/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.DeprecationData;
import io.helidon.builder.processor.TypeHandler;
import io.helidon.builder.processor.Types;
import io.helidon.common.processor.classmodel.Javadoc;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;

record AnnotationDataOption(Javadoc javadoc, boolean configured, String configKey, Boolean configMerge, AccessModifier accessModifier, boolean required, boolean validateNotNull, boolean provider, TypeName providerType, boolean providerDiscoverServices, boolean singular, String singularName, boolean sameGeneric, boolean equalityRedundant, boolean toStringRedundant, boolean confidential, List<AllowedValue> allowedValues, String defaultValue, DeprecationData deprecationData, List<Annotation> annotations) {
    private static final String UNCONFIGURED = "io.helidon.config.metadata.ConfiguredOption.UNCONFIGURED";

    static AnnotationDataOption create(TypeHandler handler, TypedElementInfo element) {
        boolean toStringRedundant;
        boolean equalityRedundant;
        String singularName;
        boolean singular;
        Annotation annotation;
        Javadoc javadoc = null;
        Boolean configured = null;
        String configKey = null;
        Boolean configMerge = null;
        Boolean required = null;
        Boolean providerBased = null;
        TypeName providerType = null;
        Boolean discoverServices = null;
        List<AllowedValue> allowedValues = null;
        List<String> defaultValues = null;
        List defaultInts = null;
        List defaultLongs = null;
        List defaultDoubles = null;
        List defaultBooleans = null;
        DefaultMethod defaultMethod = null;
        String defaultCode = null;
        if (element.hasAnnotation(Types.DESCRIPTION_TYPE)) {
            javadoc = Javadoc.parse((String)((String)element.annotation(Types.DESCRIPTION_TYPE).stringValue().orElseThrow()));
        }
        if (element.hasAnnotation(Types.OPTION_CONFIGURED_TYPE)) {
            annotation = element.annotation(Types.OPTION_CONFIGURED_TYPE);
            configured = true;
            configKey = annotation.stringValue().filter(Predicate.not(String::isBlank)).orElseGet(() -> AnnotationDataOption.toConfigKey(handler.name()));
            configMerge = annotation.booleanValue("merge").orElse(false);
        }
        AccessModifier accessModifier = element.findAnnotation(Types.OPTION_ACCESS_TYPE).flatMap(rec$ -> ((Annotation)rec$).stringValue()).map(it -> it.isBlank() ? AccessModifier.PACKAGE_PRIVATE : AccessModifier.valueOf((String)it)).orElse(AccessModifier.PUBLIC);
        if (element.hasAnnotation(Types.OPTION_REQUIRED_TYPE)) {
            required = true;
        }
        if (element.hasAnnotation(Types.OPTION_PROVIDER_TYPE)) {
            annotation = element.annotation(Types.OPTION_PROVIDER_TYPE);
            providerBased = true;
            providerType = annotation.stringValue().map(TypeName::create).orElseThrow();
            discoverServices = annotation.booleanValue("discoverServices").orElse(true);
        }
        if (element.hasAnnotation(Types.OPTION_ALLOWED_VALUES_TYPE)) {
            annotation = element.annotation(Types.OPTION_ALLOWED_VALUES_TYPE);
            allowedValues = annotation.annotationValues().orElseGet(List::of).stream().map(it -> {
                String value = (String)it.stringValue().orElseThrow();
                String description = (String)it.stringValue("description").orElseThrow();
                return new AllowedValue(value, description);
            }).toList();
        }
        if (element.hasAnnotation(Types.OPTION_SINGULAR_TYPE)) {
            singular = true;
            singularName = element.annotation(Types.OPTION_SINGULAR_TYPE).value().filter(Predicate.not(String::isBlank)).orElseGet(() -> AnnotationDataOption.singularName(handler.name()));
        } else {
            singular = false;
            singularName = null;
        }
        boolean sameGeneric = element.hasAnnotation(Types.OPTION_SAME_GENERIC_TYPE);
        if (element.hasAnnotation(Types.OPTION_REDUNDANT_TYPE)) {
            annotation = element.annotation(Types.OPTION_REDUNDANT_TYPE);
            equalityRedundant = annotation.booleanValue("equality").orElse(true);
            toStringRedundant = annotation.booleanValue("stringValue").orElse(true);
        } else {
            equalityRedundant = false;
            toStringRedundant = false;
        }
        boolean confidential = element.hasAnnotation(Types.OPTION_CONFIDENTIAL_TYPE);
        if (element.hasAnnotation(Types.OPTION_DEFAULT_TYPE)) {
            annotation = element.annotation(Types.OPTION_DEFAULT_TYPE);
            defaultValues = annotation.stringValues().orElseGet(List::of);
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_INT_TYPE)) {
            annotation = element.annotation(Types.OPTION_DEFAULT_INT_TYPE);
            defaultInts = annotation.intValues().orElseGet(List::of);
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_LONG_TYPE)) {
            annotation = element.annotation(Types.OPTION_DEFAULT_LONG_TYPE);
            defaultLongs = annotation.longValues().orElseGet(List::of);
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_DOUBLE_TYPE)) {
            annotation = element.annotation(Types.OPTION_DEFAULT_DOUBLE_TYPE);
            defaultDoubles = annotation.doubleValues().orElseGet(List::of);
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_BOOLEAN_TYPE)) {
            annotation = element.annotation(Types.OPTION_DEFAULT_BOOLEAN_TYPE);
            defaultBooleans = annotation.booleanValues().orElseGet(List::of);
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_METHOD_TYPE)) {
            annotation = element.annotation(Types.OPTION_DEFAULT_METHOD_TYPE);
            TypeName type = annotation.typeValue("type").orElse(Types.OPTION_DEFAULT_METHOD_TYPE);
            if (Types.OPTION_DEFAULT_METHOD_TYPE.equals((Object)type)) {
                type = handler.declaredType();
            }
            String name = (String)annotation.stringValue().orElseThrow();
            defaultMethod = new DefaultMethod(type, name);
        }
        if (element.hasAnnotation(Types.OPTION_DEFAULT_CODE_TYPE)) {
            defaultCode = (String)element.annotation(Types.OPTION_DEFAULT_CODE_TYPE).stringValue().orElseThrow();
        }
        if (element.hasAnnotation(Types.CONFIGURED_OPTION_TYPE)) {
            String defaultValue;
            annotation = element.annotation(Types.CONFIGURED_OPTION_TYPE);
            if (defaultValues == null && defaultBooleans == null && defaultInts == null && defaultCode == null && defaultMethod == null && defaultLongs == null && defaultDoubles == null && (defaultValue = (String)annotation.stringValue().filter(Predicate.not(UNCONFIGURED::equals)).orElse(null)) != null) {
                defaultValues = handler.declaredType().isSet() || handler.declaredType().isList() || handler.declaredType().isMap() ? List.of(defaultValue.split(",")) : List.of(defaultValue);
            }
            if (configured == null) {
                configured = annotation.getValue("notConfigured").map(Boolean::parseBoolean).orElse(false) == false;
                configKey = annotation.stringValue("key").filter(Predicate.not(String::isBlank)).orElseGet(() -> AnnotationDataOption.toConfigKey(handler.name()));
                configMerge = annotation.booleanValue("mergeWithParent").orElse(false);
            }
            if (required == null) {
                required = annotation.getValue("required").map(Boolean::parseBoolean).orElse(false);
            }
            if (providerBased == null) {
                providerBased = annotation.booleanValue("provider").orElse(false);
                if (providerBased.booleanValue()) {
                    providerType = annotation.typeValue("providerType").filter(Predicate.not(arg_0 -> ((TypeName)Types.CONFIGURED_OPTION_TYPE).equals(arg_0))).orElseThrow(() -> new IllegalArgumentException("When a @ConfiguredOption has provided=true, the providerType must be specified."));
                }
                discoverServices = annotation.booleanValue("providerDiscoverServices").orElse(true);
            }
            if (allowedValues == null) {
                allowedValues = annotation.annotationValues("allowedValues").stream().flatMap(Collection::stream).map(it -> new AllowedValue((String)it.stringValue().orElseThrow(), (String)it.stringValue("description").orElseThrow())).toList();
            }
            if (javadoc == null) {
                javadoc = annotation.stringValue("description").filter(Predicate.not(String::isBlank)).or(() -> element.description()).map(Javadoc::parse).orElseGet(() -> Javadoc.builder().addLine("Option " + handler.name()).returnDescription(handler.name()).build());
            }
        }
        String defaultValue = handler.toDefaultValue(defaultValues, defaultInts, defaultLongs, defaultDoubles, defaultBooleans, defaultCode, defaultMethod);
        TypeName genericType = handler.declaredType().genericTypeName();
        boolean validateNotNull = defaultValue == null && !genericType.equals((Object)TypeNames.OPTIONAL) && (!genericType.primitive() || genericType.array()) && !genericType.equals((Object)TypeNames.MAP) && !genericType.equals((Object)TypeNames.SET) && !genericType.equals((Object)TypeNames.LIST);
        configured = configured != null && configured != false;
        required = required != null && required != false;
        providerBased = providerBased != null && providerBased != false;
        discoverServices = discoverServices == null || discoverServices != false;
        boolean bl = validateNotNull = validateNotNull || required != false;
        if (javadoc == null) {
            javadoc = element.description().map(Javadoc::parse).orElseGet(() -> Javadoc.builder().addLine("Option " + handler.name()).returnDescription(handler.name()).build());
        }
        DeprecationData deprecationData = DeprecationData.create(element, javadoc);
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        javadoc = AnnotationDataOption.processDeprecation(deprecationData, annotations, javadoc);
        return new AnnotationDataOption(javadoc, configured, configKey, configMerge, accessModifier, required, validateNotNull, providerBased, providerType, discoverServices, singular, singularName, sameGeneric, equalityRedundant, toStringRedundant, confidential, allowedValues, defaultValue, deprecationData, annotations);
    }

    boolean hasDefault() {
        return this.defaultValue != null;
    }

    boolean hasAllowedValues() {
        return this.allowedValues != null && !this.allowedValues.isEmpty();
    }

    private static Javadoc processDeprecation(DeprecationData deprecationData, List<Annotation> annotations, Javadoc javadoc) {
        if (javadoc == null) {
            return null;
        }
        if (!deprecationData.deprecated()) {
            return javadoc;
        }
        Annotation.Builder deprecated = (Annotation.Builder)Annotation.builder().typeName(Types.DEPRECATED_TYPE);
        if (deprecationData.since() != null) {
            deprecated.putValue("since", (Object)deprecationData.since());
        }
        if (deprecationData.forRemoval()) {
            deprecated.putValue("forRemoval", (Object)true);
        }
        if (Annotations.findFirst((TypeName)Types.DEPRECATED_TYPE, annotations).isEmpty()) {
            annotations.add(deprecated.build());
        }
        if (deprecationData.alternativeOption() != null || deprecationData.description() != null) {
            Javadoc.Builder javadocBuilder = Javadoc.builder((Javadoc)javadoc);
            if (deprecationData.alternativeOption() == null) {
                javadocBuilder.deprecation(deprecationData.description());
            } else {
                javadocBuilder.deprecation("use {@link #" + deprecationData.alternativeOption() + "()} instead");
            }
            javadoc = javadocBuilder.build();
        }
        return javadoc;
    }

    private static String singularName(String optionName) {
        if (optionName.endsWith("s")) {
            return optionName.substring(0, optionName.length() - 1);
        }
        return optionName;
    }

    private static String toConfigKey(String propertyName) {
        char[] chars;
        StringBuilder result = new StringBuilder();
        for (char aChar : chars = propertyName.toCharArray()) {
            if (Character.isUpperCase(aChar)) {
                if (result.isEmpty()) {
                    result.append(Character.toLowerCase(aChar));
                    continue;
                }
                result.append('-').append(Character.toLowerCase(aChar));
                continue;
            }
            result.append(aChar);
        }
        return result.toString();
    }

    record DefaultMethod(TypeName type, String method) {
    }

    record AllowedValue(String value, String description) {
    }
}

