/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.BuilderInfoPredicates;
import io.helidon.builder.processor.MethodSignature;
import io.helidon.builder.processor.ProcessingContext;
import io.helidon.builder.processor.TypeHandler;
import io.helidon.builder.processor.Types;
import io.helidon.common.processor.ElementInfoPredicates;
import io.helidon.common.processor.GeneratorTools;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

record FactoryMethods(Optional<FactoryMethod> createTargetType, Optional<FactoryMethod> createFromConfig, Optional<FactoryMethod> builder) {
    static FactoryMethods create(ProcessingContext processingContext, TypeInfo blueprint, TypeHandler typeHandler) {
        Optional<FactoryMethod> targetFactory = FactoryMethods.targetTypeMethod(processingContext, blueprint, typeHandler);
        LinkedHashSet<Object> configObjectCandidates = new LinkedHashSet<TypeName>();
        if (targetFactory.isPresent()) {
            configObjectCandidates.add(targetFactory.get().argumentType());
        }
        configObjectCandidates.add(typeHandler.actualType());
        configObjectCandidates.add(typeHandler.declaredType());
        Optional<FactoryMethod> configFactory = FactoryMethods.createFromConfigMethod(processingContext, blueprint, typeHandler, configObjectCandidates);
        configObjectCandidates = new LinkedHashSet();
        if (targetFactory.isPresent()) {
            configObjectCandidates.add(targetFactory.get().argumentType());
        }
        if (configFactory.isPresent()) {
            configObjectCandidates.add(configFactory.get().factoryMethodReturnType());
        }
        return new FactoryMethods(targetFactory, configFactory, FactoryMethods.builder(processingContext, typeHandler, configObjectCandidates));
    }

    private static Optional<FactoryMethod> builder(ProcessingContext processingContext, TypeHandler typeHandler, Set<TypeName> builderCandidates) {
        if (typeHandler.actualType().equals((Object)TypeNames.OBJECT)) {
            return Optional.empty();
        }
        builderCandidates.add(typeHandler.actualType());
        FactoryMethod found = null;
        FactoryMethod secondary = null;
        for (TypeName builderCandidate : builderCandidates) {
            if (typeHandler.actualType().primitive()) continue;
            TypeInfo typeInfo = processingContext.toTypeInfo(builderCandidate.genericTypeName()).orElse(null);
            if (typeInfo == null) {
                if (secondary != null || builderCandidate.fqName().endsWith(".Builder")) continue;
                TypeName builderTypeName = ((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)builderCandidate).className("Builder")).enclosingNames(List.of(builderCandidate.className()))).typeArguments(builderCandidate.typeArguments())).build();
                secondary = new FactoryMethod(builderCandidate, builderTypeName, "builder", null);
                continue;
            }
            found = typeInfo.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates::isStatic).filter(ElementInfoPredicates.elementName((String)"builder")).filter(ElementInfoPredicates::hasNoArgs).findFirst().map(it -> new FactoryMethod(builderCandidate, it.typeName(), "builder", null)).orElse(null);
            if (found == null) continue;
            break;
        }
        FactoryMethod secondaryMethod = secondary;
        return Optional.ofNullable(found).or(() -> Optional.ofNullable(secondaryMethod));
    }

    private static Optional<FactoryMethod> createFromConfigMethod(ProcessingContext processingContext, TypeInfo blueprint, TypeHandler typeHandler, Set<TypeName> configObjectCandidates) {
        TypeName candidateTypeName;
        Optional<FactoryMethod> foundMethod;
        String methodName = "create" + GeneratorTools.capitalize((String)typeHandler.name());
        Optional<TypeName> returnType = FactoryMethods.findFactoryMethodByParamType(blueprint, Types.CONFIG_TYPE, methodName);
        if (returnType.isPresent()) {
            TypeName typeWithFactoryMethod = blueprint.typeName();
            return Optional.of(new FactoryMethod(typeWithFactoryMethod, returnType.get(), methodName, Types.CONFIG_TYPE));
        }
        String createMethod = "create";
        List candidates = configObjectCandidates.stream().map(processingContext::toTypeInfo).flatMap(Optional::stream).toList();
        for (TypeInfo typeInfo : candidates) {
            Optional<FactoryMethod> foundMethod2;
            if (!FactoryMethods.doesImplement(typeInfo, Types.PROTOTYPE_TYPE) || !(foundMethod2 = BuilderInfoPredicates.findMethod(new MethodSignature(typeInfo.typeName(), createMethod, List.of(Types.CONFIG_TYPE)), Set.of(Modifier.STATIC), typeInfo).map(it -> new FactoryMethod(typeInfo.typeName(), typeInfo.typeName(), createMethod, Types.CONFIG_TYPE))).isPresent()) continue;
            return foundMethod2;
        }
        for (TypeInfo typeInfo : candidates) {
            if (!FactoryMethods.doesImplement(typeInfo, Types.RUNTIME_OBJECT_TYPE) || !(foundMethod = BuilderInfoPredicates.findMethod(new MethodSignature(candidateTypeName = typeInfo.typeName(), createMethod, List.of(Types.CONFIG_TYPE)), Set.of(Modifier.STATIC), typeInfo).map(it -> new FactoryMethod(candidateTypeName, candidateTypeName, createMethod, Types.CONFIG_TYPE))).isPresent()) continue;
            return foundMethod;
        }
        for (TypeInfo typeInfo : candidates) {
            candidateTypeName = typeInfo.typeName();
            foundMethod = BuilderInfoPredicates.findMethod(new MethodSignature(candidateTypeName, createMethod, List.of(Types.CONFIG_TYPE)), Set.of(Modifier.STATIC), typeInfo).filter(ElementInfoPredicates::isPublic).map(it -> new FactoryMethod(candidateTypeName, candidateTypeName, createMethod, Types.CONFIG_TYPE));
            if (!foundMethod.isPresent()) continue;
            return foundMethod;
        }
        for (TypeName configObjectCandidate : configObjectCandidates) {
            if (!configObjectCandidate.packageName().isEmpty()) continue;
            return Optional.of(new FactoryMethod(configObjectCandidate, configObjectCandidate, "create", Types.CONFIG_TYPE));
        }
        return Optional.empty();
    }

    private static boolean doesImplement(TypeInfo typeInfo, TypeName interfaceType) {
        return typeInfo.interfaceTypeInfo().stream().anyMatch(it -> interfaceType.equals((Object)it.typeName().genericTypeName()));
    }

    private static Optional<FactoryMethod> targetTypeMethod(ProcessingContext processingContext, TypeInfo blueprint, TypeHandler typeHandler) {
        Object createMethodName = "create" + GeneratorTools.capitalize((String)typeHandler.name());
        TypeName typeWithFactoryMethod = blueprint.typeName();
        TypeName factoryMethodReturnType = typeHandler.declaredType();
        Optional<TypeName> argumentType = FactoryMethods.findFactoryMethodByReturnType(blueprint, factoryMethodReturnType, (String)createMethodName);
        if (argumentType.isPresent()) {
            return Optional.of(new FactoryMethod(typeWithFactoryMethod, factoryMethodReturnType, (String)createMethodName, argumentType.get()));
        }
        factoryMethodReturnType = typeHandler.actualType();
        argumentType = FactoryMethods.findFactoryMethodByReturnType(blueprint, factoryMethodReturnType, (String)createMethodName);
        if (argumentType.isPresent()) {
            return Optional.of(new FactoryMethod(typeWithFactoryMethod, factoryMethodReturnType, (String)createMethodName, argumentType.get()));
        }
        Optional configuredTypeInterface = processingContext.toTypeInfo(typeHandler.actualType()).flatMap(it -> it.interfaceTypeInfo().stream().filter(typeInfo -> Types.RUNTIME_OBJECT_TYPE.equals((Object)typeInfo.typeName().genericTypeName())).findFirst());
        createMethodName = "create";
        if (configuredTypeInterface.isPresent()) {
            typeWithFactoryMethod = factoryMethodReturnType = typeHandler.actualType();
            argumentType = Optional.of((TypeName)((TypeInfo)configuredTypeInterface.get()).typeName().typeArguments().get(0));
            return Optional.of(new FactoryMethod(typeWithFactoryMethod, factoryMethodReturnType, (String)createMethodName, argumentType.get()));
        }
        return Optional.empty();
    }

    private static Optional<TypeName> findFactoryMethodByReturnType(TypeInfo declaringType, TypeName returnType, String methodName) {
        return declaringType.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates::isStatic).filter(it -> it.hasAnnotation(Types.FACTORY_METHOD_TYPE)).filter(it -> methodName.equals(it.elementName())).filter(it -> it.typeName().equals((Object)returnType)).filter(it -> it.parameterArguments().size() == 1).map(it -> (TypedElementInfo)it.parameterArguments().get(0)).map(rec$ -> ((TypedElementInfo)rec$).typeName()).findFirst();
    }

    private static Optional<TypeName> findFactoryMethodByParamType(TypeInfo declaringType, TypeName paramType, String methodName) {
        return declaringType.elementInfo().stream().filter(ElementInfoPredicates::isMethod).filter(ElementInfoPredicates::isStatic).filter(ElementInfoPredicates.hasAnnotation((TypeName)Types.FACTORY_METHOD_TYPE)).filter(ElementInfoPredicates.elementName((String)methodName)).filter(ElementInfoPredicates.hasParams((TypeName[])new TypeName[]{paramType})).map(rec$ -> ((TypedElementInfo)rec$).typeName()).findFirst();
    }

    record FactoryMethod(TypeName typeWithFactoryMethod, TypeName factoryMethodReturnType, String createMethodName, TypeName argumentType) {
    }
}

