/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.TypeInfoPredicates;
import io.helidon.builder.processor.Types;
import io.helidon.common.Errors;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

abstract class ValidationTask {
    ValidationTask() {
    }

    abstract void validate(Errors.Collector var1);

    private static void validateImplements(Errors.Collector errors, TypeInfo validatedType, TypeName implementedInterface, String message) {
        if (validatedType.interfaceTypeInfo().stream().noneMatch(it -> it.typeName().equals((Object)implementedInterface))) {
            errors.fatal(message);
        }
    }

    private static void validateFactoryMethod(Errors.Collector errors, TypeInfo validatedType, TypeName returnType, String methodName, TypeName argument, String message) {
        if (validatedType.elementInfo().stream().filter(TypeInfoPredicates::isMethod).filter(TypeInfoPredicates::isStatic).filter(TypeInfoPredicates.methodName(methodName)).filter(it -> returnType.equals((Object)it.typeName())).filter(it -> {
            List args = it.parameterArguments();
            if (argument == null) {
                return args.isEmpty();
            }
            if (args.size() != 1) {
                return false;
            }
            TypedElementInfo typedElementInfo = (TypedElementInfo)args.get(0);
            return argument.equals((Object)typedElementInfo.typeName());
        }).findFirst().isEmpty()) {
            errors.fatal((Object)validatedType.typeName().fqName(), message);
        }
    }

    private static class ValidateBuilderMethod
    extends ValidationTask {
        private final TypeName configObjectType;
        private final TypeInfo runtimeTypeInfo;
        private final TypeName configObjectBuilder;

        ValidateBuilderMethod(TypeName configObjectType, TypeInfo runtimeTypeInfo, TypeName configObjectBuilder) {
            this.configObjectType = configObjectType;
            this.runtimeTypeInfo = runtimeTypeInfo;
            this.configObjectBuilder = configObjectBuilder;
        }

        @Override
        public void validate(Errors.Collector errors) {
            ValidationTask.validateFactoryMethod(errors, this.runtimeTypeInfo, this.configObjectBuilder, "builder", null, "As " + this.configObjectType.fqName() + " implements " + Types.PROTOTYPE_FACTORY_TYPE.classNameWithEnclosingNames() + "<" + this.runtimeTypeInfo.typeName().fqName() + ">, the runtime type must implement the following method:\nstatic " + this.configObjectType.className() + ".Builder builder() {\n  return " + this.configObjectType.className() + ".builder();\n}");
        }
    }

    private static class ValidateCreateWithConsumerMethod
    extends ValidationTask {
        private final TypeName configObjectType;
        private final TypeInfo runtimeTypeInfo;

        ValidateCreateWithConsumerMethod(TypeName configObjectType, TypeInfo runtimeTypeInfo) {
            this.configObjectType = configObjectType;
            this.runtimeTypeInfo = runtimeTypeInfo;
        }

        @Override
        public void validate(Errors.Collector errors) {
            TypeName consumerArgument = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(TypeName.create((String)(this.configObjectType.fqName() + ".Builder")))).build();
            ValidationTask.validateFactoryMethod(errors, this.runtimeTypeInfo, this.runtimeTypeInfo.typeName(), "create", consumerArgument, "As " + this.configObjectType.fqName() + " implements " + Types.PROTOTYPE_FACTORY_TYPE.classNameWithEnclosingNames() + "<" + this.runtimeTypeInfo.typeName().fqName() + ">, the type " + this.runtimeTypeInfo.typeName().className() + " must implement the following method:\nstatic " + this.runtimeTypeInfo.typeName().className() + " create(" + consumerArgument.fqName() + " consumer) {\n  var builder = " + this.configObjectType.className() + ".builder();\n  consumer.accept(builder);  return builder.build();}");
        }
    }

    private static class ValidateCreateMethod
    extends ValidationTask {
        private final TypeName configObjectType;
        private final TypeInfo runtimeTypeInfo;

        ValidateCreateMethod(TypeName configObjectType, TypeInfo runtimeTypeInfo) {
            this.configObjectType = configObjectType;
            this.runtimeTypeInfo = runtimeTypeInfo;
        }

        @Override
        public void validate(Errors.Collector errors) {
            String fqName = this.runtimeTypeInfo.typeName().genericTypeName().fqName();
            ValidationTask.validateFactoryMethod(errors, this.runtimeTypeInfo, this.runtimeTypeInfo.typeName(), "create", this.configObjectType, "As " + fqName + " is annotated with @" + Types.RUNTIME_PROTOTYPE_TYPE.classNameWithEnclosingNames() + "(" + this.configObjectType.className() + "), the type must implement the following method:\nstatic " + this.runtimeTypeInfo.typeName().classNameWithTypes() + " create(" + this.configObjectType.classNameWithTypes() + ");");
        }
    }

    private static class ValidateAnnotatedWith
    extends ValidationTask {
        private final TypeInfo typeInfo;
        private final TypeName annotation;
        private final String expectedValue;

        ValidateAnnotatedWith(TypeInfo typeInfo, TypeName annotation, String expectedValue) {
            this.typeInfo = typeInfo;
            this.annotation = annotation;
            this.expectedValue = expectedValue;
        }

        @Override
        void validate(Errors.Collector errors) {
            if (this.typeInfo.findAnnotation(this.annotation).stream().noneMatch(it -> it.value().map(this.expectedValue::equals).orElse(false))) {
                errors.fatal("Type " + this.typeInfo.typeName().fqName() + " must be annotated with " + this.annotation.fqName() + "(" + this.expectedValue + ")");
            }
        }
    }

    static class ValidateBlueprintExtendsFactory
    extends ValidationTask {
        private final List<ValidationTask> nestedValidators;
        private final TypeName configObjectType;
        private final TypeInfo blueprintInfo;
        private final TypeInfo runtimeTypeInfo;

        ValidateBlueprintExtendsFactory(TypeName configObjectType, TypeInfo blueprintInfo, TypeInfo runtimeTypeInfo) {
            this.configObjectType = configObjectType;
            this.blueprintInfo = blueprintInfo;
            this.runtimeTypeInfo = runtimeTypeInfo;
            TypeName configObjectBuilder = ((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().packageName(configObjectType.packageName())).enclosingNames(List.of(configObjectType.className()))).className("Builder")).build();
            this.nestedValidators = List.of(new ValidateBuilderMethod(configObjectType, runtimeTypeInfo, configObjectBuilder), new ValidateAnnotatedWith(runtimeTypeInfo, Types.RUNTIME_PROTOTYPE_TYPE, configObjectType.genericTypeName().fqName()));
        }

        @Override
        public void validate(Errors.Collector errors) {
            ValidationTask.validateImplements(errors, this.runtimeTypeInfo, ((TypeName.Builder)TypeName.builder((TypeName)Types.RUNTIME_OBJECT_TYPE).addTypeArgument(this.configObjectType.boxed())).build(), "As " + this.blueprintInfo.typeName().fqName() + " implements " + Types.PROTOTYPE_FACTORY_TYPE.classNameWithEnclosingNames() + "<" + this.runtimeTypeInfo.typeName().fqName() + ">, the runtime type must implement(or extend) interface " + Types.RUNTIME_OBJECT_TYPE.fqName() + "<" + this.configObjectType.className() + ">");
            for (ValidationTask nestedValidator : this.nestedValidators) {
                nestedValidator.validate(errors);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidateBlueprintExtendsFactory that = (ValidateBlueprintExtendsFactory)o;
            return Objects.equals(this.blueprintInfo, that.blueprintInfo) && Objects.equals(this.runtimeTypeInfo, that.runtimeTypeInfo);
        }

        public int hashCode() {
            return Objects.hash(this.blueprintInfo, this.runtimeTypeInfo);
        }
    }

    static class ValidateBlueprint
    extends ValidationTask {
        private final TypeInfo blueprint;

        ValidateBlueprint(TypeInfo blueprint) {
            this.blueprint = blueprint;
        }

        @Override
        public void validate(Errors.Collector errors) {
            if (this.blueprint.modifiers().contains("public")) {
                errors.fatal(this.blueprint.typeName().fqName() + " is defined as public, it must be package local");
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidateBlueprint that = (ValidateBlueprint)o;
            return Objects.equals(this.blueprint.typeName(), that.blueprint.typeName());
        }

        public int hashCode() {
            return Objects.hash(this.blueprint.typeName());
        }
    }

    private static class ValidateImplements
    extends ValidationTask {
        private final TypeInfo typeInfo;
        private final TypeName requiredInterface;
        private final String message;

        ValidateImplements(TypeInfo typeInfo, TypeName requiredInterface, String message) {
            this.typeInfo = typeInfo;
            this.requiredInterface = requiredInterface;
            this.message = message;
        }

        @Override
        void validate(Errors.Collector errors) {
            ValidationTask.validateImplements(errors, this.typeInfo, this.requiredInterface, this.message);
        }
    }

    static class ValidateConfiguredType
    extends ValidationTask {
        private final TypeInfo runtimeTypeInfo;
        private final List<ValidationTask> nestedValidators;

        ValidateConfiguredType(TypeInfo runtimeTypeInfo, TypeName configObjectType) {
            this.runtimeTypeInfo = runtimeTypeInfo;
            TypeName configObjectWithTypeParams = ((TypeName.Builder)TypeName.builder((TypeName)configObjectType).typeArguments(runtimeTypeInfo.typeName().typeArguments())).build();
            TypeName configuredTypeInterface = ((TypeName.Builder)TypeName.builder((TypeName)Types.RUNTIME_OBJECT_TYPE).addTypeArgument(configObjectType)).build();
            this.nestedValidators = List.of(new ValidateCreateMethod(configObjectWithTypeParams, runtimeTypeInfo), new ValidateCreateWithConsumerMethod(configObjectWithTypeParams, runtimeTypeInfo), new ValidateImplements(runtimeTypeInfo, configuredTypeInterface, "Type annotated with @" + Types.RUNTIME_PROTOTYPE_TYPE.classNameWithEnclosingNames() + "(" + configObjectType.className() + ".class) must implement " + Types.RUNTIME_OBJECT_TYPE.classNameWithEnclosingNames() + "<" + configObjectWithTypeParams.classNameWithTypes() + ">"));
        }

        @Override
        public void validate(Errors.Collector errors) {
            for (ValidationTask nestedValidator : this.nestedValidators) {
                nestedValidator.validate(errors);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ValidateConfiguredType that = (ValidateConfiguredType)o;
            return Objects.equals(this.runtimeTypeInfo, that.runtimeTypeInfo);
        }

        public int hashCode() {
            return Objects.hash(this.runtimeTypeInfo);
        }
    }
}

