/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.MethodSignature;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;

final class TypeInfoPredicates {
    private TypeInfoPredicates() {
    }

    static boolean isMethod(TypedElementInfo element) {
        return "METHOD".equals(element.elementTypeKind());
    }

    static boolean isStatic(TypedElementInfo element) {
        return element.modifiers().contains("static");
    }

    static boolean isPrivate(TypedElementInfo element) {
        return element.modifiers().contains("private");
    }

    static boolean isDefault(TypedElementInfo element) {
        return element.modifiers().contains("default");
    }

    static boolean hasNoArgs(TypedElementInfo element) {
        return element.parameterArguments().isEmpty();
    }

    static Predicate<TypedElementInfo> hasAnnotation(TypeName annotation) {
        return element -> element.hasAnnotation(annotation);
    }

    static Predicate<TypedElementInfo> methodName(String methodName) {
        return element -> methodName.equals(element.elementName());
    }

    static Predicate<TypedElementInfo> hasParams(TypeName ... paramTypes) {
        return element -> {
            List arguments = element.parameterArguments();
            if (paramTypes.length != arguments.size()) {
                return false;
            }
            for (int i = 0; i < paramTypes.length; ++i) {
                TypeName paramType = paramTypes[i];
                if (paramType.equals((Object)((TypedElementInfo)arguments.get(i)).typeName())) continue;
                return false;
            }
            return true;
        };
    }

    static Predicate<? super TypedElementInfo> ignoredMethod(Set<MethodSignature> ignoredMethods, Set<String> ignoredNames) {
        return it -> {
            if (ignoredNames.contains(it.elementName())) {
                return true;
            }
            return ignoredMethods.contains(MethodSignature.create(it));
        };
    }

    static Optional<TypedElementInfo> findMethod(MethodSignature signatureFilter, Set<String> expectedModifiers, TypeInfo typeInfo) {
        return typeInfo.elementInfo().stream().filter(TypeInfoPredicates::isMethod).filter(it -> {
            Set modifiers = it.modifiers();
            if (expectedModifiers != null) {
                for (String expectedModifier : expectedModifiers) {
                    if (modifiers.contains(expectedModifier)) continue;
                    return false;
                }
            }
            return true;
        }).filter(it -> {
            if (signatureFilter.returnType() != null && !it.typeName().equals((Object)signatureFilter.returnType())) {
                return false;
            }
            if (signatureFilter.name() != null && !it.elementName().equals(signatureFilter.name())) {
                return false;
            }
            List<TypeName> expectedArguments = signatureFilter.arguments();
            if (expectedArguments != null) {
                List actualArguments = it.parameterArguments();
                if (actualArguments.size() != expectedArguments.size()) {
                    return false;
                }
                for (int i = 0; i < expectedArguments.size(); ++i) {
                    TypeName actualArgument;
                    TypeName expected = expectedArguments.get(i);
                    if (expected.equals((Object)(actualArgument = ((TypedElementInfo)actualArguments.get(i)).typeName()))) continue;
                    return false;
                }
            }
            return true;
        }).findFirst();
    }
}

