/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.FactoryMethods;
import io.helidon.builder.processor.GeneratedMethod;
import io.helidon.builder.processor.Javadoc;
import io.helidon.builder.processor.PrototypeProperty;
import io.helidon.builder.processor.TypeHandler;
import io.helidon.builder.processor.Types;
import io.helidon.common.processor.GeneratorTools;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

class TypeHandlerOptional
extends TypeHandler.OneTypeHandler {
    TypeHandlerOptional(String name, String getterName, String setterName, TypeName declaredType) {
        super(name, getterName, setterName, declaredType);
    }

    @Override
    String generateBuilderGetter() {
        return "Optional.ofNullable(" + this.name() + ")";
    }

    @Override
    String fieldDeclaration(PrototypeProperty.ConfiguredOption configured, boolean isBuilder, boolean alwaysFinal) {
        TypeName usedType;
        StringBuilder fieldDeclaration = new StringBuilder("private ");
        TypeName typeName = usedType = isBuilder ? this.actualType() : this.declaredType();
        if (alwaysFinal || !isBuilder) {
            fieldDeclaration.append("final ");
        }
        if (isBuilder && (configured.required() || !configured.hasDefault())) {
            fieldDeclaration.append(usedType.boxed().fqName());
        } else {
            fieldDeclaration.append(usedType.fqName());
        }
        fieldDeclaration.append(" ").append(this.name());
        if (isBuilder && configured.hasDefault()) {
            fieldDeclaration.append(" = ").append(configured.defaultValue());
        }
        return fieldDeclaration.toString();
    }

    @Override
    TypeName argumentTypeName() {
        return TypeName.builder((TypeName)TypeNames.OPTIONAL).addTypeArgument(TypeHandlerOptional.toWildcard(this.actualType()));
    }

    @Override
    void setters(PrototypeProperty.ConfiguredOption configured, PrototypeProperty.Singular singular, List<GeneratedMethod> setters, FactoryMethods factoryMethod, TypeName returnType, Javadoc blueprintJavadoc) {
        ArrayList<String> lines;
        Javadoc javadoc;
        Object argumentName;
        FactoryMethods.FactoryMethod fm;
        this.declaredSetter(setters, returnType, blueprintJavadoc);
        this.clearSetter(setters, returnType, configured);
        if (!this.actualType().equals((Object)Types.CONFIG_TYPE)) {
            ArrayList<String> lines2 = new ArrayList<String>();
            lines2.add("Objects.requireNonNull(" + this.name() + ");");
            lines2.addAll(TypeHandlerOptional.resolveBuilderLines(this.actualType(), this.name()));
            lines2.add("this." + this.name() + " = " + this.name() + ";");
            lines2.add("return self();");
            Javadoc javadoc2 = new Javadoc(blueprintJavadoc.lines(), List.of(new Javadoc.Tag(this.name(), blueprintJavadoc.returns())), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
            setters.add(new GeneratedMethod(Set.of(TypeHandlerOptional.setterModifier(configured).trim()), this.setterName(), returnType, List.of(new GeneratedMethod.Argument(this.name(), this.actualType())), List.of(), javadoc2, lines2));
        }
        if (this.actualType().equals((Object)Types.CHAR_ARRAY_TYPE)) {
            this.charArraySetter(configured, setters, returnType, blueprintJavadoc);
        }
        if (factoryMethod.createTargetType().isPresent()) {
            fm = factoryMethod.createTargetType().get();
            String optionalSuffix = this.optionalSuffix(fm.factoryMethodReturnType());
            argumentName = this.name() + "Config";
            javadoc = new Javadoc(blueprintJavadoc.lines(), List.of(new Javadoc.Tag((String)argumentName, blueprintJavadoc.returns())), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
            lines = new ArrayList<String>();
            lines.add("Objects.requireNonNull(" + (String)argumentName + ");");
            lines.add("this." + this.name() + " = " + fm.typeWithFactoryMethod().genericTypeName().fqName() + "." + fm.createMethodName() + "(" + (String)argumentName + ")" + optionalSuffix + ";");
            lines.add("return self();");
            setters.add(new GeneratedMethod(Set.of(TypeHandlerOptional.setterModifier(configured).trim()), this.setterName(), returnType, List.of(new GeneratedMethod.Argument((String)argumentName, fm.argumentType())), List.of(), javadoc, lines));
        }
        if (factoryMethod.builder().isPresent()) {
            fm = factoryMethod.builder().get();
            TypeName builderType = fm.factoryMethodReturnType().className().equals("Builder") ? fm.factoryMethodReturnType() : TypeName.create((String)(fm.factoryMethodReturnType().fqName() + ".Builder"));
            argumentName = "consumer";
            javadoc = new Javadoc(blueprintJavadoc.lines(), List.of(new Javadoc.Tag((String)argumentName, blueprintJavadoc.returns())), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
            lines = new ArrayList();
            lines.add("Objects.requireNonNull(" + (String)argumentName + ");");
            lines.add("var builder = " + fm.typeWithFactoryMethod().genericTypeName().fqName() + "." + fm.createMethodName() + "();");
            lines.add("consumer.accept(builder);");
            lines.add("this." + this.name() + "(builder.build());");
            lines.add("return self();");
            TypeName argumentType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(builderType)).build();
            setters.add(new GeneratedMethod(Set.of(TypeHandlerOptional.setterModifier(configured).trim()), this.setterName(), returnType, List.of(new GeneratedMethod.Argument((String)argumentName, argumentType)), List.of(), javadoc, lines));
        }
    }

    private void declaredSetter(List<GeneratedMethod> setters, TypeName returnType, Javadoc blueprintJavadoc) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Objects.requireNonNull(" + this.name() + ");");
        lines.add("this." + this.name() + " = " + this.name() + ".orElse(null);");
        lines.add("return self();");
        Javadoc javadoc = new Javadoc(blueprintJavadoc.lines(), List.of(new Javadoc.Tag(this.name(), blueprintJavadoc.returns())), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
        setters.add(new GeneratedMethod(Set.of(), this.setterName(), returnType, List.of(new GeneratedMethod.Argument(this.name(), this.argumentTypeName())), List.of(), javadoc, lines));
    }

    private void clearSetter(List<GeneratedMethod> setters, TypeName returnType, PrototypeProperty.ConfiguredOption configured) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("this." + this.name() + " = null;");
        lines.add("return self();");
        Javadoc javadoc = new Javadoc(List.of("Clear existing value of this property."), List.of(), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
        setters.add(new GeneratedMethod(Set.of(TypeHandlerOptional.setterModifier(configured)), "clear" + GeneratorTools.capitalize((String)this.name()), returnType, List.of(), List.of(), javadoc, lines));
    }

    private String optionalSuffix(TypeName typeName) {
        if (TypeNames.OPTIONAL.equals((Object)typeName.genericTypeName())) {
            return ".orElse(null)";
        }
        return "";
    }
}

