/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.FactoryMethods;
import io.helidon.builder.processor.GeneratedMethod;
import io.helidon.builder.processor.Javadoc;
import io.helidon.builder.processor.PrototypeProperty;
import io.helidon.builder.processor.TypeHandler;
import io.helidon.builder.processor.Types;
import io.helidon.common.processor.GeneratorTools;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

class TypeHandlerMap
extends TypeHandler {
    private static final TypeName SAME_GENERIC_TYPE = TypeName.createFromGenericDeclaration((String)"TYPE");
    private final TypeName actualType;
    private final String implTypeName;
    private final boolean sameGeneric;

    TypeHandlerMap(String name, String getterName, String setterName, TypeName declaredType, boolean sameGeneric) {
        super(name, getterName, setterName, declaredType);
        this.sameGeneric = sameGeneric;
        this.implTypeName = TypeHandlerMap.collectionImplType(TypeNames.MAP);
        this.actualType = declaredType.typeArguments().size() < 2 ? Types.STRING_TYPE : (TypeName)declaredType.typeArguments().get(1);
    }

    @Override
    String fieldDeclaration(PrototypeProperty.ConfiguredOption configured, boolean isBuilder, boolean alwaysFinal) {
        return super.fieldDeclaration(configured, isBuilder, true) + (String)(isBuilder && !configured.hasDefault() ? " = new " + this.implTypeName + "<>()" : "");
    }

    @Override
    String toDefaultValue(String defaultValue) {
        CharSequence[] defaults = defaultValue.split(",");
        if (defaults.length % 2 != 0) {
            throw new IllegalArgumentException("Default value for a map does not have even number of entries:" + defaultValue);
        }
        for (int i = 1; i < defaults.length; i += 2) {
            defaults[i] = super.toDefaultValue(defaultValue);
        }
        return "java.util.Map.of(" + String.join((CharSequence)", ", defaults) + ")";
    }

    @Override
    TypeName actualType() {
        return this.actualType;
    }

    @Override
    Optional<String> generateFromConfig(PrototypeProperty.ConfiguredOption configured, FactoryMethods factoryMethods) {
        if (Types.STRING_TYPE.equals((Object)this.actualType)) {
            return Optional.of("config.get(\"" + configured.configKey() + "\").asMap().ifPresent(this::" + this.setterName() + ");");
        }
        return Optional.of("config.get(\"" + configured.configKey() + "\").asNodeList().ifPresent(nodes -> nodes.forEach(node -> " + this.name() + ".put(node.get(\"name\").asString().orElse(node.name()), node" + this.generateFromConfig(factoryMethods) + ".get())));");
    }

    @Override
    TypeName argumentTypeName() {
        return ((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)TypeNames.MAP).addTypeArgument(TypeHandlerMap.toWildcard((TypeName)this.declaredType().typeArguments().get(0)))).addTypeArgument(TypeHandlerMap.toWildcard((TypeName)this.declaredType().typeArguments().get(1)))).build();
    }

    @Override
    void setters(PrototypeProperty.ConfiguredOption configured, PrototypeProperty.Singular singular, List<GeneratedMethod> setters, FactoryMethods factoryMethod, TypeName returnType, Javadoc blueprintJavadoc) {
        String singularName;
        this.declaredSetter(configured, setters, returnType, blueprintJavadoc);
        this.declaredSetterAdd(configured, setters, returnType, blueprintJavadoc);
        if (factoryMethod.createTargetType().isPresent()) {
            FactoryMethods.FactoryMethod fm = factoryMethod.createTargetType().get();
            String argumentName = this.name() + "Config";
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("Objects.requireNonNull(" + argumentName + ");");
            lines.add("this." + this.name() + ".clear();");
            lines.add("this." + this.name() + ".putAll(" + fm.typeWithFactoryMethod().genericTypeName().fqName() + "." + fm.createMethodName() + "(" + argumentName + "));");
            lines.add("return self();");
            ArrayList<String> docLines = new ArrayList<String>(blueprintJavadoc.lines());
            docLines.add("This method keeps existing values, then puts all new values into the map.");
            Javadoc javadoc = new Javadoc(docLines, List.of(new Javadoc.Tag(this.name(), blueprintJavadoc.returns())), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
            setters.add(new GeneratedMethod(Set.of(TypeHandlerMap.setterModifier(configured).trim()), null, this.setterName(), returnType, List.of(new GeneratedMethod.Argument(argumentName, fm.argumentType())), List.of(), javadoc, lines));
        }
        TypeName keyType = (TypeName)this.declaredType().typeArguments().get(0);
        if (singular.hasSingular() && this.isCollection(this.actualType())) {
            singularName = singular.singularName();
            setters.add(this.setterAddValueToCollection(configured, "add" + GeneratorTools.capitalize((String)singularName), singularName, keyType, (TypeName)this.actualType().typeArguments().get(0), returnType, blueprintJavadoc));
            setters.add(this.setterAddValuesToCollection(configured, "add" + GeneratorTools.capitalize((String)this.name()), keyType, returnType, blueprintJavadoc));
        }
        if (singular.hasSingular()) {
            List<GeneratedMethod.Argument> args;
            singularName = singular.singularName();
            String methodName = "put" + GeneratorTools.capitalize((String)singularName);
            String typeDeclaration = null;
            if (this.sameGeneric) {
                SameGenericArgs sameGenArgs = this.sameGenericArgs("key", keyType, singularName, this.actualType());
                typeDeclaration = sameGenArgs.typeDeclaration();
                args = sameGenArgs.arguments();
            } else {
                args = List.of(new GeneratedMethod.Argument("key", keyType), new GeneratedMethod.Argument(singularName, this.actualType()));
            }
            ArrayList<Javadoc.Tag> docParamTags = new ArrayList<Javadoc.Tag>();
            docParamTags.add(new Javadoc.Tag("key", List.of("key to add or replace")));
            docParamTags.add(new Javadoc.Tag(singularName, List.of("new value for the key")));
            if (this.sameGeneric) {
                docParamTags.add(new Javadoc.Tag("<TYPE>", List.of("Type to correctly map key and value")));
            }
            ArrayList<String> docLines = new ArrayList<String>(blueprintJavadoc.lines());
            docLines.add("This method adds a new value to the map, or replaces it if the key already exists.");
            Javadoc javadoc = new Javadoc(docLines, docParamTags, List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("Objects.requireNonNull(key);");
            lines.add("Objects.requireNonNull(" + singularName + ");");
            lines.addAll(TypeHandlerMap.resolveBuilderLines(this.actualType(), singularName));
            lines.add("this." + this.name() + ".put(key, " + this.secondArgToPut(this.actualType(), singularName) + ");");
            lines.add("return self();");
            setters.add(new GeneratedMethod(Set.of(TypeHandlerMap.setterModifier(configured).trim()), typeDeclaration, methodName, returnType, args, List.of(), javadoc, lines));
            if (factoryMethod.builder().isPresent()) {
                FactoryMethods.FactoryMethod fm = factoryMethod.builder().get();
                TypeName builderType = fm.factoryMethodReturnType().className().equals("Builder") ? fm.factoryMethodReturnType() : TypeName.create((String)(fm.factoryMethodReturnType().fqName() + ".Builder"));
                GeneratedMethod.Argument keyArg = new GeneratedMethod.Argument("key", keyType);
                GeneratedMethod.Argument valArg = new GeneratedMethod.Argument("consumer", ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(builderType)).build());
                docLines = new ArrayList<String>(blueprintJavadoc.lines());
                docLines.add("This method adds a new value to the map, or replaces it if the key already exists.");
                javadoc = new Javadoc(docLines, List.of(new Javadoc.Tag("key", List.of("key to add or replace")), new Javadoc.Tag("consumer", List.of("builder consumer to create new value for the key"))), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
                lines = new ArrayList();
                lines.add("Objects.requireNonNull(key);");
                lines.add("Objects.requireNonNull(consumer);");
                lines.add("var builder = " + fm.typeWithFactoryMethod().genericTypeName().fqName() + "." + fm.createMethodName() + "();");
                lines.add("consumer.accept(builder);");
                lines.add("this." + methodName + "(key, builder.build());");
                lines.add("return self();");
                setters.add(new GeneratedMethod(Set.of(TypeHandlerMap.setterModifier(configured).trim()), null, methodName, returnType, List.of(keyArg, valArg), List.of(), javadoc, lines));
            }
        }
    }

    private SameGenericArgs sameGenericArgs(String key, TypeName keyType, String value, TypeName valueType) {
        TypeName resolvedValueType;
        TypeName resolvedKeyType;
        TypeName genericTypeBase;
        if (keyType.typeArguments().isEmpty()) {
            genericTypeBase = keyType;
            resolvedKeyType = SAME_GENERIC_TYPE;
        } else if (keyType.typeArguments().size() == 1) {
            TypeName typeArg = (TypeName)keyType.typeArguments().get(0);
            genericTypeBase = typeArg.wildcard() ? (typeArg.generic() ? TypeNames.OBJECT : ((TypeName.Builder)TypeName.builder((TypeName)typeArg).wildcard(false)).build()) : typeArg;
            resolvedKeyType = ((TypeName.Builder)TypeName.builder((TypeName)keyType).typeArguments(List.of(SAME_GENERIC_TYPE))).build();
        } else {
            throw new IllegalArgumentException("Property " + this.name() + " with type " + this.declaredType().fqName() + " is annotated with @SameGeneric, yet the key generic type cannot be determined. Either the key must be a simple type, or a type with one type argument.");
        }
        String typeDeclaration = "<TYPE extends " + genericTypeBase.fqName() + ">";
        if (valueType.typeArguments().isEmpty()) {
            if (!genericTypeBase.equals((Object)valueType)) {
                throw new IllegalArgumentException("Property " + this.name() + " with type " + this.declaredType().fqName() + " is annotated with @SameGeneric, yet the type of value is not the same as type found on key: " + genericTypeBase.fqName());
            }
            resolvedValueType = SAME_GENERIC_TYPE;
        } else if (valueType.typeArguments().size() == 1) {
            if (!genericTypeBase.equals(valueType.typeArguments().get(0))) {
                throw new IllegalArgumentException("Property " + this.name() + " with type " + this.declaredType().fqName() + " is annotated with @SameGeneric, yet type of value is not the same as type found on key: " + genericTypeBase.fqName());
            }
            resolvedValueType = ((TypeName.Builder)TypeName.builder((TypeName)valueType).typeArguments(List.of(SAME_GENERIC_TYPE))).build();
        } else {
            throw new IllegalArgumentException("Property " + this.name() + " with type " + this.declaredType().fqName() + " is annotated with @SameGeneric, yet the value generic type cannot be determined. Either the value must be a simple type, or a type with one type argument.");
        }
        return new SameGenericArgs(typeDeclaration, List.of(new GeneratedMethod.Argument(key, resolvedKeyType), new GeneratedMethod.Argument(value, resolvedValueType)));
    }

    private GeneratedMethod setterAddValueToCollection(PrototypeProperty.ConfiguredOption configured, String methodName, String singularName, TypeName keyType, TypeName valueType, TypeName returnType, Javadoc blueprintJavadoc) {
        GeneratedMethod.Argument keyArg = new GeneratedMethod.Argument("key", keyType);
        GeneratedMethod.Argument valArg = new GeneratedMethod.Argument(singularName, valueType);
        String implType = TypeHandlerMap.collectionImplType(this.actualType());
        List<String> methodLines = List.of("Objects.requireNonNull(key);", "Objects.requireNonNull(" + singularName + ");", "this." + this.name() + ".compute(key, (k, v) -> {", "    v = v == null ? new " + implType + "<>() : new " + implType + "<>(v);", "    v.add(" + singularName + ");", "    return v;", "});", "return self();");
        ArrayList<String> docLines = new ArrayList<String>(blueprintJavadoc.lines());
        docLines.add("This method adds a new value to the map value, or creates a new value.");
        Javadoc javadoc = new Javadoc(docLines, List.of(new Javadoc.Tag("key", List.of("key to add to")), new Javadoc.Tag(singularName, List.of("additional value for the key"))), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
        return new GeneratedMethod(Set.of(TypeHandlerMap.setterModifier(configured).trim()), null, methodName, returnType, List.of(keyArg, valArg), List.of(), javadoc, methodLines);
    }

    private GeneratedMethod setterAddValuesToCollection(PrototypeProperty.ConfiguredOption configured, String methodName, TypeName keyType, TypeName returnType, Javadoc blueprintJavadoc) {
        GeneratedMethod.Argument keyArg = new GeneratedMethod.Argument("key", keyType);
        GeneratedMethod.Argument valArg = new GeneratedMethod.Argument(this.name(), this.actualType());
        String implType = TypeHandlerMap.collectionImplType(this.actualType());
        List<String> methodLines = List.of("Objects.requireNonNull(key);", "Objects.requireNonNull(" + this.name() + ");", "this." + this.name() + ".compute(key, (k, v) -> {", "    v = v == null ? new " + implType + "<>() : new " + implType + "<>(v);", "    v.addAll(" + this.name() + ");", "    return v;", "});", "return self();");
        ArrayList<String> docLines = new ArrayList<String>(blueprintJavadoc.lines());
        docLines.add("This method adds a new value to the map value, or creates a new value.");
        Javadoc javadoc = new Javadoc(docLines, List.of(new Javadoc.Tag("key", List.of("key to add to")), new Javadoc.Tag(this.name(), List.of("additional values for the key"))), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
        return new GeneratedMethod(Set.of(TypeHandlerMap.setterModifier(configured).trim()), null, methodName, returnType, List.of(keyArg, valArg), List.of(), javadoc, methodLines);
    }

    private void declaredSetterAdd(PrototypeProperty.ConfiguredOption configured, List<GeneratedMethod> setters, TypeName returnType, Javadoc blueprintJavadoc) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Objects.requireNonNull(" + this.name() + ");");
        lines.add("this." + this.name() + ".putAll(" + this.name() + ");");
        lines.add("return self();");
        ArrayList<String> docLines = new ArrayList<String>(blueprintJavadoc.lines());
        docLines.add("This method keeps existing values, then puts all new values into the map.");
        Javadoc javadoc = new Javadoc(docLines, List.of(new Javadoc.Tag(this.name(), blueprintJavadoc.returns())), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
        setters.add(new GeneratedMethod(Set.of(TypeHandlerMap.setterModifier(configured).trim()), null, "add" + GeneratorTools.capitalize((String)this.name()), returnType, List.of(new GeneratedMethod.Argument(this.name(), this.argumentTypeName())), List.of(), javadoc, lines));
    }

    private void declaredSetter(PrototypeProperty.ConfiguredOption configured, List<GeneratedMethod> setters, TypeName returnType, Javadoc blueprintJavadoc) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Objects.requireNonNull(" + this.name() + ");");
        lines.add("this." + this.name() + ".clear();");
        lines.add("this." + this.name() + ".putAll(" + this.name() + ");");
        lines.add("return self();");
        ArrayList<String> docLines = new ArrayList<String>(blueprintJavadoc.lines());
        docLines.add("This method replaces all values with the new ones.");
        Javadoc javadoc = new Javadoc(docLines, List.of(new Javadoc.Tag(this.name(), blueprintJavadoc.returns())), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
        setters.add(new GeneratedMethod(Set.of(TypeHandlerMap.setterModifier(configured).trim()), null, this.setterName(), returnType, List.of(new GeneratedMethod.Argument(this.name(), this.argumentTypeName())), List.of(), javadoc, lines));
    }

    private String secondArgToPut(TypeName typeName, String singularName) {
        TypeName genericTypeName = typeName.genericTypeName();
        if (genericTypeName.equals((Object)TypeNames.LIST)) {
            return "java.util.List.copyOf(" + singularName + ")";
        }
        if (genericTypeName.equals((Object)TypeNames.SET)) {
            return "java.util.Set.copyOf(" + singularName + ")";
        }
        if (genericTypeName.equals((Object)TypeNames.MAP)) {
            return "java.util.Map.copyOf(" + singularName + ")";
        }
        return singularName;
    }

    private boolean isCollection(TypeName typeName) {
        if (typeName.typeArguments().size() != 1) {
            return false;
        }
        TypeName genericTypeName = typeName.genericTypeName();
        if (genericTypeName.equals((Object)TypeNames.LIST)) {
            return true;
        }
        return genericTypeName.equals((Object)TypeNames.SET);
    }

    record SameGenericArgs(String typeDeclaration, List<GeneratedMethod.Argument> arguments) {
    }
}

