/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.FactoryMethods;
import io.helidon.builder.processor.GeneratedMethod;
import io.helidon.builder.processor.Javadoc;
import io.helidon.builder.processor.PrototypeProperty;
import io.helidon.builder.processor.TypeHandler;
import io.helidon.builder.processor.Types;
import io.helidon.common.processor.GeneratorTools;
import io.helidon.common.types.TypeName;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

abstract class TypeHandlerCollection
extends TypeHandler.OneTypeHandler {
    private final TypeName collectionType;
    private final String collectionImplType;
    private final String collector;
    private final Optional<String> configMapper;

    TypeHandlerCollection(String name, String getterName, String setterName, TypeName declaredType, TypeName collectionType, String collector, Optional<String> configMapper) {
        super(name, getterName, setterName, declaredType);
        this.collectionType = collectionType;
        this.collectionImplType = TypeHandlerCollection.collectionImplType(collectionType);
        this.collector = collector;
        this.configMapper = configMapper;
    }

    @Override
    String fieldDeclaration(PrototypeProperty.ConfiguredOption configured, boolean isBuilder, boolean alwaysFinal) {
        return super.fieldDeclaration(configured, isBuilder, true) + (String)(isBuilder && !configured.hasDefault() ? " = new " + this.collectionImplType + "<>()" : "");
    }

    @Override
    String toDefaultValue(String defaultValue) {
        String defaults = Stream.of(defaultValue.split(",")).map(x$0 -> super.toDefaultValue((String)x$0)).collect(Collectors.joining(", "));
        return this.collectionType.fqName() + ".of(" + defaults + ")";
    }

    @Override
    Optional<String> generateFromConfig(PrototypeProperty.ConfiguredOption configured, FactoryMethods factoryMethods) {
        if (configured.provider()) {
            return Optional.empty();
        }
        if (factoryMethods.createFromConfig().isPresent()) {
            return Optional.of(this.configGet(configured) + this.generateFromConfig(factoryMethods) + ".ifPresent(this::" + this.setterName() + ");");
        }
        if (this.actualType().equals((Object)Types.STRING_TYPE)) {
            return Optional.of(this.configGet(configured) + ".asList(String.class)" + (this.configMapper.isPresent() ? this.configMapper.get() : "") + ".ifPresent(this::" + this.setterName() + ");");
        }
        return Optional.of(this.configGet(configured) + ".asNodeList().map(nodeList -> nodeList.stream().map(cfg -> cfg" + this.generateFromConfig(factoryMethods) + ".get())." + this.collector + ").ifPresent(this::" + this.setterName() + ");");
    }

    @Override
    TypeName argumentTypeName() {
        return TypeName.builder((TypeName)this.collectionType).addTypeArgument(TypeHandlerCollection.toWildcard(this.actualType()));
    }

    @Override
    void setters(PrototypeProperty.ConfiguredOption configured, PrototypeProperty.Singular singular, List<GeneratedMethod> setters, FactoryMethods factoryMethods, TypeName returnType, Javadoc blueprintJavadoc) {
        if (configured.provider()) {
            this.discoverServicesSetter(configured, setters, returnType, blueprintJavadoc);
        }
        this.declaredSetters(configured, setters, returnType, blueprintJavadoc);
        if (factoryMethods.createTargetType().isPresent()) {
            this.factorySetter(configured, setters, returnType, blueprintJavadoc, factoryMethods.createTargetType().get());
        }
        if (singular.hasSingular()) {
            this.singularSetter(configured, setters, returnType, blueprintJavadoc, singular);
        }
        if (factoryMethods.builder().isPresent()) {
            this.factorySetterConsumer(configured, setters, returnType, blueprintJavadoc, factoryMethods, factoryMethods.builder().get(), singular);
        }
    }

    private void discoverServicesSetter(PrototypeProperty.ConfiguredOption configured, List<GeneratedMethod> setters, TypeName returnType, Javadoc blueprintJavadoc) {
        Javadoc javadoc = new Javadoc(blueprintJavadoc.lines(), List.of(new Javadoc.Tag("discoverServices", List.of("whether to discover implementations through service loader"))), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
        List<String> methodLines = List.of("this." + this.name() + "DiscoverServices = discoverServices;", "return self();");
        setters.add(new GeneratedMethod(Set.of(TypeHandlerCollection.setterModifier(configured).trim()), this.setterName() + "DiscoverServices", returnType, List.of(new GeneratedMethod.Argument("discoverServices", TypeName.create(Boolean.TYPE))), List.of(), javadoc, methodLines));
    }

    private void factorySetterConsumer(PrototypeProperty.ConfiguredOption configured, List<GeneratedMethod> setters, TypeName returnType, Javadoc blueprintJavadoc, FactoryMethods factoryMethods, FactoryMethods.FactoryMethod factoryMethod, PrototypeProperty.Singular singular) {
        TypeName builderType = factoryMethod.factoryMethodReturnType().className().equals("Builder") ? factoryMethod.factoryMethodReturnType() : TypeName.create((String)(factoryMethod.factoryMethodReturnType().fqName() + ".Builder"));
        String argumentName = "consumer";
        if (factoryMethods.createTargetType().map(FactoryMethods.FactoryMethod::factoryMethodReturnType).map(m -> m.genericTypeName().equals((Object)this.collectionType)).orElse(false).booleanValue()) {
            Javadoc javadoc = new Javadoc(blueprintJavadoc.lines(), List.of(new Javadoc.Tag(argumentName, blueprintJavadoc.returns())), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("Objects.requireNonNull(" + argumentName + ");");
            lines.add("var builder = " + factoryMethod.typeWithFactoryMethod().genericTypeName().fqName() + "." + factoryMethod.createMethodName() + "();");
            lines.add("consumer.accept(builder);");
            lines.add("this." + this.name() + "(builder.build());");
            lines.add("return self();");
            TypeName argumentType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(builderType)).build();
            setters.add(new GeneratedMethod(Set.of(TypeHandlerCollection.setterModifier(configured).trim()), this.setterName(), returnType, List.of(new GeneratedMethod.Argument(argumentName, argumentType)), List.of(), javadoc, lines));
        } else if (singular.hasSingular()) {
            String singularName = singular.singularName();
            String methodName = "add" + GeneratorTools.capitalize((String)singularName);
            Javadoc javadoc = new Javadoc(blueprintJavadoc.lines(), List.of(new Javadoc.Tag(argumentName, blueprintJavadoc.returns())), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("Objects.requireNonNull(" + argumentName + ");");
            lines.add("var builder = " + factoryMethod.typeWithFactoryMethod().genericTypeName().fqName() + "." + factoryMethod.createMethodName() + "();");
            lines.add("consumer.accept(builder);");
            lines.add("this." + this.name() + ".add(builder.build());");
            lines.add("return self();");
            TypeName argumentType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(builderType)).build();
            setters.add(new GeneratedMethod(Set.of(TypeHandlerCollection.setterModifier(configured).trim()), methodName, returnType, List.of(new GeneratedMethod.Argument(argumentName, argumentType)), List.of(), javadoc, lines));
        }
    }

    private void singularSetter(PrototypeProperty.ConfiguredOption configured, List<GeneratedMethod> setters, TypeName returnType, Javadoc blueprintJavadoc, PrototypeProperty.Singular singular) {
        String singularName = singular.singularName();
        String methodName = "add" + GeneratorTools.capitalize((String)singularName);
        Javadoc javadoc = new Javadoc(blueprintJavadoc.lines(), List.of(new Javadoc.Tag(singularName, blueprintJavadoc.returns())), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Objects.requireNonNull(" + singularName + ");");
        lines.addAll(TypeHandlerCollection.resolveBuilderLines(this.actualType(), singularName));
        lines.add("this." + this.name() + ".add(" + singularName + ");");
        lines.add("return self();");
        setters.add(new GeneratedMethod(Set.of(TypeHandlerCollection.setterModifier(configured).trim()), methodName, returnType, List.of(new GeneratedMethod.Argument(singularName, this.actualType())), List.of(), javadoc, lines));
    }

    private void factorySetter(PrototypeProperty.ConfiguredOption configured, List<GeneratedMethod> setters, TypeName returnType, Javadoc blueprintJavadoc, FactoryMethods.FactoryMethod factoryMethod) {
        String argumentName = this.name() + "Config";
        Javadoc javadoc = new Javadoc(blueprintJavadoc.lines(), List.of(new Javadoc.Tag(argumentName, blueprintJavadoc.returns())), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Objects.requireNonNull(" + argumentName + ");");
        lines.add("this." + this.name() + ".clear();");
        lines.add("this." + this.name() + ".addAll(" + factoryMethod.typeWithFactoryMethod().genericTypeName().fqName() + "." + factoryMethod.createMethodName() + "(" + argumentName + "));");
        lines.add("return self();");
        setters.add(new GeneratedMethod(Set.of(TypeHandlerCollection.setterModifier(configured).trim()), this.setterName(), returnType, List.of(new GeneratedMethod.Argument(argumentName, factoryMethod.argumentType())), List.of(), javadoc, lines));
    }

    private void declaredSetters(PrototypeProperty.ConfiguredOption configured, List<GeneratedMethod> setters, TypeName returnType, Javadoc blueprintJavadoc) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Objects.requireNonNull(" + this.name() + ");");
        lines.add("this." + this.name() + ".clear();");
        lines.add("this." + this.name() + ".addAll(" + this.name() + ");");
        lines.add("return self();");
        Javadoc javadoc = new Javadoc(blueprintJavadoc.lines(), List.of(new Javadoc.Tag(this.name(), blueprintJavadoc.returns())), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
        setters.add(new GeneratedMethod(Set.of(TypeHandlerCollection.setterModifier(configured).trim()), this.setterName(), returnType, List.of(new GeneratedMethod.Argument(this.name(), this.argumentTypeName())), List.of(), javadoc, lines));
        lines = new ArrayList();
        lines.add("Objects.requireNonNull(" + this.name() + ");");
        lines.add("this." + this.name() + ".addAll(" + this.name() + ");");
        lines.add("return self();");
        setters.add(new GeneratedMethod(Set.of(TypeHandlerCollection.setterModifier(configured).trim()), "add" + GeneratorTools.capitalize((String)this.name()), returnType, List.of(new GeneratedMethod.Argument(this.name(), this.argumentTypeName())), List.of(), javadoc, lines));
    }
}

