/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.FactoryMethods;
import io.helidon.builder.processor.GeneratedMethod;
import io.helidon.builder.processor.Javadoc;
import io.helidon.builder.processor.PrototypeProperty;
import io.helidon.builder.processor.TypeHandlerList;
import io.helidon.builder.processor.TypeHandlerMap;
import io.helidon.builder.processor.TypeHandlerOptional;
import io.helidon.builder.processor.TypeHandlerSet;
import io.helidon.builder.processor.Types;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

class TypeHandler {
    static final String UNCONFIGURED = "io.helidon.config.metadata.ConfiguredOption.UNCONFIGURED";
    private final String name;
    private final String getterName;
    private final String setterName;
    private final TypeName declaredType;

    TypeHandler(String name, String getterName, String setterName, TypeName declaredType) {
        this.name = name;
        this.getterName = getterName;
        this.setterName = setterName;
        this.declaredType = declaredType;
    }

    static TypeHandler create(String name, String getterName, String setterName, TypeName returnType, boolean sameGeneric) {
        if (TypeNames.OPTIONAL.equals((Object)returnType)) {
            return new TypeHandlerOptional(name, getterName, setterName, returnType);
        }
        if (TypeNames.SET.equals((Object)returnType)) {
            return new TypeHandlerSet(name, getterName, setterName, returnType);
        }
        if (TypeNames.LIST.equals((Object)returnType)) {
            return new TypeHandlerList(name, getterName, setterName, returnType);
        }
        if (TypeNames.MAP.equals((Object)returnType)) {
            return new TypeHandlerMap(name, getterName, setterName, returnType, sameGeneric);
        }
        return new TypeHandler(name, getterName, setterName, returnType);
    }

    static String setterModifier(PrototypeProperty.ConfiguredOption configured) {
        if (configured.builderMethod()) {
            return "public ";
        }
        return "";
    }

    static TypeName toWildcard(TypeName typeName) {
        if (typeName.wildcard()) {
            return typeName;
        }
        return ((TypeName.Builder)TypeName.builder((TypeName)typeName).wildcard(true)).build();
    }

    protected static String collectionImplType(TypeName typeName) {
        TypeName genericTypeName = typeName.genericTypeName();
        if (genericTypeName.equals((Object)TypeNames.MAP)) {
            return Types.LINKED_HASH_MAP_TYPE.fqName();
        }
        if (genericTypeName.equals((Object)TypeNames.LIST)) {
            return Types.ARRAY_LIST_TYPE.fqName();
        }
        return Types.LINKED_HASH_SET_TYPE.fqName();
    }

    protected static List<String> resolveBuilderLines(TypeName typeName, String variableName) {
        if (typeName.primitive() || typeName.isOptional() || typeName.array() || typeName.isList() || typeName.isSet() || typeName.isMap()) {
            return List.of();
        }
        if (typeName.packageName().startsWith("java.")) {
            return List.of();
        }
        return List.of(variableName + " = resolveBuilder(" + variableName + ");");
    }

    public String toString() {
        return this.declaredType.fqName() + " " + this.name;
    }

    String generateBuilderGetter() {
        return this.name;
    }

    String fieldDeclaration(PrototypeProperty.ConfiguredOption configured, boolean isBuilder, boolean alwaysFinal) {
        StringBuilder fieldDeclaration = new StringBuilder("private ");
        if (alwaysFinal || !isBuilder) {
            fieldDeclaration.append("final ");
        }
        if (isBuilder && configured.required()) {
            fieldDeclaration.append(this.declaredType.boxed().fqName());
        } else {
            fieldDeclaration.append(this.declaredType.fqName());
        }
        fieldDeclaration.append(" ").append(this.name);
        if (isBuilder && configured.hasDefault()) {
            fieldDeclaration.append(" = ").append(configured.defaultValue());
        }
        return fieldDeclaration.toString();
    }

    String toDefaultValue(String defaultValue) {
        TypeName typeName = this.actualType();
        if (Types.STRING_TYPE.equals((Object)typeName)) {
            return "\"" + defaultValue + "\"";
        }
        if (Types.DURATION_TYPE.equals((Object)typeName)) {
            return "java.time.Duration.parse(\"" + defaultValue + "\")";
        }
        if (Types.CHAR_ARRAY_TYPE.equals((Object)typeName)) {
            return "\"" + defaultValue + "\".toCharArray()";
        }
        if (typeName.primitive()) {
            if (typeName.fqName().equals("char")) {
                return "'" + defaultValue + "'";
            }
            return defaultValue;
        }
        if (typeName.name().startsWith("java.")) {
            return defaultValue;
        }
        return typeName.genericTypeName().fqName() + "." + defaultValue;
    }

    TypeName declaredType() {
        return this.declaredType;
    }

    TypeName actualType() {
        return this.declaredType;
    }

    String name() {
        return this.name;
    }

    String getterName() {
        return this.getterName;
    }

    String setterName() {
        return this.setterName;
    }

    Optional<String> generateFromConfig(PrototypeProperty.ConfiguredOption configured, FactoryMethods factoryMethods) {
        return Optional.of(this.configGet(configured) + this.generateFromConfig(factoryMethods) + ".ifPresent(this::" + this.setterName() + ");");
    }

    String configGet(PrototypeProperty.ConfiguredOption configured) {
        return "config.get(\"" + configured.configKey() + "\")";
    }

    String generateFromConfig(FactoryMethods factoryMethods) {
        if (this.actualType().fqName().equals("char[]")) {
            return ".asString().map(String::toCharArray)";
        }
        TypeName boxed = this.actualType().boxed();
        return factoryMethods.createFromConfig().map(it -> ".map(" + it.typeWithFactoryMethod().genericTypeName().fqName() + "::" + it.createMethodName() + ")").orElseGet(() -> ".as(" + boxed.fqName() + ".class)");
    }

    TypeName argumentTypeName() {
        return this.declaredType();
    }

    void setters(PrototypeProperty.ConfiguredOption configured, PrototypeProperty.Singular singular, List<GeneratedMethod> setters, FactoryMethods factoryMethod, TypeName returnType, Javadoc blueprintJavadoc) {
        this.declaredSetter(configured, setters, returnType, blueprintJavadoc);
        if (this.actualType().equals((Object)Types.CHAR_ARRAY_TYPE)) {
            this.charArraySetter(configured, setters, returnType, blueprintJavadoc);
        }
        if (factoryMethod.createTargetType().isPresent()) {
            this.factorySetter(configured, setters, returnType, blueprintJavadoc, factoryMethod.createTargetType().get());
        }
        if (factoryMethod.builder().isPresent()) {
            this.factorySetterConsumer(configured, setters, returnType, blueprintJavadoc, factoryMethod.builder().get());
        }
    }

    protected void charArraySetter(PrototypeProperty.ConfiguredOption configured, List<GeneratedMethod> setters, TypeName returnType, Javadoc blueprintJavadoc) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Objects.requireNonNull(" + this.name() + ");");
        lines.add("this." + this.name() + " = " + this.name() + ".toCharArray();");
        lines.add("return self();");
        Javadoc javadoc = new Javadoc(blueprintJavadoc.lines(), List.of(new Javadoc.Tag(this.name(), blueprintJavadoc.returns())), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
        setters.add(new GeneratedMethod(Set.of(TypeHandler.setterModifier(configured).trim()), this.setterName(), returnType, List.of(new GeneratedMethod.Argument(this.name(), Types.STRING_TYPE)), List.of(), javadoc, lines));
    }

    private void declaredSetter(PrototypeProperty.ConfiguredOption configured, List<GeneratedMethod> setters, TypeName returnType, Javadoc blueprintJavadoc) {
        ArrayList<String> lines = new ArrayList<String>();
        if (!this.declaredType.primitive()) {
            lines.add("Objects.requireNonNull(" + this.name() + ");");
        }
        lines.addAll(TypeHandler.resolveBuilderLines(this.actualType(), this.name()));
        lines.add("this." + this.name() + " = " + this.name() + ";");
        lines.add("return self();");
        Javadoc javadoc = new Javadoc(blueprintJavadoc.lines(), List.of(new Javadoc.Tag(this.name(), blueprintJavadoc.returns())), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
        setters.add(new GeneratedMethod(Set.of(TypeHandler.setterModifier(configured).trim()), this.setterName(), returnType, List.of(new GeneratedMethod.Argument(this.name(), this.argumentTypeName())), List.of(), javadoc, lines));
    }

    private void factorySetterConsumer(PrototypeProperty.ConfiguredOption configured, List<GeneratedMethod> setters, TypeName returnType, Javadoc blueprintJavadoc, FactoryMethods.FactoryMethod factoryMethod) {
        TypeName builderType = factoryMethod.factoryMethodReturnType().className().equals("Builder") ? factoryMethod.factoryMethodReturnType() : TypeName.create((String)(factoryMethod.factoryMethodReturnType().fqName() + ".Builder"));
        String argumentName = "consumer";
        ArrayList<String> paramLines = new ArrayList<String>();
        paramLines.add("consumer of builder for");
        paramLines.addAll(blueprintJavadoc.returns());
        Javadoc javadoc = new Javadoc(blueprintJavadoc.lines(), List.of(new Javadoc.Tag(argumentName, paramLines)), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Objects.requireNonNull(" + argumentName + ");");
        lines.add("var builder = " + factoryMethod.typeWithFactoryMethod().genericTypeName().fqName() + "." + factoryMethod.createMethodName() + "();");
        lines.add("consumer.accept(builder);");
        lines.add("this." + this.name() + "(builder.build());");
        lines.add("return self();");
        TypeName argumentType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(builderType)).build();
        setters.add(new GeneratedMethod(Set.of(TypeHandler.setterModifier(configured).trim()), this.setterName(), returnType, List.of(new GeneratedMethod.Argument(argumentName, argumentType)), List.of(), javadoc, lines));
    }

    private void factorySetter(PrototypeProperty.ConfiguredOption configured, List<GeneratedMethod> setters, TypeName returnType, Javadoc blueprintJavadoc, FactoryMethods.FactoryMethod factoryMethod) {
        String argumentName = this.name() + "Config";
        Javadoc javadoc = new Javadoc(blueprintJavadoc.lines(), List.of(new Javadoc.Tag(argumentName, blueprintJavadoc.returns())), List.of("updated builder instance"), List.of(new Javadoc.Tag("see", List.of("#" + this.getterName() + "()"))));
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("Objects.requireNonNull(" + argumentName + ");");
        lines.add("this." + this.name() + " = " + factoryMethod.typeWithFactoryMethod().genericTypeName().fqName() + "." + factoryMethod.createMethodName() + "(" + argumentName + ");");
        lines.add("return self();");
        setters.add(new GeneratedMethod(Set.of(TypeHandler.setterModifier(configured).trim()), this.setterName(), returnType, List.of(new GeneratedMethod.Argument(argumentName, factoryMethod.argumentType())), List.of(), javadoc, lines));
    }

    static class OneTypeHandler
    extends TypeHandler {
        private final TypeName actualType;

        OneTypeHandler(String name, String getterName, String setterName, TypeName declaredType) {
            super(name, getterName, setterName, declaredType);
            this.actualType = declaredType.typeArguments().isEmpty() ? Types.STRING_TYPE : (TypeName)declaredType.typeArguments().get(0);
        }

        @Override
        TypeName actualType() {
            return this.actualType;
        }
    }
}

