/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import java.util.ArrayList;
import java.util.List;

record Javadoc(List<String> lines, List<Tag> parameters, List<String> returns, List<Tag> nonParamTags) {
    static Javadoc parse(List<String> documentation) {
        List<String> lines = documentation.stream().map(String::trim).toList();
        ParserState state = ParserState.LINES;
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<Tag> params = new ArrayList<Tag>();
        ArrayList<String> returns = new ArrayList<String>();
        ArrayList<Tag> otherTags = new ArrayList<Tag>();
        String currentTagName = null;
        ArrayList<String> currentTag = new ArrayList<String>();
        block4: for (String line : lines) {
            if (line.startsWith("@")) {
                int space;
                if (state == ParserState.PARAM) {
                    params.add(new Tag(currentTagName, List.copyOf(currentTag)));
                } else if (state == ParserState.TAG) {
                    otherTags.add(new Tag(currentTagName, List.copyOf(currentTag)));
                }
                currentTagName = null;
                currentTag.clear();
                if (line.startsWith("@param")) {
                    state = ParserState.PARAM;
                    space = line.indexOf(32);
                    if (space < 0) {
                        throw new IllegalStateException("Failed to parse javadoc, @param without param name: " + line);
                    }
                    int secondSpace = line.indexOf(32, space + 2);
                    if (secondSpace < 0) {
                        throw new IllegalStateException("Failed to parse javadoc, @param without param name or docs: " + line);
                    }
                    currentTagName = line.substring(space + 1, secondSpace);
                    currentTag.add(line.substring(secondSpace + 1));
                    continue;
                }
                if (line.startsWith("@return")) {
                    state = ParserState.RETURNS;
                    returns.add(line.substring("@return".length()).trim());
                    continue;
                }
                state = ParserState.TAG;
                space = line.indexOf(32);
                if (space < 0) {
                    throw new IllegalStateException("Failed to parse javadoc, @tag without space: " + line);
                }
                currentTagName = line.substring(1, space);
                currentTag.add(line.substring(space + 1));
                continue;
            }
            switch (state) {
                case LINES: {
                    result.add(line);
                    continue block4;
                }
                case RETURNS: {
                    returns.add(line);
                    continue block4;
                }
            }
            currentTag.add(line);
        }
        if (state == ParserState.PARAM) {
            if (currentTagName != null) {
                params.add(new Tag(currentTagName, List.copyOf(currentTag)));
            }
        } else if (currentTagName != null) {
            otherTags.add(new Tag(currentTagName, List.copyOf(currentTag)));
        }
        return new Javadoc(result, params, returns, otherTags);
    }

    static Javadoc parse(String docString) {
        return Javadoc.parse(List.of(docString.split("\n")));
    }

    Javadoc removeFirstParam() {
        if (this.parameters.isEmpty()) {
            return this;
        }
        return new Javadoc(this.lines(), this.parameters().subList(1, this.parameters().size()), this.returns(), this.nonParamTags());
    }

    Javadoc updateReturns(String returns) {
        return new Javadoc(this.lines(), this.parameters(), List.of(returns), this.nonParamTags());
    }

    List<String> toLines() {
        ArrayList<String> result = new ArrayList<String>(this.lines());
        for (Tag parameter : this.parameters) {
            this.addToTag(result, "@param " + parameter.name, parameter.tagLines());
        }
        if (!this.returns().isEmpty()) {
            this.addToTag(result, "@return", this.returns());
        }
        for (Tag tag : this.nonParamTags()) {
            this.addToTag(result, "@" + tag.name, tag.tagLines());
        }
        return result;
    }

    private void addToTag(List<String> result, String tag, List<String> tagLines) {
        if (tagLines.isEmpty()) {
            result.add(tag);
        } else {
            result.add(tag + " " + tagLines.get(0));
            result.addAll(tagLines.subList(1, tagLines.size()));
        }
    }

    private static enum ParserState {
        LINES,
        PARAM,
        RETURNS,
        TAG;

    }

    record Tag(String name, List<String> tagLines) {
    }
}

