/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.GenerateAbstractBuilder;
import io.helidon.builder.processor.TypeContext;
import io.helidon.common.types.TypeName;
import java.io.PrintWriter;

final class GenerateBuilder {
    private static final String SOURCE_SPACING = "    ";

    private GenerateBuilder() {
    }

    static void generate(PrintWriter pw, TypeName prototype, TypeName runtimeType, String typeArguments, boolean isFactory, TypeContext typeContext) {
        String prototypeWithTypes = prototype.className() + typeArguments;
        String runtimeTypeWithTypes = runtimeType.className() + typeArguments;
        Object typeArgumentNames = "";
        if (!typeArguments.isEmpty()) {
            typeArgumentNames = typeArguments.substring(1, typeArguments.length() - 1) + ", ";
        }
        pw.print(SOURCE_SPACING);
        pw.println("/**");
        pw.print(SOURCE_SPACING);
        pw.print(" * Fluent API builder for {@link ");
        pw.print(runtimeType.className());
        pw.println("}.");
        pw.print(SOURCE_SPACING);
        pw.println(" */");
        pw.print(SOURCE_SPACING);
        pw.print("class Builder");
        pw.print(typeArguments);
        pw.print(" extends BuilderBase<");
        pw.print((String)typeArgumentNames);
        pw.print("Builder");
        pw.print(typeArguments);
        pw.print(", ");
        pw.print(prototypeWithTypes);
        pw.print("> implements io.helidon.common.Builder<Builder");
        pw.print(typeArguments);
        pw.print(", ");
        pw.print(runtimeTypeWithTypes);
        pw.println("> {");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("private Builder() {");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("}");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("@Override");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print("public ");
        pw.print(prototypeWithTypes);
        pw.println(" buildPrototype() {");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("preBuildPrototype();");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("validatePrototype();");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.print("return new ");
        pw.print(prototype.className());
        pw.print("Impl");
        if (!typeArguments.isEmpty()) {
            pw.print("<>");
        }
        pw.println("(this);");
        pw.print(SOURCE_SPACING);
        pw.print(SOURCE_SPACING);
        pw.println("}");
        pw.println();
        if (isFactory) {
            GenerateAbstractBuilder.buildRuntimeObjectMethod(pw, typeContext, true);
        } else {
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("@Override");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print("public ");
            pw.print(runtimeTypeWithTypes);
            pw.println(" build() {");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("return buildPrototype();");
            pw.print(SOURCE_SPACING);
            pw.print(SOURCE_SPACING);
            pw.println("}");
            pw.println();
        }
        pw.print(SOURCE_SPACING);
        pw.println("}");
    }
}

