/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.processor;

import io.helidon.builder.processor.CustomMethods;
import io.helidon.builder.processor.GenerateAbstractBuilder;
import io.helidon.builder.processor.GenerateBuilder;
import io.helidon.builder.processor.Javadoc;
import io.helidon.builder.processor.ProcessingContext;
import io.helidon.builder.processor.TypeContext;
import io.helidon.builder.processor.Types;
import io.helidon.builder.processor.ValidationTask;
import io.helidon.common.Errors;
import io.helidon.common.processor.CopyrightHandler;
import io.helidon.common.processor.GeneratedAnnotationHandler;
import io.helidon.common.processor.TypeInfoFactory;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public class BlueprintProcessor
extends AbstractProcessor {
    private static final String SOURCE_SPACING = "    ";
    private static final TypeName GENERATOR = TypeName.create(BlueprintProcessor.class);
    private final Set<ValidationTask> validationTasks = new LinkedHashSet<ValidationTask>();
    private final Set<Element> runtimeTypes = new HashSet<Element>();
    private final Set<Element> blueprintTypes = new HashSet<Element>();
    private TypeElement blueprintAnnotationType;
    private TypeElement runtimePrototypeAnnotationType;
    private Messager messager;
    private Filer filer;
    private ProcessingEnvironment env;
    private Elements elementUtils;

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Set.of("io.helidon.builder.api.Prototype.Blueprint", "io.helidon.builder.api.RuntimeType.PrototypedBy", Types.GENERATED);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.messager = processingEnv.getMessager();
        this.blueprintAnnotationType = this.elementUtils.getTypeElement("io.helidon.builder.api.Prototype.Blueprint");
        this.runtimePrototypeAnnotationType = this.elementUtils.getTypeElement("io.helidon.builder.api.RuntimeType.PrototypedBy");
        this.filer = processingEnv.getFiler();
        this.env = processingEnv;
        if (this.blueprintAnnotationType == null || this.runtimePrototypeAnnotationType == null) {
            throw new IllegalStateException("Bug in BlueprintProcessor code, cannot find required types, probably wrong type constants. io.helidon.builder.api.Prototype.Blueprint = " + String.valueOf(this.blueprintAnnotationType) + ", io.helidon.builder.api.RuntimeType.PrototypedBy = " + String.valueOf(this.runtimePrototypeAnnotationType));
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.runtimeTypes.addAll(roundEnv.getElementsAnnotatedWith(this.runtimePrototypeAnnotationType));
        Set<? extends Element> blueprints = roundEnv.getElementsAnnotatedWithAny(this.blueprintAnnotationType);
        this.blueprintTypes.addAll(blueprints);
        List<TypeElement> blueprintInterfaces = this.collectInterfaces(blueprints);
        ProcessingContext processingContext = ProcessingContext.create(this.processingEnv);
        for (TypeElement typeElement : blueprintInterfaces) {
            try {
                this.process(typeElement, processingContext);
            }
            catch (Throwable e) {
                this.messager.printError("Failed to process @Builder: " + e.getClass().getName() + ": " + e.getMessage(), typeElement);
                throw new IllegalStateException("Failed to code generate builders", e);
            }
        }
        if (roundEnv.processingOver()) {
            this.addRuntimeTypesForValidation(this.runtimeTypes);
            this.addBlueprintsForValidation(processingContext, this.blueprintTypes);
            Errors.Collector collector = Errors.collector();
            for (ValidationTask task : this.validationTasks) {
                task.validate(collector);
            }
            this.validationTasks.clear();
            Errors errors = collector.collect();
            if (errors.hasFatal()) {
                for (Errors.ErrorMessage error : errors) {
                    this.messager.printError(error.toString().replace('\n', ' '));
                }
            }
        }
        return annotations.size() == 1;
    }

    private void process(TypeElement definitionTypeElement, ProcessingContext processingContext) throws IOException {
        TypeInfo typeInfo = (TypeInfo)TypeInfoFactory.create((ProcessingEnvironment)this.env, (TypeElement)definitionTypeElement).orElseThrow(() -> new IllegalArgumentException("Could not process " + String.valueOf(definitionTypeElement) + ", no type info generated"));
        TypeContext typeContext = TypeContext.create(processingContext, this.elementUtils, definitionTypeElement, typeInfo);
        this.generatePrototypeWithBuilder(definitionTypeElement, typeContext);
    }

    private void addBlueprintsForValidation(ProcessingContext processingContext, Set<Element> blueprintElements) {
        for (Element element : blueprintElements) {
            TypeElement typeElement = (TypeElement)element;
            TypeInfo typeInfo = TypeInfoFactory.create((ProcessingEnvironment)this.processingEnv, (TypeElement)typeElement).orElse(null);
            if (typeInfo == null) continue;
            this.validationTasks.add(new ValidationTask.ValidateBlueprint(typeInfo));
            TypeContext typeContext = TypeContext.create(processingContext, this.elementUtils, typeElement, typeInfo);
            if (!typeContext.blueprintData().isFactory()) continue;
            this.validationTasks.add(new ValidationTask.ValidateBlueprintExtendsFactory(typeContext.typeInfo().prototype(), typeInfo, this.toTypeInfo(typeInfo, typeContext.typeInfo().runtimeObject().get())));
        }
    }

    private void addRuntimeTypesForValidation(Set<? extends Element> runtimeTypes) {
        runtimeTypes.stream().map(TypeElement.class::cast).map(it -> TypeInfoFactory.create((ProcessingEnvironment)this.processingEnv, (TypeElement)it)).flatMap(Optional::stream).forEach(it -> this.validationTasks.add(new ValidationTask.ValidateConfiguredType((TypeInfo)it, this.annotationTypeValue((TypeInfo)it, Types.RUNTIME_PROTOTYPE_TYPE))));
    }

    private TypeName annotationTypeValue(TypeInfo typeInfo, TypeName annotationType) {
        return (TypeName)typeInfo.findAnnotation(annotationType).flatMap(it -> it.value().map(TypeName::create)).orElseThrow(() -> new IllegalArgumentException("Type " + typeInfo.typeName().fqName() + " has invalid ConfiguredBy annotation"));
    }

    private TypeInfo toTypeInfo(TypeInfo typeInfo, TypeName typeName) {
        TypeElement element = this.elementUtils.getTypeElement(typeName.genericTypeName().fqName());
        return (TypeInfo)TypeInfoFactory.create((ProcessingEnvironment)this.processingEnv, (TypeElement)element).orElseThrow(() -> new IllegalArgumentException("Type " + typeName.fqName() + " is not a valid type for Factory declared on type " + typeInfo.typeName().fqName()));
    }

    private List<TypeElement> collectInterfaces(Set<? extends Element> builderTypes) {
        ArrayList<TypeElement> result = new ArrayList<TypeElement>();
        Errors.Collector errors = Errors.collector();
        for (Element element : builderTypes) {
            if (element.getKind() != ElementKind.INTERFACE) {
                errors.fatal("@Blueprint can only be defined on an interface, but is defined on: " + String.valueOf(element));
                this.messager.printMessage(Diagnostic.Kind.MANDATORY_WARNING, "io.helidon.builder.api.Prototype.Blueprint can only be defined on an interface", element);
                continue;
            }
            result.add((TypeElement)element);
        }
        errors.collect().checkValid();
        return result;
    }

    private void generatePrototypeWithBuilder(TypeElement builderInterface, TypeContext typeContext) throws IOException {
        TypeContext.BlueprintData blueprintDef = typeContext.blueprintData();
        TypeContext.ConfiguredData configuredData = typeContext.configuredData();
        TypeContext.PropertyData propertyData = typeContext.propertyData();
        TypeContext.TypeInformation typeInformation = typeContext.typeInfo();
        CustomMethods customMethods = typeContext.customMethods();
        TypeInfo typeInfo = typeInformation.blueprintType();
        TypeName prototype = typeContext.typeInfo().prototype();
        String ifaceName = prototype.className();
        JavaFileObject generatedIface = this.filer.createSourceFile(prototype.name(), builderInterface);
        try (PrintWriter pw = new PrintWriter(generatedIface.openWriter());){
            pw.println(CopyrightHandler.copyright((TypeName)GENERATOR, (TypeName)typeInfo.typeName(), (TypeName)prototype));
            pw.print("package ");
            pw.print(typeInfo.typeName().packageName());
            pw.println(";");
            pw.println();
            pw.print("import ");
            pw.print(typeInfo.typeName().genericTypeName().fqName());
            pw.println(";");
            pw.print("import ");
            pw.print("io.helidon.builder.api.Prototype.FactoryMethod");
            pw.println(";");
            pw.println("import java.util.Objects;");
            if (propertyData.hasRequired() || propertyData.hasNonNulls()) {
                pw.println("import io.helidon.common.Errors;");
            }
            if (configuredData.configured() || GenerateAbstractBuilder.hasConfig(propertyData.properties())) {
                pw.println("import io.helidon.common.config.Config;");
            }
            if (propertyData.hasOptional() || configuredData.configured()) {
                pw.println();
                pw.println("import java.util.Optional;");
            }
            pw.println();
            String javadoc = blueprintDef.javadoc();
            if (javadoc == null) {
                javadoc = " Interface generated from definition. Please add javadoc to the definition interface.";
            }
            pw.println("/**");
            for (String string : javadoc.split("\n")) {
                pw.print(" *");
                pw.println(string);
            }
            pw.println(" *");
            pw.println(" * @see #builder()");
            if (!propertyData.hasRequired() && blueprintDef.createEmptyPublic()) {
                pw.println(" * @see #create()");
            }
            pw.println(" */");
            typeContext.typeInfo().annotationsToGenerate().forEach(pw::println);
            pw.println(GeneratedAnnotationHandler.createString((TypeName)GENERATOR, (TypeName)typeInfo.typeName(), (TypeName)prototype, (String)"1", (String)""));
            if (typeContext.blueprintData().prototypePublic()) {
                pw.print("public ");
            }
            pw.print("interface ");
            pw.print(ifaceName);
            pw.print(blueprintDef.typeArguments());
            pw.print(" extends ");
            pw.print(blueprintDef.extendsList().stream().map(rec$ -> ((TypeName)rec$).fqName()).collect(Collectors.joining(", ")));
            pw.println(" {");
            if (blueprintDef.builderPublic()) {
                pw.print(SOURCE_SPACING);
                pw.println("/**");
                pw.print(SOURCE_SPACING);
                pw.println(" * Create a new fluent API builder to customize configuration.");
                pw.print(SOURCE_SPACING);
                pw.println(" *");
                pw.print(SOURCE_SPACING);
                pw.println(" * @return a new builder");
                pw.print(SOURCE_SPACING);
                pw.println(" */");
                pw.print(SOURCE_SPACING);
                pw.print("static");
                if (!blueprintDef.typeArguments().isEmpty()) {
                    pw.print(" ");
                    pw.print(blueprintDef.typeArguments());
                }
                pw.print(" Builder");
                pw.print(blueprintDef.typeArguments());
                pw.println(" builder() {");
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                if (blueprintDef.typeArguments().isEmpty()) {
                    pw.print("return new ");
                    pw.print(ifaceName);
                    pw.println(".Builder();");
                } else {
                    pw.print("return new ");
                    pw.print(ifaceName);
                    pw.println(".Builder<>();");
                }
                pw.print(SOURCE_SPACING);
                pw.println("}");
                pw.println();
                pw.print(SOURCE_SPACING);
                pw.println("/**");
                pw.print(SOURCE_SPACING);
                pw.println(" * Create a new fluent API builder from an existing instance.");
                pw.print(SOURCE_SPACING);
                pw.println(" *");
                pw.print(SOURCE_SPACING);
                pw.println(" * @param instance an existing instance used as a base for the builder");
                pw.print(SOURCE_SPACING);
                pw.println(" * @return a builder based on an instance");
                pw.print(SOURCE_SPACING);
                pw.println(" */");
                pw.print(SOURCE_SPACING);
                pw.print("static");
                if (!blueprintDef.typeArguments().isEmpty()) {
                    pw.print(" ");
                    pw.print(blueprintDef.typeArguments());
                }
                pw.print(" Builder");
                pw.print(blueprintDef.typeArguments());
                pw.print(" builder(");
                pw.print(ifaceName);
                pw.print(blueprintDef.typeArguments());
                pw.println(" instance) {");
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.print("return ");
                pw.print(ifaceName);
                pw.print(".");
                pw.print(blueprintDef.typeArguments());
                pw.println("builder().from(instance);");
                pw.print(SOURCE_SPACING);
                pw.println("}");
                pw.println();
            }
            if (blueprintDef.createFromConfigPublic() && configuredData.configured()) {
                pw.print(SOURCE_SPACING);
                pw.println("/**");
                pw.print(SOURCE_SPACING);
                pw.println(" * Create a new instance from configuration.");
                pw.print(SOURCE_SPACING);
                pw.println(" *");
                pw.print(SOURCE_SPACING);
                pw.println(" * @param config used to configure the new instance");
                pw.print(SOURCE_SPACING);
                pw.println(" * @return a new instance configured from configuration");
                pw.print(SOURCE_SPACING);
                pw.println(" */");
                pw.print(SOURCE_SPACING);
                pw.print("static ");
                if (!blueprintDef.typeArguments().isEmpty()) {
                    pw.print(blueprintDef.typeArguments());
                    pw.print(" ");
                }
                pw.print(ifaceName);
                pw.print(blueprintDef.typeArguments());
                pw.println(" create(Config config) {");
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                if (blueprintDef.builderPublic()) {
                    pw.print("return ");
                    pw.print(ifaceName);
                    pw.print(".");
                    pw.print(blueprintDef.typeArguments());
                    pw.println("builder().config(config).buildPrototype();");
                } else if (blueprintDef.typeArguments().isEmpty()) {
                    pw.println("return new Builder().config(config).build();");
                } else {
                    pw.println("return new Builder()<>.config(config).build();");
                }
                pw.print(SOURCE_SPACING);
                pw.println("}");
                pw.println();
            }
            if (blueprintDef.createEmptyPublic() && !propertyData.hasRequired()) {
                pw.print(SOURCE_SPACING);
                pw.println("/**");
                pw.print(SOURCE_SPACING);
                pw.println(" * Create a new instance with default values.");
                pw.print(SOURCE_SPACING);
                pw.println(" *");
                pw.print(SOURCE_SPACING);
                pw.println(" * @return a new instance");
                pw.print(SOURCE_SPACING);
                pw.println(" */");
                pw.print(SOURCE_SPACING);
                pw.print("static ");
                if (!blueprintDef.typeArguments().isEmpty()) {
                    pw.print(blueprintDef.typeArguments());
                    pw.print(" ");
                }
                pw.print(ifaceName);
                pw.print(blueprintDef.typeArguments());
                pw.println(" create() {");
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.print(" return ");
                pw.print(ifaceName);
                pw.print(".");
                pw.print(blueprintDef.typeArguments());
                pw.println("builder().buildPrototype();");
                pw.print(SOURCE_SPACING);
                pw.println("}");
                pw.println();
            }
            for (CustomMethods.CustomMethod customMethod : customMethods.factoryMethods()) {
                CustomMethods.Method generated = customMethod.generatedMethod().method();
                if (!generated.javadoc().isEmpty()) {
                    pw.print(SOURCE_SPACING);
                    pw.println("/**");
                    for (String string : generated.javadoc()) {
                        pw.print(SOURCE_SPACING);
                        pw.print(" *");
                        pw.println(string);
                    }
                    pw.print(SOURCE_SPACING);
                    pw.println(" */");
                }
                for (String string : customMethod.generatedMethod().annotations()) {
                    pw.print(SOURCE_SPACING);
                    pw.print('@');
                    pw.println(string);
                }
                pw.print(SOURCE_SPACING);
                pw.print("static ");
                pw.print(generated.returnType().fqName());
                pw.print(" ");
                pw.print(generated.name());
                pw.print("(");
                pw.print(generated.arguments().stream().map(it -> it.typeName().fqName() + " " + it.name()).collect(Collectors.joining(", ")));
                pw.println(") {");
                pw.print(SOURCE_SPACING);
                pw.print(SOURCE_SPACING);
                pw.print(customMethod.generatedMethod().callCode());
                pw.println(";");
                pw.print(SOURCE_SPACING);
                pw.println("}");
                pw.println();
            }
            for (CustomMethods.CustomMethod customMethod : customMethods.prototypeMethods()) {
                CustomMethods.Method generated = customMethod.generatedMethod().method();
                if (generated.javadoc().isEmpty() && customMethod.generatedMethod().annotations().contains(Types.OVERRIDE)) continue;
                if (!generated.javadoc().isEmpty()) {
                    Javadoc javadoc2 = Javadoc.parse(generated.javadoc()).removeFirstParam();
                    pw.print(SOURCE_SPACING);
                    pw.println("/**");
                    for (String docLine : javadoc2.toLines()) {
                        pw.print(SOURCE_SPACING);
                        pw.print(" *");
                        pw.println(docLine);
                    }
                    pw.print(SOURCE_SPACING);
                    pw.println(" */");
                }
                for (String string : customMethod.generatedMethod().annotations()) {
                    pw.print(SOURCE_SPACING);
                    pw.print('@');
                    pw.println(string);
                }
                pw.print(SOURCE_SPACING);
                pw.print(generated.returnType().fqName());
                pw.print(" ");
                pw.print(generated.name());
                pw.print("(");
                pw.print(generated.arguments().stream().map(it -> it.typeName().fqName() + " " + it.name()).collect(Collectors.joining(", ")));
                pw.println(");");
                pw.println();
            }
            GenerateAbstractBuilder.generate(pw, typeInformation.prototype(), typeInformation.runtimeObject().orElseGet(typeInformation::prototype), blueprintDef.typeArguments(), typeContext);
            GenerateBuilder.generate(pw, typeInformation.prototype(), typeInformation.runtimeObject().orElseGet(typeInformation::prototype), blueprintDef.typeArguments(), typeContext.blueprintData().isFactory(), typeContext);
            pw.println("}");
        }
    }
}

