/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.FactoryMethod;
import io.helidon.builder.codegen.GeneratedMethod;
import io.helidon.builder.codegen.OptionConfigured;
import io.helidon.builder.codegen.OptionInfo;
import io.helidon.builder.codegen.PrototypeInfo;
import io.helidon.builder.codegen.TypeHandlerBasic;
import io.helidon.builder.codegen.Types;
import io.helidon.builder.codegen.Utils;
import io.helidon.builder.codegen.spi.BuilderCodegenExtension;
import io.helidon.codegen.classmodel.ClassBase;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

class TypeHandlerSupplier
extends TypeHandlerBasic {
    TypeHandlerSupplier(List<BuilderCodegenExtension> extensions, PrototypeInfo prototypeInfo, OptionInfo option) {
        super(extensions, prototypeInfo, option, TypeHandlerSupplier.firstTypeArgument(option));
    }

    @Override
    public void fields(ClassBase.Builder<?, ?> classBuilder, boolean isBuilder) {
        Field.Builder builder = ((Field.Builder)Field.builder().type(this.option().declaredType()).name(this.option().name())).isFinal(!isBuilder);
        if (isBuilder && this.option().defaultValue().isPresent()) {
            builder.addContent("() -> ");
            this.option().defaultValue().get().accept((ContentBuilder<?>)builder);
        }
        classBuilder.addField(builder);
    }

    @Override
    public void generateFromConfig(Method.Builder method, OptionConfigured optionConfigured) {
        if (this.option().provider().isPresent()) {
            return;
        }
        Optional<FactoryMethod> factoryMethod = optionConfigured.factoryMethod();
        String setterName = this.option().setterName();
        if (factoryMethod.isPresent()) {
            method.addContent(this.configGet(optionConfigured));
            this.generateFromConfig((ContentBuilder<?>)method, factoryMethod.get());
            method.addContentLine(".ifPresent(this::" + setterName + ");");
        } else if (this.type().isOptional()) {
            method.addContent(setterName + "(");
            method.addContent(this.configGet(optionConfigured));
            method.addContent(this.generateFromConfigOptional());
            method.addContentLine(".optionalSupplier());");
        } else {
            method.addContent(setterName + "(");
            method.addContent(this.configGet(optionConfigured));
            this.generateFromConfig((ContentBuilder<?>)method);
            method.addContentLine(".supplier());");
        }
    }

    @Override
    Optional<GeneratedMethod> prepareBuilderSetterDeclared(Javadoc getterJavadoc) {
        TypeName typeName = this.option().declaredType();
        TypeName returnType = Utils.builderReturnType();
        String name = this.option().name();
        boolean generic = !this.type().typeArguments().isEmpty();
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(AccessModifier.PACKAGE_PRIVATE)).typeName(returnType)).elementName(this.option().setterName())).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        if (generic) {
            method.addAnnotation(Annotation.create(SuppressWarnings.class, (String)"unchecked"));
        }
        method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(typeName)).elementName(name));
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            if (!typeName.primitive()) {
                it.addContent(Objects.class).addContentLine(".requireNonNull(" + name + ");");
            }
            it.addContentLine("this." + name + " = " + name + "::get;").addContentLine("return self();");
        };
        return Optional.ofNullable(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(this.setterJavadoc(getterJavadoc, name, ""))).contentBuilder(contentConsumer)).build());
    }

    @Override
    TypeName builderGetterType() {
        return this.option().declaredType();
    }

    @Override
    GeneratedMethod prepareBuilderGetter(Javadoc javadoc) {
        return super.prepareBuilderGetter(javadoc);
    }

    @Override
    GeneratedMethod prepareBuilderSetter(Javadoc getterJavadoc) {
        TypeName typeName = this.type();
        if (typeName.equals((Object)Types.CHAR_ARRAY)) {
            return this.stringSetterForCharArrayBuilderSetter(getterJavadoc);
        }
        return this.realDeclaredBuilderSetter(getterJavadoc);
    }

    @Override
    Optional<GeneratedMethod> prepareBuilderSetterCharArray(Javadoc getterJavadoc) {
        if (this.type().equals((Object)Types.CHAR_ARRAY)) {
            return Optional.of(this.realDeclaredBuilderSetter(getterJavadoc));
        }
        return Optional.empty();
    }

    @Override
    GeneratedMethod realDeclaredBuilderSetter(Javadoc getterJavadoc) {
        TypeName typeName = this.type();
        TypeName returnType = Utils.builderReturnType();
        String name = this.option().name();
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName(this.option().setterName())).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(typeName)).elementName(name));
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            if (!typeName.primitive()) {
                it.addContent(Objects.class).addContentLine(".requireNonNull(" + name + ");");
            }
            it.addContentLine("this." + name + " = () -> " + name + ";").addContentLine("return self();");
        };
        return ((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(this.setterJavadoc(getterJavadoc, name, ""))).contentBuilder(contentConsumer)).build();
    }

    String generateFromConfigOptional() {
        TypeName optionalType = (TypeName)this.type().typeArguments().get(0);
        if (optionalType.fqName().equals("char[]")) {
            return ".asString().as(String::toCharArray)";
        }
        TypeName boxed = optionalType.boxed();
        return ".as(" + boxed.fqName() + ".class)";
    }
}

