/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.FactoryMethod;
import io.helidon.builder.codegen.GeneratedMethod;
import io.helidon.builder.codegen.OptionBuilder;
import io.helidon.builder.codegen.OptionConfigured;
import io.helidon.builder.codegen.OptionDeprecation;
import io.helidon.builder.codegen.OptionInfo;
import io.helidon.builder.codegen.OptionMethodType;
import io.helidon.builder.codegen.PrototypeInfo;
import io.helidon.builder.codegen.RuntimeTypeInfo;
import io.helidon.builder.codegen.TypeHandler;
import io.helidon.builder.codegen.Types;
import io.helidon.builder.codegen.Utils;
import io.helidon.builder.codegen.spi.BuilderCodegenExtension;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ClassBase;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.InnerClass;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.Modifier;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;

class TypeHandlerBasic
implements TypeHandler {
    private final Map<OptionMethodType, GeneratedMethod> generatedMethods = new EnumMap<OptionMethodType, GeneratedMethod>(OptionMethodType.class);
    private final OptionInfo option;
    private final TypeName type;
    private final PrototypeInfo prototypeInfo;
    private final List<BuilderCodegenExtension> extensions;

    TypeHandlerBasic(List<BuilderCodegenExtension> extensions, PrototypeInfo prototypeInfo, OptionInfo option, TypeName type) {
        this.extensions = extensions;
        this.prototypeInfo = prototypeInfo;
        this.option = option;
        this.type = type;
    }

    protected static TypeName firstTypeArgument(OptionInfo option) {
        return (TypeName)option.declaredType().typeArguments().getFirst();
    }

    @Override
    public Optional<GeneratedMethod> optionMethod(OptionMethodType type) {
        return Optional.ofNullable(this.generatedMethods.get((Object)type));
    }

    @Override
    public TypeName type() {
        return this.type;
    }

    @Override
    public void fields(ClassBase.Builder<?, ?> classBuilder, boolean isBuilder) {
        classBuilder.addField(this.field(isBuilder));
    }

    @Override
    public void setters(InnerClass.Builder classBuilder) {
        this.optionMethod(OptionMethodType.BUILDER_CLEAR).ifPresent(it -> Utils.addGeneratedMethod(classBuilder, it));
        this.optionMethod(OptionMethodType.BUILDER_SETTER).ifPresent(it -> Utils.addGeneratedMethod(classBuilder, it));
        this.optionMethod(OptionMethodType.BUILDER_SETTER_CHAR_ARRAY).ifPresent(it -> Utils.addGeneratedMethod(classBuilder, it));
        this.optionMethod(OptionMethodType.BUILDER_SETTER_DECLARED).ifPresent(it -> Utils.addGeneratedMethod(classBuilder, it));
        this.optionMethod(OptionMethodType.BUILDER_SETTER_RUNTIME_TYPE_PROTOTYPE).ifPresent(it -> Utils.addGeneratedMethod(classBuilder, it));
        this.optionMethod(OptionMethodType.BUILDER_SETTER_CONSUMER).ifPresent(it -> Utils.addGeneratedMethod(classBuilder, it));
        this.optionMethod(OptionMethodType.BUILDER_SETTER_SUPPLIER).ifPresent(it -> Utils.addGeneratedMethod(classBuilder, it));
        this.optionMethod(OptionMethodType.BUILDER_ADD_COLLECTION).ifPresent(it -> Utils.addGeneratedMethod(classBuilder, it));
        this.optionMethod(OptionMethodType.BUILDER_SINGULAR_ADD_TO_MAP_VALUE).ifPresent(it -> Utils.addGeneratedMethod(classBuilder, it));
        this.optionMethod(OptionMethodType.BUILDER_SINGULAR_ADD_TO_MAP_VALUES).ifPresent(it -> Utils.addGeneratedMethod(classBuilder, it));
        this.optionMethod(OptionMethodType.BUILDER_SINGULAR_ADD).ifPresent(it -> Utils.addGeneratedMethod(classBuilder, it));
        this.optionMethod(OptionMethodType.BUILDER_SINGULAR_ADD_CONSUMER).ifPresent(it -> Utils.addGeneratedMethod(classBuilder, it));
    }

    @Override
    public void generateFromConfig(Method.Builder method, OptionConfigured optionConfigured) {
        method.addContent(this.configGet(optionConfigured));
        String fqName = this.type().fqName();
        String setterName = this.option().setterName();
        if (fqName.endsWith(".Builder")) {
            if (this.option().defaultValue().isPresent()) {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(".as(")).addContent(Types.CONFIG)).addContent(".class).ifPresent(")).addContent(this.option().name())).addContentLine("::config);");
            } else {
                int lastDot = fqName.lastIndexOf(46);
                String builderMethod = fqName.substring(0, lastDot) + ".builder()";
                method.addContentLine(".as(" + builderMethod + "::config).ifPresent(this::" + setterName + ");");
            }
        } else {
            Optional<FactoryMethod> factoryMethod = optionConfigured.factoryMethod();
            if (factoryMethod.isPresent()) {
                this.generateFromConfig((ContentBuilder<?>)method, factoryMethod.get());
            } else {
                boolean configured = false;
                if (this.option().runtimeType().isPresent()) {
                    RuntimeTypeInfo runtimeTypeInfo = this.option().runtimeType().get();
                    OptionBuilder optionBuilder = runtimeTypeInfo.optionBuilder();
                    this.generateFromConfig((ContentBuilder<?>)method, ((FactoryMethod.Builder)((FactoryMethod.Builder)((FactoryMethod.Builder)((FactoryMethod.Builder)FactoryMethod.builder().parameterType(Types.COMMON_CONFIG)).methodName("create")).declaringType(optionBuilder.builderMethodType())).returnType(this.type())).build());
                    configured = true;
                }
                if (!configured) {
                    this.generateFromConfig((ContentBuilder<?>)method);
                }
            }
            method.addContentLine(".ifPresent(this::" + setterName + ");");
        }
    }

    public String toString() {
        return this.option().declaredType().fqName() + " " + this.option().name();
    }

    @Override
    public boolean builderGetterOptional() {
        boolean required = this.option().required();
        boolean hasDefault = this.option().defaultValue().isPresent();
        if (this.option().declaredType().isList() || this.option().declaredType().isMap() || this.option().declaredType().isSet()) {
            return false;
        }
        if (this.option().declaredType().isOptional()) {
            return true;
        }
        if (!required && this.option().declaredType().primitive()) {
            return false;
        }
        return !hasDefault;
    }

    @Override
    public void fromBuilderAssignment(ContentBuilder<?> contentBuilder) {
        if (this.type().equals((Object)Types.CONFIG) || this.type().equals((Object)Types.COMMON_CONFIG)) {
            if (this.type().equals((Object)Types.COMMON_CONFIG)) {
                if (this.builderGetterOptional()) {
                    contentBuilder.addContent("this.config = builder.").addContent(this.option().getterName()).addContent("().map(").addContent(Types.CONFIG).addContentLine("::config).orElse(this.config);");
                } else {
                    contentBuilder.addContentLine("this.config = ").addContent(Types.CONFIG).addContentLine(".config(builder.").addContent(this.option().getterName()).addContentLine("());");
                }
            } else if (this.builderGetterOptional()) {
                contentBuilder.addContent("this.config = builder.").addContent(this.option().getterName()).addContentLine("().orElse(this.config);");
            } else {
                contentBuilder.addContent("this.config = builder.").addContent(this.option().getterName()).addContentLine("();");
            }
            return;
        }
        if (this.builderGetterOptional()) {
            contentBuilder.addContent("builder.").addContent(this.option().getterName()).addContentLine("().ifPresent(this::" + this.option().setterName() + ");");
        } else {
            contentBuilder.addContent(this.option().setterName()).addContent("(builder.").addContent(this.option().getterName()).addContentLine("());");
        }
    }

    @Override
    public void fromPrototypeAssignment(ContentBuilder<?> contentBuilder) {
        if (this.option().builderOptionOnly()) {
            return;
        }
        if (this.type().equals((Object)Types.CONFIG) || this.type().equals((Object)Types.COMMON_CONFIG)) {
            if (this.type().equals((Object)Types.COMMON_CONFIG)) {
                if (this.option().declaredType().isOptional()) {
                    contentBuilder.addContentLine("this.config = prototype.config().map(").addContent(Types.CONFIG).addContentLine("::config).orElse(null);");
                } else {
                    contentBuilder.addContentLine("this.config = ").addContent(Types.CONFIG).addContentLine(".config(prototype.config());");
                }
            } else if (this.option().declaredType().isOptional()) {
                contentBuilder.addContentLine("this.config = prototype.config().orElse(null);");
            } else {
                contentBuilder.addContentLine("this.config = prototype.config();");
            }
            return;
        }
        contentBuilder.addContent(this.option().setterName()).addContent("(prototype.").addContent(this.option().getterName()).addContentLine("());");
        if (this.option().provider().isPresent()) {
            contentBuilder.addContent("this.").addContent(this.option().name() + "DiscoverServices").addContentLine(" = false;");
        }
    }

    Field.Builder field(boolean isBuilder) {
        Field.Builder field = ((Field.Builder)Field.builder().name(this.option().name())).isFinal(!isBuilder);
        if (isBuilder && this.option().required()) {
            field.type(this.option().declaredType().boxed());
        } else {
            field.type(this.option().declaredType());
        }
        if (isBuilder && this.option().defaultValue().isPresent()) {
            this.option().defaultValue().get().accept((ContentBuilder<?>)field);
        }
        return field;
    }

    void prepareMethods() {
        Javadoc getterJavadoc = this.deprecation(this.getterJavadoc());
        this.generatedMethod(OptionMethodType.PROTOTYPE_GETTER, this.preparePrototypeGetter(getterJavadoc));
        this.generatedMethod(OptionMethodType.IMPL_GETTER, this.prepareImplGetter());
        this.generatedMethod(OptionMethodType.BUILDER_GETTER, Optional.of(this.prepareBuilderGetter(getterJavadoc)));
        this.generatedMethod(OptionMethodType.BUILDER_SETTER, Optional.of(this.prepareBuilderSetter(getterJavadoc)));
        this.generatedMethod(OptionMethodType.BUILDER_SETTER_CHAR_ARRAY, this.prepareBuilderSetterCharArray(getterJavadoc));
        this.generatedMethod(OptionMethodType.BUILDER_SETTER_DECLARED, this.prepareBuilderSetterDeclared(getterJavadoc));
        this.generatedMethod(OptionMethodType.BUILDER_ADD_COLLECTION, this.prepareBuilderAddCollection(getterJavadoc));
        this.generatedMethod(OptionMethodType.BUILDER_CLEAR, this.prepareBuilderClear(getterJavadoc));
        this.generatedMethod(OptionMethodType.BUILDER_SINGULAR_ADD, this.prepareBuilderSingularAdd(getterJavadoc));
        this.generatedMethod(OptionMethodType.BUILDER_SINGULAR_ADD_CONSUMER, this.prepareBuilderSingularAddConsumer(getterJavadoc));
        this.generatedMethod(OptionMethodType.BUILDER_SINGULAR_ADD_TO_MAP_VALUE, this.prepareBuilderSingularAddToMapValue(getterJavadoc));
        this.generatedMethod(OptionMethodType.BUILDER_SINGULAR_ADD_TO_MAP_VALUES, this.prepareBuilderSingularAddToMapValues(getterJavadoc));
        this.generatedMethod(OptionMethodType.BUILDER_SETTER_CONSUMER, this.prepareSetterConsumer(getterJavadoc));
        this.generatedMethod(OptionMethodType.BUILDER_SETTER_RUNTIME_TYPE_PROTOTYPE, this.prepareSetterPrototypeOfRuntimeType(getterJavadoc));
        this.generatedMethod(OptionMethodType.BUILDER_SETTER_SUPPLIER, this.prepareSetterSupplier(getterJavadoc));
    }

    TypeName asTypeArgument(TypeName topLevel) {
        return ((TypeName.Builder)TypeName.builder((TypeName)topLevel).addTypeArgument(Utils.toWildcard(this.type()))).build();
    }

    TypeName builderGetterType() {
        return this.type();
    }

    GeneratedMethod prepareBuilderGetter(Javadoc javadoc) {
        TypeName returnType = this.builderGetterOptional() ? (this.option().declaredType().isOptional() ? this.option().declaredType() : ((TypeName.Builder)TypeName.builder((TypeName)TypeNames.OPTIONAL).addTypeArgument(this.builderGetterType().boxed())).build()) : this.option().declaredType();
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName(this.option().getterName())).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            it.addContent("return ");
            if (this.builderGetterOptional()) {
                it.addContent(Optional.class).addContent(".ofNullable(").addContent(this.option().name()).addContent(")");
            } else {
                it.addContent(this.option().name());
            }
            it.addContentLine(";");
        };
        return ((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(javadoc)).contentBuilder(contentConsumer)).build();
    }

    GeneratedMethod prepareBuilderSetter(Javadoc getterJavadoc) {
        TypeName typeName = this.type();
        if (typeName.equals((Object)Types.CHAR_ARRAY)) {
            return this.stringSetterForCharArrayBuilderSetter(getterJavadoc);
        }
        return this.realDeclaredBuilderSetter(getterJavadoc);
    }

    GeneratedMethod realDeclaredBuilderSetter(Javadoc getterJavadoc) {
        TypeName typeName = this.type();
        TypeName returnType = Utils.builderReturnType();
        String name = this.option().name();
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName(this.option().setterName())).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(typeName.unboxed())).elementName(name));
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            if (!typeName.unboxed().primitive()) {
                it.addContent(Objects.class).addContentLine(".requireNonNull(" + name + ");");
            }
            this.option().decorator().ifPresent(decorator -> {
                it.addContent("new ").addContent(decorator).addContent("().decorate(this, ");
                this.decorateValue((ContentBuilder<?>)it, name);
                it.addContentLine(");");
            });
            it.addContentLine("this." + name + " = " + name + ";");
            it.addContentLine("return self();");
        };
        return ((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(this.setterJavadoc(getterJavadoc, name, ""))).contentBuilder(contentConsumer)).build();
    }

    void decorateValue(ContentBuilder<?> contentBuilder, String optionName) {
        contentBuilder.addContent(optionName);
    }

    Optional<GeneratedMethod> prepareBuilderSetterCharArray(Javadoc getterJavadoc) {
        TypeName typeName = this.type();
        if (!typeName.equals((Object)Types.CHAR_ARRAY)) {
            return Optional.empty();
        }
        return Optional.of(this.realDeclaredBuilderSetter(getterJavadoc));
    }

    Optional<GeneratedMethod> prepareBuilderSetterDeclared(Javadoc getterJavadoc) {
        return Optional.empty();
    }

    Optional<GeneratedMethod> prepareBuilderAddCollection(Javadoc getterJavadoc) {
        return Optional.empty();
    }

    Optional<GeneratedMethod> prepareBuilderClear(Javadoc getterJavadoc) {
        return Optional.empty();
    }

    Optional<GeneratedMethod> prepareBuilderSingularAdd(Javadoc getterJavadoc) {
        return Optional.empty();
    }

    Optional<GeneratedMethod> prepareBuilderSingularAddConsumer(Javadoc getterJavadoc) {
        return Optional.empty();
    }

    Optional<GeneratedMethod> prepareBuilderSingularAddToMapValue(Javadoc getterJavadoc) {
        return Optional.empty();
    }

    Optional<GeneratedMethod> prepareBuilderSingularAddToMapValues(Javadoc getterJavadoc) {
        return Optional.empty();
    }

    Optional<GeneratedMethod> prepareSetterPrototypeOfRuntimeType(Javadoc getterJavadoc) {
        if (this.option().runtimeType().isEmpty()) {
            return Optional.empty();
        }
        RuntimeTypeInfo rti = this.option().runtimeType().get();
        OptionBuilder optionBuilder = rti.optionBuilder();
        Optional<FactoryMethod> factoryMethod = rti.factoryMethod();
        String optionName = this.option().name();
        Javadoc javadoc = this.setterJavadoc(getterJavadoc, optionName, "prototype of ");
        TypedElementInfo.Builder method = this.setterMethodBuilder(optionBuilder.builderMethodType(), optionName);
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            it.addContent(Objects.class).addContentLine(".requireNonNull(" + optionName + ");").addContent(this.option().setterName()).addContent("(");
            factoryMethod.ifPresent(fm -> it.addContent(fm.declaringType().genericTypeName()).addContent(".").addContent(fm.methodName()).addContent("("));
            it.addContent(optionName);
            if (factoryMethod.isPresent()) {
                it.addContent(")");
            } else {
                it.addContent(".build()");
            }
            it.addContentLine(");");
            it.addContentLine("return self();");
        };
        return Optional.of(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(javadoc)).contentBuilder(contentConsumer)).build());
    }

    Optional<GeneratedMethod> prepareSetterConsumer(Javadoc getterJavadoc) {
        if (this.option().builderInfo().isEmpty() && this.option().runtimeType().isEmpty() && !this.option().declaredType().fqName().endsWith(".Builder")) {
            return Optional.empty();
        }
        if (this.option().runtimeType().isPresent()) {
            RuntimeTypeInfo rti = this.option().runtimeType().get();
            OptionBuilder optionBuilder = rti.optionBuilder();
            Optional<FactoryMethod> factoryMethod = rti.factoryMethod();
            Javadoc javadoc = this.setterJavadoc(getterJavadoc, "consumer", "consumer of builder of ");
            TypedElementInfo.Builder method = this.setterMethodBuilder(((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(optionBuilder.builderType())).build(), "consumer");
            Consumer<ContentBuilder<?>> contentConsumer = it -> {
                it.addContent(Objects.class).addContentLine(".requireNonNull(consumer);").addContent("var builder = ");
                if (optionBuilder.builderMethodName().equals("<init>")) {
                    it.addContent("new ").addContent(optionBuilder.builderType()).addContentLine("();");
                } else {
                    it.addContent(optionBuilder.builderMethodType()).addContentLine("." + optionBuilder.builderMethodName() + "();");
                }
                it.addContentLine("consumer.accept(builder);").addContent("this." + this.option().setterName() + "(");
                factoryMethod.ifPresent(fm -> it.addContent(fm.declaringType().genericTypeName()).addContent(".").addContent(fm.methodName()).addContent("("));
                it.addContent("builder.").addContent(optionBuilder.buildMethodName()).addContent("()");
                factoryMethod.ifPresent(f -> it.addContent(")"));
                it.addContentLine(");");
                it.addContentLine("return self();");
            };
            return Optional.of(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(javadoc)).contentBuilder(contentConsumer)).build());
        }
        if (this.option().builderInfo().isPresent()) {
            OptionBuilder optionBuilder = this.option().builderInfo().get();
            Javadoc javadoc = this.setterJavadoc(getterJavadoc, "consumer", "consumer of builder of ");
            TypedElementInfo.Builder method = this.setterMethodBuilder(((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(optionBuilder.builderType())).build(), "consumer");
            Consumer<ContentBuilder<?>> contentConsumer = it -> {
                it.addContent(Objects.class).addContentLine(".requireNonNull(consumer);").addContent("var builder = ");
                if (optionBuilder.builderMethodName().equals("<init>")) {
                    it.addContent("new ").addContent(optionBuilder.builderType()).addContentLine("();");
                } else {
                    it.addContent(optionBuilder.builderMethodType()).addContentLine("." + optionBuilder.builderMethodName() + "();");
                }
                it.addContentLine("consumer.accept(builder);").addContent("this." + this.option().setterName() + "(builder.").addContent(optionBuilder.buildMethodName()).addContentLine("());").addContentLine("return self();");
            };
            return Optional.of(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(javadoc)).contentBuilder(contentConsumer)).build());
        }
        Javadoc javadoc = Javadoc.builder((Javadoc)this.setterJavadoc(getterJavadoc, "consumer", "consumer of ")).parameters(Map.of()).build();
        TypedElementInfo.Builder method = this.setterMethodBuilder(((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(this.type())).build(), "consumer");
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            it.addContent(Objects.class).addContentLine(".requireNonNull(consumer);").addContent("var builder = ");
            if (this.option().defaultValue().isPresent()) {
                it.addContentLine("this." + this.option().name() + ";");
            } else {
                String fqName = this.option().declaredType().fqName();
                int lastDot = fqName.lastIndexOf(46);
                String builderMethod = fqName.substring(0, lastDot) + ".builder()";
                it.addContentLine(builderMethod + ";");
            }
            it.addContentLine("consumer.accept(builder);").addContentLine("this." + this.option().setterName() + "(builder);").addContentLine("return self();");
        };
        return Optional.of(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(javadoc)).contentBuilder(contentConsumer)).build());
    }

    Optional<GeneratedMethod> prepareSetterSupplier(Javadoc getterJavadoc) {
        if (this.option().builderInfo().isEmpty()) {
            return Optional.empty();
        }
        Javadoc javadoc = this.setterJavadoc(getterJavadoc, "supplier", "supplier of ");
        TypedElementInfo.Builder method = this.setterMethodBuilder(this.asTypeArgument(TypeNames.SUPPLIER), "supplier");
        Consumer<ContentBuilder<?>> contentConsumer = it -> it.addContent(Objects.class).addContentLine(".requireNonNull(supplier);").addContent("this.").addContent(this.option().setterName()).addContentLine("(supplier.get());").addContentLine("return self();");
        return Optional.of(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(javadoc)).contentBuilder(contentConsumer)).build());
    }

    void generateFromConfig(ContentBuilder<?> content) {
        TypeName usedType = this.type();
        if (usedType.fqName().equals("char[]")) {
            content.addContent(".asString().as(").addContent(String.class).addContent("::toCharArray)");
            return;
        }
        if (usedType.equals((Object)TypeNames.STRING)) {
            content.addContent(".asString()");
            return;
        }
        if (usedType.boxed().equals((Object)TypeNames.BOXED_INT)) {
            content.addContent(".asInt()");
            return;
        }
        if (usedType.boxed().equals((Object)TypeNames.BOXED_DOUBLE)) {
            content.addContent(".asDouble()");
            return;
        }
        if (usedType.boxed().equals((Object)TypeNames.BOXED_BOOLEAN)) {
            content.addContent(".asBoolean()");
            return;
        }
        if (usedType.boxed().equals((Object)TypeNames.BOXED_LONG)) {
            content.addContent(".asLong()");
            return;
        }
        content.addContent(".as(").addContent(this.type().boxed().genericTypeName()).addContent(".class)");
    }

    void generateFromConfig(ContentBuilder<?> content, FactoryMethod factoryMethod) {
        if (this.type().fqName().equals("char[]")) {
            content.addContent(".asString().as(").addContent(String.class).addContent("::toCharArray)");
            return;
        }
        content.addContent(".as(").addContent(factoryMethod.declaringType().genericTypeName()).addContent("::");
        if (!this.type().typeArguments().isEmpty()) {
            content.addContent("<");
            Iterator iterator = this.type().typeArguments().iterator();
            while (iterator.hasNext()) {
                content.addContent((TypeName)iterator.next());
                if (!iterator.hasNext()) continue;
                content.addContent(", ");
            }
            content.addContent(">");
        }
        content.addContent(factoryMethod.methodName()).addContent(")");
    }

    String configGet(OptionConfigured configured) {
        if (configured.merge()) {
            return "config";
        }
        return "config.get(\"" + configured.configKey() + "\")";
    }

    OptionInfo option() {
        return this.option;
    }

    PrototypeInfo prototype() {
        return this.prototypeInfo;
    }

    void deprecation(TypedElementInfo.Builder method) {
        if (this.option().deprecation().isEmpty()) {
            return;
        }
        OptionDeprecation deprecation = this.option().deprecation().get();
        Optional<String> since = deprecation.since();
        boolean forRemoval = deprecation.forRemoval();
        Annotation.Builder builder = (Annotation.Builder)Annotation.builder().typeName(TypeName.create(Deprecated.class));
        since.ifPresent(it -> builder.putValue("since", it));
        if (forRemoval) {
            builder.putValue("forRemoval", (Object)true);
        }
        method.addAnnotation(builder.build());
    }

    Javadoc deprecation(Javadoc javadoc) {
        if (this.option().deprecation().isEmpty()) {
            return javadoc;
        }
        OptionDeprecation deprecation = this.option().deprecation().get();
        String message = deprecation.message();
        Optional<String> alternative = deprecation.alternative();
        Javadoc.Builder javadocBuilder = Javadoc.builder((Javadoc)javadoc);
        if (alternative.isPresent()) {
            javadocBuilder.deprecation(message + ", use {@link #" + alternative.get() + "} instead");
        } else {
            javadocBuilder.deprecation(message);
        }
        return javadocBuilder.build();
    }

    Javadoc setterJavadoc(Javadoc getterJavadoc, String parameterName, String paramDescriptionPrefix) {
        return Javadoc.builder((Javadoc)getterJavadoc).addParameter(parameterName, paramDescriptionPrefix + String.join((CharSequence)"\n", getterJavadoc.returnDescription())).returnDescription("updated builder instance").addTag("see", "#" + this.option().getterName() + "()").build();
    }

    GeneratedMethod stringSetterForCharArrayBuilderSetter(Javadoc getterJavadoc) {
        TypeName typeName = TypeNames.STRING;
        TypeName returnType = Utils.builderReturnType();
        String name = this.option().name();
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(returnType)).elementName(this.option().setterName())).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(typeName)).elementName(name));
        Consumer<ContentBuilder<?>> contentConsumer = it -> {
            if (!typeName.primitive()) {
                it.addContent(Objects.class).addContentLine(".requireNonNull(" + name + ");");
            }
            it.addContentLine("this." + this.option().setterName() + "(" + name + ".toCharArray());");
            it.addContentLine("return self();");
        };
        return ((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(this.setterJavadoc(getterJavadoc, name, ""))).contentBuilder(contentConsumer)).build();
    }

    private TypedElementInfo.Builder setterMethodBuilder(TypeName paramType, String paramName) {
        TypedElementInfo.Builder method = this.methodBuilderNoParam();
        method.addParameterArgument(param -> ((TypedElementInfo.Builder)((TypedElementInfo.Builder)param.kind(ElementKind.PARAMETER)).typeName(paramType)).elementName(paramName));
        return method;
    }

    private TypedElementInfo.Builder methodBuilderNoParam() {
        return (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(this.option().accessModifier())).typeName(Utils.builderReturnType())).elementName(this.option().setterName())).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
    }

    private Optional<GeneratedMethod> prepareImplGetter() {
        if (this.option().builderOptionOnly()) {
            return Optional.empty();
        }
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(AccessModifier.PUBLIC)).typeName(this.option().declaredType())).elementName(this.option().getterName())).addAnnotation(Annotations.OVERRIDE)).update(this::deprecation)).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)));
        return Optional.of(((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).contentBuilder(it -> it.addContentLine("return " + this.option().name() + ";"))).build());
    }

    private Optional<GeneratedMethod> preparePrototypeGetter(Javadoc javadoc) {
        Consumer<ContentBuilder<?>> contentConsumer;
        TypeName declaringType;
        if (this.option().builderOptionOnly()) {
            return Optional.empty();
        }
        boolean override = false;
        if (this.option().declaringType().isPresent()) {
            TypeInfo declaringType2 = this.option().declaringType().get();
            if (this.isBlueprint(declaringType2)) {
                override = !this.prototypeInfo.detachBlueprint();
            } else {
                if (declaringType2.accessModifier() == AccessModifier.PUBLIC) {
                    return Optional.empty();
                }
                override = true;
            }
        }
        boolean callSuper = false;
        if (override) {
            TypedElementInfo interfaceMethod;
            TypeName tmpDeclaringType = null;
            if (this.option().interfaceMethod().isPresent() && (interfaceMethod = this.option().interfaceMethod().get()).elementModifiers().contains(Modifier.DEFAULT)) {
                tmpDeclaringType = interfaceMethod.enclosingType().orElse(null);
                callSuper = tmpDeclaringType != null;
            }
            declaringType = tmpDeclaringType;
        } else {
            declaringType = null;
        }
        TypedElementInfo.Builder method = (TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)((TypedElementInfo.Builder)TypedElementInfo.builder().kind(ElementKind.METHOD)).accessModifier(AccessModifier.PUBLIC)).typeName(this.option().declaredType())).elementName(this.option().getterName())).update(it -> this.option().annotations().forEach(arg_0 -> ((TypedElementInfo.Builder)it).addAnnotation(arg_0)))).update(this::deprecation);
        if (override) {
            method.addAnnotation(Annotations.OVERRIDE);
        }
        if (callSuper) {
            method.addElementModifier(Modifier.DEFAULT);
            contentConsumer = it -> it.addContent("return ").addContent(declaringType).addContent(".super.").addContent(this.option().getterName()).addContentLine("();");
        } else {
            contentConsumer = it -> {};
        }
        return Optional.of(((GeneratedMethod.Builder)((GeneratedMethod.Builder)((GeneratedMethod.Builder)GeneratedMethod.builder().method(method.build())).javadoc(javadoc)).contentBuilder(contentConsumer)).build());
    }

    private Javadoc getterJavadoc() {
        Javadoc getterJavadoc = this.option().interfaceMethod().isPresent() && this.option().interfaceMethod().get().description().isPresent() && !((String)this.option().interfaceMethod().get().description().get()).isBlank() ? Javadoc.parse((String)((String)this.option().interfaceMethod().get().description().get())) : (this.option.interfaceMethod().isPresent() && this.option.declaringType().isPresent() && this.option.declaringType().get().accessModifier() == AccessModifier.PUBLIC ? Javadoc.builder().add(CodegenUtil.capitalize((String)this.option().name()) + " option. Defined in {@link " + this.option.declaringType().get().typeName().fqName() + "#" + this.option.interfaceMethod().get().elementName() + "()}").returnDescription("the " + this.option().name() + " option").build() : Javadoc.builder().add(CodegenUtil.capitalize((String)this.option().name()) + " option.").returnDescription("the " + this.option().name() + " option").build());
        Javadoc.Builder builder = Javadoc.builder((Javadoc)getterJavadoc);
        this.option().description().ifPresent(it -> builder.content(List.of(it.split("\n"))));
        this.option().paramDescription().ifPresent(arg_0 -> ((Javadoc.Builder)builder).returnDescription(arg_0));
        return builder.build();
    }

    private boolean isBlueprint(TypeInfo declaringType) {
        return declaringType.hasAnnotation(Types.PROTOTYPE_BLUEPRINT);
    }

    private void generatedMethod(OptionMethodType type, Optional<GeneratedMethod> generatedMethod) {
        generatedMethod.flatMap(method -> this.extensions(type, (GeneratedMethod)method)).ifPresent(method -> this.generatedMethods.put(type, (GeneratedMethod)method));
    }

    private Optional<GeneratedMethod> extensions(OptionMethodType type, GeneratedMethod method) {
        GeneratedMethod result = method;
        for (BuilderCodegenExtension extension : this.extensions) {
            result = extension.method(this.option(), result, type).orElse(null);
            if (result != null) continue;
            return Optional.empty();
        }
        return Optional.of(result);
    }
}

