/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import java.util.Objects;
import java.util.Optional;

public interface OptionSingular
extends Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OptionSingular instance) {
        return (Builder)OptionSingular.builder().from(instance);
    }

    public String name();

    public String methodName();

    public static class Builder
    extends BuilderBase<Builder, OptionSingular>
    implements io.helidon.common.Builder<Builder, OptionSingular> {
        private Builder() {
        }

        public OptionSingular buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.OptionSingularImpl(this);
        }

        public OptionSingular build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends OptionSingular>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private String methodName;
        private String name;

        protected BuilderBase() {
        }

        public BUILDER from(OptionSingular prototype) {
            this.name(prototype.name());
            this.methodName(prototype.methodName());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.name().ifPresent(this::name);
            builder.methodName().ifPresent(this::methodName);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER name(String name) {
            Objects.requireNonNull(name);
            this.name = name;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER methodName(String methodName) {
            Objects.requireNonNull(methodName);
            this.methodName = methodName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> name() {
            return Optional.ofNullable(this.name);
        }

        public Optional<String> methodName() {
            return Optional.ofNullable(this.methodName);
        }

        public String toString() {
            return "OptionSingularBuilder{name=" + this.name + ",methodName=" + this.methodName + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.name == null) {
                collector.fatal(this.getClass(), "Property \"name\" must not be null, but not set");
            }
            if (this.methodName == null) {
                collector.fatal(this.getClass(), "Property \"methodName\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class OptionSingularImpl
        implements OptionSingular {
            private final String methodName;
            private final String name;

            protected OptionSingularImpl(BuilderBase<?, ?> builder) {
                this.name = builder.name().get();
                this.methodName = builder.methodName().get();
            }

            @Override
            public String name() {
                return this.name;
            }

            @Override
            public String methodName() {
                return this.methodName;
            }

            public String toString() {
                return "OptionSingular{name=" + this.name + ",methodName=" + this.methodName + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OptionSingular)) {
                    return false;
                }
                OptionSingular other = (OptionSingular)o;
                return Objects.equals(this.name, other.name()) && Objects.equals(this.methodName, other.methodName());
            }

            public int hashCode() {
                return Objects.hash(this.name, this.methodName);
            }
        }
    }
}

