/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.api.Prototype;
import io.helidon.builder.codegen.FactoryMethod;
import io.helidon.common.Errors;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface OptionConfigured
extends Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OptionConfigured instance) {
        return (Builder)OptionConfigured.builder().from(instance);
    }

    public String configKey();

    public boolean merge();

    public boolean traverse();

    public Optional<FactoryMethod> factoryMethod();

    public static class Builder
    extends BuilderBase<Builder, OptionConfigured>
    implements io.helidon.common.Builder<Builder, OptionConfigured> {
        private Builder() {
        }

        public OptionConfigured buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.OptionConfiguredImpl(this);
        }

        public OptionConfigured build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends OptionConfigured>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private boolean merge = false;
        private boolean traverse = true;
        private FactoryMethod factoryMethod;
        private String configKey;

        protected BuilderBase() {
        }

        public BUILDER from(OptionConfigured prototype) {
            this.configKey(prototype.configKey());
            this.merge(prototype.merge());
            this.traverse(prototype.traverse());
            this.factoryMethod(prototype.factoryMethod());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            builder.configKey().ifPresent(this::configKey);
            this.merge(builder.merge());
            this.traverse(builder.traverse());
            builder.factoryMethod().ifPresent(this::factoryMethod);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER configKey(String configKey) {
            Objects.requireNonNull(configKey);
            this.configKey = configKey;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER merge(boolean merge) {
            this.merge = merge;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER traverse(boolean traverse) {
            this.traverse = traverse;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER clearFactoryMethod() {
            this.factoryMethod = null;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER factoryMethod(FactoryMethod factoryMethod) {
            Objects.requireNonNull(factoryMethod);
            this.factoryMethod = factoryMethod;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER factoryMethod(Consumer<FactoryMethod.Builder> consumer) {
            Objects.requireNonNull(consumer);
            FactoryMethod.Builder builder = FactoryMethod.builder();
            consumer.accept(builder);
            this.factoryMethod(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER factoryMethod(Supplier<? extends FactoryMethod> supplier) {
            Objects.requireNonNull(supplier);
            this.factoryMethod(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public Optional<String> configKey() {
            return Optional.ofNullable(this.configKey);
        }

        public boolean merge() {
            return this.merge;
        }

        public boolean traverse() {
            return this.traverse;
        }

        public Optional<FactoryMethod> factoryMethod() {
            return Optional.ofNullable(this.factoryMethod);
        }

        public String toString() {
            return "OptionConfiguredBuilder{configKey=" + this.configKey + ",merge=" + this.merge + ",traverse=" + this.traverse + ",factoryMethod=" + String.valueOf(this.factoryMethod) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.configKey == null) {
                collector.fatal(this.getClass(), "Property \"configKey\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        BUILDER factoryMethod(Optional<? extends FactoryMethod> factoryMethod) {
            Objects.requireNonNull(factoryMethod);
            this.factoryMethod = factoryMethod.map(FactoryMethod.class::cast).orElse(this.factoryMethod);
            return (BUILDER)((BuilderBase)this.self());
        }

        protected static class OptionConfiguredImpl
        implements OptionConfigured {
            private final boolean merge;
            private final boolean traverse;
            private final Optional<FactoryMethod> factoryMethod;
            private final String configKey;

            protected OptionConfiguredImpl(BuilderBase<?, ?> builder) {
                this.configKey = builder.configKey().get();
                this.merge = builder.merge();
                this.traverse = builder.traverse();
                this.factoryMethod = builder.factoryMethod().map(Function.identity());
            }

            @Override
            public String configKey() {
                return this.configKey;
            }

            @Override
            public boolean merge() {
                return this.merge;
            }

            @Override
            public boolean traverse() {
                return this.traverse;
            }

            @Override
            public Optional<FactoryMethod> factoryMethod() {
                return this.factoryMethod;
            }

            public String toString() {
                return "OptionConfigured{configKey=" + this.configKey + ",merge=" + this.merge + ",traverse=" + this.traverse + ",factoryMethod=" + String.valueOf(this.factoryMethod) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OptionConfigured)) {
                    return false;
                }
                OptionConfigured other = (OptionConfigured)o;
                return Objects.equals(this.configKey, other.configKey()) && this.merge == other.merge() && this.traverse == other.traverse() && Objects.equals(this.factoryMethod, other.factoryMethod());
            }

            public int hashCode() {
                return Objects.hash(this.configKey, this.merge, this.traverse, this.factoryMethod);
            }
        }
    }
}

