/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.types.TypeName;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface OptionBuilder
extends Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(OptionBuilder instance) {
        return (Builder)OptionBuilder.builder().from(instance);
    }

    public String builderMethodName();

    public TypeName builderType();

    public TypeName builderMethodType();

    public String buildMethodName();

    public static class Builder
    extends BuilderBase<Builder, OptionBuilder>
    implements io.helidon.common.Builder<Builder, OptionBuilder> {
        private Builder() {
        }

        public OptionBuilder buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.OptionBuilderImpl(this);
        }

        public OptionBuilder build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends OptionBuilder>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private String buildMethodName = "build";
        private String builderMethodName = "builder";
        private TypeName builderMethodType;
        private TypeName builderType;

        protected BuilderBase() {
        }

        public BUILDER from(OptionBuilder prototype) {
            this.builderMethodName(prototype.builderMethodName());
            this.builderType(prototype.builderType());
            this.builderMethodType(prototype.builderMethodType());
            this.buildMethodName(prototype.buildMethodName());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.builderMethodName(builder.builderMethodName());
            builder.builderType().ifPresent(this::builderType);
            builder.builderMethodType().ifPresent(this::builderMethodType);
            this.buildMethodName(builder.buildMethodName());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderMethodName(String builderMethodName) {
            Objects.requireNonNull(builderMethodName);
            this.builderMethodName = builderMethodName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderType(TypeName builderType) {
            Objects.requireNonNull(builderType);
            this.builderType = builderType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.builderType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.builderType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderMethodType(TypeName builderMethodType) {
            Objects.requireNonNull(builderMethodType);
            this.builderMethodType = builderMethodType;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderMethodType(Consumer<TypeName.Builder> consumer) {
            Objects.requireNonNull(consumer);
            TypeName.Builder builder = TypeName.builder();
            consumer.accept(builder);
            this.builderMethodType(builder.build());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER builderMethodType(Supplier<? extends TypeName> supplier) {
            Objects.requireNonNull(supplier);
            this.builderMethodType(supplier.get());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER buildMethodName(String buildMethodName) {
            Objects.requireNonNull(buildMethodName);
            this.buildMethodName = buildMethodName;
            return (BUILDER)((BuilderBase)this.self());
        }

        public String builderMethodName() {
            return this.builderMethodName;
        }

        public Optional<TypeName> builderType() {
            return Optional.ofNullable(this.builderType);
        }

        public Optional<TypeName> builderMethodType() {
            return Optional.ofNullable(this.builderMethodType);
        }

        public String buildMethodName() {
            return this.buildMethodName;
        }

        public String toString() {
            return "OptionBuilderBuilder{builderMethodName=" + this.builderMethodName + ",builderType=" + String.valueOf(this.builderType) + ",builderMethodType=" + String.valueOf(this.builderMethodType) + ",buildMethodName=" + this.buildMethodName + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.builderType == null) {
                collector.fatal(this.getClass(), "Property \"builderType\" must not be null, but not set");
            }
            if (this.builderMethodType == null) {
                collector.fatal(this.getClass(), "Property \"builderMethodType\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class OptionBuilderImpl
        implements OptionBuilder {
            private final String buildMethodName;
            private final String builderMethodName;
            private final TypeName builderMethodType;
            private final TypeName builderType;

            protected OptionBuilderImpl(BuilderBase<?, ?> builder) {
                this.builderMethodName = builder.builderMethodName();
                this.builderType = builder.builderType().get();
                this.builderMethodType = builder.builderMethodType().get();
                this.buildMethodName = builder.buildMethodName();
            }

            @Override
            public String builderMethodName() {
                return this.builderMethodName;
            }

            @Override
            public TypeName builderType() {
                return this.builderType;
            }

            @Override
            public TypeName builderMethodType() {
                return this.builderMethodType;
            }

            @Override
            public String buildMethodName() {
                return this.buildMethodName;
            }

            public String toString() {
                return "OptionBuilder{builderMethodName=" + this.builderMethodName + ",builderType=" + String.valueOf(this.builderType) + ",builderMethodType=" + String.valueOf(this.builderMethodType) + ",buildMethodName=" + this.buildMethodName + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof OptionBuilder)) {
                    return false;
                }
                OptionBuilder other = (OptionBuilder)o;
                return Objects.equals(this.builderMethodName, other.builderMethodName()) && Objects.equals(this.builderType, other.builderType()) && Objects.equals(this.builderMethodType, other.builderMethodType()) && Objects.equals(this.buildMethodName, other.buildMethodName());
            }

            public int hashCode() {
                return Objects.hash(this.builderMethodName, this.builderType, this.builderMethodType, this.buildMethodName);
            }
        }
    }
}

