/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.DeprecatedFactoryMethod;
import io.helidon.builder.codegen.FactoryOption;
import io.helidon.builder.codegen.FactoryPrototypeInfo;
import io.helidon.builder.codegen.GenerateAbstractBuilder;
import io.helidon.builder.codegen.GenerateBuilder;
import io.helidon.builder.codegen.GeneratedMethod;
import io.helidon.builder.codegen.GeneratedMethods;
import io.helidon.builder.codegen.OptionConfigured;
import io.helidon.builder.codegen.OptionHandler;
import io.helidon.builder.codegen.OptionInfo;
import io.helidon.builder.codegen.OptionMethodType;
import io.helidon.builder.codegen.OptionProvider;
import io.helidon.builder.codegen.PrototypeConfigured;
import io.helidon.builder.codegen.PrototypeConstant;
import io.helidon.builder.codegen.PrototypeInfo;
import io.helidon.builder.codegen.Types;
import io.helidon.builder.codegen.Utils;
import io.helidon.builder.codegen.ValidationTask;
import io.helidon.builder.codegen.spi.BuilderCodegenExtension;
import io.helidon.builder.codegen.spi.BuilderCodegenExtensionProvider;
import io.helidon.codegen.CodegenContext;
import io.helidon.codegen.CodegenEvent;
import io.helidon.codegen.CodegenException;
import io.helidon.codegen.CodegenFiler;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.FilerTextResource;
import io.helidon.codegen.RoundContext;
import io.helidon.codegen.classmodel.ClassBase;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.codegen.spi.CodegenExtension;
import io.helidon.common.Errors;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.ElementKind;
import io.helidon.common.types.TypeInfo;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;

class BuilderCodegen
implements CodegenExtension {
    private static final TypeName GENERATOR = TypeName.create(BuilderCodegen.class);
    private final Set<TypeName> blueprintTypes = new HashSet<TypeName>();
    private final Set<String> serviceLoaderContracts = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private final CodegenContext ctx;
    private final List<BuilderCodegenExtensionProvider> extensions;

    BuilderCodegen(CodegenContext ctx) {
        this.ctx = ctx;
        this.extensions = HelidonServiceLoader.create(ServiceLoader.load(BuilderCodegenExtensionProvider.class, BuilderCodegen.class.getClassLoader())).asList();
    }

    static void generateCustomPrototypeMethods(ClassBase.Builder<?, ?> classModel, List<GeneratedMethod> customMethods, boolean implementation) {
        for (GeneratedMethod customMethod : customMethods) {
            if (BuilderCodegen.onlyImplMethod(customMethod)) {
                if (!implementation) continue;
                Utils.addGeneratedMethod(classModel, customMethod);
                continue;
            }
            if (implementation) continue;
            Utils.addGeneratedMethod(classModel, customMethod);
        }
    }

    public void process(RoundContext roundContext) {
        Collection blueprints = roundContext.annotatedTypes(Types.PROTOTYPE_BLUEPRINT);
        this.blueprintTypes.addAll(blueprints.stream().map(TypeInfo::typeName).toList());
        List<TypeInfo> blueprintInterfaces = blueprints.stream().filter(it -> it.kind() == ElementKind.INTERFACE).toList();
        for (TypeInfo blueprintInterface : blueprintInterfaces) {
            this.process(roundContext, blueprintInterface);
        }
    }

    public void processingOver(RoundContext roundContext) {
        this.process(roundContext);
        this.updateServiceLoaderResource();
        ArrayList<? extends ValidationTask> validationTasks = new ArrayList<ValidationTask>(this.addBlueprintsForValidation(roundContext, this.blueprintTypes));
        Errors.Collector collector = Errors.collector();
        for (ValidationTask validationTask : validationTasks) {
            validationTask.validate(collector);
        }
        Errors errors = collector.collect();
        if (errors.hasFatal()) {
            for (Errors.ErrorMessage error : errors) {
                CodegenEvent.Builder builder = (CodegenEvent.Builder)((CodegenEvent.Builder)CodegenEvent.builder().message(error.getMessage().replace('\n', ' '))).addObject(error.getSource());
                switch (error.getSeverity()) {
                    case FATAL: {
                        builder.level(System.Logger.Level.ERROR);
                        break;
                    }
                    case WARN: {
                        builder.level(System.Logger.Level.WARNING);
                        break;
                    }
                    case HINT: {
                        builder.level(System.Logger.Level.INFO);
                        break;
                    }
                    default: {
                        builder.level(System.Logger.Level.DEBUG);
                    }
                }
                this.ctx.logger().log(builder.build());
            }
        }
    }

    private static void addCreateDefaultMethod(List<OptionHandler> options, ClassModel.Builder classModel, PrototypeInfo prototype, String ifaceName, String typeArgumentString, List<TypeArgument> typeArguments) {
        boolean noRequired = BuilderCodegen.noRequired(options);
        if (noRequired || prototype.builderDecorator().isPresent()) {
            classModel.addMethod(builder -> {
                ((Method.Builder)((Method.Builder)builder.isStatic(true).name("create")).description("Create a new instance with default values.")).returnType(prototype.prototypeType(), "a new instance").addContentLine("return " + ifaceName + "." + typeArgumentString + "builder().buildPrototype();");
                typeArguments.forEach(arg_0 -> ((Method.Builder)builder).addGenericArgument(arg_0));
            });
        }
    }

    private static void addCreateFromConfigMethod(PrototypeConfigured configuredData, TypeName prototype, List<TypeArgument> typeArguments, String ifaceName, String typeArgumentString, ClassModel.Builder classModel) {
        Method.Builder method = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().accessModifier(configuredData.createAccessModifier())).name("create")).isStatic(true).description("Create a new instance from configuration.")).returnType(prototype, "a new instance configured from configuration").addParameter(paramBuilder -> ((Parameter.Builder)paramBuilder.type(Types.CONFIG).name("config")).description("used to configure the new instance"));
        typeArguments.forEach(arg_0 -> ((Method.Builder)method).addGenericArgument(arg_0));
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent("return ")).addContent(ifaceName)).addContent(".")).addContent(typeArgumentString)).addContentLine("builder()")).increaseContentPadding()).increaseContentPadding()).addContentLine(".config(config)")).addContentLine(".buildPrototype();")).decreaseContentPadding()).decreaseContentPadding();
        classModel.addMethod(method);
        Method.Builder commonMethod = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("create")).isStatic(true).returnType(prototype).addParameter(paramBuilder -> paramBuilder.type(Types.COMMON_CONFIG).name("config"))).javadoc(Javadoc.builder().add("Create a new instance from configuration.").returnDescription("a new instance configured from configuration").addParameter("config", "used to configure the new instance").addTag("deprecated", "use {@link #create(" + Types.CONFIG.fqName() + ")}").build())).addContent("return create(")).addContent(Types.CONFIG)).addContentLine(".config(config));")).addAnnotation(Annotations.DEPRECATED);
        typeArguments.forEach(arg_0 -> ((Method.Builder)commonMethod).addGenericArgument(arg_0));
        classModel.addMethod(commonMethod);
    }

    private static void addCopyBuilderMethod(ClassModel.Builder classModel, TypeName builderTypeName, TypeName prototype, List<TypeArgument> typeArguments, String ifaceName, String typeArgumentString) {
        classModel.addMethod(builder -> {
            ((Method.Builder)((Method.Builder)builder.isStatic(true).name("builder")).description("Create a new fluent API builder from an existing instance.")).returnType(builderTypeName, "a builder based on an instance").addParameter(paramBuilder -> ((Parameter.Builder)paramBuilder.type(prototype).name("instance")).description("an existing instance used as a base for the builder"));
            typeArguments.forEach(arg_0 -> ((Method.Builder)builder).addGenericArgument(arg_0));
            builder.addContentLine("return " + ifaceName + "." + typeArgumentString + "builder().from(instance);");
        });
    }

    private static void addBuilderMethod(ClassModel.Builder classModel, TypeName builderTypeName, List<TypeArgument> typeArguments, String ifaceName) {
        classModel.addMethod(builder -> {
            ((Method.Builder)((Method.Builder)builder.isStatic(true).name("builder")).description("Create a new fluent API builder to customize configuration.")).returnType(builderTypeName, "a new builder");
            typeArguments.forEach(arg_0 -> ((Method.Builder)builder).addGenericArgument(arg_0));
            if (typeArguments.isEmpty()) {
                builder.addContentLine("return new " + ifaceName + ".Builder();");
            } else {
                builder.addContentLine("return new " + ifaceName + ".Builder<>();");
            }
        });
    }

    private static void generateCustomConstant(ClassModel.Builder classModel, PrototypeConstant customConstant) {
        classModel.addField(constant -> ((Field.Builder)constant.type(customConstant.type()).name(customConstant.name())).javadoc(customConstant.javadoc()).update(customConstant.content()::accept));
    }

    private static void generateCustomMethods(ClassModel.Builder classModel, List<GeneratedMethod> customMethods) {
        for (GeneratedMethod customMethod : customMethods) {
            Utils.addGeneratedMethod(classModel, customMethod);
        }
    }

    private static boolean onlyImplMethod(GeneratedMethod customMethod) {
        TypedElementInfo method = customMethod.method();
        String methodName = method.elementName();
        List params = method.parameterArguments();
        if (methodName.equals("toString") || methodName.equals("hashCode")) {
            return params.isEmpty();
        }
        if (methodName.equals("equals")) {
            return params.size() == 1 && ((TypedElementInfo)params.getFirst()).typeName().equals((Object)TypeNames.OBJECT);
        }
        return false;
    }

    private static boolean noRequired(List<OptionHandler> options) {
        return options.stream().map(OptionHandler::option).noneMatch(OptionInfo::required);
    }

    private static boolean hasRegistryService(List<OptionInfo> options) {
        return options.stream().anyMatch(OptionInfo::registryService);
    }

    private void updateServiceLoaderResource() {
        String moduleName;
        String resourceLocation;
        CodegenFiler filer = this.ctx.filer();
        FilerTextResource serviceLoaderResource = filer.textResource(resourceLocation = "META-INF/helidon" + (String)((moduleName = (String)this.ctx.moduleName().orElse(null)) == null ? "" : "/" + moduleName) + "/service.loader", new Object[0]);
        ArrayList<String> lines = new ArrayList<String>(serviceLoaderResource.lines());
        if (lines.isEmpty()) {
            lines.add("# List of service contracts we want to support either from service registry, or from service loader");
        }
        boolean modified = false;
        for (String serviceLoaderContract : this.serviceLoaderContracts) {
            if (lines.contains(serviceLoaderContract)) continue;
            modified = true;
            lines.add(serviceLoaderContract);
        }
        if (modified) {
            serviceLoaderResource.lines(lines);
            serviceLoaderResource.write();
            filer.manifest().add(resourceLocation);
        }
    }

    private void process(RoundContext roundContext, TypeInfo blueprint) {
        PrototypeInfo tmpPrototypeInfo = FactoryPrototypeInfo.create(roundContext, blueprint);
        List<BuilderCodegenExtension> extensions = this.findExtensions(tmpPrototypeInfo);
        for (BuilderCodegenExtension extension : extensions) {
            tmpPrototypeInfo = extension.prototypeInfo(tmpPrototypeInfo);
        }
        List<OptionInfo> newOptions = new ArrayList<OptionInfo>();
        ArrayList<OptionInfo> existingOptions = new ArrayList<OptionInfo>();
        FactoryOption.options(this.ctx, roundContext, tmpPrototypeInfo, newOptions, existingOptions);
        for (BuilderCodegenExtension extension : extensions) {
            newOptions = extension.options(tmpPrototypeInfo, newOptions);
        }
        PrototypeInfo prototypeInfo = this.fixFactoryMethods(tmpPrototypeInfo, newOptions);
        List<OptionInfo> discoverServicesOptions = newOptions.stream().filter(it -> it.provider().isPresent() || it.registryService()).map(it -> {
            boolean defaultValue = it.provider().map(OptionProvider::discoverServices).orElse(true);
            String name = it.name() + "DiscoverServices";
            String setterName = it.setterName() + "DiscoverServices";
            String getterName = it.getterName() + "DiscoverServices";
            return ((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)OptionInfo.builder().accessModifier(it.accessModifier())).description("Service discovery flag for {@link #" + it.getterName() + "()}. If set to {@code true}, services will be discovered from Java service loader, or Helidon ServiceRegistry.")).paramDescription("whether to enabled automatic service discovery")).name(name)).setterName(setterName)).getterName(getterName)).builderOptionOnly(true)).declaredType(TypeNames.PRIMITIVE_BOOLEAN)).defaultValue(defaultConsumer -> defaultConsumer.addContent(String.valueOf(defaultValue)))).update(optionBuilder -> this.copyConfiguredForDiscoverServices((OptionInfo)it, (OptionInfo.Builder)optionBuilder))).update(optionBuilder -> it.deprecation().ifPresent(optionBuilder::deprecation))).build();
        }).toList();
        newOptions = new ArrayList<OptionInfo>(newOptions);
        newOptions.addAll(discoverServicesOptions);
        this.configOption(prototypeInfo, newOptions, existingOptions);
        this.serviceRegistryOption(prototypeInfo, newOptions);
        LinkedHashMap<String, List> existingOptionMap = new LinkedHashMap<String, List>();
        LinkedHashMap<String, List> newOptionMap = new LinkedHashMap<String, List>();
        for (OptionInfo existingOption : existingOptions) {
            existingOptionMap.computeIfAbsent(existingOption.name(), k -> new ArrayList()).add(existingOption);
        }
        for (OptionInfo newOption : newOptions) {
            newOptionMap.computeIfAbsent(newOption.name(), k -> new ArrayList()).add(newOption);
        }
        ArrayList<OptionInfo> options = new ArrayList<OptionInfo>();
        ArrayList<NewDefault> newDefaults = new ArrayList<NewDefault>();
        for (Map.Entry optionEntry : newOptionMap.entrySet()) {
            if (existingOptionMap.containsKey(optionEntry.getKey())) {
                ((List)optionEntry.getValue()).stream().filter(it -> it.defaultValue().isPresent()).findFirst().ifPresent(it -> newDefaults.add(new NewDefault((String)optionEntry.getKey(), this.setterName(prototypeInfo, (List)existingOptionMap.get(optionEntry.getKey())), it.defaultValue().get())));
                continue;
            }
            List optionInfos = (List)optionEntry.getValue();
            if (optionInfos.size() == 1) {
                options.add((OptionInfo)optionInfos.getFirst());
                continue;
            }
            options.add(this.mergeOptions(optionInfos));
        }
        List<OptionHandler> optionHandlers = options.stream().map(it -> OptionHandler.create(extensions, prototypeInfo, it)).toList();
        this.generatePrototype(roundContext, extensions, prototypeInfo, optionHandlers, newDefaults);
    }

    private void serviceRegistryOption(PrototypeInfo prototypeInfo, List<OptionInfo> newOptions) {
        boolean registrySupport;
        boolean bl = registrySupport = prototypeInfo.registrySupport() || BuilderCodegen.hasRegistryService(newOptions);
        if (!registrySupport) {
            return;
        }
        boolean style = prototypeInfo.recordStyle();
        String getter = style ? "serviceRegistry" : "getServiceRegistry";
        String setter = style ? "serviceRegistry" : "setServiceRegistry";
        newOptions.add(((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)OptionInfo.builder().name("serviceRegistry")).declaredType(Types.SERVICE_REGISTRY)).getterName(getter)).setterName(setter)).includeInEqualsAndHashCode(false)).includeInToString(false)).builderOptionOnly(true)).accessModifier(AccessModifier.PUBLIC)).description("Service registry used to discover providers and services.\nProvide an explicit registry instance to use.\n<p>\nIf not configured, the {@link " + Types.GLOBAL_SERVICE_REGISTRY.fqName() + "} would be used to discover services.")).paramDescription("service registry to use")).build());
    }

    private void configOption(PrototypeInfo prototypeInfo, List<OptionInfo> newOptions, List<OptionInfo> existingOptions) {
        if (prototypeInfo.configured().isEmpty()) {
            return;
        }
        if (this.hasConfigOption(newOptions)) {
            return;
        }
        if (this.hasConfigOption(existingOptions)) {
            return;
        }
        if (prototypeInfo.superPrototype().isPresent()) {
            return;
        }
        boolean style = prototypeInfo.recordStyle();
        String getter = style ? "config" : "getConfig";
        String setter = style ? "config" : "setConfig";
        newOptions.add(((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)((OptionInfo.Builder)OptionInfo.builder().name("config")).declaredType(Types.COMMON_CONFIG)).getterName(getter)).setterName(setter)).includeInEqualsAndHashCode(false)).includeInToString(false)).builderOptionOnly(true)).accessModifier(AccessModifier.PROTECTED)).description("Configuration used to configure this instance.")).paramDescription("config instance")).build());
    }

    private boolean hasConfigOption(List<OptionInfo> options) {
        return options.stream().filter(it -> it.name().equals("config")).anyMatch(it -> {
            TypeName optionType = it.declaredType();
            if (optionType.equals((Object)Types.CONFIG) || optionType.equals((Object)Types.COMMON_CONFIG)) {
                return true;
            }
            if (optionType.isOptional() && ((optionType = (TypeName)optionType.typeArguments().getFirst()).equals((Object)Types.CONFIG) || optionType.equals((Object)Types.COMMON_CONFIG))) {
                return true;
            }
            throw new CodegenException("An option named \"config\" in a configured blueprint must be of type " + Types.CONFIG.fqName() + " or its optional, but is: " + it.declaredType().fqName(), it.interfaceMethod().map(TypedElementInfo::originatingElementValue).orElse(it.name()));
        });
    }

    private PrototypeInfo fixFactoryMethods(PrototypeInfo tmpPrototypeInfo, List<OptionInfo> newOptions) {
        TypeName prototypeType = tmpPrototypeInfo.prototypeType();
        PrototypeInfo.Builder builder = PrototypeInfo.builder(tmpPrototypeInfo);
        ArrayList<GeneratedMethod> prototypeFactories = new ArrayList<GeneratedMethod>(tmpPrototypeInfo.prototypeFactories());
        for (DeprecatedFactoryMethod factoryMethod : tmpPrototypeInfo.deprecatedFactoryMethods()) {
            TypedElementInfo method = factoryMethod.method();
            TypeName returnType = method.typeName();
            if (returnType.unboxed().equals((Object)TypeNames.PRIMITIVE_VOID) || method.parameterArguments().size() != 1 || Utils.typesEqual(returnType, prototypeType)) {
                prototypeFactories.add(GeneratedMethods.createFactoryMethod(factoryMethod.declaringType(), factoryMethod.method(), List.of()));
                continue;
            }
            if (!newOptions.stream().filter(it -> Utils.typesEqual(returnType, Utils.realType(it.declaredType())) || Utils.resolvedTypesEqual(returnType, it.declaredType())).findAny().isEmpty()) continue;
            prototypeFactories.add(GeneratedMethods.createFactoryMethod(factoryMethod.declaringType(), factoryMethod.method(), List.of()));
        }
        return ((PrototypeInfo.Builder)builder.prototypeFactories(prototypeFactories)).build();
    }

    private void copyConfiguredForDiscoverServices(OptionInfo providerOption, OptionInfo.Builder optionBuilder) {
        if (providerOption.configured().isEmpty()) {
            return;
        }
        OptionConfigured configured = providerOption.configured().get();
        optionBuilder.configured(cfg -> ((OptionConfigured.Builder)cfg.merge(configured.merge())).configKey(configured.configKey() + "-discover-services"));
    }

    private OptionInfo mergeOptions(List<OptionInfo> optionInfos) {
        for (OptionInfo optionInfo : optionInfos) {
            Optional enclosing;
            if (!optionInfo.interfaceMethod().isPresent() || !(enclosing = optionInfo.interfaceMethod().get().enclosingType()).isPresent() || !((TypeName)enclosing.get()).className().endsWith("Blueprint")) continue;
            return optionInfo;
        }
        return optionInfos.getFirst();
    }

    private String setterName(PrototypeInfo prototypeInfo, List<OptionInfo> optionInfos) {
        boolean recordStyle = prototypeInfo.recordStyle();
        String first = null;
        for (OptionInfo optionInfo : optionInfos) {
            String setterName = optionInfo.setterName();
            if (first == null) {
                first = setterName;
            }
            if (!(setterName.startsWith("set") && setterName.length() > 3 && Character.isUpperCase(setterName.charAt(3)) ? !recordStyle : recordStyle)) continue;
            return setterName;
        }
        return first;
    }

    private void generatePrototype(RoundContext ctx, List<BuilderCodegenExtension> extensions, PrototypeInfo prototypeInfo, List<OptionHandler> options, List<NewDefault> newDefaults) {
        TypeInfo blueprint = prototypeInfo.blueprint();
        TypeName prototype = prototypeInfo.prototypeType();
        String ifaceName = prototype.className();
        List typeGenericArguments = blueprint.typeName().typeArguments();
        String typeArgumentString = this.createTypeArgumentString(typeGenericArguments);
        Javadoc javadoc = prototypeInfo.javadoc();
        List<TypeArgument> typeArguments = typeGenericArguments.stream().map(it -> {
            List tokenJavadoc;
            TypeArgument.Builder builder = TypeArgument.builder().token(it.className());
            if (!it.upperBounds().isEmpty()) {
                it.upperBounds().forEach(arg_0 -> ((TypeArgument.Builder)builder).addBound(arg_0));
            }
            if ((tokenJavadoc = (List)javadoc.genericsTokens().get(it.className())) != null) {
                builder.description(tokenJavadoc);
            }
            return builder.build();
        }).toList();
        ClassModel.Builder classModel = ((ClassModel.Builder)ClassModel.builder().type(prototypeInfo.prototypeType()).classType(ElementKind.INTERFACE)).copyright(CodegenUtil.copyright((TypeName)GENERATOR, (TypeName)blueprint.typeName(), (TypeName)prototype)).accessModifier(prototypeInfo.accessModifier());
        typeArguments.forEach(arg_0 -> ((ClassModel.Builder)classModel).addGenericArgument(arg_0));
        prototypeInfo.annotations().forEach(x$0 -> {
            ClassModel.Builder cfr_ignored_0 = (ClassModel.Builder)classModel.addAnnotation(x$0);
        });
        classModel.addAnnotation(CodegenUtil.generatedAnnotation((TypeName)GENERATOR, (TypeName)blueprint.typeName(), (TypeName)prototype, (String)"1", (String)""));
        prototypeInfo.superTypes().forEach(arg_0 -> ((ClassModel.Builder)classModel).addInterface(arg_0));
        prototypeInfo.constants().forEach(constant -> BuilderCodegen.generateCustomConstant(classModel, constant));
        TypeName builderTypeName = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)(prototype.fqName() + ".Builder")))).typeArguments(prototype.typeArguments())).build();
        BuilderCodegen.addBuilderMethod(classModel, builderTypeName, typeArguments, ifaceName);
        BuilderCodegen.addCopyBuilderMethod(classModel, builderTypeName, prototype, typeArguments, ifaceName, typeArgumentString);
        if (prototypeInfo.configured().isPresent()) {
            BuilderCodegen.addCreateFromConfigMethod(prototypeInfo.configured().get(), prototype, typeArguments, ifaceName, typeArgumentString, classModel);
        }
        if (prototypeInfo.createEmptyCreate()) {
            BuilderCodegen.addCreateDefaultMethod(options, classModel, prototypeInfo, ifaceName, typeArgumentString, typeArguments);
        }
        BuilderCodegen.generateCustomMethods(classModel, prototypeInfo.prototypeFactories());
        BuilderCodegen.generateCustomPrototypeMethods(classModel, prototypeInfo.prototypeMethods(), false);
        this.generatePrototypeMethods(classModel, options);
        List<OptionInfo> optionList = options.stream().map(OptionHandler::option).collect(Collectors.toUnmodifiableList());
        GenerateAbstractBuilder.generate(extensions, classModel, prototypeInfo, typeArguments, typeGenericArguments, options, newDefaults);
        GenerateBuilder.generate(extensions, classModel, prototypeInfo, typeArguments, typeGenericArguments, options);
        classModel.javadoc(prototypeInfo.javadoc());
        for (BuilderCodegenExtension extension : extensions) {
            extension.updatePrototype(prototypeInfo, optionList, classModel);
        }
        if (prototypeInfo.builderAccessModifier() == AccessModifier.PUBLIC) {
            classModel.addJavadocTag("see", "#builder()");
        }
        if (BuilderCodegen.noRequired(options) && prototypeInfo.createEmptyCreate() && prototypeInfo.builderAccessModifier() == AccessModifier.PUBLIC) {
            classModel.addJavadocTag("see", "#create()");
        }
        ctx.addGeneratedType(prototype, classModel, blueprint.typeName(), new Object[]{blueprint.originatingElementValue()});
        if (prototypeInfo.registrySupport()) {
            for (OptionHandler optionHandler : options) {
                OptionInfo option = optionHandler.option();
                if (!option.provider().isPresent()) continue;
                this.serviceLoaderContracts.add(option.provider().get().providerType().fqName());
            }
        }
    }

    private List<BuilderCodegenExtension> findExtensions(PrototypeInfo prototypeInfo) {
        List extensions = prototypeInfo.blueprint().findAnnotation(Types.PROTOTYPE_EXTENSIONS).flatMap(it -> it.annotationValues()).orElseGet(List::of);
        if (!extensions.isEmpty()) {
            return this.extensionsForAnnotations(prototypeInfo, extensions);
        }
        return prototypeInfo.findAnnotation(Types.PROTOTYPE_EXTENSION).map(it -> this.extensionsForAnnotations(prototypeInfo, List.of(it))).orElseGet(List::of);
    }

    private List<BuilderCodegenExtension> extensionsForAnnotations(PrototypeInfo prototypeInfo, List<Annotation> extensionAnnotations) {
        Set extensionTypes = extensionAnnotations.stream().map(Annotation::typeValue).flatMap(Optional::stream).collect(Collectors.toSet());
        ArrayList<ExtensionAndTypes> found = new ArrayList<ExtensionAndTypes>();
        HashSet unsatisfiedTypes = new HashSet(extensionTypes);
        for (BuilderCodegenExtensionProvider extension : this.extensions) {
            boolean matches = false;
            ArrayList<TypeName> matchedTypes = new ArrayList<TypeName>();
            for (TypeName extensionType : extensionTypes) {
                if (!extension.supports(extensionType)) continue;
                matches = true;
                unsatisfiedTypes.remove(extensionType);
                matchedTypes.add(extensionType);
            }
            if (!matches) continue;
            found.add(new ExtensionAndTypes(matchedTypes, extension));
        }
        if (!unsatisfiedTypes.isEmpty()) {
            throw new CodegenException("Could not find builder codegen extension for types: " + String.valueOf(unsatisfiedTypes) + " (used in @Prototype.Extension)", (Object)prototypeInfo.blueprint());
        }
        return found.stream().map(it -> it.provider().create(it.typeArray())).toList();
    }

    private void generatePrototypeMethods(ClassModel.Builder classModel, List<OptionHandler> options) {
        for (OptionHandler optionHandler : options) {
            optionHandler.typeHandler().optionMethod(OptionMethodType.PROTOTYPE_GETTER).ifPresent(it -> Utils.addGeneratedMethod(classModel, it));
        }
    }

    private Collection<? extends ValidationTask> addBlueprintsForValidation(RoundContext roundContext, Set<TypeName> blueprints) {
        ArrayList<ValidationTask> result = new ArrayList<ValidationTask>();
        for (TypeName blueprintType : blueprints) {
            TypeInfo blueprint = (TypeInfo)this.ctx.typeInfo(blueprintType).orElseThrow(() -> new CodegenException("Could not get TypeInfo for " + blueprintType.fqName(), (Object)blueprintType));
            result.add(new ValidationTask.ValidateBlueprint(blueprint));
            PrototypeInfo typeContext = FactoryPrototypeInfo.create(roundContext, blueprint);
            if (!typeContext.runtimeType().isPresent()) continue;
            result.add(new ValidationTask.ValidateBlueprintExtendsFactory(typeContext.prototypeType(), blueprint, this.toTypeInfo(blueprint, typeContext.runtimeType().get())));
        }
        return result;
    }

    private TypeInfo toTypeInfo(TypeInfo typeInfo, TypeName typeName) {
        return (TypeInfo)this.ctx.typeInfo(typeName.genericTypeName()).orElseThrow(() -> new IllegalArgumentException("Type " + typeName.fqName() + " is not a valid type for Factory declared on type " + typeInfo.typeName().fqName()));
    }

    private String createTypeArgumentString(List<TypeName> typeArguments) {
        if (!typeArguments.isEmpty()) {
            String arguments = typeArguments.stream().map(TypeName::className).collect(Collectors.joining(", "));
            return "<" + arguments + ">";
        }
        return "";
    }

    private record ExtensionAndTypes(List<TypeName> types, BuilderCodegenExtensionProvider provider) {
        public TypeName[] typeArray() {
            return this.types.toArray(new TypeName[0]);
        }
    }

    record NewDefault(String name, String setterName, Consumer<ContentBuilder<?>> defaultValue) {
    }
}

