/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.AnnotationDataOption;
import io.helidon.builder.codegen.FactoryMethods;
import io.helidon.builder.codegen.TypeHandler;
import io.helidon.builder.codegen.Types;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.InnerClass;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import io.helidon.common.types.TypedElementInfo;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.regex.Pattern;

abstract class TypeHandlerCollection
extends TypeHandler.OneTypeHandler {
    private static final Set<TypeName> BUILT_IN_MAPPERS = Set.of(TypeNames.STRING, TypeNames.BOXED_BOOLEAN, TypeNames.BOXED_BYTE, TypeNames.BOXED_SHORT, TypeNames.BOXED_INT, TypeNames.BOXED_LONG, TypeNames.BOXED_CHAR, TypeNames.BOXED_FLOAT, TypeNames.BOXED_DOUBLE, TypeNames.BOXED_VOID, TypeName.create(BigDecimal.class), TypeName.create(BigInteger.class), TypeName.create(Pattern.class), TypeName.create(Class.class), TypeName.create(Duration.class), TypeName.create(Period.class), TypeName.create(LocalDate.class), TypeName.create(LocalDateTime.class), TypeName.create(LocalTime.class), TypeName.create(ZonedDateTime.class), TypeName.create(ZoneId.class), TypeName.create(ZoneOffset.class), TypeName.create(Instant.class), TypeName.create(OffsetTime.class), TypeName.create(OffsetDateTime.class), TypeName.create(YearMonth.class), TypeName.create(File.class), TypeName.create(Path.class), TypeName.create(Charset.class), TypeName.create(URI.class), TypeName.create(URL.class), TypeName.create(UUID.class));
    private final TypeName collectionType;
    private final TypeName collectionImplType;
    private final String collector;
    private final Optional<String> configMapper;

    TypeHandlerCollection(TypeName blueprintType, TypedElementInfo annotatedMethod, String name, String getterName, String setterName, TypeName declaredType, TypeName collectionType, String collector, Optional<String> configMapper) {
        super(blueprintType, annotatedMethod, name, getterName, setterName, declaredType);
        this.collectionType = collectionType;
        this.collectionImplType = TypeHandlerCollection.collectionImplType(collectionType);
        this.collector = collector;
        this.configMapper = configMapper;
    }

    @Override
    Field.Builder fieldDeclaration(AnnotationDataOption configured, boolean isBuilder, boolean alwaysFinal) {
        Field.Builder builder = super.fieldDeclaration(configured, isBuilder, true);
        if (isBuilder && !configured.hasDefault()) {
            this.newCollectionInstanceWithoutParams((ContentBuilder<?>)builder);
            builder.addContent("()");
        }
        return builder;
    }

    @Override
    Consumer<ContentBuilder<?>> toDefaultValue(List<String> defaultValues, List<Integer> defaultInts, List<Long> defaultLongs, List<Double> defaultDoubles, List<Boolean> defaultBooleans) {
        if (defaultValues != null) {
            return content -> {
                this.newCollectionInstanceWithoutParams((ContentBuilder<?>)content);
                content.addContent("(").addContent(this.collectionType.genericTypeName()).addContent(".of(");
                for (int i = 0; i < defaultValues.size(); ++i) {
                    this.toDefaultValue((String)defaultValues.get(i)).accept((ContentBuilder<?>)content);
                    if (i == defaultValues.size() - 1) continue;
                    content.addContent(", ");
                }
                content.addContent("))");
            };
        }
        if (defaultInts != null) {
            return this.defaultCollection(defaultInts);
        }
        if (defaultLongs != null) {
            return content -> {
                this.newCollectionInstanceWithoutParams((ContentBuilder<?>)content);
                content.addContent("(").addContent(this.collectionType.genericTypeName()).addContent(".of(");
                for (int i = 0; i < defaultLongs.size(); ++i) {
                    content.addContent(String.valueOf(defaultLongs.get(i))).addContent("L");
                    if (i == defaultLongs.size() - 1) continue;
                    content.addContent(", ");
                }
                content.addContent("))");
            };
        }
        if (defaultDoubles != null) {
            return this.defaultCollection(defaultDoubles);
        }
        if (defaultBooleans != null) {
            return this.defaultCollection(defaultBooleans);
        }
        return null;
    }

    @Override
    void generateFromConfig(Method.Builder method, AnnotationDataOption configured, FactoryMethods factoryMethods) {
        if (configured.provider()) {
            return;
        }
        TypeName actualType = this.actualType().genericTypeName();
        if (factoryMethods.createFromConfig().isPresent()) {
            FactoryMethods.FactoryMethod factoryMethod = factoryMethods.createFromConfig().get();
            TypeName returnType = factoryMethod.factoryMethodReturnType();
            boolean mapList = true;
            mapList = returnType.isList() || returnType.isSet() ? false : returnType.equals((Object)actualType);
            if (mapList) {
                method.addContentLine(this.configGet(configured) + ".asList(" + this.generateMapListFromConfig(factoryMethods) + ").ifPresent(this::" + this.setterName() + ");");
            } else {
                method.addContent(this.configGet(configured));
                this.generateFromConfig((ContentBuilder<?>)method, factoryMethods);
                method.addContentLine(".ifPresent(this::" + this.setterName() + ");");
            }
        } else if (BUILT_IN_MAPPERS.contains(actualType)) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(this.configGet(configured))).addContent(".asList(")).addContent(actualType.genericTypeName())).addContent(".class")).addContent(")");
            this.configMapper.ifPresent(arg_0 -> ((Method.Builder)method).addContent(arg_0));
            if (this.actualType().typeArguments().isEmpty()) {
                ((Method.Builder)((Method.Builder)method.addContent(".ifPresent(this::")).addContent(this.setterName())).addContentLine(");");
            } else {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(".ifPresent(it -> this.")).addContent(this.setterName())).addContent("((")).addContent(this.collectionType)).addContentLine(")it));");
            }
        } else {
            method.addContent(this.configGet(configured) + ".asNodeList().map(nodeList -> nodeList.stream().map(cfg -> cfg");
            this.generateFromConfig((ContentBuilder<?>)method, factoryMethods);
            method.addContentLine(".get())." + this.collector + ").ifPresent(this::" + this.setterName() + ");");
        }
    }

    String generateMapListFromConfig(FactoryMethods factoryMethods) {
        return factoryMethods.createFromConfig().map(it -> it.typeWithFactoryMethod().genericTypeName().fqName() + "::" + it.createMethodName()).orElseThrow(() -> new IllegalStateException("This should have been called only if factory method is present for " + String.valueOf(this.declaredType()) + " " + this.name()));
    }

    @Override
    TypeName argumentTypeName() {
        TypeName type = this.actualType();
        if (TypeNames.STRING.equals((Object)type) || this.toPrimitive(type).primitive() || type.array()) {
            return this.declaredType();
        }
        return ((TypeName.Builder)TypeName.builder((TypeName)this.collectionType).addTypeArgument(TypeHandlerCollection.toWildcard(type))).build();
    }

    @Override
    void setters(InnerClass.Builder classBuilder, AnnotationDataOption configured, FactoryMethods factoryMethods, TypeName returnType, Javadoc blueprintJavadoc) {
        FactoryMethods.FactoryMethod factoryMethod;
        if (configured.provider() || configured.registryService()) {
            this.discoverServicesSetter(classBuilder, configured, returnType, blueprintJavadoc);
        }
        this.declaredSetters(classBuilder, configured, returnType, blueprintJavadoc);
        if (factoryMethods.createTargetType().isPresent() && ((factoryMethod = factoryMethods.createTargetType().get()).factoryMethodReturnType().isList() || factoryMethod.factoryMethodReturnType().isSet())) {
            this.factorySetter(classBuilder, configured, returnType, blueprintJavadoc, factoryMethod);
        }
        if (configured.singular()) {
            this.singularSetter(classBuilder, configured, returnType, blueprintJavadoc, configured.singularName());
        }
        if (factoryMethods.builder().isPresent()) {
            this.factorySetterConsumer(classBuilder, configured, returnType, blueprintJavadoc, factoryMethods, factoryMethods.builder().get());
        }
    }

    private void newCollectionInstanceWithoutParams(ContentBuilder<?> content) {
        content.addContent("new ").addContent(this.collectionImplType.genericTypeName()).addContent("<>");
    }

    private Consumer<ContentBuilder<?>> defaultCollection(List<?> list) {
        return content -> {
            this.newCollectionInstanceWithoutParams((ContentBuilder<?>)content);
            content.addContent("(").addContent(this.collectionType.genericTypeName()).addContent(".of(");
            for (int i = 0; i < list.size(); ++i) {
                content.addContent(String.valueOf(list.get(i)));
                if (i == list.size() - 1) continue;
                content.addContent(", ");
            }
            content.addContent("))");
        };
    }

    private void discoverServicesSetter(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        classBuilder.addMethod(builder -> ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.name(this.setterName() + "DiscoverServices")).returnType(returnType, "updated builder instance").description(blueprintJavadoc.content())).addJavadocTag("see", "#" + this.getterName() + "()")).addParameter(param -> ((Parameter.Builder)param.name("discoverServices")).type(Boolean.TYPE).description("whether to discover implementations through service loader"))).accessModifier(TypeHandlerCollection.setterAccessModifier(configured))).addContentLine("this." + this.name() + "DiscoverServices = discoverServices;")).addContentLine("return self();"));
    }

    private void factorySetterConsumer(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc, FactoryMethods factoryMethods, FactoryMethods.FactoryMethod factoryMethod) {
        if (!configured.singular()) {
            return;
        }
        TypeName builderType = factoryMethod.factoryMethodReturnType().className().equals("Builder") ? factoryMethod.factoryMethodReturnType() : TypeName.create((String)(factoryMethod.factoryMethodReturnType().fqName() + ".Builder"));
        if (this.skipBuilderConsumer(builderType)) {
            return;
        }
        TypeName argumentType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Consumer.class)).addTypeArgument(builderType)).build();
        String argumentName = "consumer";
        Javadoc javadoc = this.setterJavadoc(blueprintJavadoc).addParameter(argumentName, blueprintJavadoc.returnDescription()).build();
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType).addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(argumentType))).accessModifier(TypeHandlerCollection.setterAccessModifier(configured))).addContent(Objects.class)).javadoc(javadoc)).addContentLine(".requireNonNull(" + argumentName + ");")).addContent("var builder = ")).addContent(factoryMethod.typeWithFactoryMethod().genericTypeName())).addContentLine("." + factoryMethod.createMethodName() + "();")).addContentLine("consumer.accept(builder);");
        if (factoryMethods.createTargetType().map(FactoryMethods.FactoryMethod::factoryMethodReturnType).map(m -> m.genericTypeName().equals((Object)this.collectionType)).orElse(false).booleanValue()) {
            ((Method.Builder)builder.addContentLine("this." + this.name() + "(builder.build());")).addContentLine("return self();");
            classBuilder.addMethod(builder);
            return;
        }
        String singularName = configured.singularName();
        Object methodName = configured.singularAddPrefix() ? "add" + CodegenUtil.capitalize((String)singularName) : singularName;
        ((Method.Builder)((Method.Builder)builder.name((String)methodName)).addContentLine("this." + this.name() + ".add(builder.build());")).addContentLine("return self();");
        classBuilder.addMethod(builder);
    }

    private void singularSetter(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc, String singularName) {
        Object methodName = configured.singularAddPrefix() ? "add" + CodegenUtil.capitalize((String)singularName) : singularName;
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name((String)methodName)).javadoc(this.setterJavadoc(blueprintJavadoc).addParameter(singularName, blueprintJavadoc.returnDescription()).build())).returnType(returnType).update(it -> configured.annotations().forEach(x$0 -> {
            Method.Builder cfr_ignored_0 = (Method.Builder)it.addAnnotation(x$0);
        }))).addParameter(param -> ((Parameter.Builder)param.name(singularName)).type(this.actualType()))).accessModifier(TypeHandlerCollection.setterAccessModifier(configured))).addContent(Objects.class)).addContentLine(".requireNonNull(" + singularName + ");");
        if (configured.decorator() != null) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)builder.addContent("new ")).addContent(configured.decorator())).addContent("().decorate(this, ")).addContent(singularName)).addContentLine(");");
        }
        ((Method.Builder)((Method.Builder)builder.addContentLine("this." + this.name() + ".add(" + singularName + ");")).update(this::extraAdderContent)).addContentLine("return self();");
        classBuilder.addMethod(builder);
    }

    private void factorySetter(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc, FactoryMethods.FactoryMethod factoryMethod) {
        if (factoryMethod.argumentType().equals((Object)Types.CONFIG)) {
            return;
        }
        String argumentName = this.name() + "Config";
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType, "updated builder instance").description(blueprintJavadoc.content())).addJavadocTag("see", "#" + this.getterName() + "()")).addParameter(param -> ((Parameter.Builder)param.name(argumentName)).type(factoryMethod.argumentType()).description(blueprintJavadoc.returnDescription()))).accessModifier(TypeHandlerCollection.setterAccessModifier(configured))).addContent(Objects.class)).addContentLine(".requireNonNull(" + argumentName + ");")).addContentLine("this." + this.name() + ".clear();")).addContent("this." + this.name() + ".addAll(")).addContent(factoryMethod.typeWithFactoryMethod().genericTypeName())).addContentLine("." + factoryMethod.createMethodName() + "(" + argumentName + "));")).addContentLine("return self();");
        classBuilder.addMethod(builder);
    }

    private void declaredSetters(InnerClass.Builder classBuilder, AnnotationDataOption configured, TypeName returnType, Javadoc blueprintJavadoc) {
        Method.Builder setMethod = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name(this.setterName())).returnType(returnType, "updated builder instance").description(blueprintJavadoc.content())).addJavadocTag("see", "#" + this.getterName() + "()")).addParameter(param -> ((Parameter.Builder)param.name(this.name())).type(this.argumentTypeName()).description(blueprintJavadoc.returnDescription()))).accessModifier(TypeHandlerCollection.setterAccessModifier(configured))).addContent(Objects.class)).addContentLine(".requireNonNull(" + this.name() + ");");
        Method.Builder addMethod = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("add" + CodegenUtil.capitalize((String)this.name()))).returnType(returnType, "updated builder instance").description(blueprintJavadoc.content())).addJavadocTag("see", "#" + this.getterName() + "()")).addParameter(param -> ((Parameter.Builder)param.name(this.name())).type(this.argumentTypeName()).description(blueprintJavadoc.returnDescription()))).accessModifier(TypeHandlerCollection.setterAccessModifier(configured))).addContent(Objects.class)).addContentLine(".requireNonNull(" + this.name() + ");");
        if (configured.decorator() != null) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)setMethod.addContent("new ")).addContent(configured.decorator())).addContent("().")).addContent(this.decoratorSetMethodName())).addContent("(this, ")).addContent(this.name())).addContentLine(");");
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)addMethod.addContent("new ")).addContent(configured.decorator())).addContent("().")).addContent(this.decoratorAddMethodName())).addContent("(this, ")).addContent(this.name())).addContentLine(");");
        }
        ((Method.Builder)((Method.Builder)((Method.Builder)setMethod.update(this::extraSetterContent)).addContentLine("this." + this.name() + ".clear();")).addContentLine("this." + this.name() + ".addAll(" + this.name() + ");")).addContentLine("return self();");
        ((Method.Builder)((Method.Builder)addMethod.update(this::extraAdderContent)).addContentLine("this." + this.name() + ".addAll(" + this.name() + ");")).addContentLine("return self();");
        classBuilder.addMethod(setMethod);
        classBuilder.addMethod(addMethod);
    }

    Method.Builder extraSetterContent(Method.Builder builder) {
        return builder;
    }

    Method.Builder extraAdderContent(Method.Builder builder) {
        return builder;
    }

    protected abstract String decoratorSetMethodName();

    protected abstract String decoratorAddMethodName();
}

