/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen;

import io.helidon.builder.codegen.AnnotationDataConfigured;
import io.helidon.builder.codegen.AnnotationDataOption;
import io.helidon.builder.codegen.CustomMethods;
import io.helidon.builder.codegen.PrototypeProperty;
import io.helidon.builder.codegen.TypeContext;
import io.helidon.builder.codegen.TypeHandler;
import io.helidon.builder.codegen.TypeHandlerList;
import io.helidon.builder.codegen.Types;
import io.helidon.codegen.CodegenUtil;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.codegen.classmodel.Constructor;
import io.helidon.codegen.classmodel.ContentBuilder;
import io.helidon.codegen.classmodel.Field;
import io.helidon.codegen.classmodel.InnerClass;
import io.helidon.codegen.classmodel.Javadoc;
import io.helidon.codegen.classmodel.Method;
import io.helidon.codegen.classmodel.Parameter;
import io.helidon.codegen.classmodel.TypeArgument;
import io.helidon.common.Errors;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.types.AccessModifier;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNames;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

final class GenerateAbstractBuilder {
    private GenerateAbstractBuilder() {
    }

    static void generate(ClassModel.Builder classModel, TypeName prototype, TypeName runtimeType, List<TypeArgument> typeArguments, List<TypeName> typeArgumentNames, TypeContext typeContext) {
        Optional<TypeName> superType = typeContext.typeInfo().superPrototype();
        classModel.addInnerClass(builder -> {
            typeArguments.forEach(arg_0 -> ((InnerClass.Builder)builder).addGenericArgument(arg_0));
            ((InnerClass.Builder)((InnerClass.Builder)((InnerClass.Builder)((InnerClass.Builder)((InnerClass.Builder)((InnerClass.Builder)builder.name("BuilderBase")).isAbstract(true)).accessModifier(AccessModifier.PACKAGE_PRIVATE)).description("Fluent API builder base for {@link " + runtimeType.className() + "}.")).addGenericArgument(token -> token.token("BUILDER").description("type of the builder extending this abstract builder").bound(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)(prototype.fqName() + ".BuilderBase")))).addTypeArguments(typeArgumentNames)).addTypeArgument(TypeName.createFromGenericDeclaration((String)"BUILDER"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"PROTOTYPE"))).build()))).addGenericArgument(token -> token.token("PROTOTYPE").description("type of the prototype interface that would be built by {@link #buildPrototype()}").bound(prototype))).addConstructor(constructor -> GenerateAbstractBuilder.createConstructor(constructor, typeContext));
            superType.ifPresent(type -> builder.superType(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)(type.fqName() + ".BuilderBase")))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"BUILDER"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"PROTOTYPE"))).build()));
            if (typeContext.configuredData().configured() || GenerateAbstractBuilder.hasConfig(typeContext.propertyData().properties())) {
                builder.addInterface(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(Types.CONFIG_CONFIGURED_BUILDER)).addTypeArgument(TypeName.createFromGenericDeclaration((String)"BUILDER"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"PROTOTYPE"))).build());
            } else {
                builder.addInterface(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(Types.PROTOTYPE_BUILDER)).addTypeArgument(TypeName.createFromGenericDeclaration((String)"BUILDER"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"PROTOTYPE"))).build());
            }
            GenerateAbstractBuilder.fields(builder, typeContext, true);
            GenerateAbstractBuilder.fromInstanceMethod(builder, typeContext, prototype);
            GenerateAbstractBuilder.fromBuilderMethod(builder, typeContext, typeArgumentNames);
            GenerateAbstractBuilder.preBuildPrototypeMethod(builder, typeContext);
            GenerateAbstractBuilder.validatePrototypeMethod(builder, typeContext);
            GenerateAbstractBuilder.addCustomBuilderMethods(typeContext, builder);
            GenerateAbstractBuilder.builderMethods(builder, typeContext);
            GenerateAbstractBuilder.toString(builder, typeContext, prototype.className() + "Builder", superType.isPresent(), typeContext.customMethods().prototypeMethods(), true);
            GenerateAbstractBuilder.generatePrototypeImpl(builder, typeContext, typeArguments, typeArgumentNames);
        });
    }

    static void buildRuntimeObjectMethod(InnerClass.Builder classBuilder, TypeContext typeContext, boolean isBuilder) {
        TypeContext.TypeInformation typeInformation = typeContext.typeInfo();
        boolean hasRuntimeObject = typeInformation.runtimeObject().isPresent();
        TypeName builtObject = typeInformation.runtimeObject().orElse(typeInformation.prototype());
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("build")).addAnnotation(Annotations.OVERRIDE)).returnType(builtObject).addContent("return ");
        if (hasRuntimeObject) {
            builder.addContent(builtObject.genericTypeName());
            if (isBuilder) {
                builder.addContentLine(".create(this.buildPrototype());");
            } else {
                builder.addContentLine(".create(this);");
            }
        } else if (isBuilder) {
            builder.addContentLine("build();");
        } else {
            builder.addContentLine("this;");
        }
        classBuilder.addMethod(builder);
        if (!isBuilder) {
            classBuilder.addMethod(method -> ((Method.Builder)((Method.Builder)method.name("get")).returnType(builtObject).addAnnotation(Annotations.OVERRIDE)).addContentLine("return build();"));
        }
    }

    static boolean hasConfig(List<PrototypeProperty> properties) {
        return properties.stream().anyMatch(GenerateAbstractBuilder::isConfigProperty);
    }

    private static void addCustomBuilderMethods(TypeContext typeContext, InnerClass.Builder builder) {
        for (CustomMethods.CustomMethod customMethod : typeContext.customMethods().builderMethods()) {
            CustomMethods.Method generated = customMethod.generatedMethod().method();
            Method.Builder method = ((Method.Builder)Method.builder().name(generated.name())).returnType(TypeName.createFromGenericDeclaration((String)"BUILDER"));
            customMethod.generatedMethod().generateCode().accept((ContentBuilder<?>)method);
            for (String annotation : customMethod.generatedMethod().annotations()) {
                method.addAnnotation(io.helidon.codegen.classmodel.Annotation.parse((String)annotation));
            }
            int argSize = generated.arguments().size();
            for (int i = 0; i < argSize; ++i) {
                CustomMethods.Argument argument = generated.arguments().get(i);
                if (i == argSize - 1 && argument.typeName().array() && !argument.typeName().primitive()) {
                    method.addParameter(param -> ((Parameter.Builder)param.name(argument.name())).type(((TypeName.Builder)TypeName.builder((TypeName)argument.typeName()).array(false)).build()).vararg(true));
                    continue;
                }
                method.addParameter(param -> ((Parameter.Builder)param.name(argument.name())).type(argument.typeName()));
            }
            for (TypeName typeParameter : customMethod.generatedMethod().method().typeParameters()) {
                method.addGenericArgument(TypeArgument.create((TypeName)typeParameter));
            }
            if (!generated.javadoc().isEmpty()) {
                Javadoc javadoc = Javadoc.builder().from(Javadoc.parse(generated.javadoc())).returnDescription("updated builder instance").build();
                method.javadoc(javadoc);
            }
            builder.addMethod(method);
        }
    }

    private static void createConstructor(Constructor.Builder constructor, TypeContext typeContext) {
        ((Constructor.Builder)constructor.description("Protected to support extensibility.")).accessModifier(AccessModifier.PROTECTED);
        for (PrototypeProperty prop : typeContext.propertyData().overridingProperties()) {
            if (!prop.configuredOption().hasDefault()) continue;
            ((Constructor.Builder)constructor.addContent(prop.setterName())).addContent("(");
            prop.configuredOption().defaultValue().accept((ContentBuilder<?>)constructor);
            constructor.addContent(");");
        }
    }

    private static void builderMethods(InnerClass.Builder classBuilder, TypeContext typeContext) {
        List<PrototypeProperty> properties = typeContext.propertyData().properties();
        AnnotationDataConfigured configured = typeContext.configuredData();
        if (configured.configured() || GenerateAbstractBuilder.hasConfig(properties)) {
            GenerateAbstractBuilder.createConfigMethod(classBuilder, typeContext, configured, properties);
        }
        TypeName returnType = TypeName.createFromGenericDeclaration((String)"BUILDER");
        if (typeContext.typeInfo().supportsServiceRegistry()) {
            GenerateAbstractBuilder.serviceRegistrySetter(classBuilder);
        }
        for (PrototypeProperty child : properties) {
            if (GenerateAbstractBuilder.isConfigProperty(child)) continue;
            child.setters(classBuilder, returnType, child.configuredOption().javadoc());
        }
        for (PrototypeProperty child : properties) {
            String getterName = child.getterName();
            if ("config".equals(getterName) && configured.configured()) {
                if (child.typeHandler().actualType().equals((Object)Types.COMMON_CONFIG)) continue;
                throw new IllegalArgumentException("Configured property named \"config\" can only be of type " + Types.COMMON_CONFIG.declaredName() + ", but is: " + child.typeName().declaredName());
            }
            Method.Builder method = ((Method.Builder)Method.builder().name(getterName)).returnType(child.builderGetterType());
            child.builderGetter((ContentBuilder<?>)method);
            for (Annotation annotation : child.configuredOption().annotations()) {
                method.addAnnotation(annotation);
            }
            Javadoc javadoc = child.configuredOption().javadoc();
            if (javadoc != null) {
                method.javadoc(Javadoc.builder((Javadoc)javadoc).returnDescription("the " + GenerateAbstractBuilder.toHumanReadable(child.name())).build());
            }
            classBuilder.addMethod(method);
        }
        if (configured.configured()) {
            TypeName configReturnType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Optional.class)).addTypeArgument(Types.COMMON_CONFIG)).build();
            Method.Builder method = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("config")).description("If this instance was configured, this would be the config instance used.")).returnType(configReturnType, "config node used to configure this builder, or empty if not configured").addContent("return ")).addContent(Optional.class)).addContentLine(".ofNullable(config);");
            classBuilder.addMethod(method);
        }
    }

    private static void serviceRegistrySetter(InnerClass.Builder classBuilder) {
        Javadoc javadoc = Javadoc.builder().addLine("Provide an explicit registry instance to use.").addLine("<p>").addLine("If not configured, the {@link " + Types.GLOBAL_SERVICE_REGISTRY.fqName() + "} would be used to discover services.").build();
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("serviceRegistry")).javadoc(javadoc)).returnType((TypeName)TypeArgument.create((String)"BUILDER"), "updated builder instance").addParameter(param -> ((Parameter.Builder)param.name("registry")).type(Types.SERVICE_REGISTRY).description("service registry instance"))).addContent(Objects.class)).addContentLine(".requireNonNull(registry);")).addContentLine("this.serviceRegistry = registry;")).addContentLine("return self();");
        classBuilder.addMethod(builder);
    }

    private static void createConfigMethod(InnerClass.Builder classBuilder, TypeContext typeContext, AnnotationDataConfigured configured, List<PrototypeProperty> properties) {
        Javadoc javadoc = configured.configured() ? Javadoc.builder().addLine("Update builder from configuration (node of this type).").addLine("If a value is present in configuration, it would override currently configured values.").build() : Javadoc.builder().addLine("Config to use.").build();
        Method.Builder builder = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("config")).javadoc(javadoc)).returnType((TypeName)TypeArgument.create((String)"BUILDER"), "updated builder instance").addParameter(param -> ((Parameter.Builder)param.name("config")).type(Types.COMMON_CONFIG).description("configuration instance used to obtain values to update this builder"))).addAnnotation(Annotations.OVERRIDE)).addContent(Objects.class)).addContentLine(".requireNonNull(config);")).addContentLine("this.config = config;");
        if (typeContext.typeInfo().superPrototype().isPresent()) {
            builder.addContentLine("super.config(config);");
        }
        if (configured.configured()) {
            for (PrototypeProperty child : properties) {
                if (!child.configuredOption().configured() || child.configuredOption().provider()) continue;
                child.typeHandler().generateFromConfig(builder, child.configuredOption(), child.factoryMethods());
            }
        }
        builder.addContentLine("return self();");
        classBuilder.addMethod(builder);
    }

    private static void fromInstanceMethod(InnerClass.Builder builder, TypeContext typeContext, TypeName prototype) {
        Method.Builder methodBuilder = ((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("from")).returnType((TypeName)TypeArgument.create((String)"BUILDER")).description("Update this builder from an existing prototype instance. This method disables automatic service discovery.")).addParameter(param -> ((Parameter.Builder)param.name("prototype")).type(prototype).description("existing prototype to update this builder from"))).returnType((TypeName)TypeArgument.create((String)"BUILDER"), "updated builder instance");
        typeContext.typeInfo().superPrototype().ifPresent(it -> methodBuilder.addContentLine("super.from(prototype);"));
        for (PrototypeProperty property : typeContext.propertyData().properties()) {
            TypeName declaredType = property.typeHandler().declaredType();
            if (declaredType.isSet() || declaredType.isList() || declaredType.isMap()) {
                if (declaredType.isList()) {
                    ((Method.Builder)((Method.Builder)methodBuilder.addContentLine("if (!is" + CodegenUtil.capitalize((String)property.name()) + "Mutated) {")).addContentLine(property.name() + ".clear();")).addContentLine("}");
                }
                methodBuilder.addContent("add");
                methodBuilder.addContent(CodegenUtil.capitalize((String)property.name()));
                methodBuilder.addContent("(prototype.");
                methodBuilder.addContent(property.typeHandler().getterName());
                methodBuilder.addContentLine("());");
            } else if (GenerateAbstractBuilder.isConfigProperty(property)) {
                methodBuilder.addContent("this.config = prototype.config()");
                if (declaredType.isOptional()) {
                    methodBuilder.addContent(".orElse(null)");
                }
                methodBuilder.addContentLine(";");
            } else {
                methodBuilder.addContent(property.typeHandler().setterName());
                methodBuilder.addContent("(prototype.");
                methodBuilder.addContent(property.typeHandler().getterName());
                methodBuilder.addContentLine("());");
            }
            if (!property.configuredOption().provider() && !property.registryService()) continue;
            methodBuilder.addContentLine(property.typeHandler().name() + "DiscoverServices = false;");
        }
        methodBuilder.addContentLine("return self();");
        builder.addMethod(methodBuilder);
    }

    private static void fromBuilderMethod(InnerClass.Builder classBuilder, TypeContext typeContext, List<TypeName> arguments) {
        TypeName prototype = typeContext.typeInfo().prototype();
        TypeName parameterType = ((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)(prototype.fqName() + ".BuilderBase")))).addTypeArguments(arguments)).addTypeArgument(TypeName.createFromGenericDeclaration((String)"?"))).addTypeArgument(TypeName.createFromGenericDeclaration((String)"?"))).build();
        Method.Builder methodBuilder = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("from")).addParameter(param -> ((Parameter.Builder)param.name("builder")).type(parameterType).description("existing builder prototype to update this builder from"))).returnType((TypeName)TypeArgument.create((String)"BUILDER"), "updated builder instance").description("Update this builder from an existing prototype builder instance.");
        typeContext.typeInfo().superPrototype().ifPresent(it -> methodBuilder.addContentLine("super.from(builder);"));
        for (PrototypeProperty property : typeContext.propertyData().properties()) {
            TypeName declaredType = property.typeHandler().declaredType();
            String setterName = property.typeHandler().setterName();
            String getterName = property.typeHandler().getterName();
            if (property.builderGetterOptional()) {
                methodBuilder.addContentLine("builder." + getterName + "().ifPresent(this::" + setterName + ");");
            } else if (declaredType.isSet() || declaredType.isList() || declaredType.isMap()) {
                if (declaredType.isList()) {
                    String isMutatedProperty = TypeHandlerList.isMutatedField(property.name());
                    ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)methodBuilder.addContentLine("if (" + isMutatedProperty + ") {")).addContentLine("if (builder." + isMutatedProperty + ") {")).addContentLine("add" + CodegenUtil.capitalize((String)property.name()) + "(builder." + property.name() + ");")).addContentLine("}")).decreaseContentPadding()).addContentLine("} else {")).addContentLine(property.name() + ".clear();")).addContentLine("add" + CodegenUtil.capitalize((String)property.name()) + "(builder." + property.name() + ");")).addContentLine("}");
                } else {
                    methodBuilder.addContentLine("add" + CodegenUtil.capitalize((String)property.name()) + "(builder." + property.name() + ");");
                }
            } else {
                methodBuilder.addContentLine(setterName + "(builder." + getterName + "());");
            }
            if (!property.configuredOption().provider() && !property.registryService()) continue;
            methodBuilder.addContent(property.name() + "DiscoverServices");
            methodBuilder.addContentLine(" = builder." + property.name() + "DiscoverServices;");
        }
        methodBuilder.addContentLine("return self();");
        classBuilder.addMethod(methodBuilder);
    }

    private static void fields(InnerClass.Builder classBuilder, TypeContext typeContext, boolean isBuilder) {
        if (isBuilder && (typeContext.configuredData().configured() || GenerateAbstractBuilder.hasConfig(typeContext.propertyData().properties()))) {
            classBuilder.addField(builder -> builder.type(Types.COMMON_CONFIG).name("config"));
        }
        if (isBuilder && typeContext.typeInfo().supportsServiceRegistry()) {
            classBuilder.addField(builder -> builder.type(Types.SERVICE_REGISTRY).name("serviceRegistry"));
        }
        for (PrototypeProperty child : typeContext.propertyData().properties()) {
            if (isBuilder && child.configuredOption().hasAllowedValues()) {
                String allowedValues = child.configuredOption().allowedValues().stream().map(AnnotationDataOption.AllowedValue::value).map(it -> "\"" + it + "\"").collect(Collectors.joining(", "));
                classBuilder.addField(it -> ((Field.Builder)((Field.Builder)it.isFinal(true).isStatic(true).name(child.name().toUpperCase(Locale.ROOT) + "_ALLOWED_VALUES")).type(((TypeName.Builder)TypeName.builder((TypeName)TypeNames.SET).addTypeArgument(TypeNames.STRING)).build()).addContent(Set.class)).addContent(".of(").addContent(allowedValues).addContent(")"));
            }
            if (!isBuilder || !GenerateAbstractBuilder.isConfigProperty(child)) {
                classBuilder.addField(child.fieldDeclaration(isBuilder));
            }
            if (isBuilder && child.configuredOption().provider()) {
                classBuilder.addField(builder -> ((Field.Builder)builder.type(Boolean.TYPE).name(child.name() + "DiscoverServices")).defaultValue(String.valueOf(child.configuredOption().providerDiscoverServices())));
            }
            if (isBuilder && child.registryService()) {
                classBuilder.addField(builder -> ((Field.Builder)builder.type(Boolean.TYPE).name(child.name() + "DiscoverServices")).defaultValue("true"));
            }
            if (!isBuilder || !child.typeHandler().declaredType().isList()) continue;
            classBuilder.addField(builder -> ((Field.Builder)builder.type(Boolean.TYPE).name("is" + CodegenUtil.capitalize((String)child.name()) + "Mutated")).accessModifier(AccessModifier.PRIVATE));
        }
    }

    private static boolean isConfigProperty(PrototypeProperty property) {
        return TypeHandler.isConfigProperty(property.typeHandler());
    }

    private static void preBuildPrototypeMethod(InnerClass.Builder classBuilder, TypeContext typeContext) {
        Method.Builder preBuildBuilder = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("preBuildPrototype")).accessModifier(AccessModifier.PROTECTED)).description("Handles providers and decorators.");
        if (typeContext.propertyData().hasProvider()) {
            preBuildBuilder.addAnnotation(builder -> builder.type(SuppressWarnings.class).addParameter("value", (Object)"unchecked"));
        }
        typeContext.typeInfo().superPrototype().ifPresent(it -> preBuildBuilder.addContentLine("super.preBuildPrototype();"));
        if (typeContext.typeInfo().supportsServiceRegistry() || typeContext.propertyData().hasProvider()) {
            boolean configured = typeContext.configuredData().configured();
            if (configured && typeContext.propertyData().hasProvider()) {
                ((Method.Builder)((Method.Builder)preBuildBuilder.addContent("var config = this.config == null ? ")).addContent(Types.COMMON_CONFIG)).addContentLine(".empty() : this.config;");
            }
            if (typeContext.typeInfo().supportsServiceRegistry()) {
                ((Method.Builder)((Method.Builder)preBuildBuilder.addContent("var registry = ")).addContent(Optional.class)).addContentLine(".ofNullable(this.serviceRegistry);");
            }
            for (PrototypeProperty property : typeContext.propertyData().properties()) {
                boolean propertyConfigured = property.configuredOption().configured();
                AnnotationDataOption configuredOption = property.configuredOption();
                if (configuredOption.provider()) {
                    boolean defaultDiscoverServices = configuredOption.providerDiscoverServices();
                    TypeName providerType = configuredOption.providerType();
                    if (typeContext.typeInfo().supportsServiceRegistry()) {
                        GenerateAbstractBuilder.serviceRegistryPropertyDiscovery(preBuildBuilder, property, propertyConfigured, configuredOption, providerType, defaultDiscoverServices);
                        continue;
                    }
                    GenerateAbstractBuilder.serviceLoaderPropertyDiscovery(preBuildBuilder, property, propertyConfigured, configuredOption, providerType, defaultDiscoverServices);
                    continue;
                }
                if (!property.registryService()) continue;
                GenerateAbstractBuilder.serviceRegistryProperty(preBuildBuilder, property);
            }
        }
        if (typeContext.typeInfo().decorator().isPresent()) {
            ((Method.Builder)((Method.Builder)preBuildBuilder.addContent("new ")).addContent(typeContext.typeInfo().decorator().get())).addContentLine("().decorate(this);");
        }
        classBuilder.addMethod(preBuildBuilder);
    }

    private static void serviceLoaderPropertyDiscovery(Method.Builder preBuildBuilder, PrototypeProperty property, boolean propertyConfigured, AnnotationDataOption configuredOption, TypeName providerType, boolean defaultDiscoverServices) {
        preBuildBuilder.addContentLine("{");
        ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent("var serviceLoader = ")).addContent(HelidonServiceLoader.class)).addContent(".create(")).addContent(ServiceLoader.class)).addContent(".load(")).addContent(providerType.genericTypeName())).addContentLine(".class));");
        if (propertyConfigured) {
            TypeName typeName = property.typeHandler().declaredType();
            if (typeName.isList() || typeName.isSet()) {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent("this.add")).addContent(CodegenUtil.capitalize((String)property.name()))).addContent("(")).addContent(Types.CONFIG_BUILDER_SUPPORT)).addContent(".discoverServices(config, \"")).addContent(configuredOption.configKey())).addContent("\", serviceLoader, ")).addContent(providerType.genericTypeName())).addContent(".class, ")).addContent(property.typeHandler().actualType().genericTypeName())).addContent(".class, ")).addContent(property.name())).addContent("DiscoverServices, ")).addContent(property.name())).addContentLine("));");
            } else {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent(Types.CONFIG_BUILDER_SUPPORT)).addContent(".discoverService(config, \"")).addContent(configuredOption.configKey())).addContent("\", serviceLoader, ")).addContent(providerType)).addContent(".class, ")).addContent(property.typeHandler().actualType().genericTypeName())).addContent(".class, ")).addContent(property.name())).addContent("DiscoverServices, ")).addContent(Optional.class)).addContent(".ofNullable(")).addContent(property.name())).addContent(")).ifPresent(this::")).addContent(property.setterName())).addContentLine(");");
            }
        } else if (defaultDiscoverServices) {
            preBuildBuilder.addContentLine("this." + property.name() + "(serviceLoader.asList());");
        }
        preBuildBuilder.addContentLine("}");
    }

    private static void serviceRegistryProperty(Method.Builder preBuildBuilder, PrototypeProperty property) {
        TypeName typeName = property.typeHandler().declaredType();
        if (typeName.isList()) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent("this.add")).addContent(CodegenUtil.capitalize((String)property.name()))).addContent("(")).addContent(Types.REGISTRY_BUILDER_SUPPORT)).addContent(".serviceList(registry, ")).addContentCreate(property.typeHandler().actualType())).addContent(", ")).addContent(property.name())).addContentLine("DiscoverServices));");
        } else if (typeName.isSet()) {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent("this.add")).addContent(CodegenUtil.capitalize((String)property.name()))).addContent("(")).addContent(Types.REGISTRY_BUILDER_SUPPORT)).addContent(".serviceSet(registry, ")).addContentCreate(property.typeHandler().actualType())).addContent(", ")).addContent(property.name())).addContentLine("DiscoverServices));");
        } else {
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent(Types.REGISTRY_BUILDER_SUPPORT)).addContent(".service(registry, ")).addContentCreate(property.typeHandler().actualType())).addContent(", ")).addContent(Optional.class)).addContent(".ofNullable(")).addContent(property.name())).addContent("), ")).addContent(property.name())).addContent("DiscoverServices).ifPresent(this::")).addContent(property.setterName())).addContentLine(");");
        }
    }

    private static void serviceRegistryPropertyDiscovery(Method.Builder preBuildBuilder, PrototypeProperty property, boolean propertyConfigured, AnnotationDataOption configuredOption, TypeName providerType, boolean defaultDiscoverServices) {
        if (propertyConfigured) {
            TypeName typeName = property.typeHandler().declaredType();
            if (typeName.isList() || typeName.isSet()) {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent("this.add")).addContent(CodegenUtil.capitalize((String)property.name()))).addContent("(")).addContent(Types.CONFIG_BUILDER_SUPPORT)).addContentLine(".discoverServices(config,")).increaseContentPadding()).increaseContentPadding()).increaseContentPadding()).addContent("\"")).addContent(configuredOption.configKey())).addContentLine("\",")).addContentLine("registry,")).addContent(providerType.genericTypeName())).addContentLine(".class,")).addContent(property.typeHandler().actualType().genericTypeName())).addContentLine(".class,")).addContent(property.name())).addContentLine("DiscoverServices,")).addContent(property.name())).addContentLine("));")).decreaseContentPadding()).decreaseContentPadding()).decreaseContentPadding();
            } else {
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)preBuildBuilder.addContent(Types.CONFIG_BUILDER_SUPPORT)).addContentLine(".discoverService(config,")).increaseContentPadding()).increaseContentPadding()).increaseContentPadding()).addContent("\"")).addContent(configuredOption.configKey())).addContentLine("\",")).addContentLine("registry,")).addContent(providerType)).addContentLine(".class,")).addContent(property.typeHandler().actualType().genericTypeName())).addContentLine(".class,")).addContent(property.name())).addContentLine("DiscoverServices,")).addContent(Optional.class)).addContent(".ofNullable(")).addContent(property.name())).addContentLine("))")).decreaseContentPadding()).decreaseContentPadding()).addContent(".ifPresent(this::")).addContent(property.setterName())).addContentLine(");")).decreaseContentPadding();
            }
        } else if (defaultDiscoverServices) {
            ((Method.Builder)((Method.Builder)preBuildBuilder.addContent("this." + property.name() + "(registry.all(")).addContent(providerType.genericTypeName())).addContentLine(".class));");
        }
    }

    private static void validatePrototypeMethod(InnerClass.Builder classBuilder, TypeContext typeContext) {
        Method.Builder validateBuilder = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("validatePrototype")).accessModifier(AccessModifier.PROTECTED)).description("Validates required properties.");
        typeContext.typeInfo().superPrototype().ifPresent(it -> validateBuilder.addContentLine("super.validatePrototype();"));
        TypeContext.PropertyData propertyData = typeContext.propertyData();
        if (propertyData.hasRequired() || propertyData.hasNonNulls() || propertyData.hasAllowedValues()) {
            GenerateAbstractBuilder.requiredValidation(validateBuilder, typeContext);
        }
        classBuilder.addMethod(validateBuilder);
    }

    private static void requiredValidation(Method.Builder validateBuilder, TypeContext typeContext) {
        ((Method.Builder)((Method.Builder)((Method.Builder)validateBuilder.addContent(Errors.Collector.class)).addContent(" collector = ")).addContent(Errors.class)).addContentLine(".collector();");
        for (PrototypeProperty property : typeContext.propertyData().properties()) {
            String configKey = property.configuredOption().configKey();
            String propertyName = property.name();
            if (property.configuredOption().validateNotNull() && !property.configuredOption().hasDefault()) {
                ((Method.Builder)((Method.Builder)validateBuilder.addContentLine("if (" + propertyName + " == null) {")).addContent("collector.fatal(getClass(), \"Property \\\"")).addContent(configKey == null ? propertyName : configKey);
                if (property.configuredOption().required()) {
                    validateBuilder.addContentLine("\\\" is required, but not set\");");
                } else {
                    validateBuilder.addContentLine("\\\" must not be null, but not set\");");
                }
                validateBuilder.addContentLine("}");
            }
            if (!property.configuredOption().hasAllowedValues()) continue;
            String allowedValuesConstant = propertyName.toUpperCase(Locale.ROOT) + "_ALLOWED_VALUES";
            TypeName declaredType = property.typeHandler().declaredType();
            if (declaredType.isList() || declaredType.isSet()) {
                String single = "single" + CodegenUtil.capitalize((String)propertyName);
                validateBuilder.addContentLine("for (var " + single + " : " + propertyName + ") {");
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)validateBuilder.addContentLine("if (!" + allowedValuesConstant + ".contains(String.valueOf(" + single + "))) {")).addContent("collector.fatal(getClass(), \"Property \\\"")).addContent(configKey == null ? propertyName : configKey)).addContent("\\\" contains value that is not within allowed values. Configured: \\\"\" + " + single + " + \"\\\"")).addContentLine(", expected one of: \\\"\" + " + allowedValuesConstant + " + \"\\\"\");");
                validateBuilder.addContentLine("}");
                validateBuilder.addContentLine("}");
                continue;
            }
            validateBuilder.addContent("if (");
            if (!declaredType.primitive()) {
                validateBuilder.addContent(propertyName + " != null && ");
            }
            ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)validateBuilder.addContentLine("!" + allowedValuesConstant + ".contains(String.valueOf(" + propertyName + "))) {")).addContent("collector.fatal(getClass(), \"Property \\\"")).addContent(configKey == null ? propertyName : configKey)).addContent("\\\" value is not within allowed values. Configured: \\\"\" + " + propertyName + " + \"\\\"")).addContentLine(", expected one of: \\\"\" + " + allowedValuesConstant + " + \"\\\"\");");
            validateBuilder.addContentLine("}");
        }
        validateBuilder.addContentLine("collector.collect().checkValid();");
    }

    private static void generatePrototypeImpl(InnerClass.Builder classBuilder, TypeContext typeContext, List<TypeArgument> typeArguments, List<TypeName> typeArgumentNames) {
        Optional<TypeName> superPrototype = typeContext.typeInfo().superPrototype();
        TypeName prototype = typeContext.typeInfo().prototype();
        TypeName prototypeImpl = typeContext.typeInfo().prototypeImpl();
        String ifaceName = prototype.className();
        String implName = prototypeImpl.className();
        classBuilder.addInnerClass(builder -> {
            typeArguments.forEach(arg_0 -> ((InnerClass.Builder)builder).addGenericArgument(arg_0));
            ((InnerClass.Builder)((InnerClass.Builder)builder.name(implName)).accessModifier(AccessModifier.PROTECTED)).isStatic(true).description("Generated implementation of the prototype, can be extended by descendant prototype implementations.");
            superPrototype.ifPresent(it -> builder.superType(TypeName.create((String)(it.className() + "Impl"))));
            builder.addInterface(prototype);
            if (typeContext.blueprintData().isFactory()) {
                builder.addInterface(((TypeName.Builder)((TypeName.Builder)TypeName.builder().type(Supplier.class)).addTypeArgument(typeContext.typeInfo().runtimeObject().orElse(typeContext.typeInfo().prototype()))).build());
            }
            GenerateAbstractBuilder.fields(builder, typeContext, false);
            builder.addConstructor(constructor -> {
                ((Constructor.Builder)((Constructor.Builder)constructor.description("Create an instance providing a builder.")).accessModifier(AccessModifier.PROTECTED)).addParameter(param -> ((Parameter.Builder)param.name("builder")).type(((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)((TypeName.Builder)TypeName.builder().from(TypeName.create((String)(ifaceName + ".BuilderBase")))).addTypeArguments(typeArgumentNames)).addTypeArgument((TypeName)TypeArgument.create((String)"?"))).addTypeArgument((TypeName)TypeArgument.create((String)"?"))).build()).description("extending builder base of this prototype"));
                superPrototype.ifPresent(it -> constructor.addContentLine("super(builder);"));
                GenerateAbstractBuilder.implAssignToFields(constructor, typeContext);
            });
            if (typeContext.blueprintData().isFactory()) {
                GenerateAbstractBuilder.buildRuntimeObjectMethod(builder, typeContext, false);
            }
            for (CustomMethods.CustomMethod customMethod : typeContext.customMethods().prototypeMethods()) {
                CustomMethods.Method generated = customMethod.generatedMethod().method();
                Method.Builder method = ((Method.Builder)Method.builder().name(generated.name())).returnType(generated.returnType());
                for (String annotation : customMethod.generatedMethod().annotations()) {
                    method.addAnnotation(io.helidon.codegen.classmodel.Annotation.parse((String)annotation));
                }
                if (!customMethod.generatedMethod().annotations().contains(Override.class.getName())) {
                    method.addAnnotation(Annotations.OVERRIDE);
                }
                generated.arguments().forEach(argument -> method.addParameter(param -> ((Parameter.Builder)param.name(argument.name())).type(argument.typeName())));
                customMethod.generatedMethod().generateCode().accept((ContentBuilder<?>)method);
                builder.addMethod(method);
            }
            GenerateAbstractBuilder.implMethods(builder, typeContext);
            GenerateAbstractBuilder.toString(builder, typeContext, ifaceName, superPrototype.isPresent(), typeContext.customMethods().prototypeMethods(), false);
            GenerateAbstractBuilder.hashCodeAndEquals(builder, typeContext, ifaceName, superPrototype.isPresent());
        });
    }

    private static void hashCodeAndEquals(InnerClass.Builder classBuilder, TypeContext typeContext, String ifaceName, boolean hasSuper) {
        List<PrototypeProperty> equalityFields = typeContext.propertyData().properties().stream().filter(PrototypeProperty::equality).toList();
        GenerateAbstractBuilder.equalsMethod(classBuilder, ifaceName, hasSuper, equalityFields);
        GenerateAbstractBuilder.hashCodeMethod(classBuilder, hasSuper, equalityFields);
    }

    private static void equalsMethod(InnerClass.Builder classBuilder, String ifaceName, boolean hasSuper, List<PrototypeProperty> equalityFields) {
        String newLine = "\n<<padding>><<padding>>&& ";
        Method.Builder method = (Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("equals")).returnType(TypeName.create(Boolean.TYPE)).addAnnotation(Annotations.OVERRIDE)).addParameter(param -> ((Parameter.Builder)param.name("o")).type(Object.class))).addContentLine("if (o == this) {")).addContentLine("return true;")).addContentLine("}")).addContentLine("if (!(o instanceof " + ifaceName + " other)) {")).addContentLine("return false;")).addContentLine("}");
        ((Method.Builder)method.addContent("return ")).increaseContentPadding();
        if (hasSuper) {
            method.addContent("super.equals(other)");
            if (!equalityFields.isEmpty()) {
                method.addContent(newLine);
            }
        }
        if (!hasSuper && equalityFields.isEmpty()) {
            method.addContent("true");
        } else {
            Iterator<PrototypeProperty> equalIterator = equalityFields.iterator();
            while (equalIterator.hasNext()) {
                PrototypeProperty field = equalIterator.next();
                if (field.typeName().array()) {
                    ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(Arrays.class)).addContent(".equals(")).addContent(field.name())).addContent(", other.")).addContent(field.getterName())).addContent("())");
                } else if (field.typeName().primitive()) {
                    ((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(field.name())).addContent(" == other.")).addContent(field.getterName())).addContent("()");
                } else if (field.typeName().isOptional() && field.typeHandler().actualType().equals((Object)Types.CHAR_ARRAY)) {
                    ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(Types.GENERATED_EQUALITY_UTIL)).addContent(".optionalCharArrayEquals(")).addContent(field.name())).addContent(", other.")).addContent(field.getterName())).addContent("())");
                } else {
                    ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(Objects.class)).addContent(".equals(")).addContent(field.name())).addContent(", other.")).addContent(field.getterName())).addContent("())");
                }
                if (!equalIterator.hasNext()) continue;
                ((Method.Builder)method.addContentLine("")).addContent("&& ");
            }
        }
        method.addContentLine(";");
        classBuilder.addMethod(method);
    }

    private static void hashCodeMethod(InnerClass.Builder classBuilder, boolean hasSuper, List<PrototypeProperty> equalityFields) {
        Method.Builder method = (Method.Builder)((Method.Builder)Method.builder().name("hashCode")).returnType(TypeName.create(Integer.TYPE)).addAnnotation(Annotations.OVERRIDE);
        if (equalityFields.isEmpty()) {
            if (hasSuper) {
                method.addContentLine("return super.hashCode();");
            } else {
                method.addContentLine("return 1;");
            }
        } else {
            if (hasSuper) {
                ((Method.Builder)((Method.Builder)method.addContent("return 31 * super.hashCode() + ")).addContent(Objects.class)).addContent(".hash(");
            } else {
                ((Method.Builder)((Method.Builder)method.addContent("return ")).addContent(Objects.class)).addContent(".hash(");
            }
            ((Method.Builder)method.addContent(equalityFields.stream().filter(it -> !it.typeName().isOptional() || !it.typeHandler().actualType().equals((Object)Types.CHAR_ARRAY)).map(PrototypeProperty::name).collect(Collectors.joining(", ")))).addContent(")");
            for (PrototypeProperty field : equalityFields) {
                if (!field.typeName().isOptional() || !field.typeHandler().actualType().equals((Object)Types.CHAR_ARRAY)) continue;
                ((Method.Builder)((Method.Builder)((Method.Builder)((Method.Builder)method.addContent(" + 31 * ")).addContent(Types.GENERATED_EQUALITY_UTIL)).addContent(".optionalCharArrayHash(")).addContent(field.name())).addContent(")");
            }
            method.addContent(";");
        }
        classBuilder.addMethod(method);
    }

    private static void toString(InnerClass.Builder classBuilder, TypeContext typeContext, String typeName, boolean hasSuper, List<CustomMethods.CustomMethod> prototypeMethods, boolean isBuilder) {
        if (prototypeMethods.stream().map(CustomMethods.CustomMethod::generatedMethod).map(CustomMethods.GeneratedMethod::method).filter(it -> "toString".equals(it.name())).filter(it -> it.returnType().equals((Object)TypeNames.STRING)).anyMatch(it -> it.arguments().isEmpty())) {
            return;
        }
        Method.Builder method = (Method.Builder)((Method.Builder)((Method.Builder)Method.builder().name("toString")).returnType(TypeName.create(String.class)).addAnnotation(Annotations.OVERRIDE)).addContent("return \"" + typeName);
        List<PrototypeProperty> toStringFields = typeContext.propertyData().properties().stream().filter(PrototypeProperty::toStringValue).toList();
        if (toStringFields.isEmpty()) {
            method.addContentLine("{};\"");
        } else {
            ((Method.Builder)((Method.Builder)((Method.Builder)method.addContentLine("{\"")).increaseContentPadding()).increaseContentPadding()).addContentLine(toStringFields.stream().map(it -> {
                boolean secret = it.confidential() || it.typeHandler().actualType().equals((Object)Types.CHAR_ARRAY);
                String name = it.name();
                if (secret) {
                    if (it.typeName().primitive() && !it.typeName().array()) {
                        return "+ \"" + name + "=****\"";
                    }
                    if (!isBuilder && it.typeName().genericTypeName().equals((Object)TypeNames.OPTIONAL)) {
                        return "+ \"" + name + "=\" + (" + name + ".isPresent() ? \"****\" : \"null\")";
                    }
                    return "+ \"" + name + "=\" + (" + name + " == null ? \"null\" : \"****\")";
                }
                return "+ \"" + name + "=\" + " + name;
            }).collect(Collectors.joining(" + \",\"\n")));
            if (hasSuper) {
                method.addContentLine("+ \"};\"");
            } else {
                method.addContent("+ \"}\"");
            }
        }
        if (hasSuper) {
            method.addContent("+ super.toString()");
        }
        method.addContentLine(";");
        classBuilder.addMethod(method);
    }

    private static void implMethods(InnerClass.Builder classBuilder, TypeContext typeContext) {
        for (PrototypeProperty child : typeContext.propertyData().properties()) {
            String fieldName = child.name();
            String getterName = child.getterName();
            classBuilder.addMethod(method -> ((Method.Builder)((Method.Builder)method.name(getterName)).returnType(child.typeHandler().declaredType()).addAnnotation(Annotations.OVERRIDE)).addContentLine("return " + fieldName + ";"));
        }
    }

    private static void implAssignToFields(Constructor.Builder constructor, TypeContext typeContext) {
        for (PrototypeProperty child : typeContext.propertyData().properties()) {
            constructor.addContent("this." + child.name() + " = ");
            TypeName declaredType = child.typeHandler().declaredType();
            if (declaredType.genericTypeName().equals((Object)TypeNames.LIST)) {
                ((Constructor.Builder)constructor.addContent(List.class)).addContentLine(".copyOf(builder." + child.getterName() + "());");
                continue;
            }
            if (declaredType.genericTypeName().equals((Object)TypeNames.SET)) {
                ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)constructor.addContent(Collections.class)).addContent(".unmodifiableSet(new ")).addContent(LinkedHashSet.class)).addContentLine("<>(builder." + child.getterName() + "()));");
                continue;
            }
            if (declaredType.genericTypeName().equals((Object)TypeNames.MAP)) {
                ((Constructor.Builder)((Constructor.Builder)((Constructor.Builder)constructor.addContent(Collections.class)).addContent(".unmodifiableMap(new ")).addContent(LinkedHashMap.class)).addContentLine("<>(builder." + child.getterName() + "()));");
                continue;
            }
            if (child.builderGetterOptional() && !declaredType.isOptional()) {
                constructor.addContentLine("builder." + child.getterName() + "().get();");
                continue;
            }
            constructor.addContentLine("builder." + child.getterName() + "();");
        }
    }

    private static String toHumanReadable(String name) {
        char[] nameChars;
        StringBuilder result = new StringBuilder();
        for (char nameChar : nameChars = name.toCharArray()) {
            if (Character.isUpperCase(nameChar)) {
                if (!result.isEmpty()) {
                    result.append(' ');
                }
                result.append(Character.toLowerCase(nameChar));
                continue;
            }
            result.append(nameChar);
        }
        return result.toString();
    }
}

