/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen.jackson;

import io.helidon.builder.codegen.jackson.JacksonBuilderExtension;
import io.helidon.builder.codegen.jackson.JacksonTypes;
import io.helidon.builder.codegen.spi.BuilderCodegenExtension;
import io.helidon.builder.codegen.spi.BuilderCodegenExtensionProvider;
import io.helidon.common.types.TypeName;

public class JacksonBuilderExtensionProvider
implements BuilderCodegenExtensionProvider {
    public boolean supports(TypeName type) {
        return type.equals((Object)JacksonTypes.JSON_SERIALIZE) || type.equals((Object)JacksonTypes.JSON_DESERIALIZE);
    }

    public BuilderCodegenExtension create(TypeName ... supportedTypes) {
        boolean serialize = false;
        boolean deserialize = false;
        for (TypeName supportedType : supportedTypes) {
            if (supportedType.equals((Object)JacksonTypes.JSON_SERIALIZE)) {
                serialize = true;
                continue;
            }
            if (supportedType.equals((Object)JacksonTypes.JSON_DESERIALIZE)) {
                deserialize = true;
                continue;
            }
            throw new IllegalArgumentException("Unsupported type in Jackson extension: " + String.valueOf(supportedType));
        }
        return new JacksonBuilderExtension(serialize, deserialize);
    }
}

