/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.codegen.jackson;

import io.helidon.builder.codegen.GeneratedMethod;
import io.helidon.builder.codegen.OptionInfo;
import io.helidon.builder.codegen.OptionMethodType;
import io.helidon.builder.codegen.PrototypeInfo;
import io.helidon.builder.codegen.jackson.JacksonTypes;
import io.helidon.builder.codegen.spi.BuilderCodegenExtension;
import io.helidon.codegen.classmodel.ClassModel;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypedElementInfo;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;

class JacksonBuilderExtension
implements BuilderCodegenExtension {
    public static final String JACKSON_PACKAGE_PREFIX = "com.fasterxml.jackson";
    private final boolean serialize;
    private final boolean deserialize;

    JacksonBuilderExtension(boolean serialize, boolean deserialize) {
        this.serialize = serialize;
        this.deserialize = deserialize;
    }

    public Optional<GeneratedMethod> method(OptionInfo optionInfo, GeneratedMethod method, OptionMethodType methodType) {
        if (methodType == OptionMethodType.PROTOTYPE_GETTER) {
            return Optional.of(this.updateImplGetter(optionInfo, method));
        }
        if (methodType == OptionMethodType.BUILDER_SETTER && this.serialize) {
            return Optional.of(this.updateBuilderSetter(optionInfo, method));
        }
        return Optional.of(method);
    }

    public void updatePrototype(PrototypeInfo prototypeInfo, List<OptionInfo> options, ClassModel.Builder classModel) {
        if (!this.deserialize) {
            return;
        }
        TypeName builderType = ((TypeName.Builder)((TypeName.Builder)TypeName.builder((TypeName)prototypeInfo.prototypeType()).className("Builder")).addEnclosingName(prototypeInfo.prototypeType().className())).build();
        classModel.addAnnotation(((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(JacksonTypes.JSON_DESERIALIZE)).putValue("builder", (Object)builderType)).build());
        classModel.addAnnotation(((Annotation.Builder)((Annotation.Builder)Annotation.builder().typeName(JacksonTypes.JSON_POJO_BUILDER)).putValue("withPrefix", (Object)(prototypeInfo.recordStyle() ? "" : "set"))).build());
    }

    private GeneratedMethod updateBuilderSetter(OptionInfo optionInfo, GeneratedMethod method) {
        if (optionInfo.interfaceMethod().isEmpty()) {
            return method;
        }
        TypedElementInfo ifaceMethod = (TypedElementInfo)optionInfo.interfaceMethod().get();
        GeneratedMethod.Builder gmBuilder = GeneratedMethod.builder((GeneratedMethod)method);
        TypedElementInfo.Builder methodBuilder = TypedElementInfo.builder((TypedElementInfo)method.method());
        for (Annotation annotation : ifaceMethod.annotations()) {
            if (!annotation.typeName().packageName().startsWith(JACKSON_PACKAGE_PREFIX)) continue;
            methodBuilder.addAnnotation(annotation);
        }
        return ((GeneratedMethod.Builder)gmBuilder.method((Supplier)methodBuilder)).build();
    }

    private GeneratedMethod updateImplGetter(OptionInfo optionInfo, GeneratedMethod method) {
        if (optionInfo.interfaceMethod().isEmpty()) {
            return method;
        }
        TypedElementInfo ifaceMethod = (TypedElementInfo)optionInfo.interfaceMethod().get();
        GeneratedMethod.Builder gmBuilder = GeneratedMethod.builder((GeneratedMethod)method);
        TypedElementInfo.Builder methodBuilder = TypedElementInfo.builder((TypedElementInfo)method.method());
        for (Annotation annotation : ifaceMethod.annotations()) {
            if (!annotation.typeName().packageName().startsWith(JACKSON_PACKAGE_PREFIX)) continue;
            methodBuilder.addAnnotation(annotation);
        }
        return ((GeneratedMethod.Builder)gmBuilder.method((Supplier)methodBuilder)).build();
    }
}

