/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.api;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Set;

public final class Prototype {
    private Prototype() {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Extensions {
        public Extension[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    @Repeatable(value=Extensions.class)
    public static @interface Extension {
        public Class<?> value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface IncludeDefaultMethods {
        public String[] value() default {};
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface RegistrySupport {
        public boolean value() default true;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Implement {
        public String[] value();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Constant {
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface PrototypeMethod {
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface BuilderMethod {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface CustomMethods {
        public Class<?> value();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface RuntimeTypeFactoryMethod {
        public String value() default "";

        public String builderMethodName() default "builder";

        public String buildMethodName() default "build";

        public Class<?> builderType() default RuntimeTypeFactoryMethod.class;

        public Class<?> builderMethodType() default RuntimeTypeFactoryMethod.class;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface ConfigFactoryMethod {
        public String value() default "";
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface PrototypeFactoryMethod {
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    @Deprecated(forRemoval=true, since="4.4.0")
    public static @interface FactoryMethod {
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Annotated {
        public String[] value();
    }

    @FunctionalInterface
    public static interface OptionDecorator<B, T> {
        public void decorate(B var1, T var2);

        default public void decorateSetList(B builder, List<T> optionValues) {
        }

        default public void decorateAddList(B builder, List<T> optionValues) {
        }

        default public void decorateSetSet(B builder, Set<T> optionValues) {
        }

        default public void decorateAddSet(B builder, Set<T> optionValues) {
        }
    }

    @FunctionalInterface
    public static interface BuilderDecorator<T> {
        public void decorate(T var1);
    }

    @Target(value={ElementType.TYPE})
    @Inherited
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Provides {
        public Class<?>[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Configured {
        public String value() default "";

        public boolean root() default true;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Blueprint {
        public boolean isPublic() default true;

        public boolean builderPublic() default true;

        public boolean createFromConfigPublic() default true;

        public boolean createEmptyPublic() default true;

        public boolean beanStyle() default false;

        public Class<? extends BuilderDecorator> decorator() default BuilderDecorator.class;

        public boolean detach() default false;
    }

    public static interface Factory<T> {
        public T build();
    }

    public static interface Builder<BUILDER, PROTOTYPE> {
        public PROTOTYPE buildPrototype();

        default public BUILDER self() {
            return (BUILDER)this;
        }
    }

    public static interface Api {
    }
}

