/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.api;

import io.helidon.builder.api.ProvidedUtil;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfiguredProvider;
import io.helidon.common.config.NamedService;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Optional;

public final class Prototype {
    private Prototype() {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface RegistrySupport {
        public boolean value() default true;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Implement {
        public String[] value();
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Constant {
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface PrototypeMethod {
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface BuilderMethod {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface CustomMethods {
        public Class<?> value();
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface FactoryMethod {
    }

    @Target(value={ElementType.METHOD, ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Annotated {
        public String[] value();
    }

    @FunctionalInterface
    public static interface OptionDecorator<B, T> {
        public void decorate(B var1, T var2);
    }

    @FunctionalInterface
    public static interface BuilderDecorator<T> {
        public void decorate(T var1);
    }

    @Target(value={ElementType.TYPE})
    @Inherited
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Provides {
        public Class<?>[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Configured {
        public String value() default "";

        public boolean root() default true;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.CLASS)
    public static @interface Blueprint {
        public boolean isPublic() default true;

        public boolean builderPublic() default true;

        public boolean createFromConfigPublic() default true;

        public boolean createEmptyPublic() default true;

        public boolean beanStyle() default false;

        public Class<? extends BuilderDecorator> decorator() default BuilderDecorator.class;
    }

    public static interface Factory<T> {
        public T build();
    }

    public static interface ConfiguredBuilder<BUILDER, PROTOTYPE>
    extends Builder<BUILDER, PROTOTYPE> {
        public BUILDER config(Config var1);

        default public <S extends NamedService, T extends ConfiguredProvider<S>> List<S> discoverServices(Config config, String configKey, HelidonServiceLoader<T> serviceLoader, Class<T> providerType, Class<S> configType, boolean allFromServiceLoader, List<S> existingInstances) {
            return ProvidedUtil.discoverServices(config, configKey, serviceLoader, providerType, configType, allFromServiceLoader, existingInstances);
        }

        default public <S extends NamedService, T extends ConfiguredProvider<S>> Optional<S> discoverService(Config config, String configKey, HelidonServiceLoader<T> serviceLoader, Class<T> providerType, Class<S> configType, boolean allFromServiceLoader, Optional<S> existingValue) {
            return ProvidedUtil.discoverService(config, configKey, serviceLoader, providerType, configType, allFromServiceLoader, existingValue);
        }
    }

    public static interface Builder<BUILDER, PROTOTYPE> {
        public PROTOTYPE buildPrototype();

        default public BUILDER self() {
            return (BUILDER)this;
        }
    }

    public static interface Api {
    }
}

