/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.builder.api;

import io.helidon.builder.api.Prototype;
import io.helidon.common.HelidonServiceLoader;
import io.helidon.common.config.Config;
import io.helidon.common.config.ConfigException;
import io.helidon.common.config.ConfiguredProvider;
import io.helidon.common.config.NamedService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;

final class ProvidedUtil {
    private static final System.Logger PROVIDER_LOGGER = System.getLogger(Prototype.class.getName() + ".provider");
    private static final String KEY_SERVICE_TYPE = "type";
    private static final String KEY_SERVICE_NAME = "name";
    private static final String KEY_SERVICE_ENABLED = "enabled";

    private ProvidedUtil() {
    }

    static <T extends NamedService> Optional<T> discoverService(Config config, String configKey, HelidonServiceLoader<? extends ConfiguredProvider<T>> serviceLoader, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, boolean discoverServices, Optional<T> existingValue) {
        if (existingValue.isPresent()) {
            return Optional.empty();
        }
        List serviceConfigList = (List)config.get(configKey).asNodeList().orElseGet(List::of);
        if (serviceConfigList.size() > 1) {
            throw new ConfigException("There can only be one provider configured for " + String.valueOf(config.key()));
        }
        List<T> services = ProvidedUtil.discoverServices(config, configKey, serviceLoader, providerType, configType, discoverServices, List.of());
        return services.isEmpty() ? Optional.empty() : Optional.of((NamedService)services.getFirst());
    }

    static <T extends NamedService> List<T> discoverServices(Config config, String configKey, HelidonServiceLoader<? extends ConfiguredProvider<T>> serviceLoader, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, boolean allFromServiceLoader, List<T> existingInstances) {
        HashSet<TypeAndName> ignoredServices = new HashSet<TypeAndName>();
        existingInstances.forEach(it -> ignoredServices.add(new TypeAndName(it.type(), it.name())));
        boolean discoverServices = (Boolean)config.get(configKey + "-discover-services").asBoolean().orElse((Object)allFromServiceLoader);
        Config providersConfig = config.get(configKey);
        ArrayList<ConfiguredService> configuredServices = new ArrayList<ConfiguredService>();
        List serviceConfigList = (List)providersConfig.asNodeList().orElseGet(List::of);
        boolean isList = providersConfig.isList();
        for (Config serviceConfig : serviceConfigList) {
            configuredServices.add(ProvidedUtil.configuredService(serviceConfig, isList));
        }
        if (providersConfig.isList()) {
            return ProvidedUtil.servicesFromList(serviceLoader, providerType, configType, configuredServices, discoverServices, ignoredServices);
        }
        return ProvidedUtil.servicesFromObject(providersConfig, serviceLoader, providerType, configType, configuredServices, discoverServices, ignoredServices);
    }

    private static <T extends NamedService> List<T> servicesFromObject(Config providersConfig, HelidonServiceLoader<? extends ConfiguredProvider<T>> serviceLoader, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, List<ConfiguredService> configuredServices, boolean allFromServiceLoader, Set<TypeAndName> ignoredServices) {
        HashSet availableProviders = new HashSet();
        HashMap allConfigs = new HashMap();
        configuredServices.forEach(it -> allConfigs.put(it.typeAndName().type, it));
        HashSet unusedConfigs = new HashSet(allConfigs.keySet());
        ArrayList result = new ArrayList();
        serviceLoader.forEach(provider -> {
            ConfiguredService configuredService = (ConfiguredService)allConfigs.get(provider.configKey());
            availableProviders.add(provider.configKey());
            unusedConfigs.remove(provider.configKey());
            if (configuredService == null) {
                if (allFromServiceLoader) {
                    String type = provider.configKey();
                    if (ignoredServices.add(new TypeAndName(type, type))) {
                        result.add(provider.create(providersConfig.get(type), type));
                    } else if (PROVIDER_LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                        PROVIDER_LOGGER.log(System.Logger.Level.DEBUG, "Service: " + String.valueOf(new TypeAndName(type, type)) + " is already added in builder, ignoring configured one.");
                    }
                }
            } else if (configuredService.enabled()) {
                if (ignoredServices.add(configuredService.typeAndName())) {
                    result.add(provider.create(configuredService.serviceConfig(), configuredService.typeAndName().name()));
                } else if (PROVIDER_LOGGER.isLoggable(System.Logger.Level.DEBUG)) {
                    PROVIDER_LOGGER.log(System.Logger.Level.DEBUG, "Service: " + String.valueOf(configuredService.typeAndName()) + " is already added in builder, ignoring configured one.");
                }
            }
        });
        if (!unusedConfigs.isEmpty()) {
            throw new ConfigException("Unknown provider configured. Expected providers with types: " + String.valueOf(unusedConfigs) + ", but only the following providers are supported: " + String.valueOf(availableProviders) + ", provider interface: " + providerType.getName() + ", configured service: " + configType.getName());
        }
        return result;
    }

    private static <T extends NamedService> List<T> servicesFromList(HelidonServiceLoader<? extends ConfiguredProvider<T>> serviceLoader, Class<? extends ConfiguredProvider<T>> providerType, Class<T> configType, List<ConfiguredService> configuredServices, boolean allFromServiceLoader, Set<TypeAndName> ignoredServices) {
        HashMap allProvidersByType = new HashMap();
        LinkedHashMap<String, ConfiguredProvider> unusedProvidersByType = new LinkedHashMap<String, ConfiguredProvider>();
        serviceLoader.forEach(it -> {
            allProvidersByType.put(it.configKey(), it);
            unusedProvidersByType.put(it.configKey(), (ConfiguredProvider)it);
        });
        ArrayList<NamedService> result = new ArrayList<NamedService>();
        for (ConfiguredService service : configuredServices) {
            TypeAndName typeAndName = service.typeAndName();
            if (!ignoredServices.add(typeAndName)) {
                unusedProvidersByType.remove(typeAndName.type());
                if (!PROVIDER_LOGGER.isLoggable(System.Logger.Level.DEBUG)) continue;
                PROVIDER_LOGGER.log(System.Logger.Level.DEBUG, "Service: " + String.valueOf(typeAndName) + " is already added in builder, ignoring configured one.");
                continue;
            }
            ConfiguredProvider provider2 = (ConfiguredProvider)allProvidersByType.get(typeAndName.type());
            if (provider2 == null) {
                throw new ConfigException("Unknown provider configured. Expecting a provider with type \"" + typeAndName.type() + "\", but only the following providers are supported: " + String.valueOf(allProvidersByType.keySet()) + ", provider interface: " + providerType.getName() + ", configured service: " + configType.getName());
            }
            unusedProvidersByType.remove(typeAndName.type());
            if (!service.enabled()) continue;
            result.add(provider2.create(service.serviceConfig(), typeAndName.name()));
        }
        if (allFromServiceLoader) {
            unusedProvidersByType.forEach((type, provider) -> {
                if (ignoredServices.add(new TypeAndName((String)type, (String)type))) {
                    result.add(provider.create(Config.empty(), type));
                }
            });
        }
        return result;
    }

    private static ConfiguredService configuredService(Config serviceConfig, boolean isList) {
        if (isList) {
            String type = (String)serviceConfig.get(KEY_SERVICE_TYPE).asString().orElse(null);
            String name = (String)serviceConfig.get(KEY_SERVICE_NAME).asString().orElse((Object)type);
            boolean enabled = (Boolean)serviceConfig.get(KEY_SERVICE_ENABLED).asBoolean().orElse((Object)true);
            Config usedConfig = serviceConfig;
            if (type == null) {
                List configs = (List)serviceConfig.asNodeList().orElseGet(List::of);
                if (configs.size() != 1) {
                    throw new ConfigException("Service provider configuration defined as a list must have a single node that is the type, with children containing the provider configuration. Failed on: " + String.valueOf(serviceConfig.key()));
                }
                usedConfig = (Config)configs.get(0);
                name = usedConfig.name();
                type = (String)usedConfig.get(KEY_SERVICE_TYPE).asString().orElse((Object)name);
                enabled = (Boolean)usedConfig.get(KEY_SERVICE_ENABLED).asBoolean().orElse((Object)enabled);
            }
            return new ConfiguredService(new TypeAndName(type, name), usedConfig, enabled);
        }
        String name = serviceConfig.name();
        String type = (String)serviceConfig.get(KEY_SERVICE_TYPE).asString().orElse((Object)name);
        boolean enabled = (Boolean)serviceConfig.get(KEY_SERVICE_ENABLED).asBoolean().orElse((Object)true);
        return new ConfiguredService(new TypeAndName(type, name), serviceConfig, enabled);
    }

    private record ConfiguredService(TypeAndName typeAndName, Config serviceConfig, boolean enabled) {
    }

    private record TypeAndName(String type, String name) {
    }
}

