/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;

public class Strings {
    public static boolean isValid(String value) {
        return value != null && !value.isBlank();
    }

    public static boolean isNotValid(String value) {
        return value == null || value.isBlank();
    }

    public static String normalizeNewLines(String value) {
        if (value == null) {
            return value;
        }
        return value.replaceAll("\r\n", "\n");
    }

    public static String read(InputStream inputStream) {
        try {
            return new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private Strings() {
    }
}

