/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.ConfigProperties;
import io.helidon.build.util.FileUtils;
import io.helidon.build.util.ProjectDependency;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ProjectConfig
extends ConfigProperties {
    public static final String DOT_HELIDON = ".helidon";
    public static final String SCHEMA_VERSION = "schema.version";
    public static final String CURRENT_SCHEMA_VERSION = "1.1.0";
    public static final String PROJECT_DIRECTORY = "project.directory";
    public static final String PROJECT_FLAVOR = "project.flavor";
    public static final String FEATURE_PREFIX = "feature.";
    public static final String PROJECT_DEPENDENCIES = "project.dependencies";
    public static final String PROJECT_SOURCEDIRS = "project.sourcedirs";
    public static final String PROJECT_SOURCE_INCLUDES = "project.source.includes";
    public static final String PROJECT_SOURCE_EXCLUDES = "project.source.excludes";
    public static final String PROJECT_CLASSDIRS = "project.classdirs";
    public static final String PROJECT_RESOURCEDIRS = "project.resourcedirs";
    public static final String RESOURCE_INCLUDE_EXCLUDE_SEPARATOR = ":";
    public static final String RESOURCE_INCLUDE_EXCLUDE_LIST_SEPARATOR = ";";
    public static final String PROJECT_MAINCLASS = "project.mainclass";
    public static final String PROJECT_VERSION = "project.version";
    public static final String HELIDON_VERSION = "helidon.version";
    public static final String PROJECT_LAST_BUILD_SUCCESS_TIME = "project.last.build.success.time";

    public static boolean projectConfigExists(Path projectDir) {
        return Files.isRegularFile(ProjectConfig.toDotHelidon(projectDir), new LinkOption[0]);
    }

    public static ProjectConfig ensureProjectConfig(Path projectDir, String helidonVersion) {
        Path dotHelidon = ProjectConfig.toDotHelidon(projectDir);
        if (Files.isRegularFile(dotHelidon, new LinkOption[0])) {
            return new ProjectConfig(dotHelidon);
        }
        ProjectConfig config = new ProjectConfig(dotHelidon);
        config.projectDir(projectDir);
        String version = System.getProperty(HELIDON_VERSION, helidonVersion);
        if (version != null) {
            config.property(HELIDON_VERSION, helidonVersion);
        }
        config.store();
        return config;
    }

    public static ProjectConfig projectConfig(Path projectDir) {
        Path dotHelidon = FileUtils.assertExists(ProjectConfig.toDotHelidon(projectDir));
        return new ProjectConfig(dotHelidon);
    }

    public static Path toDotHelidon(Path projectDir) {
        return FileUtils.assertDir(projectDir).resolve(DOT_HELIDON);
    }

    public ProjectConfig(Path file) {
        super(file);
        if (this.property(SCHEMA_VERSION) == null) {
            this.property(SCHEMA_VERSION, CURRENT_SCHEMA_VERSION);
        }
    }

    public Optional<Path> projectDir() {
        String dir = this.property(PROJECT_DIRECTORY);
        return dir == null ? Optional.empty() : Optional.of(Paths.get(dir, new String[0]));
    }

    public void projectDir(Path projectDir) {
        this.property(PROJECT_DIRECTORY, projectDir.toString());
    }

    public List<String> listFeatures() {
        return this.keySet().stream().filter(k -> k.startsWith(FEATURE_PREFIX)).map(k -> k.substring(FEATURE_PREFIX.length())).collect(Collectors.toList());
    }

    public List<ProjectDependency> featureDeps(String feature) {
        return this.entrySet().stream().filter(e -> {
            String s = (String)e.getKey();
            return s.equals(FEATURE_PREFIX + feature);
        }).flatMap(e -> {
            String v = (String)e.getValue();
            return Arrays.stream(v.split(",")).map(d -> {
                String[] ds = d.split(RESOURCE_INCLUDE_EXCLUDE_SEPARATOR);
                return new ProjectDependency(ds[0], ds[1], ds.length > 2 ? ds[2] : null);
            });
        }).collect(Collectors.toList());
    }

    public void buildFailed() {
        this.remove(PROJECT_LAST_BUILD_SUCCESS_TIME);
    }

    public void buildSucceeded() {
        this.property(PROJECT_LAST_BUILD_SUCCESS_TIME, Long.toString(System.currentTimeMillis()));
    }

    public long lastSuccessfulBuildTime() {
        String time = this.property(PROJECT_LAST_BUILD_SUCCESS_TIME);
        return time == null ? 0L : Long.parseLong(time);
    }
}

