/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.FileUtils;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;

public class PomUtils {
    private static final String BUILD_TOOLS_GROUP_ID = "io.helidon.build-tools";
    private static final String BUILD_TOOLS_PLUGIN_ARTIFACT_ID = "helidon-maven-plugin";
    private static final String POM = "pom.xml";
    public static final String HELIDON_PLUGIN_VERSION_PROPERTY = "version.helidon.plugin";

    public static Path toPomFile(Path projectDir) {
        return FileUtils.assertFile(FileUtils.assertDir(projectDir).resolve(POM));
    }

    public static void ensureHelidonPluginConfig(Path projectDir, String helidonPluginVersion) {
        String pluginVersion = System.getProperty(HELIDON_PLUGIN_VERSION_PROPERTY, helidonPluginVersion);
        Path pomFile = PomUtils.toPomFile(projectDir);
        Model model = PomUtils.readPomModel(pomFile);
        boolean propertyAdded = PomUtils.ensurePluginVersion(model, pluginVersion);
        boolean extensionAdded = PomUtils.ensurePlugin(model);
        if (extensionAdded || propertyAdded) {
            PomUtils.writePomModel(pomFile, model);
        }
    }

    public static Model readPomModel(Path pomPath) {
        return PomUtils.readPomModel(pomPath.toFile());
    }

    public static Model readPomModel(File pomFile) {
        Model model;
        FileReader fr = new FileReader(pomFile);
        try {
            MavenXpp3Reader mvnReader = new MavenXpp3Reader();
            model = mvnReader.read((Reader)fr);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fr.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        fr.close();
        return model;
    }

    public static void writePomModel(Path pomPath, Model model) {
        PomUtils.writePomModel(pomPath.toFile(), model);
    }

    public static void writePomModel(File pomFile, Model model) {
        try (FileWriter fw = new FileWriter(pomFile);){
            MavenXpp3Writer mvnWriter = new MavenXpp3Writer();
            mvnWriter.write((Writer)fw, model);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean ensurePluginVersion(Model model, String helidonPluginVersion) {
        Properties properties = model.getProperties();
        String existing = properties.getProperty(HELIDON_PLUGIN_VERSION_PROPERTY);
        if (existing == null || !existing.equals(helidonPluginVersion)) {
            model.addProperty(HELIDON_PLUGIN_VERSION_PROPERTY, helidonPluginVersion);
            return true;
        }
        return false;
    }

    private static boolean ensurePlugin(Model model) {
        Build build = model.getBuild();
        boolean isPresent = build.getPlugins().stream().anyMatch(p -> p.getGroupId().equals(BUILD_TOOLS_GROUP_ID) && p.getArtifactId().equals(BUILD_TOOLS_PLUGIN_ARTIFACT_ID));
        if (isPresent) {
            return false;
        }
        Plugin helidonPlugin = new Plugin();
        helidonPlugin.setGroupId(BUILD_TOOLS_GROUP_ID);
        helidonPlugin.setArtifactId(BUILD_TOOLS_PLUGIN_ARTIFACT_ID);
        helidonPlugin.setVersion("${version.helidon.plugin}");
        helidonPlugin.setExtensions(true);
        build.addPlugin(helidonPlugin);
        return true;
    }

    private PomUtils() {
    }
}

