/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import java.util.function.Predicate;
import org.apache.maven.artifact.versioning.ComparableVersion;

public class MavenVersion
extends ComparableVersion {
    private final boolean qualified;

    private MavenVersion(String version) {
        super(version);
        this.qualified = version.contains("-");
    }

    public static MavenVersion toMavenVersion(String version) {
        return new MavenVersion(version);
    }

    public static Predicate<MavenVersion> unqualifiedMinimum(String minimumVersion) {
        return MavenVersion.notQualified().and(MavenVersion.greaterThanOrEqualTo(minimumVersion));
    }

    public static Predicate<MavenVersion> notQualified() {
        return v -> !v.isQualified();
    }

    public static Predicate<MavenVersion> lessThan(String version) {
        MavenVersion mavenVersion = new MavenVersion(version);
        return v -> v.isLessThan(mavenVersion);
    }

    public static Predicate<MavenVersion> lessThanOrEqualTo(String version) {
        MavenVersion mavenVersion = new MavenVersion(version);
        return v -> v.isLessThanOrEqualTo(mavenVersion);
    }

    public static Predicate<MavenVersion> greaterThan(String version) {
        MavenVersion mavenVersion = new MavenVersion(version);
        return v -> v.isGreaterThan(mavenVersion);
    }

    public static Predicate<MavenVersion> greaterThanOrEqualTo(String version) {
        MavenVersion mavenVersion = new MavenVersion(version);
        return v -> v.isGreaterThanOrEqualTo(mavenVersion);
    }

    public boolean isQualified() {
        return this.qualified;
    }

    public boolean isLessThan(MavenVersion other) {
        return this.compareTo(other) < 0;
    }

    public boolean isLessThanOrEqualTo(MavenVersion other) {
        return this.compareTo(other) <= 0;
    }

    public boolean isGreaterThan(MavenVersion other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEqualTo(MavenVersion other) {
        return this.compareTo(other) >= 0;
    }
}

