/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.AnsiConsoleInstaller;
import io.helidon.build.util.Constants;
import io.helidon.build.util.FileUtils;
import io.helidon.build.util.Log;
import io.helidon.build.util.MavenVersion;
import io.helidon.build.util.PrintStreams;
import io.helidon.build.util.ProcessMonitor;
import io.helidon.build.util.Requirements;
import io.helidon.build.util.StyleFunction;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public class MavenCommand {
    private static final String MAVEN_BINARY_NAME = Constants.OS.mavenExec();
    private static final String MAVEN_HOME_VAR = "MAVEN_HOME";
    private static final String MVN_HOME_VAR = "MVN_HOME";
    private static final String MAVEN_CORE_PREFIX = "maven-core";
    private static final String MAVEN_SHIM_TARGET = "libexec/bin/mvn";
    private static final String JAR_SUFFIX = ".jar";
    private static final String MAVEN_DOWNLOAD_URL = "https://maven.apache.org/download.cgi";
    private static final AtomicReference<Path> MAVEN_EXECUTABLE = new AtomicReference();
    private static final AtomicReference<Path> MAVEN_HOME = new AtomicReference();
    private static final AtomicReference<MavenVersion> MAVEN_VERSION = new AtomicReference();
    private static final String VERSION_ERROR = "$(RED Found Maven version %s.)" + Constants.EOL + "$(bold Version) $(GREEN %s) $(bold or later is required.) Please update from %s and prepend your PATH or set the MAVEN_HOME or MVN_HOME environment variable.";
    private final String name;
    private final ProcessBuilder processBuilder;
    private final int maxWaitSeconds;
    private final PrintStream stdOut;
    private final PrintStream stdErr;
    private final Predicate<String> filter;
    private final Function<String, String> transform;
    private final Runnable beforeShutdown;
    private final Runnable afterShutdown;

    public static Builder builder() {
        return new Builder();
    }

    private MavenCommand(Builder builder) {
        this.name = builder.description;
        this.processBuilder = builder.processBuilder;
        this.maxWaitSeconds = builder.maxWaitSeconds;
        this.stdOut = builder.stdOut;
        this.stdErr = builder.stdErr;
        this.filter = builder.filter;
        this.transform = builder.transform;
        this.beforeShutdown = builder.beforeShutdown;
        this.afterShutdown = builder.afterShutdown;
    }

    public static Path mavenExecutable() {
        if (MAVEN_EXECUTABLE.get() == null) {
            Path maven;
            Optional<Path> path = FileUtils.findExecutableInPath(MAVEN_BINARY_NAME);
            if (path.isPresent()) {
                maven = path.get();
            } else {
                maven = MavenCommand.toMavenExecutable(MAVEN_HOME_VAR);
                if (maven == null && (maven = MavenCommand.toMavenExecutable(MVN_HOME_VAR)) == null) {
                    throw new IllegalStateException(MAVEN_BINARY_NAME + " not found. Please add it to your PATH or set either the MAVEN_HOME or MVN_HOME environment variables.");
                }
            }
            try {
                maven = maven.toRealPath(new LinkOption[0]);
                Path shimmed = maven.getParent().getParent().resolve(MAVEN_SHIM_TARGET);
                if (Files.exists(shimmed, new LinkOption[0])) {
                    maven = shimmed;
                }
                MAVEN_EXECUTABLE.set(maven.toRealPath(new LinkOption[0]));
            }
            catch (IOException ex) {
                throw new IllegalStateException(ex.getMessage());
            }
        }
        return MAVEN_EXECUTABLE.get();
    }

    public static Path mavenHome() {
        if (MAVEN_HOME.get() == null) {
            MAVEN_HOME.set(MavenCommand.mavenExecutable().getParent().getParent());
        }
        return MAVEN_HOME.get();
    }

    public static MavenVersion installedVersion() {
        if (MAVEN_VERSION.get() == null) {
            Path mavenHome = MavenCommand.mavenHome();
            Path libDir = FileUtils.assertDir(mavenHome.resolve("lib"));
            List<Path> jars = FileUtils.listFiles(libDir, name -> name.startsWith(MAVEN_CORE_PREFIX) && name.endsWith(JAR_SUFFIX));
            if (jars.isEmpty()) {
                throw new IllegalStateException("maven-core* not found in " + libDir);
            }
            Path jarFile = jars.get(0);
            String fileName = jarFile.getFileName().toString();
            String versionStr = MavenCommand.jarVersion(jarFile).orElse(fileName.substring(MAVEN_CORE_PREFIX.length() + 1, fileName.length() - JAR_SUFFIX.length()));
            MavenVersion version = MavenVersion.toMavenVersion(versionStr);
            MAVEN_VERSION.set(version);
        }
        return MAVEN_VERSION.get();
    }

    public static Optional<String> jarVersion(Path jarFilePath) {
        try {
            return Optional.of(new JarFile(jarFilePath.toFile()).getManifest().getMainAttributes().getValue("Implementation-Version"));
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    public static void assertRequiredMavenVersion(MavenVersion requiredMinimumVersion) {
        MavenVersion installed;
        Path executable = MavenCommand.mavenExecutable();
        Log.debug("Found maven executable " + executable, new Object[0]);
        try {
            installed = MavenCommand.installedVersion();
        }
        catch (Exception ex) {
            Log.debug("Could not determine Maven version: " + ex.toString() + " Assuming version is acceptable.", new Object[0]);
            return;
        }
        Requirements.require(installed.isGreaterThanOrEqualTo(requiredMinimumVersion), VERSION_ERROR, new Object[]{installed, requiredMinimumVersion, MAVEN_DOWNLOAD_URL});
    }

    public ProcessMonitor start() throws IOException {
        if (this.name != null) {
            Log.info("%s", StyleFunction.Bold.apply(this.name));
        }
        return ProcessMonitor.builder().processBuilder(this.processBuilder).stdOut(this.stdOut).stdErr(this.stdErr).filter(this.filter).transform(this.transform).beforeShutdown(this.beforeShutdown).afterShutdown(this.afterShutdown).capture(false).build().start();
    }

    public void execute() throws Exception {
        this.start().waitForCompletion(this.maxWaitSeconds, TimeUnit.SECONDS);
    }

    private static Path toMavenExecutable(String mavenHomeEnvVar) {
        Path executable;
        Path mavenHome = MavenCommand.envVarPath(mavenHomeEnvVar);
        if (mavenHome != null && Files.isDirectory(mavenHome, new LinkOption[0]) && Files.exists(executable = mavenHome.resolve("bin").resolve(MAVEN_BINARY_NAME), new LinkOption[0]) && (!Constants.OS.isPosix() || Files.isExecutable(executable))) {
            return executable;
        }
        return null;
    }

    private static Path envVarPath(String var) {
        String path = System.getenv(var);
        return path == null ? null : Paths.get(path, new String[0]);
    }

    public static class Builder {
        private static final String MAVEN_EXEC = Constants.OS.mavenExec();
        private static final String PATH_VAR = "PATH";
        private static final String MAVEN_OPTS_VAR = "MAVEN_OPTS";
        private static final int SECONDS_PER_YEAR = 31536000;
        private static final String DEBUG_OPT_PREFIX = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=y,address=*:";
        private static final String LOG_LEVEL_PROPERTY = "log.level";
        private static final String LOG_LEVEL = System.getProperty("log.level");
        private static final MavenVersion DEFAULT_MINIMUM = MavenVersion.toMavenVersion("3.6.0");
        private static final String DEBUG_PORT_PROPERTY = "mvn.debug.port";
        private static final String CHILD_DEBUG_PORT_PROPERTY = "mvn.child.debug.port";
        private static final int DEFAULT_DEBUG_PORT = Integer.getInteger("mvn.debug.port", 0);
        private static final int DEFAULT_CHILD_DEBUG_PORT = Integer.getInteger("mvn.child.debug.port", 0);
        private String description;
        private Path directory;
        private List<String> mavenArgs;
        private boolean verbose;
        private int debugPort;
        private int maxWaitSeconds = 31536000;
        private PrintStream stdOut;
        private PrintStream stdErr;
        private Predicate<String> filter = line -> true;
        private Function<String, String> transform = Function.identity();
        private Runnable beforeShutdown = () -> {};
        private Runnable afterShutdown = () -> {};
        private MavenVersion requiredMinimumVersion;
        private ProcessBuilder processBuilder;

        private Builder() {
            this.mavenArgs = new ArrayList<String>();
            this.debugPort = AnsiConsoleInstaller.isHelidonChildProcess() ? DEFAULT_CHILD_DEBUG_PORT : DEFAULT_DEBUG_PORT;
            this.requiredMinimumVersion = DEFAULT_MINIMUM;
        }

        public Builder requiredMinimumVersion(MavenVersion requiredMinimumVersion) {
            this.requiredMinimumVersion = Objects.requireNonNull(requiredMinimumVersion);
            return this;
        }

        public Builder description(String description) {
            this.description = Objects.requireNonNull(description);
            return this;
        }

        public Builder directory(File directory) {
            return this.directory(directory.toPath());
        }

        public Builder directory(Path directory) {
            this.directory = FileUtils.assertDir(directory);
            return this;
        }

        public Builder addArgument(String argument) {
            this.mavenArgs.add(Objects.requireNonNull(argument));
            return this;
        }

        public Builder addArguments(List<String> arguments) {
            this.mavenArgs.addAll((Collection<String>)Objects.requireNonNull(arguments));
            return this;
        }

        public Builder addOptionalArgument(String argument) {
            if (argument != null) {
                this.addArgument(argument);
            }
            return this;
        }

        public Builder arguments(List<String> arguments) {
            this.mavenArgs = Objects.requireNonNull(arguments);
            return this;
        }

        public Builder verbose(boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        public Builder debugPort(int debugPort) {
            this.debugPort = debugPort;
            return this;
        }

        public Builder stdOut(PrintStream stdOut) {
            this.stdOut = stdOut;
            return this;
        }

        public Builder stdErr(PrintStream stdErr) {
            this.stdErr = stdErr;
            return this;
        }

        public Builder filter(Predicate<String> filter) {
            this.filter = filter;
            return this;
        }

        public Builder transform(Function<String, String> transform) {
            this.transform = transform;
            return this;
        }

        public Builder beforeShutdown(Runnable beforeShutdown) {
            this.beforeShutdown = beforeShutdown;
            return this;
        }

        public Builder afterShutdown(Runnable afterShutdown) {
            this.afterShutdown = afterShutdown;
            return this;
        }

        public Builder maxWaitSeconds(int maxWaitSeconds) {
            this.maxWaitSeconds = maxWaitSeconds;
            return this;
        }

        public MavenCommand build() {
            this.prepare();
            ArrayList<String> command = new ArrayList<String>();
            command.add(MAVEN_EXEC);
            command.addAll(this.mavenArgs);
            if (this.verbose) {
                command.add("--debug");
            }
            if (LOG_LEVEL != null) {
                command.add("-Dlog.level=" + LOG_LEVEL);
            }
            if (DEFAULT_CHILD_DEBUG_PORT > 0) {
                command.add("-Dmvn.child.debug.port=" + DEFAULT_CHILD_DEBUG_PORT);
            }
            if (!AnsiConsoleInstaller.areAnsiEscapesEnabled()) {
                command.add("--batch-mode");
            }
            this.processBuilder = new ProcessBuilder(new String[0]).redirectInput(ProcessBuilder.Redirect.INHERIT).directory(this.directory.toFile()).command(command);
            Map<String, String> env = this.processBuilder.environment();
            String mavenPath = MavenCommand.mavenExecutable().getParent().toString();
            env.entrySet().stream().filter((? super T e) -> ((String)e.getKey()).equalsIgnoreCase(PATH_VAR)).forEach(e -> env.put((String)e.getKey(), mavenPath + File.pathSeparatorChar + (String)e.getValue()));
            String mavenOpts = Builder.removeDebugOption(env.get(MAVEN_OPTS_VAR));
            if (this.debugPort > 0) {
                mavenOpts = Builder.addMavenOption(DEBUG_OPT_PREFIX + this.debugPort, mavenOpts);
            }
            mavenOpts = Builder.addMavenOption(AnsiConsoleInstaller.childProcessArgument(), mavenOpts);
            env.put(MAVEN_OPTS_VAR, mavenOpts);
            return new MavenCommand(this);
        }

        private static String addMavenOption(String option, String mavenOpts) {
            return mavenOpts == null ? option : mavenOpts.trim() + " " + option;
        }

        private static String removeDebugOption(String mavenOpts) {
            if (mavenOpts != null && mavenOpts.contains(DEBUG_OPT_PREFIX)) {
                mavenOpts = Arrays.stream(mavenOpts.trim().split(" ")).filter((? super T opt) -> !opt.startsWith(DEBUG_OPT_PREFIX)).collect(Collectors.joining(" "));
            }
            return mavenOpts;
        }

        private void prepare() {
            MavenCommand.assertRequiredMavenVersion(this.requiredMinimumVersion);
            Objects.requireNonNull(this.directory, "directory required");
            FileUtils.assertJavaExecutable();
            if (this.stdOut == null) {
                this.stdOut = PrintStreams.STDOUT;
            }
            if (this.stdErr == null) {
                this.stdErr = PrintStreams.RED_STDERR;
            }
        }
    }
}

