/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.Instance;
import io.helidon.build.util.Requirements;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Objects;
import java.util.Properties;

public class BuildToolsProperties
extends Properties {
    private static final Instance<BuildToolsProperties> INSTANCE = new Instance<BuildToolsProperties>(BuildToolsProperties::newInstance);
    private static final String RESOURCE_PATH = "build-tools.properties";
    private static final String VERSION_KEY = "version";
    private static final String BUILD_REVISION_KEY = "revision";
    private static final String BUILD_DATE_KEY = "date";

    public static BuildToolsProperties instance() {
        return INSTANCE.instance();
    }

    public static BuildToolsProperties from(String resourcePath) {
        return new BuildToolsProperties(Objects.requireNonNull(resourcePath));
    }

    public String version() {
        return Objects.requireNonNull(this.getProperty(VERSION_KEY));
    }

    public String buildRevision() {
        return Objects.requireNonNull(this.getProperty(BUILD_REVISION_KEY));
    }

    public String buildDate() {
        return Objects.requireNonNull(this.getProperty(BUILD_DATE_KEY));
    }

    private BuildToolsProperties(String resourcePath) {
        try {
            InputStream stream = BuildToolsProperties.class.getResourceAsStream(resourcePath);
            Requirements.requireNonNull(stream, "%s resource not found", resourcePath);
            try (InputStreamReader reader = new InputStreamReader(stream);){
                this.load(reader);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static BuildToolsProperties newInstance() {
        return new BuildToolsProperties(RESOURCE_PATH);
    }
}

