/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.build.util;

import io.helidon.build.util.Log;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.fusesource.jansi.Ansi;
import picocli.jansi.graalvm.AnsiConsole;

public class AnsiConsoleInstaller {
    public static final String HELIDON_CHILD_PROCESS_PROPERTY = "helidon.child.process";
    private static final String JANSI_FORCE_PROPERTY = "jansi.force";
    private static final String JANSI_STRIP_PROPERTY = "jansi.strip";
    private static final String JANSI_PASS_THROUGH_PROPERTY = "jansi.passthrough";
    private static final String JANSI_PACKAGE_PREFIX = "org.fusesource.jansi";
    private static final String JANSI_STRIP_STREAM_CLASS_NAME = "org.fusesource.jansi.AnsiPrintStream";
    private static final boolean IS_HELIDON_CHILD_PROCESS = Boolean.getBoolean("helidon.child.process");
    private static final AtomicBoolean INSTALLED = new AtomicBoolean();
    private static final AtomicReference<ConsoleType> CONSOLE_TYPE = new AtomicReference();
    private static final AtomicBoolean ENABLED = new AtomicBoolean();

    public static boolean install() {
        if (!INSTALLED.getAndSet(true)) {
            ConsoleType desiredType = AnsiConsoleInstaller.desiredConsoleType();
            AnsiConsole.systemInstall();
            ConsoleType installedType = AnsiConsoleInstaller.installedConsoleType(desiredType);
            CONSOLE_TYPE.set(installedType);
            ENABLED.set(installedType == ConsoleType.ANSI);
        }
        return ENABLED.get();
    }

    public static void disable() {
        if (INSTALLED.get()) {
            if (ENABLED.get()) {
                throw new IllegalStateException("Color support is already enabled");
            }
        } else {
            INSTALLED.set(true);
            ENABLED.set(false);
            CONSOLE_TYPE.set(ConsoleType.DEFAULT);
            System.setProperty(JANSI_STRIP_PROPERTY, "true");
            Ansi.setEnabled((boolean)false);
        }
    }

    public static String childProcessArgument() {
        return AnsiConsoleInstaller.consoleType().childProcessArgument();
    }

    public static boolean isHelidonChildProcess() {
        return IS_HELIDON_CHILD_PROCESS;
    }

    public static ConsoleType consoleType() {
        AnsiConsoleInstaller.install();
        return CONSOLE_TYPE.get();
    }

    public static boolean areAnsiEscapesEnabled() {
        return AnsiConsoleInstaller.install();
    }

    private static ConsoleType desiredConsoleType() {
        if (Boolean.getBoolean(JANSI_FORCE_PROPERTY)) {
            Log.preInitDebug("Jansi streams requested: %s=true", JANSI_FORCE_PROPERTY);
            return ConsoleType.ANSI;
        }
        if (Boolean.getBoolean(JANSI_STRIP_PROPERTY)) {
            Log.preInitDebug("Jansi strip streams requested: %s=true", JANSI_STRIP_PROPERTY);
            return ConsoleType.STRIP_ANSI;
        }
        if (Boolean.getBoolean(JANSI_PASS_THROUGH_PROPERTY)) {
            Log.preInitDebug("Jansi pass through streams requested: %s=true", JANSI_PASS_THROUGH_PROPERTY);
            return ConsoleType.STRIP_ANSI;
        }
        if (System.console() != null) {
            Log.preInitDebug("No Jansi request, but Console is available", new Object[0]);
            return ConsoleType.ANSI;
        }
        Log.preInitDebug("No Jansi request and Console is not available", new Object[0]);
        return ConsoleType.DEFAULT;
    }

    private static ConsoleType installedConsoleType(ConsoleType desiredType) {
        ConsoleType installedType;
        String systemOutClassName;
        block14: {
            PrintStream systemOut = System.out;
            Class<?> systemOutclass = systemOut.getClass();
            systemOutClassName = systemOutclass.getName();
            if (systemOutClassName.startsWith(JANSI_PACKAGE_PREFIX)) {
                if (systemOutClassName.equals(JANSI_STRIP_STREAM_CLASS_NAME)) {
                    try {
                        String mode = systemOutclass.getMethod("getMode", new Class[0]).invoke((Object)systemOut, new Object[0]).toString();
                        if (mode.equalsIgnoreCase("strip")) {
                            installedType = ConsoleType.STRIP_ANSI;
                            break block14;
                        }
                        if (mode.equalsIgnoreCase("force")) {
                            installedType = ConsoleType.ANSI;
                            break block14;
                        }
                        installedType = ConsoleType.DEFAULT;
                    }
                    catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                        installedType = ConsoleType.STRIP_ANSI;
                    }
                } else {
                    installedType = ConsoleType.ANSI;
                }
            } else {
                installedType = ConsoleType.DEFAULT;
            }
        }
        if (desiredType != installedType) {
            switch (installedType) {
                case STRIP_ANSI: {
                    Log.preInitDebug("Desired = %s, but Ansi escapes will be stripped by system streams.", new Object[]{desiredType});
                    break;
                }
                case ANSI: {
                    Log.preInitDebug("Desired = %s, but Ansi escapes should be supported by system streams.", new Object[]{desiredType});
                    break;
                }
                case DEFAULT: {
                    Log.preInitDebug("Desired = %s, but System.out not a Jansi type (%s) ao Ansi escapes should not be stripped", new Object[]{desiredType, systemOutClassName});
                    break;
                }
            }
        }
        return installedType;
    }

    private AnsiConsoleInstaller() {
    }

    public static enum ConsoleType {
        ANSI("jansi.force"),
        STRIP_ANSI("jansi.strip"),
        DEFAULT("jansi.passthrough");

        private final String argument;

        private ConsoleType(String propertyName) {
            this.argument = "-Dhelidon.child.process=true -D" + propertyName + "=true";
        }

        public String childProcessArgument() {
            return this.argument;
        }
    }
}

