/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot;

import io.hawt.springboot.EndpointPathResolver;
import io.hawt.springboot.HawtioPlugin;
import io.hawt.springboot.HawtioPluginController;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@ManagementContextConfiguration
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class HawtioPluginAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(value={EndpointPathResolver.class})
    public HawtioPluginController hawtioRequestHandler(EndpointPathResolver endpointPathResolver, @Autowired @Qualifier(value="requestMappingHandlerMapping") RequestMappingHandlerMapping requestMappingHandlerMapping, @Autowired Optional<List<HawtioPlugin>> plugins) throws NoSuchMethodException {
        HawtioPluginController hawtioRequestHandler = new HawtioPluginController(plugins.orElse(Collections.emptyList()));
        Method getPlugins = HawtioPluginController.class.getMethod("getPlugins", new Class[0]);
        RequestMappingInfo getPluginsMappingInfo = RequestMappingInfo.paths((String[])new String[]{endpointPathResolver.resolveUrlMapping("hawtio", new String[0]) + "/plugin"}).methods(new RequestMethod[]{RequestMethod.GET}).build();
        requestMappingHandlerMapping.registerMapping(getPluginsMappingInfo, (Object)hawtioRequestHandler, getPlugins);
        return hawtioRequestHandler;
    }
}

