/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot;

import io.hawt.web.ServletHelpers;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletPath;

public class EndpointPathResolver {
    private final WebEndpointProperties webEndpointProperties;
    private final ServerProperties serverProperties;
    private final ManagementServerProperties managementServerProperties;
    private final DispatcherServletPath dispatcherServletPath;

    public EndpointPathResolver(WebEndpointProperties webEndpointProperties, ServerProperties serverProperties, ManagementServerProperties managementServerProperties, DispatcherServletPath dispatcherServletPath) {
        this.webEndpointProperties = webEndpointProperties;
        this.serverProperties = serverProperties;
        this.managementServerProperties = managementServerProperties;
        this.dispatcherServletPath = dispatcherServletPath;
    }

    public String resolve(String endpointName) {
        String webContextPath;
        Map pathMapping = this.webEndpointProperties.getPathMapping();
        Integer mgmtPort = this.managementServerProperties.getPort();
        String servletPath = this.dispatcherServletPath.getPath();
        if (mgmtPort != null && !mgmtPort.equals(this.serverProperties.getPort())) {
            servletPath = "/";
        }
        String basePath = this.webEndpointProperties.getBasePath();
        String endpointPathMapping = (String)pathMapping.get(endpointName);
        if (endpointPathMapping == null) {
            endpointPathMapping = endpointName;
        }
        return (webContextPath = ServletHelpers.webContextPath((String)servletPath, (String[])new String[]{basePath, endpointPathMapping})).isEmpty() ? "/" : webContextPath;
    }

    public String resolveUrlMapping(String endpointName, String ... mappings) {
        String servletPath = this.dispatcherServletPath.getPath();
        String endpointPath = this.resolve(endpointName);
        if (!servletPath.equals("/")) {
            endpointPath = endpointPath.replace(servletPath, "");
        }
        return ServletHelpers.webContextPath((String)endpointPath, (String[])mappings);
    }

    public String resolveContextPath() {
        Integer serverPort = this.serverProperties.getPort();
        Integer managementServerPort = this.managementServerProperties.getPort();
        String contextPath = serverPort == null || managementServerPort == null || serverPort.equals(this.managementServerProperties.getPort()) ? this.serverProperties.getServlet().getContextPath() : this.managementServerProperties.getBasePath();
        return ServletHelpers.webContextPath((String)contextPath, (String[])new String[0]);
    }
}

