/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot;

import io.hawt.springboot.ConditionalOnExposedEndpoint;
import io.hawt.springboot.EndpointPathResolver;
import io.hawt.springboot.HawtioEndpoint;
import io.hawt.springboot.HawtioPlugin;
import io.hawt.springboot.HawtioProperties;
import io.hawt.springboot.SpringHawtioContextListener;
import io.hawt.system.ConfigManager;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.AuthenticationFilter;
import io.hawt.web.auth.LoginRedirectFilter;
import io.hawt.web.auth.LoginServlet;
import io.hawt.web.auth.LogoutServlet;
import io.hawt.web.auth.Redirector;
import io.hawt.web.auth.SessionExpiryFilter;
import io.hawt.web.auth.keycloak.KeycloakServlet;
import io.hawt.web.auth.keycloak.KeycloakUserServlet;
import io.hawt.web.filters.BaseTagHrefFilter;
import io.hawt.web.filters.CORSFilter;
import io.hawt.web.filters.CacheHeadersFilter;
import io.hawt.web.filters.ContentSecurityPolicyFilter;
import io.hawt.web.filters.FlightRecordingDownloadFacade;
import io.hawt.web.filters.PublicKeyPinningFilter;
import io.hawt.web.filters.ReferrerPolicyFilter;
import io.hawt.web.filters.StrictTransportSecurityFilter;
import io.hawt.web.filters.XContentTypeOptionsFilter;
import io.hawt.web.filters.XFrameOptionsFilter;
import io.hawt.web.filters.XXSSProtectionFilter;
import io.hawt.web.proxy.ProxyServlet;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.jolokia.JolokiaEndpoint;
import org.springframework.boot.actuate.autoconfigure.jolokia.JolokiaEndpointAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.web.ManagementContextConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.AbstractUrlViewController;

@ManagementContextConfiguration
@AutoConfigureAfter(value={JolokiaEndpointAutoConfiguration.class})
@ConditionalOnBean(value={HawtioEndpoint.class})
public class HawtioManagementConfiguration {
    private final String hawtioPath;

    public HawtioManagementConfiguration(EndpointPathResolver pathResolver) {
        this.hawtioPath = pathResolver.resolve("hawtio");
    }

    @Autowired
    public void initializeHawtioPlugins(HawtioEndpoint hawtioEndpoint, Optional<List<HawtioPlugin>> plugins) {
        hawtioEndpoint.setPlugins(plugins.orElse(Collections.emptyList()));
    }

    @Bean
    public ConfigManager hawtioConfigManager(HawtioProperties hawtioProperties) {
        return new ConfigManager(hawtioProperties.get()::get);
    }

    @Bean
    @ConditionalOnBean(value={JolokiaEndpoint.class})
    @ConditionalOnExposedEndpoint(name="jolokia")
    public SimpleUrlHandlerMapping hawtioUrlMapping(EndpointPathResolver pathResolver) {
        String jolokiaPath = pathResolver.resolve("jolokia");
        String hawtioPath = pathResolver.resolve("hawtio");
        SilentSimpleUrlHandlerMapping mapping = new SilentSimpleUrlHandlerMapping();
        HashMap<String, JolokiaForwardingController> urlMap = new HashMap<String, JolokiaForwardingController>();
        if (!hawtioPath.isEmpty()) {
            String hawtioJolokiaPath = pathResolver.resolveUrlMapping("hawtio", "jolokia", "**");
            urlMap.put(hawtioJolokiaPath, new JolokiaForwardingController(hawtioPath + "/jolokia", jolokiaPath));
            mapping.setOrder(Integer.MIN_VALUE);
        } else {
            urlMap.put("/<DUMMY>", null);
        }
        mapping.setUrlMap(urlMap);
        return mapping;
    }

    @Bean
    public Redirector redirector() {
        Redirector redirector = new Redirector();
        redirector.setApplicationContextPath(this.hawtioPath);
        return redirector;
    }

    @Bean
    public FilterRegistrationBean<SessionExpiryFilter> sessionExpiryFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new SessionExpiryFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean<CacheHeadersFilter> cacheFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new CacheHeadersFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean<CORSFilter> hawtioCorsFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new CORSFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean<XFrameOptionsFilter> xframeOptionsFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new XFrameOptionsFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean<XXSSProtectionFilter> xxssProtectionFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new XXSSProtectionFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean<XContentTypeOptionsFilter> xContentTypeOptionsFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new XContentTypeOptionsFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean<ContentSecurityPolicyFilter> contentSecurityPolicyFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new ContentSecurityPolicyFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean<StrictTransportSecurityFilter> strictTransportSecurityFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new StrictTransportSecurityFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean<PublicKeyPinningFilter> publicKeyPinningFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new PublicKeyPinningFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean<ReferrerPolicyFilter> referrerPolicyFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new ReferrerPolicyFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    @ConditionalOnBean(value={JolokiaEndpoint.class})
    @ConditionalOnExposedEndpoint(name="jolokia")
    public FilterRegistrationBean<AuthenticationFilter> authenticationFilter(EndpointPathResolver pathResolver) {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new AuthenticationFilter());
        filter.addUrlPatterns(new String[]{pathResolver.resolveUrlMapping("jolokia", "*")});
        filter.setDispatcherTypes(DispatcherType.ERROR, new DispatcherType[]{DispatcherType.FORWARD, DispatcherType.REQUEST});
        return filter;
    }

    @Bean
    public FilterRegistrationBean<LoginRedirectFilter> loginRedirectFilter(Redirector redirector) {
        String[] unsecuredPaths = this.prependContextPath(AuthenticationConfiguration.UNSECURED_PATHS);
        FilterRegistrationBean filter = new FilterRegistrationBean();
        LoginRedirectFilter loginRedirectFilter = new LoginRedirectFilter(unsecuredPaths);
        loginRedirectFilter.setRedirector(redirector);
        filter.setFilter((Filter)loginRedirectFilter);
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean<BaseTagHrefFilter> baseTagHrefFilter(EndpointPathResolver pathResolver) {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        BaseTagHrefFilter baseTagHrefFilter = new BaseTagHrefFilter();
        filter.setFilter((Filter)baseTagHrefFilter);
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/"});
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/index.html"});
        filter.setDispatcherTypes(DispatcherType.ERROR, new DispatcherType[]{DispatcherType.FORWARD, DispatcherType.REQUEST});
        filter.addInitParameter("applicationContextPath", pathResolver.resolve("hawtio"));
        return filter;
    }

    @Bean
    public FilterRegistrationBean<FlightRecordingDownloadFacade> flightRecorderDownloadFacade(EndpointPathResolver pathResolver) {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new FlightRecordingDownloadFacade());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/jolokia/*"});
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/proxy/*"});
        filter.setDispatcherTypes(DispatcherType.ERROR, new DispatcherType[]{DispatcherType.FORWARD, DispatcherType.REQUEST});
        return filter;
    }

    @Bean
    public ServletRegistrationBean<ProxyServlet> jolokiaProxyServlet() {
        return new ServletRegistrationBean((Servlet)new ProxyServlet(), new String[]{this.hawtioPath + "/proxy/*"});
    }

    @Bean
    public ServletRegistrationBean<KeycloakUserServlet> userServlet() {
        return new ServletRegistrationBean((Servlet)new KeycloakUserServlet(), new String[]{this.hawtioPath + "/user/*"});
    }

    @Bean
    public ServletRegistrationBean<LoginServlet> loginServlet(Redirector redirector) {
        LoginServlet loginServlet = new LoginServlet();
        loginServlet.setRedirector(redirector);
        return new ServletRegistrationBean((Servlet)loginServlet, new String[]{this.hawtioPath + "/auth/login"});
    }

    @Bean
    public ServletRegistrationBean<LogoutServlet> logoutServlet(Redirector redirector) {
        LogoutServlet logoutServlet = new LogoutServlet();
        logoutServlet.setRedirector(redirector);
        return new ServletRegistrationBean((Servlet)logoutServlet, new String[]{this.hawtioPath + "/auth/logout"});
    }

    @Bean
    public ServletRegistrationBean<KeycloakServlet> keycloakServlet() {
        return new ServletRegistrationBean((Servlet)new KeycloakServlet(), new String[]{this.hawtioPath + "/keycloak/*"});
    }

    @Bean
    public ServletListenerRegistrationBean<SpringHawtioContextListener> hawtioContextListener(ConfigManager configManager) {
        return new ServletListenerRegistrationBean((EventListener)((Object)new SpringHawtioContextListener(configManager, this.hawtioPath)));
    }

    @Bean
    public ServletContextInitializer servletContextInitializer() {
        return servletContext -> servletContext.getSessionCookieConfig().setHttpOnly(true);
    }

    private String[] prependContextPath(String[] paths) {
        return (String[])Arrays.stream(paths).map(path -> this.hawtioPath + path).toArray(String[]::new);
    }

    private static class SilentSimpleUrlHandlerMapping
    extends SimpleUrlHandlerMapping {
        private static final String DUMMY = "/<DUMMY>";

        private SilentSimpleUrlHandlerMapping() {
        }

        protected void registerHandler(@Nonnull String urlPath, @Nonnull Object handler) {
            if (!DUMMY.equals(urlPath)) {
                super.registerHandler(urlPath, handler);
            }
        }
    }

    private static class JolokiaForwardingController
    extends AbstractUrlViewController {
        private final String hawtioJolokiaPath;
        private final String jolokiaPath;

        JolokiaForwardingController(String hawtioJolokiaPath, String jolokiaPath) {
            this.hawtioJolokiaPath = hawtioJolokiaPath;
            this.jolokiaPath = jolokiaPath;
        }

        @Nonnull
        protected String getViewNameForRequest(HttpServletRequest request) {
            StringBuilder b = new StringBuilder();
            b.append("forward:");
            b.append(this.jolokiaPath);
            String pathQuery = request.getRequestURI().substring(request.getContextPath().length() + this.hawtioJolokiaPath.length());
            b.append(pathQuery);
            if (request.getQueryString() != null) {
                b.append('?').append(request.getQueryString());
            }
            return b.toString();
        }
    }
}

