/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot;

import io.hawt.springboot.EndpointPathResolver;
import io.hawt.springboot.HawtPlugin;
import java.util.List;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;

@ControllerEndpoint(id="hawtio")
public class HawtioEndpoint
implements WebMvcConfigurer {
    private final EndpointPathResolver endpointPath;
    private List<HawtPlugin> plugins;

    public HawtioEndpoint(EndpointPathResolver endpointPath) {
        this.endpointPath = endpointPath;
    }

    public void setPlugins(List<HawtPlugin> plugins) {
        this.plugins = plugins;
    }

    @RequestMapping(value={"", "{path:^(?:(?!\\bjolokia\\b|auth|css|fonts|img|js|user|oauth|\\.).)*$}/**"}, produces={"text/html"})
    public String forwardHawtioRequestToIndexHtml() {
        String path = this.endpointPath.resolve("hawtio");
        UriComponents uriComponents = ServletUriComponentsBuilder.fromPath((String)path).path("/index.html").build();
        return "forward:" + uriComponents.getPath();
    }

    @RequestMapping(value={"/plugin"})
    @ResponseBody
    public List<HawtPlugin> getPlugins() {
        return this.plugins;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{this.endpointPath.resolveUrlMapping("hawtio", "/plugins/**")}).addResourceLocations(new String[]{"/app/", "classpath:/hawtio-static/app/"});
        registry.addResourceHandler(new String[]{this.endpointPath.resolveUrlMapping("hawtio", "/**")}).addResourceLocations(new String[]{"/", "/app/", "classpath:/hawtio-static/", "classpath:/hawtio-static/app/"});
        registry.addResourceHandler(new String[]{this.endpointPath.resolveUrlMapping("hawtio", "/img/**")}).addResourceLocations(new String[]{"classpath:/hawtio-static/img/"});
    }
}

