/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot;

import io.hawt.springboot.EndpointPathResolver;
import io.hawt.springboot.HawtPlugin;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.actuate.endpoint.web.annotation.ControllerEndpoint;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UrlPathHelper;

@ControllerEndpoint(id="hawtio")
public class HawtioEndpoint
implements WebMvcConfigurer {
    private final EndpointPathResolver endpointPath;
    private List<HawtPlugin> plugins;

    public HawtioEndpoint(EndpointPathResolver endpointPath) {
        this.endpointPath = endpointPath;
    }

    public void setPlugins(List<HawtPlugin> plugins) {
        this.plugins = plugins;
    }

    @RequestMapping(value={"", "/"}, produces={"text/html"})
    public String redirectRootToIndexPage(HttpServletRequest request) {
        return this.getIndexHtmlRedirect(request);
    }

    @RequestMapping(value={"/plugin"})
    @ResponseBody
    public List<HawtPlugin> getPlugins() {
        return this.plugins;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{this.endpointPath.resolveUrlMapping("hawtio", "/plugins/**")}).addResourceLocations(new String[]{"/app/", "classpath:/hawtio-static/app/"});
        registry.addResourceHandler(new String[]{this.endpointPath.resolveUrlMapping("hawtio", "/**")}).addResourceLocations(new String[]{"/", "/app/", "classpath:/hawtio-static/", "classpath:/hawtio-static/app/"});
        registry.addResourceHandler(new String[]{this.endpointPath.resolveUrlMapping("hawtio", "/img/**")}).addResourceLocations(new String[]{"classpath:/hawtio-static/img/"});
    }

    protected String getIndexHtmlRedirect(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromRequest((HttpServletRequest)request);
        if (request.getServletContext().getContextPath() != null) {
            String path = new UrlPathHelper().getPathWithinApplication(request);
            builder.replacePath(path);
        }
        builder.path("/index.html");
        UriComponents uriComponents = builder.build();
        String path = uriComponents.getPath();
        return "forward:" + path;
    }
}

