/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot;

import io.hawt.util.Strings;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.endpoint.web.WebEndpointProperties;
import org.springframework.boot.actuate.autoconfigure.web.server.ManagementServerProperties;
import org.springframework.boot.autoconfigure.web.ServerProperties;

public class EndpointPathResolver {
    private final WebEndpointProperties webEndpointProperties;
    private final ServerProperties serverProperties;
    private final ManagementServerProperties managementServerProperties;

    public EndpointPathResolver(WebEndpointProperties webEndpointProperties, ServerProperties serverProperties, ManagementServerProperties managementServerProperties) {
        this.webEndpointProperties = webEndpointProperties;
        this.serverProperties = serverProperties;
        this.managementServerProperties = managementServerProperties;
    }

    public String resolve(String endpointName) {
        String webContextPath;
        Map pathMapping = this.webEndpointProperties.getPathMapping();
        String basePath = this.webEndpointProperties.getBasePath();
        String servletPath = this.serverProperties.getServlet().getPath();
        String endpointPathMapping = (String)pathMapping.get(endpointName);
        if (endpointPathMapping == null) {
            endpointPathMapping = endpointName;
        }
        return (webContextPath = Strings.webContextPath((String)servletPath, (String[])new String[]{basePath, endpointPathMapping})).isEmpty() ? "/" : webContextPath;
    }

    public String resolveUrlMapping(String endpointName, String ... mappings) {
        String servletPath = this.serverProperties.getServlet().getPath();
        String endpointPath = this.resolve(endpointName);
        if (!servletPath.equals("/")) {
            endpointPath = endpointPath.replace(servletPath, "");
        }
        return Strings.webContextPath((String)endpointPath, (String[])mappings);
    }

    public String resolveContextPath() {
        Integer serverPort = this.serverProperties.getPort();
        Integer managementServerPort = this.managementServerProperties.getPort();
        String contextPath = "";
        contextPath = serverPort == null || managementServerPort == null || serverPort.equals(this.managementServerProperties.getPort()) ? this.serverProperties.getServlet().getContextPath() : this.managementServerProperties.getServlet().getContextPath();
        return Strings.webContextPath((String)contextPath, (String[])new String[0]);
    }
}

