## Becoming a Maintainer

The documentation for becoming a maintainer has been taken from [Foreman](https://theforeman.org/handbook.html#Becomingamaintainer) and adapted for the PatternFly project.

As a maintainer, it is your responsibility to help manage and maintain the health of the PatternFly project.  A PatternFly maintainer has commit permissions to one or more of the repositories under the [PatternFly organization](https://github.com/patternfly). To see a list of maintainers to the PatternFly project, view the [PatternFly GitHub Teams](https://github.com/orgs/patternfly/teams) page.

Maintainers are members of the PatternFly community who exhibit most of the following behaviors:

- Review and merge code and documentation.
- Help triaging bugs and testing pull requests.
- Make well formed pull requests.
- Have a sense of duty about the project.
- Play well with others, are respectful, show gratitude.

If you want to become a maintainer, we expect you to:

- Review and test pull requests submitted by others.
- Encourage and ensure design remains an integral part of the review process and pull in designers for review as needed (you can leverage @patternfly/angular-patternfly-ux if there is no known associated designer).
- Maintain sustained activity versus sporadic.
- Support users and other developers on PatternFly Slack as well as our mailing lists, [Angular Patternfly](mailto:angular-patternfly@redhat.com) and [PatternFly](mailto:patternfly@redhat.com).

Other things that are nice to do:

- Participate in (or even initiate) real-world events such as user/developer meetups, papers/talks at conferences, etc.

### How do I become a maintainer?

One person has to nominate you to the group of existing maintainers. The person who nominates you has to:

- Submit ten examples that prove this person behaves like a maintainer.
- Explain how the nominee is involved in the community and cares about the future of the project

This nomination is public and should be sent to the PatternFly mailing list. After the nomination is submitted, two other maintainers have to second the nomination. If no one objects in one week, the nomination is accepted.

Such objections may happen in public on the nomination e-mail thread. However, not everyone is comfortable giving objections publicly. Therefore, it is acceptable for other maintainers to raise their concerns with the sponsor and/or other maintainers privately if they wish to do so. The sponsor is expected to update the nomination e-mail thread to show that it is on hold pending private concerns.

Regardless, while objections are discussed either in private or public, the nomination is on hold until the objections are resolved or the nomination is rejected. In the event of a failed nomination, the sponsor (as part of the discussing group) will know the grounds for the rejection, and can pass along constructive feedback to the candidate. Care should be taken to do this sensitively.

### How do I lose maintainers status?

The maintainers team will be reevaluated periodically to ensure it remains up to date. If you are inactive in the community for six months, we will remove you from the maintainers list and revoke your permission, but we will make a mention of you on a list of previous maintainers. In the event that a maintainer continues to disregard good citizenship (or actively disrupts the project), we may need to revoke that person’s status.

The process for revoking someone's maintainer status is a discussion limited to the maintainer team given the sensitive nature of this conversation. The maintainer being discussed should be made aware of the reasons their membership is being discussed and why. It may be that this person simply does not have time and agrees to opt out of this role without any further discussion. If more is required, the process is similar to a nomination. A member should suggest the revocation with a good reason, two people second the motion, and a vote may be called if consensus cannot be reached. Someone from the maintainer team is required to follow up with the person being removed to update them and pass along constructive feedback. Again, care should be taken to do this sensitively.  

### Quick tips for new maintainers

- If something you merged broke something, it’s your responsibility to resolve or coordinate how to resolve the issue.
- Do not merge your own commits
- Do not merge commits blindly. If you do not fully understand a pull request, ask existing maintainers to take a look
- Do not merge if the build is failing. Wait until tests are green to merge.

