var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    }
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var Diagnostics;
(function (Diagnostics) {
    DiagnosticsFlagsController.$inject = ["$scope", "jolokia"];
    function DiagnosticsFlagsController($scope, jolokia) {
        'ngInject';
        var readRequest = {
            type: 'read',
            mbean: 'com.sun.management:type=HotSpotDiagnostic',
            arguments: []
        };
        $scope.flags = [];
        // $scope.tableDef = tableDef();
        Core.register(jolokia, $scope, [readRequest], Core.onSuccess(render));
        function render(response) {
            //remove watches on previous content
            for (var i = 0; i < $scope.flags.length; i++) {
                $scope.flags[i].deregisterWatch();
            }
            $scope.flags = response.value.DiagnosticOptions;
            for (var i = 0; i < $scope.flags.length; i++) {
                var flag = $scope.flags[i];
                flag.value = parseValue(flag.value); //convert to typed value
                if (flag.writeable) { //hint for the kind of control to use
                    flag.dataType = typeof (flag.value);
                }
                else {
                    flag.dataType = "readonly";
                }
                flag.deregisterWatch = $scope.$watch('flags[' + i + ']', function (newValue, oldValue) {
                    if (newValue.value != oldValue.value) {
                        jolokia.request([{
                                type: 'exec',
                                mbean: 'com.sun.management:type=HotSpotDiagnostic',
                                operation: 'setVMOption(java.lang.String,java.lang.String)',
                                arguments: [newValue.name, newValue.value]
                            }, readRequest], Core.onSuccess(function (response) {
                            if (response.request.type === "read") {
                                render(response);
                            }
                            else {
                                Diagnostics.log.info("Set VM option " + newValue.name + "=" + newValue.value);
                            }
                        }));
                    }
                }, true);
            }
            Core.$apply($scope);
        }
        function parseValue(value) {
            if (typeof (value) === "string") {
                if (value.match(/true/)) {
                    return true;
                }
                else if (value.match(/false/)) {
                    return false;
                }
                else if (value.match(/\d+/)) {
                    return Number(value);
                }
            }
            return value;
        }
        // function tableDef() {
        //   return {
        //     selectedItems: [],
        //     data: 'flags',
        //     showFilter: true,
        //     filterOptions: {
        //       filterText: ''
        //     },
        //     showSelectionCheckbox: false,
        //     enableRowClickSelection: true,
        //     multiSelect: false,
        //     primaryKeyFn: function (entity, idx) {
        //       return entity.name;
        //     },
        //     columnDefs: [
        //       {
        //         field: 'name',
        //         displayName: 'VM Flag',
        //         resizable: true
        //       }, {
        //         field: 'origin',
        //         displayName: 'Origin',
        //         resizable: true
        //       }, {
        //         field: 'value',
        //         displayName: 'Value',
        //         resizable: true,
        //         cellTemplate: '<div ng-switch on="row.entity.dataType"><span ng-switch-when="readonly">{{row.entity.value}}</span><input ng-switch-when="boolean" type="checkbox" ng-model="row.entity.value"></input><input ng-switch-when="string" type="text" ng-model="row.entity.value"></input><input ng-switch-when="number" type="number" ng-model="row.entity.value"></input></div>'
        //       }]
        //   };
        // }
    }
    Diagnostics.DiagnosticsFlagsController = DiagnosticsFlagsController;
})(Diagnostics || (Diagnostics = {}));
var JVM;
(function (JVM) {
    JVM.rootPath = 'plugins/jvm';
    JVM.templatePath = UrlHelpers.join(JVM.rootPath, '/html');
    JVM.pluginName = 'hawtio-jmx-jvm';
    JVM.log = Logger.get(JVM.pluginName);
    JVM.connectionSettingsKey = 'jvmConnect';
    JVM.logoPath = 'img/icons/jvm/';
    JVM.logoRegistry = {
        'jetty': JVM.logoPath + 'jetty-logo-80x22.png',
        'tomcat': JVM.logoPath + 'tomcat-logo.gif',
        'generic': JVM.logoPath + 'java-logo.svg'
    };
})(JVM || (JVM = {}));
/// <reference path="jvmGlobals.ts"/>
var JVM;
(function (JVM) {
    /**
     * Adds common properties and functions to the scope
     * @method configureScope
     * @for Jvm
     * @param {*} $scope
     * @param {ng.ILocationService} $location
     * @param {Core.Workspace} workspace
     */
    function configureScope($scope, $location, workspace) {
        $scope.isActive = function (href) {
            var tidy = Core.trimLeading(href, "#");
            var loc = $location.path();
            return loc === tidy;
        };
        $scope.isValid = function (link) {
            return link && link.isValid(workspace);
        };
        $scope.hasLocalMBean = function () {
            return JVM.hasLocalMBean(workspace);
        };
        $scope.goto = function (path) {
            $location.path(path);
        };
    }
    JVM.configureScope = configureScope;
    function hasLocalMBean(workspace) {
        return workspace.treeContainsDomainAndProperties('hawtio', { type: 'JVMList' });
    }
    JVM.hasLocalMBean = hasLocalMBean;
    function hasDiscoveryMBean(workspace) {
        return workspace.treeContainsDomainAndProperties('jolokia', { type: 'Discovery' });
    }
    JVM.hasDiscoveryMBean = hasDiscoveryMBean;
    /**
     * Creates a jolokia object for connecting to the container with the given remote jolokia URL,
     * username and password
     * @method createJolokia
     * @for Core
     * @static
     * @param {String} url
     * @param {String} username
     * @param {String} password
     * @return {Object}
     */
    function createJolokia(url, username, password) {
        var jolokiaParams = {
            url: url,
            username: username,
            password: password,
            canonicalNaming: false, ignoreErrors: true, mimeType: 'application/json'
        };
        return new Jolokia(jolokiaParams);
    }
    JVM.createJolokia = createJolokia;
    function getRecentConnections(localStorage) {
        if (Core.isBlank(localStorage['recentConnections'])) {
            clearConnections();
        }
        return angular.fromJson(localStorage['recentConnections']);
    }
    JVM.getRecentConnections = getRecentConnections;
    function addRecentConnection(localStorage, name) {
        var recent = getRecentConnections(localStorage);
        recent.push(name);
        recent = _.take(_.uniq(recent), 5);
        localStorage['recentConnections'] = angular.toJson(recent);
    }
    JVM.addRecentConnection = addRecentConnection;
    function removeRecentConnection(localStorage, name) {
        var recent = getRecentConnections(localStorage);
        recent = _.without(recent, name);
        localStorage['recentConnections'] = angular.toJson(recent);
    }
    JVM.removeRecentConnection = removeRecentConnection;
    function clearConnections() {
        localStorage['recentConnections'] = '[]';
    }
    JVM.clearConnections = clearConnections;
    function isRemoteConnection() {
        return ('con' in new URI().query(true));
    }
    JVM.isRemoteConnection = isRemoteConnection;
    function connectToServer(localStorage, options) {
        JVM.log.debug("Connecting with options: ", StringHelpers.toString(options));
        var clone = angular.extend({}, options);
        addRecentConnection(localStorage, clone.name);
        if (!('userName' in clone)) {
            var userDetails = HawtioCore.injector.get('userDetails');
            clone.userName = userDetails.username;
            clone.password = userDetails.password;
        }
        //must save to local storage, to be picked up by new tab
        saveConnection(clone);
        var $window = HawtioCore.injector.get('$window');
        var url = (clone.view || '/') + '?con=' + clone.name;
        url = url.replace(/\?/g, "&");
        url = url.replace(/&/, "?");
        var newWindow = $window.open(url, clone.name);
        newWindow['con'] = clone.name;
        newWindow['userDetails'] = {
            username: clone.userName,
            password: clone.password,
            loginDetails: {}
        };
    }
    JVM.connectToServer = connectToServer;
    function saveConnection(options) {
        var connections = loadConnections();
        var existingIndex = _.findIndex(connections, function (element) { return element.name === options.name; });
        if (existingIndex != -1) {
            connections[existingIndex] = options;
        }
        else {
            connections.unshift(options);
        }
        saveConnections(connections);
    }
    JVM.saveConnection = saveConnection;
    /**
     * Loads all of the available connections from local storage
     */
    function loadConnections() {
        var localStorage = Core.getLocalStorage();
        try {
            var connections = angular.fromJson(localStorage[JVM.connectionSettingsKey]);
            if (!connections) {
                // nothing found on local storage
                return [];
            }
            else if (!_.isArray(connections)) {
                // found the legacy connections map
                delete localStorage[JVM.connectionSettingsKey];
                return [];
            }
            else {
                // found a valid connections array
                return connections;
            }
        }
        catch (e) {
            // corrupt config
            delete localStorage[JVM.connectionSettingsKey];
            return [];
        }
    }
    JVM.loadConnections = loadConnections;
    /**
     * Saves the connection map to local storage
     * @param connections array of all connections to be stored
     */
    function saveConnections(connections) {
        JVM.log.debug("Saving connection array:", StringHelpers.toString(connections));
        localStorage[JVM.connectionSettingsKey] = angular.toJson(connections);
    }
    JVM.saveConnections = saveConnections;
    function getConnectionNameParameter() {
        return new URI().search(true)['con'];
    }
    JVM.getConnectionNameParameter = getConnectionNameParameter;
    /**
     * Returns the connection options for the given connection name from localStorage
     */
    function getConnectOptions(name, localStorage) {
        if (localStorage === void 0) { localStorage = Core.getLocalStorage(); }
        if (!name) {
            return null;
        }
        var connections = loadConnections();
        return _.find(connections, function (connection) { return connection.name === name; });
    }
    JVM.getConnectOptions = getConnectOptions;
    /**
     * Creates the Jolokia URL string for the given connection options
     */
    function createServerConnectionUrl(options) {
        JVM.log.debug("Connect to server, options:", StringHelpers.toString(options));
        var answer = null;
        if (options.jolokiaUrl) {
            answer = options.jolokiaUrl;
        }
        if (answer === null) {
            var uri = new URI();
            uri.protocol(options.scheme || 'http')
                .host(options.host || 'localhost')
                .port(String(options.port || 80))
                .path(options.path);
            answer = UrlHelpers.join('proxy', uri.protocol(), uri.hostname(), uri.port(), uri.path());
        }
        JVM.log.debug("Using URL:", answer);
        return answer;
    }
    JVM.createServerConnectionUrl = createServerConnectionUrl;
})(JVM || (JVM = {}));
/// <reference path="../jvmHelpers.ts"/>
var JVM;
(function (JVM) {
    var ConnectService = /** @class */ (function () {
        ConnectService.$inject = ["$q", "$window", "$location"];
        function ConnectService($q, $window, $location) {
            'ngInject';
            this.$q = $q;
            this.$window = $window;
            this.$location = $location;
        }
        ConnectService.prototype.getConnections = function () {
            var connectionsJson = this.$window.localStorage.getItem(JVM.connectionSettingsKey);
            return connectionsJson ? JSON.parse(connectionsJson) : [];
        };
        ConnectService.prototype.updateReachableFlags = function (connections) {
            var _this = this;
            var promises = connections.map(function (connection) { return _this.testConnection(connection); });
            return this.$q.all(promises)
                .then(function (reachableFlags) {
                for (var i = 0; i < connections.length; i++) {
                    connections[i].reachable = reachableFlags[i];
                }
                return connections;
            });
        };
        ConnectService.prototype.updateReachableFlag = function (connection) {
            return this.testConnection(connection)
                .then(function (reachable) {
                connection.reachable = reachable;
                return connection;
            });
        };
        ConnectService.prototype.saveConnections = function (connections) {
            this.$window.localStorage.setItem(JVM.connectionSettingsKey, JSON.stringify(connections));
        };
        ConnectService.prototype.testConnection = function (connection) {
            return this.$q(function (resolve, reject) {
                try {
                    new Jolokia({
                        url: JVM.createServerConnectionUrl(connection),
                        method: 'post',
                        mimeType: 'application/json'
                    }).request({
                        type: 'version'
                    }, {
                        success: function (response) {
                            resolve(true);
                        },
                        error: function (response) {
                            resolve(false);
                        },
                        ajaxError: function (response) {
                            resolve(response.status === 403 ? true : false);
                        }
                    });
                }
                catch (error) {
                    resolve(false);
                }
            });
        };
        ;
        ConnectService.prototype.checkCredentials = function (connection, username, password) {
            return this.$q(function (resolve, reject) {
                new Jolokia({
                    url: JVM.createServerConnectionUrl(connection),
                    method: 'post',
                    mimeType: 'application/json',
                    username: username,
                    password: password
                }).request({
                    type: 'version'
                }, {
                    success: function (response) {
                        resolve(true);
                    },
                    error: function (response) {
                        resolve(false);
                    },
                    ajaxError: function (response) {
                        resolve(false);
                    }
                });
            });
        };
        ;
        ConnectService.prototype.connect = function (connection) {
            JVM.log.debug("Connecting with options: ", StringHelpers.toString(connection));
            var url = URI('').search({ con: connection.name }).toString();
            this.$window.open(url);
        };
        ConnectService.prototype.getDefaultOptions = function () {
            return {
                port: this.getBrowserUrlPortNumber(),
                path: this.getBrowserUrlContextPath() + '/jolokia'
            };
        };
        ConnectService.prototype.getBrowserUrlPortNumber = function () {
            var port = null;
            try {
                var uri = URI(this.$location.absUrl());
                if (uri.port()) {
                    port = parseInt(uri.port());
                }
            }
            catch (error) {
                JVM.log.error(error);
            }
            return port;
        };
        ConnectService.prototype.getBrowserUrlContextPath = function () {
            var contextPath = null;
            try {
                var uri = URI(this.$location.absUrl());
                var uriPath = uri.path();
                var locationPath = this.$location.path();
                contextPath = uriPath.slice(0, uriPath.indexOf(locationPath));
            }
            catch (error) {
                JVM.log.error(error);
            }
            return contextPath;
        };
        return ConnectService;
    }());
    JVM.ConnectService = ConnectService;
})(JVM || (JVM = {}));
/// <reference path="connect.service.ts"/>
var JVM;
(function (JVM) {
    var ConnectController = /** @class */ (function () {
        ConnectController.$inject = ["$timeout", "$uibModal", "connectService"];
        function ConnectController($timeout, $uibModal, connectService) {
            'ngInject';
            var _this = this;
            this.$timeout = $timeout;
            this.$uibModal = $uibModal;
            this.connectService = connectService;
            this.connections = [];
            this.listConfig = {
                selectionMatchProp: 'name',
                selectItems: false,
                showSelectBox: false
            };
            this.listActionButtons = [
                { name: 'Connect', actionFn: function (action, connection) { return _this.connect(connection); } }
            ];
            this.listActionDropDown = [
                { name: 'Edit', actionFn: function (action, connection) { return _this.editConnection(connection); } },
                { name: 'Delete', actionFn: function (action, connection) { return _this.deleteConnection(connection); } }
            ];
        }
        ConnectController.prototype.$onInit = function () {
            this.connections = this.connectService.getConnections();
            this.connectService.updateReachableFlags(this.connections);
            this.setTimerToUpdateReachableFlags();
        };
        ConnectController.prototype.$onDestroy = function () {
            this.$timeout.cancel(this.promise);
        };
        ConnectController.prototype.setTimerToUpdateReachableFlags = function () {
            var _this = this;
            this.promise = this.$timeout(function () {
                _this.connectService.updateReachableFlags(_this.connections)
                    .then(function (connections) { return _this.setTimerToUpdateReachableFlags(); });
            }, 20000);
        };
        ConnectController.prototype.addConnection = function () {
            var _this = this;
            var defaultOptions = this.connectService.getDefaultOptions();
            this.$uibModal.open({
                component: 'connectEditModal',
                resolve: {
                    connection: function () { return JVM.createConnectOptions(defaultOptions); },
                    connectionNames: function () { return _this.connections.map(function (conn) { return conn.name; }); }
                },
            })
                .result.then(function (connection) {
                _this.connections.unshift(connection);
                _this.connectService.saveConnections(_this.connections);
                _this.connectService.updateReachableFlag(connection);
            });
        };
        ConnectController.prototype.editConnection = function (connection) {
            var _this = this;
            var clone = angular.extend({}, connection);
            this.$uibModal.open({
                component: 'connectEditModal',
                resolve: {
                    connection: function () { return clone; },
                    connectionNames: function () { return _this.connections
                        .filter(function (conn) { return conn.name !== clone.name; })
                        .map(function (conn) { return conn.name; }); }
                },
            })
                .result.then(function (clone) {
                angular.extend(connection, clone);
                _this.connectService.saveConnections(_this.connections);
                _this.connectService.updateReachableFlag(connection);
            });
        };
        ConnectController.prototype.deleteConnection = function (connection) {
            var _this = this;
            this.$uibModal.open({
                component: 'connectDeleteModal'
            })
                .result.then(function () {
                _this.connections = _.without(_this.connections, connection);
                _this.connectService.saveConnections(_this.connections);
            });
        };
        ConnectController.prototype.connect = function (connection) {
            if (connection.reachable) {
                this.connectService.connect(connection);
            }
            else {
                this.$uibModal.open({
                    component: 'connectUnreachableModal'
                });
            }
        };
        return ConnectController;
    }());
    JVM.connectComponent = {
        templateUrl: 'plugins/jvm/html/connect.html',
        controller: ConnectController
    };
})(JVM || (JVM = {}));
var JVM;
(function (JVM) {
    var ConnectEditModalController = /** @class */ (function () {
        ConnectEditModalController.$inject = ["connectService"];
        function ConnectEditModalController(connectService) {
            'ngInject';
            this.connectService = connectService;
            this.errors = {};
            this.test = { ok: false, message: null };
        }
        ConnectEditModalController.prototype.$onInit = function () {
            this.connection = this.resolve.connection;
            this.connectionNames = this.resolve.connectionNames;
            this.operation = this.connection.name ? 'edit' : 'add';
        };
        ConnectEditModalController.prototype.testConnection = function (connection) {
            var _this = this;
            this.connectService.testConnection(connection)
                .then(function (ok) {
                _this.test.ok = ok;
                _this.test.message = ok ? 'Connected successfully' : 'Connection failed';
            });
        };
        ;
        ConnectEditModalController.prototype.cancel = function () {
            this.modalInstance.dismiss();
        };
        ConnectEditModalController.prototype.saveConnection = function (connection) {
            this.errors = this.validateConnection(connection);
            if (Object.keys(this.errors).length === 0) {
                this.modalInstance.close(this.connection);
            }
        };
        ConnectEditModalController.prototype.validateConnection = function (connection) {
            var errors = {};
            if (connection.name === null || connection.name.trim().length === 0) {
                errors['name'] = 'Please fill out this field';
            }
            if (this.connectionNames.indexOf(connection.name.trim()) >= 0) {
                errors['name'] = "Connection name '" + connection.name.trim() + "' is already in use";
            }
            if (connection.host === null || connection.host.trim().length === 0) {
                errors['host'] = 'Please fill out this field';
            }
            if (connection.port !== null && connection.port < 0 || connection.port > 65535) {
                errors['port'] = 'Please enter a number from 0 to 65535';
            }
            return errors;
        };
        return ConnectEditModalController;
    }());
    JVM.ConnectEditModalController = ConnectEditModalController;
    JVM.connectEditModalComponent = {
        bindings: {
            modalInstance: '<',
            resolve: '<'
        },
        templateUrl: 'plugins/jvm/html/connect-edit.html',
        controller: ConnectEditModalController
    };
})(JVM || (JVM = {}));
var JVM;
(function (JVM) {
    JVM.connectDeleteModalComponent = {
        bindings: {
            close: '&',
            dismiss: '&'
        },
        template: "\n      <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" aria-label=\"Close\" ng-click=\"$ctrl.dismiss()\">\n          <span class=\"pficon pficon-close\" aria-hidden=\"true\"></span>\n        </button>\n        <h4 class=\"modal-title\">Are you sure?</h4>\n      </div>\n      <div class=\"modal-body\">\n        <p>You are about to delete this connection.</p>\n      </div>\n      <div class=\"modal-footer\">\n        <button type=\"button\" class=\"btn btn-default\" ng-click=\"$ctrl.dismiss()\">Cancel</button>\n        <button type=\"button\" class=\"btn btn-danger\" ng-click=\"$ctrl.close()\">Delete</button>\n      </div>\n    "
    };
})(JVM || (JVM = {}));
var JVM;
(function (JVM) {
    var ConnectLoginController = /** @class */ (function () {
        ConnectLoginController.$inject = ["$location", "$window", "$uibModal", "userDetails", "postLoginTasks", "postLogoutTasks"];
        function ConnectLoginController($location, $window, $uibModal, userDetails, postLoginTasks, postLogoutTasks) {
            'ngInject';
            this.$location = $location;
            this.$window = $window;
            this.$uibModal = $uibModal;
            this.userDetails = userDetails;
            this.postLoginTasks = postLoginTasks;
            this.postLogoutTasks = postLogoutTasks;
        }
        ConnectLoginController.prototype.$onInit = function () {
            var _this = this;
            this.$uibModal.open({
                backdrop: 'static',
                component: 'connectLoginModal'
            })
                .result.then(function (credentials) {
                _this.registerTaskToPersistCredentials(credentials);
                _this.userDetails.login(credentials.username, credentials.password);
                _this.$window.location.href = _this.$location.search().redirect;
            })
                .catch(function (error) {
                _this.$window.close();
            });
        };
        ConnectLoginController.prototype.registerTaskToPersistCredentials = function (credentials) {
            var _this = this;
            this.postLoginTasks.addTask('set-credentials-in-session-storage', function () {
                _this.$window.sessionStorage.setItem('username', credentials.username);
                _this.$window.sessionStorage.setItem('password', credentials.password);
            });
            this.postLogoutTasks.addTask('remove-credentials-from-session-storage', function () {
                _this.$window.sessionStorage.removeItem('username');
                _this.$window.sessionStorage.removeItem('password');
            });
        };
        return ConnectLoginController;
    }());
    JVM.ConnectLoginController = ConnectLoginController;
    JVM.connectLoginComponent = {
        controller: ConnectLoginController
    };
})(JVM || (JVM = {}));
var JVM;
(function (JVM) {
    var ConnectLoginModalController = /** @class */ (function () {
        ConnectLoginModalController.$inject = ["ConnectOptions", "connectService"];
        function ConnectLoginModalController(ConnectOptions, connectService) {
            'ngInject';
            this.ConnectOptions = ConnectOptions;
            this.connectService = connectService;
            this.invalidCredentials = false;
        }
        ConnectLoginModalController.prototype.cancel = function () {
            this.modalInstance.dismiss();
        };
        ConnectLoginModalController.prototype.login = function (username, password) {
            var _this = this;
            this.connectService.checkCredentials(this.ConnectOptions, username, password)
                .then(function (ok) {
                if (ok) {
                    _this.modalInstance.close({ username: username, password: password });
                }
                else {
                    _this.invalidCredentials = true;
                }
            });
        };
        return ConnectLoginModalController;
    }());
    JVM.ConnectLoginModalController = ConnectLoginModalController;
    JVM.connectLoginModalComponent = {
        bindings: {
            modalInstance: '<'
        },
        template: "\n      <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" aria-label=\"Close\" ng-click=\"$ctrl.cancel()\">\n          <span class=\"pficon pficon-close\" aria-hidden=\"true\"></span>\n        </button>\n        <h4 class=\"modal-title\">Log In</h4>\n      </div>\n      <form name=\"connectForm\" class=\"form-horizontal\" ng-submit=\"$ctrl.login(username, password)\">\n        <div class=\"modal-body\">\n          <div class=\"alert alert-danger\" ng-show=\"$ctrl.invalidCredentials\">\n            <span class=\"pficon pficon-error-circle-o\"></span> Incorrect username or password\n          </div>    \n          <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\" for=\"connection-username\">Username</label>\n            <div class=\"col-sm-8\">\n              <input type=\"text\" id=\"connection-username\" class=\"form-control\" ng-model=\"username\" pf-focused=\"true\">\n            </div>\n          </div>\n          <div class=\"form-group\">\n            <label class=\"col-sm-3 control-label\" for=\"connection-password\">Password</label>\n            <div class=\"col-sm-8\">\n              <input type=\"password\" id=\"connection-password\" class=\"form-control\" ng-model=\"password\">\n            </div>\n          </div>\n        </div>\n        <div class=\"modal-footer\">\n          <button type=\"button\" class=\"btn btn-default\" ng-click=\"$ctrl.cancel()\">Cancel</button>\n          <button type=\"submit\" class=\"btn btn-primary\">Log In</button>\n        </div>\n      </form>\n    ",
        controller: ConnectLoginModalController
    };
})(JVM || (JVM = {}));
var JVM;
(function (JVM) {
    JVM.connectUnreachableModalComponent = {
        bindings: {
            close: '&'
        },
        template: "\n      <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" aria-label=\"Close\" ng-click=\"$ctrl.close()\">\n          <span class=\"pficon pficon-close\" aria-hidden=\"true\"></span>\n        </button>\n        <h4 class=\"modal-title\">Endpoint Unreachable</h4>\n      </div>\n      <div class=\"modal-body\">\n        <p>This Jolokia endpoint is unreachable. Please check the connection details and try again.</p>\n      </div>\n      <div class=\"modal-footer\">\n        <button type=\"button\" class=\"btn btn-primary\" ng-click=\"$ctrl.close()\">OK</button>\n      </div>\n    "
    };
})(JVM || (JVM = {}));
var JVM;
(function (JVM) {
    function ConnectionUrlFilter() {
        return function (connection) {
            var url = connection.scheme + "://" + connection.host;
            if (connection.port) {
                url += ":" + connection.port;
            }
            if (connection.path) {
                url += "/" + connection.path;
            }
            return url;
        };
    }
    JVM.ConnectionUrlFilter = ConnectionUrlFilter;
})(JVM || (JVM = {}));
/// <reference path="connect.component.ts"/>
/// <reference path="connect-edit-modal.component.ts"/>
/// <reference path="connect-delete-modal.component.ts"/>
/// <reference path="connect-login.component.ts"/>
/// <reference path="connect-login-modal.component.ts"/>
/// <reference path="connect-unreachable-modal.component.ts"/>
/// <reference path="connect.service.ts"/>
/// <reference path="connection-url.filter.ts"/>
var JVM;
(function (JVM) {
    JVM.connectModule = angular
        .module('hawtio-jvm-connect', [])
        .component('connect', JVM.connectComponent)
        .component('connectEditModal', JVM.connectEditModalComponent)
        .component('connectDeleteModal', JVM.connectDeleteModalComponent)
        .component('connectLogin', JVM.connectLoginComponent)
        .component('connectLoginModal', JVM.connectLoginModalComponent)
        .component('connectUnreachableModal', JVM.connectUnreachableModalComponent)
        .service('connectService', JVM.ConnectService)
        .filter('connectionUrl', JVM.ConnectionUrlFilter)
        .name;
})(JVM || (JVM = {}));
var JVM;
(function (JVM) {
    createJolokiaParams.$inject = ["jolokiaUrl", "localStorage"];
    function createJolokiaParams(jolokiaUrl, localStorage) {
        'ngInject';
        var answer = {
            canonicalNaming: false,
            ignoreErrors: true,
            maxCollectionSize: JVM.DEFAULT_MAX_COLLECTION_SIZE,
            maxDepth: JVM.DEFAULT_MAX_DEPTH,
            method: 'post',
            mimeType: 'application/json'
        };
        if ('jolokiaParams' in localStorage) {
            answer = angular.fromJson(localStorage['jolokiaParams']);
        }
        else {
            localStorage['jolokiaParams'] = angular.toJson(answer);
        }
        answer['url'] = jolokiaUrl;
        return answer;
    }
    JVM.createJolokiaParams = createJolokiaParams;
})(JVM || (JVM = {}));
/// <reference path="../jvmPlugin.ts"/>
var JVM;
(function (JVM) {
    JolokiaPreferences.$inject = ["$scope", "localStorage", "jolokiaParams", "$window"];
    var SHOW_ALERT = 'showJolokiaPreferencesAlert';
    function JolokiaPreferences($scope, localStorage, jolokiaParams, $window) {
        'ngInject';
        // Initialize tooltips
        $('[data-toggle="tooltip"]').tooltip();
        Core.initPreferenceScope($scope, localStorage, {
            'updateRate': {
                'value': 5000,
                'post': function (newValue) {
                    $scope.$emit('UpdateRate', newValue);
                }
            },
            'maxDepth': {
                'value': JVM.DEFAULT_MAX_DEPTH,
                'converter': parseInt,
                'formatter': parseInt,
                'post': function (newValue) {
                    jolokiaParams.maxDepth = newValue;
                    localStorage['jolokiaParams'] = angular.toJson(jolokiaParams);
                }
            },
            'maxCollectionSize': {
                'value': JVM.DEFAULT_MAX_COLLECTION_SIZE,
                'converter': parseInt,
                'formatter': parseInt,
                'post': function (newValue) {
                    jolokiaParams.maxCollectionSize = newValue;
                    localStorage['jolokiaParams'] = angular.toJson(jolokiaParams);
                }
            }
        });
        $scope.showAlert = !!$window.sessionStorage.getItem(SHOW_ALERT);
        $window.sessionStorage.removeItem(SHOW_ALERT);
        $scope.reboot = function () {
            $window.sessionStorage.setItem(SHOW_ALERT, 'true');
            $window.location.reload();
        };
    }
    JVM.JolokiaPreferences = JolokiaPreferences;
})(JVM || (JVM = {}));
var JVM;
(function (JVM) {
    var JolokiaService = /** @class */ (function () {
        JolokiaService.$inject = ["$q", "jolokia"];
        function JolokiaService($q, jolokia) {
            'ngInject';
            this.$q = $q;
            this.jolokia = jolokia;
        }
        JolokiaService.prototype.getMBean = function (objectName) {
            var _this = this;
            return this.$q(function (resolve, reject) {
                _this.jolokia.request({ type: 'read', mbean: objectName }, Core.onSuccess(function (response) {
                    resolve(response.value);
                }, {
                    error: function (response) {
                        JVM.log.error("JolokiaService.getMBean('" + objectName + "') failed: " + response.error);
                        reject(response.error);
                    },
                    ajaxError: function (jqXHR) {
                        JVM.log.error("JolokiaService.getMBean('" + objectName + "') failed: " + jqXHR.responseText);
                        reject(jqXHR.responseText);
                    }
                }));
            });
        };
        JolokiaService.prototype.getMBeans = function (objectNames) {
            var _this = this;
            return this.$q(function (resolve, reject) {
                if (objectNames.length === 0) {
                    return resolve([]);
                }
                else {
                    var requests_1 = objectNames.map(function (mbeanName) { return ({ type: 'read', mbean: mbeanName }); });
                    var mbeans_1 = [];
                    _this.jolokia.request(requests_1, Core.onSuccess(function (response) {
                        mbeans_1.push(response.value);
                        if (mbeans_1.length === requests_1.length) {
                            resolve(mbeans_1);
                        }
                    }, {
                        error: function (response) {
                            JVM.log.error("JolokiaService.getMBeans('" + objectNames + "') failed: " + response.error);
                            reject(response.error);
                        },
                        ajaxError: function (jqXHR) {
                            JVM.log.error("JolokiaService.getMBeans('" + objectNames + "') failed: " + jqXHR.responseText);
                            reject(jqXHR.responseText);
                        }
                    }));
                }
            });
        };
        JolokiaService.prototype.getAttribute = function (objectName, attribute) {
            var _this = this;
            return this.$q(function (resolve, reject) {
                _this.jolokia.request({ type: 'read', mbean: objectName, attribute: attribute }, Core.onSuccess(function (response) {
                    resolve(response.value);
                }, {
                    error: function (response) {
                        JVM.log.error("JolokiaService.getAttribute('" + objectName + "', '" + attribute + "') failed: " + response.error);
                        reject(response.error);
                    },
                    ajaxError: function (jqXHR) {
                        JVM.log.error("JolokiaService.getAttribute('" + objectName + "', '" + attribute + "') failed: " + jqXHR.responseText);
                        reject(jqXHR.responseText);
                    }
                }));
            });
        };
        JolokiaService.prototype.getAttributes = function (objectName, attributes) {
            var _this = this;
            return this.$q(function (resolve, reject) {
                _this.jolokia.request({ type: 'read', mbean: objectName, attribute: attributes }, Core.onSuccess(function (response) {
                    resolve(response.value);
                }, {
                    error: function (response) {
                        JVM.log.error("JolokiaService.getAttributes('" + objectName + "', '" + attributes + "') failed: " + response.error);
                        reject(response.error);
                    },
                    ajaxError: function (jqXHR) {
                        JVM.log.error("JolokiaService.getAttributes('" + objectName + "', '" + attributes + "') failed: " + jqXHR.responseText);
                        reject(jqXHR.responseText);
                    }
                }));
            });
        };
        JolokiaService.prototype.setAttribute = function (objectName, attribute, value) {
            var _this = this;
            return this.$q(function (resolve, reject) {
                _this.jolokia.request({ type: 'write', mbean: objectName, attribute: attribute, value: value }, Core.onSuccess(function (response) {
                    resolve(response.value);
                }, {
                    error: function (response) {
                        JVM.log.error("JolokiaService.setAttribute('" + objectName + "', '" + attribute + "', '" + value + "') failed: " + response.error);
                        reject(response.error);
                    },
                    ajaxError: function (jqXHR) {
                        JVM.log.error("JolokiaService.setAttribute('" + objectName + "', '" + attribute + "', '" + value + "') failed: " + jqXHR.responseText);
                        reject(jqXHR.responseText);
                    }
                }));
            });
        };
        JolokiaService.prototype.setAttributes = function (objectName, attributes, values) {
            var _this = this;
            return this.$q(function (resolve, reject) {
                if (attributes.length != values.length) {
                    return resolve([]);
                }
                else {
                    var requests_2 = attributes.map(function (attribute, index) { return ({ type: 'write', mbean: objectName, attribute: attribute, value: values[index] }); });
                    var results_1 = [];
                    _this.jolokia.request(requests_2, Core.onSuccess(function (response) {
                        results_1.push(response.value);
                        if (results_1.length === requests_2.length) {
                            resolve(results_1);
                        }
                    }, {
                        error: function (response) {
                            JVM.log.error("JolokiaService.setAttributes('" + objectName + "', '" + attributes + "', '" + values + "') failed: " + response.error);
                            reject(response.error);
                        },
                        ajaxError: function (jqXHR) {
                            JVM.log.error("JolokiaService.setAttributes('" + objectName + "', '" + attributes + "', '" + values + "') failed: " + jqXHR.responseText);
                            reject(jqXHR.responseText);
                        }
                    }));
                }
            });
        };
        JolokiaService.prototype.execute = function (objectName, operation) {
            var _this = this;
            var args = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                args[_i - 2] = arguments[_i];
            }
            return this.$q(function (resolve, reject) {
                _this.jolokia.request({ type: 'exec', mbean: objectName, operation: operation, arguments: args }, Core.onSuccess(function (response) {
                    resolve(response.value);
                }, {
                    error: function (response) {
                        JVM.log.error("JolokiaService.execute('" + objectName + "', '" + operation + "', '" + args + "') failed: " + response.error);
                        reject(response.error);
                    },
                    ajaxError: function (jqXHR) {
                        JVM.log.error("JolokiaService.execute('" + objectName + "', '" + operation + "', '" + args + "') failed: " + jqXHR.responseText);
                        reject(jqXHR.responseText);
                    }
                }));
            });
        };
        JolokiaService.prototype.executeMany = function (objectNames, operation) {
            var _this = this;
            var args = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                args[_i - 2] = arguments[_i];
            }
            return this.$q(function (resolve, reject) {
                if (objectNames.length === 0) {
                    return resolve([]);
                }
                else {
                    var requests_3 = objectNames.map(function (objectName) { return ({ type: 'exec', mbean: objectName, operation: operation, arguments: args }); });
                    var results_2 = [];
                    _this.jolokia.request(requests_3, Core.onSuccess(function (response) {
                        results_2.push(response.value);
                        if (results_2.length === requests_3.length) {
                            resolve(results_2);
                        }
                    }, {
                        error: function (response) {
                            JVM.log.error("JolokiaService.executeMany('" + objectNames + "', '" + operation + "', '" + args + "') failed: " + response.error);
                            reject(response.error);
                        },
                        ajaxError: function (jqXHR) {
                            JVM.log.error("JolokiaService.executeMany('" + objectNames + "', '" + operation + "', '" + args + "') failed: " + jqXHR.responseText);
                            reject(jqXHR.responseText);
                        }
                    }));
                }
            });
        };
        JolokiaService.prototype.search = function (mbeanPattern) {
            var _this = this;
            return this.$q(function (resolve, reject) {
                _this.jolokia.request({ type: 'search', mbean: mbeanPattern }, Core.onSuccess(function (response) {
                    resolve(response.value);
                }, {
                    error: function (response) {
                        JVM.log.error("JolokiaService.search('" + mbeanPattern + "') failed: " + response.error);
                        reject(response.error);
                    },
                    ajaxError: function (jqXHR) {
                        JVM.log.error("JolokiaService.search('" + mbeanPattern + "') failed: " + jqXHR.responseText);
                        reject(jqXHR.responseText);
                    }
                }));
            });
        };
        return JolokiaService;
    }());
    JVM.JolokiaService = JolokiaService;
})(JVM || (JVM = {}));
/// <reference path="jolokia-params.factory.ts"/>
/// <reference path="jolokia-preferences.controller.ts"/>
/// <reference path="jolokia.service.ts"/>
var JVM;
(function (JVM) {
    JVM.jolokiaModule = angular
        .module('hawtio-jvm-jolokia', [])
        .controller("JVM.JolokiaPreferences", JVM.JolokiaPreferences)
        .service("jolokiaService", JVM.JolokiaService)
        .factory('jolokiaParams', JVM.createJolokiaParams)
        .name;
})(JVM || (JVM = {}));
var JVM;
(function (JVM) {
    var JvmController = /** @class */ (function () {
        JvmController.$inject = ["workspace"];
        function JvmController(workspace) {
            'ngInject';
            this.tabs = [new Nav.HawtioTab('Remote', '/jvm/connect')];
            if (JVM.hasLocalMBean(workspace)) {
                this.tabs.push(new Nav.HawtioTab('Local', '/jvm/local'));
            }
            if (JVM.hasDiscoveryMBean(workspace)) {
                this.tabs.push(new Nav.HawtioTab('Discover', '/jvm/discover'));
            }
        }
        return JvmController;
    }());
    JVM.JvmController = JvmController;
    JVM.jvmComponent = {
        template: '<hawtio-tabs-layout tabs="$ctrl.tabs"></hawtio-tabs-layout>',
        controller: JvmController
    };
})(JVM || (JVM = {}));
/// <reference path="connect/connect.module.ts"/>
/// <reference path="jolokia/jolokia.module.ts"/>
/// <reference path="jvm.component.ts"/>
var JVM;
(function (JVM) {
    defineRoutes.$inject = ["$routeProvider"];
    configurePlugin.$inject = ["mainNavService", "$location", "viewRegistry", "helpRegistry", "preferencesRegistry", "ConnectOptions", "preLogoutTasks", "locationChangeStartTasks", "HawtioDashboard", "HawtioExtension", "$templateCache", "$compile"];
    startJolokia.$inject = ["$q", "initService", "jolokia", "localStorage"];
    JVM._module = angular
        .module(JVM.pluginName, [
        JVM.connectModule,
        JVM.jolokiaModule
    ])
        .config(defineRoutes)
        .constant('mbeanName', 'hawtio:type=JVMList')
        .run(configurePlugin)
        .run(startJolokia)
        .component("jvm", JVM.jvmComponent);
    function defineRoutes($routeProvider) {
        'ngInject';
        $routeProvider
            .when('/jvm/connect', { template: '<connect></connect>' })
            .when('/jvm/connect-login', { template: '<connect-login></connect-login>' })
            .when('/jvm/welcome', { templateUrl: UrlHelpers.join(JVM.templatePath, 'welcome.html') })
            .when('/jvm/discover', { templateUrl: UrlHelpers.join(JVM.templatePath, 'discover.html') })
            .when('/jvm/local', { templateUrl: UrlHelpers.join(JVM.templatePath, 'local.html') });
    }
    function configurePlugin(mainNavService, $location, viewRegistry, helpRegistry, preferencesRegistry, ConnectOptions, preLogoutTasks, locationChangeStartTasks, HawtioDashboard, HawtioExtension, $templateCache, $compile) {
        'ngInject';
        viewRegistry['jvm'] = "plugins/jvm/html/layoutConnect.html";
        HawtioExtension.add('hawtio-header', function ($scope) {
            var template = $templateCache.get(UrlHelpers.join(JVM.templatePath, 'navbarHeaderExtension.html'));
            return $compile(template)($scope);
        });
        if (!HawtioDashboard.inDashboard) {
            // ensure that if the connection parameter is present, that we keep it
            locationChangeStartTasks.addTask('ConParam', function ($event, newUrl, oldUrl) {
                // we can't execute until the app is initialized...
                if (!HawtioCore.injector) {
                    return;
                }
                if (!ConnectOptions || !ConnectOptions.name || !newUrl) {
                    return;
                }
                var newQuery = new URI(newUrl).query(true);
                if (!newQuery.con) {
                    newQuery['con'] = ConnectOptions.name;
                    $location.search(newQuery);
                }
            });
        }
        // clean up local storage upon logout
        preLogoutTasks.addTask('CleanupJvmConnectCredentials', function () {
            JVM.log.debug("Clean up credentials from JVM connection settings in local storage");
            var connections = JVM.loadConnections();
            connections.forEach(function (connection) {
                delete connection.userName;
                delete connection.password;
            });
            JVM.saveConnections(connections);
        });
        helpRegistry.addUserDoc('jvm', 'plugins/jvm/doc/help.md');
        preferencesRegistry.addTab("Connect", 'plugins/jvm/html/reset.html');
        preferencesRegistry.addTab("Jolokia", "plugins/jvm/html/jolokia-preferences.html");
        mainNavService.addItem({
            title: 'Connect',
            basePath: '/jvm',
            template: '<jvm></jvm>',
            isValid: function () { return ConnectOptions == null || ConnectOptions.name == null; }
        });
    }
    function startJolokia($q, initService, jolokia, localStorage) {
        'ngInject';
        initService.registerInitFunction(function () {
            return $q(function (resolve) {
                var updateRate = localStorage['updateRate'];
                if (updateRate && updateRate > 0) {
                    jolokia.start(updateRate);
                    JVM.log.info('JVM.startJolokia: started');
                }
                resolve();
            });
        });
    }
    hawtioPluginLoader.addModule(JVM.pluginName);
})(JVM || (JVM = {}));
/// <reference path="../jvmPlugin.ts"/>
var JVM;
(function (JVM) {
    createJolokia.$inject = ["$location", "localStorage", "jolokiaStatus", "jolokiaParams", "jolokiaUrl", "userDetails", "postLoginTasks", "$timeout"];
    var JolokiaListMethod;
    (function (JolokiaListMethod) {
        // constant meaning that general LIST+EXEC Jolokia operations should be used
        JolokiaListMethod["LIST_GENERAL"] = "list";
        // constant meaning that optimized hawtio:type=security,name=RBACRegistry may be used
        JolokiaListMethod["LIST_WITH_RBAC"] = "list_rbac";
        // when we get this status, we have to try checking again after logging in
        JolokiaListMethod["LIST_CANT_DETERMINE"] = "cant_determine";
    })(JolokiaListMethod = JVM.JolokiaListMethod || (JVM.JolokiaListMethod = {}));
    var JOLOKIA_RBAC_LIST_MBEAN = "hawtio:type=security,name=RBACRegistry";
    JVM.DEFAULT_MAX_DEPTH = 7;
    JVM.DEFAULT_MAX_COLLECTION_SIZE = 50000;
    var urlCandidates = ['/hawtio/jolokia', '/jolokia', 'jolokia'];
    var discoveredUrl = null;
    hawtioPluginLoader.registerPreBootstrapTask({
        name: 'JvmParseLocation',
        task: function (next) {
            var uri = new URI();
            var query = uri.query(true);
            JVM.log.debug("query: ", query);
            var jolokiaUrl = query['jolokiaUrl'];
            if (jolokiaUrl) {
                delete query['sub-tab'];
                delete query['main-tab'];
                jolokiaUrl = URI.decode(jolokiaUrl);
                var jolokiaURI = new URI(jolokiaUrl);
                var name_1 = query['title'] || 'Unknown Connection';
                var token = query['token'] || Core.trimLeading(uri.hash(), '#');
                var options = createConnectOptions({
                    jolokiaUrl: jolokiaUrl,
                    name: name_1,
                    scheme: jolokiaURI.protocol(),
                    host: jolokiaURI.hostname(),
                    port: Core.parseIntValue(jolokiaURI.port()),
                    path: Core.trimLeading(jolokiaURI.pathname(), '/')
                });
                if (!Core.isBlank(token)) {
                    options['token'] = token;
                }
                _.merge(options, jolokiaURI.query(true));
                _.assign(options, query);
                JVM.log.debug("options: ", options);
                var connections = JVM.loadConnections().filter(function (connection) { return connection.name !== name_1; });
                connections.push(options);
                JVM.saveConnections(connections);
                uri.hash("").query({
                    con: name_1
                });
                window.location.replace(uri.toString());
                // don't allow bootstrap to continue
                return;
            }
            var connectionName = query['con'];
            if (connectionName) {
                JVM.log.debug("Not discovering jolokia");
                // a connection name is set, no need to discover a jolokia instance
                next();
                return;
            }
            function maybeCheckNext(candidates) {
                if (candidates.length === 0) {
                    next();
                }
                else {
                    checkNext(candidates.pop());
                }
            }
            function checkNext(url) {
                JVM.log.debug("Trying URL:", url);
                $.ajax(url).always(function (data, statusText, jqXHR) {
                    // for $.ajax().always(), the xhr is flipped on fail
                    if (statusText !== 'success') {
                        jqXHR = data;
                    }
                    if (jqXHR.status === 200) {
                        try {
                            var resp = angular.fromJson(data);
                            //log.debug("Got response: ", resp);
                            if ('value' in resp && 'agent' in resp.value) {
                                discoveredUrl = url;
                                JVM.log.debug("Found jolokia agent at:", url, "version:", resp.value.agent);
                                next();
                            }
                            else {
                                maybeCheckNext(urlCandidates);
                            }
                        }
                        catch (e) {
                            maybeCheckNext(urlCandidates);
                        }
                    }
                    else if (jqXHR.status === 401 || jqXHR.status === 403) {
                        // I guess this could be it...
                        discoveredUrl = url;
                        JVM.log.debug("Using URL:", url, "assuming it could be an agent but got return code:", jqXHR.status);
                        next();
                    }
                    else {
                        maybeCheckNext(urlCandidates);
                    }
                });
            }
            checkNext(urlCandidates.pop());
        }
    });
    JVM.ConnectionName = null;
    function getConnectionName(reset) {
        if (reset === void 0) { reset = false; }
        if (!Core.isBlank(JVM.ConnectionName) && !reset) {
            return JVM.ConnectionName;
        }
        JVM.ConnectionName = '';
        var search = new URI().search(true);
        if ('con' in window) {
            JVM.ConnectionName = window['con'];
            JVM.log.debug("Using connection name from window:", JVM.ConnectionName);
        }
        else if ('con' in search) {
            JVM.ConnectionName = search['con'];
            JVM.log.debug("Using connection name from URL:", JVM.ConnectionName);
        }
        else {
            JVM.log.debug("No connection name found, using direct connection to JVM");
        }
        return JVM.ConnectionName;
    }
    JVM.getConnectionName = getConnectionName;
    var connectOptions = (function () {
        var name = getConnectionName();
        if (Core.isBlank(name)) {
            // this will fail any if (ConnectOptions) check
            return null;
        }
        var answer = JVM.getConnectOptions(name);
        // load saved credentials when connecting to remote server
        answer.userName = sessionStorage.getItem('username');
        answer.password = sessionStorage.getItem('password');
        return answer;
    })();
    function getJolokiaUrl() {
        var answer = undefined;
        var documentBase = HawtioCore.documentBase();
        if (!connectOptions || !connectOptions.name) {
            JVM.log.debug("Using discovered URL");
            answer = discoveredUrl;
        }
        else {
            answer = JVM.createServerConnectionUrl(connectOptions);
            JVM.log.debug("Using configured URL");
        }
        if (!answer) {
            // this will force a dummy jolokia instance
            return false;
        }
        // build full URL
        var windowURI = new URI();
        var jolokiaURI = undefined;
        if (_.startsWith(answer, '/') || _.startsWith(answer, 'http')) {
            jolokiaURI = new URI(answer);
        }
        else {
            jolokiaURI = new URI(UrlHelpers.join(documentBase, answer));
        }
        if (!connectOptions || !connectOptions.jolokiaUrl) {
            if (!jolokiaURI.protocol()) {
                jolokiaURI.protocol(windowURI.protocol());
            }
            if (!jolokiaURI.hostname()) {
                jolokiaURI.host(windowURI.hostname());
            }
            if (!jolokiaURI.port()) {
                jolokiaURI.port(windowURI.port());
            }
        }
        answer = jolokiaURI.toString();
        JVM.log.debug("Complete jolokia URL: ", answer);
        return answer;
    }
    JVM.getJolokiaUrl = getJolokiaUrl;
    JVM._module.service('ConnectionName', function () { return function (reset) {
        if (reset === void 0) { reset = false; }
        return getConnectionName(reset);
    }; });
    JVM._module.service('ConnectOptions', function () { return connectOptions; });
    // the jolokia URL we're connected to
    JVM._module.factory('jolokiaUrl', function () { return getJolokiaUrl(); });
    // holds the status returned from the last jolokia call and hints for jolokia.list optimization
    JVM._module.factory('jolokiaStatus', createJolokiaStatus);
    JVM._module.factory('jolokia', createJolokia);
    function createJolokiaStatus() {
        'ngInject';
        return {
            xhr: null,
            listMethod: JolokiaListMethod.LIST_GENERAL,
            listMBean: JOLOKIA_RBAC_LIST_MBEAN
        };
    }
    function createJolokia($location, localStorage, jolokiaStatus, jolokiaParams, jolokiaUrl, userDetails, postLoginTasks, $timeout) {
        'ngInject';
        var jolokia = null;
        if (jolokiaUrl) {
            // hawtio-oauth may have already set up jQuery beforeSend
            if (!$.ajaxSettings.beforeSend) {
                JVM.log.debug("Setting up jQuery beforeSend");
                $.ajaxSetup({ beforeSend: getBeforeSend(userDetails) });
            }
            // execute post-login tasks in case they are not yet executed
            // TODO: Where is the right place to execute post-login tasks for unauthenticated hawtio app?
            postLoginTasks.execute();
            if (!jolokiaParams.ajaxError) {
                var errorThreshold_1 = 2;
                var errorCount_1 = 0;
                jolokiaParams.ajaxError = function (xhr, textStatus, error) {
                    if (xhr.status === 403) {
                        // If window was opened to connect to remote Jolokia endpoint
                        if (JVM.isRemoteConnection()) {
                            // ... and not showing the login modal
                            if ($location.path() !== '/jvm/connect-login') {
                                jolokia.stop();
                                var redirectUrl = $location.absUrl();
                                $location.path('/jvm/connect-login').search('redirect', redirectUrl);
                            }
                        }
                        else {
                            // just logout
                            if (userDetails.loggedIn) {
                                userDetails.logout();
                            }
                        }
                    }
                    else {
                        errorCount_1++;
                        var validityPeriod = localStorage['updateRate'] * (errorThreshold_1 + 1);
                        $timeout(function () { return errorCount_1--; }, validityPeriod);
                        if (errorCount_1 > errorThreshold_1) {
                            Core.notification('danger', 'Connection lost. Retrying...', localStorage['updateRate']);
                        }
                    }
                };
            }
            jolokia = new Jolokia(jolokiaParams);
            jolokia.stop();
            // let's check if we can call faster jolokia.list()
            checkJolokiaOptimization(jolokia, jolokiaStatus);
        }
        else {
            JVM.log.debug("Use dummy Jolokia");
            jolokia = new DummyJolokia();
        }
        return jolokia;
    }
    function getBeforeSend(userDetails) {
        // Just set Authorization for now...
        var header = 'Authorization';
        if (userDetails.loggedIn && userDetails.token) {
            JVM.log.debug("Setting authorization header to token");
            return function (xhr) {
                if (userDetails.token) {
                    xhr.setRequestHeader(header, 'Bearer ' + userDetails.token);
                }
            };
        }
        else if (connectOptions && connectOptions['token']) {
            return function (xhr) { return xhr.setRequestHeader(header, 'Bearer ' + connectOptions['token']); };
        }
        else if (connectOptions && connectOptions.userName && connectOptions.password) {
            JVM.log.debug("Setting authorization header to username/password");
            return function (xhr) {
                return xhr.setRequestHeader(header, Core.getBasicAuthHeader(connectOptions.userName, connectOptions.password));
            };
        }
        else {
            JVM.log.debug("Not setting any authorization header");
            return function (xhr) { };
        }
    }
    /**
     * Queries available server-side MBean to check if we can call optimized jolokia.list() operation
     * @param jolokia {Jolokia.IJolokia}
     * @param jolokiaStatus {JolokiaStatus}
     */
    function checkJolokiaOptimization(jolokia, jolokiaStatus) {
        JVM.log.debug("Checking if we can call optimized jolokia.list() operation");
        // NOTE: Sync XHR call to Jolokia is required here to resolve the available list method immediately
        var response = jolokia.list(Core.escapeMBeanPath(jolokiaStatus.listMBean), Core.onSuccess(null));
        if (response && _.isObject(response['op'])) {
            jolokiaStatus.listMethod = JolokiaListMethod.LIST_WITH_RBAC;
        }
        else {
            // we could get 403 error, mark the method as special case, equal in practice with LIST_GENERAL
            jolokiaStatus.listMethod = JolokiaListMethod.LIST_CANT_DETERMINE;
        }
        JVM.log.debug("Jolokia list method:", jolokiaStatus.listMethod);
    }
    /**
     * Empty jolokia that returns nothing
     */
    var DummyJolokia = /** @class */ (function () {
        function DummyJolokia() {
            this.isDummy = true;
            this.running = false;
        }
        DummyJolokia.prototype.request = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return null;
        };
        DummyJolokia.prototype.getAttribute = function (mbean, attribute, path, opts) { return null; };
        DummyJolokia.prototype.setAttribute = function (mbean, attribute, value, path, opts) { };
        ;
        DummyJolokia.prototype.execute = function (mbean, operation) {
            var args = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                args[_i - 2] = arguments[_i];
            }
            return null;
        };
        DummyJolokia.prototype.search = function (mBeanPatter, opts) { return null; };
        DummyJolokia.prototype.list = function (path, opts) { return null; };
        DummyJolokia.prototype.version = function (opts) { return null; };
        DummyJolokia.prototype.register = function (params) {
            var request = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                request[_i - 1] = arguments[_i];
            }
            return null;
        };
        DummyJolokia.prototype.unregister = function (handle) { };
        DummyJolokia.prototype.jobs = function () { return []; };
        DummyJolokia.prototype.start = function (period) { this.running = true; };
        DummyJolokia.prototype.stop = function () { this.running = false; };
        DummyJolokia.prototype.isRunning = function () { return this.running; };
        return DummyJolokia;
    }());
    JVM.DummyJolokia = DummyJolokia;
    function createConnectOptions(options) {
        if (options === void 0) { options = {}; }
        var defaults = {
            name: null,
            scheme: 'http',
            host: null,
            port: null,
            path: null,
            useProxy: true,
            jolokiaUrl: null,
            userName: null,
            password: null,
            reachable: true
        };
        return angular.extend(defaults, options);
    }
    JVM.createConnectOptions = createConnectOptions;
})(JVM || (JVM = {}));
var Jmx;
(function (Jmx) {
    var TreeEvent;
    (function (TreeEvent) {
        TreeEvent["Fetched"] = "jmxTreeFetched";
        TreeEvent["Updated"] = "jmxTreeUpdated";
        TreeEvent["NodeSelected"] = "jmxTreeClicked";
    })(TreeEvent = Jmx.TreeEvent || (Jmx.TreeEvent = {}));
})(Jmx || (Jmx = {}));
/// <reference path="../../jvm/ts/jolokia/jolokiaService.ts"/>
/// <reference path="tree/tree-event.ts"/>
var Jmx;
(function (Jmx) {
    var log = Logger.get("hawtio-jmx-workspace");
    var logTree = Logger.get("hawtio-jmx-workspace-tree");
    var HAWTIO_REGISTRY_MBEAN = "hawtio:type=Registry";
    var HAWTIO_TREE_WATCHER_MBEAN = "hawtio:type=TreeWatcher";
    /**
     * @class Workspace
     */
    var Workspace = /** @class */ (function () {
        function Workspace(jolokia, jolokiaStatus, jmxTreeLazyLoadRegistry, $location, $compile, $templateCache, localStorage, $rootScope) {
            this.jolokia = jolokia;
            this.jolokiaStatus = jolokiaStatus;
            this.jmxTreeLazyLoadRegistry = jmxTreeLazyLoadRegistry;
            this.$location = $location;
            this.$compile = $compile;
            this.$templateCache = $templateCache;
            this.localStorage = localStorage;
            this.$rootScope = $rootScope;
            this.operationCounter = 0;
            this.tree = new Jmx.Folder('MBeans');
            this.mbeanTypesToDomain = {};
            this.mbeanServicesToDomain = {};
            this.attributeColumnDefs = {};
            this.onClickRowHandlers = {};
            this.treePostProcessors = {};
            this.topLevelTabs = undefined;
            this.subLevelTabs = [];
            this.keyToNodeMap = {};
            this.pluginRegisterHandle = null;
            this.pluginUpdateCounter = null;
            this.treeWatchRegisterHandle = null;
            this.treeWatcherCounter = null;
            this.treeFetched = false;
            // mapData allows to store arbitrary data on the workspace
            this.mapData = {};
            this.rootId = 'root';
            this.separator = '-';
            // set defaults
            if (!('autoRefresh' in localStorage)) {
                localStorage['autoRefresh'] = true;
            }
            if (!('updateRate' in localStorage)) {
                localStorage['updateRate'] = 5000;
            }
        }
        /**
         * Creates a shallow copy child workspace with its own selection and location
         * @method createChildWorkspace
         * @param {ng.ILocationService} location
         * @return {Workspace}
         */
        Workspace.prototype.createChildWorkspace = function (location) {
            var child = new Workspace(this.jolokia, this.jolokiaStatus, this.jmxTreeLazyLoadRegistry, this.$location, this.$compile, this.$templateCache, this.localStorage, this.$rootScope);
            // lets copy across all the properties just in case
            _.forEach(this, function (value, key) { return child[key] = value; });
            child.$location = location;
            return child;
        };
        Workspace.prototype.getLocalStorage = function (key) {
            return this.localStorage[key];
        };
        Workspace.prototype.setLocalStorage = function (key, value) {
            this.localStorage[key] = value;
        };
        Workspace.prototype.jolokiaList = function (callback, flags) {
            var listMethod = this.jolokiaStatus.listMethod;
            switch (listMethod) {
                case JVM.JolokiaListMethod.LIST_WITH_RBAC:
                    log.debug("Invoking Jolokia list mbean in RBAC mode");
                    flags.maxDepth = 9;
                    this.jolokia.execute(this.jolokiaStatus.listMBean, "list()", Core.onSuccess(callback, flags));
                    break;
                case JVM.JolokiaListMethod.LIST_GENERAL:
                case JVM.JolokiaListMethod.LIST_CANT_DETERMINE:
                default:
                    log.debug("Invoking Jolokia list mbean in general mode");
                    this.jolokia.list(null, Core.onSuccess(callback, flags));
                    break;
            }
        };
        Workspace.prototype.loadTree = function () {
            var _this = this;
            var workspace = this;
            if (this.jolokia['isDummy']) {
                setTimeout(function () {
                    workspace.setTreeFetched();
                    workspace.populateTree({ value: {} });
                }, 10);
                return;
            }
            var flags = {
                ignoreErrors: true,
                error: function (response) {
                    workspace.setTreeFetched();
                    log.debug("Error fetching JMX tree:", response);
                },
                ajaxError: function (response) {
                    workspace.setTreeFetched();
                    log.debug("Error fetching JMX tree:", response);
                }
            };
            log.debug("Jolokia:", this.jolokia);
            this.jolokiaList(function (response) {
                _this.jolokiaStatus.xhr = null;
                workspace.setTreeFetched();
                workspace.populateTree({ value: _this.unwindResponseWithRBACCache(response) });
            }, flags);
        };
        /**
         * Adds a post processor of the tree to swizzle the tree metadata after loading
         * such as correcting any typeName values or CSS styles by hand
         * @method addTreePostProcessor
         * @param {Function} processor
         */
        Workspace.prototype.addTreePostProcessor = function (processor) {
            var numKeys = _.keys(this.treePostProcessors).length;
            var nextKey = numKeys + 1;
            return this.addNamedTreePostProcessor(nextKey + '', processor);
        };
        Workspace.prototype.addNamedTreePostProcessor = function (name, processor) {
            this.treePostProcessors[name] = processor;
            var tree = this.tree;
            if (this.treeFetched && tree) {
                // the tree is loaded already so lets process it now :)
                processor(tree);
            }
            return name;
        };
        Workspace.prototype.removeNamedTreePostProcessor = function (name) {
            delete this.treePostProcessors[name];
        };
        Workspace.prototype.maybeMonitorPlugins = function () {
            if (this.treeContainsDomainAndProperties("hawtio", { type: "Registry" })) {
                if (this.pluginRegisterHandle === null) {
                    var callback = angular.bind(this, this.maybeUpdatePlugins);
                    this.pluginRegisterHandle = this.jolokia.register(callback, {
                        type: "read",
                        mbean: HAWTIO_REGISTRY_MBEAN,
                        attribute: "UpdateCounter"
                    });
                }
            }
            else {
                if (this.pluginRegisterHandle !== null) {
                    this.jolokia.unregister(this.pluginRegisterHandle);
                    this.pluginRegisterHandle = null;
                    this.pluginUpdateCounter = null;
                }
            }
            // lets also listen to see if we have a JMX tree watcher
            if (this.treeContainsDomainAndProperties("hawtio", { type: "TreeWatcher" })) {
                if (this.treeWatchRegisterHandle === null) {
                    var callback = angular.bind(this, this.maybeReloadTree);
                    this.treeWatchRegisterHandle = this.jolokia.register(callback, {
                        type: "read",
                        mbean: HAWTIO_TREE_WATCHER_MBEAN,
                        attribute: "Counter"
                    });
                }
            }
        };
        Workspace.prototype.maybeUpdatePlugins = function (response) {
            if (this.pluginUpdateCounter === null) {
                this.pluginUpdateCounter = response.value;
                return;
            }
            if (this.pluginUpdateCounter !== response.value) {
                if (Core.parseBooleanValue(localStorage['autoRefresh'])) {
                    window.location.reload();
                }
            }
        };
        Workspace.prototype.maybeReloadTree = function (response) {
            var _this = this;
            var counter = response.value;
            if (this.treeWatcherCounter === null) {
                this.treeWatcherCounter = counter;
                return;
            }
            if (this.treeWatcherCounter !== counter) {
                this.treeWatcherCounter = counter;
                this.jolokiaList(function (response) { return _this.populateTree({ value: _this.unwindResponseWithRBACCache(response) }); }, { ignoreErrors: true, maxDepth: 8 });
            }
        };
        /**
         * Processes response from jolokia list - if it contains "domains" and "cache" properties
         * @param response
         */
        Workspace.prototype.unwindResponseWithRBACCache = function (response) {
            if (response['domains'] && response['cache']) {
                // post process cached RBAC info
                for (var domainName in response['domains']) {
                    var domainClass = Core.escapeDots(domainName);
                    var domain = response['domains'][domainName];
                    for (var mbeanName in domain) {
                        if (_.isString(domain[mbeanName])) {
                            domain[mbeanName] = response['cache']["" + domain[mbeanName]];
                        }
                    }
                }
                return response['domains'];
            }
            return response;
        };
        Workspace.prototype.populateTree = function (response) {
            var _this = this;
            log.debug("JMX tree has been loaded, data:", response.value);
            this.mbeanTypesToDomain = {};
            this.mbeanServicesToDomain = {};
            this.keyToNodeMap = {};
            var newTree = new Jmx.Folder('MBeans');
            newTree.key = this.rootId;
            var domains = response.value;
            _.forEach(domains, function (domain, domainName) {
                // domain name is displayed in the tree, so let's escape it here
                // Core.escapeHtml() and _.escape() cannot be used, as escaping '"' breaks Camel tree...
                _this.populateDomainFolder(newTree, _this.escapeTagOnly(domainName), domain);
            });
            newTree.sortChildren(true);
            // now lets mark the nodes with no children as lazy loading...
            this.enableLazyLoading(newTree);
            this.tree = newTree;
            var processors = this.treePostProcessors;
            _.forIn(processors, function (processor, key) {
                log.debug("Running tree post processor:", key);
                processor(newTree);
            });
            this.maybeMonitorPlugins();
            this.jmxTreeUpdated();
        };
        Workspace.prototype.setTreeFetched = function () {
            this.treeFetched = true;
            var rootScope = this.$rootScope;
            if (rootScope) {
                Core.$apply(rootScope);
                rootScope.$broadcast(Jmx.TreeEvent.Fetched);
            }
        };
        Workspace.prototype.jmxTreeUpdated = function () {
            var rootScope = this.$rootScope;
            if (rootScope) {
                Core.$apply(rootScope);
                rootScope.$broadcast(Jmx.TreeEvent.Updated);
            }
        };
        Workspace.prototype.initFolder = function (folder, domain, folderNames) {
            folder.domain = domain;
            if (!folder.key) {
                folder.key = this.rootId + this.separator + folderNames.join(this.separator);
            }
            folder.folderNames = folderNames;
            logTree.debug("    folder: domain=" + folder.domain + ", key=" + folder.key);
        };
        Workspace.prototype.populateDomainFolder = function (tree, domainName, domain) {
            var _this = this;
            logTree.debug("JMX tree domain: " + domainName);
            var domainClass = Core.escapeDots(domainName);
            var folder = this.folderGetOrElse(tree, domainName);
            this.initFolder(folder, domainName, [domainName]);
            _.forEach(domain, function (mbean, mbeanName) {
                _this.populateMBeanFolder(folder, domainClass, mbeanName, mbean);
            });
        };
        /**
         * Escape only '<' and '>' as opposed to Core.escapeHtml() and _.escape()
         *
         * @param {string} str string to be escaped
        */
        Workspace.prototype.escapeTagOnly = function (str) {
            var tagChars = {
                "<": "&lt;",
                ">": "&gt;"
            };
            if (!angular.isString(str)) {
                return str;
            }
            var escaped = "";
            for (var i = 0; i < str.length; i++) {
                var c = str.charAt(i);
                escaped += tagChars[c] || c;
            }
            return escaped;
        };
        Workspace.prototype.populateMBeanFolder = function (domainFolder, domainClass, mbeanName, mbean) {
            var _this = this;
            logTree.debug("  JMX tree mbean: " + mbeanName);
            var entries = {};
            var paths = [];
            var typeName = null;
            var serviceName = null;
            mbeanName.split(',').forEach(function (prop) {
                // do not use split('=') as it splits wrong when there is a space in the mbean name
                var kv = _this.splitMBeanProperty(prop);
                var propKey = kv[0];
                // mbean property value is displayed in the tree, so let's escape it here
                // Core.escapeHtml() and _.escape() cannot be used, as escaping '"' breaks Camel tree...
                var propValue = _this.escapeTagOnly(kv[1] || propKey);
                entries[propKey] = propValue;
                var moveToFront = false;
                var lowerKey = propKey.toLowerCase();
                if (lowerKey === "type") {
                    typeName = propValue;
                    // if the type name value already exists in the root node
                    // of the domain then lets move this property around too
                    if (domainFolder.get(propValue)) {
                        moveToFront = true;
                    }
                }
                if (lowerKey === "service") {
                    serviceName = propValue;
                }
                if (moveToFront) {
                    paths.unshift(propValue);
                }
                else {
                    paths.push(propValue);
                }
            });
            var folder = domainFolder;
            var domainName = domainFolder.domain;
            var folderNames = _.clone(domainFolder.folderNames);
            var lastPath = paths.pop();
            paths.forEach(function (path) {
                folder = _this.folderGetOrElse(folder, path);
                if (folder) {
                    folderNames.push(path);
                    _this.configureFolder(folder, domainName, domainClass, folderNames, path);
                }
            });
            if (folder) {
                folder = this.folderGetOrElse(folder, lastPath);
                if (folder) {
                    // lets add the various data into the folder
                    folder.entries = entries;
                    folderNames.push(lastPath);
                    this.configureFolder(folder, domainName, domainClass, folderNames, lastPath);
                    folder.text = Core.trimQuotes(lastPath);
                    folder.objectName = domainName + ":" + mbeanName;
                    folder.mbean = mbean;
                    folder.typeName = typeName;
                    if (serviceName) {
                        this.addFolderByDomain(folder, domainName, serviceName, this.mbeanServicesToDomain);
                    }
                    if (typeName) {
                        this.addFolderByDomain(folder, domainName, typeName, this.mbeanTypesToDomain);
                    }
                }
            }
            else {
                log.info("No folder found for last path: " + lastPath);
            }
        };
        Workspace.prototype.folderGetOrElse = function (folder, name) {
            return folder ? folder.getOrElse(name) : null;
        };
        Workspace.prototype.splitMBeanProperty = function (property) {
            var pos = property.indexOf('=');
            if (pos > 0) {
                return [property.substr(0, pos), property.substr(pos + 1)];
            }
            else {
                return [property, property];
            }
        };
        Workspace.prototype.configureFolder = function (folder, domainName, domainClass, folderNames, path) {
            var _this = this;
            this.initFolder(folder, domainName, _.clone(folderNames));
            this.keyToNodeMap[folder.key] = folder;
            var classes = "";
            var typeKey = _.filter(_.keys(folder.entries), function (key) { return key.toLowerCase().indexOf("type") >= 0; });
            if (typeKey.length) {
                // last path
                _.forEach(typeKey, function (key) {
                    var typeName = folder.entries[key];
                    if (!folder.ancestorHasEntry(key, typeName)) {
                        classes += " " + domainClass + _this.separator + typeName;
                    }
                });
            }
            else {
                // folder
                var kindName = _.last(folderNames);
                if (kindName === path) {
                    kindName += "-folder";
                }
                if (kindName) {
                    classes += " " + domainClass + this.separator + kindName;
                }
            }
            folder.class = Core.escapeTreeCssStyles(classes);
            return folder;
        };
        Workspace.prototype.addFolderByDomain = function (folder, domainName, typeName, owner) {
            var map = owner[typeName];
            if (!map) {
                map = {};
                owner[typeName] = map;
            }
            var value = map[domainName];
            if (!value) {
                map[domainName] = folder;
            }
            else {
                var array = null;
                if (angular.isArray(value)) {
                    array = value;
                }
                else {
                    array = [value];
                    map[domainName] = array;
                }
                array.push(folder);
            }
        };
        Workspace.prototype.enableLazyLoading = function (folder) {
            var _this = this;
            var children = folder.children;
            if (children && children.length) {
                angular.forEach(children, function (child) { return _this.enableLazyLoading(child); });
            }
            else {
                // we have no children so enable lazy loading if we have a custom loader registered
                var lazyFunction = Jmx.findLazyLoadingFunction(this, folder);
                if (lazyFunction) {
                    folder.lazyLoad = true;
                }
                else {
                    folder.icon = 'fa fa-cube';
                }
            }
        };
        /**
         * Returns the hash query argument to append to URL links
         * @method hash
         * @return {String}
         */
        Workspace.prototype.hash = function () {
            var hash = this.$location.search();
            var params = Core.hashToString(hash);
            if (params) {
                return "?" + params;
            }
            return "";
        };
        /**
         * Returns the currently active tab
         * @method getActiveTab
         * @return {Boolean}
         */
        Workspace.prototype.getActiveTab = function () {
            var workspace = this;
            return _.find(this.topLevelTabs, function (tab) {
                if (!angular.isDefined(tab.isActive)) {
                    return workspace.isLinkActive(tab.href());
                }
                else {
                    return tab.isActive(workspace);
                }
            });
        };
        Workspace.prototype.getStrippedPathName = function () {
            var pathName = Core.trimLeading((this.$location.path() || '/'), "#");
            pathName = pathName.replace(/^\//, '');
            return pathName;
        };
        Workspace.prototype.linkContains = function () {
            var words = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                words[_i] = arguments[_i];
            }
            var pathName = this.getStrippedPathName();
            return _.every(words, function (word) { return pathName.indexOf(word) !== 0; });
        };
        /**
         * Returns true if the given link is active. The link can omit the leading # or / if necessary.
         * The query parameters of the URL are ignored in the comparison.
         * @method isLinkActive
         * @param {String} href
         * @return {Boolean} true if the given link is active
         */
        Workspace.prototype.isLinkActive = function (href) {
            // lets trim the leading slash
            var pathName = this.getStrippedPathName();
            var link = Core.trimLeading(href, "#");
            link = link.replace(/^\//, '');
            // strip any query arguments
            var idx = link.indexOf('?');
            if (idx >= 0) {
                link = link.substring(0, idx);
            }
            if (!pathName.length) {
                return link === pathName;
            }
            else {
                return _.startsWith(pathName, link);
            }
        };
        /**
         * Returns true if the given link is active. The link can omit the leading # or / if necessary.
         * The query parameters of the URL are ignored in the comparison.
         * @method isLinkActive
         * @param {String} href
         * @return {Boolean} true if the given link is active
         */
        Workspace.prototype.isLinkPrefixActive = function (href) {
            // lets trim the leading slash
            var pathName = this.getStrippedPathName();
            var link = Core.trimLeading(href, "#");
            link = link.replace(/^\//, '');
            // strip any query arguments
            var idx = link.indexOf('?');
            if (idx >= 0) {
                link = link.substring(0, idx);
            }
            return _.startsWith(pathName, link);
        };
        /**
         * Returns true if the tab query parameter is active or the URL starts with the given path
         * @method isTopTabActive
         * @param {String} path
         * @return {Boolean}
         */
        Workspace.prototype.isTopTabActive = function (path) {
            var tab = this.$location.search()['tab'];
            if (angular.isString(tab)) {
                return _.startsWith(tab, path);
            }
            return this.isLinkActive(path);
        };
        Workspace.prototype.isMainTabActive = function (path) {
            var tab = this.$location.search()['main-tab'];
            if (angular.isString(tab)) {
                return tab === path;
            }
            return false;
        };
        /**
         * Returns the selected mbean name if there is one
         * @method getSelectedMBeanName
         * @return {String}
         */
        Workspace.prototype.getSelectedMBeanName = function () {
            var selection = this.getSelectedMBean();
            if (selection) {
                return selection.objectName;
            }
            return null;
        };
        Workspace.prototype.getSelectedMBean = function () {
            if (this.selection) {
                return this.selection;
            }
            log.debug("Location:", this.$location);
            var nid = this.$location.search()['nid'];
            if (nid && this.tree) {
                var answer = this.tree.findDescendant(function (node) { return nid === node.key; });
                if (!this.selection) {
                    this.selection = answer;
                }
                return answer;
            }
            return null;
        };
        /**
         * Returns true if the path is valid for the current selection
         * @method validSelection
         * @param {String} uri
         * @return {Boolean}
         */
        Workspace.prototype.validSelection = function (uri) {
            // TODO
            return true;
        };
        /**
         * In cases where we have just deleted something we typically want to change
         * the selection to the parent node
         * @method removeAndSelectParentNode
         */
        Workspace.prototype.removeAndSelectParentNode = function () {
            var selection = this.selection;
            if (selection) {
                var parent_1 = selection.parent;
                if (parent_1) {
                    // lets remove the selection from the parent so we don't do any more JMX attribute queries on the children
                    // or include it in table views etc
                    // would be nice to eagerly remove the tree node too?
                    var idx = parent_1.children.indexOf(selection);
                    if (idx < 0) {
                        idx = _.findIndex(parent_1.children, function (n) { return n.key === selection.key; });
                    }
                    if (idx >= 0) {
                        parent_1.children.splice(idx, 1);
                    }
                    this.updateSelectionNode(parent_1);
                }
            }
        };
        Workspace.prototype.selectParentNode = function () {
            var selection = this.selection;
            if (selection) {
                var parent_2 = selection.parent;
                if (parent_2) {
                    this.updateSelectionNode(parent_2);
                }
            }
        };
        /**
         * Returns the view configuration key for the kind of selection
         * for example based on the domain and the node type
         * @method selectionViewConfigKey
         * @return {String}
         */
        Workspace.prototype.selectionViewConfigKey = function () {
            return this.selectionConfigKey("view/");
        };
        /**
         * Returns a configuration key for a node which is usually of the form
         * domain/typeName or for folders with no type, domain/name/folder
         * @method selectionConfigKey
         * @param {String} prefix
         * @return {String}
         */
        Workspace.prototype.selectionConfigKey = function (prefix) {
            if (prefix === void 0) { prefix = ""; }
            var key = null;
            var selection = this.selection;
            if (selection) {
                // lets make a unique string for the kind of select
                key = prefix + selection.domain;
                var typeName = selection.typeName;
                if (!typeName) {
                    typeName = selection.text;
                }
                key += "/" + typeName;
                if (selection.isFolder()) {
                    key += "/folder";
                }
            }
            return key;
        };
        Workspace.prototype.moveIfViewInvalid = function () {
            var workspace = this;
            var uri = Core.trimLeading(this.$location.path(), "/");
            if (this.selection) {
                var key = this.selectionViewConfigKey();
                if (this.validSelection(uri)) {
                    // lets remember the previous selection
                    this.setLocalStorage(key, uri);
                    return false;
                }
                else {
                    log.info("the uri '" + uri + "' is not valid for this selection");
                    // lets look up the previous preferred value for this type
                    var defaultPath_1 = this.getLocalStorage(key);
                    if (!defaultPath_1 || !this.validSelection(defaultPath_1)) {
                        // lets find the first path we can find which is valid
                        defaultPath_1 = null;
                        angular.forEach(this.subLevelTabs, function (tab) {
                            var fn = tab.isValid;
                            if (!defaultPath_1 && tab.href && angular.isDefined(fn) && fn(workspace)) {
                                defaultPath_1 = tab.href();
                            }
                        });
                    }
                    if (!defaultPath_1) {
                        defaultPath_1 = "#/jmx/help";
                    }
                    log.info("moving the URL to be", defaultPath_1);
                    if (_.startsWith(defaultPath_1, "#")) {
                        defaultPath_1 = defaultPath_1.substring(1);
                    }
                    this.$location.path(defaultPath_1);
                    return true;
                }
            }
            else {
                return false;
            }
        };
        Workspace.prototype.updateSelectionNode = function (node) {
            this.selection = node;
            var key = null;
            if (node) {
                key = node.key;
            }
            if (key) {
                var $location = this.$location;
                var q = $location.search();
                q['nid'] = key;
                $location.search(q);
            }
            // Broadcast an event so other parts of the UI can update accordingly
            this.broadcastSelectionNode();
        };
        Workspace.prototype.broadcastSelectionNode = function () {
            if (this.selection) {
                this.$rootScope.$broadcast(Jmx.TreeEvent.NodeSelected, this.selection);
            }
        };
        Workspace.prototype.matchesProperties = function (entries, properties) {
            if (!entries)
                return false;
            for (var key in properties) {
                var value = properties[key];
                if (!value || entries[key] !== value) {
                    return false;
                }
            }
            return true;
        };
        Workspace.prototype.hasInvokeRightsForName = function (objectName) {
            var methods = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                methods[_i - 1] = arguments[_i];
            }
            // allow invoke by default, same as in hasInvokeRight() below
            if (!objectName) {
                return true;
            }
            var mbean = Core.parseMBean(objectName);
            if (!mbean) {
                log.debug("Failed to parse mbean name", objectName);
                return true;
            }
            var mbeanFolder = this.findMBeanWithProperties(mbean.domain, mbean.attributes);
            if (!mbeanFolder) {
                log.debug("Failed to find mbean folder with name", objectName);
                return true;
            }
            return this.hasInvokeRights.apply(this, [mbeanFolder].concat(methods));
        };
        Workspace.prototype.hasInvokeRights = function (selection) {
            var _this = this;
            var methods = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                methods[_i - 1] = arguments[_i];
            }
            if (!selection) {
                return true;
            }
            var selectionFolder = selection;
            var mbean = selectionFolder.mbean;
            if (!mbean) {
                return true;
            }
            var canInvoke = true;
            if (angular.isDefined(mbean.canInvoke)) {
                canInvoke = mbean.canInvoke;
            }
            if (canInvoke && methods && methods.length > 0) {
                var opsByString_1 = mbean['opByString'];
                var ops_1 = mbean['op'];
                if (opsByString_1 && ops_1) {
                    methods.forEach(function (method) {
                        if (!canInvoke) {
                            return;
                        }
                        var op = null;
                        if (_.endsWith(method, ')')) {
                            op = opsByString_1[method];
                        }
                        else {
                            op = ops_1[method];
                        }
                        if (!op) {
                            log.debug("Could not find method:", method, " to check permissions, skipping");
                            return;
                        }
                        canInvoke = _this.resolveCanInvoke(op);
                    });
                }
            }
            return canInvoke;
        };
        Workspace.prototype.resolveCanInvoke = function (op) {
            // for single method
            if (!angular.isArray(op)) {
                return angular.isDefined(op.canInvoke) ? op.canInvoke : true;
            }
            // for overloaded methods
            // returns true only if all overloaded methods can be invoked (i.e. canInvoke=true)
            var cantInvoke = _.find(op, function (o) {
                return angular.isDefined(o.canInvoke) && !o.canInvoke;
            });
            return !angular.isDefined(cantInvoke);
        };
        Workspace.prototype.treeContainsDomainAndProperties = function (domainName, properties) {
            var _this = this;
            if (properties === void 0) { properties = null; }
            var workspace = this;
            var tree = workspace.tree;
            if (!tree) {
                return false;
            }
            var folder = tree.get(domainName);
            if (!folder) {
                return false;
            }
            if (properties) {
                var children = folder.children || [];
                var checkProperties_1 = function (node) {
                    if (!_this.matchesProperties(node.entries, properties)) {
                        if (node.domain === domainName && node.children && node.children.length > 0) {
                            return node.children.some(checkProperties_1);
                        }
                        else {
                            return false;
                        }
                    }
                    else {
                        return true;
                    }
                };
                return children.some(checkProperties_1);
            }
            return true;
        };
        Workspace.prototype.matches = function (folder, properties, propertiesCount) {
            if (!folder) {
                return false;
            }
            var entries = folder.entries;
            if (properties) {
                if (!entries)
                    return false;
                for (var key in properties) {
                    var entryValue = entries[key];
                    var propertyValue = properties[key];
                    if (!propertyValue) {
                        return false;
                    }
                    else if (_.startsWith(propertyValue, '*')) {
                        if (!_.endsWith(entryValue, propertyValue.substr(1))) {
                            return false;
                        }
                    }
                    else if (_.endsWith(propertyValue, '*')) {
                        if (!_.startsWith(entryValue, propertyValue.substr(0, propertyValue.length - 1))) {
                            return false;
                        }
                    }
                    else if (entryValue !== propertyValue) {
                        return false;
                    }
                }
            }
            if (propertiesCount) {
                return entries && Object.keys(entries).length === propertiesCount;
            }
            return true;
        };
        // only display stuff if we have an mbean with the given properties
        Workspace.prototype.hasDomainAndProperties = function (domainName, properties, propertiesCount) {
            if (properties === void 0) { properties = null; }
            if (propertiesCount === void 0) { propertiesCount = null; }
            var node = this.selection;
            if (node) {
                return this.matches(node, properties, propertiesCount) && node.domain === domainName;
            }
            return false;
        };
        // only display stuff if we have an mbean with the given properties
        Workspace.prototype.findMBeanWithProperties = function (domainName, properties, propertiesCount) {
            if (properties === void 0) { properties = null; }
            if (propertiesCount === void 0) { propertiesCount = null; }
            var tree = this.tree;
            if (tree) {
                return this.findChildMBeanWithProperties(tree.get(domainName), properties, propertiesCount);
            }
            return null;
        };
        Workspace.prototype.findChildMBeanWithProperties = function (folder, properties, propertiesCount) {
            var _this = this;
            if (properties === void 0) { properties = null; }
            if (propertiesCount === void 0) { propertiesCount = null; }
            var workspace = this;
            if (folder) {
                var children = folder.children;
                if (children) {
                    var answer = _.find(children, function (node) { return _this.matches(node, properties, propertiesCount); });
                    if (answer) {
                        return answer;
                    }
                    answer = _.find(children.map(function (node) { return workspace.findChildMBeanWithProperties(node, properties, propertiesCount); }), function (node) { return node; });
                    if (answer) {
                        return answer;
                    }
                }
            }
            return null;
        };
        Workspace.prototype.selectionHasDomainAndLastFolderName = function (objectName, lastName) {
            var lastNameLower = (lastName || "").toLowerCase();
            function isName(name) {
                return (name || "").toLowerCase() === lastNameLower;
            }
            var node = this.selection;
            if (node) {
                if (objectName === node.domain) {
                    var folders = node.folderNames;
                    if (folders) {
                        var last = _.last(folders);
                        return (isName(last) || isName(node.text)) && node.isFolder() && !node.objectName;
                    }
                }
            }
            return false;
        };
        Workspace.prototype.selectionHasDomain = function (domainName) {
            var node = this.selection;
            if (node) {
                return domainName === node.domain;
            }
            return false;
        };
        Workspace.prototype.selectionHasDomainAndType = function (objectName, typeName) {
            var node = this.selection;
            if (node) {
                return objectName === node.domain && typeName === node.typeName;
            }
            return false;
        };
        /**
         * Returns true if this workspace has any mbeans at all
         */
        Workspace.prototype.hasMBeans = function () {
            var answer = false;
            var tree = this.tree;
            if (tree) {
                var children = tree.children;
                if (_.isArray(children) && children.length > 0) {
                    answer = true;
                }
            }
            return answer;
        };
        Workspace.prototype.hasFabricMBean = function () {
            return this.hasDomainAndProperties('io.fabric8', { type: 'Fabric' });
        };
        Workspace.prototype.isFabricFolder = function () {
            return this.hasDomainAndProperties('io.fabric8');
        };
        Workspace.prototype.isCamelContext = function () {
            return this.hasDomainAndProperties('org.apache.camel', { type: 'context' });
        };
        Workspace.prototype.isCamelFolder = function () {
            return this.hasDomainAndProperties('org.apache.camel');
        };
        Workspace.prototype.isEndpointsFolder = function () {
            return this.selectionHasDomainAndLastFolderName('org.apache.camel', 'endpoints');
        };
        Workspace.prototype.isEndpoint = function () {
            return this.hasDomainAndProperties('org.apache.camel', { type: 'endpoints' });
        };
        Workspace.prototype.isRoutesFolder = function () {
            return this.selectionHasDomainAndLastFolderName('org.apache.camel', 'routes');
        };
        Workspace.prototype.isRoute = function () {
            return this.hasDomainAndProperties('org.apache.camel', { type: 'routes' });
        };
        Workspace.prototype.isComponentsFolder = function () {
            return this.selectionHasDomainAndLastFolderName('org.apache.camel', 'components');
        };
        Workspace.prototype.isComponent = function () {
            return this.hasDomainAndProperties('org.apache.camel', { type: 'components' });
        };
        Workspace.prototype.isDataformatsFolder = function () {
            return this.selectionHasDomainAndLastFolderName('org.apache.camel', 'dataformats');
        };
        Workspace.prototype.isDataformat = function () {
            return this.hasDomainAndProperties('org.apache.camel', { type: 'dataformats' });
        };
        Workspace.prototype.isOsgiFolder = function () {
            return this.hasDomainAndProperties('osgi.core');
        };
        Workspace.prototype.isKarafFolder = function () {
            return this.hasDomainAndProperties('org.apache.karaf');
        };
        Workspace.prototype.isOsgiCompendiumFolder = function () {
            return this.hasDomainAndProperties('osgi.compendium');
        };
        return Workspace;
    }());
    Jmx.Workspace = Workspace;
})(Jmx || (Jmx = {}));
/// <reference path="../workspace.ts"/>
var Jmx;
(function (Jmx) {
    var TreeService = /** @class */ (function () {
        TreeService.$inject = ["$rootScope", "$q", "workspace"];
        function TreeService($rootScope, $q, workspace) {
            'ngInject';
            this.$rootScope = $rootScope;
            this.$q = $q;
            this.workspace = workspace;
        }
        TreeService.prototype.treeContainsDomainAndProperties = function (domainName, properties) {
            var _this = this;
            if (properties === void 0) { properties = null; }
            return this.runWhenTreeReady(function () { return _this.workspace.treeContainsDomainAndProperties(domainName, properties); });
        };
        TreeService.prototype.findMBeanWithProperties = function (domainName, properties, propertiesCount) {
            var _this = this;
            if (properties === void 0) { properties = null; }
            if (propertiesCount === void 0) { propertiesCount = null; }
            return this.runWhenTreeReady(function () { return _this.workspace.findMBeanWithProperties(domainName, properties, propertiesCount); });
        };
        TreeService.prototype.getSelectedMBean = function () {
            var _this = this;
            return this.runWhenTreeSelectionReady(function () { return _this.workspace.getSelectedMBean(); });
        };
        TreeService.prototype.getSelectedMBeanName = function () {
            var _this = this;
            return this.runWhenTreeSelectionReady(function () { return _this.workspace.getSelectedMBeanName(); });
        };
        TreeService.prototype.runWhenTreeReady = function (fn) {
            var _this = this;
            return this.$q(function (resolve, reject) {
                if (_this.workspace.treeFetched) {
                    resolve(fn());
                }
                else {
                    var unsubscribe_1 = _this.$rootScope.$on(Jmx.TreeEvent.Updated, function () {
                        unsubscribe_1();
                        resolve(fn());
                    });
                }
            });
        };
        TreeService.prototype.runWhenTreeSelectionReady = function (fn) {
            var _this = this;
            return this.$q(function (resolve, reject) {
                if (_this.workspace.selection) {
                    resolve(fn());
                }
                else {
                    var unsubscribe_2 = _this.$rootScope.$on(Jmx.TreeEvent.NodeSelected, function () {
                        unsubscribe_2();
                        resolve(fn());
                    });
                }
            });
        };
        return TreeService;
    }());
    Jmx.TreeService = TreeService;
})(Jmx || (Jmx = {}));
/// <reference path="../../jmx/ts/workspace.ts"/>
/// <reference path="../../jmx/ts/tree/tree.service.ts"/>
var Diagnostics;
(function (Diagnostics) {
    var DiagnosticsService = /** @class */ (function () {
        DiagnosticsService.$inject = ["workspace", "configManager"];
        function DiagnosticsService(workspace, configManager) {
            'ngInject';
            this.workspace = workspace;
            this.configManager = configManager;
        }
        DiagnosticsService.prototype.getTabs = function () {
            var tabs = [];
            if (this.hasDiagnosticFunction('jfrCheck')) {
                tabs.push(new Nav.HawtioTab('Flight Recorder', '/diagnostics/jfr'));
            }
            if (this.hasDiagnosticFunction('gcClassHistogram')) {
                tabs.push(new Nav.HawtioTab('Class Histogram', '/diagnostics/heap'));
            }
            if (this.hasHotspotDiagnostic()) {
                tabs.push(new Nav.HawtioTab('Hotspot Diagnostic', '/diagnostics/flags'));
            }
            return tabs;
        };
        DiagnosticsService.prototype.hasHotspotDiagnostic = function () {
            return this.workspace.treeContainsDomainAndProperties('com.sun.management', { type: 'HotSpotDiagnostic' });
        };
        DiagnosticsService.prototype.hasDiagnosticFunction = function (operation) {
            var diagnostics = this.workspace.findMBeanWithProperties('com.sun.management', { type: 'DiagnosticCommand' });
            return diagnostics && diagnostics.mbean && diagnostics.mbean.op && !!diagnostics.mbean.op[operation];
        };
        DiagnosticsService.prototype.findMyPid = function (title) {
            //snatch PID from window title
            var regex = /pid:(\d+)/g;
            var pid = regex.exec(title);
            if (pid && pid[1]) {
                return pid[1];
            }
            else {
                return null;
            }
        };
        return DiagnosticsService;
    }());
    Diagnostics.DiagnosticsService = DiagnosticsService;
})(Diagnostics || (Diagnostics = {}));
/// <reference path="./diagnostics.service.ts"/>
var Diagnostics;
(function (Diagnostics) {
    DiagnosticsHeapController.$inject = ["$scope", "jolokia", "diagnosticsService"];
    function DiagnosticsHeapController($scope, jolokia, diagnosticsService) {
        'ngInject';
        var instanceCounts;
        var byteCounts;
        $scope.items = [];
        $scope.loading = false;
        $scope.lastLoaded = null;
        $scope.toolbarConfig = {
            actionsConfig: {
                actionsInclude: true
            },
            isTableView: true
        };
        $scope.tableConfig = {
            selectionMatchProp: 'name',
            showCheckboxes: false
        };
        $scope.tableDtOptions = {
            order: [[1, "desc"]]
        };
        $scope.pageConfig = {
            pageSize: 20
        };
        $scope.tableColumns = [
            {
                header: 'Class Name',
                itemField: 'name'
            },
            {
                header: 'Bytes',
                itemField: 'bytes'
            },
            {
                header: 'Bytes Delta',
                itemField: 'deltaBytes'
            },
            {
                header: 'Instances',
                itemField: 'count'
            },
            {
                header: 'Instances Delta',
                itemField: 'deltaCount'
            }
        ];
        $scope.loadClassStats = function () {
            $scope.loading = true;
            Core.$apply($scope);
            jolokia.request({
                type: 'exec',
                mbean: 'com.sun.management:type=DiagnosticCommand',
                operation: 'gcClassHistogram([Ljava.lang.String;)',
                arguments: ['']
            }, {
                success: render,
                error: function (response) {
                    Diagnostics.log.error('Failed to get class histogram: ' + response.error);
                    $scope.loading = false;
                    Core.$apply($scope);
                }
            });
        };
        function render(response) {
            var classHistogram = response.value;
            var lines = response.value.split('\n');
            var parsed = [];
            var classCounts = {};
            var bytesCounts = {};
            for (var i = 0; i < lines.length; i++) {
                var values = lines[i].match(/\s*(\d+):\s*(\d+)\s*(\d+)\s*(\S+)\s*/);
                if (values && values.length >= 5) {
                    var className = translateJniName(values[4]);
                    var count = values[2];
                    var bytes = values[3];
                    var entry = {
                        count: count,
                        bytes: bytes,
                        name: className,
                        deltaCount: findDelta(instanceCounts, className, count),
                        deltaBytes: findDelta(byteCounts, className, bytes)
                    };
                    parsed.push(entry);
                    classCounts[className] = count;
                    bytesCounts[className] = bytes;
                }
            }
            $scope.items = parsed;
            $scope.lastLoaded = Date.now();
            instanceCounts = classCounts;
            byteCounts = bytesCounts;
            Core.$apply($scope);
            setTimeout(function () {
                $scope.loading = false;
                Core.$apply($scope);
            });
        }
        function findDelta(oldCounts, className, newValue) {
            if (!oldCounts) {
                return '';
            }
            var oldValue = oldCounts[className];
            if (oldValue) {
                return oldValue - newValue;
            }
            else {
                return newValue;
            }
        }
        function translateJniName(name) {
            if (name.length == 1) {
                switch (name.charAt(0)) {
                    case 'I':
                        return 'int';
                    case 'S':
                        return 'short';
                    case 'C':
                        return 'char';
                    case 'Z':
                        return 'boolean';
                    case 'D':
                        return 'double';
                    case 'F':
                        return 'float';
                    case 'J':
                        return 'long';
                    case 'B':
                        return 'byte';
                }
            }
            else {
                switch (name.charAt(0)) {
                    case '[':
                        return translateJniName(name.substring(1)) + '[]';
                    case 'L':
                        if (name.endsWith(';')) {
                            return translateJniName(name.substring(1, name.indexOf(';')));
                        }
                    default:
                        return name;
                }
            }
        }
    }
    Diagnostics.DiagnosticsHeapController = DiagnosticsHeapController;
})(Diagnostics || (Diagnostics = {}));
/// <reference path="diagnostics.service.ts"/>
var Diagnostics;
(function (Diagnostics) {
    DiagnosticsJfrController.$inject = ["$scope", "$location", "workspace", "jolokia", "localStorage", "diagnosticsService"];
    function splitResponse(response) {
        return response.match(/Dumped recording "(.+)",(.+) written to:\r?\n\r?\n(.+)/);
    }
    function buildStartParams(jfrSettings) {
        var params = [];
        if (jfrSettings.name && jfrSettings.name.length > 0) {
            params.push('name="' + jfrSettings.name + '"');
        }
        if (jfrSettings.filename && jfrSettings.filename.length > 0) {
            params.push('filename="' + jfrSettings.filename + '"');
        }
        params.push('dumponexit=' + jfrSettings.dumpOnExit);
        if (jfrSettings.limitType != 'unlimited') {
            params.push(jfrSettings.limitType + '=' + jfrSettings.limitValue);
        }
        return params;
    }
    function buildDumpParams(jfrSettings) {
        return [
            'filename="' + jfrSettings.filename + '"',
            'name="' + jfrSettings.name + '"'
        ];
    }
    function DiagnosticsJfrController($scope, $location, workspace, jolokia, localStorage, diagnosticsService) {
        'ngInject';
        $scope.forms = {};
        $scope.pid = diagnosticsService.findMyPid($scope.pageTitle);
        $scope.recordings = [];
        $scope.settingsVisible = false;
        $scope.jfrSettings = {
            limitType: 'unlimited',
            limitValue: '',
            name: '',
            dumpOnExit: true,
            recordingNumber: '',
            filename: ''
        };
        $scope.formConfig = {
            properties: {
                name: {
                    type: "java.lang.String",
                    tooltip: "Name for this connection",
                    "input-attributes": {
                        "placeholder": "Recording name (optional)..."
                    }
                },
                limitType: {
                    type: "java.lang.String",
                    tooltip: "Duration if any",
                    enum: ['unlimited', 'duration', 'maxsize']
                },
                limitValue: {
                    type: "java.lang.String",
                    tooltip: "Limit value. duration: [val]s/m/h, maxsize: [val]kB/MB/GB",
                    required: false,
                    "input-attributes": {
                        "ng-show": "jfrSettings.limitType != 'unlimited'"
                    }
                },
                dumpOnExit: {
                    type: "java.lang.Boolean",
                    tooltip: "Automatically dump recording on VM exit"
                },
                filename: {
                    type: "java.lang.String",
                    tooltip: "Filename",
                    "input-attributes": {
                        "placeholder": "Specify file name *.jfr (optional)..."
                    }
                },
            }
        };
        $scope.unlock = function () {
            executeDiagnosticFunction('vmUnlockCommercialFeatures()', 'VM.unlock_commercial_features', [], null);
        };
        $scope.startRecording = function () {
            if ($scope.isRecording) { //this means that there is a stopped recording, clear state before starting the next
                $scope.jfrSettings.name = null;
                $scope.jfrSettings.filename = null;
            }
            executeDiagnosticFunction('jfrStart([Ljava.lang.String;)', 'JFR.start', [buildStartParams($scope.jfrSettings)], null);
        };
        $scope.dumpRecording = function () {
            executeDiagnosticFunction('jfrDump([Ljava.lang.String;)', 'JFR.dump', [buildDumpParams($scope.jfrSettings)], function (response) {
                var matches = splitResponse(response);
                Diagnostics.log.debug("response: " + response
                    + " split: " + matches + "split2: "
                    + matches);
                if (matches) {
                    var recordingData = {
                        number: matches[1],
                        size: matches[2],
                        file: matches[3],
                        time: Date.now()
                    };
                    Diagnostics.log.debug("data: "
                        + recordingData);
                    addRecording(recordingData, $scope.recordings);
                }
            });
        };
        $scope.closeMessageForGood = function (key) {
            localStorage[key] = "false";
        };
        $scope.isMessageVisible = function (key) {
            return localStorage[key] !== "false";
        };
        $scope.stopRecording = function () {
            var name = $scope.jfrSettings.name;
            $scope.jfrSettings.filename = '';
            $scope.jfrSettings.name = '';
            executeDiagnosticFunction('jfrStop([Ljava.lang.String;)', 'JFR.stop', ['name="' + name + '"'], null);
        };
        $scope.toggleSettingsVisible = function () {
            $scope.settingsVisible = !$scope.settingsVisible;
            Core.$apply($scope);
        };
        Core.register(jolokia, $scope, [{
                type: 'exec',
                operation: 'jfrCheck([Ljava.lang.String;)',
                mbean: 'com.sun.management:type=DiagnosticCommand',
                arguments: ['']
            }], Core.onSuccess(render));
        function render(response) {
            var statusString = response.value;
            $scope.jfrEnabled = statusString.indexOf("not enabled") == -1;
            $scope.isRunning = statusString.indexOf("(running)") > -1;
            $scope.isRecording = $scope.isRunning || statusString.indexOf("(stopped)") > -1;
            if ((statusString.indexOf("Use JFR.") > -1 || statusString
                .indexOf("Use VM.") > -1)
                && $scope.pid) {
                statusString = statusString.replace("Use ", "Use command line: jcmd " + $scope.pid + " ");
            }
            $scope.jfrStatus = statusString;
            if ($scope.isRecording) {
                var regex = /recording=(\d+) name="(.+?)"/g;
                if ($scope.isRunning) { //if there are several recordings (some stopped), make sure we parse the running one
                    regex = /recording=(\d+) name="(.+?)".+?\(running\)/g;
                }
                var parsed = regex.exec(statusString);
                $scope.jfrSettings.recordingNumber = parsed[1];
                $scope.jfrSettings.name = parsed[2];
                var parsedFilename = statusString.match(/filename="(.+)"/);
                if (parsedFilename && parsedFilename[1]) {
                    $scope.jfrSettings.filename = parsedFilename[1];
                }
                else {
                    $scope.jfrSettings.filename = 'recording' + parsed[1] + '.jfr';
                }
            }
            Core.$apply($scope);
        }
        function addRecording(recording, recordings) {
            for (var i = 0; i < recordings.length; i++) {
                if (recordings[i].file === recording.file) {
                    recordings[i] = recording;
                    return;
                }
            }
            recordings.push(recording);
        }
        function showArguments(arguments) {
            var result = '';
            var first = true;
            for (var i = 0; i < arguments.length; i++) {
                if (first) {
                    first = false;
                }
                else {
                    result += ',';
                }
                result += arguments[i];
            }
            return result;
        }
        function executeDiagnosticFunction(operation, jcmd, arguments, callback) {
            Diagnostics.log.debug(Date.now() + " Invoking operation "
                + operation + " with arguments" + arguments + " settings: " + JSON.stringify($scope.jfrSettings));
            $scope.jcmd = 'jcmd ' + $scope.pid + ' ' + jcmd + ' ' + showArguments(arguments);
            jolokia.request([{
                    type: "exec",
                    operation: operation,
                    mbean: 'com.sun.management:type=DiagnosticCommand',
                    arguments: arguments
                }, {
                    type: 'exec',
                    operation: 'jfrCheck([Ljava.lang.String;)',
                    mbean: 'com.sun.management:type=DiagnosticCommand',
                    arguments: ['']
                }], Core.onSuccess(function (response) {
                Diagnostics.log.debug("Diagnostic Operation "
                    + operation + " was successful" + response.value);
                if (response.request.operation.indexOf("jfrCheck") > -1) {
                    render(response);
                }
                else {
                    if (callback) {
                        callback(response.value);
                    }
                    Core.$apply($scope);
                }
            }, {
                error: function (response) {
                    Diagnostics.log.warn("Diagnostic Operation "
                        + operation + " failed", response);
                }
            }));
        }
    }
    Diagnostics.DiagnosticsJfrController = DiagnosticsJfrController;
})(Diagnostics || (Diagnostics = {}));
/// <reference path="diagnostics.service.ts"/>
var Diagnostics;
(function (Diagnostics) {
    var DiagnosticsController = /** @class */ (function () {
        DiagnosticsController.$inject = ["diagnosticsService"];
        function DiagnosticsController(diagnosticsService) {
            'ngInject';
            this.diagnosticsService = diagnosticsService;
        }
        DiagnosticsController.prototype.$onInit = function () {
            this.tabs = this.diagnosticsService.getTabs();
        };
        return DiagnosticsController;
    }());
    Diagnostics.DiagnosticsController = DiagnosticsController;
    Diagnostics.diagnosticsComponent = {
        template: '<hawtio-tabs-layout tabs="$ctrl.tabs"></hawtio-tabs-layout>',
        controller: DiagnosticsController
    };
})(Diagnostics || (Diagnostics = {}));
/// <reference path="../../jmx/ts/workspace.ts"/>
/// <reference path="diagnostics.service.ts"/>
var Diagnostics;
(function (Diagnostics) {
    configureRoutes.$inject = ["$routeProvider"];
    configureHelp.$inject = ["helpRegistry"];
    configureMainNav.$inject = ["mainNavService", "diagnosticsService"];
    function configureRoutes($routeProvider) {
        'ngInject';
        $routeProvider
            .when('/diagnostics/jfr', { templateUrl: 'plugins/diagnostics/html/jfr.html' })
            .when('/diagnostics/heap', { templateUrl: 'plugins/diagnostics/html/heap.html' })
            .when('/diagnostics/flags', { templateUrl: 'plugins/diagnostics/html/flags.html' });
    }
    Diagnostics.configureRoutes = configureRoutes;
    function configureHelp(helpRegistry) {
        'ngInject';
        helpRegistry.addUserDoc('diagnostics', 'plugins/diagnostics/doc/help.md');
    }
    Diagnostics.configureHelp = configureHelp;
    function configureMainNav(mainNavService, diagnosticsService) {
        'ngInject';
        mainNavService.addItem({
            title: 'Diagnostics',
            basePath: '/diagnostics',
            template: '<diagnostics></diagnostics>',
            isValid: function () { return diagnosticsService.getTabs().length > 0; },
            rank: -1
        });
    }
    Diagnostics.configureMainNav = configureMainNav;
})(Diagnostics || (Diagnostics = {}));
/// <reference path="diagnostics.config.ts"/>
/// <reference path="diagnostics.component.ts"/>
/// <reference path="diagnostics-jfr.controller.ts"/>
/// <reference path="diagnostics-heap.controller.ts"/>
/// <reference path="diagnostics-flags.controller.ts"/>
/// <reference path="diagnostics.service.ts"/>
var Diagnostics;
(function (Diagnostics) {
    var pluginName = 'hawtio-jmx-diagnostics';
    Diagnostics.log = Logger.get(pluginName);
    Diagnostics._module = angular
        .module(pluginName, [])
        .config(Diagnostics.configureRoutes)
        .run(Diagnostics.configureHelp)
        .run(Diagnostics.configureMainNav)
        .component("diagnostics", Diagnostics.diagnosticsComponent)
        .controller("DiagnosticsJfrController", Diagnostics.DiagnosticsJfrController)
        .controller("DiagnosticsHeapController", Diagnostics.DiagnosticsHeapController)
        .controller("DiagnosticsFlagsController", Diagnostics.DiagnosticsFlagsController)
        .service('diagnosticsService', Diagnostics.DiagnosticsService);
    hawtioPluginLoader.addModule(pluginName);
})(Diagnostics || (Diagnostics = {}));
// TODO: should be move to Jmx
var Core;
(function (Core) {
    function scopeStoreJolokiaHandle($scope, jolokia, jolokiaHandle) {
        // TODO do we even need to store the jolokiaHandle in the scope?
        if (jolokiaHandle) {
            $scope.$on('$destroy', function () {
                closeHandle($scope, jolokia);
            });
            $scope.jolokiaHandle = jolokiaHandle;
        }
    }
    Core.scopeStoreJolokiaHandle = scopeStoreJolokiaHandle;
    function closeHandle($scope, jolokia) {
        var jolokiaHandle = $scope.jolokiaHandle;
        if (jolokiaHandle) {
            //console.log('Closing the handle ' + jolokiaHandle);
            jolokia.unregister(jolokiaHandle);
            $scope.jolokiaHandle = null;
        }
    }
    Core.closeHandle = closeHandle;
    /**
     * Pass in null for the success function to switch to sync mode
     *
     * @method onSuccess
     * @static
     * @param {Function} Success callback function
     * @param {Object} Options object to pass on to Jolokia request
     * @return {Object} initialized options object
     */
    function onSuccess(fn, options) {
        if (options === void 0) { options = {}; }
        options['mimeType'] = 'application/json';
        if (!_.isUndefined(fn)) {
            options['success'] = fn;
        }
        if (!options['method']) {
            options['method'] = "POST";
        }
        // the default (unsorted) order is important for Karaf runtime
        options['canonicalNaming'] = false;
        options['canonicalProperties'] = false;
        if (!options['error']) {
            options['error'] = function (response) { return defaultJolokiaErrorHandler(response, options); };
        }
        return options;
    }
    Core.onSuccess = onSuccess;
    /**
     * The default error handler which logs errors either using debug or log level logging based on the silent setting
     * @param response the response from a jolokia request
     */
    function defaultJolokiaErrorHandler(response, options) {
        if (options === void 0) { options = {}; }
        var operation = Core.pathGet(response, ['request', 'operation']) || "unknown";
        var silent = options['silent'];
        var stacktrace = response.stacktrace;
        if (silent || isIgnorableException(response)) {
            Core.log.debug("Operation", operation, "failed due to:", response['error']);
        }
        else {
            Core.log.warn("Operation", operation, "failed due to:", response['error']);
        }
    }
    Core.defaultJolokiaErrorHandler = defaultJolokiaErrorHandler;
    /**
     * Checks if it's an error that can happen on timing issues such as its been removed or if we run against older containers
     * @param {Object} response the error response from a jolokia request
     */
    function isIgnorableException(response) {
        var isNotFound = function (target) {
            return target.indexOf("InstanceNotFoundException") >= 0
                || target.indexOf("AttributeNotFoundException") >= 0
                || target.indexOf("IllegalArgumentException: No operation") >= 0;
        };
        return (response.stacktrace && isNotFound(response.stacktrace)) || (response.error && isNotFound(response.error));
    }
    /**
     * Logs any failed operation and stack traces
     */
    function logJolokiaStackTrace(response) {
        var stacktrace = response.stacktrace;
        if (stacktrace) {
            var operation = Core.pathGet(response, ['request', 'operation']) || "unknown";
            Core.log.info("Operation", operation, "failed due to:", response['error']);
        }
    }
    Core.logJolokiaStackTrace = logJolokiaStackTrace;
    /**
     * Applies the Jolokia escaping rules to the mbean name.
     * See: http://www.jolokia.org/reference/html/protocol.html#escape-rules
     *
     * @param {string} mbean the mbean
     * @returns {string}
     */
    function applyJolokiaEscapeRules(mbean) {
        return mbean
            .replace(/!/g, '!!')
            .replace(/\//g, '!/')
            .replace(/"/g, '!"');
    }
    /**
     * Escapes the mbean for Jolokia GET requests.
     *
     * @param {string} mbean the mbean
     * @returns {string}
     */
    function escapeMBean(mbean) {
        return encodeURI(applyJolokiaEscapeRules(mbean));
    }
    Core.escapeMBean = escapeMBean;
    /**
     * Escapes the mbean as a path for Jolokia POST "list" requests.
     * See: https://jolokia.org/reference/html/protocol.html#list
     *
     * @param {string} mbean the mbean
     * @returns {string}
     */
    function escapeMBeanPath(mbean) {
        return applyJolokiaEscapeRules(mbean).replace(':', '/');
    }
    Core.escapeMBeanPath = escapeMBeanPath;
    function parseMBean(mbean) {
        var answer = {};
        var parts = mbean.split(":");
        if (parts.length > 1) {
            answer['domain'] = _.first(parts);
            parts = _.without(parts, _.first(parts));
            parts = parts.join(":");
            answer['attributes'] = {};
            var nameValues = parts.split(",");
            nameValues.forEach(function (str) {
                var nameValue = str.split('=');
                var name = _.first(nameValue).trim();
                nameValue = _.without(nameValue, _.first(nameValue));
                answer['attributes'][name] = nameValue.join('=').trim();
            });
        }
        return answer;
    }
    Core.parseMBean = parseMBean;
    /**
     * Register a JMX operation to poll for changes, only
     * calls back when a change occurs
     *
     * @param jolokia
     * @param scope
     * @param arguments
     * @param callback
     * @param options
     * @returns Object
     */
    function registerForChanges(jolokia, $scope, arguments, callback, options) {
        var decorated = {
            responseJson: '',
            success: function (response) {
                var json = angular.toJson(response.value);
                if (decorated.responseJson !== json) {
                    decorated.responseJson = json;
                    callback(response);
                }
            }
        };
        angular.extend(decorated, options);
        return Core.register(jolokia, $scope, arguments, onSuccess(undefined, decorated));
    }
    Core.registerForChanges = registerForChanges;
    var responseHistory = null;
    function getOrInitObjectFromLocalStorage(key) {
        var answer = undefined;
        if (!(key in localStorage)) {
            localStorage[key] = angular.toJson({});
        }
        return angular.fromJson(localStorage[key]);
    }
    Core.getOrInitObjectFromLocalStorage = getOrInitObjectFromLocalStorage;
    function argumentsToString(arguments) {
        return StringHelpers.toString(arguments);
    }
    function keyForArgument(argument) {
        if (!('type' in argument)) {
            return null;
        }
        var answer = argument['type'];
        switch (answer.toLowerCase()) {
            case 'exec':
                answer += ':' + argument['mbean'] + ':' + argument['operation'];
                var argString = argumentsToString(argument['arguments']);
                if (!Core.isBlank(argString)) {
                    answer += ':' + argString;
                }
                break;
            case 'read':
                answer += ':' + argument['mbean'] + ':' + argument['attribute'];
                break;
            default:
                return null;
        }
        return answer;
    }
    function createResponseKey(arguments) {
        var answer = '';
        if (angular.isArray(arguments)) {
            answer = arguments.map(function (arg) { return keyForArgument(arg); }).join(':');
        }
        else {
            answer = keyForArgument(arguments);
        }
        return answer;
    }
    function getResponseHistory() {
        if (responseHistory === null) {
            //responseHistory = getOrInitObjectFromLocalStorage('responseHistory');
            responseHistory = {};
            Core.log.debug("Created response history", responseHistory);
        }
        return responseHistory;
    }
    Core.getResponseHistory = getResponseHistory;
    Core.MAX_RESPONSE_CACHE_SIZE = 20;
    function getOldestKey(responseHistory) {
        var oldest = null;
        var oldestKey = null;
        angular.forEach(responseHistory, function (value, key) {
            //log.debug("Checking entry: ", key);
            //log.debug("Oldest timestamp: ", oldest, " key: ", key, " value: ", value);
            if (!value || !value.timestamp) {
                // null value is an excellent candidate for deletion
                oldest = 0;
                oldestKey = key;
            }
            else if (oldest === null || value.timestamp < oldest) {
                oldest = value.timestamp;
                oldestKey = key;
            }
        });
        return oldestKey;
    }
    function addResponse(arguments, value) {
        var responseHistory = getResponseHistory();
        var key = createResponseKey(arguments);
        if (key === null) {
            Core.log.debug("key for arguments is null, not caching: ", StringHelpers.toString(arguments));
            return;
        }
        //log.debug("Adding response to history, key: ", key, " value: ", value);
        // trim the cache if needed
        var keys = _.keys(responseHistory);
        //log.debug("Number of stored responses: ", keys.length);
        if (keys.length >= Core.MAX_RESPONSE_CACHE_SIZE) {
            Core.log.debug("Cache limit (", Core.MAX_RESPONSE_CACHE_SIZE, ") met or  exceeded (", keys.length, "), trimming oldest response");
            var oldestKey = getOldestKey(responseHistory);
            if (oldestKey !== null) {
                // delete the oldest entry
                Core.log.debug("Deleting key: ", oldestKey);
                delete responseHistory[oldestKey];
            }
            else {
                Core.log.debug("Got null key, could be a cache problem, wiping cache");
                keys.forEach(function (key) {
                    Core.log.debug("Deleting key: ", key);
                    delete responseHistory[key];
                });
            }
        }
        responseHistory[key] = value;
        //localStorage['responseHistory'] = angular.toJson(responseHistory);
    }
    function getResponse(jolokia, arguments, callback) {
        var responseHistory = getResponseHistory();
        var key = createResponseKey(arguments);
        if (key === null) {
            jolokia.request(arguments, callback);
            return;
        }
        if (key in responseHistory && 'success' in callback) {
            var value_1 = responseHistory[key];
            // do this async, the controller might not handle us immediately calling back
            setTimeout(function () {
                callback['success'](value_1);
            }, 10);
        }
        else {
            Core.log.debug("Unable to find existing response for key: ", key);
            jolokia.request(arguments, callback);
        }
    }
    // end jolokia caching stuff
    /**
     * Register a JMX operation to poll for changes
     * @method register
     * @for Core
     * @static
     * @return {Function} a zero argument function for unregistering  this registration
     * @param {*} jolokia
     * @param {*} scope
     * @param {Object} arguments
     * @param {Function} callback
     */
    function register(jolokia, scope, arguments, callback) {
        if (scope.$$destroyed) {
            // fail fast to prevent registration leaks
            return;
        }
        /*
        if (scope && !Core.isBlank(scope.name)) {
          Core.log.debug("Calling register from scope: ", scope.name);
        } else {
          Core.log.debug("Calling register from anonymous scope");
        }
        */
        if (!angular.isDefined(scope.$jhandle) || !angular.isArray(scope.$jhandle)) {
            //log.debug("No existing handle set, creating one");
            scope.$jhandle = [];
        }
        else {
            //log.debug("Using existing handle set");
        }
        if (angular.isDefined(scope.$on)) {
            scope.$on('$destroy', function (event) {
                unregister(jolokia, scope);
            });
        }
        var handle = null;
        if ('success' in callback) {
            var cb_1 = callback.success;
            var args_1 = arguments;
            callback.success = function (response) {
                addResponse(args_1, response);
                cb_1(response);
            };
        }
        if (angular.isArray(arguments)) {
            if (arguments.length >= 1) {
                // TODO can't get this to compile in typescript :)
                //let args = [callback].concat(arguments);
                var args_2 = [callback];
                angular.forEach(arguments, function (value) { return args_2.push(value); });
                //let args = [callback];
                //args.push(arguments);
                var registerFn = jolokia.register;
                handle = registerFn.apply(jolokia, args_2);
                scope.$jhandle.push(handle);
                getResponse(jolokia, arguments, callback);
            }
        }
        else {
            handle = jolokia.register(callback, arguments);
            scope.$jhandle.push(handle);
            getResponse(jolokia, arguments, callback);
        }
        return function () {
            if (handle !== null) {
                scope.$jhandle.remove(handle);
                jolokia.unregister(handle);
            }
        };
    }
    Core.register = register;
    /**
     * Register a JMX operation to poll for changes using a jolokia search using the given mbean pattern
     * @method registerSearch
     * @for Core
     * @static
     * @paran {*} jolokia
     * @param {*} scope
     * @param {String} mbeanPattern
     * @param {Function} callback
     */
    /*
    TODO - won't compile, and where is 'arguments' coming from?
    export function registerSearch(jolokia:Jolokia.IJolokia, scope, mbeanPattern:string, callback) {
        if (!angular.isDefined(scope.$jhandle) || !angular.isArray(scope.$jhandle)) {
            scope.$jhandle = [];
        }
        if (angular.isDefined(scope.$on)) {
            scope.$on('$destroy', function (event) {
                unregister(jolokia, scope);
            });
        }
        if (angular.isArray(arguments)) {
            if (arguments.length >= 1) {
                // TODO can't get this to compile in typescript :)
                //let args = [callback].concat(arguments);
                let args = [callback];
                angular.forEach(arguments, (value) => args.push(value));
                //let args = [callback];
                //args.push(arguments);
                let registerFn = jolokia.register;
                let handle = registerFn.apply(jolokia, args);
                scope.$jhandle.push(handle);
                jolokia.search(mbeanPattern, callback);
            }
        } else {
            let handle = jolokia.register(callback, arguments);
            scope.$jhandle.push(handle);
            jolokia.search(mbeanPattern, callback);
        }
    }
    */
    function unregister(jolokia, scope) {
        if (angular.isDefined(scope.$jhandle)) {
            scope.$jhandle.forEach(function (handle) {
                jolokia.unregister(handle);
            });
            delete scope.$jhandle;
        }
    }
    Core.unregister = unregister;
})(Core || (Core = {}));
var Jmx;
(function (Jmx) {
    Jmx.jmxComponent = {
        template: "\n      <div class=\"tree-nav-layout\">\n        <div class=\"sidebar-pf sidebar-pf-left\" resizable r-directions=\"['right']\">\n          <tree-header></tree-header>\n          <tree></tree>\n        </div>\n        <div class=\"tree-nav-main\">\n          <jmx-header></jmx-header>\n          <jmx-navigation></jmx-navigation>\n          <div class=\"contents\" ng-view></div>\n        </div>\n      </div>\n    "
    };
})(Jmx || (Jmx = {}));
/// <reference path="workspace.ts"/>
var Jmx;
(function (Jmx) {
    configureRoutes.$inject = ["$routeProvider"];
    configureAbout.$inject = ["aboutService"];
    configureHelp.$inject = ["helpRegistry"];
    configureMainNav.$inject = ["mainNavService", "workspace"];
    configurePageTitle.$inject = ["pageTitle", "jolokia"];
    initializeTree.$inject = ["$q", "$rootScope", "initService", "workspace"];
    Jmx.currentProcessId = '';
    function configureRoutes($routeProvider) {
        'ngInject';
        $routeProvider
            .when('/jmx/attributes', { templateUrl: 'plugins/jmx/html/attributes/attributes.html' })
            .when('/jmx/operations', { template: '<operations></operations>' })
            .when('/jmx/charts', { templateUrl: 'plugins/jmx/html/charts.html' })
            .when('/jmx/charts/edit', { templateUrl: 'plugins/jmx/html/chartEdit.html' });
    }
    Jmx.configureRoutes = configureRoutes;
    function configureAbout(aboutService) {
        'ngInject';
        aboutService.addProductInfo('Hawtio JMX', '4.1.4');
    }
    Jmx.configureAbout = configureAbout;
    function configureHelp(helpRegistry) {
        'ngInject';
        helpRegistry.addUserDoc('jmx', 'plugins/jmx/doc/help.md');
    }
    Jmx.configureHelp = configureHelp;
    function configureMainNav(mainNavService, workspace) {
        'ngInject';
        mainNavService.addItem({
            title: 'JMX',
            basePath: '/jmx',
            template: '<jmx></jmx>',
            isValid: function () { return workspace.hasMBeans(); }
        });
    }
    Jmx.configureMainNav = configureMainNav;
    function configurePageTitle(pageTitle, jolokia) {
        'ngInject';
        pageTitle.addTitleElement(function () {
            if (Jmx.currentProcessId === '') {
                try {
                    Jmx.currentProcessId = jolokia.getAttribute('java.lang:type=Runtime', 'Name');
                }
                catch (e) {
                    // ignore
                }
                if (Jmx.currentProcessId && Jmx.currentProcessId.indexOf("@") !== -1) {
                    Jmx.currentProcessId = "pid:" + Jmx.currentProcessId.split("@")[0];
                }
            }
            return Jmx.currentProcessId;
        });
    }
    Jmx.configurePageTitle = configurePageTitle;
    function initializeTree($q, $rootScope, initService, workspace) {
        'ngInject';
        initService.registerInitFunction(function () {
            Jmx.log.info('Jmx.initializeTree: initializing...');
            return $q(function (resolve) {
                workspace.loadTree();
                var unsubscribe = $rootScope.$on(Jmx.TreeEvent.Fetched, function () {
                    unsubscribe();
                    Jmx.log.info('Jmx.initializeTree: initialized');
                    resolve();
                });
            });
        });
    }
    Jmx.initializeTree = initializeTree;
})(Jmx || (Jmx = {}));
var Jmx;
(function (Jmx) {
    AttributesController.$inject = ["$scope", "$location", "workspace", "$templateCache", "localStorage", "$uibModal", "attributesService"];
    var PROPERTIES_COLUMN_DEFS = [
        {
            field: 'name',
            displayName: 'Attribute',
            cellTemplate: "\n        <div class=\"ngCellText\" title=\"{{row.entity.attrDesc}}\" data-placement=\"bottom\">\n          <a href=\"\" ng-click=\"row.entity.onViewAttribute()\">{{row.entity.name}}</a>\n        </div>\n      "
        },
        {
            field: 'value',
            displayName: 'Value',
            cellTemplate: "\n        <div class=\"ngCellText mouse-pointer\"\n             ng-click=\"row.entity.onViewAttribute()\"\n             title=\"{{row.entity.tooltip}}\"\n             ng-bind-html=\"row.entity.summary\"></div>\n      "
        }
    ];
    var FOLDERS_COLUMN_DEFS = [
        {
            displayName: 'Name',
            cellTemplate: "\n        <div class=\"ngCellText\">\n          <a href=\"\" ng-click=\"row.entity.gotoFolder(row)\">\n            <i class=\"{{row.entity.folderIconClass(row)}}\"></i> {{row.getProperty(\"title\")}}\n          </a>\n        </div>\n      "
        }
    ];
    function AttributesController($scope, $location, workspace, $templateCache, localStorage, $uibModal, attributesService) {
        'ngInject';
        var gridData = [];
        $scope.searchText = '';
        $scope.nid = 'empty';
        $scope.selectedItems = [];
        $scope.lastKey = null;
        $scope.attributesInfoCache = {};
        $scope.entity = {};
        $scope.attributeSchema = {};
        $scope.gridData = [];
        $scope.attributes = "";
        $scope.$watch('gridData.length', function (newValue, oldValue) {
            if (newValue !== oldValue) {
                if (newValue > 0) {
                    $scope.attributes = $templateCache.get('gridTemplate');
                }
                else {
                    $scope.attributes = "";
                }
            }
        });
        var ATTRIBUTE_SCHEMA_BASIC = {
            properties: {
                'key': {
                    type: 'string',
                    readOnly: 'true'
                },
                'description': {
                    description: 'Description',
                    type: 'string',
                    formTemplate: "<textarea class='form-control' rows='2' readonly='true'></textarea>"
                },
                'type': {
                    type: 'string',
                    readOnly: 'true'
                },
                'jolokia': {
                    label: 'Jolokia&nbsp;URL',
                    type: 'string',
                    formTemplate: "\n            <div class=\"hawtio-clipboard-container\">\n              <button hawtio-clipboard=\"#attribute-jolokia-url\" class=\"btn btn-default\">\n                <i class=\"fa fa-clipboard\" aria-hidden=\"true\"></i>\n              </button>\n              <input type=\"text\" id=\"attribute-jolokia-url\" class='form-control' style=\"padding-right: 26px\" value=\"{{entity.jolokia}}\" readonly='true'>\n            </div>\n          "
                }
            }
        };
        $scope.gridOptions = {
            scope: $scope,
            selectedItems: [],
            showFilter: false,
            canSelectRows: false,
            enableRowSelection: false,
            enableRowClickSelection: false,
            keepLastSelected: false,
            multiSelect: false,
            showColumnMenu: true,
            displaySelectionCheckbox: false,
            filterOptions: {
                filterText: ''
            },
            data: 'gridData',
            columnDefs: PROPERTIES_COLUMN_DEFS
        };
        $scope.$watch(function (scope) { return scope.gridOptions.selectedItems.map(function (item) { return item.key || item; }); }, function (newValue, oldValue) {
            if (newValue !== oldValue) {
                Jmx.log.debug("Selected items:", newValue);
                $scope.selectedItems = newValue;
            }
        }, true);
        // clear selection if we clicked the jmx nav bar button
        // otherwise we may show data from Camel/ActiveMQ or other plugins that
        // reuse the JMX plugin for showing tables (#884)
        var currentUrl = $location.url();
        if (_.endsWith(currentUrl, "/jmx/attributes")) {
            Jmx.log.debug("Reset selection in JMX plugin");
            workspace.selection = null;
            $scope.lastKey = null;
        }
        $scope.nid = $location.search()['nid'];
        Jmx.log.debug("attribute - nid: ", $scope.nid);
        var updateTable = _.debounce(updateTableContents, 50, { leading: false, trailing: true });
        $scope.$on(Jmx.TreeEvent.Updated, updateTable);
        updateTable();
        function onViewAttribute(row) {
            if (!row.summary) {
                return;
            }
            if (row.rw) {
                // for writable attribute, we need to check RBAC
                attributesService.canInvoke(workspace.getSelectedMBeanName(), row.key, row.type)
                    .then(function (canInvoke) { return showAttributeDialog(row, canInvoke); });
            }
            else {
                showAttributeDialog(row, false);
            }
        }
        function showAttributeDialog(row, rw) {
            // create entity and populate it with data from the selected row
            $scope.entity = {
                key: row.key,
                description: row.attrDesc,
                type: row.type,
                jolokia: attributesService.buildJolokiaUrl(workspace.getSelectedMBeanName(), row.key),
                rw: rw
            };
            var rows = numberOfRows(row);
            var readOnly = !$scope.entity.rw;
            if (readOnly) {
                // if the value is empty its a &nbsp; as we need this for the table to allow us to click on the empty row
                if (row.summary === '&nbsp;') {
                    $scope.entity["attrValueView"] = '';
                }
                else {
                    $scope.entity["attrValueView"] = row.summary;
                }
                initAttributeSchemaView($scope, rows);
            }
            else {
                // if the value is empty its a &nbsp; as we need this for the table to allow us to click on the empty row
                if (row.summary === '&nbsp;') {
                    $scope.entity["attrValueEdit"] = '';
                }
                else {
                    $scope.entity["attrValueEdit"] = row.summary;
                }
                initAttributeSchemaEdit($scope, rows);
            }
            $uibModal.open({
                templateUrl: 'attributeModal.html',
                scope: $scope,
                size: 'lg'
            })
                .result.then(function () {
                // update the attribute on the mbean
                var mbean = workspace.getSelectedMBeanName();
                if (mbean) {
                    var value = $scope.entity["attrValueEdit"];
                    var key = $scope.entity["key"];
                    attributesService.update(mbean, key, value);
                }
                $scope.entity = {};
            })
                .catch(function () {
                $scope.entity = {};
            });
        }
        function numberOfRows(row) {
            // calculate a textare with X number of rows that usually fit the value to display
            var len = row.summary.length;
            var rows = (len / 40) + 1;
            if (rows > 10) {
                // cap at most 10 rows to not make the dialog too large
                rows = 10;
            }
            return rows;
        }
        function initAttributeSchemaView($scope, rows) {
            // clone from the basic schema to the new schema we create on-the-fly
            // this is needed as the dialog have problems if reusing the schema, and changing the schema afterwards
            // so its safer to create a new schema according to our needs
            $scope.attributeSchemaView = {};
            for (var key in ATTRIBUTE_SCHEMA_BASIC) {
                $scope.attributeSchemaView[key] = ATTRIBUTE_SCHEMA_BASIC[key];
            }
            // and add the new attrValue which is dynamic computed
            $scope.attributeSchemaView.properties.attrValueView = {
                description: 'Value',
                label: "Value",
                type: 'string',
                formTemplate: "<textarea id=\"attribute-value\" class='form-control' style=\"overflow-y: scroll\" rows='" + rows + "' readonly='true'></textarea>\n        "
            };
            // just to be safe, then delete not needed part of the schema
            if ($scope.attributeSchemaView) {
                delete $scope.attributeSchemaView.properties.attrValueEdit;
            }
        }
        function initAttributeSchemaEdit($scope, rows) {
            // clone from the basic schema to the new schema we create on-the-fly
            // this is needed as the dialog have problems if reusing the schema, and changing the schema afterwards
            // so its safer to create a new schema according to our needs
            $scope.attributeSchemaEdit = {};
            for (var key in ATTRIBUTE_SCHEMA_BASIC) {
                $scope.attributeSchemaEdit[key] = ATTRIBUTE_SCHEMA_BASIC[key];
            }
            // and add the new attrValue which is dynamic computed
            $scope.attributeSchemaEdit.properties.attrValueEdit = {
                description: 'Value',
                label: "Value",
                type: 'string',
                formTemplate: "<textarea id=\"attribute-value\" class='form-control' style=\"overflow-y: scroll\" rows='" + rows + "'></textarea>"
            };
            // just to be safe, then delete not needed part of the schema
            if ($scope.attributeSchemaEdit) {
                delete $scope.attributeSchemaEdit.properties.attrValueView;
            }
        }
        function operationComplete() {
            updateTableContents();
        }
        function updateTableContents() {
            // lets clear any previous queries just in case!
            attributesService.unregisterJolokia($scope);
            $scope.gridData = [];
            $scope.mbeanIndex = null;
            var mbean = workspace.getSelectedMBeanName();
            var node = workspace.selection;
            if (_.isNil(node) || node.key !== $scope.lastKey) {
                // cache attributes info, so we know if the attribute is read-only or read-write, and also the attribute description
                $scope.attributesInfoCache = null;
                if (mbean == null) {
                    // in case of refresh
                    var _key = $location.search()['nid'];
                    var _node = workspace.keyToNodeMap[_key];
                    if (_node) {
                        mbean = _node.objectName;
                    }
                }
                if (mbean) {
                    attributesService.listMBean(mbean, Core.onSuccess(function (response) {
                        $scope.attributesInfoCache = response.value;
                        Jmx.log.debug("Updated attributes info cache for mbean", mbean, $scope.attributesInfoCache);
                    }));
                }
            }
            var request = null;
            if (mbean) {
                request = { type: 'read', mbean: mbean };
                if (_.isNil(node) || node.key !== $scope.lastKey) {
                    $scope.gridOptions.columnDefs = PROPERTIES_COLUMN_DEFS;
                }
            }
            else if (node) {
                if (node.key !== $scope.lastKey) {
                    $scope.gridOptions.columnDefs = [];
                }
                // lets query each child's details
                var children = node.children;
                if (children) {
                    var childNodes = children.map(function (child) { return child.objectName; });
                    var mbeans = childNodes.filter(function (mbean) { return FilterHelpers.search(mbean, $scope.gridOptions.filterOptions.filterText); });
                    var maxFolderSize = localStorage["jmxMaxFolderSize"];
                    mbeans = mbeans.slice(0, maxFolderSize);
                    if (mbeans) {
                        var typeNames = Jmx.getUniqueTypeNames(children);
                        if (typeNames.length <= 1) {
                            var query = mbeans.map(function (mbean) {
                                return { type: "READ", mbean: mbean, ignoreErrors: true };
                            });
                            if (query.length > 0) {
                                request = query;
                                // deal with multiple results
                                $scope.mbeanIndex = {};
                                $scope.mbeanRowCounter = 0;
                                $scope.mbeanCount = mbeans.length;
                            }
                        }
                        else {
                            Jmx.log.debug("Too many type names ", typeNames);
                        }
                    }
                }
            }
            if (request) {
                $scope.request = request;
                attributesService.registerJolokia($scope, request, Core.onSuccess(render));
            }
            else if (node) {
                if (node.key !== $scope.lastKey) {
                    $scope.gridOptions.columnDefs = FOLDERS_COLUMN_DEFS;
                }
                $scope.gridData = node.children;
                addHandlerFunctions($scope.gridData);
            }
            if (node) {
                $scope.lastKey = node.key;
                $scope.title = node.text;
            }
            Core.$apply($scope);
        }
        function render(response) {
            var data = response.value;
            var mbeanIndex = $scope.mbeanIndex;
            var mbean = response.request['mbean'];
            if (mbean) {
                // lets store the mbean in the row for later
                data["_id"] = mbean;
            }
            if (mbeanIndex) {
                if (mbean) {
                    var idx = mbeanIndex[mbean];
                    if (!angular.isDefined(idx)) {
                        idx = $scope.mbeanRowCounter;
                        mbeanIndex[mbean] = idx;
                        $scope.mbeanRowCounter += 1;
                    }
                    if (idx === 0) {
                        // this is to force the table to repaint
                        $scope.selectedIndices = $scope.selectedItems.map(function (item) { return $scope.gridData.indexOf(item); });
                        gridData = [];
                        if (!$scope.gridOptions.columnDefs.length) {
                            // lets update the column definitions based on any configured defaults
                            var key = workspace.selectionConfigKey();
                            $scope.gridOptions.gridKey = key;
                            $scope.gridOptions.onClickRowHandlers = workspace.onClickRowHandlers;
                            var defaultDefs_1 = _.clone(workspace.attributeColumnDefs[key]) || [];
                            var defaultSize_1 = defaultDefs_1.length;
                            var map_1 = {};
                            angular.forEach(defaultDefs_1, function (value, key) {
                                var field = value.field;
                                if (field) {
                                    map_1[field] = value;
                                }
                            });
                            var extraDefs_1 = [];
                            _.forEach(data, function (value, key) {
                                if (includePropertyValue(key, value)) {
                                    if (!map_1[key]) {
                                        extraDefs_1.push({
                                            field: key,
                                            displayName: key === '_id' ? 'Object name' : Core.humanizeValue(key),
                                            visible: defaultSize_1 === 0
                                        });
                                    }
                                }
                            });
                            // the additional columns (which are not pre-configured), should be sorted
                            // so the column menu has a nice sorted list instead of random ordering
                            extraDefs_1 = extraDefs_1.sort(function (def, def2) {
                                // make sure _id is last
                                if (_.startsWith(def.field, '_')) {
                                    return 1;
                                }
                                else if (_.startsWith(def2.field, '_')) {
                                    return -1;
                                }
                                return def.field.localeCompare(def2.field);
                            });
                            extraDefs_1.forEach(function (e) { return defaultDefs_1.push(e); });
                            if (extraDefs_1.length > 0) {
                                $scope.hasExtraColumns = true;
                            }
                            $scope.gridOptions.columnDefs = defaultDefs_1;
                        }
                    }
                    // mask attribute read error
                    _.forEach(data, function (value, key) {
                        if (includePropertyValue(key, value)) {
                            data[key] = maskReadError(value);
                        }
                    });
                    // assume 1 row of data per mbean
                    gridData[idx] = data;
                    addHandlerFunctions(gridData);
                    var count = $scope.mbeanCount;
                    if (!count || idx + 1 >= count) {
                        // only cause a refresh on the last row
                        var newSelections = $scope.selectedIndices.map(function (idx) { return $scope.gridData[idx]; }).filter(function (row) { return row; });
                        $scope.selectedItems.splice(0, $scope.selectedItems.length);
                        $scope.selectedItems.push.apply($scope.selectedItems, newSelections);
                        $scope.gridData = gridData;
                        Core.$apply($scope);
                    }
                    // if the last row, then fire an event
                }
                else {
                    Jmx.log.info("No mbean name in request", JSON.stringify(response.request));
                }
            }
            else {
                $scope.gridOptions.columnDefs = PROPERTIES_COLUMN_DEFS;
                $scope.gridOptions.enableRowClickSelection = false;
                var showAllAttributes_1 = true;
                if (_.isObject(data)) {
                    var properties_1 = [];
                    _.forEach(data, function (value, key) {
                        if (showAllAttributes_1 || includePropertyValue(key, value)) {
                            // always skip keys which start with _
                            if (!_.startsWith(key, "_")) {
                                // lets format the ObjectName nicely dealing with objects with
                                // nested object names or arrays of object names
                                if (key === "ObjectName") {
                                    value = unwrapObjectName(value);
                                }
                                // lets unwrap any arrays of object names
                                if (_.isArray(value)) {
                                    value = value.map(function (v) { return unwrapObjectName(v); });
                                }
                                // the value must be string as the sorting/filtering of the table relies on that
                                var type = lookupAttributeType(key);
                                var data_1 = {
                                    key: key,
                                    name: Core.humanizeValue(key),
                                    value: maskReadError(Core.safeNullAsString(value, type))
                                };
                                generateSummaryAndDetail(key, data_1);
                                properties_1.push(data_1);
                            }
                        }
                    });
                    if (!_.some(properties_1, function (p) {
                        return p['key'] === 'ObjectName';
                    })) {
                        var objectName = {
                            key: "ObjectName",
                            name: "Object Name",
                            value: mbean
                        };
                        generateSummaryAndDetail(objectName.key, objectName);
                        properties_1.push(objectName);
                    }
                    properties_1 = _.sortBy(properties_1, 'name');
                    $scope.selectedItems = [data];
                    data = properties_1;
                }
                $scope.gridData = data;
                addHandlerFunctions($scope.gridData);
                Core.$apply($scope);
            }
        }
        function maskReadError(value) {
            if (typeof value !== 'string') {
                return value;
            }
            var forbidden = /^ERROR: Reading attribute .+ \(class java\.lang\.SecurityException\)$/;
            var unsupported = /^ERROR: java\.lang\.UnsupportedOperationException: .+ \(class javax\.management\.RuntimeMBeanException\)$/;
            if (value.match(forbidden)) {
                return "**********";
            }
            else if (value.match(unsupported)) {
                return "(Not supported)";
            }
            else {
                return value;
            }
        }
        function addHandlerFunctions(data) {
            if (!data) {
                return;
            }
            data.forEach(function (item) {
                item['onViewAttribute'] = function () { return onViewAttribute(item); };
                item['folderIconClass'] = function (row) { return folderIconClass(row); };
                item['gotoFolder'] = function (row) { return gotoFolder(row); };
            });
        }
        function folderIconClass(row) {
            if (!row.getProperty) {
                return '';
            }
            if (!row.getProperty('objectName')) {
                return 'pficon pficon-folder-close';
            }
            var mbean = row.getProperty('mbean');
            return _.isNil(mbean) || _.isNil(mbean.canInvoke) || mbean.canInvoke ? 'fa fa-cog' : 'fa fa-lock';
        }
        function gotoFolder(row) {
            if (row.getProperty) {
                var key = row.getProperty('key');
                if (key) {
                    $location.search('nid', key);
                }
            }
        }
        function unwrapObjectName(value) {
            if (!_.isObject(value)) {
                return value;
            }
            var keys = Object.keys(value);
            if (keys.length === 1 && keys[0] === "objectName") {
                return value["objectName"];
            }
            return value;
        }
        function generateSummaryAndDetail(key, data) {
            var value = Core.escapeHtml(data.value);
            if (!angular.isArray(value) && angular.isObject(value)) {
                var detailHtml_1 = "<table class='table table-striped'>";
                var summary_1 = "";
                var object_1 = value;
                var keys = Object.keys(value).sort();
                angular.forEach(keys, function (key) {
                    var value = object_1[key];
                    detailHtml_1 += "<tr><td>" + Core.humanizeValue(key) + "</td><td>" + value + "</td></tr>";
                    summary_1 += Core.humanizeValue(key) + ": " + value + "  ";
                });
                detailHtml_1 += "</table>";
                data.summary = summary_1;
                data.detailHtml = detailHtml_1;
                data.tooltip = summary_1;
            }
            else {
                var text = value;
                // if the text is empty then use a no-break-space so the table allows us to click on the row,
                // otherwise if the text is empty, then you cannot click on the row
                if (text === '') {
                    text = '&nbsp;';
                    data.tooltip = "";
                }
                else {
                    data.tooltip = text;
                }
                data.summary = "" + text;
                data.detailHtml = "<pre>" + text + "</pre>";
                if (angular.isArray(value)) {
                    var html_1 = "<ul>";
                    angular.forEach(value, function (item) { return html_1 += "<li>" + item + "</li>"; });
                    html_1 += "</ul>";
                    data.detailHtml = html_1;
                }
            }
            // enrich the data with information if the attribute is read-only/read-write, and the JMX attribute description (if any)
            data.rw = false;
            data.attrDesc = data.name;
            data.type = "string";
            if ($scope.attributesInfoCache != null && 'attr' in $scope.attributesInfoCache) {
                var info = $scope.attributesInfoCache.attr[key];
                if (angular.isDefined(info)) {
                    data.rw = info.rw;
                    data.attrDesc = info.desc;
                    data.type = info.type;
                }
            }
        }
        function lookupAttributeType(key) {
            if ($scope.attributesInfoCache != null && 'attr' in $scope.attributesInfoCache) {
                var info = $scope.attributesInfoCache.attr[key];
                if (angular.isDefined(info)) {
                    return info.type;
                }
            }
            return null;
        }
        function includePropertyValue(key, value) {
            return !_.isObject(value);
        }
    }
    Jmx.AttributesController = AttributesController;
})(Jmx || (Jmx = {}));
/// <reference path="../../../rbac/ts/models.ts"/>
var Jmx;
(function (Jmx) {
    var AttributesService = /** @class */ (function () {
        AttributesService.$inject = ["$q", "jolokia", "jolokiaUrl", "rbacACLMBean"];
        function AttributesService($q, jolokia, jolokiaUrl, rbacACLMBean) {
            'ngInject';
            this.$q = $q;
            this.jolokia = jolokia;
            this.jolokiaUrl = jolokiaUrl;
            this.rbacACLMBean = rbacACLMBean;
        }
        AttributesService.prototype.registerJolokia = function (scope, request, callback) {
            Core.register(this.jolokia, scope, request, callback);
        };
        AttributesService.prototype.unregisterJolokia = function (scope) {
            Core.unregister(this.jolokia, scope);
        };
        AttributesService.prototype.listMBean = function (mbeanName, callback) {
            this.jolokia.request({
                type: "LIST",
                method: "post",
                path: Core.escapeMBeanPath(mbeanName),
                ignoreErrors: true
            }, callback);
        };
        AttributesService.prototype.canInvoke = function (mbeanName, attribute, type) {
            var _this = this;
            return this.$q(function (resolve, reject) {
                if (_.isNull(mbeanName) || _.isNull(attribute) || _.isNull(type)) {
                    resolve(false);
                    return;
                }
                _this.rbacACLMBean.then(function (rbacACLMBean) {
                    if (!rbacACLMBean) {
                        // Client-side RBAC is not available
                        resolve(true);
                    }
                    _this.jolokia.request({
                        type: 'exec',
                        mbean: rbacACLMBean,
                        operation: 'canInvoke(java.lang.String,java.lang.String,[Ljava.lang.String;)',
                        arguments: [mbeanName, "set" + attribute, [type]]
                    }, Core.onSuccess(function (response) {
                        Jmx.log.debug("rbacACLMBean canInvoke attribute response:", response);
                        var canInvoke = response.value;
                        resolve(canInvoke);
                    }, {
                        error: function (response) {
                            Jmx.log.debug('AttributesService.canInvoke() failed:', response);
                            resolve(false);
                        }
                    }));
                });
            });
        };
        AttributesService.prototype.buildJolokiaUrl = function (mbeanName, attribute) {
            return this.jolokiaUrl + "/read/" + Core.escapeMBean(mbeanName) + "/" + attribute;
        };
        AttributesService.prototype.update = function (mbeanName, attribute, value) {
            this.jolokia.setAttribute(mbeanName, attribute, value, Core.onSuccess(function (response) {
                Core.notification("success", "Updated attribute " + attribute);
            }, {
                error: function (response) {
                    Jmx.log.debug("Failed to update attribute", response);
                    Core.notification("danger", "Failed to update attribute " + attribute);
                }
            }));
        };
        return AttributesService;
    }());
    Jmx.AttributesService = AttributesService;
})(Jmx || (Jmx = {}));
/// <reference path="attributes.controller.ts"/>
/// <reference path="attributes.service.ts"/>
var Jmx;
(function (Jmx) {
    Jmx.attributesModule = angular
        .module('hawtio-jmx-attributes', [])
        .controller('Jmx.AttributesController', Jmx.AttributesController)
        .service('attributesService', Jmx.AttributesService)
        .name;
})(Jmx || (Jmx = {}));
var Jmx;
(function (Jmx) {
    var HeaderController = /** @class */ (function () {
        HeaderController.$inject = ["$scope"];
        function HeaderController($scope) {
            'ngInject';
            var _this = this;
            $scope.$on('jmxTreeClicked', function (event, selectedNode) {
                _this.title = selectedNode.text;
                _this.objectName = selectedNode.objectName;
            });
        }
        return HeaderController;
    }());
    Jmx.HeaderController = HeaderController;
    Jmx.headerComponent = {
        template: "\n      <div class=\"jmx-header\">\n        <header>\n          <h1>{{$ctrl.title}}</h1>\n          <p class=\"text-muted\">{{$ctrl.objectName}}</p>\n        </header>\n      </div>\n      ",
        controller: HeaderController
    };
})(Jmx || (Jmx = {}));
var Jmx;
(function (Jmx) {
    var NavigationController = /** @class */ (function () {
        NavigationController.$inject = ["$scope", "$location", "workspace"];
        function NavigationController($scope, $location, workspace) {
            'ngInject';
            var _this = this;
            this.$location = $location;
            this.workspace = workspace;
            $scope.$on('jmxTreeClicked', function () {
                _this.tabs = _this.getTabs();
            });
        }
        NavigationController.prototype.$onInit = function () {
            this.tabs = this.getTabs();
        };
        NavigationController.prototype.getTabs = function () {
            var tabs = [];
            tabs.push(new Nav.HawtioTab('Attributes', '/jmx/attributes'));
            if (this.workspace.getSelectedMBeanName() !== null) {
                tabs.push(new Nav.HawtioTab('Operations', '/jmx/operations'));
            }
            tabs.push(new Nav.HawtioTab('Chart', '/jmx/charts'));
            return tabs;
        };
        NavigationController.prototype.goto = function (tab) {
            this.$location.path(tab.path);
        };
        return NavigationController;
    }());
    Jmx.NavigationController = NavigationController;
    Jmx.navigationComponent = {
        template: '<hawtio-tabs tabs="$ctrl.tabs" on-change="$ctrl.goto(tab)"></hawtio-tabs>',
        controller: NavigationController
    };
})(Jmx || (Jmx = {}));
/// <reference path="header.component.ts"/>
/// <reference path="navigation.component.ts"/>
var Jmx;
(function (Jmx) {
    Jmx.commonModule = angular
        .module('hawtio-jmx-common', [])
        .component('jmxHeader', Jmx.headerComponent)
        .component('jmxNavigation', Jmx.navigationComponent)
        .name;
})(Jmx || (Jmx = {}));
var Jmx;
(function (Jmx) {
    var Operation = /** @class */ (function () {
        function Operation(method, args, description) {
            this.args = args;
            this.description = description;
            this.name = Operation.buildName(method, args);
            this.readableName = Operation.buildReadableName(method, args);
            this.canInvoke = true;
        }
        Operation.buildName = function (method, args) {
            return method + "(" + args.map(function (arg) { return arg.type; }).join() + ")";
        };
        Operation.buildReadableName = function (method, args) {
            return method + "(" + args.map(function (arg) { return arg.readableType(); }).join(', ') + ")";
        };
        return Operation;
    }());
    Jmx.Operation = Operation;
    var OperationArgument = /** @class */ (function () {
        function OperationArgument() {
        }
        OperationArgument.prototype.readableType = function () {
            var lastDotIndex = this.type.lastIndexOf('.');
            var answer = lastDotIndex > 0 ? this.type.substr(lastDotIndex + 1) : this.type;
            if (_.startsWith(this.type, '[') && _.endsWith(this.type, ';')) {
                answer = _.trimEnd(answer, ';') + '[]';
            }
            return answer;
        };
        return OperationArgument;
    }());
    Jmx.OperationArgument = OperationArgument;
})(Jmx || (Jmx = {}));
/// <reference path="operation.ts"/>
/// <reference path="../../../rbac/ts/models.ts"/>
var Jmx;
(function (Jmx) {
    var OperationsService = /** @class */ (function () {
        OperationsService.$inject = ["$q", "jolokia", "jolokiaUrl", "workspace", "treeService", "rbacACLMBean"];
        function OperationsService($q, jolokia, jolokiaUrl, workspace, treeService, rbacACLMBean) {
            'ngInject';
            this.$q = $q;
            this.jolokia = jolokia;
            this.jolokiaUrl = jolokiaUrl;
            this.workspace = workspace;
            this.treeService = treeService;
            this.rbacACLMBean = rbacACLMBean;
        }
        OperationsService.prototype.getOperations = function () {
            var _this = this;
            return this.treeService.getSelectedMBeanName()
                .then(function (mbeanName) { return mbeanName ? _this.fetchOperations(mbeanName) : []; });
        };
        OperationsService.prototype.fetchOperations = function (mbeanName) {
            var _this = this;
            return this.$q(function (resolve, reject) {
                _this.jolokia.request({
                    type: 'list',
                    path: Core.escapeMBeanPath(mbeanName)
                }, Core.onSuccess(function (response) {
                    var operations = [];
                    var operationMap = {};
                    _.forEach(response.value.op, function (op, opName) {
                        if (_.isArray(op)) {
                            _.forEach(op, function (op) {
                                return _this.addOperation(operations, operationMap, opName, op);
                            });
                        }
                        else {
                            _this.addOperation(operations, operationMap, opName, op);
                        }
                    });
                    operations = _.sortBy(operations, function (operation) { return operation.readableName; });
                    if (!_.isEmpty(operationMap)) {
                        _this.fetchPermissions(operationMap, mbeanName)
                            .then(function () { return resolve(operations); });
                    }
                    else {
                        resolve(operations);
                    }
                }, {
                    error: function (response) {
                        return Jmx.log.debug('OperationsService.loadOperations() failed:', response);
                    }
                }));
            });
        };
        OperationsService.prototype.addOperation = function (operations, operationMap, opName, op) {
            var operation = new Jmx.Operation(opName, op.args.map(function (arg) { return _.assign(new Jmx.OperationArgument(), arg); }), op.desc);
            operations.push(operation);
            operationMap[operation.name] = operation;
        };
        OperationsService.prototype.fetchPermissions = function (operationMap, mbeanName) {
            var _this = this;
            return this.$q(function (resolve, reject) {
                return _this.rbacACLMBean.then(function (rbacACLMBean) {
                    var _a;
                    if (!rbacACLMBean) {
                        // Client-side RBAC is not available
                        resolve();
                    }
                    _this.jolokia.request({
                        type: 'exec',
                        mbean: rbacACLMBean,
                        operation: 'canInvoke(java.util.Map)',
                        arguments: [(_a = {}, _a[mbeanName] = _.values(operationMap).map(function (op) { return op.name; }), _a)]
                    }, Core.onSuccess(function (response) {
                        Jmx.log.debug("rbacACLMBean canInvoke operations response:", response);
                        var ops = response.value;
                        _.forEach(ops[mbeanName], function (canInvoke, opName) {
                            operationMap[opName].canInvoke = canInvoke.CanInvoke;
                        });
                        Jmx.log.debug("Got operations:", operationMap);
                        resolve();
                    }, {
                        error: function (response) {
                            return Jmx.log.debug('OperationsService.fetchPermissions() failed:', response);
                        }
                    }));
                });
            });
        };
        OperationsService.prototype.executeOperation = function (mbeanName, operation, argValues) {
            var _this = this;
            if (argValues === void 0) { argValues = []; }
            return this.$q(function (resolve, reject) {
                var _a;
                (_a = _this.jolokia).execute.apply(_a, [mbeanName, operation.name].concat(argValues, [{
                        success: function (response) {
                            if (response === null || response === 'null') {
                                resolve('Operation Succeeded!');
                            }
                            else if (typeof response === 'string') {
                                if (response.trim() === '') {
                                    resolve('Empty string');
                                }
                                else {
                                    resolve(response);
                                }
                            }
                            else {
                                resolve(angular.toJson(response, true));
                            }
                        },
                        error: function (response) { return reject(response.stacktrace ? response.stacktrace : response.error); }
                    }]));
            });
        };
        ;
        OperationsService.prototype.buildJolokiaUrl = function (operation) {
            var mbeanName = Core.escapeMBean(this.workspace.getSelectedMBeanName());
            return this.jolokiaUrl + "/exec/" + mbeanName + "/" + operation.name;
        };
        return OperationsService;
    }());
    Jmx.OperationsService = OperationsService;
})(Jmx || (Jmx = {}));
/// <reference path="../workspace.ts"/>
/// <reference path="operations.service.ts"/>
/// <reference path="operation.ts"/>
var Jmx;
(function (Jmx) {
    var OperationsController = /** @class */ (function () {
        OperationsController.$inject = ["operationsService"];
        function OperationsController(operationsService) {
            'ngInject';
            var _this = this;
            this.operationsService = operationsService;
            this.config = {
                showSelectBox: false,
                useExpandingRows: true
            };
            this.menuActions = [
                {
                    name: 'Copy method name',
                    actionFn: function (action, item) {
                        var clipboard = new Clipboard('.jmx-operations-list-view .dropdown-menu a', {
                            text: function (trigger) { return item.readableName; }
                        });
                        setTimeout(function () { return clipboard.destroy(); }, 1000);
                        Core.notification('success', 'Method name copied');
                    }
                },
                {
                    name: 'Copy Jolokia URL',
                    actionFn: function (action, item) {
                        var clipboard = new Clipboard('.jmx-operations-list-view .dropdown-menu a', {
                            text: function (trigger) { return _this.operationsService.buildJolokiaUrl(item); }
                        });
                        setTimeout(function () { return clipboard.destroy(); }, 1000);
                        Core.notification('success', 'Jolokia URL copied');
                    }
                }
            ];
        }
        OperationsController.prototype.$onInit = function () {
            var _this = this;
            this.operationsService.getOperations()
                .then(function (operations) { return _this.operations = operations; });
        };
        return OperationsController;
    }());
    Jmx.OperationsController = OperationsController;
    Jmx.operationsComponent = {
        templateUrl: 'plugins/jmx/html/operations/operations.html',
        controller: OperationsController
    };
})(Jmx || (Jmx = {}));
/// <reference path="../workspace.ts"/>
/// <reference path="operations.service.ts"/>
/// <reference path="operation.ts"/>
var Jmx;
(function (Jmx) {
    var OperationFormController = /** @class */ (function () {
        OperationFormController.$inject = ["workspace", "operationsService"];
        function OperationFormController(workspace, operationsService) {
            'ngInject';
            this.workspace = workspace;
            this.operationsService = operationsService;
            this.editorMode = 'text';
            this.isExecuting = false;
        }
        OperationFormController.prototype.$onInit = function () {
            this.formFields = this.operation.args.map(function (arg) { return ({
                label: arg.name,
                type: OperationFormController.convertToHtmlInputType(arg.type),
                helpText: OperationFormController.buildHelpText(arg),
                value: OperationFormController.getDefaultValue(arg.type)
            }); });
        };
        OperationFormController.buildHelpText = function (arg) {
            if (arg.desc && arg.desc !== arg.name) {
                if (arg.desc.charAt(arg.desc.length - 1) !== '.') {
                    arg.desc = arg.desc + '.';
                }
                arg.desc = arg.desc + ' ';
            }
            else {
                arg.desc = '';
            }
            return arg.desc + 'Type: ' + arg.readableType();
        };
        OperationFormController.convertToHtmlInputType = function (javaType) {
            switch (javaType) {
                case 'boolean':
                case 'java.lang.Boolean':
                    return 'checkbox';
                case 'int':
                case 'long':
                case 'java.lang.Integer':
                case 'java.lang.Long':
                    return 'number';
                default:
                    return 'text';
            }
        };
        OperationFormController.getDefaultValue = function (javaType) {
            switch (javaType) {
                case 'boolean':
                case 'java.lang.Boolean':
                    return false;
                case 'int':
                case 'long':
                case 'java.lang.Integer':
                case 'java.lang.Long':
                    return 0;
                default:
                    return '';
            }
        };
        OperationFormController.prototype.execute = function () {
            var _this = this;
            this.isExecuting = true;
            var mbeanName = this.workspace.getSelectedMBeanName();
            var argValues = this.formFields.map(function (formField) { return formField.value; });
            this.operationsService.executeOperation(mbeanName, this.operation, argValues)
                .then(function (result) {
                _this.operationFailed = false;
                _this.operationResult = result.trim();
                _this.isExecuting = false;
            })
                .catch(function (error) {
                _this.operationFailed = true;
                _this.operationResult = error.trim();
                _this.isExecuting = false;
            });
        };
        return OperationFormController;
    }());
    Jmx.OperationFormController = OperationFormController;
    Jmx.operationFormComponent = {
        bindings: {
            operation: '<'
        },
        templateUrl: 'plugins/jmx/html/operations/operation-form.html',
        controller: OperationFormController
    };
})(Jmx || (Jmx = {}));
/// <reference path="operations.component.ts"/>
/// <reference path="operation-form.component.ts"/>
/// <reference path="operations.service.ts"/>
var Jmx;
(function (Jmx) {
    Jmx.operationsModule = angular
        .module('hawtio-jmx-operations', [])
        .component('operations', Jmx.operationsComponent)
        .component('operationForm', Jmx.operationFormComponent)
        .service('operationsService', Jmx.OperationsService)
        .name;
})(Jmx || (Jmx = {}));
/// <reference path="tree.module.ts"/>
var Jmx;
(function (Jmx) {
    var TreeHeaderController = /** @class */ (function () {
        TreeHeaderController.$inject = ["$scope", "$element"];
        function TreeHeaderController($scope, $element) {
            'ngInject';
            this.$scope = $scope;
            this.$element = $element;
            this.filter = '';
            this.result = [];
            // it's not possible to declare classes to the component host tag in AngularJS
            $element.addClass('tree-nav-sidebar-header');
        }
        TreeHeaderController.prototype.$onInit = function () {
            var _this = this;
            this.$scope.$watch(angular.bind(this, function () { return _this.filter; }), function (filter, previous) {
                if (filter !== previous) {
                    _this.search(filter);
                }
            });
        };
        TreeHeaderController.prototype.search = function (filter) {
            var _this = this;
            var doSearch = function (filter) {
                var _a;
                var result = _this.tree().search(filter, {
                    ignoreCase: true,
                    exactMatch: false,
                    revealResults: true,
                });
                _this.result.length = 0;
                (_a = _this.result).push.apply(_a, result);
                Core.$apply(_this.$scope);
            };
            _.debounce(doSearch, 300, { leading: false, trailing: true })(filter);
        };
        TreeHeaderController.prototype.tree = function () {
            return $(Jmx.treeElementId).treeview(true);
        };
        TreeHeaderController.prototype.expandAll = function () {
            return this.tree().expandAll({ silent: true });
        };
        TreeHeaderController.prototype.contractAll = function () {
            return this.tree().collapseAll({ silent: true });
        };
        return TreeHeaderController;
    }());
    Jmx.TreeHeaderController = TreeHeaderController;
})(Jmx || (Jmx = {}));
/// <reference path="tree-header.controller.ts"/>
var Jmx;
(function (Jmx) {
    Jmx.treeHeaderComponent = {
        templateUrl: 'plugins/jmx/html/tree/header.html',
        controller: Jmx.TreeHeaderController
    };
})(Jmx || (Jmx = {}));
var Jmx;
(function (Jmx) {
    var TreeController = /** @class */ (function () {
        TreeController.$inject = ["$scope", "$location", "workspace", "$element", "$timeout"];
        function TreeController($scope, $location, workspace, $element, $timeout) {
            'ngInject';
            this.$scope = $scope;
            this.$location = $location;
            this.workspace = workspace;
            this.$element = $element;
            this.$timeout = $timeout;
            // it's not possible to declare classes to the component host tag in AngularJS
            $element.addClass('tree-nav-sidebar-content');
        }
        TreeController.prototype.$onInit = function () {
            var _this = this;
            this.$scope.$on('$destroy', function () { return _this.removeTree(); });
            this.$scope.$on(Jmx.TreeEvent.Updated, function () { return _this.populateTree(); });
            this.$scope.$on('$routeChangeStart', function () { return _this.updateSelectionFromURL(); });
            this.populateTree();
        };
        TreeController.prototype.updateSelectionFromURL = function () {
            Jmx.updateTreeSelectionFromURL(this.$location, $(Jmx.treeElementId));
        };
        TreeController.prototype.populateTree = function () {
            var _this = this;
            Jmx.log.debug('TreeController: populateTree');
            this.removeTree();
            Jmx.enableTree(this.$scope, this.$location, this.workspace, $(Jmx.treeElementId), this.workspace.tree.children);
            this.$timeout(function () {
                _this.updateSelectionFromURL();
                _this.workspace.broadcastSelectionNode();
            });
        };
        TreeController.prototype.removeTree = function () {
            var tree = $(Jmx.treeElementId).treeview(true);
            // There is no exposed API to check whether the tree has already been initialized,
            // so let's just check if the methods are presents
            if (tree.clearSearch) {
                tree.clearSearch();
                // Bootstrap tree view leaks the node elements into the data structure
                // so let's clean this up when the user leaves the view
                var cleanTreeFolder_1 = function (node) {
                    delete node['$el'];
                    if (node.nodes)
                        node.nodes.forEach(cleanTreeFolder_1);
                };
                cleanTreeFolder_1(this.workspace.tree);
                // Then call the tree clean-up method
                tree.remove();
            }
        };
        return TreeController;
    }());
    Jmx.TreeController = TreeController;
    Jmx.treeComponent = {
        templateUrl: 'plugins/jmx/html/tree/content.html',
        controller: TreeController,
    };
})(Jmx || (Jmx = {}));
/// <reference path="tree-header.component.ts"/>
/// <reference path="tree.component.ts"/>
/// <reference path="tree.service.ts"/>
var Jmx;
(function (Jmx) {
    Jmx.treeModule = angular
        .module('hawtio-jmx-tree', [])
        .component('treeHeader', Jmx.treeHeaderComponent)
        .component('tree', Jmx.treeComponent)
        .service('treeService', Jmx.TreeService)
        .name;
    Jmx.treeElementId = '#jmxtree';
})(Jmx || (Jmx = {}));
/// <reference path="workspace.ts"/>
var Jmx;
(function (Jmx) {
    createWorkspace.$inject = ["$location", "jmxTreeLazyLoadRegistry", "$compile", "$templateCache", "localStorage", "jolokia", "jolokiaStatus", "$rootScope", "userDetails"];
    function createWorkspace($location, jmxTreeLazyLoadRegistry, $compile, $templateCache, localStorage, jolokia, jolokiaStatus, $rootScope, userDetails) {
        'ngInject';
        var workspace = new Jmx.Workspace(jolokia, jolokiaStatus, jmxTreeLazyLoadRegistry, $location, $compile, $templateCache, localStorage, $rootScope);
        return workspace;
    }
    Jmx.createWorkspace = createWorkspace;
})(Jmx || (Jmx = {}));
/// <reference path="../../jvm/ts/jvmHelpers.ts"/>
/// <reference path="attributes/attributes.module.ts"/>
/// <reference path="common/common.module.ts"/>
/// <reference path="operations/operations.module.ts"/>
/// <reference path="tree/tree.module.ts"/>
/// <reference path="jmx.component.ts"/>
/// <reference path="jmx.config.ts"/>
/// <reference path="workspace.factory.ts"/>
var Jmx;
(function (Jmx) {
    Jmx.jmxModule = angular.module('hawtio-jmx', [
        'angularResizable',
        Jmx.commonModule,
        Jmx.attributesModule,
        Jmx.operationsModule,
        Jmx.treeModule
    ])
        .config(Jmx.configureRoutes)
        .run(Jmx.configureAbout)
        .run(Jmx.configureHelp)
        .run(Jmx.configureMainNav)
        .run(Jmx.configurePageTitle)
        .run(Jmx.initializeTree)
        .component('jmx', Jmx.jmxComponent)
        .factory('workspace', Jmx.createWorkspace)
        .factory('jmxTreeLazyLoadRegistry', function () { return Core.lazyLoaders; });
    hawtioPluginLoader.addModule(Jmx.jmxModule.name);
    Jmx.log = Logger.get(Jmx.jmxModule.name);
})(Jmx || (Jmx = {}));
// TODO: should be move to Jmx
var Core;
(function (Core) {
    function setupPolling($scope, updateFunction, period, $timeout, jolokia) {
        if (period === void 0) { period = 2000; }
        if ($scope.$hasPoller) {
            Core.log.debug("scope already has polling set up, ignoring subsequent polling request");
            return;
        }
        $scope.$hasPoller = true;
        if (!$timeout) {
            $timeout = HawtioCore.injector.get('$timeout');
        }
        if (!jolokia) {
            try {
                jolokia = HawtioCore.injector.get('jolokia');
            }
            catch (err) {
                // no jolokia service
            }
        }
        var promise = undefined;
        var name = $scope.name || 'anonymous scope';
        var refreshFunction = function () {
            // log.debug("polling for scope: ", name);
            updateFunction(function () {
                var keepPollingFn = $scope.$keepPolling;
                if (!angular.isFunction(keepPollingFn)) {
                    keepPollingFn = function () {
                        if (!jolokia) {
                            return true;
                        }
                        return jolokia.isRunning();
                    };
                }
                if (keepPollingFn() && $scope.$hasPoller) {
                    promise = $timeout(refreshFunction, period);
                }
            });
        };
        if ($scope.$on) {
            $scope.$on('$destroy', function () {
                Core.log.debug("scope", name, " being destroyed, cancelling polling");
                delete $scope.$hasPoller;
                $timeout.cancel(promise);
            });
            $scope.$on('$routeChangeStart', function () {
                Core.log.debug("route changing, cancelling polling for scope: ", name);
                delete $scope.$hasPoller;
                $timeout.cancel(promise);
            });
        }
        return refreshFunction;
    }
    Core.setupPolling = setupPolling;
})(Core || (Core = {}));
/// <reference path="../jmx.module.ts"/>
var Jmx;
(function (Jmx) {
    Jmx.jmxModule.controller("Jmx.ChartEditController", ["$scope", "$location", "workspace", "jolokia", function ($scope, $location, workspace, jolokia) {
            $scope.selectedAttributes = [];
            $scope.selectedMBeans = [];
            $scope.metrics = {};
            $scope.mbeans = {};
            // TODO move this function to $routeScope
            $scope.size = function (value) {
                if (angular.isObject(value)) {
                    return _.keys(value).length;
                }
                else if (angular.isArray(value)) {
                    return value.length;
                }
                else
                    return 1;
            };
            $scope.canViewChart = function () {
                return $scope.selectedAttributes.length && $scope.selectedMBeans.length &&
                    $scope.size($scope.mbeans) > 0 && $scope.size($scope.metrics) > 0;
            };
            $scope.canEditChart = function () {
                // Similar to can view chart, although rules are slightly different for parents
                var result;
                if (workspace.selection && workspace.selection.isFolder()) {
                    // For ENTESB-4165. This is a bit hacky but needed to deal with special conditions like
                    // where there is only a single queue or topic
                    result = $scope.selectedAttributes.length && $scope.selectedMBeans.length &&
                        ($scope.size($scope.mbeans) + $scope.size($scope.metrics) >= 2);
                }
                else {
                    result = $scope.selectedAttributes.length && $scope.selectedMBeans.length &&
                        $scope.size($scope.mbeans) > 0 && $scope.size($scope.metrics) > 0;
                }
                return result;
            };
            $scope.showAttributes = function () {
                return $scope.canViewChart() && $scope.size($scope.metrics) > 1;
            };
            $scope.showElements = function () {
                return $scope.canViewChart() && $scope.size($scope.mbeans) > 1;
            };
            $scope.onSelectedAttributesChange = function () {
                // hack to avoid having an empty array of attributes
                if ($scope.selectedAttributes.length == 0 && $scope.selectedAttributesBackup) {
                    $scope.selectedAttributes = $scope.selectedAttributesBackup;
                }
                else {
                    $scope.selectedAttributesBackup = $scope.selectedAttributes;
                }
            };
            $scope.viewChart = function () {
                // lets add the attributes and mbeans into the URL so we can navigate back to the charts view
                var search = $location.search();
                search["att"] = $scope.selectedAttributes;
                // if we are on an mbean with no children lets discard an unnecessary parameter
                if (!workspace.selection.isFolder() && $scope.selectedMBeans.length === $scope.size($scope.mbeans) && $scope.size($scope.mbeans) === 1) {
                    delete search["el"];
                }
                else {
                    search["el"] = $scope.selectedMBeans;
                }
                search['sub-tab'] = 'jmx-chart';
                $location.search(search);
                $location.path($location.path().replace('/charts/edit', '/charts'));
            };
            $scope.$on("$routeChangeSuccess", function (event, current, previous) {
                // lets do this asynchronously to avoid Error: $digest already in progress
                setTimeout(render, 50);
            });
            function render() {
                var node = workspace.selection;
                if (!angular.isDefined(node) || node === null) {
                    return;
                }
                $scope.selectedAttributes = [];
                $scope.selectedMBeans = [];
                $scope.metrics = {};
                $scope.mbeans = {};
                var mbeanCounter = 0;
                var resultCounter = 0;
                // lets iterate through all the children if the current node is not an mbean
                var children = node.children;
                if (!children || !children.length || node.objectName) {
                    children = [node];
                }
                if (children) {
                    children.forEach(function (mbeanNode) {
                        var mbean = mbeanNode.objectName;
                        var name = mbeanNode.text;
                        if (name && mbean) {
                            mbeanCounter++;
                            $scope.mbeans[name] = name;
                            // use same logic as the JMX attributes page which works better than jolokia.list which has problems with
                            // mbeans with special characters such as ? and query parameters such as Camel endpoint mbeans
                            var asQuery = function (node) {
                                var path = Core.escapeMBeanPath(node);
                                var query = {
                                    type: "list",
                                    path: path,
                                    ignoreErrors: true
                                };
                                return query;
                            };
                            var infoQuery = asQuery(mbean);
                            // must use post, so see further below where we pass in {method: "post"}
                            jolokia.request(infoQuery, Core.onSuccess(function (meta) {
                                var attributes = meta.value.attr;
                                if (attributes) {
                                    for (var key in attributes) {
                                        var value = attributes[key];
                                        if (value) {
                                            var typeName = value['type'];
                                            if (Core.isNumberTypeName(typeName)) {
                                                if (!$scope.metrics[key]) {
                                                    //console.log("Number attribute " + key + " for " + mbean);
                                                    $scope.metrics[key] = key;
                                                }
                                            }
                                        }
                                    }
                                    if (++resultCounter >= mbeanCounter) {
                                        // TODO do we need to sort just in case?
                                        // lets look in the search URI to default the selections
                                        var search = $location.search();
                                        var attributeNames = Core.toSearchArgumentArray(search["att"]);
                                        var elementNames = Core.toSearchArgumentArray(search["el"]);
                                        if (attributeNames && attributeNames.length) {
                                            attributeNames.forEach(function (name) {
                                                if ($scope.metrics[name] && !_.some($scope.selectedAttributes, function (el) { return el === name; })) {
                                                    $scope.selectedAttributes.push(name);
                                                }
                                            });
                                        }
                                        if (elementNames && elementNames.length) {
                                            elementNames.forEach(function (name) {
                                                if ($scope.mbeans[name] && !_.some($scope.selectedAttributes, function (el) { return el === name; })) {
                                                    $scope.selectedMBeans.push(name);
                                                }
                                            });
                                        }
                                        // default selections if there are none
                                        if ($scope.selectedMBeans.length < 1) {
                                            $scope.selectedMBeans = _.keys($scope.mbeans);
                                        }
                                        if ($scope.selectedAttributes.length < 1) {
                                            var attrKeys = _.keys($scope.metrics).sort();
                                            if ($scope.selectedMBeans.length > 1) {
                                                $scope.selectedAttributes = [_.first(attrKeys)];
                                            }
                                            else {
                                                $scope.selectedAttributes = attrKeys;
                                            }
                                        }
                                        // lets update the sizes using jquery as it seems AngularJS doesn't support it
                                        $("#attributes").attr("size", _.keys($scope.metrics).length);
                                        $("#mbeans").attr("size", _.keys($scope.mbeans).length);
                                        Core.$apply($scope);
                                    }
                                }
                                // update the website
                                Core.$apply($scope);
                            }, { method: "post" }));
                        }
                    });
                }
            }
        }]);
})(Jmx || (Jmx = {}));
/// <reference path="../jmx.module.ts"/>
var Jmx;
(function (Jmx) {
    Jmx.jmxModule.controller("Jmx.ChartController", ["$scope", "$element", "$location", "workspace", "localStorage", "jolokiaUrl", "jolokiaParams", function ($scope, $element, $location, workspace, localStorage, jolokiaUrl, jolokiaParams) {
            $scope.title = workspace.selection ? workspace.selection.text : '';
            $scope.metrics = [];
            $scope.updateRate = 1000; //parseInt(localStorage['updateRate']);
            $scope.context = null;
            $scope.jolokia = null;
            $scope.charts = null;
            $scope.edit = function () { return $location.path($location.path().replace('/charts', '/charts/edit')); };
            $scope.reset = function () {
                if ($scope.context) {
                    $scope.context.stop();
                    $scope.context = null;
                }
                if ($scope.jolokia) {
                    $scope.jolokia.stop();
                    $scope.jolokia = null;
                }
                if ($scope.charts) {
                    $scope.charts.empty();
                    $scope.charts = null;
                }
            };
            $scope.$on('$destroy', function () {
                try {
                    $scope.deregRouteChange();
                }
                catch (error) {
                    // ignore
                }
                try {
                    $scope.dereg();
                }
                catch (error) {
                    // ignore
                }
                $scope.reset();
            });
            $scope.errorMessage = function () {
                if ($scope.updateRate === 0) {
                    return "updateRate";
                }
                if ($scope.metrics.length === 0) {
                    return "metrics";
                }
            };
            var doRender = _.debounce(render, 200, { trailing: true });
            $scope.deregRouteChange = $scope.$on("$routeChangeSuccess", function (event, current, previous) {
                // lets do this asynchronously to avoid Error: $digest already in progress
                doRender();
            });
            doRender();
            function render() {
                var node = workspace.selection || workspace.getSelectedMBean();
                if (node == null) {
                    return;
                }
                if (!angular.isDefined(node) || !angular.isDefined($scope.updateRate) || $scope.updateRate === 0) {
                    // Called render too early, let's retry
                    setTimeout(doRender, 500);
                    Core.$apply($scope);
                    return;
                }
                var width = 594;
                var charts = $element.find('#charts');
                if (charts) {
                    width = charts.width();
                }
                else {
                    // Called render too early, let's retry
                    setTimeout(doRender, 500);
                    Core.$apply($scope);
                    return;
                }
                // clear out any existing context
                $scope.reset();
                $scope.charts = charts;
                $scope.jolokia = new Jolokia(jolokiaParams);
                $scope.jolokia.start($scope.updateRate);
                var mbean = node.objectName;
                $scope.metrics = [];
                var context = cubism.context()
                    .serverDelay($scope.updateRate)
                    .clientDelay($scope.updateRate)
                    .step($scope.updateRate)
                    .size(width);
                var horizon = context.horizon();
                horizon.height(40);
                horizon.colors(["#6a96c3", "#83b4d7", "#a6cee6", "#d7e7f0", "#d5eed1", "#abdbac", "#83c798", "#66a780"]);
                $scope.context = context;
                $scope.jolokiaContext = context.jolokia($scope.jolokia);
                var search = $location.search();
                var attributeNames = Core.toSearchArgumentArray(search["att"]);
                if (mbean) {
                    // TODO make generic as we can cache them; they rarely ever change
                    // lets get the attributes for this mbean
                    // use same logic as the JMX attributes page which works better than jolokia.list which has problems with
                    // mbeans with special characters such as ? and query parameters such as Camel endpoint mbeans
                    var asQuery = function (node) {
                        // we need to escape the mbean path for list
                        var path = Core.escapeMBeanPath(node);
                        var query = {
                            type: "list",
                            path: path,
                            ignoreErrors: true
                        };
                        return query;
                    };
                    var infoQuery = asQuery(mbean);
                    // must use post, so see further below where we pass in {method: "post"}
                    var meta = $scope.jolokia.request(infoQuery, { method: "post" });
                    if (meta) {
                        // in case of error then use the default error handler
                        Core.defaultJolokiaErrorHandler(meta, {});
                        var attributes = meta.value ? meta.value.attr : null;
                        if (attributes) {
                            var foundNames = [];
                            for (var key in attributes) {
                                var value = attributes[key];
                                if (value) {
                                    var typeName = value['type'];
                                    if (Core.isNumberTypeName(typeName)) {
                                        foundNames.push(key);
                                    }
                                }
                            }
                            // lets filter the attributes
                            // if we find none then the att search attribute is invalid
                            // so lets discard the filter - as it must be for some other mbean
                            if (attributeNames.length) {
                                var filtered = foundNames.filter(function (key) { return attributeNames.indexOf(key) >= 0; });
                                if (filtered.length) {
                                    foundNames = filtered;
                                }
                            }
                            // sort the names
                            foundNames = foundNames.sort();
                            angular.forEach(foundNames, function (key) {
                                var metric = $scope.jolokiaContext.metric({
                                    type: 'read',
                                    mbean: mbean,
                                    attribute: key
                                }, Core.humanizeValue(key));
                                if (metric) {
                                    $scope.metrics.push(metric);
                                }
                            });
                        }
                    }
                }
                else {
                    // lets try pull out the attributes and elements from the URI and use those to chart
                    var elementNames = Core.toSearchArgumentArray(search["el"]);
                    if (attributeNames && attributeNames.length && elementNames && elementNames.length) {
                        // first lets map the element names to mbean names to keep the URI small
                        var mbeans = {};
                        elementNames.forEach(function (elementName) {
                            var child = node.get(elementName);
                            if (!child && node.children) {
                                child = _.find(node.children, function (n) { return elementName === n["title"]; });
                            }
                            if (child) {
                                var mbean = child.objectName;
                                if (mbean) {
                                    mbeans[elementName] = mbean;
                                }
                            }
                        });
                        // sort the names
                        attributeNames = attributeNames.sort();
                        // lets create the metrics
                        attributeNames.forEach(function (key) {
                            angular.forEach(mbeans, function (mbean, name) {
                                var attributeTitle = Core.humanizeValue(key);
                                // for now lets always be verbose
                                var title = name + ": " + attributeTitle;
                                var metric = $scope.jolokiaContext.metric({
                                    type: 'read',
                                    mbean: mbean,
                                    attribute: key
                                }, title);
                                if (metric) {
                                    $scope.metrics.push(metric);
                                }
                            });
                        });
                    }
                    // if we've children and none of the query arguments matched any metrics
                    // lets redirect back to the edit view
                    if (node.children.length && !$scope.metrics.length) {
                        // lets forward to the chart selection UI if we have some children; they may have
                        // chartable attributes
                        $location.path($location.path().replace('/charts', '/charts/edit'));
                    }
                }
                if ($scope.metrics.length > 0) {
                    var d3Selection = d3.select(charts.get(0));
                    var axisEl = d3Selection.selectAll(".axis");
                    var bail = false;
                    axisEl.data(["top", "bottom"])
                        .enter().append("div")
                        .attr("class", function (d) {
                        return d + " axis";
                    })
                        .each(function (d) {
                        if (bail) {
                            return;
                        }
                        try {
                            d3.select(this).call(context.axis().ticks(12).orient(d));
                        }
                        catch (error) {
                            // still rendering at not the right time...
                            Jmx.log.debug("error:", error);
                            if (!bail) {
                                bail = true;
                            }
                        }
                    });
                    if (bail) {
                        $scope.reset();
                        setTimeout(doRender, 500);
                        Core.$apply($scope);
                        return;
                    }
                    d3Selection.append("div")
                        .attr("class", "rule")
                        .call(context.rule());
                    context.on("focus", function (i) {
                        try {
                            d3Selection.selectAll(".value").style("right", i === null ? null : context.size() - i + "px");
                        }
                        catch (error) {
                            Jmx.log.info("error:", error);
                        }
                    });
                    $scope.metrics.forEach(function (metric) {
                        d3Selection.call(function (div) {
                            div.append("div")
                                .data([metric])
                                .attr("class", "horizon")
                                .call(horizon);
                        });
                    });
                }
                else {
                    $scope.reset();
                }
                Core.$apply($scope);
            }
            ;
        }]);
})(Jmx || (Jmx = {}));
var Jmx;
(function (Jmx) {
    /**
     * @class Folder
     * @uses NodeSelection
     */
    var Folder = /** @class */ (function () {
        function Folder(text) {
            this.text = text;
            this.id = null;
            this.typeName = null;
            this.nodes = [];
            this.folderNames = [];
            this.domain = null;
            this.objectName = null;
            this.entries = {};
            this.class = null;
            this.parent = null;
            this.isLazy = false;
            this.icon = null;
            this.image = null;
            this.tooltip = null;
            this.entity = null;
            this.version = null;
            this.mbean = null;
            this.class = Core.escapeTreeCssStyles(text);
        }
        Object.defineProperty(Folder.prototype, "key", {
            get: function () {
                return this.id;
            },
            set: function (key) {
                this.id = key;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Folder.prototype, "title", {
            get: function () {
                return this.text;
            },
            set: function (title) {
                this.text = title;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Folder.prototype, "children", {
            get: function () {
                return this.nodes;
            },
            set: function (items) {
                this.nodes = items;
            },
            enumerable: true,
            configurable: true
        });
        Object.defineProperty(Folder.prototype, "lazyLoad", {
            get: function () {
                return this.isLazy;
            },
            set: function (isLazy) {
                this.isLazy = isLazy;
            },
            enumerable: true,
            configurable: true
        });
        Folder.prototype.get = function (key) {
            return _.find(this.children, function (child) { return child.text === key; });
        };
        Folder.prototype.isFolder = function () {
            return this.nodes && this.nodes.length > 0;
        };
        /**
         * Navigates the given paths and returns the value there or null if no value could be found
         * @method navigate
         * @for Folder
         * @param {Array} paths
         * @return {NodeSelection}
         */
        Folder.prototype.navigate = function () {
            var paths = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                paths[_i] = arguments[_i];
            }
            return paths.reduce(function (node, path) { return node ? node.get(path) : null; }, this);
        };
        Folder.prototype.hasEntry = function (key, value) {
            var entries = this.entries;
            if (entries) {
                var actual = entries[key];
                return actual && value === actual;
            }
            return false;
        };
        Folder.prototype.parentHasEntry = function (key, value) {
            if (this.parent) {
                return this.parent.hasEntry(key, value);
            }
            return false;
        };
        Folder.prototype.ancestorHasEntry = function (key, value) {
            var parent = this.parent;
            while (parent) {
                if (parent.hasEntry(key, value))
                    return true;
                parent = parent.parent;
            }
            return false;
        };
        Folder.prototype.ancestorHasType = function (typeName) {
            var parent = this.parent;
            while (parent) {
                if (typeName === parent.typeName)
                    return true;
                parent = parent.parent;
            }
            return false;
        };
        Folder.prototype.getOrElse = function (key, defaultValue) {
            if (defaultValue === void 0) { defaultValue = new Folder(key); }
            var answer = this.get(key);
            if (!answer) {
                answer = defaultValue;
                this.children.push(answer);
                answer.parent = this;
            }
            return answer;
        };
        Folder.prototype.sortChildren = function (recursive) {
            var children = this.children;
            if (children) {
                this.children = _.sortBy(children, 'text');
                if (recursive) {
                    angular.forEach(children, function (child) { return child.sortChildren(recursive); });
                }
            }
        };
        Folder.prototype.moveChild = function (child) {
            if (child && child.parent !== this) {
                child.detach();
                child.parent = this;
                this.children.push(child);
            }
        };
        Folder.prototype.insertBefore = function (child, referenceFolder) {
            child.detach();
            child.parent = this;
            var idx = _.indexOf(this.children, referenceFolder);
            if (idx >= 0) {
                this.children.splice(idx, 0, child);
            }
        };
        Folder.prototype.insertAfter = function (child, referenceFolder) {
            child.detach();
            child.parent = this;
            var idx = _.indexOf(this.children, referenceFolder);
            if (idx >= 0) {
                this.children.splice(idx + 1, 0, child);
            }
        };
        /**
         * Removes this node from my parent if I have one
         * @method detach
         * @for Folder
         */
        Folder.prototype.detach = function () {
            var _this = this;
            var oldParent = this.parent;
            if (oldParent) {
                var oldParentChildren = oldParent.children;
                if (oldParentChildren) {
                    var idx = oldParentChildren.indexOf(this);
                    if (idx < 0) {
                        _.remove(oldParent.children, function (child) { return child.key === _this.key; });
                    }
                    else {
                        oldParentChildren.splice(idx, 1);
                    }
                }
                this.parent = null;
            }
        };
        /**
         * Searches this folder and all its descendants for the first folder to match the filter
         * @method findDescendant
         * @for Folder
         * @param {Function} filter
         * @return {Folder}
         */
        Folder.prototype.findDescendant = function (filter) {
            if (filter(this)) {
                return this;
            }
            var answer = null;
            angular.forEach(this.children, function (child) {
                if (!answer) {
                    answer = child.findDescendant(filter);
                }
            });
            return answer;
        };
        /**
         * Searches this folder and all its ancestors for the first folder to match the filter
         * @method findDescendant
         * @for Folder
         * @param {Function} filter
         * @return {Folder}
         */
        Folder.prototype.findAncestor = function (filter) {
            if (filter(this)) {
                return this;
            }
            if (this.parent != null) {
                return this.parent.findAncestor(filter);
            }
            else {
                return null;
            }
        };
        return Folder;
    }());
    Jmx.Folder = Folder;
})(Jmx || (Jmx = {}));
/// <reference path="folder.ts"/>
/// <reference path="../workspace.ts"/>
var Jmx;
(function (Jmx) {
    function findLazyLoadingFunction(workspace, folder) {
        var factories = workspace.jmxTreeLazyLoadRegistry[folder.domain];
        var lazyFunction = null;
        if (factories && factories.length) {
            angular.forEach(factories, function (customLoader) {
                if (!lazyFunction) {
                    lazyFunction = customLoader(folder);
                }
            });
        }
        return lazyFunction;
    }
    Jmx.findLazyLoadingFunction = findLazyLoadingFunction;
    function registerLazyLoadHandler(domain, lazyLoaderFactory) {
        var array = Core.lazyLoaders[domain];
        if (!array) {
            array = [];
            Core.lazyLoaders[domain] = array;
        }
        array.push(lazyLoaderFactory);
    }
    Jmx.registerLazyLoadHandler = registerLazyLoadHandler;
    function unregisterLazyLoadHandler(domain, lazyLoaderFactory) {
        if (Core.lazyLoaders) {
            var array = Core.lazyLoaders[domain];
            if (array) {
                array.remove(lazyLoaderFactory);
            }
        }
    }
    Jmx.unregisterLazyLoadHandler = unregisterLazyLoadHandler;
    function updateTreeSelectionFromURL($location, treeElement, activateIfNoneSelected) {
        if (activateIfNoneSelected === void 0) { activateIfNoneSelected = false; }
        updateTreeSelectionFromURLAndAutoSelect($location, treeElement, null, activateIfNoneSelected);
    }
    Jmx.updateTreeSelectionFromURL = updateTreeSelectionFromURL;
    function updateTreeSelectionFromURLAndAutoSelect($location, treeElement, autoSelect, activateIfNoneSelected) {
        if (activateIfNoneSelected === void 0) { activateIfNoneSelected = false; }
        var tree = treeElement.treeview(true);
        var node;
        // If there is a node id then select that one
        var key = $location.search()['nid'];
        if (key) {
            node = _.find(tree.getNodes(), { id: key });
        }
        // Else optionally select the first node if there is no selection
        if (!node && activateIfNoneSelected && tree.getSelected().length === 0) {
            var children = tree.getNodes();
            if (children.length > 0) {
                node = children[0];
                // invoke any auto select function, and use its result as new first, if any returned
                if (autoSelect) {
                    var result = autoSelect(node);
                    if (result) {
                        node = result;
                    }
                }
            }
        }
        // Finally update the tree with the result node
        if (node) {
            tree.revealNode(node, { silent: true });
            tree.selectNode(node, { silent: false });
            tree.expandNode(node, { levels: 1, silent: true });
        }
        // Word-around to avoid collapsed parent node on re-parenting
        tree.getExpanded().forEach(function (node) { return tree.revealNode(node, { silent: true }); });
    }
    Jmx.updateTreeSelectionFromURLAndAutoSelect = updateTreeSelectionFromURLAndAutoSelect;
    function getUniqueTypeNames(children) {
        var typeNameMap = {};
        angular.forEach(children, function (mbean) {
            var typeName = mbean.typeName;
            if (typeName) {
                typeNameMap[typeName] = mbean;
            }
        });
        // only query if all the typenames are the same
        return Object.keys(typeNameMap);
    }
    Jmx.getUniqueTypeNames = getUniqueTypeNames;
    function enableTree($scope, $location, workspace, treeElement, children) {
        treeElement.treeview({
            lazyLoad: function (node, addNodes) {
                var plugin = Jmx.findLazyLoadingFunction(workspace, node);
                if (plugin) {
                    Jmx.log.debug('Lazy loading folder', node.text);
                    plugin(workspace, node, function (children) { return addNodes(children); });
                }
                // It seems to be required, as the lazyLoad property deletion done
                // by the treeview component does not seem to work
                node.lazyLoad = false;
            },
            onNodeSelected: function (event, node) {
                // We need to clear any selected node state that may leave outside
                // this tree element sub-graph so that the current selection is
                // correctly taken into account when leaving for a wider tree graph,
                // like when leaving the ActiveMQ or Camel trees to go to the JMX tree.
                var clearSelection = function (n) {
                    if (n.state && n.id !== node.id) {
                        n.state.selected = false;
                    }
                    if (n.children) {
                        n.children.forEach(clearSelection);
                    }
                };
                clearSelection(workspace.tree);
                // Expand one level down
                // Lazy loaded node are automatically expanded once the children get added
                if (!node.lazyLoad) {
                    treeElement.treeview('expandNode', [node, { levels: 1, silent: true }]);
                }
                // Update the workspace state
                // The treeview component clones the node passed with the event
                // so let's lookup the original one
                var selection = treeElement.treeview('getSelected')[0];
                workspace.updateSelectionNode(selection);
                Core.$apply($scope);
            },
            levels: 1,
            data: children,
            collapseIcon: 'fa fa-angle-down',
            expandIcon: 'fa fa-angle-right',
            nodeIcon: 'pficon pficon-folder-close',
            showImage: true,
            highlightSearchResults: true,
            searchResultColor: '#b58100',
            searchResultBackColor: '#fbeabc',
            preventUnselect: true
        });
    }
    Jmx.enableTree = enableTree;
})(Jmx || (Jmx = {}));
/// <reference path="jvmPlugin.ts"/>
var JVM;
(function (JVM) {
    JVM._module.controller("JVM.DiscoveryController", ["$scope", "localStorage", "jolokia", function ($scope, localStorage, jolokia) {
            $scope.discovering = true;
            $scope.agents = undefined;
            $scope.$watch('agents', function (newValue, oldValue) {
                if (newValue !== oldValue) {
                    $scope.selectedAgent = _.find($scope.agents, function (a) { return a['selected']; });
                }
            }, true);
            $scope.closePopover = function ($event) {
                $($event.currentTarget).parents('.popover').prev().popover('hide');
            };
            function getMoreJvmDetails(agents) {
                for (var key in agents) {
                    var agent = agents[key];
                    if (agent.url && !agent.secured) {
                        var dedicatedJolokia = JVM.createJolokia(agent.url, agent.username, agent.password);
                        agent.startTime = dedicatedJolokia.getAttribute('java.lang:type=Runtime', 'StartTime');
                        if (!$scope.hasName(agent)) { //only look for command if agent vm is not known
                            agent.command = dedicatedJolokia.getAttribute('java.lang:type=Runtime', 'SystemProperties', 'sun.java.command');
                        }
                    }
                }
            }
            function doConnect(agent) {
                if (!agent.url) {
                    Core.notification('warning', 'No URL available to connect to agent');
                    return;
                }
                var options = JVM.createConnectOptions();
                options.name = agent.agent_description || 'discover-' + agent.agent_id;
                var urlObject = Core.parseUrl(agent.url);
                angular.extend(options, urlObject);
                options.userName = agent.username;
                options.password = agent.password;
                JVM.connectToServer(localStorage, options);
            }
            $scope.connectWithCredentials = function ($event, agent) {
                $scope.closePopover($event);
                doConnect(agent);
            };
            $scope.gotoServer = function ($event, agent) {
                if (agent.secured) {
                    $($event.currentTarget).popover('show');
                }
                else {
                    doConnect(agent);
                }
            };
            $scope.getElementId = function (agent) {
                return agent.agent_id.dasherize().replace(/\./g, "-");
            };
            $scope.getLogo = function (agent) {
                if (agent.server_product) {
                    return JVM.logoRegistry[agent.server_product];
                }
                return JVM.logoRegistry['generic'];
            };
            $scope.filterMatches = function (agent) {
                if (Core.isBlank($scope.filter)) {
                    return true;
                }
                else {
                    var needle = $scope.filter.toLowerCase();
                    var haystack = angular.toJson(agent).toLowerCase();
                    return haystack.indexOf(needle) !== 0;
                }
            };
            $scope.getAgentIdClass = function (agent) {
                if ($scope.hasName(agent)) {
                    return "";
                }
                return "strong";
            };
            $scope.hasName = function (agent) {
                return !!(agent.server_vendor && agent.server_product && agent.server_version);
            };
            $scope.render = function (response) {
                $scope.discovering = false;
                if (response) {
                    var responseJson = angular.toJson(response, true);
                    if ($scope.responseJson !== responseJson) {
                        $scope.responseJson = responseJson;
                        $scope.agents = response;
                        getMoreJvmDetails($scope.agents);
                    }
                }
                Core.$apply($scope);
            };
            $scope.fetch = function () {
                $scope.discovering = true;
                // use 10 sec timeout
                jolokia.execute('jolokia:type=Discovery', 'lookupAgentsWithTimeout(int)', 10 * 1000, Core.onSuccess($scope.render));
            };
            $scope.fetch();
        }]);
})(JVM || (JVM = {}));
/// <reference path="jvmPlugin.ts"/>
var JVM;
(function (JVM) {
    JVM.HeaderController = JVM._module.controller("JVM.HeaderController", ["$scope", "ConnectOptions", function ($scope, ConnectOptions) {
            if (ConnectOptions) {
                $scope.containerName = ConnectOptions.name || "";
                if (ConnectOptions.returnTo) {
                    $scope.goBack = function () {
                        window.location.href = ConnectOptions.returnTo;
                    };
                }
            }
        }]);
})(JVM || (JVM = {}));
/// <reference path="jvmPlugin.ts"/>
/**
 * @module JVM
 */
var JVM;
(function (JVM) {
    JVM._module.controller("JVM.JVMsController", ["$scope", "$location", "localStorage", "workspace", "jolokia", "mbeanName", function ($scope, $location, localStorage, workspace, jolokia, mbeanName) {
            JVM.configureScope($scope, $location, workspace);
            $scope.data = [];
            $scope.deploying = false;
            $scope.status = '';
            $scope.initDone = false;
            $scope.filter = '';
            var listRequest = {
                type: 'exec', mbean: mbeanName,
                operation: 'listLocalJVMs()',
                arguments: []
            };
            $scope.filterMatches = function (jvm) {
                if (Core.isBlank($scope.filter)) {
                    return true;
                }
                else {
                    return jvm.alias.toLowerCase().has($scope.filter.toLowerCase());
                }
            };
            $scope.fetch = function () {
                jolokia.request(listRequest, {
                    success: render,
                    error: function (response) {
                        $scope.data = [];
                        $scope.initDone = true;
                        $scope.status = 'Could not discover local JVM processes: ' + response.error;
                        Core.$apply($scope);
                    }
                });
            };
            $scope.stopAgent = function (pid) {
                jolokia.request([{
                        type: 'exec', mbean: mbeanName,
                        operation: 'stopAgent(java.lang.String)',
                        arguments: [pid]
                    }, listRequest], Core.onSuccess(renderIfList));
            };
            $scope.startAgent = function (pid) {
                jolokia.request([{
                        type: 'exec', mbean: mbeanName,
                        operation: 'startAgent(java.lang.String)',
                        arguments: [pid]
                    }, listRequest], Core.onSuccess(renderIfList));
            };
            $scope.connectTo = function (url, scheme, host, port, path) {
                // we only need the port and path from the url, as we got the rest
                var options = {
                    scheme: scheme,
                    host: host,
                    port: port,
                    path: path
                };
                var con = JVM.createConnectOptions(options);
                con.name = "local-" + port;
                JVM.log.debug("Connecting to local JVM agent: " + url);
                JVM.connectToServer(localStorage, con);
                Core.$apply($scope);
            };
            /**
             * Since the requests are bundled, check the operation in callback to decide on
             * how to respond to success
             */
            function renderIfList(response) {
                if (response.request.operation.indexOf("listLocalJVMs") > -1) {
                    render(response);
                }
            }
            function render(response) {
                $scope.initDone = true;
                $scope.data = response.value;
                if ($scope.data.length === 0) {
                    $scope.status = 'Could not discover local JVM processes';
                }
                Core.$apply($scope);
            }
            $scope.fetch();
        }]);
})(JVM || (JVM = {}));
/// <reference path="./jvmPlugin.ts"/>
var JVM;
(function (JVM) {
    JVM._module.controller("JVM.ResetController", ["$scope", "localStorage", function ($scope, localStorage) {
            $scope.showAlert = false;
            $scope.doClearConnectSettings = function () {
                delete localStorage[JVM.connectionSettingsKey];
                $scope.showAlert = true;
            };
        }]);
})(JVM || (JVM = {}));
var Logs;
(function (Logs) {
    var LogEntry = /** @class */ (function () {
        function LogEntry(event) {
            this.className = event.className;
            this.containerName = event.containerName;
            this.exception = event.exception;
            this.fileName = event.fileName;
            this.hasOSGiProps = LogEntry.hasOSGiProps(event.properties);
            this.hasLogSourceHref = LogEntry.hasLogSourceHref(event.properties);
            this.hasLogSourceLineHref = LogEntry.hasLogSourceLineHref(event.lineNumber);
            this.host = event.host;
            this.level = event.level;
            this.levelClass = LogEntry.getLevelClass(event.level);
            this.lineNumber = event.lineNumber;
            this.logger = event.logger;
            this.logSourceUrl = LogEntry.getLogSourceUrl(event);
            this.methodName = event.methodName;
            this.properties = event.properties;
            this.sanitizedMessage = Core.escapeHtml(event.message);
            this.seq = event.seq;
            this.thread = event.thread;
            this.timestamp = event.timestamp;
        }
        LogEntry.getLevelClass = function (level) {
            switch (level) {
                case 'INFO': return 'text-info';
                case 'WARN': return 'text-warning';
                case 'ERROR': return 'text-danger';
                default: return '';
            }
        };
        ;
        LogEntry.hasOSGiProps = function (properties) {
            return properties && Object.keys(properties).some(function (key) { return key.indexOf('bundle') === 0; });
        };
        ;
        LogEntry.hasLogSourceHref = function (properties) {
            return properties && properties['maven.coordinates'] && properties['maven.coordinates'] !== '';
        };
        LogEntry.hasLogSourceLineHref = function (lineNumber) {
            return lineNumber && lineNumber !== "" && lineNumber !== "?";
        };
        LogEntry.getLogSourceUrl = function (event) {
            var fileName = LogEntry.removeQuestion(event.fileName);
            var className = LogEntry.removeQuestion(event.className);
            var properties = event.properties;
            var mavenCoords = "";
            if (properties) {
                mavenCoords = properties["maven.coordinates"];
            }
            if (mavenCoords && fileName) {
                var link = "#/source/view/" + mavenCoords + "/class/" + className + "/" + fileName;
                var line = event.lineNumber;
                if (line) {
                    link += "?line=" + line;
                }
                return link;
            }
            else {
                return "";
            }
        };
        LogEntry.removeQuestion = function (text) {
            return (!text || text === "?") ? null : text;
        };
        return LogEntry;
    }());
    Logs.LogEntry = LogEntry;
})(Logs || (Logs = {}));
/// <reference path="log-entry.ts"/>
var Logs;
(function (Logs) {
    var LogsService = /** @class */ (function () {
        LogsService.$inject = ["$q", "jolokiaService", "localStorage", "workspace"];
        function LogsService($q, jolokiaService, localStorage, workspace) {
            'ngInject';
            this.$q = $q;
            this.jolokiaService = jolokiaService;
            this.localStorage = localStorage;
            this.workspace = workspace;
        }
        LogsService.prototype.getLogQueryMBean = function () {
            return this.workspace.findMBeanWithProperties('hawtio', { type: 'LogQuery' });
        };
        LogsService.prototype.isValid = function () {
            var logQueryMBean = this.getLogQueryMBean();
            return logQueryMBean && this.workspace.hasInvokeRightsForName(logQueryMBean.objectName, 'getLogResults(int)');
        };
        LogsService.prototype.getInitialLogs = function () {
            return this.getLogs('getLogResults(int)', this.getLogCacheSize());
        };
        LogsService.prototype.getMoreLogs = function (fromTimestamp) {
            return this.getLogs('jsonQueryLogResults', { afterTimestamp: fromTimestamp, count: this.getLogBatchSize() });
        };
        LogsService.prototype.getLogs = function (operation, arg1) {
            var objectName = this.getLogQueryMBean().objectName;
            return this.jolokiaService.execute(objectName, operation, arg1)
                .then(function (response) {
                response.logEntries = response.events ? response.events.map(function (event) { return new Logs.LogEntry(event); }) : [];
                return response;
            });
        };
        LogsService.prototype.appendLogs = function (logs, logEntries) {
            logs.push.apply(logs, logEntries);
            var logCacheSize = this.getLogCacheSize();
            if (logs.length > logCacheSize) {
                logs.splice(0, logs.length - logCacheSize);
            }
            return logs;
        };
        LogsService.prototype.filterLogs = function (logs, filterConfig) {
            var filteredLogs = logs.slice();
            filterConfig.appliedFilters.forEach(function (filter) {
                switch (filter.id) {
                    case 'level':
                        filteredLogs = filteredLogs.filter(function (log) { return log.level === filter.value; });
                        break;
                    case 'logger':
                        filteredLogs = filteredLogs.filter(function (log) { return log.logger.indexOf(filter.value) !== -1; });
                        break;
                    case 'message':
                        filteredLogs = filteredLogs.filter(function (log) {
                            return log.sanitizedMessage.toLowerCase().indexOf(filter.value.toLowerCase()) !== -1;
                        });
                        break;
                }
            });
            if (!this.isLogSortAsc()) {
                filteredLogs = filteredLogs.reverse();
            }
            filterConfig.totalCount = logs.length;
            filterConfig.resultsCount = filteredLogs.length;
            return filteredLogs;
        };
        LogsService.prototype.isLogSortAsc = function () {
            var logSortAsc = this.localStorage.getItem('logSortAsc');
            return logSortAsc !== 'false';
        };
        LogsService.prototype.isLogAutoScroll = function () {
            var logAutoScroll = this.localStorage.getItem('logAutoScroll');
            return logAutoScroll !== 'false';
        };
        LogsService.prototype.getLogCacheSize = function () {
            var logCacheSize = this.localStorage.getItem('logCacheSize');
            return logCacheSize !== null ? parseInt(logCacheSize) : 500;
        };
        LogsService.prototype.getLogBatchSize = function () {
            var logBatchSize = this.localStorage.getItem('logBatchSize');
            return logBatchSize !== null ? parseInt(logBatchSize) : 20;
        };
        return LogsService;
    }());
    Logs.LogsService = LogsService;
})(Logs || (Logs = {}));
/// <reference path="../logs/logs.service.ts"/>
var Logs;
(function (Logs) {
    configureLogsPreferences.$inject = ["preferencesRegistry", "logsService"];
    function configureLogsPreferences(preferencesRegistry, logsService) {
        'ngInject';
        preferencesRegistry.addTab("Server Logs", "plugins/logs/html/logs-preferences.html", function () { return logsService.isValid(); });
    }
    Logs.configureLogsPreferences = configureLogsPreferences;
})(Logs || (Logs = {}));
var Logs;
(function (Logs) {
    LogsPreferencesController.$inject = ["$scope", "localStorage"];
    function LogsPreferencesController($scope, localStorage) {
        'ngInject';
        // Initialize tooltips
        $('[data-toggle="tooltip"]').tooltip();
        Core.initPreferenceScope($scope, localStorage, {
            'logSortAsc': {
                'value': true,
                'converter': Core.parseBooleanValue
            },
            'logAutoScroll': {
                'value': true,
                'converter': Core.parseBooleanValue
            },
            'logCacheSize': {
                'value': 500,
                'converter': parseInt
            },
            'logBatchSize': {
                'value': 20,
                'converter': parseInt
            }
        });
    }
    Logs.LogsPreferencesController = LogsPreferencesController;
})(Logs || (Logs = {}));
/// <reference path="logs-preferences.config.ts"/>
/// <reference path="logs-preferences.controller.ts"/>
var Logs;
(function (Logs) {
    Logs.logsPreferencesModule = angular.module('hawtio-logs-preferences', [])
        .run(Logs.configureLogsPreferences)
        .controller('LogsPreferencesController', Logs.LogsPreferencesController)
        .name;
})(Logs || (Logs = {}));
var Logs;
(function (Logs) {
    var LogModalController = /** @class */ (function () {
        function LogModalController() {
        }
        Object.defineProperty(LogModalController.prototype, "logEntry", {
            get: function () {
                return this.resolve.logEntry;
            },
            enumerable: true,
            configurable: true
        });
        return LogModalController;
    }());
    Logs.LogModalController = LogModalController;
    Logs.logModalComponent = {
        bindings: {
            resolve: '<',
            close: '&'
        },
        template: "\n      <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" aria-label=\"Close\" ng-click=\"$ctrl.close()\">\n          <span class=\"pficon pficon-close\" aria-hidden=\"true\"></span>\n        </button>\n        <h4 class=\"modal-title\">Log</h4>\n      </div>\n      <div class=\"modal-body\">\n        <dl class=\"dl-horizontal\">\n          <dt>Timestamp</dt>\n          <dd>{{$ctrl.logEntry | logDateFilter}}</dd>\n          <dt>Level</dt>\n          <dd class=\"{{$ctrl.logEntry.levelClass}}\">{{$ctrl.logEntry.level}}</dd>\n          <dt>Logger</dt>\n          <dd>{{$ctrl.logEntry.logger}}</dd>\n          <div ng-show=\"$ctrl.logEntry.hasLogSourceLineHref\">\n            <dt>Class</dt>\n            <dd>{{$ctrl.logEntry.className}}</dd>\n            <dt>Method</dt>\n            <dd>{{$ctrl.logEntry.methodName}}</dd>\n            <dt>File</dt>\n            <dd>{{$ctrl.logEntry.fileName}}:{{$ctrl.logEntry.lineNumber}}</dd>\n          </div>\n          <div ng-show=\"$ctrl.logEntry.host\">\n            <dt>Host</dt>\n            <dd>{{$ctrl.logEntry.host}}</dd>\n          </div>\n          <dt>Thread</dt>\n          <dd>{{$ctrl.logEntry.thread}}</dd>\n          <div ng-show=\"$ctrl.logEntry.hasOSGiProps\">\n            <div ng-show=\"$ctrl.logEntry.properties['bundle.name']\">\n              <dt>Bundle Name</dt>\n              <dd>{{$ctrl.logEntry.properties['bundle.name']}}</dd>\n            </div>\n            <div ng-show=\"$ctrl.logEntry.properties['bundle.id']\">\n              <dt>Bundle ID</dt>\n              <dd>{{$ctrl.logEntry.properties['bundle.id']}}</dd>\n            </div>\n            <div ng-show=\"$ctrl.logEntry.properties['bundle.version']\">\n              <dt>Bundle Version</dt>\n              <dd>{{$ctrl.logEntry.properties['bundle.version']}}</dd>\n            </div>\n          </div>\n          <dt>Message</dt>\n          <dd ng-bind-html=\"$ctrl.logEntry.sanitizedMessage\"></dd>\n        </dl>\n        <dl ng-if=\"$ctrl.logEntry.exception\">\n          <dt>Stack Trace</dt>\n          <dd>\n            <ul class=\"list-unstyled\">\n              <li ng-repeat=\"frame in $ctrl.logEntry.exception\" class=\"log-jmx-stacktrace-list-item\">{{frame}}</li>\n            </ul>\n          </dd>\n        </dl>\n      </div>\n    ",
        controller: LogModalController
    };
})(Logs || (Logs = {}));
/// <reference path="logs.service.ts"/>
/// <reference path="log-entry.ts"/>
var Logs;
(function (Logs) {
    var UPDATE_INTERVAL_MILLIS = 5000;
    var LogsController = /** @class */ (function () {
        LogsController.$inject = ["$timeout", "$uibModal", "logsService"];
        function LogsController($timeout, $uibModal, logsService) {
            'ngInject';
            this.$timeout = $timeout;
            this.$uibModal = $uibModal;
            this.logsService = logsService;
            this.logs = [];
            this.filteredLogs = [];
            this.messageSearchText = [];
            this.toolbarConfig = {
                filterConfig: {
                    fields: [
                        {
                            id: 'level',
                            title: 'Level',
                            placeholder: 'Filter by level...',
                            filterType: 'select',
                            filterValues: ['TRACE', 'DEBUG', 'INFO', 'WARN', 'ERROR']
                        },
                        {
                            id: 'logger',
                            title: 'Logger',
                            placeholder: 'Filter by logger...',
                            filterType: 'text'
                        },
                        {
                            id: 'message',
                            title: 'Message',
                            placeholder: 'Filter by message...',
                            filterType: 'text'
                        }
                    ],
                    totalCount: this.logs.length,
                    resultsCount: this.filteredLogs.length,
                    appliedFilters: [],
                    onFilterChange: this.onFilterChange
                },
                isTableView: true
            };
            this.scrollableTable = null;
        }
        LogsController.prototype.$onInit = function () {
            var _this = this;
            this.scrollableTable = document.querySelector('.log-jmx-scrollable-table');
            this.logsService.getInitialLogs()
                .then(function (response) { return _this.processLogEntries(response); });
        };
        LogsController.prototype.onFilterChange = function (filters) {
            var tableScrolled = this.isTableScrolled();
            this.removePreviousLevelFilter(filters);
            this.messageSearchText = this.getMessageFilterValues(filters);
            this.filteredLogs = this.logsService.filterLogs(this.logs, this);
            if (tableScrolled) {
                this.scrollTable();
            }
        };
        LogsController.prototype.removePreviousLevelFilter = function (filters) {
            _.remove(filters, function (filter, index) { return filter.id === 'level' && index < filters.length - 1 &&
                filters[filters.length - 1].id === 'level'; });
        };
        LogsController.prototype.getMessageFilterValues = function (filters) {
            return filters.filter(function (filter) { return filter.id === 'message'; }).map(function (filter) { return filter.value; });
        };
        ;
        LogsController.prototype.openLogModal = function (logEntry) {
            this.$uibModal.open({
                component: 'logModal',
                size: 'lg',
                resolve: { logEntry: logEntry }
            });
        };
        LogsController.prototype.processLogEntries = function (response) {
            if (response.logEntries.length > 0) {
                var tableScrolled = this.isTableScrolled();
                this.logsService.appendLogs(this.logs, response.logEntries);
                this.filteredLogs = this.logsService.filterLogs(this.logs, this.toolbarConfig.filterConfig);
                if (tableScrolled) {
                    this.scrollTable();
                }
            }
            this.scheduleNextRequest(response.toTimestamp);
        };
        LogsController.prototype.scheduleNextRequest = function (fromTimestamp) {
            var _this = this;
            this.$timeout(function () {
                _this.logsService.getMoreLogs(fromTimestamp)
                    .then(function (response) { return _this.processLogEntries(response); });
            }, UPDATE_INTERVAL_MILLIS);
        };
        LogsController.prototype.isTableScrolled = function () {
            if (this.logsService.isLogSortAsc()) {
                return this.scrollableTable.scrollHeight - this.scrollableTable.scrollTop === this.scrollableTable.clientHeight;
            }
            else {
                return this.scrollableTable.scrollTop === 0;
            }
        };
        LogsController.prototype.scrollTable = function () {
            var _this = this;
            if (this.logsService.isLogAutoScroll()) {
                if (this.logsService.isLogSortAsc()) {
                    this.$timeout(function () { return _this.scrollableTable.scrollTop = _this.scrollableTable.scrollHeight - _this.scrollableTable.clientHeight; }, 0);
                }
                else {
                    this.$timeout(function () { return _this.scrollableTable.scrollTop = 0; }, 0);
                }
            }
        };
        return LogsController;
    }());
    Logs.LogsController = LogsController;
    Logs.logsComponent = {
        template: "\n      <div class=\"log-jmx-main\">\n        <div class=\"log-jmx-flex-container\">\n          <div class=\"log-jmx-fixed-toolbar\">\n            <h1>Logs</h1>\n            <p ng-show=\"$ctrl.logs.length === 0\">Loading...</p>\n            <div ng-show=\"$ctrl.logs.length > 0\">\n              <pf-toolbar config=\"$ctrl.toolbarConfig\"></pf-toolbar>\n              <table class=\"table table-striped log-jmx-header-table\">\n                <thead>\n                  <tr>\n                    <th>Timestamp</th>\n                    <th>Level</th>\n                    <th>Logger</th>\n                    <th>Message</th>\n                  </tr>\n                </thead>\n              </table>\n            </div>\n          </div>\n          <div class=\"log-jmx-scrollable-table\" ng-show=\"$ctrl.logs.length > 0\">\n            <table class=\"table table-striped\">\n              <tbody>\n                <tr ng-repeat=\"logEntry in $ctrl.filteredLogs\">\n                  <td>{{logEntry | logDateFilter}}</td>\n                  <td class=\"{{logEntry.levelClass}}\">{{logEntry.level}}</td>\n                  <td ng-switch=\"logEntry.hasLogSourceHref\">\n                    <a href=\"\" ng-switch-when=\"true\" ng-click=\"$ctrl.openLogModal(logEntry)\">{{logEntry.logger}}</a>\n                    <span ng-switch-default>{{logEntry.logger}}</span>\n                  </td>\n                  <td ng-bind-html=\"logEntry.sanitizedMessage | highlight:$ctrl.messageSearchText\"></td>\n                </tr>\n              </tbody>\n            </table>\n          </div>\n        </div>\n      </div>\n    ",
        controller: LogsController
    };
})(Logs || (Logs = {}));
/// <reference path="logs.service.ts"/>
var Logs;
(function (Logs) {
    configureLogsRoutes.$inject = ["$routeProvider"];
    configureLogsHelp.$inject = ["helpRegistry", "logsService"];
    configureLogsMainNav.$inject = ["mainNavService", "logsService"];
    function configureLogsRoutes($routeProvider) {
        'ngInject';
        $routeProvider.when('/logs', { template: '<logs></logs>' });
    }
    Logs.configureLogsRoutes = configureLogsRoutes;
    function configureLogsHelp(helpRegistry, logsService) {
        'ngInject';
        helpRegistry.addUserDoc('log', 'plugins/logs/doc/help.md', function () { return logsService.isValid(); });
    }
    Logs.configureLogsHelp = configureLogsHelp;
    function configureLogsMainNav(mainNavService, logsService) {
        'ngInject';
        mainNavService.addItem({
            title: 'Logs',
            href: '/logs',
            isValid: function () { return logsService.isValid(); },
            rank: -1
        });
    }
    Logs.configureLogsMainNav = configureLogsMainNav;
})(Logs || (Logs = {}));
var Logs;
(function (Logs) {
    logDateFilter.$inject = ["$filter"];
    function logDateFilter($filter) {
        'ngInject';
        var standardDateFilter = $filter('date');
        return function (log) {
            if (!log) {
                return null;
            }
            // if there is a seq in the reply, then its the timestamp with milli seconds
            if (log.seq) {
                return standardDateFilter(log.seq, 'yyyy-MM-dd HH:mm:ss.sss');
            }
            else {
                return standardDateFilter(log.timestamp, 'yyyy-MM-dd HH:mm:ss');
            }
        };
    }
    Logs.logDateFilter = logDateFilter;
    /**
     * @param text {string} haystack to search through
     * @param search {string} needle to search for
     * @param [caseSensitive] {boolean} optional boolean to use case-sensitive searching
     */
    function highlight() {
        return function (text, searches, caseSensitive) {
            searches.forEach(function (search) {
                text = text.toString();
                search = search.toString();
                if (caseSensitive) {
                    text = text.split(search).join('<mark>' + search + '</mark>');
                }
                else {
                    text = text.replace(new RegExp(search, 'gi'), '<mark>$&</mark>');
                }
            });
            return text;
        };
    }
    Logs.highlight = highlight;
})(Logs || (Logs = {}));
/// <reference path="log-modal.component.ts"/>
/// <reference path="logs.component.ts"/>
/// <reference path="logs.config.ts"/>
/// <reference path="logs.filters.ts"/>
/// <reference path="logs.service.ts"/>
var Logs;
(function (Logs) {
    Logs.logsModule = angular.module('hawtio-logs-logs', [])
        .config(Logs.configureLogsRoutes)
        .run(Logs.configureLogsHelp)
        .run(Logs.configureLogsMainNav)
        .filter('logDateFilter', Logs.logDateFilter)
        .filter('highlight', Logs.highlight)
        .component('logs', Logs.logsComponent)
        .component('logModal', Logs.logModalComponent)
        .service('logsService', Logs.LogsService)
        .name;
})(Logs || (Logs = {}));
/// <reference path="logs-preferences/logs-preferences.module.ts"/>
/// <reference path="logs/logs.module.ts"/>
var Logs;
(function (Logs) {
    var module = angular.module('hawtio-logs', [
        Logs.logsModule,
        Logs.logsPreferencesModule
    ])
        .name;
    hawtioPluginLoader.addModule(module);
})(Logs || (Logs = {}));
var RBAC;
(function (RBAC) {
    var JmxTreeProcessor = /** @class */ (function () {
        function JmxTreeProcessor(jolokia, jolokiaStatus, rbacTasks, workspace) {
            this.jolokia = jolokia;
            this.jolokiaStatus = jolokiaStatus;
            this.rbacTasks = rbacTasks;
            this.workspace = workspace;
        }
        JmxTreeProcessor.prototype.process = function (tree) {
            var _this = this;
            RBAC.log.debug("Processing tree", tree);
            this.rbacTasks.getACLMBean().then(function (aclMBean) {
                var mbeans = {};
                _this.flattenMBeanTree(mbeans, tree);
                var listMethod = _this.jolokiaStatus.listMethod;
                switch (listMethod) {
                    case JVM.JolokiaListMethod.LIST_WITH_RBAC:
                        RBAC.log.debug("Process JMX tree: list with RBAC mode");
                        _this.processWithRBAC(mbeans);
                        RBAC.log.debug("Processed tree mbeans with RBAC", mbeans);
                        break;
                    case JVM.JolokiaListMethod.LIST_GENERAL:
                    case JVM.JolokiaListMethod.LIST_CANT_DETERMINE:
                    default:
                        RBAC.log.debug("Process JMX tree: general mode");
                        _this.processGeneral(aclMBean, mbeans);
                        RBAC.log.debug("Processed tree mbeans", mbeans);
                        break;
                }
            });
        };
        JmxTreeProcessor.prototype.flattenMBeanTree = function (mbeans, tree) {
            var _this = this;
            if (!Core.isBlank(tree.objectName)) {
                mbeans[tree.objectName] = tree;
            }
            if (tree.isFolder()) {
                tree.children.forEach(function (child) { return _this.flattenMBeanTree(mbeans, child); });
            }
        };
        JmxTreeProcessor.prototype.processWithRBAC = function (mbeans) {
            var _this = this;
            // we already have everything related to RBAC in place, except 'class' property
            _.forEach(mbeans, function (node, mbeanName) {
                var mbean = node.mbean;
                var canInvoke = mbean && (_.isNil(mbean.canInvoke) || mbean.canInvoke);
                _this.addCanInvokeToClass(node, canInvoke);
            });
        };
        JmxTreeProcessor.prototype.processGeneral = function (aclMBean, mbeans) {
            var _this = this;
            var requests = [];
            var bulkRequest = {};
            _.forEach(mbeans, function (mbean, mbeanName) {
                if (!('canInvoke' in mbean)) {
                    requests.push({
                        type: 'exec',
                        mbean: aclMBean,
                        operation: 'canInvoke(java.lang.String)',
                        arguments: [mbeanName]
                    });
                    if (mbean.mbean && mbean.mbean.op) {
                        var ops = mbean.mbean.op;
                        mbean.mbean.opByString = {};
                        var opList_1 = [];
                        _.forEach(ops, function (op, opName) {
                            if (_.isArray(op)) {
                                _.forEach(op, function (op) { return _this.addOperation(mbean, opList_1, opName, op); });
                            }
                            else {
                                _this.addOperation(mbean, opList_1, opName, op);
                            }
                        });
                        bulkRequest[mbeanName] = opList_1;
                    }
                }
            });
            requests.push({
                type: 'exec',
                mbean: aclMBean,
                operation: 'canInvoke(java.util.Map)',
                arguments: [bulkRequest]
            });
            this.jolokia.request(requests, Core.onSuccess(function (response) {
                var mbean = response.request.arguments[0];
                if (mbean && _.isString(mbean)) {
                    var canInvoke = response.value;
                    mbeans[mbean]['canInvoke'] = response.value;
                    _this.addCanInvokeToClass(mbeans[mbean], canInvoke);
                }
                else {
                    var responseMap = response.value;
                    _.forEach(responseMap, function (operations, mbeanName) {
                        _.forEach(operations, function (data, operationName) {
                            mbeans[mbeanName].mbean.opByString[operationName]['canInvoke'] = data['CanInvoke'];
                        });
                    });
                }
            }, { error: function (response) { } }));
        };
        JmxTreeProcessor.prototype.addOperation = function (mbean, opList, opName, op) {
            var operationString = Core.operationToString(opName, op.args);
            // enrich the mbean by indexing the full operation string so we can easily look it up later
            mbean.mbean.opByString[operationString] = op;
            opList.push(operationString);
        };
        JmxTreeProcessor.prototype.addCanInvokeToClass = function (mbean, canInvoke) {
            var toAdd = canInvoke ? "can-invoke" : "cant-invoke";
            mbean['class'] = this.stripClasses(mbean['class']);
            mbean['class'] = this.addClass(mbean['class'], toAdd);
            if (!canInvoke) {
                // change the tree node icon to lock here
                mbean.icon = 'fa fa-lock';
            }
        };
        JmxTreeProcessor.prototype.stripClasses = function (css) {
            if (Core.isBlank(css)) {
                return css;
            }
            var parts = css.split(" ");
            var answer = [];
            parts.forEach(function (part) {
                if (part !== "can-invoke" && part !== "cant-invoke") {
                    answer.push(part);
                }
            });
            return answer.join(" ").trim();
        };
        JmxTreeProcessor.prototype.addClass = function (css, _class) {
            if (Core.isBlank(css)) {
                return _class;
            }
            var parts = css.split(" ");
            parts.push(_class);
            return _.uniq(parts).join(" ").trim();
        };
        return JmxTreeProcessor;
    }());
    RBAC.JmxTreeProcessor = JmxTreeProcessor;
})(RBAC || (RBAC = {}));
/// <reference path="../../jmx/ts/workspace.ts"/>
var RBAC;
(function (RBAC) {
    var MBEAN_ONLY = 'canInvoke(java.lang.String)';
    var OVERLOADED_METHOD = 'canInvoke(java.lang.String,java.lang.String)';
    var EXACT_METHOD = 'canInvoke(java.lang.String,java.lang.String,[Ljava.lang.String;)';
    var HIDE = 'hide';
    var REMOVE = 'remove';
    var INVERSE = 'inverse';
    /**
     * Directive that sets an element's visibility to hidden if the user cannot invoke the supplied operation
     */
    var HawtioShow = /** @class */ (function () {
        function HawtioShow(workspace) {
            this.workspace = workspace;
            this.restrict = 'A';
        }
        HawtioShow.factory = ["workspace", function (workspace) {
            'ngInject';
            return new HawtioShow(workspace);
        }];
        HawtioShow.prototype.link = function (scope, element, attr) {
            var _this = this;
            var objectName = attr['objectName'];
            var objectNameModel = attr['objectNameModel'];
            RBAC.log.debug("hawtio-show: object-name=", objectName, "object-name-model=", objectNameModel);
            if (!objectName && !objectNameModel) {
                return;
            }
            if (objectName) {
                this.applyInvokeRights(element, objectName, attr);
            }
            else {
                scope.$watch(objectNameModel, function (newValue, oldValue) {
                    if (newValue && newValue !== oldValue) {
                        _this.applyInvokeRights(element, newValue, attr);
                    }
                });
            }
        };
        HawtioShow.prototype.applyInvokeRights = function (element, objectName, attr) {
            var methodName = attr['methodName'];
            var argumentTypes = attr['argumentTypes'];
            var mode = attr['mode'] || HIDE;
            var canInvokeOp = this.getCanInvokeOperation(methodName, argumentTypes);
            var args = this.getArguments(canInvokeOp, objectName, methodName, argumentTypes);
            var mbean = Core.parseMBean(objectName);
            var folder = this.workspace.findMBeanWithProperties(mbean.domain, mbean.attributes);
            if (!folder) {
                return;
            }
            var invokeRights = methodName ?
                this.workspace.hasInvokeRights(folder, methodName) :
                this.workspace.hasInvokeRights(folder);
            this.changeDisplay(element, invokeRights, mode);
        };
        HawtioShow.prototype.getCanInvokeOperation = function (methodName, argumentTypes) {
            var answer = MBEAN_ONLY;
            if (!Core.isBlank(methodName)) {
                answer = OVERLOADED_METHOD;
            }
            if (!Core.isBlank(argumentTypes)) {
                answer = EXACT_METHOD;
            }
            return answer;
        };
        HawtioShow.prototype.getArguments = function (canInvokeOp, objectName, methodName, argumentTypes) {
            var args = [];
            if (canInvokeOp === MBEAN_ONLY) {
                args.push(objectName);
            }
            else if (canInvokeOp === OVERLOADED_METHOD) {
                args.push(objectName);
                args.push(methodName);
            }
            else if (canInvokeOp === EXACT_METHOD) {
                args.push(objectName);
                args.push(methodName);
                args.push(argumentTypes.split(',').map(function (s) { return s.trim(); }));
            }
            return args;
        };
        HawtioShow.prototype.changeDisplay = function (element, invokeRights, mode) {
            if (invokeRights) {
                if (mode === INVERSE) {
                    element.css({ display: 'none' });
                }
            }
            else {
                if (mode === REMOVE) {
                    element.css({ display: 'none' });
                }
                else if (mode === HIDE) {
                    element.css({ visibility: 'hidden' });
                }
            }
        };
        return HawtioShow;
    }());
    RBAC.HawtioShow = HawtioShow;
})(RBAC || (RBAC = {}));
/// <reference path="models.ts"/>
var RBAC;
(function (RBAC) {
    var RBACTasksFactory = /** @class */ (function () {
        function RBACTasksFactory() {
        }
        RBACTasksFactory.create = ["postLoginTasks", "jolokia", "$q", function (postLoginTasks, jolokia, $q) {
            'ngInject';
            var rbacTasks = new RBACTasksImpl($q.defer());
            postLoginTasks.addTask("FetchJMXSecurityMBeans", function () { return rbacTasks.fetchJMXSecurityMBeans(jolokia); });
            return rbacTasks;
        }];
        return RBACTasksFactory;
    }());
    RBAC.RBACTasksFactory = RBACTasksFactory;
    var RBACACLMBeanFactory = /** @class */ (function () {
        function RBACACLMBeanFactory() {
        }
        RBACACLMBeanFactory.create = ["rbacTasks", function (rbacTasks) {
            'ngInject';
            return rbacTasks.getACLMBean();
        }];
        return RBACACLMBeanFactory;
    }());
    RBAC.RBACACLMBeanFactory = RBACACLMBeanFactory;
    var RBACTasksImpl = /** @class */ (function (_super) {
        __extends(RBACTasksImpl, _super);
        function RBACTasksImpl(deferred) {
            var _this = _super.call(this, "RBAC") || this;
            _this.deferred = deferred;
            _this.ACLMBean = null;
            return _this;
        }
        RBACTasksImpl.prototype.fetchJMXSecurityMBeans = function (jolokia) {
            var _this = this;
            jolokia.request({ type: 'search', mbean: '*:type=security,area=jmx,*' }, Core.onSuccess(function (response) {
                RBAC.log.debug("Fetching JMXSecurity MBeans...", response);
                var mbeans = response.value;
                var chosen = "";
                if (mbeans.length === 0) {
                    RBAC.log.info("Didn't discover any JMXSecurity mbeans, client-side role based access control is disabled");
                }
                else if (mbeans.length === 1) {
                    chosen = mbeans[0];
                }
                else if (mbeans.length > 1) {
                    var picked_1 = false;
                    mbeans.forEach(function (mbean) {
                        if (picked_1) {
                            return;
                        }
                        if (_.includes(mbean, "HawtioDummy")) {
                            return;
                        }
                        if (!_.includes(mbean, "rank=")) {
                            chosen = mbean;
                            picked_1 = true;
                        }
                    });
                }
                if (chosen != null && chosen != "") {
                    RBAC.log.info("Using mbean", chosen, "for client-side role based access control");
                }
                else {
                    RBAC.log.info("Didn't discover any effective JMXSecurity mbeans, client-side role based access control is disabled");
                }
                _this.initialize(chosen);
            }));
        };
        RBACTasksImpl.prototype.initialize = function (mbean) {
            this.ACLMBean = mbean;
            this.deferred.resolve(this.ACLMBean);
            _super.prototype.execute.call(this);
        };
        RBACTasksImpl.prototype.getACLMBean = function () {
            return this.deferred.promise;
        };
        return RBACTasksImpl;
    }(Core.Tasks));
})(RBAC || (RBAC = {}));
/**
 * @namespace RBAC
 * @main RBAC
 */
/// <reference path="../../jmx/ts/workspace.ts"/>
/// <reference path="../../jvm/ts/jolokia/jolokiaService.ts"/>
/// <reference path="models.ts"/>
/// <reference path="rbac.directive.ts"/>
/// <reference path="rbac.service.ts"/>
/// <reference path="jmxTreeProcessor.ts"/>
var RBAC;
(function (RBAC) {
    addTreePostProcessor.$inject = ["jolokia", "jolokiaStatus", "rbacTasks", "preLogoutTasks", "workspace"];
    RBAC.pluginName = "hawtio-jmx-rbac";
    RBAC.log = Logger.get(RBAC.pluginName);
    angular
        .module(RBAC.pluginName, [])
        .directive('hawtioShow', RBAC.HawtioShow.factory)
        .service('rbacTasks', RBAC.RBACTasksFactory.create)
        .service('rbacACLMBean', RBAC.RBACACLMBeanFactory.create)
        .run(addTreePostProcessor);
    var TREE_POSTPROCESSOR_NAME = "rbacTreePostprocessor";
    function addTreePostProcessor(jolokia, jolokiaStatus, rbacTasks, preLogoutTasks, workspace) {
        'ngInject';
        preLogoutTasks.addTask("ResetRBAC", function () {
            RBAC.log.debug("Resetting RBAC tasks");
            rbacTasks.reset();
            workspace.removeNamedTreePostProcessor(TREE_POSTPROCESSOR_NAME);
        });
        // add info to the JMX tree if we have access to invoke on mbeans or not
        var processor = new RBAC.JmxTreeProcessor(jolokia, jolokiaStatus, rbacTasks, workspace);
        rbacTasks.addTask("JMXTreePostProcess", function () { return workspace.addNamedTreePostProcessor(TREE_POSTPROCESSOR_NAME, function (tree) { return processor.process(tree); }); });
    }
    hawtioPluginLoader.addModule(RBAC.pluginName);
})(RBAC || (RBAC = {}));
var Runtime;
(function (Runtime) {
    var RuntimeService = /** @class */ (function () {
        RuntimeService.$inject = ["workspace"];
        function RuntimeService(workspace) {
            'ngInject';
            this.workspace = workspace;
        }
        RuntimeService.prototype.getTabs = function () {
            var tabs = [
                new Nav.HawtioTab('System Properties', '/runtime/sysprops'),
                new Nav.HawtioTab('Metrics', '/runtime/metrics')
            ];
            if (this.workspace.treeContainsDomainAndProperties('java.lang', { type: 'Threading' })) {
                tabs.push(new Nav.HawtioTab('Threads', '/runtime/threads'));
            }
            return tabs;
        };
        return RuntimeService;
    }());
    Runtime.RuntimeService = RuntimeService;
})(Runtime || (Runtime = {}));
/// <reference path="runtime.service.ts"/>
var Runtime;
(function (Runtime) {
    var RuntimeController = /** @class */ (function () {
        RuntimeController.$inject = ["runtimeService"];
        function RuntimeController(runtimeService) {
            'ngInject';
            this.runtimeService = runtimeService;
        }
        RuntimeController.prototype.$onInit = function () {
            this.tabs = this.runtimeService.getTabs();
        };
        return RuntimeController;
    }());
    Runtime.RuntimeController = RuntimeController;
    Runtime.runtimeComponent = {
        template: '<hawtio-tabs-layout tabs="$ctrl.tabs"></hawtio-tabs-layout>',
        controller: RuntimeController
    };
})(Runtime || (Runtime = {}));
/// <reference path="../jmx/ts/tree/tree.service.ts"/>
var Runtime;
(function (Runtime) {
    configureRoutes.$inject = ["$routeProvider"];
    configureHelp.$inject = ["helpRegistry"];
    configureMainNav.$inject = ["mainNavService", "workspace"];
    function configureRoutes($routeProvider) {
        'ngInject';
        $routeProvider
            .when('/runtime/sysprops', { template: '<runtime-system-properties></runtime-system-properties>' })
            .when('/runtime/metrics', { template: '<runtime-metrics></runtime-metrics>' })
            .when('/runtime/threads', { template: '<runtime-threads></runtime-threads>' });
    }
    Runtime.configureRoutes = configureRoutes;
    function configureHelp(helpRegistry) {
        'ngInject';
        helpRegistry.addUserDoc('runtime', 'plugins/runtime/doc/help.md');
    }
    Runtime.configureHelp = configureHelp;
    function configureMainNav(mainNavService, workspace) {
        'ngInject';
        mainNavService.addItem({
            title: 'Runtime',
            basePath: '/runtime',
            template: '<runtime></runtime>',
            isValid: function () { return workspace.treeContainsDomainAndProperties('java.lang'); }
        });
    }
    Runtime.configureMainNav = configureMainNav;
})(Runtime || (Runtime = {}));
/// <reference path="sysprop.ts"/>
var Runtime;
(function (Runtime) {
    var SystemPropertiesService = /** @class */ (function () {
        SystemPropertiesService.$inject = ["jolokiaService"];
        function SystemPropertiesService(jolokiaService) {
            'ngInject';
            this.jolokiaService = jolokiaService;
        }
        SystemPropertiesService.prototype.getSystemProperties = function () {
            return this.jolokiaService.getAttribute('java.lang:type=Runtime', null)
                .then(function (data) {
                var systemProperties = [];
                angular.forEach(data.SystemProperties, function (value, key) {
                    var sysprop = {
                        name: key,
                        value: value
                    };
                    systemProperties.push(sysprop);
                });
                return systemProperties;
            });
        };
        return SystemPropertiesService;
    }());
    Runtime.SystemPropertiesService = SystemPropertiesService;
})(Runtime || (Runtime = {}));
/// <reference path="sysprops.service.ts"/>
/// <reference path="sysprop.ts"/>
var Runtime;
(function (Runtime) {
    var SystemPropertiesController = /** @class */ (function () {
        SystemPropertiesController.$inject = ["systemPropertiesService"];
        function SystemPropertiesController(systemPropertiesService) {
            'ngInject';
            var _this = this;
            this.systemPropertiesService = systemPropertiesService;
            this.toolbarConfig = {
                filterConfig: {
                    fields: [
                        {
                            id: 'name',
                            title: 'Name',
                            placeholder: 'Filter by name...',
                            filterType: 'text'
                        },
                        {
                            id: 'value',
                            title: 'Value',
                            placeholder: 'Filter by value...',
                            filterType: 'text'
                        },
                    ],
                    onFilterChange: function (filters) {
                        _this.applyFilters(filters);
                    },
                    resultsCount: 0
                },
                isTableView: true
            };
            this.tableConfig = {
                selectionMatchProp: 'name',
                showCheckboxes: false
            };
            this.pageConfig = {
                pageSize: 20
            };
            this.tableColumns = [
                {
                    header: 'Property',
                    itemField: 'name',
                },
                {
                    header: 'Value',
                    itemField: 'value',
                }
            ];
            this.tableDtOptions = {
                order: [[0, "asc"]]
            };
            this.sysprops = [];
            this.tableItems = [];
        }
        SystemPropertiesController.prototype.$onInit = function () {
            this.loadData();
        };
        SystemPropertiesController.prototype.loadData = function () {
            var _this = this;
            this.systemPropertiesService.getSystemProperties()
                .then(function (sysprops) {
                _this.sysprops = sysprops;
                _this.tableItems = sysprops;
                _this.toolbarConfig.filterConfig.resultsCount = sysprops.length;
            }).catch(function (error) { return Core.notification('danger', error); });
            ;
        };
        SystemPropertiesController.prototype.applyFilters = function (filters) {
            var filteredSysProps = this.sysprops;
            filters.forEach(function (filter) {
                var regExp = new RegExp(filter.value, 'i');
                switch (filter.id) {
                    case 'name':
                        filteredSysProps = filteredSysProps.filter(function (sysprop) { return sysprop.name.match(regExp) !== null; });
                        break;
                    case 'value':
                        filteredSysProps = filteredSysProps.filter(function (sysprop) { return sysprop.value.match(regExp) !== null; });
                        break;
                }
            });
            this.tableItems = filteredSysProps;
            this.toolbarConfig.filterConfig.resultsCount = filteredSysProps.length;
        };
        return SystemPropertiesController;
    }());
    Runtime.SystemPropertiesController = SystemPropertiesController;
    Runtime.systemPropertiesComponent = {
        template: "\n      <div class=\"table-view runtime-sysprops-main\">\n        <h1>System Properties</h1>\n        <pf-toolbar config=\"$ctrl.toolbarConfig\"></pf-toolbar>\n        <pf-table-view config=\"$ctrl.tableConfig\"\n                       columns=\"$ctrl.tableColumns\"\n                       items=\"$ctrl.tableItems\"\n                       page-config=\"$ctrl.pageConfig\"\n                       dt-options=\"$ctrl.tableDtOptions\">\n        </pf-table-view>\n      </div>\n    ",
        controller: SystemPropertiesController
    };
})(Runtime || (Runtime = {}));
/// <reference path="sysprops.component.ts"/>
/// <reference path="sysprops.service.ts"/>
var Runtime;
(function (Runtime) {
    Runtime.systemPropertiesModule = angular
        .module('runtime-system-properties', [])
        .component('runtimeSystemProperties', Runtime.systemPropertiesComponent)
        .service('systemPropertiesService', Runtime.SystemPropertiesService)
        .name;
})(Runtime || (Runtime = {}));
var Runtime;
(function (Runtime) {
    var MetricsService = /** @class */ (function () {
        MetricsService.$inject = ["jolokia", "workspace"];
        function MetricsService(jolokia, workspace) {
            'ngInject';
            this.jolokia = jolokia;
            this.workspace = workspace;
        }
        MetricsService.prototype.registerJolokiaRequests = function (scope, callback) {
            var requests = [
                this.createMBeanRequest('java.lang:type=Threading'),
                this.createMBeanRequest('java.lang:type=Memory'),
                this.createMBeanRequest('java.lang:type=OperatingSystem'),
                this.createMBeanRequest('java.lang:type=ClassLoading'),
                this.createMBeanRequest('java.lang:type=Runtime'),
                this.createMBeanRequest('org.springframework.boot:type=Endpoint,name=metricsEndpoint')
            ];
            Core.register(this.jolokia, scope, requests, Core.onSuccess(callback));
        };
        MetricsService.prototype.unregisterJolokiaRequests = function (scope) {
            Core.unregister(this.jolokia, scope);
        };
        MetricsService.prototype.createMetric = function (name, value, unit) {
            return new Runtime.Metric(name, value, unit);
        };
        MetricsService.prototype.createUtilizationMetric = function (name, used, total, unit) {
            return new Runtime.UtilizationMetric(name, used, total, unit);
        };
        MetricsService.prototype.createMBeanRequest = function (mbean) {
            return {
                type: 'read',
                mbean: mbean,
                arguments: []
            };
        };
        return MetricsService;
    }());
    Runtime.MetricsService = MetricsService;
})(Runtime || (Runtime = {}));
var Runtime;
(function (Runtime) {
    var MetricType;
    (function (MetricType) {
        MetricType["JVM"] = "JVM";
        MetricType["SYSTEM"] = "System";
        MetricType["SPRING_BOOT"] = "Spring Boot";
    })(MetricType = Runtime.MetricType || (Runtime.MetricType = {}));
    var Metric = /** @class */ (function () {
        function Metric(name, value, unit) {
            this.name = name;
            this.value = value;
            this.unit = unit;
        }
        Metric.prototype.getDescription = function () {
            return this.name + ": " + this.value + (this.unit != null ? " " + this.unit : "");
        };
        return Metric;
    }());
    Runtime.Metric = Metric;
    var UtilizationMetric = /** @class */ (function (_super) {
        __extends(UtilizationMetric, _super);
        function UtilizationMetric(name, value, available, unit) {
            var _this = _super.call(this, name, value, unit) || this;
            _this.name = name;
            _this.value = value;
            _this.available = available;
            _this.unit = unit;
            return _this;
        }
        UtilizationMetric.prototype.getDescription = function () {
            var unitDescription = (this.unit != null ? ' ' + this.unit : '');
            var description = this.name + ": " + this.value;
            description += " " + unitDescription + " of";
            description += " " + this.available + unitDescription;
            return description;
        };
        return UtilizationMetric;
    }(Metric));
    Runtime.UtilizationMetric = UtilizationMetric;
    var MetricGroup = /** @class */ (function () {
        function MetricGroup(type, metrics) {
            if (metrics === void 0) { metrics = []; }
            this.type = type;
            this.metrics = metrics;
        }
        MetricGroup.prototype.updateMetrics = function (metrics) {
            var _this = this;
            metrics.forEach(function (metric) {
                var index = _this.metrics.map(function (m) { return m.name; }).indexOf(metric.name);
                if (index === -1) {
                    _this.metrics.push(metric);
                }
                else {
                    _this.metrics[index] = metric;
                }
            });
        };
        return MetricGroup;
    }());
    Runtime.MetricGroup = MetricGroup;
})(Runtime || (Runtime = {}));
/// <reference path="metrics.service.ts"/>
/// <reference path="metric.ts"/>
var Runtime;
(function (Runtime) {
    var MetricsController = /** @class */ (function () {
        MetricsController.$inject = ["$scope", "metricsService", "$filter", "humanizeService"];
        function MetricsController($scope, metricsService, $filter, humanizeService) {
            'ngInject';
            this.$scope = $scope;
            this.metricsService = metricsService;
            this.$filter = $filter;
            this.humanizeService = humanizeService;
            this.metricGroups = [];
        }
        MetricsController.prototype.$onInit = function () {
            var _this = this;
            this.loading = true;
            this.metricsService.registerJolokiaRequests(this.$scope, function (result) {
                _this.loading = false;
                _this.loadMetrics(result);
            });
        };
        MetricsController.prototype.$onDestroy = function () {
            this.metricsService.unregisterJolokiaRequests(this.$scope);
        };
        MetricsController.prototype.loadMetrics = function (result) {
            var _this = this;
            var metrics = result.value;
            var updates = [];
            var updateType;
            switch (result.request.mbean) {
                case 'java.lang:type=Threading':
                    updateType = Runtime.MetricType.JVM;
                    updates.push(this.metricsService.createMetric('Thread count', metrics.ThreadCount));
                    break;
                case 'java.lang:type=Memory':
                    updateType = Runtime.MetricType.JVM;
                    var heapUsed = this.formatBytes(metrics.HeapMemoryUsage.used);
                    updates.push(this.metricsService.createMetric('Heap used', heapUsed[0], heapUsed[1]));
                    break;
                case 'java.lang:type=OperatingSystem':
                    var filterNumeric = this.$filter('number');
                    var cpuLoad = filterNumeric(metrics.SystemCpuLoad * 100, 2);
                    var loadAverage = filterNumeric(metrics.SystemLoadAverage, 2);
                    var memFree = this.formatBytes(metrics.FreePhysicalMemorySize);
                    var memTotal = this.formatBytes(metrics.TotalPhysicalMemorySize);
                    updateType = Runtime.MetricType.SYSTEM;
                    updates.push(this.metricsService.createMetric('Available processors', metrics.AvailableProcessors));
                    updates.push(this.metricsService.createMetric('CPU load', cpuLoad, '%'));
                    updates.push(this.metricsService.createMetric('Load average', loadAverage));
                    updates.push(this.metricsService.createUtilizationMetric('Memory used', memFree[0], memTotal[0], memFree[1]));
                    updates.push(this.metricsService.createUtilizationMetric('File descriptors used', metrics.OpenFileDescriptorCount, metrics.MaxFileDescriptorCount));
                    break;
                case 'java.lang:type=ClassLoading':
                    updateType = Runtime.MetricType.JVM;
                    updates.push(this.metricsService.createMetric('Classes loaded', metrics.LoadedClassCount));
                    break;
                case 'java.lang:type=Runtime':
                    var filterDate = this.$filter('date');
                    updateType = Runtime.MetricType.JVM;
                    updates.push(this.metricsService.createMetric('Start time', filterDate(metrics.StartTime, 'yyyy-MM-dd HH:mm:ss')));
                    updates.push(this.metricsService.createMetric('Uptime', Core.humanizeMilliseconds(metrics.Uptime)));
                    break;
                case 'org.springframework.boot:type=Endpoint,name=metricsEndpoint':
                    updateType = Runtime.MetricType.SPRING_BOOT;
                    // Filter out metrics that are already shown under JVM & Runtime
                    Object.keys(metrics.Data).filter(function (key) {
                        return !/^(mem|processors|instance|uptime|heap|nonheap|threads|classes|gc|systemload)/.test(key);
                    }).forEach(function (metricName) {
                        updates.push(_this.metricsService.createMetric(_this.humanizeService.toSentenceCase(metricName), metrics.Data[metricName]));
                    });
                    break;
            }
            this.getMetricGroup(updateType).updateMetrics(updates);
            Core.$apply(this.$scope);
        };
        MetricsController.prototype.getMetricGroup = function (type) {
            var match = this.metricGroups.filter(function (group) { return group.type === type; });
            if (match.length > 0) {
                return match[0];
            }
            else {
                var metricGroup = new Runtime.MetricGroup(type);
                this.metricGroups.push(metricGroup);
                return metricGroup;
            }
        };
        MetricsController.prototype.formatBytes = function (bytes) {
            if (bytes == 0) {
                return [0, 'Bytes'];
            }
            var killobyte = 1024;
            var decimalPlaces = 2;
            var units = ['Bytes', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'];
            var i = Math.floor(Math.log(bytes) / Math.log(killobyte));
            var value = parseFloat((bytes / Math.pow(killobyte, i)).toFixed(decimalPlaces));
            var unit = units[i];
            return [value, unit];
        };
        return MetricsController;
    }());
    Runtime.MetricsController = MetricsController;
    Runtime.metricsComponent = {
        template: "\n      <div class=\"runtime-metrics-main\">\n        <h1>Metrics</h1>\n        <div class=\"blank-slate-pf no-border\" ng-if=\"$ctrl.loading === false && $ctrl.metricGroups.length === 0\">\n          <div class=\"blank-slate-pf-icon\">\n            <span class=\"pficon pficon pficon-warning-triangle-o\"></span>\n          </div>\n          <h1>No Metrics</h1>\n          <p>There are no metrics to display.</p>\n          <p>Wait for some metrics to be generated or check your application configuration.</p>\n        </div>\n        <div class=\"cards-pf\" ng-if=\"$ctrl.metricGroups.length > 0\">\n          <div class=\"container-fluid container-cards-pf\">\n            <div class=\"row row-cards-pf\">\n              <div class=\"col-xs-12 col-sm-6 col-md-4 col-lg-3\" ng-repeat=\"group in $ctrl.metricGroups | orderBy: 'type'\">\n                <pf-card\n                  head-title=\"{{group.type}}\"\n                  show-spinner=\"group.metrics.length === 0\"\n                  spinner-text=\"Loading\">\n                  <div class=\"card-pf-info-item\" ng-repeat=\"metric in group.metrics | orderBy: 'name'\">\n                    {{metric.getDescription()}}\n                  </div>\n                </pf-card>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    ",
        controller: MetricsController
    };
})(Runtime || (Runtime = {}));
/// <reference path="metrics.component.ts"/>
/// <reference path="metrics.service.ts"/>
var Runtime;
(function (Runtime) {
    Runtime.metricsModule = angular
        .module('runtime-metrics', [])
        .component('runtimeMetrics', Runtime.metricsComponent)
        .service('metricsService', Runtime.MetricsService)
        .name;
})(Runtime || (Runtime = {}));
var Runtime;
(function (Runtime) {
    var Thread = /** @class */ (function () {
        function Thread() {
        }
        return Thread;
    }());
    Runtime.Thread = Thread;
})(Runtime || (Runtime = {}));
/// <reference path="./thread.ts"/>
var Runtime;
(function (Runtime) {
    var ThreadsService = /** @class */ (function () {
        ThreadsService.$inject = ["jolokiaService"];
        function ThreadsService(jolokiaService) {
            'ngInject';
            this.jolokiaService = jolokiaService;
        }
        ThreadsService.prototype.getThreads = function () {
            return this.jolokiaService.execute('java.lang:type=Threading', 'dumpAllThreads', false, false)
                .then(function (threads) {
                threads.forEach(function (thread) {
                    thread.threadState = ThreadsService.STATE_LABELS[thread.threadState];
                    thread.waitedTime = thread.waitedTime > 0 ? Core.humanizeMilliseconds(thread.waitedTime) : '';
                    thread.blockedTime = thread.blockedTime > 0 ? Core.humanizeMilliseconds(thread.blockedTime) : '';
                });
                return threads;
            });
        };
        ThreadsService.prototype.isThreadContentionMonitoringEnabled = function () {
            return this.jolokiaService.getAttribute('java.lang:type=Threading', 'ThreadContentionMonitoringEnabled');
        };
        ThreadsService.prototype.enableThreadContentionMonitoring = function () {
            return this.jolokiaService.setAttribute('java.lang:type=Threading', 'ThreadContentionMonitoringEnabled', true);
        };
        ThreadsService.prototype.disableThreadContentionMonitoring = function () {
            return this.jolokiaService.setAttribute('java.lang:type=Threading', 'ThreadContentionMonitoringEnabled', false);
        };
        ThreadsService.STATE_LABELS = {
            BLOCKED: 'Blocked',
            NEW: 'New',
            RUNNABLE: 'Runnable',
            TERMINATED: 'Terminated',
            TIMED_WAITING: 'Timed waiting',
            WAITING: 'Waiting'
        };
        return ThreadsService;
    }());
    Runtime.ThreadsService = ThreadsService;
})(Runtime || (Runtime = {}));
/// <reference path="./thread.ts"/>
/// <reference path="./threads.service.ts"/>
var Runtime;
(function (Runtime) {
    var ThreadsController = /** @class */ (function () {
        ThreadsController.$inject = ["$interval", "$uibModal", "threadsService"];
        function ThreadsController($interval, $uibModal, threadsService) {
            'ngInject';
            var _this = this;
            this.$interval = $interval;
            this.$uibModal = $uibModal;
            this.threadsService = threadsService;
            this.FILTER_FUNCTIONS = {
                state: function (threads, state) { return threads.filter(function (thread) { return thread.threadState === state; }); },
                name: function (threads, name) {
                    var re = new RegExp(name, 'i');
                    return threads.filter(function (thread) { return re.test(thread.threadName); });
                }
            };
            this.toolbarActions = [];
            this.enableThreadContentionMonitoringAction = {
                name: 'Enable thread contention monitoring',
                actionFn: function () { return _this.enableThreadContentionMonitoring(); }
            };
            this.disableThreadContentionMonitoringAction = {
                name: 'Disable thread contention monitoring',
                actionFn: function () { return _this.disableThreadContentionMonitoring(); }
            };
            this.toolbarConfig = {
                filterConfig: {
                    fields: [
                        {
                            id: 'state',
                            title: 'State',
                            placeholder: 'Filter by state...',
                            filterType: 'select',
                            filterValues: ['Blocked', 'New', 'Runnable', 'Terminated', 'Timed waiting', 'Waiting']
                        },
                        {
                            id: 'name',
                            title: 'Name',
                            placeholder: 'Filter by name...',
                            filterType: 'text'
                        }
                    ],
                    onFilterChange: function (filters) {
                        _this.applyFilters(filters);
                    },
                    resultsCount: 0,
                    appliedFilters: []
                },
                actionsConfig: {
                    primaryActions: this.toolbarActions
                },
                isTableView: true
            };
            this.tableConfig = {
                selectionMatchProp: 'threadId',
                showCheckboxes: false
            };
            this.tableDtOptions = {
                order: [[0, "desc"]]
            };
            this.tableColumns = [
                {
                    header: 'ID',
                    itemField: 'threadId'
                },
                {
                    header: 'State',
                    itemField: 'threadState'
                },
                {
                    header: 'Name',
                    itemField: 'threadName',
                    templateFn: function (value) { return "<span class=\"table-cell-truncated\" title=\"" + value + "\">" + value + "</span>"; }
                },
                {
                    header: 'Waited Time',
                    itemField: 'waitedTime'
                },
                {
                    header: 'Blocked Time',
                    itemField: 'blockedTime'
                },
                {
                    header: 'Native',
                    itemField: 'inNative',
                    templateFn: function (value) { return value ? '<span class="fa fa-circle" aria-hidden="true"></span><span class="hidden">b</span>' : '<span class="hidden">a</span>'; }
                },
                {
                    header: 'Suspended',
                    itemField: 'suspended',
                    templateFn: function (value) { return value ? '<span class="fa fa-circle" aria-hidden="true"></span><span class="hidden">b</span>' : '<span class="hidden">a</span>'; }
                }
            ];
            this.tableActionButtons = [
                {
                    name: 'More',
                    title: 'View more information about this thread',
                    actionFn: function (action, thread) {
                        _this.$uibModal.open({
                            component: 'threadModal',
                            size: 'lg',
                            resolve: { thread: thread }
                        });
                    }
                }
            ];
        }
        ThreadsController.prototype.$onInit = function () {
            this.showThreadContentionMonitoringView();
            this.loadThreads();
        };
        ThreadsController.prototype.$onDestroy = function () {
            if (this.threadContentionMonitoringEnabled) {
                this.disableThreadContentionMonitoring();
            }
        };
        ThreadsController.prototype.showThreadContentionMonitoringView = function () {
            var _this = this;
            this.threadsService.isThreadContentionMonitoringEnabled()
                .then(function (enabled) { return enabled
                ? _this.showThreadContentionMonitoringEnabledView()
                : _this.showThreadContentionMonitoringDisabledView(); });
        };
        ThreadsController.prototype.loadThreads = function () {
            var _this = this;
            this.threadsService.getThreads().then(function (threads) {
                _this.allThreads = threads;
                _this.applyFilters(_this.toolbarConfig.filterConfig.appliedFilters);
            });
        };
        ThreadsController.prototype.applyFilters = function (filters) {
            var _this = this;
            var filteredThreads = this.allThreads;
            filters.forEach(function (filter) {
                filteredThreads = _this.FILTER_FUNCTIONS[filter.id](filteredThreads, filter.value);
            });
            this.filteredThreads = filteredThreads;
            this.toolbarConfig.filterConfig.resultsCount = filteredThreads.length;
        };
        ThreadsController.prototype.enableThreadContentionMonitoring = function () {
            var _this = this;
            this.threadsService.enableThreadContentionMonitoring()
                .then(function () { return _this.showThreadContentionMonitoringEnabledView(); });
        };
        ThreadsController.prototype.showThreadContentionMonitoringEnabledView = function () {
            var _this = this;
            this.threadContentionMonitoringEnabled = true;
            this.toolbarActions[0] = this.disableThreadContentionMonitoringAction;
            this.intervalId = this.$interval(function () { return _this.loadThreads(); }, 5000);
        };
        ThreadsController.prototype.disableThreadContentionMonitoring = function () {
            var _this = this;
            this.threadsService.disableThreadContentionMonitoring()
                .then(function () { return _this.showThreadContentionMonitoringDisabledView(); });
        };
        ThreadsController.prototype.showThreadContentionMonitoringDisabledView = function () {
            this.threadContentionMonitoringEnabled = false;
            this.toolbarActions[0] = this.enableThreadContentionMonitoringAction;
            this.$interval.cancel(this.intervalId);
        };
        return ThreadsController;
    }());
    Runtime.ThreadsController = ThreadsController;
    Runtime.threadsComponent = {
        template: "\n      <div class=\"table-view\">\n        <h1>Threads</h1>\n        <pf-toolbar config=\"$ctrl.toolbarConfig\"></pf-toolbar>\n        <pf-table-view class=\"runtime-threads-table\"\n                       config=\"$ctrl.tableConfig\"\n                       dt-options=\"$ctrl.tableDtOptions\"\n                       columns=\"$ctrl.tableColumns\"\n                       items=\"$ctrl.filteredThreads\"\n                       action-buttons=\"$ctrl.tableActionButtons\">\n        </pf-table-view>\n      </div>\n    ",
        controller: ThreadsController
    };
})(Runtime || (Runtime = {}));
/// <reference path="./thread.ts"/>
var Runtime;
(function (Runtime) {
    var ThreadModalController = /** @class */ (function () {
        function ThreadModalController() {
        }
        Object.defineProperty(ThreadModalController.prototype, "thread", {
            get: function () {
                return this.resolve.thread;
            },
            enumerable: true,
            configurable: true
        });
        return ThreadModalController;
    }());
    Runtime.ThreadModalController = ThreadModalController;
    Runtime.threadModalComponent = {
        bindings: {
            resolve: '<',
            close: '&'
        },
        template: "\n      <div class=\"modal-header\">\n        <button type=\"button\" class=\"close\" aria-label=\"Close\" ng-click=\"$ctrl.close()\">\n          <span class=\"pficon pficon-close\" aria-hidden=\"true\"></span>\n        </button>\n        <h4 class=\"modal-title\">Thread</h4>\n      </div>\n      <div class=\"modal-body\">\n        <div class=\"row\">\n          <div class=\"col-md-12\">\n            <dl class=\"dl-horizontal\">\n              <dt>ID</dt>\n              <dd>{{$ctrl.thread.threadId}}</dd>\n              <dt>State</dt>\n              <dd>{{$ctrl.thread.threadState}}</dd>\n              <dt>Name</dt>\n              <dd>{{$ctrl.thread.threadName}}</dd>\n              <dt>Native</dt>\n              <dd>{{$ctrl.thread.inNative ? 'yes' : 'no'}}</dd>\n              <dt>Suspended</dt>\n              <dd>{{$ctrl.thread.suspended ? 'yes' : 'no'}}</dd>\n              <dt>Waited Count</dt>\n              <dd>{{$ctrl.thread.waitedCount}}</dd>\n              <dt ng-show=\"$ctrl.thread.waitedTime\">Waited Time</dt>\n              <dd ng-show=\"$ctrl.thread.waitedTime\">{{$ctrl.thread.waitedTime}}</dd>\n              <dt>Blocked Count</dt>\n              <dd>{{$ctrl.thread.blockedCount}}</dd>\n              <dt ng-show=\"$ctrl.thread.blockedTime\">Blocked Time</dt>\n              <dd ng-show=\"$ctrl.thread.blockedTime\">{{$ctrl.thread.blockedTime}}</dd>\n              <div ng-show=\"$ctrl.thread.lockInfo != null\">\n                <dt>Lock Name</dt>\n                <dd>{{$ctrl.thread.lockName}}</dd>\n                <dt>Lock Class Name</dt>\n                <dd>{{$ctrl.thread.lockInfo.className}}</dd>\n                <dt>Lock Identity Hash Code</dt>\n                <dd>{{$ctrl.thread.lockInfo.identityHashCode}}</dd>\n              </div>\n              <div ng-show=\"$ctrl.thread.lockOwnerId > 0\">\n                <dt>Waiting for lock owned by</dt>\n                <dd><a href=\"\" ng-click=\"selectThreadById($ctrl.thread.lockOwnerId)\">{{$ctrl.thread.lockOwnerId}} - {{$ctrl.thread.lockOwnerName}}</a></dd>\n              </div>\n              <div ng-show=\"$ctrl.thread.lockedSynchronizers.length > 0\">\n                <dt>Locked Synchronizers</dt>\n                <dd>\n                  <ol class=\"list-unstyled\">\n                    <li ng-repeat=\"synchronizer in $ctrl.thread.lockedSynchronizers\">\n                      <span title=\"Class Name\">{{synchronizer.className}}</span> -\n                      <span title=\"Identity Hash Code\">{{synchronizer.identityHashCode}}</span>\n                    </li>\n                  </ol>\n                </dd>\n              </div>\n            </dl>\n          </div>\n        </div>\n        <div class=\"row\" ng-if=\"$ctrl.thread.lockedMonitors.length > 0\">\n          <div class=\"col-md-12\">\n            <dl>\n              <dt>Locked Monitors</dt>\n              <dd>\n                <ol>\n                  <li ng-repeat=\"monitor in $ctrl.thread.lockedMonitors\">\n                    Frame: <strong>{{monitor.lockedStackDepth}}</strong>\n                    <span class=\"green\">{{monitor.lockedStackFrame.className}}</span>\n                    <span class=\"bold\">.</span>\n                    <span class=\"blue bold\">{{monitor.lockedStackFrame.methodName}}</span>\n                    ({{monitor.lockedStackFrame.fileName}}<span ng-show=\"frame.lineNumber > 0\">:{{monitor.lockedStackFrame.lineNumber}}</span>)\n                    <span class=\"orange\" ng-show=\"monitor.lockedStackFrame.nativeMethod\">(Native)</span>\n                  </li>\n                </ol>\n              </dd>\n            </dl>\n          </div>\n        </div>\n        <div class=\"row\" ng-if=\"$ctrl.thread.stackTrace.length > 0\">\n          <div class=\"col-md-12\">\n            <dl>\n              <dt>Stack Trace</dt>\n              <dd>\n                <ol>\n                  <li ng-repeat=\"frame in $ctrl.thread.stackTrace\">\n                    <span class=\"green\">{{frame.className}}</span>\n                    <span class=\"bold\">.</span>\n                    <span class=\"blue bold\">{{frame.methodName}}</span>\n                    ({{frame.fileName}}<span ng-show=\"frame.lineNumber > 0\">:{{frame.lineNumber}}</span>)\n                    <span class=\"orange\" ng-show=\"frame.nativeMethod\">(Native)</span>\n                  </li>\n                </ol>\n              </dd>\n            </dl>\n          </div>\n        </div>\n      </div>\n    ",
        controller: ThreadModalController
    };
})(Runtime || (Runtime = {}));
/// <reference path="threads.component.ts"/>
/// <reference path="thread-modal.component.ts"/>
/// <reference path="threads.service.ts"/>
var Runtime;
(function (Runtime) {
    Runtime.threadsModule = angular
        .module('runtime-threads', [])
        .component('runtimeThreads', Runtime.threadsComponent)
        .component('threadModal', Runtime.threadModalComponent)
        .service('threadsService', Runtime.ThreadsService)
        .name;
})(Runtime || (Runtime = {}));
/// <reference path="sysprops/sysprops.module.ts"/>
/// <reference path="metrics/metrics.module.ts"/>
/// <reference path="threads/threads.module.ts"/>
/// <reference path="runtime.config.ts"/>
/// <reference path="runtime.component.ts"/>
/// <reference path="runtime.service.ts"/>
var Runtime;
(function (Runtime) {
    var runtimeModule = angular
        .module('hawtio-jmx-runtime', [
        Runtime.systemPropertiesModule,
        Runtime.metricsModule,
        Runtime.threadsModule
    ])
        .config(Runtime.configureRoutes)
        .run(Runtime.configureHelp)
        .run(Runtime.configureMainNav)
        .component('runtime', Runtime.runtimeComponent)
        .service('runtimeService', Runtime.RuntimeService)
        .name;
    hawtioPluginLoader.addModule(runtimeModule);
    Runtime.log = Logger.get(runtimeModule);
})(Runtime || (Runtime = {}));

angular.module('hawtio-jmx-templates', []).run(['$templateCache', function($templateCache) {$templateCache.put('plugins/diagnostics/html/flags.html','<div ng-controller="DiagnosticsFlagsController">\n  <h1>Hotspot Diagnostics</h1>\n  <table class="table table-striped table-bordered">\n    <thead>\n      <tr>\n        <th>VM Flag</th>\n        <th>Origin</th>\n        <th>Value</th>\n      </tr>\n    </thead>\n    <tbody>\n      <tr ng-repeat="flag in flags track by flag.name">\n        <td>{{flag.name}}</td>\n        <td>{{flag.origin}}</td>\n        <td>\n          <div ng-switch on="flag.dataType">\n            <span ng-switch-when="readonly">{{flag.value}}</span>\n            <input ng-switch-when="boolean" type="checkbox" ng-model="flag.value"></input>\n            <input ng-switch-when="string" type="text" ng-model="flag.value"></input>\n            <input ng-switch-when="number" type="number" ng-model="flag.value"></input>\n          </div>\n        </td>\n      </tr>\n    </tbody>\n  </table>  \n</div>');
$templateCache.put('plugins/diagnostics/html/heap.html','<div ng-controller="DiagnosticsHeapController" class="table-view">\n  <h1>Class Histogram</h1>\n  <p>\n    <strong>Please note:</strong> Loading class histogram may be very expensive, depending on the size and\n    layout of the heap. Alternatively, use the <samp>jcmd</samp> utility:<br>\n    <samp>jcmd &lt;process id/main class&gt; GC.class_histogram<samp>\n  </p>\n  <p>\n    <button type="button" class="btn btn-primary" ng-click="loadClassStats()" ng-disabled="loading">\n      Load class histogram\n    </button>\n  </p>\n  <p ng-show="loading">\n    Loading...\n  </p>\n  <div ng-show="!loading && items.length > 0">\n    <pf-toolbar config="toolbarConfig">\n      <span ng-show="lastLoaded">\n        Last loaded: {{lastLoaded | date: \'yyyy-MM-dd hh:mm:ss\'}}\n      </span>\n    </pf-toolbar>\n    <pf-table-view class="diagnostics-class-histogram-table" config="tableConfig" dt-options="tableDtOptions"\n                   page-config="pageConfig" columns="tableColumns" items="items"></pf-table-view>\n  </div>\n</div>\n');
$templateCache.put('plugins/diagnostics/html/jfr.html','<div ng-controller="DiagnosticsJfrController">\n  <h1>Flight Recorder</h1>\n  <div class="row-fluid jfr-column-container"\n       hawtio-auto-columns=".jfr-column">\n\n    <div class="jfr-column">\n      <div class="alert alert-warning alert-dismissable" ng-show="!jfrEnabled && isMessageVisible(\'jfrShowUnlockWarning\')">\n        <button type="button"\n           class="close"\n           data-dismiss="alert"\n           aria-hidden="true" ng-click="closeMessageForGood(\'jfrShowUnlockWarning\')" ><span class="pficon pficon-close"></span></button>\n        <span class="pficon pficon-warning-triangle-o"></span>\n        <strong>Please note:</strong> Running Java Flight Recorder on\n        production systems requires a <a\n        href="http://www.oracle.com/technetwork/java/javaseproducts/overview/index.html"\n        class="alert-link">license</a>.\n      </div>\n      <div class="alert alert-info alert-dismissable" ng-show="isMessageVisible(\'jfrShowJcmd\')">\n        <button type="button"\n                class="close"\n                data-dismiss="alert"\n                aria-hidden="true" ng-click="closeMessageForGood(\'jfrShowJcmd\')"><span class="pficon pficon-close"></span></button>\n        <span class="pficon pficon-info"></span>\n        <strong>Info:</strong>Equivalent command of last action: <code>{{jcmd}}</code>\n      </div>\n      <div class="casettePlayer">\n        <div class="casette">\n          <svg role="img"\n               aria-label="recording indicator"\n               xmlns="http://www.w3.org/2000/svg"\n               version="1.1"\n               viewBox="0 0 24 24"\n               width="25"\n               height="25"\n               id="recordingIndicator">\n            <circle cx="12"\n                    cy="12"\n                    r="11"\n                    fill="red"\n                    ng-show="isRunning">\n              <animate attributeType="XML"\n                       attributeName="fill"\n                       from="#ff0000"\n                       to="#000000"\n                       dur="2s"\n                       repeatCount="indefinite"></animate>\n            </circle>\n          </svg>\n          <div class="cassetteLabelCutCorners"></div>\n          <div class="casetteLabel">\n            {{jfrStatus}}\n            <div class="notLabel">\n              <div class="wrapCog"\n                   ng-class="{\'spinning\': isRunning}">\n                <svg role="img"\n                     aria-label="cassette wheel"\n                     xmlns="http://www.w3.org/2000/svg"\n                     version="1.1"\n                     viewBox="0 0 24 24"\n                     width="50"\n                     height="50"\n                     ng-class="{\'spinning\': isRecording}"\n                     id="leftcog">\n                  <circle cx="12"\n                          cy="12"\n                          r="11"\n                          fill="white"></circle>\n                  <circle cx="12"\n                          cy="12"\n                          r="8"\n                          fill="black"></circle>\n                  <rect x="2"\n                        y="10"\n                        width="20"\n                        height="4"\n                        fill="black"\n                        stroke="none"></rect>\n                  <rect x="2"\n                        y="10"\n                        width="20"\n                        height="4"\n                        fill="black"\n                        stroke="none"\n                        transform="rotate(45,12,12)"></rect>\n                  <rect x="2"\n                        y="10"\n                        width="20"\n                        height="4"\n                        fill="black"\n                        stroke="none"\n                        transform="rotate(90,12,12)"></rect>\n                  <rect x="2"\n                        y="10"\n                        width="20"\n                        height="4"\n                        fill="black"\n                        stroke="none"\n                        transform="rotate(135,12,12)"></rect>\n                </svg>\n              </div>\n              <div class="wrapCog"\n                   ng-class="{\'spinning\': isRunning}"\n                   id="rightCogWrapper">\n                <svg role="img"\n                     aria-label="cassette wheel"\n                     xmlns="http://www.w3.org/2000/svg"\n                     version="1.1"\n                     viewBox="0 0 24 24"\n                     width="50"\n                     height="50"\n                     ng-class="{\'spinning\': isRecording}">\n                  <circle cx="12"\n                          cy="12"\n                          r="11"\n                          fill="white"></circle>\n                  <circle cx="12"\n                          cy="12"\n                          r="8"\n                          fill="black"></circle>\n                  <rect x="2"\n                        y="10"\n                        width="20"\n                        height="4"\n                        fill="black"\n                        stroke="none"></rect>\n                  <rect x="2"\n                        y="10"\n                        width="20"\n                        height="4"\n                        fill="black"\n                        stroke="none"\n                        transform="rotate(45,12,12)"></rect>\n                  <rect x="2"\n                        y="10"\n                        width="20"\n                        height="4"\n                        fill="black"\n                        stroke="none"\n                        transform="rotate(90,12,12)"></rect>\n                  <rect x="2"\n                        y="10"\n                        width="20"\n                        height="4"\n                        fill="black"\n                        stroke="none"\n                        transform="rotate(135,12,12)"></rect>\n                </svg>\n              </div>\n            </div>\n          </div>\n        </div>\n        <div id="casetteButtons">\n\n          <button class="recorderButton btn"\n                  tooltip="Unlock commercial features to be able to record"\n                  ng-click="unlock()"\n                  ng-disabled="jfrEnabled"\n                  ng-class="jfrEnabled ? \'disabledJfrButton\' : \'raisedButton\'">\n            <i class="fa-5x"\n               ng-class="jfrEnabled ? \'pficon-unlocked\' : \'pficon-locked\'"></i>\n          </button>\n          <button class="recorderButton btn"\n                  ng-enabled="!isRunning"\n                  ng-class="!jfrEnabled || isRunning ? \'disabledJfrButton\' : \'raisedButton\'"\n                  tooltip="Start recording"\n                  ng-click="startRecording()"\n                  ng-disabled="isRunning">\n            <div class="recordingSymbol"\n                 id="rec"></div>\n          </button>\n          <button class="recorderButton btn"\n                  title="Dump recording to disk"\n                  ng-class="jfrEnabled && isRecording ? \'raisedButton\' : \'disabledJfrButton\'"\n                  ng-disabled="!isRecording"\n                  tooltip="Dump {{jfrSettings.name}} to disk"\n                  ng-click="dumpRecording()">\n            <i class="pficon-save fa-5x"></i>\n          </button>\n          <button class="recorderButton btn"\n                  ng-disabled="!isRecording"\n                  ng-class="jfrEnabled && isRecording ? \'raisedButton\' : \'disabledJfrButton\'"\n                  tooltip="Stop {{jfrSettings.name}}"\n                  ng-click="stopRecording()">\n            <div class="recordingSymbol"\n                 id="stop"></div>\n          </button>\n          <button class="recorderButton btn"\n                  ng-class="jfrEnabled && !settingsVisible ? \'raisedButton\' : \'disabledJfrButton\'"\n                  tooltip="Show/hide settings"\n                  ng-click="toggleSettingsVisible()">\n            <i class="pficon-settings fa-5x"></i>\n          </button>\n        </div>\n      </div>\n    </div>\n\n    <div class="jfr-column"\n         ng-show="settingsVisible">\n\n\n      <dl>\n        <dt>Recorder Settings</dt>\n        <dd>\n          <div simple-form\n               name="jfrForm"\n               data="formConfig"\n               entity="jfrSettings"></div>\n\n        </dd>\n      </dl>\n\n    </div>\n    <table ng-show="!!recordings.length"\n           class="table table-condensed table-striped">\n      <tr>\n        <th>Rec#</th>\n        <th>Size</th>\n        <th>Time</th>\n        <th>File</th>\n      </tr>\n      <tr ng-repeat="aRecording in recordings">\n        <td>{{aRecording.number}}</td>\n        <td>{{aRecording.size}}</td>\n        <td>{{aRecording.time | date: \'yyyy-MM-dd HH:mm:ss\' }}</td>\n        <td><a href="file://{{aRecording.file}}">{{aRecording.file}}</a></td>\n      </tr>\n    </table>\n\n  </div>\n\n</div>\n');
$templateCache.put('plugins/jmx/html/chartEdit.html','<div class="jmx-charts-edit-view" ng-controller="Jmx.ChartEditController">\n  <h2>Chart</h2>\n  <div ng-show="canEditChart()">\n    <p ng-if="showElements() && showAttributes()">\n      Please select the elements and attributes you want to see in the chart.\n    </p>\n    <p ng-if="!showElements() && showAttributes()">\n      Please select the attributes you want to see in the chart.\n    </p>\n    <p ng-if="!showElements() && !showAttributes()">\n      This chart cannot be edited.\n    </p>\n    <form>\n      <div class="row">\n        <div class="form-group col-md-6" ng-show="showElements()">\n          <label for="mbeans">Elements</label>\n          <select id="mbeans" class="form-control" size="20" multiple ng-model="selectedMBeans"\n                  ng-options="name for (name, value) in mbeans"></select>\n        </div>\n        <div class="form-group col-md-6" ng-show="showAttributes()">\n          <label for="attributes">Attributes</label>\n          <select id="attributes" class="form-control" size="20" multiple ng-model="selectedAttributes"\n                  ng-options="name | humanize for (name, value) in metrics"\n                  ng-change="onSelectedAttributesChange()"></select>\n        </div>\n      </div>\n      <div class="form-group">\n        <button type="submit" class="btn btn-primary" ng-click="viewChart()"\n                ng-disabled="!selectedAttributes.length && !selectedMBeans.length">\n          View Chart\n        </button>\n      </div>\n    </form>\n  </div>\n  <p ng-show="!canEditChart()">\n    No numeric metrics available. Please select another item to chart on.\n  </p>\n</div>\n');
$templateCache.put('plugins/jmx/html/charts.html','<div ng-controller="Jmx.ChartController">\n  <h2>Chart</h2>\n  <div ng-switch="errorMessage()">\n    <div ng-switch-when="metrics">No valid metrics to show for this mbean.</div>\n    <div ng-switch-when="updateRate">Charts aren\'t available when the update rate is set to "No refreshes", go to the <a ng-href="#/preferences{{hash}}">Preferences</a> panel and set a refresh rate to enable charts</div>\n    <div ng-switch-default>\n      <hawtio-action-bar>\n        <button type="button" class="btn btn-default" ng-click="edit()">Edit</button>\n      </hawtio-action-bar>\n    </div>\n    <div id="charts"></div>\n  </div>\n</div>\n');
$templateCache.put('plugins/jvm/html/connect-edit.html','<div class="modal-header">\n  <button type="button" class="close" aria-label="Close" ng-click="$ctrl.cancel()">\n    <span class="pficon pficon-close" aria-hidden="true"></span>\n  </button>\n  <h4 class="modal-title" ng-show="$ctrl.operation === \'add\'">Add Connection</h4>\n  <h4 class="modal-title" ng-show="$ctrl.operation === \'edit\'">Edit Connection</h4>\n</div>\n<form name="connectForm" class="form-horizontal jvm-connection-form" ng-submit="$ctrl.saveConnection($ctrl.connection)">\n  <div class="modal-body">\n    <div class="form-group" ng-class="{\'has-error\': $ctrl.errors.name}">\n      <label class="col-sm-3 control-label" for="connection-name">Name</label>\n      <div class="col-sm-8">\n        <input type="text" id="connection-name" class="form-control" name="name" ng-model="$ctrl.connection.name" pf-focused="!$ctrl.connection.name">\n        <span class="help-block" ng-show="$ctrl.errors.name">{{$ctrl.errors.name}}</span>\n      </div>\n    </div>\n    <div class="form-group">\n      <label class="col-sm-3 control-label" for="connection-scheme">Scheme</label>\n      <div class="col-sm-8">\n        <select id="connection-scheme" class="form-control" name="scheme" ng-model="$ctrl.connection.scheme">\n          <option>http</option>\n          <option>https</option>\n        </select>\n      </div>\n    </div>\n    <div class="form-group" ng-class="{\'has-error\': $ctrl.errors.host}">\n      <label class="col-sm-3 control-label" for="connection-host">Host</label>\n      <div class="col-sm-8">\n        <input type="text" id="connection-host" class="form-control" name="host" ng-model="$ctrl.connection.host" ng-change="">\n        <span class="help-block" ng-show="$ctrl.errors.host">{{$ctrl.errors.host}}</span>\n      </div>\n    </div>\n    <div class="form-group" ng-class="{\'has-error\': $ctrl.errors.port}">\n      <label class="col-sm-3 control-label" for="connection-port">Port</label>\n      <div class="col-sm-8">\n        <input type="number" id="connection-port" class="form-control" name="port" ng-model="$ctrl.connection.port" ng-change="resetTestConnection()">\n        <span class="help-block" ng-show="$ctrl.errors.port">{{$ctrl.errors.port}}</span>\n      </div>\n    </div>\n    <div class="form-group">\n      <label class="col-sm-3 control-label" for="connection-path">Path</label>\n      <div class="col-sm-8">\n        <input type="text" id="connection-path" class="form-control" name="path" ng-model="$ctrl.connection.path" ng-change="resetTestConnection()">\n      </div>\n    </div>\n    <div class="form-group">\n      <div class="col-sm-offset-3 col-sm-8">\n        <button type="button" class="btn btn-default" ng-click="$ctrl.testConnection($ctrl.connection)">\n          Test Connection\n        </button>\n        <span class="jvm-connection-test-msg" ng-show="$ctrl.test.message">\n          <span class="pficon" ng-class="{\'pficon-ok\': $ctrl.test.ok, \'pficon-warning-triangle-o\': !$ctrl.test.ok}"></span>\n          {{$ctrl.test.message}}\n        </span>\n      </div>\n    </div>\n  </div>\n  <div class="modal-footer">\n    <button type="button" class="btn btn-default" ng-click="$ctrl.cancel()">Cancel</button>\n    <button type="submit" class="btn btn-primary" ng-show="$ctrl.operation === \'add\'">Add</button>\n    <button type="submit" class="btn btn-primary" ng-show="$ctrl.operation === \'edit\'">Save</button>\n  </div>\n</form>\n');
$templateCache.put('plugins/jvm/html/connect.html','<div>\n  <h1>Remote</h1>\n  <div class="row">\n    <div class="col-md-7">\n      <hawtio-action-bar>\n        <button type="button" class="btn btn-default" ng-click="$ctrl.addConnection()">Add connection</button>\n      </hawtio-action-bar>\n      <pf-list-view class="jvm-connection-list" items="$ctrl.connections" config="$ctrl.listConfig"\n        action-buttons="$ctrl.listActionButtons" menu-actions="$ctrl.listActionDropDown">\n        <div class="list-view-pf-left">\n          <span class="pficon list-view-pf-icon-sm"\n                ng-class="{\'pficon-plugged\': item.reachable,\n                           \'list-view-pf-icon-success\': item.reachable,\n                           \'pficon-unplugged\': !item.reachable,\n                           \'list-view-pf-icon-danger\': !item.reachable}"\n                title="Endpoint {{item.reachable ? \'reachable\' : \'unreachable\'}}"></span>\n        </div>\n        <div class="list-view-pf-body">\n          <div class="list-view-pf-description">\n            <div class="list-group-item-heading">\n              {{item.name}}\n            </div>\n            <div class="list-group-item-text">\n              {{item | connectionUrl}}\n            </div>\n          </div>\n        </div>\n      </pf-list-view>\n    </div>\n    <div class="col-md-5">\n      <div class="panel panel-default">\n        <div class="panel-heading">\n          <h3 class="panel-title">Instructions</h3>\n        </div>\n        <div class="panel-body">\n          <p>\n            This page allows you to connect to remote processes which <strong>already have a\n            <a href="https://jolokia.org/agent.html" target="_blank">Jolokia agent</a> running inside them</strong>.\n            You will need to know the host name, port and path of the Jolokia agent to be able to connect.\n          </p>\n          <p>\n            If the process you wish to connect to does not have a Jolokia agent inside, please refer to the\n            <a href="http://jolokia.org/agent.html" target="_blank">Jolokia documentation</a> for how to add a JVM,\n            servlet or OSGi based agent inside it.\n          </p>\n          <p>\n            If you are using <a href="http://fabric8.io/" target="_blank">Fabric8</a>,\n            <a href="https://developers.redhat.com/products/fuse/overview/" target="_blank">Red Hat Fuse</a>,\n            or <a href="http://activemq.apache.org/" target="_blank">Apache ActiveMQ</a>;\n            then a Jolokia agent is included by default (use context path of Jolokia agent, usually\n            <code>jolokia</code>). Or you can always just deploy hawtio inside the process (which includes the Jolokia agent,\n            use Jolokia servlet mapping inside hawtio context path, usually <code>hawtio/jolokia</code>).\n          </p>\n        </div>\n      </div>\n    </div>\n  </div>\n</div>\n');
$templateCache.put('plugins/jvm/html/discover.html','<div ng-controller="JVM.DiscoveryController">\n\n  <h1>Discover</h1>\n\n  <p ng-if="discovering">Please wait, discovering agents...</p>\n  \n  <div ng-if="!discovering">\n    <p ng-show="agents.length === 0">\n      No agents discovered.\n    </p>\n    <div ng-show="agents.length > 0">\n      <div class="row toolbar-pf">\n        <div class="col-sm-12">\n          <form class="toolbar-pf-actions">\n            <div class="form-group">\n              <input type="text" class="form-control" ng-model="filter" placeholder="Filter..." autocomplete="off">\n            </div>\n            <div class="form-group">\n              <button class="btn btn-default" ng-click="fetch()" title="Refresh"><i class="fa fa-refresh"></i> Refresh</button>\n            </div>\n          </form>\n        </div>\n      </div>\n      <ul class="discovery zebra-list">\n        <li ng-repeat="agent in agents track by $index" ng-show="filterMatches(agent)">\n\n          <div class="inline-block">\n            <img ng-src="{{getLogo(agent)}}">\n          </div>\n\n          <div class="inline-block">\n            <p ng-hide="!hasName(agent)">\n            <span class="strong"\n                  ng-show="agent.server_vendor">\n              {{agent.server_vendor}} {{_.startCase(agent.server_product)}} {{agent.server_version}}\n            </span>\n            </p>\n          <span ng-class="getAgentIdClass(agent)">\n            <strong ng-show="hasName(agent)">Agent ID: </strong>{{agent.agent_id}}<br/>\n            <strong ng-show="hasName(agent)">Agent Version: </strong><span ng-hide="hasName(agent)"> Version: </span>{{agent.agent_version}}</span><br/>\n            <strong ng-show="hasName(agent)">Agent Description: </strong><span\n              ng-hide="hasName(agent)"> Description: {{agent.agent_description}}</span><br/>\n                <div ng-hide="!agent.startTime"><strong>JVM Started: </strong>{{agent.startTime | date: \'yyyy-MM-dd HH:mm:ss\'}}</div>\n                <div ng-hide="!agent.command"><strong>Java Command: </strong>{{agent.command}}</div>\n\n            <p ng-hide="!agent.url"><strong>Agent URL: </strong><a ng-href="{{agent.url}}"\n                                                                  target="_blank">{{agent.url}}</a>\n            </p>\n          </div>\n\n          <div class="inline-block lock" ng-show="agent.secured">\n            <i class="fa-4x pficon-locked" title="A valid username and password will be required to connect"></i>\n          </div>\n\n          <div class="inline-block" ng-hide="!agent.url">\n            <div class="connect-button"\n                ng-click="gotoServer($event, agent)"\n                hawtio-template-popover\n                content="authPrompt"\n                trigger="manual"\n                placement="auto"\n                data-title="Please enter your username and password">\n              <i ng-show="agent.url" class="fa-4x pficon-running" tooltip="Connect to process"></i>\n            </div>\n          </div>\n\n        </li>\n      </ul>\n    </div>\n  </div>\n\n  <script type="text/ng-template" id="authPrompt">\n    <div class="auth-form">\n      <form name="authForm">\n        <input type="text"\n                class="input-sm"\n                placeholder="Username..."\n                ng-model="agent.username"\n                required>\n        <input type="password"\n                class="input-sm"\n                placeholder="Password..."\n                ng-model="agent.password"\n                required>\n        <button ng-disabled="!authForm.$valid"\n                ng-click="connectWithCredentials($event, agent)"\n                class="btn btn-success">\n          <i class="fa fa-share"></i> Connect\n        </button>\n        <button class="btn" ng-click="closePopover($event)"><i class="fa fa-remove"></i></button>\n      </form>\n    </div>\n  </script>\n\n</div>\n');
$templateCache.put('plugins/jvm/html/jolokia-preferences.html','<div ng-controller="JVM.JolokiaPreferences">\n  <div class="alert alert-success jvm-jolokia-preferences-alert" ng-if="showAlert">\n    <span class="pficon pficon-ok"></span>\n    Settings applied successfully!\n  </div>\n  <form class="form-horizontal jvm-jolokia-preferences-form">\n    <div class="form-group">\n      <label class="col-md-2 control-label" for="updateRate">\n        Update rate\n        <span class="pficon pficon-info" data-toggle="tooltip" data-placement="top" title="The period between polls to jolokia to fetch JMX data"></span>\n      </label>\n      <div class="col-md-6">\n        <select id="updateRate" class="form-control" ng-model="updateRate">\n          <option value="0">Off</option>\n          <option value="5000">5 Seconds</option>\n          <option value="10000">10 Seconds</option>\n          <option value="30000">30 Seconds</option>\n          <option value="60000">60 seconds</option>\n        </select>\n      </div>\n    </div>\n    <div class="form-group">\n      <label class="col-md-2 control-label" for="maxDepth">\n        Max depth\n        <span class="pficon pficon-info" data-toggle="tooltip" data-placement="top" title="The number of levels jolokia will marshal an object to json on the server side before returning"></span>\n      </label>\n      <div class="col-sm-6">\n        <input type="number" id="maxDepth" class="form-control" ng-model="maxDepth">\n      </div>\n    </div>\n    <div class="form-group">\n      <label class="col-md-2 control-label" for="maxCollectionSize">\n        Max collection size\n        <span class="pficon pficon-info" data-toggle="tooltip" data-placement="top" title="The maximum number of elements in an array that jolokia will marshal in a response"></span>\n      </label>\n      <div class="col-sm-6">\n        <input type="number" id="maxCollectionSize" class="form-control" ng-model="maxCollectionSize">\n      </div>\n    </div>\n    <div class="form-group">\n      <label class="col-md-2">\n      </label>\n      <div class="col-md-6">\n        <button type="button" class="btn btn-primary" ng-click="reboot()">Apply</button>\n        <span class="help-block">Restart hawtio with the new values in effect</span>\n      </div>\n    </div>\n  </form>\n</div>');
$templateCache.put('plugins/jvm/html/local.html','<div ng-controller="JVM.JVMsController">\n  <h1>Local</h1>\n  <p ng-if="!initDone">\n    Please wait, discovering local JVM processes...\n  </p>\n  <div ng-if="initDone">\n    <p ng-if=\'status\'>\n      {{status}}\n    </p>\n    <div ng-if=\'data.length > 0\'>\n      <div class="row toolbar-pf">\n        <div class="col-sm-12">\n          <form class="toolbar-pf-actions">\n            <div class="form-group">\n              <input type="text" class="form-control" ng-model="filter" placeholder="Filter..." autocomplete="off">\n            </div>  \n            <div class="form-group">\n              <button class="btn btn-default" ng-click="fetch()" title="Refresh"><i class="fa fa-refresh"></i> Refresh</button>\n            </div>  \n          </form>  \n        </div>  \n      </div>  \n      <table class=\'centered table table-bordered table-condensed table-striped\'>\n        <thead>\n        <tr>\n          <th style="width: 70px">PID</th>\n          <th>Name</th>\n          <th style="width: 300px">Agent URL</th>\n          <th style="width: 50px"></th>\n        </tr>\n        </thead>\n        <tbody>\n        <tr ng-repeat="jvm in data track by $index" ng-show="filterMatches(jvm)">\n          <td>{{jvm.id}}</td>\n          <td title="{{jvm.displayName}}">{{jvm.alias}}</td>\n          <td><a href=\'\' title="Connect to this agent"\n                 ng-click="connectTo(jvm.url, jvm.scheme, jvm.hostname, jvm.port, jvm.path)">{{jvm.agentUrl}}</a></td>\n          <td>\n            <a class=\'btn control-button\' href="" title="Stop agent" ng-show="jvm.agentUrl"\n             ng-click="stopAgent(jvm.id)"><i class="pficon-close"></i></a>\n            <a class=\'btn control-button\' href="" title="Start agent" ng-hide="jvm.agentUrl"\n             ng-click="startAgent(jvm.id)"><i class="pficon-running"></i></a>\n          </td>\n        </tr>\n        </tbody>\n      </table>\n    </div>\n  </div>\n</div>\n');
$templateCache.put('plugins/jvm/html/navbarHeaderExtension.html','<style>\n  .navbar-header-hawtio-jvm {\n    float: left;\n    margin: 0;\n  }\n\n  .navbar-header-hawtio-jvm h4 {\n    color: white;\n    margin: 0px;\n  }\n\n  .navbar-header-hawtio-jvm li {\n    list-style-type: none;\n    display: inline-block;\n    margin-right: 10px;\n    margin-top: 4px;\n  }\n</style>\n<ul class="navbar-header-hawtio-jvm" ng-controller="JVM.HeaderController">\n  <li ng-show="containerName"><h4 ng-bind="containerName"></h4></li>\n  <li ng-show="goBack"><strong><a href="" ng-click="goBack()">Back</a></strong></li>\n</ul>\n');
$templateCache.put('plugins/jvm/html/reset.html','<div ng-controller="JVM.ResetController">\n  <div class="alert alert-success jvm-reset-connections-alert" ng-if="showAlert">\n    <span class="pficon pficon-ok"></span>\n    Connections cleared successfully!\n  </div>\n  <h3>Clear saved connections</h3>\n  <p>\n    Clear all saved connection settings stored in your browser\'s local storage.\n  </p>\n  <p>\n    <button class="btn btn-danger" ng-click="doClearConnectSettings()">Clear saved connections</button>\n  </p>\n</div>');
$templateCache.put('plugins/logs/html/logs-preferences.html','<form class="form-horizontal logs-preferences-form" ng-controller="LogsPreferencesController">\n\n  <div class="form-group">\n    <label class="col-md-2 control-label" for="logSortAsc">\n      Sort ascending\n      <span class="pficon pficon-info" data-toggle="tooltip" data-placement="top" title="Sort log entries by timestamp ascending"></span>\n    </label>\n    <div class="col-md-6">\n      <input type="checkbox" id="logSortAsc" ng-model="logSortAsc">\n    </div>\n  </div>\n\n  <div class="form-group">\n    <label class="col-md-2 control-label" for="logAutoScroll">\n      Auto scroll\n      <span class="pficon pficon-info" data-toggle="tooltip" data-placement="top" title="Automatically scroll when new log entries are added"></span>\n    </label>\n    <div class="col-md-6">\n      <input type="checkbox" id="logAutoScroll" ng-model="logAutoScroll">\n    </div>\n  </div>\n\n  <div class="form-group">\n    <label class="col-md-2 control-label" for="logCacheSize">\n      Log cache size\n      <span class="pficon pficon-info" data-toggle="tooltip" data-placement="top" title="The number of log messages to keep in the browser"></span>\n    </label>\n    <div class="col-md-6">\n      <input id="logCacheSize" type="number" class="form-control" ng-model="logCacheSize" min="0"/>\n    </div>\n  </div>\n\n  <div class="form-group">\n    <label class="col-md-2 control-label" for="logBatchSize">\n      Log batch size\n      <span class="pficon pficon-info" data-toggle="tooltip" data-placement="top" title="The maximum number of log messages to retrieve when loading new log lines"></span>\n    </label>\n    <div class="col-md-6">\n      <input id="logBatchSize" type="number" class="form-control" ng-model="logBatchSize" min="1" max="1000"/>\n    </div>\n  </div>\n\n</form>\n');
$templateCache.put('plugins/jmx/html/attributes/attributes.html','<div class="table-view" ng-controller="Jmx.AttributesController">\n  <h2>Attributes</h2>\n  <div ng-if="gridData.length > 0">\n    <div compile="attributes"></div>\n  </div>\n</div>\n\n<script type="text/ng-template" id="gridTemplate">\n  <table class="table table-striped table-bordered table-hover jmx-attributes-table"\n    ng-class="{\'ht-table-extra-columns\': hasExtraColumns}"\n    hawtio-simple-table="gridOptions">\n  </table>\n</script>\n\n<script type="text/ng-template" id="attributeModal.html">\n  <div class="modal-header">\n    <button type="button" class="close" aria-label="Close" ng-click="$dismiss()">\n      <span class="pficon pficon-close" aria-hidden="true"></span>\n    </button>\n    <h4 class="modal-title">Attribute: {{entity.key}}</h4>\n  </div>\n  <div class="modal-body">\n    <div simple-form ng-hide="!entity.rw" name="attributeEditor" mode="edit" entity=\'entity\' data=\'attributeSchemaEdit\'></div>\n    <div simple-form ng-hide="entity.rw" name="attributeViewer" mode="view" entity=\'entity\' data=\'attributeSchemaView\'></div>\n  </div>\n  <div class="modal-footer">\n    <button type="button" class="btn btn-default" ng-click="$dismiss()">Close</button>\n    <button type="button" class="btn btn-primary" ng-show="entity.rw" ng-click="$close()">Update</button>\n  </div>\n</script>\n');
$templateCache.put('plugins/jmx/html/operations/operation-form.html','<p ng-hide="$ctrl.operation.args.length">\n  This JMX operation requires no arguments. Click the \'Execute\' button to invoke the operation.\n</p>\n<p ng-show="$ctrl.operation.args.length">\n  This JMX operation requires some parameters. Fill in the fields below and click the \'Execute\' button\n  to invoke the operation.\n</p>\n\n<form class="form-horizontal" ng-submit="$ctrl.execute()">\n  <div class="form-group" ng-repeat="formField in $ctrl.formFields">\n    <label class="col-sm-2 control-label" for="{{formField.label}}">{{formField.label}}</label>\n    <div class="col-sm-10">\n      <input type="{{formField.type}}" id="{{formField.label}}" ng-class="{\'form-control\': formField.type !== \'checkbox\'}"\n        ng-model="formField.value" ng-disabled="!$ctrl.operation.canInvoke">\n      <span class="help-block">{{formField.helpText}}</span>\n    </div>\n  </div>\n  <div class="form-group">\n    <div ng-class="{\'col-sm-offset-2 col-sm-10\': $ctrl.operation.args.length, \'col-sm-12\': !$ctrl.operation.args.length}">\n      <button type="submit" class="btn btn-primary" ng-disabled="!$ctrl.operation.canInvoke || $ctrl.isExecuting">Execute</button>\n    </div>\n  </div>\n</form>\n\n<form ng-show="$ctrl.operationResult">\n  <div class="form-group">\n    <label>Result</label>\n    <div class="hawtio-clipboard-container">\n      <button hawtio-clipboard="#operation-result" class="btn btn-default btn-lg">\n        <i class="fa fa-clipboard" aria-hidden="true"></i>\n      </button>\n      <pre ng-class="{\'jmx-operation-error\': $ctrl.operationFailed}">{{$ctrl.operationResult}}</pre>\n    </div>\n    <textarea id="operation-result" class="hawtio-clipboard-hidden-target">{{$ctrl.operationResult}}</textarea>\n  </div>\n</form>\n');
$templateCache.put('plugins/jmx/html/operations/operations.html','<h2>Operations</h2>\n<p ng-if="$ctrl.operations.length === 0">\n  This MBean has no JMX operations.\n</p>\n<div ng-if="$ctrl.operations.length > 0">\n  <p>\n    This MBean supports the following JMX operations. Expand an item in the list to invoke that operation.\n  </p>\n  <pf-list-view class="jmx-operations-list-view" items="$ctrl.operations" config="$ctrl.config"\n    menu-actions="$ctrl.menuActions">\n    <div class="list-view-pf-stacked">\n      <div class="list-group-item-heading">\n        <span class="pficon pficon-locked" ng-if="!item.canInvoke"></span>\n        {{item.readableName}}\n      </div>\n      <div class="list-group-item-text">\n        {{item.description}}\n      </div>\n    </div>\n    <list-expanded-content>\n      <operation-form operation="$parent.item"></operation-form>\n    </list-expanded-content>\n  </pf-list-view>\n</div>\n');
$templateCache.put('plugins/jmx/html/tree/content.html','<div class="tree-nav-sidebar-content">\n  <div id="jmxtree" class="treeview-pf-hover treeview-pf-select"></div>\n</div>\n');
$templateCache.put('plugins/jmx/html/tree/header.html','<div class="tree-nav-sidebar-header">\n  <form role="form" class="search-pf has-button">\n    <div class="form-group has-clear">\n      <div class="search-pf-input-group">\n        <label for="input-search" class="sr-only">Search Tree:</label>\n        <input id="input-search" type="search" class="form-control" placeholder="Search tree:"\n          ng-model="$ctrl.filter">\n        <button type="button" class="clear" aria-hidden="true"\n          ng-hide="$ctrl.filter.length === 0"\n          ng-click="$ctrl.filter = \'\'">\n          <span class="pficon pficon-close"></span>\n        </button>\n      </div>\n    </div>\n    <div class="form-group tree-nav-buttons">\n      <span class="badge" ng-class="{positive: $ctrl.result.length > 0}"\n        ng-show="$ctrl.filter.length > 0">\n        {{$ctrl.result.length}}\n      </span>\n      <i class="fa fa-plus-square-o" title="Expand All" ng-click="$ctrl.expandAll()"></i>\n      <i class="fa fa-minus-square-o" title="Collapse All" ng-click="$ctrl.contractAll()"></i>\n    </div>\n  </form>\n</div>\n');
$templateCache.put('plugins/diagnostics/doc/help.md','## Diagnostics\n\nThe Diagnostics plugin provides diagnostic information about the JVM via the JVM DiagnosticCommand and HotspotDiangostic interfaces. The functionality is similar to the Diagnostic Commands view in Java Mission Control (jmc) or the command line tool jcmd. The plugin will provide corresponding jcmd commands in some scenarios.\n\n### Flight recorder\n\nThe Java Flight Recorder can be used to record diagnostics from a running Java process.  \n\n#### Unlock\n\nCommercial features must be enabled in order to use the flight recorder. The padlock will be locked and no operations are available if commercial options are not enabled. Click the padlock to unlock and enable flight recordings. Note: Running commercial options on a production system requires a valid license.\n\n#### Start\n\nStarts a recording. \n\n#### Dump\n\nDumps the contents of the current recording to disk. The file path will be listed in a table below.\n\n#### Stop\n\nStops the current recording.\n\n#### Settings\n\nHide/show the options pane.\n\n### Class Histogram\n\nClass histogram retrieves the number of instances of loaded classes and the amount of bytes they take up. \nIf the operation is repeated it will also show the difference since last run.\n\n### JVM flags\n\nThis table shows the JVM diagnostic flag settings. Your are also able to modify the settings in a running JVM.\n');
$templateCache.put('plugins/jmx/doc/help.md','## JMX\n\nThe JMX plugin gives a raw view of the underlying JMX metric data, allowing access to the entire JMX domain tree of MBeans.\n');
$templateCache.put('plugins/jvm/doc/help.md','## Connect\n\nThe Connect tab allows you to connect to local and remote Jolokia instances so you can examine JVMs.\n\nThe "Remote" sub-tab is used to manually add connection details for a Jolokia instance.  You can store connection details and quickly recall the details of a connection and connect.\n\nThe use proxy option should often be enabled, as Hawtio is running in your browser; usually due to CORS; you cannot open a different host or port from your browser (due to browse security restrictions); so we have to use a proxy servlet inside the Hawtio web app to proxy all requests for a different jolokia server - so we can communicate with a different jolokia agent.\n\nThe "Local" sub-tab lists local JVMs running on your machine and allows you to install the Jolokia JVM agent into a running JVM and connect to it. For this to actually work you need to have your JDK\'s "tools.jar" in the classpath, along with Jolokia\'s JVM agent jar.\n\nThe "Discover" sub-tab lists all JVMs which Jolokia could discover in the network, using its built-in discovery.\n');
$templateCache.put('plugins/logs/doc/help.md','## Logs\n\nWhen we run middleware we spend an awful lot of time looking at and searching logs. With Hawtio we show nicely coloured logs that auto scroll, can be filtered and sorted ascending or descending. Go to the Preferences page to customize the behavior the way you want.\n\n### How to enable Hawtio logs\n\nHawtio uses an MBean usually called LogQuery which implements the [LogQuerySupportMBean](https://github.com/hawtio/hawtio/blob/master/hawtio-log/src/main/java/io/hawt/log/support/LogQuerySupportMBean.java) interface from either the [hawtio-log-osgi](https://github.com/hawtio/hawtio/tree/master/hawtio-log-osgi) or [hawtio-log](https://github.com/hawtio/hawtio/tree/master/hawtio-log) bundles depending on if you are working inside or outside of OSGi respectively.\n\nIf you are using Apache Karaf, just add the hawtio-log-osgi bundle. If you are not using OSGi, then you just need to ensure you have hawtio-log in your WAR when you deploy Hawtio.\n\nYou also need to ensure that the LogQuery bean is instantiated in whatever dependency injection framework you choose.\n\nFor example, this is how we initialise LogQuery using OSGi blueprint:\n\n```html\n<bean id="logFacade" class="io.hawt.log.log4j.Log4jLogQuery" init-method="start" destroy-method="stop" scope="singleton">\n  <property name="size" value="${hawtio.log.buffer.size}"/>\n</bean>\n```\n\nAnd this is how we initialise LogQuery using Spring XML:\n\n```html\n<bean id="logQuery" class="io.fabric8.insight.log.log4j.Log4jLogQuery" lazy-init="false" scope="singleton" init-method="start" destroy-method="stop"/>\n```\n');
$templateCache.put('plugins/runtime/doc/help.md','## Runtime\n\nThe Runtime plugin displays information about the JVM runtime.\n\n### System Properties\n\nDisplays a filterable and sortable list of system properties.\n\n### Metrics\n\nDisplays runtime metrics from the JVM, such as memory, CPU, garbage collection and more.\n\n### Threads\n\nInspects the threads running in the JVM.\n');}]); hawtioPluginLoader.addModule("hawtio-jmx-templates");