/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot;

import io.hawt.springboot.HawtPlugin;
import io.hawt.springboot.HawtioEndpoint;
import io.hawt.springboot.SpringHawtioContextListener;
import io.hawt.system.ConfigManager;
import io.hawt.util.Strings;
import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.AuthenticationFilter;
import io.hawt.web.auth.LoginRedirectFilter;
import io.hawt.web.auth.LoginServlet;
import io.hawt.web.auth.LogoutServlet;
import io.hawt.web.auth.Redirector;
import io.hawt.web.auth.SessionExpiryFilter;
import io.hawt.web.auth.keycloak.KeycloakServlet;
import io.hawt.web.auth.keycloak.KeycloakUserServlet;
import io.hawt.web.filters.BaseTagHrefFilter;
import io.hawt.web.filters.CORSFilter;
import io.hawt.web.filters.CacheHeadersFilter;
import io.hawt.web.filters.ContentSecurityPolicyFilter;
import io.hawt.web.filters.PublicKeyPinningFilter;
import io.hawt.web.filters.StrictTransportSecurityFilter;
import io.hawt.web.filters.XContentTypeOptionsFilter;
import io.hawt.web.filters.XFrameOptionsFilter;
import io.hawt.web.filters.XXSSProtectionFilter;
import io.hawt.web.proxy.ProxyServlet;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.actuate.endpoint.mvc.JolokiaMvcEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.servlet.handler.SimpleUrlHandlerMapping;
import org.springframework.web.servlet.mvc.AbstractUrlViewController;

@ManagementContextConfiguration
@ConditionalOnBean(value={HawtioEndpoint.class})
@PropertySource(value={"classpath:/io/hawt/springboot/application.properties"})
public class HawtioConfiguration {
    private final String managementContextPath;
    private final String hawtioPath;

    @Autowired
    public HawtioConfiguration(ServerProperties serverProperties, ManagementServerProperties managementServerProperties, HawtioEndpoint hawtioEndpoint) {
        int serverPort = HawtioConfiguration.getOrDefault(serverProperties.getPort(), 8080);
        int managementPort = HawtioConfiguration.getOrDefault(managementServerProperties.getPort(), serverPort);
        String prefix = serverPort == managementPort ? Strings.webContextPath((String)serverProperties.getServletPrefix(), (String[])new String[0]) : "";
        this.managementContextPath = Strings.webContextPath((String)prefix, (String[])new String[]{managementServerProperties.getContextPath()});
        this.hawtioPath = Strings.webContextPath((String)this.managementContextPath, (String[])new String[]{hawtioEndpoint.getPath()});
    }

    @Autowired
    public void initializeHawtioPlugins(HawtioEndpoint hawtioEndpoint, Optional<List<HawtPlugin>> plugins) {
        hawtioEndpoint.setPlugins(plugins.orElse(Collections.emptyList()));
    }

    @Bean
    @ConditionalOnBean(value={JolokiaMvcEndpoint.class})
    public SimpleUrlHandlerMapping hawtioUrlMapping(ManagementServerProperties managementServerProperties, HawtioEndpoint hawtioEndpoint, JolokiaMvcEndpoint jolokiaEndpoint) {
        String hawtioPath = Strings.webContextPath((String)hawtioEndpoint.getPath(), (String[])new String[0]);
        String jolokiaPath = Strings.webContextPath((String)jolokiaEndpoint.getPath(), (String[])new String[0]);
        SilentSimpleUrlHandlerMapping mapping = new SilentSimpleUrlHandlerMapping();
        HashMap<String, JolokiaForwardingController> urlMap = new HashMap<String, JolokiaForwardingController>();
        if (!hawtioPath.isEmpty() || !"/jolokia".equals(jolokiaPath)) {
            String hawtioJolokiaPath = Strings.webContextPath((String)managementServerProperties.getContextPath(), (String[])new String[]{hawtioPath, "jolokia", "**"});
            urlMap.put(hawtioJolokiaPath, new JolokiaForwardingController(jolokiaEndpoint.getPath()));
            mapping.setOrder(Integer.MIN_VALUE);
        } else {
            urlMap.put("/<DUMMY>", null);
        }
        mapping.setUrlMap(urlMap);
        return mapping;
    }

    @Bean
    public Redirector redirector() {
        Redirector redirector = new Redirector();
        redirector.setApplicationContextPath(this.hawtioPath);
        return redirector;
    }

    @Bean
    public FilterRegistrationBean sessionExpiryFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new SessionExpiryFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean cacheFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new CacheHeadersFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean hawtioCorsFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new CORSFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean xframeOptionsFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new XFrameOptionsFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean xxssProtectionFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new XXSSProtectionFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean xContentTypeOptionsFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new XContentTypeOptionsFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean contentSecurityPolicyFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new ContentSecurityPolicyFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean strictTransportSecurityFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new StrictTransportSecurityFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean publicKeyPinningFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new PublicKeyPinningFilter());
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean authenticationFilter(Optional<JolokiaMvcEndpoint> jolokiaEndpoint) {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new AuthenticationFilter());
        if (jolokiaEndpoint.isPresent() && !jolokiaEndpoint.get().getPath().isEmpty()) {
            filter.addUrlPatterns(new String[]{Strings.webContextPath((String)this.managementContextPath, (String[])new String[]{jolokiaEndpoint.get().getPath(), "*"})});
        }
        return filter;
    }

    @Bean
    public FilterRegistrationBean loginRedirectFilter(Redirector redirector) {
        String[] unsecuredPaths = this.prependContextPath(AuthenticationConfiguration.UNSECURED_PATHS);
        FilterRegistrationBean filter = new FilterRegistrationBean();
        LoginRedirectFilter loginRedirectFilter = new LoginRedirectFilter(unsecuredPaths);
        loginRedirectFilter.setRedirector(redirector);
        filter.setFilter((Filter)loginRedirectFilter);
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/*"});
        return filter;
    }

    @Bean
    FilterRegistrationBean baseTagHrefFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        BaseTagHrefFilter baseTagHrefFilter = new BaseTagHrefFilter();
        filter.setFilter((Filter)baseTagHrefFilter);
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/"});
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/index.html"});
        filter.addUrlPatterns(new String[]{this.hawtioPath + "/login.html"});
        filter.setDispatcherTypes(DispatcherType.ERROR, new DispatcherType[]{DispatcherType.FORWARD, DispatcherType.REQUEST});
        filter.addInitParameter("applicationContextPath", this.hawtioPath);
        return filter;
    }

    @Bean
    public ServletRegistrationBean jolokiaProxyServlet() {
        return new ServletRegistrationBean((Servlet)new ProxyServlet(), new String[]{this.hawtioPath + "/proxy/*"});
    }

    @Bean
    public ServletRegistrationBean userServlet() {
        return new ServletRegistrationBean((Servlet)new KeycloakUserServlet(), new String[]{this.managementContextPath + "/user/*", this.hawtioPath + "/user/*"});
    }

    @Bean
    public ServletRegistrationBean loginServlet(Redirector redirector) {
        LoginServlet loginServlet = new LoginServlet();
        loginServlet.setRedirector(redirector);
        return new ServletRegistrationBean((Servlet)loginServlet, new String[]{this.hawtioPath + "/auth/login"});
    }

    @Bean
    public ServletRegistrationBean logoutServlet(Redirector redirector) {
        LogoutServlet logoutServlet = new LogoutServlet();
        logoutServlet.setRedirector(redirector);
        return new ServletRegistrationBean((Servlet)logoutServlet, new String[]{this.hawtioPath + "/auth/logout"});
    }

    @Bean
    public ServletRegistrationBean keycloakServlet() {
        return new ServletRegistrationBean((Servlet)new KeycloakServlet(), new String[]{this.hawtioPath + "/keycloak/*"});
    }

    @Bean
    public ServletListenerRegistrationBean<?> hawtioContextListener(ConfigManager configManager) {
        return new ServletListenerRegistrationBean((EventListener)((Object)new SpringHawtioContextListener(configManager, this.hawtioPath)));
    }

    private static int getOrDefault(Integer number, int defaultValue) {
        return number == null ? defaultValue : number;
    }

    private String[] prependContextPath(String[] paths) {
        return (String[])Arrays.stream(paths).map(path -> this.hawtioPath + path).toArray(String[]::new);
    }

    private static class SilentSimpleUrlHandlerMapping
    extends SimpleUrlHandlerMapping {
        private static final String DUMMY = "/<DUMMY>";

        private SilentSimpleUrlHandlerMapping() {
        }

        protected void registerHandler(String urlPath, Object handler) {
            if (!DUMMY.equals(urlPath)) {
                super.registerHandler(urlPath, handler);
            }
        }
    }

    private class JolokiaForwardingController
    extends AbstractUrlViewController {
        private final String jolokiaPath;
        private final int jolokiaSubPathStart;

        JolokiaForwardingController(String jolokiaPath) {
            this.jolokiaPath = jolokiaPath;
            this.jolokiaSubPathStart = Strings.webContextPath((String)HawtioConfiguration.this.hawtioPath, (String[])new String[]{"jolokia"}).length();
        }

        protected String getViewNameForRequest(HttpServletRequest request) {
            String uri = Strings.webContextPath((String)request.getRequestURI(), (String[])new String[0]);
            String jolokiaRequest = uri.substring(request.getContextPath().length() + this.jolokiaSubPathStart);
            StringBuilder b = new StringBuilder();
            b.append("forward:");
            b.append(Strings.webContextPath((String)HawtioConfiguration.this.managementContextPath, (String[])new String[]{this.jolokiaPath, jolokiaRequest}));
            if (request.getQueryString() != null) {
                b.append('?').append(request.getQueryString());
            }
            return b.toString();
        }
    }
}

