function mergeDeep(dst){"use strict";return angular.forEach(arguments,function(obj){obj!==dst&&angular.forEach(obj,function(value,key){dst[key]&&dst[key].constructor&&dst[key].constructor===Object?mergeDeep(dst[key],value):dst[key]=value})}),dst}function utilizationToColor(number){"use strict";var invert=100-number,hue=1.2*invert/360,rgb=hslToRgb(hue,1,.5);return"rgb("+rgb[0]+","+rgb[1]+","+rgb[2]+")"}function hue2rgb(p,q,t){"use strict";return 0>t&&(t+=1),t>1&&(t-=1),1/6>t?p+6*(q-p)*t:.5>t?q:2/3>t?p+(q-p)*(2/3-t)*6:p}function hslToRgb(h,s,l){"use strict";var r,g,b,q,p;return 0===s?r=g=b=l:(q=.5>l?l*(1+s):l+s-l*s,p=2*l-q,r=hue2rgb(p,q,h+1/3),g=hue2rgb(p,q,h),b=hue2rgb(p,q,h-1/3)),[Math.floor(255*r),Math.floor(255*g),Math.floor(255*b)]}angular.module("patternfly.canvas",["dragging","ngDragDrop","ui.bootstrap"]),angular.module("patternfly.card",["ui.bootstrap"]),angular.module("patternfly.charts",["patternfly.utils","ui.bootstrap","ngSanitize"]),angular.module("patternfly.datepicker",["ui.bootstrap"]),angular.module("patternfly.filters",["ui.bootstrap"]),angular.module("patternfly.form",[]),angular.module("patternfly.modals",["ui.bootstrap.modal","ui.bootstrap.tpls","ngSanitize","ngAnimate"]),angular.module("patternfly.navigation",["ui.bootstrap"]),angular.module("patternfly.notification",["patternfly.utils","ui.bootstrap"]),angular.module("patternfly.pagination",["ui.bootstrap"]).filter("startFrom",function(){"use strict";return function(input,start){return start=parseInt(start,10),input.slice(start)}}),angular.module("patternfly",["patternfly.autofocus","patternfly.card","patternfly.datepicker","patternfly.filters","patternfly.form","patternfly.modals","patternfly.navigation","patternfly.notification","patternfly.pagination","patternfly.select","patternfly.sort","patternfly.toolbars","patternfly.utils","patternfly.validation","patternfly.views","patternfly.wizard"]),angular.module("patternfly.select",["ui.bootstrap"]),angular.module("patternfly.sort",["ui.bootstrap"]),angular.module("patternfly.table",["datatables","patternfly.pagination","patternfly.utils","patternfly.filters","patternfly.sort"]),angular.module("patternfly.toolbars",["patternfly.utils","patternfly.filters","patternfly.sort","patternfly.views"]),angular.module("patternfly.utils",["ui.bootstrap"]),angular.module("patternfly.views",["patternfly.utils","patternfly.filters","patternfly.sort","patternfly.charts","dndLists","patternfly.pagination"]),angular.module("patternfly.wizard",["ui.bootstrap.modal","ui.bootstrap","patternfly.form"]),angular.module("patternfly.autofocus",[]).directive("pfFocused",["$timeout",function($timeout){"use strict";return{restrict:"A",link:function(scope,element,attrs){scope.$watch(attrs.pfFocused,function(newValue){$timeout(function(){newValue&&(element[0].focus(),element[0].select&&element[0].select())})})}}}]),function(){"use strict";angular.module("patternfly.canvas").component("pfCanvasEditor",{bindings:{chartDataModel:"=",chartViewModel:"=?",toolboxTabs:"=",readOnly:"<?"},transclude:!0,templateUrl:"canvas-view/canvas-editor/canvas-editor.html",controller:["$timeout",function($timeout){var prevClickedOnChart,prevInConnectingMode,ctrl=this,newNodeCount=0;ctrl.$onInit=function(){ctrl.toolboxVisible=!1,ctrl.hideConnectors=!1,ctrl.draggedItem=null},$timeout(function(){prevClickedOnChart=ctrl.chartViewModel.clickedOnChart,prevInConnectingMode=ctrl.chartViewModel.inConnectingMode}),ctrl.$doCheck=function(){angular.isDefined(prevClickedOnChart)&&angular.isDefined(prevInConnectingMode)&&(angular.equals(ctrl.chartViewModel.clickedOnChart,prevClickedOnChart)||(ctrl.chartViewModel.clickedOnChart&&(ctrl.chartViewModel.clickedOnChart=!1,ctrl.hideToolbox()),prevClickedOnChart=ctrl.chartViewModel.clickedOnChart),angular.equals(ctrl.chartViewModel.inConnectingMode,prevInConnectingMode)||(ctrl.chartViewModel.inConnectingMode&&(ctrl.hideConnectors=!1,ctrl.hideToolbox()),prevInConnectingMode=ctrl.chartViewModel.inConnectingMode))},ctrl.addNodeToCanvas=function(newNode){ctrl.chartViewModel.addNode(newNode)},ctrl.showToolbox=function(){ctrl.toolboxVisible=!0,$timeout(function(){angular.element(".subtabs>u").addClass("nav-tabs-pf"),angular.element("#filterFld").focus()})},ctrl.hideToolbox=function(){ctrl.toolboxVisible=!1},ctrl.toggleToolbox=function(){ctrl.readOnly||ctrl.chartViewModel.inConnectingMode||(ctrl.toolboxVisible===!0?ctrl.hideToolbox():ctrl.showToolbox())},ctrl.tabClicked=function(){angular.element("#filterFld").focus()},ctrl.startCallback=function(event,ui,item){ctrl.draggedItem=item},ctrl.dropCallback=function(event,ui){var newNode=angular.copy(ctrl.draggedItem);newNodeCount++,newNode.x=event.clientX-600,newNode.y=event.clientY-200,newNode.backgroundColor=newNode.backgroundColor?newNode.backgroundColor:"#fff",ctrl.chartViewModel.addNode(newNode)},ctrl.addNodeByClick=function(item){var newNode=angular.copy(item);newNodeCount++,newNode.x=250+(4*newNodeCount+160),newNode.y=200+(4*newNodeCount+160),newNode.backgroundColor=newNode.backgroundColor?newNode.backgroundColor:"#fff",ctrl.chartViewModel.addNode(newNode)},ctrl.tabClicked=function(){angular.element("#filterFld").focus()},ctrl.activeTab=function(){return ctrl.toolboxTabs.filter(function(tab){return tab.active})[0]},ctrl.activeSubTab=function(){var activeTab=ctrl.activeTab();return activeTab&&activeTab.subtabs?activeTab.subtabs.filter(function(subtab){return subtab.active})[0]:void 0},ctrl.activeSubSubTab=function(){var activeSubTab=ctrl.activeSubTab();return activeSubTab&&activeSubTab.subtabs?activeSubTab.subtabs.filter(function(subsubtab){return subsubtab.active})[0]:void 0},ctrl.maxZoom=function(){return ctrl.chartViewModel&&ctrl.chartViewModel.zoom?ctrl.chartViewModel.zoom.isMax():!1},ctrl.minZoom=function(){return ctrl.chartViewModel&&ctrl.chartViewModel.zoom?ctrl.chartViewModel.zoom.isMin():!1},ctrl.zoomIn=function(){ctrl.chartViewModel.zoom["in"]()},ctrl.zoomOut=function(){ctrl.chartViewModel.zoom.out()}}]})}(),function(){"use strict";angular.module("patternfly.canvas").component("toolboxItems",{templateUrl:"canvas-view/canvas-editor/toolbox-items.html",bindings:{items:"=",startDragCallback:"<",clickCallback:"<",searchText:"="},controller:function(){var ctrl=this;ctrl.itemClicked=function(item){angular.isFunction(ctrl.clickCallback)&&!item.disableInToolbox&&ctrl.clickCallback(item)},ctrl.startItemDrag=function(event,ui,item){angular.isFunction(ctrl.startDragCallback)&&ctrl.startDragCallback(event,ui,item)}}})}(),function(){"use strict";angular.module("patternfly.canvas").filter("trustAsResourceUrl",["$sce",function($sce){return function(val){return $sce.trustAsResourceUrl(val)}}]).component("pfCanvas",{templateUrl:"canvas-view/canvas/canvas.html",bindings:{chartDataModel:"=",chartViewModel:"=?",readOnly:"<?",hideConnectors:"=?"},controller:["$scope","dragging","$element","$document",function($scope,dragging,$element,$document){var ctrl=this;ctrl.chart=new pfCanvas.ChartViewModel(ctrl.chartDataModel),ctrl.chartViewModel=ctrl.chart,ctrl.draggingConnection=!1,ctrl.connectorSize=6,ctrl.dragSelecting=!1,ctrl.mouseOverConnector=null,ctrl.mouseOverConnection=null,ctrl.mouseOverNode=null,this.translateCoordinates=function(x,y,evt){var svgElem=$element.get(0).children[0],matrix=svgElem.getScreenCTM(),point=svgElem.createSVGPoint();return point.x=(x-evt.view.pageXOffset)/ctrl.zoomLevel(),point.y=(y-evt.view.pageYOffset)/ctrl.zoomLevel(),point.matrixTransform(matrix.inverse())},ctrl.hideConnectors=ctrl.hideConnectors||!1,ctrl.isConnectorConnected=function(connector){return connector&&connector.connected()},ctrl.isConnectorUnconnectedAndValid=function(connector){return connector&&!connector.connected()&&!connector.invalid()&&connector.parentNode()!==ctrl.connectingModeSourceNode},ctrl.isConnectedTo=function(connector,node){var i,connection,connections=ctrl.chart.connections;for(i=0;i<connections.length;i++)if(connection=connections[i],connection.dest===connector&&connection.source.parentNode()===node)return!0;return!1},ctrl.availableConnections=function(){return ctrl.chart.validConnections},ctrl.foreignObjectSupported=function(){return $document[0].implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#Extensibility","1.1")},ctrl.addNodeToCanvas=function(newNode){ctrl.chart.addNode(newNode)},$scope.$on("selectAll",function(){ctrl.selectAll()}),ctrl.selectAll=function(){ctrl.chart.selectAll()},$scope.$on("deselectAll",function(){ctrl.deselectAll()}),ctrl.deselectAll=function(){ctrl.chart.deselectAll()},$scope.$on("deleteSelected",function(){ctrl.deleteSelected()}),ctrl.deleteSelected=function(){ctrl.chart.deleteSelected()},ctrl.mouseDown=function(evt){ctrl.readOnly||(ctrl.chart.inConnectingMode&&ctrl.cancelConnectingMode(),ctrl.chart.deselectAll(),ctrl.chart.clickedOnChart=!0,dragging.startDrag(evt,{dragStarted:function(x,y){var startPoint;ctrl.dragSelecting=!0,startPoint=ctrl.translateCoordinates(x,y,evt),ctrl.dragSelectionStartPoint=startPoint,ctrl.dragSelectionRect={x:startPoint.x,y:startPoint.y,width:0,height:0}},dragging:function(x,y){var startPoint=ctrl.dragSelectionStartPoint,curPoint=ctrl.translateCoordinates(x,y,evt);ctrl.dragSelectionRect={x:curPoint.x>startPoint.x?startPoint.x:curPoint.x,y:curPoint.y>startPoint.y?startPoint.y:curPoint.y,width:curPoint.x>startPoint.x?curPoint.x-startPoint.x:startPoint.x-curPoint.x,height:curPoint.y>startPoint.y?curPoint.y-startPoint.y:startPoint.y-curPoint.y}},dragEnded:function(){ctrl.dragSelecting=!1,ctrl.chart.applySelectionRect(ctrl.dragSelectionRect),delete ctrl.dragSelectionStartPoint,delete ctrl.dragSelectionRect}}))},ctrl.nodeMouseOver=function(evt,node){ctrl.readOnly||(ctrl.mouseOverNode=node)},ctrl.nodeMouseLeave=function(){ctrl.mouseOverNode=null},ctrl.nodeMouseDown=function(evt,node){var lastMouseCoords,chart=ctrl.chart;ctrl.readOnly||dragging.startDrag(evt,{dragStarted:function(x,y){lastMouseCoords=ctrl.translateCoordinates(x,y,evt),node.selected()||(chart.deselectAll(),node.select())},dragging:function(x,y){var curCoords=ctrl.translateCoordinates(x,y,evt),deltaX=curCoords.x-lastMouseCoords.x,deltaY=curCoords.y-lastMouseCoords.y;chart.updateSelectedNodesLocation(deltaX,deltaY),lastMouseCoords=curCoords},clicked:function(){chart.handleNodeClicked(node,evt.ctrlKey)}})},ctrl.nodeClickHandler=function(action,node){"nodeActionConnect"===action&&ctrl.startConnectingMode(node)},ctrl.nodeCloseHandler=function(){ctrl.mouseOverNode=null},ctrl.connectingModeOutputConnector=null,ctrl.connectingModeSourceNode=null,ctrl.startConnectingMode=function(node){ctrl.chart.inConnectingMode=!0,ctrl.hideConnectors=!1,ctrl.connectingModeSourceNode=node,ctrl.connectingModeSourceNode.select(),ctrl.connectingModeOutputConnector=node.getOutputConnector(),ctrl.chart.updateValidNodesAndConnectors(ctrl.connectingModeSourceNode)},ctrl.cancelConnectingMode=function(){ctrl.connectingModeOutputConnector.connected()||ctrl.chart.removeOutputConnector(ctrl.connectingModeOutputConnector),ctrl.stopConnectingMode()},ctrl.stopConnectingMode=function(){ctrl.chart.inConnectingMode=!1,ctrl.chart.resetValidNodesAndConnectors()},ctrl.connectionMouseOver=function(evt,connection){ctrl.draggingConnection||ctrl.readOnly||(ctrl.mouseOverConnection=connection)},ctrl.connectionMouseLeave=function(){ctrl.mouseOverConnection=null},ctrl.connectionMouseDown=function(evt,connection){var chart=ctrl.chart;ctrl.readOnly||chart.handleConnectionMouseDown(connection,evt.ctrlKey),evt.stopPropagation(),evt.preventDefault()},ctrl.connectorMouseOver=function(evt,node,connector){ctrl.readOnly||(ctrl.mouseOverConnector=connector)},ctrl.connectorMouseLeave=function(){ctrl.mouseOverConnector=null},ctrl.connectorMouseDown=function(evt,node){ctrl.chart.inConnectingMode&&node!==ctrl.connectingModeSourceNode&&(ctrl.chart.createNewConnection(ctrl.connectingModeOutputConnector,ctrl.mouseOverConnector),ctrl.stopConnectingMode())},$scope.$on("zoomIn",function(){ctrl.chart.zoom["in"]()}),$scope.$on("zoomOut",function(){ctrl.chart.zoom.out()}),$scope.maxZoom=function(){return ctrl.chart.chartViewModel&&ctrl.chart.chartViewModel.zoom?ctrl.chart.chartViewModel.zoom.isMax():!1},$scope.minZoom=function(){return ctrl.chart.chartViewModel&&ctrl.chart.chartViewModel.zoom?ctrl.chart.chartViewModel.zoom.isMin():!1},ctrl.zoomLevel=function(){return ctrl.chart.zoom.getLevel()},ctrl.$onInit=function(){var backspaceKeyCode=8,deleteKeyCode=46,aKeyCode=65,escKeyCode=27;$document.find("body").keydown(function(evt){evt.keyCode===aKeyCode&&evt.ctrlKey===!0&&(ctrl.selectAll(),$scope.$digest(),evt.stopPropagation(),evt.preventDefault()),(evt.keyCode===deleteKeyCode||evt.keyCode===backspaceKeyCode)&&(ctrl.deleteSelected(),$scope.$digest()),evt.keyCode===escKeyCode&&(ctrl.deselectAll(),$scope.$digest())})}}]})}();var pfCanvas={};!function(){pfCanvas.defaultHeight=756,pfCanvas.defaultWidth=1396,pfCanvas.defaultBgImageSize=24,pfCanvas.defaultNodeWidth=150,pfCanvas.defaultNodeHeight=150,pfCanvas.nodeNameHeight=40,pfCanvas.connectorHeight=25,pfCanvas.computeConnectorY=function(connectorIndex){return pfCanvas.defaultNodeHeight/2+connectorIndex*pfCanvas.connectorHeight},pfCanvas.computeConnectorPos=function(node,connectorIndex,inputConnector){return{x:node.x()+(inputConnector?0:node.width?node.width():pfCanvas.defaultNodeWidth),y:node.y()+pfCanvas.computeConnectorY(connectorIndex)}},pfCanvas.ConnectorViewModel=function(connectorDataModel,x,y,parentNode){this.data=connectorDataModel,this._parentNode=parentNode,this._x=x,this._y=y,this.name=function(){return this.data.name},this.x=function(){return this._x},this.y=function(){return this._y},this.parentNode=function(){return this._parentNode},this.connected=function(){return this.data.connected},this.setConnected=function(value){this.data.connected=value},this.invalid=function(){return this.data.invalid},this.setInvalid=function(value){this.data.invalid=value},this.fontFamily=function(){return this.data.fontFamily||""},this.fontContent=function(){return this.data.fontContent||""}};var createConnectorsViewModel=function(connectorDataModels,x,parentNode){var viewModels=[];if(connectorDataModels)for(var i=0;i<connectorDataModels.length;++i){var connectorViewModel=new pfCanvas.ConnectorViewModel(connectorDataModels[i],x,pfCanvas.computeConnectorY(i),parentNode);viewModels.push(connectorViewModel)}return viewModels};pfCanvas.NodeViewModel=function(nodeDataModel){this.data=nodeDataModel,(!this.data.width||this.data.width<0)&&(this.data.width=pfCanvas.defaultNodeWidth),this.inputConnectors=createConnectorsViewModel(this.data.inputConnectors,0,this),this.outputConnectors=createConnectorsViewModel(this.data.outputConnectors,this.data.width,this),this._selected=!1,this.name=function(){return this.data.name||""},this.id=function(){return this.data.id||-1},this.image=function(){return this.data.image||""},this.icon=function(){return this.data.icon||""},this.bundle=function(){return this.data.bundle||""},this.backgroundColor=function(){return this.data.backgroundColor},this.x=function(){return this.data.x},this.y=function(){return this.data.y},this.width=function(){return this.data.width},this.fontFamily=function(){return this.data.fontFamily||""},this.fontSize=function(){return this.data.fontSize||""},this.fontContent=function(){return this.data.fontContent||""},this.validConnectionTypes=function(){return this.data.validConnectionTypes||[]},this.invalid=function(){return this.data.invalid},this.setInvalid=function(value){this.data.invalid=value},this.height=function(){return pfCanvas.defaultNodeHeight},this.select=function(){this._selected=!0},this.deselect=function(){this._selected=!1},this.toggleSelected=function(){this._selected=!this._selected},this.selected=function(){return this._selected},this._addConnector=function(connectorDataModel,x,connectorsDataModel,connectorsViewModel){var connectorViewModel=new pfCanvas.ConnectorViewModel(connectorDataModel,x,pfCanvas.computeConnectorY(connectorsViewModel.length),this);return connectorsDataModel.push(connectorDataModel),connectorsViewModel.push(connectorViewModel),connectorViewModel},this._removeConnector=function(connectorDataModel,connectorsDataModel,connectorsViewModel){var connectorIndex=connectorsDataModel.indexOf(connectorDataModel);connectorsDataModel.splice(connectorIndex,1),connectorsViewModel.splice(connectorIndex,1)},this.addInputConnector=function(connectorDataModel){this.data.inputConnectors||(this.data.inputConnectors=[]),this._addConnector(connectorDataModel,0,this.data.inputConnectors,this.inputConnectors)},this.getOutputConnector=function(){if(this.data.outputConnectors||(this.data.outputConnectors=[]),0===this.data.outputConnectors.length){var connectorDataModel={name:"out"};return this._addConnector(connectorDataModel,this.data.width,this.data.outputConnectors,this.outputConnectors)}return this.outputConnectors[0]},this.removeOutputConnector=function(connectorDataModel){this.data.outputConnectors&&this._removeConnector(connectorDataModel,this.data.outputConnectors,this.outputConnectors)},this.tags=function(){return this.data.tags}};var createNodesViewModel=function(nodesDataModel){var nodesViewModel=[];if(nodesDataModel)for(var i=0;i<nodesDataModel.length;++i)nodesViewModel.push(new pfCanvas.NodeViewModel(nodesDataModel[i]));return nodesViewModel};pfCanvas.NodeActionViewModel=function(nodeActionDataModel){this.data=nodeActionDataModel,this.id=function(){return this.data.id||""},this.name=function(){return this.data.name||""},this.iconClass=function(){return this.data.iconClass||""},this.action=function(){return this.data.action||""}};var createNodeActionsViewModel=function(nodeActionsDataModel){var nodeActionsViewModel=[];if(nodeActionsDataModel)for(var i=0;i<nodeActionsDataModel.length;++i)nodeActionsViewModel.push(new pfCanvas.NodeActionViewModel(nodeActionsDataModel[i]));return nodeActionsViewModel};pfCanvas.ConnectionViewModel=function(connectionDataModel,sourceConnector,destConnector){this.data=connectionDataModel,this.source=sourceConnector,this.dest=destConnector,this._selected=!1,this.name=function(){return destConnector.name()||""},this.sourceCoordX=function(){return this.source.parentNode().x()+this.source.x()},this.sourceCoordY=function(){return this.source.parentNode().y()+this.source.y()},this.sourceCoord=function(){return{x:this.sourceCoordX(),y:this.sourceCoordY()}},this.sourceTangentX=function(){return pfCanvas.computeConnectionSourceTangentX(this.sourceCoord(),this.destCoord())},this.sourceTangentY=function(){return pfCanvas.computeConnectionSourceTangentY(this.sourceCoord(),this.destCoord())},this.destCoordX=function(){return this.dest.parentNode().x()+this.dest.x()},this.destCoordY=function(){return this.dest.parentNode().y()+this.dest.y()},this.destCoord=function(){return{x:this.destCoordX(),y:this.destCoordY()}},this.destTangentX=function(){return pfCanvas.computeConnectionDestTangentX(this.sourceCoord(),this.destCoord())},this.destTangentY=function(){return pfCanvas.computeConnectionDestTangentY(this.sourceCoord(),this.destCoord())},this.middleX=function(scale){return angular.isUndefined(scale)&&(scale=.5),this.sourceCoordX()*(1-scale)+this.destCoordX()*scale},this.middleY=function(scale){return angular.isUndefined(scale)&&(scale=.5),this.sourceCoordY()*(1-scale)+this.destCoordY()*scale},this.select=function(){this._selected=!0},this.deselect=function(){this._selected=!1},this.toggleSelected=function(){this._selected=!this._selected},this.selected=function(){return this._selected}};var computeConnectionTangentOffset=function(pt1,pt2){return(pt2.x-pt1.x)/2};pfCanvas.computeConnectionSourceTangentX=function(pt1,pt2){return pt1.x+computeConnectionTangentOffset(pt1,pt2)},pfCanvas.computeConnectionSourceTangentY=function(pt1,pt2){return pt1.y},pfCanvas.computeConnectionSourceTangent=function(pt1,pt2){return{x:pfCanvas.computeConnectionSourceTangentX(pt1,pt2),y:pfCanvas.computeConnectionSourceTangentY(pt1,pt2)}},pfCanvas.computeConnectionDestTangentX=function(pt1,pt2){return pt2.x-computeConnectionTangentOffset(pt1,pt2)},pfCanvas.computeConnectionDestTangentY=function(pt1,pt2){return pt2.y},pfCanvas.computeConnectionDestTangent=function(pt1,pt2){return{x:pfCanvas.computeConnectionDestTangentX(pt1,pt2),y:pfCanvas.computeConnectionDestTangentY(pt1,pt2)}},pfCanvas.ChartViewModel=function(chartDataModel){this.findNode=function(nodeID){for(var i=0;i<this.nodes.length;++i){var node=this.nodes[i];if(node.data.id===nodeID)return node}throw new Error("Failed to find node "+nodeID)},this.findInputConnector=function(nodeID,connectorIndex){var node=this.findNode(nodeID);if(!node.inputConnectors||node.inputConnectors.length<=connectorIndex)throw new Error("Node "+nodeID+" has invalid input connectors.");return node.inputConnectors[connectorIndex]},this.findOutputConnector=function(nodeID,connectorIndex){var node=this.findNode(nodeID);return node.getOutputConnector()},this._createConnectionViewModel=function(connectionDataModel){var sourceConnector=this.findOutputConnector(connectionDataModel.source.nodeID,connectionDataModel.source.connectorIndex),destConnector=this.findInputConnector(connectionDataModel.dest.nodeID,connectionDataModel.dest.connectorIndex);return sourceConnector.setConnected(!0),destConnector.setConnected(!0),new pfCanvas.ConnectionViewModel(connectionDataModel,sourceConnector,destConnector)},this._createConnectionsViewModel=function(connectionsDataModel){var connectionsViewModel=[];if(connectionsDataModel)for(var i=0;i<connectionsDataModel.length;++i)connectionsViewModel.push(this._createConnectionViewModel(connectionsDataModel[i]));return connectionsViewModel},this.data=chartDataModel,this.nodes=createNodesViewModel(this.data.nodes),this.nodeActions=createNodeActionsViewModel(this.data.nodeActions),this.connections=this._createConnectionsViewModel(this.data.connections),this.validConnections=!0,this.zoom=new pfCanvas.ZoomViewModel,this.inConnectingMode=!1,this.clickedOnChart=!1,this.createNewConnection=function(startConnector,endConnector){var connectionsDataModel=this.data.connections;connectionsDataModel||(connectionsDataModel=this.data.connections=[]);var connectionsViewModel=this.connections;connectionsViewModel||(connectionsViewModel=this.connections=[]);var startNode=startConnector.parentNode(),startConnectorIndex=startNode.outputConnectors.indexOf(startConnector);startConnector=startNode.outputConnectors[startConnectorIndex];var startConnectorType="output";if(-1===startConnectorIndex&&(startConnectorIndex=startNode.inputConnectors.indexOf(startConnector),startConnectorType="input",-1===startConnectorIndex))throw new Error("Failed to find source connector within either inputConnectors or outputConnectors of source node.");var endNode=endConnector.parentNode(),endConnectorIndex=endNode.inputConnectors.indexOf(endConnector);endConnector=endNode.inputConnectors[endConnectorIndex];var endConnectorType="input";if(-1===endConnectorIndex&&(endConnectorIndex=endNode.outputConnectors.indexOf(endConnector),endConnectorType="output",-1===endConnectorIndex))throw new Error("Failed to find dest connector within inputConnectors or outputConnectors of dest node.");if(startConnectorType===endConnectorType)throw new Error("Failed to create connection. Only output to input connections are allowed.");if(startNode===endNode)throw new Error("Failed to create connection. Cannot link a node with itself.");startNode={nodeID:startNode.data.id,connectorIndex:startConnectorIndex},endNode={nodeID:endNode.data.id,connectorIndex:endConnectorIndex};var connectionDataModel={source:"output"===startConnectorType?startNode:endNode,dest:"output"===startConnectorType?endNode:startNode};connectionsDataModel.push(connectionDataModel);var outputConnector="output"===startConnectorType?startConnector:endConnector,inputConnector="output"===startConnectorType?endConnector:startConnector,connectionViewModel=new pfCanvas.ConnectionViewModel(connectionDataModel,outputConnector,inputConnector);connectionsViewModel.push(connectionViewModel),startConnector.setConnected(!0),endConnector.setConnected(!0)},this.addNode=function(nodeDataModel){this.data.nodes||(this.data.nodes=[]),this.data.nodes.push(nodeDataModel),this.nodes.push(new pfCanvas.NodeViewModel(nodeDataModel))},this.selectAll=function(){for(var nodes=this.nodes,i=0;i<nodes.length;++i){var node=nodes[i];node.select()}var connections=this.connections;for(i=0;i<connections.length;++i){var connection=connections[i];connection.select()}},this.deselectAll=function(){for(var nodes=this.nodes,i=0;i<nodes.length;++i){var node=nodes[i];node.deselect(),node.toolbarDlgOpen=!1}var connections=this.connections;for(i=0;i<connections.length;++i){var connection=connections[i];connection.deselect()}},this.updateValidNodesAndConnectors=function(sourceNode){this.validConnections=!1;for(var validConnectionTypes=sourceNode.validConnectionTypes(),i=0;i<this.nodes.length;++i){var node=this.nodes[i];node.setInvalid(!0);for(var c=0;c<node.inputConnectors.length;c++){var inputConnector=node.inputConnectors[c];inputConnector.setInvalid(-1===validConnectionTypes.indexOf(inputConnector.data.type)),inputConnector.invalid()||node===sourceNode||inputConnector.connected()||(node.setInvalid(!1),this.validConnections=!0)}}},this.resetValidNodesAndConnectors=function(){for(var i=0;i<this.nodes.length;++i){var node=this.nodes[i];node.setInvalid(!1);for(var c=0;c<node.inputConnectors.length;c++){var inputConnector=node.inputConnectors[c];inputConnector.setInvalid(!1)}}},this.removeOutputConnector=function(connectorViewModel){var parentNode=connectorViewModel.parentNode();parentNode.removeOutputConnector(connectorViewModel.data)},this.updateSelectedNodesLocation=function(deltaX,deltaY){for(var selectedNodes=this.getSelectedNodes(),i=0;i<selectedNodes.length;++i){var node=selectedNodes[i];node.data.x+=deltaX,node.data.y+=deltaY}},this.handleNodeClicked=function(node,ctrlKey){ctrlKey?node.toggleSelected():(this.deselectAll(),node.select());var nodeIndex=this.nodes.indexOf(node);if(-1===nodeIndex)throw new Error("Failed to find node in view model!");this.nodes.splice(nodeIndex,1),this.nodes.push(node)},this.handleConnectionMouseDown=function(connection,ctrlKey){ctrlKey?connection.toggleSelected():(this.deselectAll(),connection.select())},this.duplicateSelectedNode=function(){var duplicatedNode=angular.copy(this.getSelectedNodes()[0]);return delete duplicatedNode.data.outputConnectors,duplicatedNode.data},this.deleteSelected=function(){for(var newNodeViewModels=[],newNodeDataModels=[],deletedNodeIds=[],nodeIndex=0;nodeIndex<this.nodes.length;++nodeIndex){var node=this.nodes[nodeIndex];node.selected()?deletedNodeIds.push(node.data.id):(newNodeViewModels.push(node),newNodeDataModels.push(node.data))}for(var newConnectionViewModels=[],newConnectionDataModels=[],connectionIndex=0;connectionIndex<this.connections.length;++connectionIndex){var connection=this.connections[connectionIndex];if(connection.selected()){if(-1===deletedNodeIds.indexOf(connection.data.source.nodeID)){var sourceConnectorViewModel=connection.source;if(!sourceConnectorViewModel)throw new Error("Failed to find source node of deleted connection!");sourceConnectorViewModel._parentNode.removeOutputConnector(sourceConnectorViewModel.data);var destConnectorViewModel=connection.dest;if(!destConnectorViewModel)throw new Error("Failed to find dest node of deleted connection!");destConnectorViewModel.setConnected(!1)}}else-1===deletedNodeIds.indexOf(connection.data.source.nodeID)&&-1===deletedNodeIds.indexOf(connection.data.dest.nodeID)&&(newConnectionViewModels.push(connection),newConnectionDataModels.push(connection.data))}this.nodes=newNodeViewModels,this.data.nodes=newNodeDataModels,this.connections=newConnectionViewModels,this.data.connections=newConnectionDataModels},this.applySelectionRect=function(selectionRect){this.deselectAll();for(var i=0;i<this.nodes.length;++i){var node=this.nodes[i];node.x()>=selectionRect.x&&node.y()>=selectionRect.y&&node.x()+node.width()<=selectionRect.x+selectionRect.width&&node.y()+node.height()<=selectionRect.y+selectionRect.height&&node.select()}for(i=0;i<this.connections.length;++i){var connection=this.connections[i];connection.source.parentNode().selected()&&connection.dest.parentNode().selected()&&connection.select()}},this.getSelectedNodes=function(){for(var selectedNodes=[],i=0;i<this.nodes.length;++i){var node=this.nodes[i];node.selected()&&selectedNodes.push(node)}return selectedNodes},this.isOnlyOneNodeSelected=function(){return 1===this.getSelectedNodes().length},this.areAnyNodesSelected=function(){return this.getSelectedNodes().length>0},this.getSelectedConnections=function(){for(var selectedConnections=[],i=0;i<this.connections.length;++i){var connection=this.connections[i];connection.selected()&&selectedConnections.push(connection)}return selectedConnections}},pfCanvas.ZoomViewModel=function(){this.max=1,this.min=parseFloat(".5"),this.inc=parseFloat(".25"),this.level=this.max,this.isMax=function(){return this.level===this.max},this.isMin=function(){return this.level===this.min},this.getBackgroundSize=function(){var size=pfCanvas.defaultBgImageSize*this.getLevel();return size},this.getChartHeight=function(){var height=pfCanvas.defaultHeight/this.min*this.getLevel();return height},this.getChartWidth=function(){var width=pfCanvas.defaultWidth/this.min*this.getLevel();return width},this.getLevel=function(){return this.level},this["in"]=function(){this.isMax()||(this.level=(10*this.level+10*this.inc)/10)},this.out=function(){this.isMin()||(this.level=(10*this.level-10*this.inc)/10)}}}(),function(){"use strict";function Factory(mouseCapture){var threshold=5;return{startDrag:function(evt,config){var dragging=!1,x=evt.pageX,y=evt.pageY,mouseMove=function(evt){dragging?(config.dragging&&config.dragging(evt.pageX,evt.pageY,evt),x=evt.pageX,y=evt.pageY):(Math.abs(evt.pageX-x)>threshold||Math.abs(evt.pageY-y)>threshold)&&(dragging=!0,config.dragStarted&&config.dragStarted(x,y,evt),config.dragging&&config.dragging(evt.pageX,evt.pageY,evt))},released=function(){dragging?config.dragEnded&&config.dragEnded():config.clicked&&config.clicked()},mouseUp=function(evt){mouseCapture.release(),evt.stopPropagation(),evt.preventDefault()};mouseCapture.acquire(evt,{mouseMove:mouseMove,mouseUp:mouseUp,released:released}),evt.stopPropagation(),evt.preventDefault()}}}angular.module("dragging",["mouseCapture"]).factory("dragging",["mouseCapture",Factory])}(),function(){"use strict";function Factory($rootScope){var $element=document,mouseCaptureConfig=null,mouseMove=function(evt){mouseCaptureConfig&&mouseCaptureConfig.mouseMove&&(mouseCaptureConfig.mouseMove(evt),$rootScope.$digest())},mouseUp=function(evt){mouseCaptureConfig&&mouseCaptureConfig.mouseUp&&(mouseCaptureConfig.mouseUp(evt),$rootScope.$digest())};return{registerElement:function(element){$element=element},acquire:function(evt,config){this.release(),mouseCaptureConfig=config,$element.mousemove(mouseMove),$element.mouseup(mouseUp)},release:function(){mouseCaptureConfig&&(mouseCaptureConfig.released&&mouseCaptureConfig.released(),mouseCaptureConfig=null),$element.unbind("mousemove",mouseMove),$element.unbind("mouseup",mouseUp)}}}function ComponentDirective(){return{restrict:"A",controller:["$scope","$element","$attrs","mouseCapture",function($scope,$element,$attrs,mouseCapture){mouseCapture.registerElement($element)}]}}angular.module("mouseCapture",[]).factory("mouseCapture",["$rootScope",Factory]).directive("mouseCapture",[ComponentDirective])}(),function(){"use strict";angular.module("patternfly.canvas").component("nodeToolbar",{templateUrl:"canvas-view/canvas/node-toolbar.html",bindings:{node:"=",nodeActions:"=",nodeClickHandler:"<",nodeCloseHandler:"<"},controller:["$scope",function($scope){var ctrl=this;ctrl.selectedAction="none",ctrl.actionIconClicked=function(action){ctrl.selectedAction=action,$scope.$emit("nodeActionClicked",{action:action,node:ctrl.node}),angular.isFunction(ctrl.nodeClickHandler)&&ctrl.nodeClickHandler(action,ctrl.node)},ctrl.close=function(){
ctrl.selectedAction="none",$scope.$emit("nodeActionClosed"),angular.isFunction(ctrl.nodeCloseHandler)&&ctrl.nodeCloseHandler()}}]})}(),angular.module("patternfly.card").component("pfAggregateStatusCard",{bindings:{status:"=",showTopBorder:"@?",showSpinner:"<?",spinnerText:"@?",spinnerCardHeight:"@?",altLayout:"@?",layout:"@?"},templateUrl:"card/aggregate-status/aggregate-status-card.html",controller:function(){"use strict";var ctrl=this;ctrl.$onInit=function(){ctrl.shouldShowTopBorder="true"===ctrl.showTopBorder,ctrl.isAltLayout="true"===ctrl.altLayout||"tall"===ctrl.layout,ctrl.isMiniLayout="mini"===ctrl.layout,ctrl.showSpinner=ctrl.showSpinner===!0,ctrl.spinnerCardHeight&&(ctrl.spinnerHeight={height:ctrl.spinnerCardHeight})}}}),angular.module("patternfly.card").component("pfCard",{transclude:!0,templateUrl:"card/basic/card.html",bindings:{headTitle:"@",subTitle:"@?",showTopBorder:"@?",showTitlesSeparator:"@?",showSpinner:"<?",spinnerText:"@?",footer:"=?",filter:"=?"},controller:function(){"use strict";var ctrl=this;ctrl.filter&&!ctrl.currentFilter&&(ctrl.filter.defaultFilter?ctrl.currentFilter=ctrl.filter.filters[ctrl.filter.defaultFilter]:ctrl.currentFilter=ctrl.filter.filters[0]),ctrl.footerCallBackFn=function(){ctrl.footerCallBackResult=ctrl.footer.callBackFn()},ctrl.filterCallBackFn=function(f){ctrl.currentFilter=f,ctrl.filter.callBackFn&&(ctrl.filterCallBackResult=ctrl.filter.callBackFn(f))},ctrl.showHeader=function(){return ctrl.headTitle||ctrl.showFilterInHeader()},ctrl.showFilterInHeader=function(){return ctrl.filter&&ctrl.filter.filters&&ctrl.filter.position&&"header"===ctrl.filter.position},ctrl.showFilterInFooter=function(){return ctrl.filter&&ctrl.filter.filters&&(!ctrl.filter.position||"footer"===ctrl.filter.position)},ctrl.$onInit=function(){ctrl.shouldShowTitlesSeparator=!ctrl.showTitlesSeparator||"true"===ctrl.showTitlesSeparator,ctrl.showSpinner=ctrl.showSpinner===!0}}}),angular.module("patternfly.card").component("pfInfoStatusCard",{bindings:{status:"=",showTopBorder:"@?",showSpinner:"<?",spinnerText:"@?",spinnerCardHeight:"@?",htmlContent:"@?"},templateUrl:"card/info-status/info-status-card.html",controller:["$sce",function($sce){"use strict";var ctrl=this;ctrl.$onInit=function(){ctrl.shouldShowTopBorder="true"===ctrl.showTopBorder,ctrl.shouldShowHtmlContent="true"===ctrl.htmlContent,ctrl.showSpinner=ctrl.showSpinner===!0,ctrl.trustAsHtml=function(html){return $sce.trustAsHtml(html)},ctrl.spinnerCardHeight&&(ctrl.spinnerHeight={height:ctrl.spinnerCardHeight})}}]}),function(){"use strict";var patternflyDefaults=patternfly.c3ChartDefaults();angular.module("patternfly.charts").constant("c3ChartDefaults",{getDefaultColors:patternflyDefaults.getDefaultColors,getDefaultDonut:patternflyDefaults.getDefaultDonut,getDefaultDonutSize:patternflyDefaults.getDefaultDonutSize,getDefaultDonutColor:patternflyDefaults.getDefaultDonutColors,getDefaultDonutLegend:patternflyDefaults.getDefaultDonutLegend,getDefaultDonutConfig:patternflyDefaults.getDefaultDonutConfig,getDefaultSparklineArea:patternflyDefaults.getDefaultSparklineArea,getDefaultSparklineSize:patternflyDefaults.getDefaultSparklineSize,getDefaultSparklineAxis:patternflyDefaults.getDefaultSparklineAxis,getDefaultSparklineColor:patternflyDefaults.getDefaultColors,getDefaultSparklineLegend:patternflyDefaults.getDefaultSparklineLegend,getDefaultSparklinePoint:patternflyDefaults.getDefaultSparklinePoint,getDefaultSparklineTooltip:patternflyDefaults.getDefaultSparklineTooltip,getDefaultSparklineConfig:patternflyDefaults.getDefaultSparklineConfig,getDefaultLineConfig:patternflyDefaults.getDefaultLineConfig})}(),function(){"use strict";angular.module("patternfly.charts").component("pfC3Chart",{bindings:{config:"<",getChartCallback:"<"},template:'<div id=""></div>',controller:["$timeout","$attrs",function($timeout,$attrs){var prevConfig,chart,ctrl=this;ctrl.generateChart=function(){var chartData;prevConfig=angular.copy(ctrl.config),$timeout(function(){chartData=ctrl.config,chartData&&(chartData.bindto="#"+$attrs.id,!chart||-1!==$attrs.id.indexOf("donutPctChart")&&chartData.thresholds?chart=c3.generate(chartData):chart.load(ctrl.config.data),ctrl.getChartCallback&&ctrl.getChartCallback(chart),prevConfig=angular.copy(ctrl.config))})},ctrl.$doCheck=function(){angular.equals(ctrl.config,prevConfig)||ctrl.generateChart()}}]})}(),angular.module("patternfly.charts").component("pfDonutChart",{bindings:{config:"<",data:"<",chartHeight:"<?"},templateUrl:"charts/donut/donut-chart.html",controller:["pfUtils","$element","$timeout","$log",function(pfUtils,$element,$timeout,$log){"use strict";var prevData,ctrl=this;ctrl.$onInit=function(){ctrl.donutChartId="donutChart",ctrl.config.chartId&&(ctrl.donutChartId=ctrl.config.chartId+ctrl.donutChartId),ctrl.updateAll()},ctrl.getDonutData=function(){return{type:"donut",columns:ctrl.data,order:null,colors:ctrl.config.colors}},ctrl.updateAll=function(){prevData=angular.copy(ctrl.data),ctrl.config=pfUtils.merge(patternfly.c3ChartDefaults().getDefaultDonutConfig(),ctrl.config),ctrl.config.tooltip={contents:patternfly.pfDonutTooltipContents},ctrl.config.data=ctrl.getDonutData(),ctrl.config.data.onclick=ctrl.config.onClickFn},ctrl.getTotal=function(){var total=0;return angular.forEach(ctrl.data,function(value){angular.forEach(value,function(value){isNaN(value)||(total+=Number(value))})}),total},ctrl.getCenterLabelText=function(){var centerLabelText;return centerLabelText={bigText:ctrl.getTotal(),smText:ctrl.config.donut.title},ctrl.config.centerLabelFn&&(centerLabelText.bigText=ctrl.config.centerLabelFn(),centerLabelText.smText=""),centerLabelText},ctrl.setupDonutChartTitle=function(){var donutChartTitle,centerLabelText;angular.isUndefined(ctrl.chart)||(donutChartTitle=d3.select(ctrl.chart.element).select("text.c3-chart-arcs-title"),donutChartTitle&&(centerLabelText=ctrl.getCenterLabelText(),donutChartTitle.text(""),centerLabelText.bigText&&!centerLabelText.smText?donutChartTitle.text(centerLabelText.bigText):(donutChartTitle.insert("tspan").text(centerLabelText.bigText).classed("donut-title-big-pf",!0).attr("dy",0).attr("x",0),donutChartTitle.insert("tspan").text(centerLabelText.smText).classed("donut-title-small-pf",!0).attr("dy",20).attr("x",0))))},ctrl.setChart=function(chart){ctrl.chart=chart,ctrl.setupDonutChartTitle()},ctrl.$onChanges=function(changesObj){(changesObj.config||changesObj.data)&&ctrl.updateAll(),changesObj.chartHeight&&(ctrl.config.size.height=changesObj.chartHeight.currentValue)},ctrl.$doCheck=function(){angular.equals(ctrl.data,prevData)||ctrl.updateAll()}}]}),angular.module("patternfly.charts").component("pfDonutPctChart",{bindings:{config:"<",data:"<",tooltip:"<",chartHeight:"<?",centerLabel:"<?",onThresholdChange:"&"},templateUrl:"charts/donut/donut-pct-chart.html",controller:["pfUtils","$scope",function(pfUtils,$scope){"use strict";var prevData,ctrl=this;ctrl.$id=$scope.$id,ctrl.$onInit=function(){ctrl.donutChartId="donutPctChart"+ctrl.$id,ctrl.config.chartId&&(ctrl.donutChartId=ctrl.config.chartId+ctrl.donutChartId),ctrl.updateAll()},ctrl.updateAvailable=function(){ctrl.data.available=ctrl.data.total-ctrl.data.used},ctrl.updatePercentage=function(){ctrl.data.percent=Math.round(ctrl.data.used/ctrl.data.total*100)},ctrl.getStatusColor=function(used,thresholds){var threshold="none",color=pfUtils.colorPalette.blue;return thresholds&&(threshold="ok",color=pfUtils.colorPalette.green,used>=thresholds.error?(threshold="error",color=pfUtils.colorPalette.red):used>=thresholds.warning&&(threshold="warning",color=pfUtils.colorPalette.orange)),ctrl.threshold&&ctrl.threshold===threshold||(ctrl.threshold=threshold,ctrl.onThresholdChange({threshold:ctrl.threshold})),color},ctrl.statusDonutColor=function(){var color,percentUsed;return color={pattern:[]},percentUsed=ctrl.data.used/ctrl.data.total*100,color.pattern[0]=ctrl.getStatusColor(percentUsed,ctrl.config.thresholds),color.pattern[1]=pfUtils.colorPalette.black300,color},ctrl.donutTooltip=function(){return{contents:function(d){var tooltipContent='<span class="donut-tooltip-pf" style="white-space: nowrap;">'+Math.round(100*d[0].ratio)+"% "+d[0].name+"</span>";return ctrl.config.tooltipFn?tooltipContent='<span class="donut-tooltip-pf" style="white-space: nowrap;">'+ctrl.config.tooltipFn(d)+"</span>":"amount"===ctrl.tooltip?tooltipContent='<span class="donut-tooltip-pf" style="white-space: nowrap;">'+d[0].value+" "+ctrl.config.units+" "+d[0].name+"</span>":"both"===ctrl.tooltip&&(tooltipContent='<table class="c3-tooltip"><tbody><tr><td>'+d[0].value+" "+ctrl.config.units+" "+d[0].name+"</td><td>"+Math.round(100*d[0].ratio)+"%</td></tr></tbody></table>"),tooltipContent}}},ctrl.getDonutData=function(){return{columns:[["Used",ctrl.data.used],["Available",ctrl.data.available]],type:"donut",donut:{label:{show:!1}},groups:[["used","available"]],order:null}},ctrl.getCenterLabelText=function(){var centerLabelText;return centerLabelText={bigText:ctrl.data.used,smText:ctrl.config.units+" Used"},ctrl.config.centerLabelFn?(centerLabelText.bigText=ctrl.config.centerLabelFn(),centerLabelText.smText=""):"none"===ctrl.centerLabel?(centerLabelText.bigText="",centerLabelText.smText=""):"available"===ctrl.centerLabel?(centerLabelText.bigText=ctrl.data.available,centerLabelText.smText=ctrl.config.units+" Available"):"percent"===ctrl.centerLabel&&(centerLabelText.bigText=Math.round(ctrl.data.used/ctrl.data.total*100)+"%",centerLabelText.smText="of "+ctrl.data.total+" "+ctrl.config.units),centerLabelText},ctrl.updateAll=function(){prevData=angular.copy(ctrl.data),ctrl.config=pfUtils.merge(patternfly.c3ChartDefaults().getDefaultDonutConfig(),ctrl.config),ctrl.updateAvailable(),ctrl.updatePercentage(),ctrl.config.data=pfUtils.merge(ctrl.config.data,ctrl.getDonutData()),ctrl.config.color=ctrl.statusDonutColor(ctrl),ctrl.config.tooltip=ctrl.donutTooltip(),ctrl.config.data.onclick=ctrl.config.onClickFn},ctrl.setupDonutChartTitle=function(){var donutChartTitle,centerLabelText;angular.isUndefined(ctrl.chart)||(donutChartTitle=d3.select(ctrl.chart.element).select("text.c3-chart-arcs-title"),donutChartTitle&&(centerLabelText=ctrl.getCenterLabelText(),donutChartTitle.selectAll("*").remove(),centerLabelText.bigText&&!centerLabelText.smText?donutChartTitle.text(centerLabelText.bigText):(donutChartTitle.insert("tspan").text(centerLabelText.bigText).classed("donut-title-big-pf",!0).attr("dy",0).attr("x",0),donutChartTitle.insert("tspan").text(centerLabelText.smText).classed("donut-title-small-pf",!0).attr("dy",20).attr("x",0))))},ctrl.setChart=function(chart){ctrl.chart=chart,ctrl.setupDonutChartTitle()},ctrl.$onChanges=function(changesObj){(changesObj.config||changesObj.data)&&ctrl.updateAll(),changesObj.chartHeight&&(ctrl.config.size.height=changesObj.chartHeight.currentValue),changesObj.centerLabel&&ctrl.setupDonutChartTitle()},ctrl.$doCheck=function(){angular.equals(ctrl.data,prevData)||ctrl.updateAll()}}]}),angular.module("patternfly.charts").component("pfEmptyChart",{bindings:{chartHeight:"<?"},templateUrl:"charts/empty-chart.html",controller:function(){"use strict";var ctrl=this;ctrl.setSizeStyles=function(){var height=ctrl.chartHeight||40,topPadding=Math.min(Math.round((height-40)/2),20);ctrl.sizeStyles={height:height+"px","padding-top":topPadding+"px"}},ctrl.setSizeStyles(),ctrl.$onChanges=function(changesObj){changesObj.chartHeight&&ctrl.setSizeStyles()}}}),angular.module("patternfly.charts").component("pfHeatmapLegend",{bindings:{legend:"<?",legendColors:"<?"},templateUrl:"charts/heatmap/heatmap-legend.html",controller:function(){"use strict";var ctrl=this,heatmapColorPatternDefaults=["#d4f0fa","#F9D67A","#EC7A08","#CE0000"],legendLabelDefaults=["< 70%","70-80%","80-90%","> 90%"];ctrl.$onInit=function(){ctrl.updateAll()},ctrl.updateAll=function(){var index,items=[];for(ctrl.legendColors||(ctrl.legendColors=heatmapColorPatternDefaults),ctrl.legend||(ctrl.legend=legendLabelDefaults),index=ctrl.legend.length-1;index>=0;index--)items.push({text:ctrl.legend[index],color:ctrl.legendColors[index]});ctrl.legendItems=items},ctrl.$onChanges=function(changesObj){changesObj.legend&&!changesObj.legend.isFirstChange()&&ctrl.updateAll(),changesObj.legendColors&&!changesObj.legendColors.isFirstChange()&&ctrl.updateAll()}}}),angular.module("patternfly.charts").component("pfHeatmap",{bindings:{data:"<",chartDataAvailable:"<?",height:"<?",chartTitle:"<?",showLegend:"<?",legendLabels:"<?",maxBlockSize:"@",minBlockSize:"@",blockPadding:"@",thresholds:"<?",heatmapColorPattern:"<?",clickAction:"<?",rangeOnHover:"<?",rangeHoverSize:"@",rangeTooltips:"<?"},templateUrl:"charts/heatmap/heatmap.html",controller:["$element","$window","$compile","$scope","$timeout",function($element,$window,$compile,$scope,$timeout){"use strict";var prevData,containerWidth,containerHeight,blockSize,numberOfRows,ctrl=this,thresholdDefaults=[.7,.8,.9],heatmapColorPatternDefaults=["#d4f0fa","#F9D67A","#EC7A08","#CE0000"],legendLabelDefaults=["< 70%","70-80%","80-90%","> 90%"],rangeTooltipDefaults=["< 70%","70-80%","80-90%","> 90%"],heightDefault=200,setStyles=function(){ctrl.containerStyles={height:ctrl.height+"px",display:ctrl.chartDataAvailable===!1?"none":"block"}},setSizes=function(){var parentContainer=$element[0].querySelector(".heatmap-container");containerWidth=parentContainer.clientWidth,containerHeight=parentContainer.clientHeight,blockSize=determineBlockSize(),blockSize-ctrl.padding>ctrl.maxSize?(blockSize=ctrl.padding+ctrl.maxSize,numberOfRows=Math.ceil(Math.sqrt(ctrl.data.length)),(blockSize*numberOfRows>containerWidth||blockSize*numberOfRows>containerHeight)&&(numberOfRows=0===blockSize?0:Math.floor(containerHeight/blockSize))):blockSize-ctrl.padding<ctrl.minSize?(blockSize=ctrl.padding+ctrl.minSize,numberOfRows=Math.ceil(Math.sqrt(ctrl.data.length)),(blockSize*numberOfRows>containerWidth||blockSize*numberOfRows>containerHeight)&&(numberOfRows=0===blockSize?0:Math.floor(containerHeight/blockSize))):numberOfRows=0===blockSize?0:Math.floor(containerHeight/blockSize)},determineBlockSize=function(){var sx,sy,x=containerWidth,y=containerHeight,n=ctrl.data?ctrl.data.length:0,px=Math.ceil(Math.sqrt(n*x/y)),py=Math.ceil(Math.sqrt(n*y/x));return sx=Math.floor(px*y/x)*px<n?y/Math.ceil(px*y/x):x/px,sy=Math.floor(py*x/y)*py<n?x/Math.ceil(x*py/y):y/py,Math.max(sx,sy)},redraw=function(){var blocks,data=ctrl.data,color=d3.scale.threshold().domain(ctrl.thresholds).range(ctrl.heatmapColorPattern),rangeTooltip=d3.scale.threshold().domain(ctrl.thresholds).range(ctrl.rangeTooltips),fillSize=blockSize-ctrl.padding,highlightBlock=function(block,active){block.style("fill-opacity",active?1:.4)},highlightBlockColor=function(block,fillColor){var blockColor=color(block.map(function(d){return d[0].__data__.value}));blockColor===fillColor&&block.style("fill-opacity",1)},svg=window.d3.select(ctrl.thisComponent);svg.selectAll("*").remove(),blocks=svg.selectAll("rect").data(data).enter().append("rect"),blocks.attr("x",function(d,i){return Math.floor(i/numberOfRows)*blockSize}).attr("y",function(d,i){return i%numberOfRows*blockSize}).attr("width",fillSize).attr("height",fillSize).style("fill",function(d){return color(d.value)}).attr("uib-tooltip-html",function(d,i){return ctrl.rangeOnHover&&fillSize<=ctrl.rangeHoverSize?'"'+rangeTooltip(d.value)+'"':"'"+d.tooltip+"'"}).attr("tooltip-append-to-body",function(d,i){return!0}).attr("tooltip-animation",function(d,i){return!1}),blocks.on("mouseover",function(){var fillColor;blocks.call(highlightBlock,!1),ctrl.rangeOnHover&&fillSize<=ctrl.rangeHoverSize?(fillColor=color(d3.select(this).map(function(d){return d[0].__data__.value})),blocks[0].forEach(function(block){highlightBlockColor(d3.select(block),fillColor)})):d3.select(this).call(highlightBlock,!0)}),blocks.on("click",function(d){ctrl.clickAction&&ctrl.clickAction(d)}),angular.forEach(angular.element(blocks),function(block){var el=angular.element(block);$compile(el)($scope)}),svg.on("mouseleave",function(){blocks.call(highlightBlock,!0)})},updateDisplay=function(){setStyles(),ctrl.chartDataAvailable!==!1&&ctrl.data&&(ctrl.loadingDone=!0,$timeout(function(){setSizes(),redraw()}))},handleDataUpdate=function(){prevData=angular.copy(ctrl.data),updateDisplay()},debounceResize=_.debounce(function(){updateDisplay()},250,500),updateConfig=function(){void 0===ctrl.maxBlockSize||isNaN(ctrl.maxBlockSize)?ctrl.maxSize=64:(ctrl.maxSize=parseInt(ctrl.maxBlockSize),ctrl.maxSize<5?ctrl.maxSize=5:ctrl.maxSize>50&&(ctrl.maxSize=50)),void 0===ctrl.minBlockSize||isNaN(ctrl.minBlockSize)?ctrl.minSize=2:ctrl.minSize=parseInt(ctrl.minBlockSize),void 0===ctrl.blockPadding||isNaN(ctrl.blockPadding)?ctrl.padding=2:ctrl.padding=parseInt(ctrl.blockPadding),void 0===ctrl.rangeHoverSize||isNaN(ctrl.rangeHoverSize)?ctrl.rangeHoverSize=15:ctrl.rangeHoverSize=parseInt(ctrl.rangeHoverSize),ctrl.rangeOnHover=void 0===ctrl.rangeOnHover||ctrl.rangeOnHover?!0:!1,ctrl.rangeTooltips||(ctrl.rangeTooltips=rangeTooltipDefaults),ctrl.thresholds||(ctrl.thresholds=thresholdDefaults),ctrl.heatmapColorPattern||(ctrl.heatmapColorPattern=heatmapColorPatternDefaults),ctrl.legendLabels||(ctrl.legendLabels=legendLabelDefaults),ctrl.height=ctrl.height||heightDefault,ctrl.showLegend=ctrl.showLegend||void 0===ctrl.showLegend};ctrl.loadingDone=!1,ctrl.$onChanges=function(changesObj){changesObj.chartDataAvailable&&!changesObj.chartDataAvailable.isFirstChange()?setStyles():changesObj.data||(updateConfig(),updateDisplay())},ctrl.$doCheck=function(){angular.equals(ctrl.data,prevData)||handleDataUpdate()},ctrl.$postLink=function(){ctrl.thisComponent=$element[0].querySelector(".heatmap-pf-svg"),updateConfig(),handleDataUpdate(),angular.element($window).on("resize",debounceResize)},ctrl.$onDestroy=function(){angular.element($window).off("resize",debounceResize)}}]}),angular.module("patternfly.charts").component("pfLineChart",{bindings:{config:"<",chartData:"<",showXAxis:"<?",showYAxis:"<?",setAreaChart:"<?"},templateUrl:"charts/line/line-chart.html",controller:["pfUtils",function(pfUtils){"use strict";var prevChartData,ctrl=this;ctrl.updateAll=function(){prevChartData=angular.copy(ctrl.chartData),void 0===ctrl.lineChartId&&(ctrl.lineChartId="lineChart",ctrl.config.chartId&&(ctrl.lineChartId=ctrl.config.chartId+ctrl.lineChartId)),void 0===ctrl.showXAxis&&(ctrl.showXAxis=void 0!==ctrl.config.showAxis&&ctrl.config.showAxis),void 0===ctrl.showYAxis&&(ctrl.showYAxis=void 0!==ctrl.config.showAxis&&ctrl.config.showAxis),ctrl.defaultConfig=patternfly.c3ChartDefaults().getDefaultLineConfig(),ctrl.defaultConfig.axis={x:{show:ctrl.showXAxis===!0,type:"timeseries",tick:{format:function(){return""}}},y:{show:ctrl.showYAxis===!0,tick:{format:function(){return""}}}},void 0===ctrl.setAreaChart&&(ctrl.setAreaChart=void 0!==ctrl.config.setAreaChart&&ctrl.config.setAreaChart),ctrl.config.data=ctrl.getLineData(ctrl.chartData),ctrl.defaultConfig=pfUtils.merge(ctrl.defaultConfig,ctrl.config),ctrl.chartConfig=pfUtils.merge(ctrl.defaultConfig,ctrl.config)},ctrl.getLineData=function(chartData){var lineData={type:ctrl.setAreaChart?"area":"line"};return chartData&&chartData.dataAvailable!==!1&&chartData.xData&&(lineData.x=chartData.xData[0],lineData.columns=Object.keys(chartData).map(function(key){return chartData[key]})),lineData},ctrl.$onChanges=function(changesObj){ctrl.updateAll()},ctrl.$doCheck=function(){angular.equals(ctrl.chartData,prevChartData)||ctrl.updateAll()}}]}),angular.module("patternfly.charts").component("pfSparklineChart",{bindings:{config:"<",chartData:"<",chartHeight:"<?",showXAxis:"<?",showYAxis:"<?"},templateUrl:"charts/sparkline/sparkline-chart.html",controller:["pfUtils",function(pfUtils){"use strict";var prevChartData,ctrl=this;ctrl.updateAll=function(){prevChartData=angular.copy(ctrl.chartData),void 0===ctrl.sparklineChartId&&(ctrl.sparklineChartId="sparklineChart",ctrl.config.chartId&&(ctrl.sparklineChartId=ctrl.config.chartId+ctrl.sparklineChartId)),void 0===ctrl.showXAxis&&(ctrl.showXAxis=void 0!==ctrl.config.showAxis&&ctrl.config.showAxis),void 0===ctrl.showYAxis&&(ctrl.showYAxis=void 0!==ctrl.config.showAxis&&ctrl.config.showAxis),ctrl.defaultConfig=patternfly.c3ChartDefaults().getDefaultSparklineConfig(),ctrl.defaultConfig.axis={x:{show:ctrl.showXAxis===!0,type:"timeseries",tick:{format:function(){return""}}},y:{show:ctrl.showYAxis===!0,tick:{format:function(){return""}}}},ctrl.defaultConfig.tooltip=ctrl.sparklineTooltip(),ctrl.chartHeight&&(ctrl.defaultConfig.size.height=ctrl.chartHeight),ctrl.defaultConfig.units="",ctrl.config.data=pfUtils.merge(ctrl.config.data,ctrl.getSparklineData(ctrl.chartData)),ctrl.chartConfig=pfUtils.merge(ctrl.defaultConfig,ctrl.config)},ctrl.getSparklineData=function(chartData){var sparklineData={type:"area"};return chartData&&chartData.dataAvailable!==!1&&chartData.xData&&chartData.yData&&(sparklineData.x=chartData.xData[0],sparklineData.columns=[chartData.xData,chartData.yData]),sparklineData},ctrl.getTooltipTableHTML=function(tipRows){return'<div class="module-triangle-bottom">  <table class="c3-tooltip">    <tbody>'+tipRows+"    </tbody>  </table></div>"},ctrl.sparklineTooltip=function(){return{contents:function(d){var tipRows,percentUsed=0;if(ctrl.config.tooltipFn)tipRows=ctrl.config.tooltipFn(d);else switch(ctrl.config.tooltipType){case"usagePerDay":ctrl.chartData.dataAvailable!==!1&&ctrl.chartData.total>0&&(percentUsed=Math.round(d[0].value/ctrl.chartData.total*100)),tipRows='<tr>  <th colspan="2">'+d[0].x.toLocaleDateString()+'</th></tr><tr>  <td class="name">'+percentUsed+'%:</td>  <td class="value text-nowrap">'+d[0].value+" "+(ctrl.config.units?ctrl.config.units+" ":"")+d[0].name+"</td></tr>";break;case"valuePerDay":tipRows='<tr>  <td class="value">'+d[0].x.toLocaleDateString()+'</td>  <td class="value text-nowrap">'+d[0].value+" "+d[0].name+"</td></tr>";break;case"percentage":percentUsed=Math.round(d[0].value/ctrl.chartData.total*100),tipRows='<tr>  <td class="name">'+percentUsed+"%</td></tr>";break;default:tipRows=patternfly.c3ChartDefaults().getDefaultSparklineTooltip().contents(d)}return ctrl.getTooltipTableHTML(tipRows)},position:function(data,width,height,element){var center,top,chartBox,graphOffsetX,x;try{return center=parseInt(element.getAttribute("x")),top=parseInt(element.getAttribute("y")),chartBox=document.querySelector("#"+ctrl.sparklineChartId).getBoundingClientRect(),graphOffsetX=document.querySelector("#"+ctrl.sparklineChartId+" g.c3-axis-y").getBoundingClientRect().right,x=Math.max(0,center+graphOffsetX-chartBox.left-Math.floor(width/2)),{top:top-height,left:Math.min(x,chartBox.width-width)}}catch(e){}}}},ctrl.$onChanges=function(changesObj){ctrl.updateAll()},ctrl.$doCheck=function(){angular.equals(ctrl.chartData,prevChartData)||ctrl.updateAll()}}]}),angular.module("patternfly.charts").component("pfTopologyMap",{bindings:{nodes:"<",edges:"<",selectNode:"&",multiSelectNodes:"&",tooltipStyle:"<?",showNodeLabels:"<?",showEdgeLabels:"<?",selectEdge:"&",multiSelectEdges:"&"},templateUrl:"charts/topology-map/topology-map.html",controller:["$element","pfUtils","$scope","$window","$q",function($element,pfUtils,$scope,$window,$q){"use strict";var ctrl=this;ctrl.canvas=null,ctrl.showNodeLabels=!1,ctrl.showEdgeLabels=!1,ctrl.scale=1,ctrl.cachedIcons={},ctrl.nodeMultiSelect=[],ctrl.edgeMultiSelect=[],ctrl.IE11=!!window.MSInputMethodContext&&!!document.documentMode,this.$onInit=function(){ctrl.zoom=d3.behavior.zoom().scale(1).scaleExtent([1,8]),ctrl.transform={x:ctrl.zoom.translate()[0],y:ctrl.zoom.translate()[1],k:ctrl.zoom.scale()},ctrl.rules=ctrl.findRules(),ctrl.loadIcons(),ctrl.setUpCanvas(),ctrl.setUpForce(),ctrl.setUpDrag(),ctrl.setUpSelection(),ctrl.setUpSemanticZoom(),ctrl.setUpTooltips()},this.$onChanges=function(changes){ctrl.force&&(changes.showNodeLabels&&!changes.showNodeLabels.isFirstChange()&&changes.showNodeLabels.previousValue!==ctrl.showNodeLabels?ctrl.force.on("tick")():changes.showEdgeLabels&&!changes.showEdgeLabels.isFirstChange()&&changes.showEdgeLabels.previousValue!==ctrl.showEdgeLabels?ctrl.force.on("tick")():(ctrl.loadIcons(),ctrl.setUpForce()))},ctrl.setUpTooltips=function(){function mouseMove(){d3.event.defaultPrevented||ctrl.draggedNode||(ctrl.tooltip=ctrl.findNode.apply(this,ctrl.getRealCoordinates(d3.event.offsetX,d3.event.offsetY)),ctrl.tooltip||(ctrl.highlightEdge=ctrl.pointOverEdge.apply(this,ctrl.getRealCoordinates(d3.event.offsetX,d3.event.offsetY))),ctrl.tooltip||ctrl.highlightEdge?ctrl.canvas.style.cursor="pointer":ctrl.canvas.style.cursor="auto",ctrl.force.on("tick")())}var canvas=d3.select(ctrl.canvas);ctrl.tooltipStyle?ctrl.tooltipStyle={size:ctrl.tooltipStyle.size||12,font:ctrl.tooltipStyle.font||'"Open Sans", Helvetica, Arial, sans-serif',textColor:ctrl.tooltipStyle.textColor||"#FFFFFF",background:ctrl.tooltipStyle.background||"rgba(0, 0 , 0, 0.5)",borderColor:ctrl.tooltipStyle.borderColor||"transparent",borderWidth:ctrl.tooltipStyle.borderWidth||0}:ctrl.tooltipStyle={size:12,font:'"Open Sans", Helvetica, Arial, sans-serif',textColor:"#FFFFFF",background:"rgba(0, 0 , 0, 0.5)",borderColor:"transparent",borderWidth:0},canvas.on("mousemove",mouseMove)},this.ctrlKey=function(){var platform=$window.navigator.platform;return"MacIntel"===platform?d3.event.shiftKey:d3.event.ctrlKey||d3.event.shiftKey},ctrl.assignNode=function(node,addKey){ctrl.selectedNode=ctrl.selectedNode&&ctrl.selectedNode.id===node.id?null:node,node.fixed=!node.fixed,addKey&&(_.find(ctrl.nodeMultiSelect,function(n){return n.id===node.id})?_.remove(ctrl.nodeMultiSelect,function(n){return n.id===node.id}):ctrl.nodeMultiSelect.push(node)),0!==ctrl.nodeMultiSelect.length&&addKey||(ctrl.nodeMultiSelect=[node]),ctrl.selectNode&&ctrl.selectNode({node:node}),ctrl.multiSelectNodes&&ctrl.multiSelectNodes({array:ctrl.nodeMultiSelect}),ctrl.force.on("tick")()},ctrl.setUpSelection=function(){function click(){var node,edge,addKey=ctrl.ctrlKey();d3.event.defaultPrevented||(node=ctrl.findNode.apply(this,ctrl.getRealCoordinates(d3.event.offsetX,d3.event.offsetY)),node&&(ctrl.selectNode||ctrl.multiSelectNodes)?ctrl.assignNode(node,addKey):(edge=ctrl.pointOverEdge.apply(this,ctrl.getRealCoordinates(d3.event.offsetX,d3.event.offsetY)),edge&&(ctrl.selectEdge||ctrl.multiSelectEdges)&&(addKey&&(_.find(ctrl.edgeMultiSelect,function(e){return _.isEqual(e,edge)})?_.remove(ctrl.edgeMultiSelect,function(e){return _.isEqual(e,edge)}):ctrl.edgeMultiSelect.push(edge)),0!==ctrl.edgeMultiSelect.length&&addKey||(ctrl.edgeMultiSelect=[edge]),ctrl.selectedEdge=ctrl.selectedEdge&&_.isEqual(ctrl.selectedEdge,edge)?null:edge,ctrl.selectEdge&&ctrl.selectEdge({edge:edge}),ctrl.multiSelectEdges&&ctrl.multiSelectEdges({array:ctrl.edgeMultiSelect}),ctrl.force.on("tick")())))}var canvas=d3.select(ctrl.canvas);canvas.on("click",click)},$window.onresize=function(event){ctrl.setUpCanvas(),ctrl.force.on("tick")()},ctrl.setUpCanvas=function(){var coords;ctrl.canvas=$element[0].querySelector("canvas.topology-graph"),coords=ctrl.canvas.getBoundingClientRect(),ctrl.canvasW=ctrl.canvas.clientWidth,ctrl.canvasH=ctrl.canvas.clientHeight,ctrl.canvas.width=ctrl.canvasW,ctrl.canvas.height=ctrl.canvasH,ctrl.canvasX=coords.left,ctrl.canvasY=coords.top,ctrl.context=ctrl.canvas.getContext("2d")},ctrl.findNode=function(x,y){var size,result=void 0;return ctrl.force.nodes().forEach(function(node){Math.pow(x-node.x,2)+Math.pow(y-node.y,2)<Math.pow(node.size/ctrl.transform.k,2)&&(size=ctrl.force.nodes().length-1,ctrl.force.nodes()[size].index=node.index,ctrl.force.nodes()[node.index]=ctrl.force.nodes()[size],node.index=size,ctrl.force.nodes()[size]=node,result=node)}),result},ctrl.pointOverEdge=function(x,y){return _.find(ctrl.edges,function(edge){var x1=edge.source.x,x2=edge.target.x,y1=edge.source.y,y2=edge.target.y,distance=Math.abs((y-y2)*x1-(x-x2)*y1+x*y2-y*x2)/Math.sqrt(Math.pow(y-y2,2)+Math.pow(x-x2,2)),dotproduct=(x-x1)*(x2-x1)+(y-y1)*(y2-y1),tolerance=10,squaredlengthba=(x2-x1)*(x2-x1)+(y2-y1)*(y2-y1);return distance>tolerance?!1:0>dotproduct?!1:dotproduct>squaredlengthba?!1:!0})},ctrl.getRealCoordinates=function(x,y){return[(x-ctrl.transform.x)/ctrl.transform.k,(y-ctrl.transform.y)/ctrl.transform.k]},ctrl.setUpDrag=function(){function onDragStart(){ctrl.tooltip=void 0,d3.event.sourceEvent.stopPropagation(),ctrl.draggedNode=ctrl.findNode.apply(this,ctrl.getRealCoordinates(d3.event.sourceEvent.offsetX,d3.event.sourceEvent.offsetY))}function onDrag(){var newCoordinates=ctrl.getRealCoordinates(d3.event.sourceEvent.offsetX,d3.event.sourceEvent.offsetY);ctrl.draggedNode&&(d3.event.sourceEvent.stopPropagation(),ctrl.draggedNode.px=newCoordinates[0],ctrl.draggedNode.py=newCoordinates[1],ctrl.draggedNode.fixed=!0,ctrl.force.start())}function onDragEnd(){d3.event.sourceEvent.stopPropagation(),ctrl.draggedNode=void 0}var drag=d3.behavior.drag(),canvas=d3.select(ctrl.canvas);canvas.call(drag.on("dragstart",onDragStart).on("drag",onDrag).on("dragend",onDragEnd))},ctrl.setUpSemanticZoom=function(){function semanticZoom(){var translateX,translateY;ctrl.draggedNode||(1===ctrl.zoom.scale()?(translateY=0,translateX=0):(translateX=Math.min(0,Math.max(ctrl.zoom.translate()[0],ctrl.canvasW-ctrl.canvasW*ctrl.zoom.scale())),translateY=Math.min(0,Math.max(ctrl.zoom.translate()[1],ctrl.canvasH-ctrl.canvasH*ctrl.zoom.scale()))),ctrl.zoom.translate([translateX,translateY]),ctrl.transform={x:translateX,y:translateY,k:ctrl.zoom.scale()},ctrl.draw())}d3.select(ctrl.canvas).call(ctrl.zoom.on("zoom",semanticZoom))},ctrl.transformApply=function(x,y){return{x:x*ctrl.transform.k+ctrl.transform.x,y:y*ctrl.transform.k+ctrl.transform.y}},ctrl.draw=function(){ctrl.context.clearRect(0,0,ctrl.canvasW,ctrl.canvasH,d3.scale.linear()),ctrl.drawEdges(),ctrl.drawNodes(),!ctrl.showNodeLabels&&ctrl.tooltip&&ctrl.tooltip.title&&ctrl.drawNodeTooltip(ctrl.tooltip),!ctrl.showEdgeLabels&&ctrl.highlightEdge&&ctrl.highlightEdge.title&&ctrl.drawEdgeTooltip(ctrl.highlightEdge),1!==ctrl.transform.scale&&ctrl.drawMiniMap()},ctrl.setUpForce=function(){function tick(){ctrl.draw()}ctrl.force=d3.layout.force().charge(function(d,i){return i?-500:-2500}).friction(.5).chargeDistance(400).gravity(0).linkDistance(100).linkStrength(1).size([ctrl.canvasW,ctrl.canvasH]),ctrl.edges.forEach(function(edge){edge.source=_.findIndex(ctrl.nodes,function(node){return node.id===edge.source}),edge.target=_.findIndex(ctrl.nodes,function(node){return node.id===edge.target})}),ctrl.force.nodes(ctrl.nodes).links(ctrl.edges).on("tick",tick).start()},ctrl.shouldHighlightEdge=function(edge){return _.isEqual(edge,ctrl.highlightEdge)||_.find(ctrl.edgeMultiSelect,function(e){return _.isEqual(edge,e)})},ctrl.drawEdges=function(){var quadtree=d3.geom.quadtree(ctrl.force.nodes());ctrl.context.strokeStyle="rgba(150, 150, 150, 0.6)",ctrl.context.lineWidth=1,ctrl.edges.forEach(function(d){var sourceCoords,targetCoords,highlight=ctrl.shouldHighlightEdge(d);ctrl.context.strokeStyle=highlight?"rgba(0, 0, 0, .5)":"rgba(150, 150, 150, 0.6)",quadtree.visit(ctrl.collide(d.source)),quadtree.visit(ctrl.collide(d.target)),sourceCoords=ctrl.transformApply(d.source.x,d.source.y),targetCoords=ctrl.transformApply(d.target.x,d.target.y),ctrl.context.beginPath(),ctrl.context.setLineDash([]),"dashed"===d.lineStyle&&ctrl.context.setLineDash([10,5]),ctrl.context.moveTo(sourceCoords.x,sourceCoords.y),ctrl.context.lineTo(targetCoords.x,targetCoords.y),highlight?(ctrl.context.shadowBlur=15,ctrl.context.shadowOffsetX=3,ctrl.context.shadowOffsetY=3,ctrl.context.shadowColor="rgba(0, 0, 0, 0.5)"):ctrl.context.shadowColor="transparent",ctrl.context.stroke(),ctrl.context.shadowColor="transparent",ctrl.showEdgeLabels&&d.title&&ctrl.drawEdgeTooltip(d)})},ctrl.normalizeNode=function(node){node.size=node.size||17,node.x=Math.max(node.size+1,Math.min(ctrl.canvasW-node.size-1,node.x)),node.y=Math.max(node.size+1,Math.min(ctrl.canvasH-node.size-1,node.y))},ctrl.shouldHighlightNode=function(node){return ctrl.tooltip&&ctrl.tooltip.id===node.id||_.find(ctrl.nodeMultiSelect,function(n){return n.id===node.id})},ctrl.drawNodes=function(){
var coordinates;ctrl.nodes.forEach(function(node){var imgR=.7*node.size,highlight=ctrl.shouldHighlightNode(node);ctrl.normalizeNode(node),ctrl.context.globalAlpha=node.opacity||1,coordinates=ctrl.transformApply(node.x,node.y),ctrl.context.beginPath(),ctrl.context.fillStyle=node.fill||"#FFFFFF",ctrl.context.strokeStyle=node.borderColor||"#000000",ctrl.context.lineWidth=highlight?3:1,ctrl.context.arc(coordinates.x,coordinates.y,node.size,0,2*Math.PI),highlight?(ctrl.context.shadowBlur=20,ctrl.context.shadowOffsetX=5,ctrl.context.shadowOffsetY=5,ctrl.context.shadowColor="rgba(0, 0, 0, 0.5)"):ctrl.context.shadowColor="transparent",ctrl.context.fill(),ctrl.context.shadowColor="transparent",ctrl.context.stroke(),node.utilization&&(ctrl.context.beginPath(),ctrl.context.lineWidth=5,ctrl.context.arc(coordinates.x,coordinates.y,node.size,0,node.utilization/100*2*Math.PI),ctrl.context.strokeStyle=pfUtils.utilizationToColor(node.utilization),ctrl.context.stroke()),ctrl.context.beginPath(),ctrl.context.fillStyle=node.iconColor||"#000000",ctrl.context.textAlign="center",ctrl.context.textBaseline="middle",node.fonticon?(ctrl.context.font="normal normal normal "+node.size+"px FontAwesome",ctrl.context.fillText(ctrl.cachedIcons[node.fonticon]["char"],coordinates.x,coordinates.y)):node.fileicon?ctrl.context.drawImage(ctrl.cachedIcons[node.fileicon].img,coordinates.x-imgR,coordinates.y-imgR,2*imgR,2*imgR):(ctrl.context.font=2*imgR+"px "+ctrl.cachedIcons.unknown.font,ctrl.context.fillText(ctrl.cachedIcons.unknown["char"],coordinates.x,coordinates.y)),ctrl.context.globalAlpha=1,ctrl.showNodeLabels&&node.title&&ctrl.drawNodeTooltip(node)})},ctrl.drawMiniMap=function(){var mapX=.9*ctrl.canvasW-10,mapY=10,mapW=.1*ctrl.canvasW,mapH=.1*ctrl.canvasH;ctrl.context.lineWidth=1,ctrl.context.beginPath(),ctrl.context.strokeStyle="rgba(0, 0, 0, 0.3)",ctrl.context.fillStyle="rgba(252, 252, 252, 0.3)",ctrl.context.rect(mapX,mapY,mapW,mapH),ctrl.context.stroke(),ctrl.context.fill(),ctrl.context.beginPath(),ctrl.context.fillStyle="rgba(224, 224, 224, 0.3)",ctrl.context.rect(mapX-ctrl.transform.x/ctrl.transform.k*.1,mapY-ctrl.transform.y/ctrl.transform.k*.1,mapW/ctrl.transform.k,mapH/ctrl.transform.k),ctrl.context.stroke(),ctrl.context.fill()},ctrl.drawEdgeTooltip=function(edge){var tooltipWidth,sourceCoordinates=ctrl.transformApply(edge.source.x,edge.source.y),targetCoordinates=ctrl.transformApply(edge.target.x,edge.target.y),midX=sourceCoordinates.x+.5*(targetCoordinates.x-sourceCoordinates.x),midY=sourceCoordinates.y+.5*(targetCoordinates.y-sourceCoordinates.y),tmp=document.createElement("span");tmp.innerHTML=edge.title,tmp.style.padding="10px",tmp.style.visibility="hidden",tmp.style.display="inline-block",document.body.appendChild(tmp),tooltipWidth=tmp.clientWidth,ctrl.context.beginPath(),ctrl.context.fillStyle="#000000",ctrl.context.font=ctrl.tooltipStyle.size+"px "+ctrl.tooltipStyle.font,ctrl.context.fillText(edge.title,midX,midY+5),document.body.removeChild(tmp)},ctrl.drawNodeTooltip=function(node){var coordinates=ctrl.transformApply(node.x,node.y),tooltipWidth=0,offsetY=coordinates.y+node.size+ctrl.tooltipStyle.size+5,tmp=document.createElement("span");tmp.innerHTML=node.title,tmp.style.padding="10px",tmp.style.visibility="hidden",tmp.style.display="inline-block",document.body.appendChild(tmp),tooltipWidth=tmp.clientWidth,ctrl.context.beginPath(),ctrl.context.rect(coordinates.x-tooltipWidth/2-5,offsetY-ctrl.tooltipStyle.size,tooltipWidth+10,ctrl.tooltipStyle.size+10),ctrl.context.fillStyle=ctrl.tooltipStyle.background,ctrl.context.fill(),ctrl.context.lineWidth=ctrl.tooltipStyle.borderWidth,ctrl.context.strokeStyle=ctrl.tooltipStyle.borderColor,ctrl.context.stroke(),ctrl.context.fillStyle=ctrl.tooltipStyle.textColor,ctrl.context.font=ctrl.tooltipStyle.size+"px "+ctrl.tooltipStyle.font,ctrl.context.fillText(node.title,coordinates.x,offsetY),document.body.removeChild(tmp)},ctrl.loadIcons=function(){var tmp=document.createElement("i"),char="",promises=[],questionCode=ctrl.findIconUnicode("fa fa-question"),q=$q.defer(),code="";document.body.appendChild(tmp),ctrl.cachedIcons.unknown={},tmp.className="hidden fa fa-question",char=window.getComputedStyle(tmp,":before").content.replace(/'|"/g,""),ctrl.IE11&&questionCode?ctrl.cachedIcons.unknown["char"]=String.fromCharCode(questionCode.toUpperCase().replace("\\","0x").replace(/'|"/g,"")):ctrl.cachedIcons.unknown["char"]=char,ctrl.cachedIcons.unknown.font=window.getComputedStyle(tmp,":before").fontFamily,ctrl.nodes.forEach(function(node){node.fileicon&&!ctrl.cachedIcons[node.fileicon]?(ctrl.cachedIcons[node.fileicon]={},promises.push(q.promise),ctrl.cachedIcons[node.fileicon].img=new Image,ctrl.cachedIcons[node.fileicon].img.src=node.fileicon,ctrl.cachedIcons[node.fileicon].img.onload=function(){return q.resolve()}):node.fonticon&&!ctrl.cachedIcons[node.fonticon]&&(ctrl.cachedIcons[node.fonticon]={},tmp.className="hidden "+node.fonticon,char=window.getComputedStyle(tmp,":before").content,ctrl.cachedIcons[node.fonticon]["char"]=char.replace(/'|"/g,""),ctrl.IE11&&(code=ctrl.findIconUnicode(node.fonticon).toUpperCase().replace("\\","0x"),ctrl.cachedIcons[node.fonticon]["char"]=String.fromCharCode(code.replace(/'|"/g,""))),ctrl.cachedIcons[node.fonticon].font=window.getComputedStyle(tmp,":before").fontFamily)}),document.body.removeChild(tmp)},this.collide=function(node){var r=node.size+22,nx1=node.x-r,nx2=node.x+r,ny1=node.y-r,ny2=node.y+r;return function(quad,x1,y1,x2,y2){var x,l,y,r;return quad.point&&quad.point!==node&&(x=node.x-quad.point.x,y=node.y-quad.point.y,l=Math.sqrt(x*x+y*y),r=30*node.size+quad.point.radius,r>l&&(l=(l-r)/l*2.5,node.x-=x*=l,node.y-=y*=l,quad.point.x+=x,quad.point.y+=y)),x1>nx2||nx1>x2||y1>ny2||ny1>y2}},ctrl.findRules=function(){var href,index,styleSheet=_.find(document.styleSheets,function(sheet){return sheet&&sheet.href?(href=sheet.href,index=sheet.href.lastIndexOf("/"),"/patternfly.css"===href.substring(index)):void 0});return styleSheet?styleSheet.rules:void 0},ctrl.findIconUnicode=function(fonticon){var rule,className=fonticon.substring(fonticon.indexOf(" ")+1);return ctrl.rules&&(rule=_.find(ctrl.rules,function(rule){return rule&&rule.selectorText?-1!==rule.selectorText.indexOf(className+"::before"):void 0})),rule?rule.style.content:void 0}}]}),angular.module("patternfly.charts").component("pfTopology",{bindings:{items:"<",relations:"<",kinds:"<",icons:"<",selection:"<",force:"<",radius:"<",nodes:"<",searchText:"<?",chartRendered:"&?",itemSelected:"&?",showLabels:"<?",tooltipFunction:"&?"},controller:["$element","$attrs",function($element,$attrs){"use strict";function topologyGraph(selector,notify,options){function select(item){void 0!==item&&(selection=item),svg.selectAll("g").classed("selected",function(d){return d.item===selection})}function adjust(){timeout=null,width=outer.node().clientWidth,height=outer.node().clientHeight,force.size([width,height]),svg.attr("viewBox","0 0 "+width+" "+height),update()}function update(){var added;return edges=svg.selectAll("line").data(links),edges.exit().remove(),edges.enter().insert("line",":first-child"),edges.attr("class",function(d){return d.kinds}),vertices=svg.selectAll("g").data(nodes,function(d){return d.id}),vertices.exit().remove(),added=vertices.enter().append("g").call(drag),select(selection),force.nodes(nodes).links(links).start(),added}function digest(){var item,id,kind,node,i,len,relation,s,t,pnodes=nodes,plookup=lookup;nodes=[],links=[],lookup={};for(id in items)if(id){if(item=items[id],kind=item.kind,kinds&&!kinds[kind])continue;node=pnodes[plookup[id]],node||(node=cache[id],delete cache[id],node||(node={})),node.id=id,node.item=item,lookup[id]=nodes.length,nodes.push(node)}for(i=0,len=relations.length;len>i;i++)relation=relations[i],s=lookup[relation.source],t=lookup[relation.target],void 0!==s&&void 0!==t&&links.push({source:s,target:t,kinds:nodes[s].item.kind+nodes[t].item.kind});return width&&height?update():d3.select()}function resized(){window.clearTimeout(timeout),timeout=window.setTimeout(adjust,1)}var width,height,timeout,drag,svg,vertices,edges,outer=d3.select(selector),kinds=null,items={},relations=[],radius=20,nodes=[],links=[],lookup={},selection=null,force=options.force;return options.radius&&(radius=options.radius),force||(force=d3.layout.force().charge(-800).gravity(.2).linkDistance(80)),drag=force.drag(),svg=outer.append("svg").attr("viewBox","0 0 1600 1200").attr("preserveAspectRatio","xMidYMid meet").attr("class","pf-topology-svg"),vertices=d3.select(),edges=d3.select(),force.on("tick",function(){edges.attr("x1",function(d){return d.source.x}).attr("y1",function(d){return d.source.y}).attr("x2",function(d){return d.target.x}).attr("y2",function(d){return d.target.y}),vertices.attr("cx",function(d){return d.x=d.fixed?d.x:Math.max(radius,Math.min(width-radius,d.x)),d.x}).attr("cy",function(d){return d.y=d.fixed?d.y:Math.max(radius,Math.min(height-radius,d.y)),d.y}).attr("transform",function(d){return"translate("+d.x+","+d.y+")"})}),drag.on("dragstart",function(d){notify(d.item),d.fixed!==!0&&(d.floatpoint=[d.x,d.y]),d.fixed=!0,d3.select(this).classed("fixed",!0)}).on("dragend",function(d){var moved=!0;d.floatpoint&&(moved=d.x<d.floatpoint[0]-5||d.x>d.floatpoint[0]+5||d.y<d.floatpoint[1]-5||d.y>d.floatpoint[1]+5,delete d.floatpoint),d.fixed=moved&&d.x>3&&d.x<width-3&&d.y>=3&&d.y<height-3,d3.select(this).classed("fixed",d.fixed)}),svg.on("dblclick",function(){svg.selectAll("g").classed("fixed",!1).each(function(d){d.fixed=!1}),force.start()}).on("click",function(ev){d3.select(d3.event.target).datum()||notify(null)}),window.addEventListener("resize",resized),adjust(),resized(),{select:select,kinds:function(value){var added;return kinds=value,added=digest(),[vertices,added]},data:function(newItems,newRelations){var added;return items=newItems||{},relations=newRelations||[],added=digest(),[vertices,added]},close:function(){var id,node;window.removeEventListener("resize",resized),window.clearTimeout(timeout),cache={};for(id in lookup)id&&(node=nodes[lookup[id]],delete node.item,cache[id]=node);nodes=[],lookup={}}}}function search(query){var selected,links,svg=getSVG(),nodes=svg.selectAll("g");""!==query&&(selected=nodes.filter(function(d){return-1===d.item.name.indexOf(query)}),selected.style("opacity","0.2"),links=svg.selectAll("line"),links.style("opacity","0.2"))}function toggleLabelVisibility(){ctrl.showLabels?vs.selectAll("text.attached-label").classed("visible",!0):vs.selectAll("text.attached-label").classed("visible",!1)}function getSVG(){var graph=d3.select("pf-topology"),svg=graph.select("svg");return svg}function notify(item){ctrl.itemSelected({item:item}),void 0===$attrs.selection&&graph.select(item)}function render(args){var event,vertices=args[0],added=args[1];angular.isFunction(ctrl.chartRendered)&&(event=ctrl.chartRendered({vertices:vertices,added:added})),event&&event.defaultPrevented||(added.attr("class",function(d){return d.item.kind}),added.append("circle").attr("r",function(d){return getDimensions(d).r}).attr("class",function(d){return getItemStatusClass(d)}).on("contextmenu",function(d){contextMenu(ctrl,d)}),added.append("title"),added.on("dblclick",function(d){return dblclick(d)}),added.append("image").attr("xlink:href",function(d){var iconInfo=ctrl.icons[d.item.kind];switch(iconInfo.type){case"image":return iconInfo.icon;case"glyph":return null}}).attr("height",function(d){var iconInfo=ctrl.icons[d.item.kind];return"image"!==iconInfo.type?0:40}).attr("width",function(d){var iconInfo=ctrl.icons[d.item.kind];return"image"!==iconInfo.type?0:40}).attr("y",function(d){return getDimensions(d).y}).attr("x",function(d){return getDimensions(d).x}).on("contextmenu",function(d){contextMenu(ctrl,d)}),added.append("text").each(function(d){var iconInfo=ctrl.icons[d.item.kind];"glyph"===iconInfo.type&&d3.select(this).text(iconInfo.icon).attr("class","glyph").attr("font-family",iconInfo.fontfamily)}).attr("y",function(d){return getDimensions(d).y}).attr("x",function(d){return getDimensions(d).x}).on("contextmenu",function(d){contextMenu(this,d)}),added.append("text").attr("x",26).attr("y",24).text(function(d){return d.item.name}).attr("class",function(){var className="attached-label";return ctrl.showLabels?className+" visible":className}),added.selectAll("title").text(function(d){return tooltip(d).join("\n")}),vs=vertices),graph.select()}function tooltip(d){return ctrl.tooltipFunction?ctrl.tooltipFunction({node:d}):"Name: "+d.item.name}function removeContextMenu(){d3.event.preventDefault(),d3.select(".popup").remove(),contextMenuShowing=!1}function contextMenu(that,data){var canvasSize,popupSize,canvas,mousePosition,popup;contextMenuShowing?removeContextMenu():(d3.event.preventDefault(),canvas=d3.select("pf-topology"),mousePosition=d3.mouse(canvas.node()),popup=canvas.append("div").attr("class","popup").style("left",mousePosition[0]+"px").style("top",mousePosition[1]+"px"),popup.append("h5").text("Actions on "+data.item.kind),buildContextMenuOptions(popup,data),canvasSize=[canvas.node().offsetWidth,canvas.node().offsetHeight],popupSize=[popup.node().offsetWidth,popup.node().offsetHeight],popupSize[0]+mousePosition[0]>canvasSize[0]&&(popup.style("left","auto"),popup.style("right",0)),popupSize[1]+mousePosition[1]>canvasSize[1]&&(popup.style("top","auto"),popup.style("bottom",0)),contextMenuShowing=!contextMenuShowing)}function buildContextMenuOptions(popup,data){return"Tag"===data.item.kind?!1:void addContextMenuOption(popup,"Go to summary page",data,dblclick)}function dblclick(d){window.location.assign(d.url)}function addContextMenuOption(popup,text,data,callback){popup.append("p").text(text).on("click",function(){callback(data)})}function getDimensions(d){var nodeEntry=ctrl.nodes[d.item.kind],defaultDimensions=defaultElementDimensions();return nodeEntry&&(nodeEntry.textX&&(defaultDimensions.x=nodeEntry.textX),nodeEntry.textY&&(defaultDimensions.y=nodeEntry.textY),nodeEntry.radius&&(defaultDimensions.r=nodeEntry.radius)),defaultDimensions}function defaultElementDimensions(){return{x:0,y:9,r:17}}function getItemStatusClass(d){switch(d.item.status.toLowerCase()){case"ok":case"active":case"available":case"on":case"ready":case"running":case"succeeded":case"valid":return"success";case"notready":case"failed":case"error":case"unreachable":return"error";case"warning":case"waiting":case"pending":return"warning";case"unknown":case"terminated":return"unknown"}}var options,graph,previousItems,previousRelations,previousKinds,contextMenuShowing,vs,ctrl=this,cache={};ctrl.$onInit=function(){$element.css("display","block"),options={force:ctrl.force,radius:ctrl.radius},ctrl.showLabels=!1,$element.on("$destroy",function(){graph.close()}),d3.select("body").on("click",function(){contextMenuShowing&&removeContextMenu()})},ctrl.$onChanges=function(changesObj){changesObj.searchText&&graph&&search(changesObj.searchText.currentValue),changesObj.showLabels&&vs&&toggleLabelVisibility(),changesObj.selection&&graph&&graph.select(changesObj.selection.currentValue||null)},ctrl.$doCheck=function(){graph&&(angular.equals(ctrl.kinds,previousKinds)||(previousKinds=angular.copy(ctrl.kinds),render(graph.kinds(ctrl.kinds))),angular.equals(ctrl.items,previousItems)&&angular.equals(ctrl.relations,previousRelations)||(previousItems=angular.copy(ctrl.items),previousRelations=angular.copy(ctrl.relations),render(graph.data(ctrl.items,ctrl.relations))))},ctrl.$postLink=function(){options={force:ctrl.force,radius:ctrl.radius},graph=topologyGraph($element[0],notify,options)}}]}),angular.module("patternfly.charts").component("pfTrendsChart",{bindings:{config:"<",chartData:"<",chartHeight:"<?",showXAxis:"<?",showYAxis:"<?"},templateUrl:"charts/trends/trends-chart.html",controller:["pfUtils",function(pfUtils){"use strict";var prevChartData,prevConfig,ctrl=this,SMALL=30,LARGE=60;ctrl.updateAll=function(){prevChartData=angular.copy(ctrl.chartData),prevConfig=angular.copy(ctrl.config),ctrl.showLargeCardLayout=!ctrl.config.layout||"large"===ctrl.config.layout,ctrl.showSmallCardLayout="small"===ctrl.config.layout,ctrl.showActualValue=!ctrl.config.valueType||"actual"===ctrl.config.valueType,ctrl.showPercentageValue="percentage"===ctrl.config.valueType},ctrl.getPercentageValue=function(){var pctValue=0;return ctrl.chartData.dataAvailable!==!1&&ctrl.chartData.total>0&&(pctValue=Math.round(ctrl.getLatestValue()/ctrl.chartData.total*100)),pctValue},ctrl.getLatestValue=function(){var latestValue=0;return ctrl.chartData.yData&&ctrl.chartData.yData.length>0&&(latestValue=ctrl.chartData.yData[ctrl.chartData.yData.length-1]),latestValue},ctrl.getChartHeight=function(){var retValue=LARGE;return ctrl.chartHeight?retValue=ctrl.chartHeight:"small"===ctrl.config.layout&&(retValue=SMALL),retValue},ctrl.$onChanges=function(changesObj){ctrl.updateAll()},ctrl.$doCheck=function(){angular.equals(ctrl.chartData,prevChartData)&&angular.equals(ctrl.config,prevConfig)||ctrl.updateAll()}}]}),angular.module("patternfly.charts").component("pfUtilizationBarChart",{bindings:{chartData:"=",chartTitle:"=",chartFooter:"=",units:"=",thresholdError:"=?",thresholdWarning:"=?",footerLabelFormat:"@?",layout:"=?",usedTooltipFunction:"&?",availableTooltipFunction:"&?"},templateUrl:"charts/utilization-bar/utilization-bar-chart.html",controller:["$timeout",function($timeout){"use strict";var prevChartData,prevLayout,ctrl=this;ctrl.updateAll=function(){prevChartData=angular.copy(ctrl.chartData),prevLayout=angular.copy(ctrl.layout),ctrl.chartData&&(!isNaN(ctrl.chartData.used)&&!isNaN(ctrl.chartData.total)&&ctrl.chartData.total>0?ctrl.chartData.percentageUsed=Math.round(100*(ctrl.chartData.used/ctrl.chartData.total)):ctrl.chartData.percentageUsed=0,(ctrl.thresholdError||ctrl.thresholdWarning)&&(ctrl.isError=ctrl.chartData.percentageUsed>=ctrl.thresholdError,ctrl.isWarn=ctrl.chartData.percentageUsed>=ctrl.thresholdWarning&&ctrl.chartData.percentageUsed<ctrl.thresholdError,ctrl.isOk=ctrl.chartData.percentageUsed<ctrl.thresholdWarning),ctrl.animate=!0,$timeout(function(){ctrl.animate=!1},0))},ctrl.$onChanges=function(changesObj){ctrl.updateAll()},ctrl.$doCheck=function(){angular.equals(ctrl.chartData,prevChartData)&&angular.equals(ctrl.layout,prevLayout)||ctrl.updateAll()},ctrl.usedTooltipMessage=function(){return ctrl.usedTooltipFunction?ctrl.usedTooltipFunction():_.get(ctrl.chartData,"percentageUsed","N/A")+"% Used"},ctrl.availableTooltipMessage=function(){return ctrl.availableTooltipFunction?ctrl.availableTooltipFunction():100-_.get(ctrl.chartData,"percentageUsed",0)+"% Available"}}]}),angular.module("patternfly.charts").component("pfUtilizationTrendChart",{bindings:{chartData:"<",config:"<",centerLabel:"<?",donutConfig:"<",sparklineConfig:"<",sparklineChartHeight:"<?",showSparklineXAxis:"<?",showSparklineYAxis:"<?"},templateUrl:"charts/utilization-trend/utilization-trend-chart.html",controller:["pfUtils",function(pfUtils){"use strict";var prevChartData,prevConfig,ctrl=this;ctrl.updateAll=function(){prevChartData=angular.copy(ctrl.chartData),prevConfig=angular.copy(ctrl.config),void 0===ctrl.centerLabel&&(ctrl.centerLabel="used"),void 0===ctrl.donutConfig.units&&(ctrl.donutConfig.units=ctrl.config.units),void 0===ctrl.chartData.available&&(ctrl.chartData.available=ctrl.chartData.total-ctrl.chartData.used),ctrl.config.units=ctrl.config.units||ctrl.units,"available"===ctrl.centerLabel?(ctrl.currentValue=ctrl.chartData.used,ctrl.currentText="Used"):(ctrl.currentValue=ctrl.chartData.total-ctrl.chartData.used,ctrl.currentText="Available")},ctrl.$onChanges=function(changesObj){ctrl.updateAll()},ctrl.$doCheck=function(){angular.equals(ctrl.chartData,prevChartData)&&angular.equals(ctrl.config,prevConfig)||ctrl.updateAll()}}]}),angular.module("patternfly.datepicker").component("pfBootstrapDatepicker",{bindings:{date:"<",format:"@?",dateOptions:"<?",isOpen:"<?",popupPlacement:"@?",onDateChange:"&"},templateUrl:"datepicker/datepicker.html",controller:function(){"use strict";var prevDate,ctrl=this;ctrl.defaultDateOptions={showWeeks:!1,formatDay:"d"},ctrl.defaultIsOpen=!1,ctrl.$onInit=function(){ctrl.format="MM/dd/yyyy",ctrl.showButtonBar=!0,ctrl.popupPlacement="auto bottom-left",angular.isUndefined(ctrl.dateOptions)&&(ctrl.dateOptions={}),_.defaults(ctrl.dateOptions,ctrl.defaultDateOptions),_.defaults(ctrl.isOpen,ctrl.defaultIsOpen)},ctrl.$onChanges=function(changes){prevDate=angular.copy(ctrl.date),_.defaults(ctrl.isOpen,ctrl.defaultIsOpen)},ctrl.$doCheck=function(){angular.equals(ctrl.date,prevDate)||(prevDate=angular.copy(ctrl.date),ctrl.onDateChange&&ctrl.onDateChange({newDate:ctrl.date}))}}}),angular.module("patternfly.filters").component("pfFilterPanel",{bindings:{config:"="},transclude:!0,templateUrl:"filters/filter-panel/filter-panel.html",controller:function(){"use strict"}}),angular.module("patternfly.filters").component("pfFilterPanelResults",{bindings:{config:"="},templateUrl:"filters/filter-panel/filter-panel-results.html",controller:function(){"use strict";function setupConfig(){ctrl.config.appliedFilters||(ctrl.config.appliedFilters=[]),void 0===ctrl.config.resultsCount&&(ctrl.config.resultsCount=0)}function clearFilter(evt,filter,value){var changedFilterId=filter.id;evt.preventDefault(),_.pull(filter.values,value),0===filter.values.length&&_.pull(ctrl.config.appliedFilters,filter),ctrl.config.onFilterChange&&ctrl.config.onFilterChange(ctrl.config.appliedFilters,changedFilterId,value)}function clearAllFilters(evt){evt.preventDefault(),ctrl.config.appliedFilters=[],ctrl.config.onFilterChange&&ctrl.config.onFilterChange(ctrl.config.appliedFilters)}var ctrl=this;ctrl.$onInit=function(){angular.extend(ctrl,{clearFilter:clearFilter,clearAllFilters:clearAllFilters})},ctrl.$onChanges=function(){setupConfig()}}}),angular.module("patternfly.filters").component("pfFilter",{bindings:{config:"="},templateUrl:"filters/simple-filter/filter.html",controller:function(){"use strict";function filterExists(filter){return angular.isDefined(_.find(ctrl.config.appliedFilters,{title:filter.title,value:filter.value}))}function findDuplicateComplexSelect(item){return item.value.filterCategory}function enforceSingleSelect(filter){_.remove(ctrl.config.appliedFilters,{title:filter.title})}function addFilter(field,value){var newFilter={id:field.id,title:field.title,type:field.filterType,value:value};filterExists(newFilter)||("select"===newFilter.type&&enforceSingleSelect(newFilter),"complex-select"!==field.filterType||field.filterMultiselect||_.remove(ctrl.config.appliedFilters,findDuplicateComplexSelect),ctrl.config.appliedFilters.push(newFilter),ctrl.config.onFilterChange&&ctrl.config.onFilterChange(ctrl.config.appliedFilters))}var ctrl=this;ctrl.$onInit=function(){angular.extend(ctrl,{addFilter:addFilter})}}}),angular.module("patternfly.filters").component("pfFilterFields",{bindings:{config:"=",addFilterFn:"<"},templateUrl:"filters/simple-filter/filter-fields.html",controller:function(){"use strict";function selectField(item){ctrl.currentField=item,ctrl.currentField.filterDelimiter=ctrl.currentField.filterDelimiter||" ",ctrl.currentValue=null}function selectValue(filterValue,valueType){if(angular.isDefined(filterValue))if("complex-select"===ctrl.currentField.filterType){switch(valueType){case"filter-category":ctrl.filterCategory=filterValue,ctrl.filterValue=null;break;case"filter-value":ctrl.filterValue=filterValue}ctrl.filterCategory&&ctrl.filterValue&&ctrl.addFilterFn(ctrl.currentField,{filterCategory:ctrl.filterCategory,filterDelimiter:ctrl.currentField.filterDelimiter,filterValue:ctrl.filterValue})}else ctrl.addFilterFn(ctrl.currentField,filterValue),ctrl.currentValue=filterValue}function onValueKeyPress(keyEvent){13===keyEvent.which&&ctrl.currentValue&&ctrl.currentValue.length>0&&(ctrl.addFilterFn(ctrl.currentField,ctrl.currentValue),ctrl.currentValue=void 0,keyEvent.stopPropagation(),keyEvent.preventDefault())}function setupConfig(){var fieldFound=!1;prevConfig=angular.copy(ctrl.config),void 0===ctrl.config.fields&&(ctrl.config.fields=[]),ctrl.currentField&&(fieldFound=_.find(ctrl.config.fields,function(nextField){return nextField.id===ctrl.currentField.id})),fieldFound||(ctrl.currentField=ctrl.config.fields[0],ctrl.currentValue=null),void 0===ctrl.currentValue&&(ctrl.currentValue=null)}var prevConfig,ctrl=this;ctrl.$onInit=function(){angular.extend(ctrl,{selectField:selectField,selectValue:selectValue,onValueKeyPress:onValueKeyPress})},ctrl.$onChanges=function(){setupConfig()},ctrl.$doCheck=function(){angular.equals(ctrl.config,prevConfig)||setupConfig()}}}),angular.module("patternfly.filters").component("pfFilterResults",{bindings:{config:"="},templateUrl:"filters/simple-filter/filter-results.html",controller:function(){"use strict";function setupConfig(){prevConfig=angular.copy(ctrl.config),ctrl.config.appliedFilters||(ctrl.config.appliedFilters=[]),void 0===ctrl.config.resultsCount&&(ctrl.config.resultsCount=0),ctrl.config.itemsLabel=ctrl.config.itemsLabel||"Result",ctrl.config.itemsLabelPlural=ctrl.config.itemsLabelPlural||"Results"}function clearFilter(evt,item){var newFilters=[];evt.preventDefault(),ctrl.config.appliedFilters.forEach(function(filter){(item.title!==filter.title||item.value!==filter.value)&&newFilters.push(filter)}),ctrl.config.appliedFilters=newFilters,ctrl.config.onFilterChange&&ctrl.config.onFilterChange(ctrl.config.appliedFilters)}function clearAllFilters(evt){evt.preventDefault(),ctrl.config.appliedFilters=[],ctrl.config.onFilterChange&&ctrl.config.onFilterChange(ctrl.config.appliedFilters)}var prevConfig,ctrl=this;ctrl.$onInit=function(){angular.extend(ctrl,{clearFilter:clearFilter,clearAllFilters:clearAllFilters})},ctrl.$onChanges=function(){setupConfig()},ctrl.$doCheck=function(){angular.equals(ctrl.config,prevConfig)||setupConfig()}}}),angular.module("patternfly.form").component("pfFormButtons",{bindings:{pfHandleCancel:"&pfOnCancel",pfHandleSave:"&pfOnSave",pfWorking:"=",pfButtonContainerClass:"@"},require:{form:"^form"},templateUrl:"form/form-buttons/form-buttons.html",controller:function(){"use strict";function isInvalid(){var invalid=ctrl.form.$invalid;return ctrl.form&&ctrl.form.name&&ctrl.form.name.$error&&ctrl.form.name.$error.server&&(invalid=!1),invalid}var ctrl=this;ctrl.$onInit=function(){void 0===ctrl.pfWorking&&(ctrl.pfWorking=!1),angular.extend(ctrl,{isInvalid:isInvalid})}}}),angular.module("patternfly.form").component("pfFormGroup",{bindings:{pfLabel:"@",pfField:"@",pfLabelClass:"@",pfInputClass:"@"},require:{form:"^form"},transclude:!0,templateUrl:"form/form-group/form-group.html",controller:["$element",function($element){"use strict";function hasErrors(){return ctrl.form[ctrl.pfField]&&ctrl.form[ctrl.pfField].$invalid&&ctrl.form[ctrl.pfField].$dirty}function getInput(element){var input=element.find("table");return 0===input.length&&(input=element.find("input"),0===input.length&&(input=element.find("select"),0===input.length&&(input=element.find("textarea")))),input}var ctrl=this;ctrl.$onInit=function(){angular.extend(ctrl,{hasErrors:hasErrors})},ctrl.$postLink=function(){var input=getInput($element),type=input.attr("type");-1===["checkbox","radio","time"].indexOf(type)&&input.addClass("form-control"),ctrl.pfField||(ctrl.pfField=input.attr("id")),input.attr("required")&&$element.addClass("required"),ctrl.form[ctrl.pfField]&&(ctrl.error=ctrl.form[ctrl.pfField].$error)}}]}),angular.module("patternfly.form").directive("pfRemainingCharsCount",["$timeout",function($timeout){"use strict";return{restrict:"A",require:"ngModel",scope:{ngModel:"="},link:function($scope,$element,$attributes){var charsMaxLimit=$attributes.charsMaxLimit,charsWarnRemaining=$attributes.charsWarnRemaining,countRemainingFld=angular.element(document.getElementById($attributes.countFld)),blockInputAtMaxLimit="true"===$attributes.blockInputAtMaxLimit,checkCharactersRemaining=function(){var charsLength=$scope.ngModel.length,remainingChars=charsMaxLimit-charsLength;blockInputAtMaxLimit&&charsLength>charsMaxLimit&&($scope.ngModel=$scope.ngModel.substring(0,charsMaxLimit),charsLength=$scope.ngModel.length,remainingChars=charsMaxLimit-charsLength),$scope.remainingChars=remainingChars,$scope.remainingCharsWarning=charsWarnRemaining>=remainingChars,countRemainingFld.text(remainingChars),countRemainingFld.toggleClass("chars-warn-remaining-pf",charsWarnRemaining>=remainingChars),0>remainingChars?$scope.$emit("overCharsMaxLimit",$attributes.id):$scope.$emit("underCharsMaxLimit",$attributes.id)};$scope.$watch("ngModel",function(){checkCharactersRemaining()}),$element.on("keypress",function(event){blockInputAtMaxLimit&&$element.val().length>=charsMaxLimit&&8!==event.keyCode&&event.preventDefault()})}}}]),angular.module("patternfly.modals").directive("pfAboutModalTransclude",["$parse",function($parse){"use strict";return{link:function(scope,element,attrs){element.append($parse(attrs.pfAboutModalTransclude)(scope))}}}]).component("pfModalContent",{templateUrl:"about-modal-template.html",bindings:{resolve:"<",close:"&",dismiss:"&"},controller:function(){"use strict";var $ctrl=this;$ctrl.$onInit=function(){$ctrl.additionalInfo=$ctrl.resolve.additionalInfo,$ctrl.copyright=$ctrl.resolve.copyright,$ctrl.imgAlt=$ctrl.resolve.imgAlt,$ctrl.imgSrc=$ctrl.resolve.imgSrc,$ctrl.isOpen=$ctrl.resolve.isOpen,$ctrl.productInfo=$ctrl.resolve.productInfo,$ctrl.title=$ctrl.resolve.title,$ctrl.template=$ctrl.resolve.content}}}).component("pfAboutModal",{bindings:{additionalInfo:"=?",copyright:"=?",close:"&onClose",imgAlt:"=?",imgSrc:"=?",isOpen:"<?",productInfo:"=",title:"=?"},templateUrl:"modals/about-modal/about-modal.html",transclude:!0,controller:["$uibModal","$transclude",function($uibModal,$transclude){"use strict";var ctrl=this;ctrl.openModal=function(){$uibModal.open({component:"pfModalContent",resolve:{content:function(){var transcludedContent;return $transclude(function(clone){transcludedContent=clone}),transcludedContent},additionalInfo:function(){return ctrl.additionalInfo},copyright:function(){return ctrl.copyright},close:function(){return ctrl.close},imgAlt:function(){return ctrl.imgAlt},imgSrc:function(){return ctrl.imgSrc},isOpen:function(){return ctrl.isOpen},productInfo:function(){return ctrl.productInfo},title:function(){return ctrl.title}}}).result.then(function(){ctrl.close()},function(){ctrl.close()})},ctrl.$onInit=function(){void 0===ctrl.isOpen&&(ctrl.isOpen=!1)},ctrl.$onChanges=function(changesObj){changesObj.isOpen&&changesObj.isOpen.currentValue===!0&&ctrl.openModal()}}]}),angular.module("patternfly.modals").component("pfModalOverlay",{bindings:{showModal:"<",close:"&onClose",modalId:"=",modalTitle:"=",titleId:"=?",hideCloseIcon:"<?",backgroundClose:"<?",onBackgroundClick:"=?",isForm:"<?",modalBodyTemplate:"=",modalBodyScope:"=?",actionButtons:"<"},templateUrl:"modals/modal-overlay/modal-overlay.html",controller:["$uibModal",function($uibModal){"use strict";var modalInstance,ctrl=this;ctrl.open=function(){modalInstance=$uibModal.open({component:"pfModalOverlayContent",backdrop:ctrl.backgroundClose?!0:"static",resolve:{modalId:function(){return ctrl.modalId},titleId:function(){return ctrl.titleId||"modalTitle"},modalTitle:function(){return ctrl.modalTitle},hideCloseIcon:function(){return ctrl.hideCloseIcon},onBackgroundClick:function(){return ctrl.onBackgroundClick},isForm:function(){return ctrl.isForm},modalBodyTemplate:function(){return ctrl.modalBodyTemplate},modalBodyScope:function(){return ctrl.modalBodyScope},actionButtons:function(){return ctrl.actionButtons}}}),modalInstance.result.then(function(dismissCause){ctrl.close({dismissCause:dismissCause})},function(dismissCause){ctrl.close({dismissCause:dismissCause})})},ctrl.$onInit=function(){void 0===ctrl.showModal&&(ctrl.showModal=!1)},ctrl.$onChanges=function(changesObj){changesObj.showModal&&(changesObj.showModal.currentValue===!0?ctrl.open():changesObj.showModal.currentValue===!1&&modalInstance&&modalInstance.dismiss("showModal set to false"))}}]}),angular.module("patternfly.modals").component("pfModalOverlayContent",{templateUrl:"modal-overlay-template.html",
bindings:{resolve:"<",close:"&",dismiss:"&"},controller:["$scope",function($scope){"use strict";var ctrl=this;ctrl.$onInit=function(){ctrl.modalId=ctrl.resolve.modalId,ctrl.titleId=ctrl.resolve.titleId||"modalTitle",ctrl.modalTitle=ctrl.resolve.modalTitle,ctrl.hideCloseIcon=ctrl.resolve.hideCloseIcon||!1,ctrl.modalBodyTemplate=ctrl.resolve.modalBodyTemplate,ctrl.modalBodyScope=ctrl.resolve.modalBodyScope,ctrl.actionButtons=ctrl.resolve.actionButtons,ctrl.isForm=ctrl.resolve.isForm,ctrl.onBackgroundClick=ctrl.resolve.onBackgroundClick,ctrl.ok=function(label,actionFn){"function"==typeof actionFn?actionFn()!==!1&&ctrl.close({$value:label}):ctrl.close({$value:label})},ctrl.cancel=function(actionFn){"function"==typeof actionFn&&actionFn(),ctrl.dismiss({$value:"cancel"})},$scope.$on("modal.closing",function(event,reason,closed){("backdrop click"===reason||"escape key press"===reason)&&(event.preventDefault(),"function"==typeof ctrl.onBackgroundClick&&ctrl.onBackgroundClick()?ctrl.dismiss({$value:"backdropClick"}):$scope.$digest())})}}]}),angular.module("patternfly.navigation").component("pfApplicationLauncher",{bindings:{items:"<",label:"@?",isDisabled:"<?",isList:"<?",hiddenIcons:"<?"},templateUrl:"navigation/application-launcher.html",controller:["$scope",function($scope){"use strict";var ctrl=this;ctrl.$id=$scope.$id}]}),angular.module("patternfly.navigation").component("pfVerticalNavigation",{bindings:{brandSrc:"@",brandAlt:"@",showBadges:"@",persistentSecondary:"@",pinnableMenus:"@",hiddenIcons:"@",items:"=",navigateCallback:"=?",itemClickCallback:"=?",updateActiveItemsOnClick:"@",ignoreMobile:"@"},templateUrl:"navigation/vertical-navigation.html",transclude:!0,controller:["$window","$timeout","$injector","$location","$rootScope","$scope",function($window,$timeout,$injector,$location,$rootScope,$scope){"use strict";var routeChangeListener,$state,ctrl=this,explicitCollapse=!1,hoverDelay=500,hideDelay=hoverDelay+200,getBodyContentElement=function(){return angular.element(document.querySelector(".container-pf-nav-pf-vertical"))},initBodyElement=function(){var bodyContentElement=getBodyContentElement();ctrl.showBadges&&bodyContentElement.addClass("nav-pf-vertical-with-badges"),ctrl.persistentSecondary&&bodyContentElement.addClass("nav-pf-persistent-secondary"),ctrl.hiddenIcons&&bodyContentElement.addClass("hidden-icons-pf")},updateMobileMenu=function(selected,secondaryItem){ctrl.items.forEach(function(item){item.isMobileItem=!1,item.children&&item.children.forEach(function(nextSecondary){nextSecondary.isMobileItem=!1})}),selected?(selected.isMobileItem=!0,secondaryItem?(secondaryItem.isMobileItem=!0,ctrl.showMobileSecondary=!1,ctrl.showMobileTertiary=!0):(ctrl.showMobileSecondary=!0,ctrl.showMobileTertiary=!1)):(ctrl.showMobileSecondary=!1,ctrl.showMobileTertiary=!1)},checkNavState=function(){var width=$window.innerWidth,bodyContentElement=getBodyContentElement();!ctrl.ignoreMobile&&width<patternfly.pfBreakpoints.tablet?ctrl.inMobileState||(ctrl.inMobileState=!0,bodyContentElement.removeClass("collapsed-nav"),bodyContentElement.addClass("hidden-nav"),updateSecondaryCollapsedState(!1),updateTertiaryCollapsedState(!1),explicitCollapse=!1):(ctrl.inMobileState=!1,ctrl.showMobileNav=!1,bodyContentElement.removeClass("hidden-nav")),explicitCollapse?(ctrl.navCollapsed=!0,bodyContentElement.addClass("collapsed-nav")):(ctrl.navCollapsed=!1,bodyContentElement.removeClass("collapsed-nav"))},collapseMenu=function(){var bodyContentElement=getBodyContentElement();ctrl.navCollapsed=!0,bodyContentElement.addClass("collapsed-nav"),explicitCollapse=!0},expandMenu=function(){var bodyContentElement=getBodyContentElement();ctrl.navCollapsed=!1,bodyContentElement.removeClass("collapsed-nav"),explicitCollapse=!1,angular.element($window).triggerHandler("resize")},forceHideSecondaryMenu=function(){ctrl.forceHidden=!0,$timeout(function(){ctrl.forceHidden=!1},500)},setParentActive=function(item){ctrl.items.forEach(function(topLevel){topLevel.children&&topLevel.children.forEach(function(secondLevel){secondLevel===item&&(topLevel.isActive=!0),secondLevel.children&&secondLevel.children.forEach(function(thirdLevel){thirdLevel===item&&(topLevel.isActive=!0,secondLevel.isActive=!0)})})})},getFirstNavigateChild=function(item){var firstChild;return firstChild=!item.children||item.children.length<1?item:getFirstNavigateChild(item.children[0])},setSecondaryItemVisible=function(){var bodyContentElement=getBodyContentElement();ctrl.activeSecondary=!1,ctrl.persistentSecondary&&!ctrl.inMobileState&&(ctrl.items.forEach(function(topLevel){topLevel.children&&topLevel.children.forEach(function(secondLevel){secondLevel.isActive&&(ctrl.activeSecondary=!0)})}),ctrl.activeSecondary?bodyContentElement.addClass("secondary-visible-pf"):bodyContentElement.removeClass("secondary-visible-pf"))},navigateToItem=function(item){var navTo,navItem=getFirstNavigateChild(item);if(navItem){if(ctrl.showMobileNav=!1,navItem.uiSref&&navItem.href)throw new Error("Using both uiSref and href on an item is not supported.");if(navItem.uiSref){if(void 0===$state)throw new Error('uiSref is defined on item, but no $state has been injected. Did you declare a dependency on "ui.router" module in your app?');$state.go(navItem.uiSref,navItem.uiSrefOptions)}else navTo=navItem.href,navTo&&(navTo.startsWith("#/")&&(navTo=navTo.substring(2)),$location.path(navTo));ctrl.navigateCallback&&ctrl.navigateCallback(navItem)}ctrl.itemClickCallback&&ctrl.itemClickCallback(item),ctrl.updateActiveItemsOnClick&&(ctrl.clearActiveItems(),navItem.isActive=!0,setParentActive(navItem),setSecondaryItemVisible()),setSecondaryItemVisible()},primaryHover=function(){var hover=!1;return ctrl.items.forEach(function(item){item.isHover&&(hover=!0)}),hover},secondaryHover=function(){var hover=!1;return ctrl.items.forEach(function(item){item.children&&item.children.length>0&&item.children.forEach(function(secondaryItem){secondaryItem.isHover&&(hover=!0)})}),hover},updateSecondaryCollapsedState=function(setCollapsed,collapsedItem){var bodyContentElement=getBodyContentElement();collapsedItem&&(collapsedItem.secondaryCollapsed=setCollapsed),setCollapsed?(ctrl.collapsedSecondaryNav=!0,bodyContentElement.addClass("collapsed-secondary-nav-pf")):(ctrl.items&&ctrl.items.forEach(function(item){item.secondaryCollasped=!1}),ctrl.collapsedSecondaryNav=!1,bodyContentElement.removeClass("collapsed-secondary-nav-pf"))},updateTertiaryCollapsedState=function(setCollapsed,collapsedItem){var bodyContentElement=getBodyContentElement();collapsedItem&&(collapsedItem.tertiaryCollapsed=setCollapsed),setCollapsed?(ctrl.collapsedTertiaryNav=!0,bodyContentElement.addClass("collapsed-tertiary-nav-pf"),updateSecondaryCollapsedState(!1)):(ctrl.items&&ctrl.items.forEach(function(item){item.children&&item.children.length>0&&item.children.forEach(function(secondaryItem){secondaryItem.tertiaryCollasped=!1})}),ctrl.collapsedTertiaryNav=!1,bodyContentElement.removeClass("collapsed-tertiary-nav-pf"))};ctrl.showBadges="true"===ctrl.showBadges,ctrl.persistentSecondary="true"===ctrl.persistentSecondary,ctrl.pinnableMenus="true"===ctrl.pinnableMenus,ctrl.hiddenIcons="true"===ctrl.hiddenIcons,ctrl.updateActiveItemsOnClick="true"===ctrl.updateActiveItemsOnClick,ctrl.ignoreMobile="true"===ctrl.ignoreMobile,ctrl.activeSecondary=!1,ctrl.showMobileNav=!1,ctrl.showMobileSecondary=!1,ctrl.showMobileTertiary=!1,ctrl.hoverSecondaryNav=!1,ctrl.hoverTertiaryNav=!1,ctrl.collapsedSecondaryNav=!1,ctrl.collapsedTertiaryNav=!1,ctrl.navCollapsed=!1,ctrl.forceHidden=!1,ctrl.clearActiveItems=function(){ctrl.items.forEach(function(item){item.isActive=!1,item.children&&item.children.forEach(function(secondary){secondary.isActive=!1,secondary.children&&secondary.children.forEach(function(tertiary){tertiary.isActive=!1})})})},ctrl.setActiveItems=function(){var updatedRoute="#"+$location.path();ctrl.items.forEach(function(topLevel){updatedRoute.indexOf(topLevel.href)>-1&&(topLevel.isActive=!0),topLevel.children&&topLevel.children.forEach(function(secondLevel){updatedRoute.indexOf(secondLevel.href)>-1&&(secondLevel.isActive=!0,topLevel.isActive=!0),secondLevel.children&&secondLevel.children.forEach(function(thirdLevel){updatedRoute.indexOf(thirdLevel.href)>-1&&(thirdLevel.isActive=!0,secondLevel.isActive=!0,topLevel.isActive=!0)})})})},ctrl.handleNavBarToggleClick=function(){ctrl.inMobileState?ctrl.showMobileNav?ctrl.showMobileNav=!1:(updateMobileMenu(),ctrl.showMobileNav=!0):ctrl.navCollapsed?expandMenu():collapseMenu()},ctrl.handlePrimaryClick=function(item,event){ctrl.inMobileState?item.children&&item.children.length>0?updateMobileMenu(item):(updateMobileMenu(),navigateToItem(item)):navigateToItem(item)},ctrl.handleSecondaryClick=function(primary,secondary,event){ctrl.inMobileState?secondary.children&&secondary.children.length>0?updateMobileMenu(primary,secondary):(updateMobileMenu(),navigateToItem(secondary)):navigateToItem(secondary)},ctrl.handleTertiaryClick=function(primary,secondary,tertiary,event){ctrl.inMobileState&&updateMobileMenu(),navigateToItem(tertiary)},ctrl.handlePrimaryHover=function(item){item.children&&item.children.length>0&&(ctrl.inMobileState||(void 0!==item.navUnHoverTimeout?($timeout.cancel(item.navUnHoverTimeout),item.navUnHoverTimeout=void 0):void 0!==ctrl.navHoverTimeout||item.isHover||(item.navHoverTimeout=$timeout(function(){ctrl.hoverSecondaryNav=!0,item.isHover=!0,item.navHoverTimeout=void 0},hoverDelay))))},ctrl.handlePrimaryUnHover=function(item){item.children&&item.children.length>0&&(void 0!==item.navHoverTimeout?($timeout.cancel(item.navHoverTimeout),item.navHoverTimeout=void 0):void 0===item.navUnHoverTimeout&&item.isHover&&(item.navUnHoverTimeout=$timeout(function(){item.isHover=!1,primaryHover()||(ctrl.hoverSecondaryNav=!1),item.navUnHoverTimeout=void 0},hideDelay)))},ctrl.handleSecondaryHover=function(item){item.children&&item.children.length>0&&(ctrl.inMobileState||(void 0!==item.navUnHoverTimeout?($timeout.cancel(item.navUnHoverTimeout),item.navUnHoverTimeout=void 0):void 0===ctrl.navHoverTimeout&&(item.navHoverTimeout=$timeout(function(){ctrl.hoverTertiaryNav=!0,item.isHover=!0,item.navHoverTimeout=void 0},hoverDelay))))},ctrl.handleSecondaryUnHover=function(item){item.children&&item.children.length>0&&(void 0!==item.navHoverTimeout?($timeout.cancel(item.navHoverTimeout),item.navHoverTimeout=void 0):void 0===item.navUnHoverTimeout&&(item.navUnHoverTimeout=$timeout(function(){item.isHover=!1,secondaryHover()||(ctrl.hoverTertiaryNav=!1),item.navUnHoverTimeout=void 0},hideDelay)))},ctrl.collapseSecondaryNav=function(item,event){ctrl.inMobileState?updateMobileMenu():item.secondaryCollapsed?(updateSecondaryCollapsedState(!1,item),forceHideSecondaryMenu()):updateSecondaryCollapsedState(!0,item),ctrl.hoverSecondaryNav=!1,event.stopImmediatePropagation()},ctrl.collapseTertiaryNav=function(item,event){ctrl.inMobileState?ctrl.items.forEach(function(primaryItem){primaryItem.children&&primaryItem.children.forEach(function(secondaryItem){secondaryItem===item&&updateMobileMenu(primaryItem)})}):item.tertiaryCollapsed?(updateTertiaryCollapsedState(!1,item),forceHideSecondaryMenu()):updateTertiaryCollapsedState(!0,item),ctrl.hoverSecondaryNav=!1,ctrl.hoverTertiaryNav=!1,event.stopImmediatePropagation()},ctrl.$onInit=function(){$injector.has("$state")&&($state=$injector.get("$state")),ctrl.updateActiveItemsOnClick||$rootScope&&(routeChangeListener=$rootScope.$on("$routeChangeSuccess",function(event,next,current){ctrl.clearActiveItems(),ctrl.setActiveItems()})),initBodyElement(),checkNavState(),angular.element($window).on("resize",function(){checkNavState(),$scope.$digest()})},ctrl.$onDestroy=function(){_.isFunction(routeChangeListener)&&routeChangeListener()}}]}),angular.module("patternfly.notification").component("pfInlineNotification",{bindings:{pfNotificationType:"=",pfNotificationMessage:"=",pfNotificationHeader:"=",pfNotificationPersistent:"=",pfNotificationIndex:"=",pfNotificationRemove:"&?"},templateUrl:"notification/inline-notification.html"}),angular.module("patternfly.notification").component("pfNotificationDrawer",{bindings:{drawerHidden:"<",allowExpand:"=?",drawerExpanded:"=?",drawerTitle:"@",notificationGroups:"<",notificationTrackField:"@",onClose:"=?",showMarkAllRead:"<?",onMarkAllRead:"=?",showClearAll:"<?",onClearAll:"=?",actionButtonTitle:"@",actionButtonCallback:"=?",titleInclude:"@",headingInclude:"@",subheadingInclude:"@",notificationBodyInclude:"@",notificationFooterInclude:"@",noNotificationsText:"@",customScope:"=?"},templateUrl:"notification/notification-drawer.html",controller:["$window","$timeout","$element",function($window,$timeout,$element){"use strict";var ctrl=this,setupGroups=function(){var openFound=!1;angular.isDefined(_.get(ctrl.notificationGroups,"notifications"))&&(ctrl.notificationGroups=[ctrl.notificationGroups]),ctrl.singleGroup=_.size(ctrl.notificationGroups)<2,angular.forEach(ctrl.notificationGroups,function(group){group.emptyStateConfig={icon:"pficon-info",title:group.noNotificationsText||ctrl.noNotificationsText||"There are no notifications to display."}}),angular.forEach(ctrl.notificationGroups,function(group){group.open&&(openFound?group.open=!1:openFound=!0)})},updateAccordionSizing=function(){$timeout(function(){angular.element($window).triggerHandler("resize")},100)};ctrl.toggleCollapse=function(selectedGroup){selectedGroup.open?selectedGroup.open=!1:(angular.forEach(ctrl.notificationGroups,function(group){group.open=!1}),selectedGroup.open=!0,updateAccordionSizing())},ctrl.toggleExpandDrawer=function(){ctrl.drawerExpanded=!ctrl.drawerExpanded},ctrl.$onInit=function(){(!ctrl.allowExpand||angular.isUndefined(ctrl.drawerExpanded))&&(ctrl.drawerExpanded=!1),ctrl.emptyStateConfig={icon:"pficon-info",title:ctrl.noNotificationsText||"There are no notifications to display."},setupGroups()},ctrl.$onChanges=function(changesObj){changesObj.notificationGroups&&(setupGroups(),updateAccordionSizing()),!ctrl.drawerHidden&&(changesObj.drawerHidden||changesObj.showMarkAllRead||changesObj.showClearAll||changesObj.actionButtonTitle||changesObj.titleInclude||changesObj.headingInclude||changesObj.subheadingInclude||changesObj.notificationBodyInclude||changesObj.notificationFooterInclude)&&updateAccordionSizing()},ctrl.$postLink=function(){ctrl.groupHeight&&$element.find(".panel-group").css("height",ctrl.groupHeight),ctrl.groupClass&&$element.find(".panel-group").addClass(ctrl.groupClass)},ctrl.hasNotifications=function(notificationGroup){return _.size(_.get(notificationGroup,"notifications"))>0},ctrl.hasUnread=function(notificationGroup){return _.size(_.filter(_.get(notificationGroup,"notifications"),{unread:!0}))>0}}]}),angular.module("patternfly.notification").provider("Notifications",function(){"use strict";this.delay=8e3,this.verbose=!0,this.notifications={},this.notifications.data=[],this.persist={error:!0,httpError:!0},this.setDelay=function(delay){return this.delay=delay,this},this.setVerbose=function(verbose){return this.verbose=verbose,this},this.setPersist=function(persist){this.persist=persist},this.$get=["$timeout","$log",function($timeout,$log){function createNotifyMethod(mode){return function(message,header,persistent,closeCallback,actionTitle,actionCallback,menuActions){angular.isUndefined(header)&&(header=modes[mode].header),angular.isUndefined(persistent)&&(persistent=persist[mode]),notifications.message(modes[mode].type,header,message,persistent,closeCallback,actionTitle,actionCallback,menuActions),verbose&&$log[modes[mode].log](message)}}var delay=this.delay,notifications=this.notifications,verbose=this.verbose,persist=this.persist,modes={info:{type:"info",header:"Info!",log:"info"},success:{type:"success",header:"Success!",log:"info"},error:{type:"danger",header:"Error!",log:"error"},warn:{type:"warning",header:"Warning!",log:"warn"}};return notifications||(notifications.data=[]),notifications.message=function(type,header,message,isPersistent,closeCallback,actionTitle,actionCallback,menuActions){var notification={type:type,header:header,message:message,isPersistent:isPersistent,closeCallback:closeCallback,actionTitle:actionTitle,actionCallback:actionCallback,menuActions:menuActions};notification.show=!0,notifications.data.push(notification),notification.isPersistent||(notification.viewing=!1,$timeout(function(){notification.show=!1,notification.viewing||notifications.remove(notification)},delay))},angular.forEach(modes,function(mode,index){notifications[index]=createNotifyMethod(index)}),notifications.httpError=function(message,httpResponse){message+=" ("+(httpResponse.data.message||httpResponse.data.cause||httpResponse.data.cause||httpResponse.data.errorMessage)+")",notifications.message("danger","Error!",message,persist.httpError),verbose&&$log.error(message)},notifications.remove=function(notification){var index=notifications.data.indexOf(notification);-1!==index&&notifications.removeIndex(index)},notifications.removeIndex=function(index){notifications.data.splice(index,1)},notifications.setViewing=function(notification,viewing){notification.viewing=viewing,viewing||notification.show||notifications.remove(notification)},notifications}]}),angular.module("patternfly.notification").component("pfNotificationList",{templateUrl:"notification/notification-list.html",controller:["Notifications",function(Notifications){"use strict";var ctrl=this;ctrl.$onInit=function(){ctrl.notifications=Notifications}}]}),angular.module("patternfly.notification").component("pfToastNotificationList",{bindings:{notifications:"=",showClose:"=?",htmlContent:"<?",closeCallback:"=?",updateViewing:"=?"},templateUrl:"notification/toast-notification-list.html",controller:function(){"use strict";var ctrl=this;ctrl.handleClose=function(notification){angular.isFunction(ctrl.closeCallback)&&ctrl.closeCallback(notification)},ctrl.handleViewingChange=function(isViewing,notification){angular.isFunction(ctrl.updateViewing)&&ctrl.updateViewing(isViewing,notification)}}}),angular.module("patternfly.notification").component("pfToastNotification",{bindings:{notificationType:"@",message:"@",header:"@",showClose:"@",htmlContent:"<?",closeCallback:"=?",actionTitle:"@",actionCallback:"=?",menuActions:"<?",updateViewing:"=?",data:"=?"},templateUrl:"notification/toast-notification.html",controller:["$sce",function($sce){"use strict";var _showClose,ctrl=this;Object.defineProperty(ctrl,"showClose",{get:function(){return _showClose},set:function(value){_showClose=value,ctrl.updateShowClose()}}),ctrl.notificationType=ctrl.notificationType||"info",ctrl.updateShowClose=function(){ctrl.showCloseButton="true"===ctrl.showClose&&(angular.isUndefined(ctrl.menuActions)||ctrl.menuActions.length<1)},ctrl.handleClose=function(){angular.isFunction(ctrl.closeCallback)&&ctrl.closeCallback(ctrl.data)},ctrl.handleAction=function(){angular.isFunction(ctrl.actionCallback)&&ctrl.actionCallback(ctrl.data)},ctrl.handleMenuAction=function(menuAction){menuAction&&angular.isFunction(menuAction.actionFn)&&menuAction.isDisabled!==!0&&menuAction.actionFn(menuAction,ctrl.data)},ctrl.handleEnter=function(){angular.isFunction(ctrl.updateViewing)&&ctrl.updateViewing(!0,ctrl.data)},ctrl.handleLeave=function(){angular.isFunction(ctrl.updateViewing)&&ctrl.updateViewing(!1,ctrl.data)},ctrl.$onInit=function(){ctrl.updateShowClose()},ctrl.$onChanges=function(changesObj){changesObj.menuActions&&ctrl.updateShowClose()},ctrl.trustAsHtml=function(html){return $sce.trustAsHtml(html)}}]}),angular.module("patternfly.pagination").component("pfPagination",{transclude:!0,templateUrl:"pagination/pagination.html",bindings:{pageNumber:"=?",numTotalItems:"<",pageSizeIncrements:"<?",pageSize:"=?",updatePageSize:"&",updatePageNumber:"&"},controller:["$scope","$log",function($scope,$log){"use strict";function updatePageNumber(newPageNumber){ctrl.pageNumber=newPageNumber,ctrl.updatePageNumber&&ctrl.updatePageNumber({$event:{pageNumber:ctrl.pageNumber}})}function getLastPageNumber(){return Math.ceil(ctrl.numTotalItems/ctrl.pageSize)}function isLastPage(){return ctrl.pageNumber===ctrl.lastPageNumber}var ctrl=this,defaultPageSizeIncrements=[5,10,20,40,80,100];ctrl.$onInit=function(){angular.isUndefined(ctrl.pageNumber)&&(ctrl.pageNumber=1),angular.isUndefined(ctrl.pageSizeIncrements)&&(ctrl.pageSizeIncrements=defaultPageSizeIncrements),angular.isUndefined(ctrl.pageSize)&&(ctrl.pageSize=ctrl.pageSizeIncrements[0]),ctrl.lastPageNumber=getLastPageNumber()},ctrl.$onChanges=function(changesObj){changesObj.numTotalItems&&!changesObj.numTotalItems.isFirstChange()&&(ctrl.lastPageNumber=getLastPageNumber(),ctrl.gotoFirstPage())},ctrl.onPageSizeChange=function(newPageSize){ctrl.pageSize=newPageSize,ctrl.lastPageNumber=getLastPageNumber(),ctrl.gotoFirstPage(),ctrl.updatePageSize&&ctrl.updatePageSize({$event:{pageSize:newPageSize}})},ctrl.onPageNumberChange=function(){var newPageNumber=parseInt(ctrl.pageNumber,10);updatePageNumber(newPageNumber>ctrl.lastPageNumber?ctrl.lastPageNumber:1>newPageNumber||isNaN(ctrl.pageNumber)?1:newPageNumber)},ctrl.gotoFirstPage=function(){1!==ctrl.pageNumber&&updatePageNumber(1)},ctrl.gotoPreviousPage=function(){1!==ctrl.pageNumber&&updatePageNumber(ctrl.pageNumber-1)},ctrl.gotoNextPage=function(){ctrl.pageNumber<ctrl.lastPageNumber&&updatePageNumber(ctrl.pageNumber+1)},ctrl.gotoLastPage=function(){ctrl.pageNumber<ctrl.lastPageNumber&&updatePageNumber(ctrl.lastPageNumber)},ctrl.getStartIndex=function(){return ctrl.numTotalItems?ctrl.pageSize*(ctrl.pageNumber-1)+1:0},ctrl.getEndIndex=function(){var numFullPages=Math.floor(ctrl.numTotalItems/ctrl.pageSize),numItemsOnLastPage=ctrl.numTotalItems-numFullPages*ctrl.pageSize||ctrl.pageSize,numItemsOnPage=isLastPage()?numItemsOnLastPage:ctrl.pageSize;return ctrl.numTotalItems?ctrl.getStartIndex()+numItemsOnPage-1:0}}]}),angular.module("patternfly.select").directive("pfBootstrapSelect",function(){"use strict";return{restrict:"A",require:"?ngModel",scope:{selectPickerOptions:"=pfBootstrapSelect"},link:function(scope,element,attrs,ngModel){var optionCollectionList,optionCollectionExpr,optionCollection,$render=ngModel.$render,selectpickerRefresh=function(argument){scope.$applyAsync(function(){element.selectpicker("refresh")})},selectpickerDestroy=function(){element.selectpicker("destroy")};element.selectpicker(scope.selectPickerOptions),ngModel.$render=function(){$render.apply(this,arguments),selectpickerRefresh()},attrs.ngOptions&&(optionCollectionList=attrs.ngOptions.split("in "),optionCollectionExpr=optionCollectionList[optionCollectionList.length-1].split(/track by|\|/),optionCollection=optionCollectionExpr[0],scope.$parent.$watchCollection(optionCollection,selectpickerRefresh)),attrs.ngModel&&scope.$parent.$watch(attrs.ngModel,selectpickerRefresh),attrs.$observe("disabled",selectpickerRefresh),scope.$on("$destroy",selectpickerDestroy)}}}),angular.module("patternfly.select").component("pfSelect",{bindings:{selected:"=",options:"<",displayField:"@",emptyValue:"@",onSelect:"<"},templateUrl:"select/select.html",controller:function(){"use strict";function getDisplayValue(item){var value;return value=item!==ctrl.emptyValue&&angular.isString(ctrl.displayField)?item[ctrl.displayField]:item}function selectItem(evt,item){evt.preventDefault(),ctrl.selected=item,angular.isFunction(ctrl.onSelect)&&ctrl.onSelect(item)}var ctrl=this;ctrl.$onInit=function(){angular.extend(ctrl,{showEmpty:angular.isDefined(ctrl.emptyValue),getDisplayValue:getDisplayValue,selectItem:selectItem})}}}),angular.module("patternfly.sort").component("pfSort",{bindings:{config:"="},templateUrl:"sort/sort.html",controller:function(){"use strict";function setupConfig(){var updated=!1;prevConfig=angular.copy(ctrl.config),void 0===ctrl.config.fields&&(ctrl.config.fields=[]),ctrl.config.fields.length>0&&(void 0===ctrl.config.currentField&&(ctrl.config.currentField=ctrl.config.fields[0],updated=!0),void 0===ctrl.config.isAscending&&(ctrl.config.isAscending=!0,updated=!0)),updated===!0&&ctrl.config.onSortChange&&ctrl.config.onSortChange(ctrl.config.currentField,ctrl.config.isAscending)}function selectField(evt,field){evt.preventDefault(),ctrl.config.currentField=field,ctrl.config.onSortChange&&ctrl.config.onSortChange(ctrl.config.currentField,ctrl.config.isAscending)}function changeDirection(){ctrl.config.isAscending=!ctrl.config.isAscending,ctrl.config.onSortChange&&ctrl.config.onSortChange(ctrl.config.currentField,ctrl.config.isAscending)}function getSortIconClass(){var iconClass;return iconClass="numeric"===ctrl.config.currentField.sortType?ctrl.config.isAscending?"fa fa-sort-numeric-asc":"fa fa-sort-numeric-desc":ctrl.config.isAscending?"fa fa-sort-alpha-asc":"fa fa-sort-alpha-desc"}var prevConfig,ctrl=this;ctrl.$onInit=function(){angular.isDefined(ctrl.config)&&angular.isUndefined(ctrl.config.show)&&(ctrl.config.show=!0),angular.extend(ctrl,{selectField:selectField,changeDirection:changeDirection,getSortIconClass:getSortIconClass})},ctrl.$onChanges=function(){setupConfig()},ctrl.$doCheck=function(){angular.equals(ctrl.config,prevConfig)||setupConfig()}}}),angular.module("patternfly.table").component("pfTableView",{bindings:{config:"<?",dtOptions:"<?",colummns:"<?",columns:"<?",items:"<",actionButtons:"<?",menuActions:"<?",pageConfig:"=?",emptyStateConfig:"=?",emptyStateActionButtons:"=?"},templateUrl:"table/tableview/table-view.html",controller:["DTOptionsBuilder","DTColumnDefBuilder","$element","pfUtils","$log","$filter","$timeout","$sce",function(DTOptionsBuilder,DTColumnDefBuilder,$element,pfUtils,$log,$filter,$timeout,$sce){"use strict";function setPagination(){angular.isUndefined(ctrl.dtOptions)?ctrl.dtOptions={}:(angular.isDefined(ctrl.dtOptions.paginationType)&&(ctrl.dtOptions.paging=!0,angular.isUndefined(ctrl.pageConfig)&&(ctrl.pageConfig={}),angular.isNumber(ctrl.pageConfig.pageNumber)||(ctrl.pageConfig.pageNumber=1)),angular.isNumber(ctrl.dtOptions.displayLength)&&(ctrl.dtOptions.paging=!0,angular.isUndefined(ctrl.pageConfig)&&(ctrl.pageConfig={}),angular.isNumber(ctrl.pageConfig.pageSize)||(ctrl.pageConfig.pageSize=ctrl.dtOptions.displayLength)),angular.isDefined(ctrl.dtOptions.dom)&&-1!==ctrl.dtOptions.dom.indexOf("p")&&(ctrl.dtOptions.dom=ctrl.dtOptions.dom.replace(/p/gi,""))),angular.isDefined(ctrl.pageConfig)&&(ctrl.dtOptions.paging=!0,ctrl.pageConfig.numTotalItems=ctrl.items.length,angular.isUndefined(ctrl.pageConfig.pageSize)&&(ctrl.pageConfig.pageSize=10),ctrl.dtOptions.displayLength=ctrl.pageConfig.pageSize,angular.isUndefined(ctrl.pageConfig.pageNumber)&&(ctrl.pageConfig.pageNumber=1))}function setColumnDefs(){var offset,i=0,actnBtns=1;if(ctrl.dtColumnDefs=[],ctrl.config.showCheckboxes&&ctrl.dtColumnDefs.push(DTColumnDefBuilder.newColumnDef(i++).notSortable()),_.forEach(ctrl.columns,function(column){ctrl.dtColumnDefs.push(DTColumnDefBuilder.newColumnDef(i++))}),offset=ctrl.config.showCheckboxes?1:0,ctrl.selectionMatchPropColNum=_.findIndex(ctrl.columns,["itemField",ctrl.config.selectionMatchProp])+offset,ctrl.actionButtons&&ctrl.actionButtons.length>0)for(actnBtns=1;actnBtns<=ctrl.actionButtons.length;actnBtns++)ctrl.dtColumnDefs.push(DTColumnDefBuilder.newColumnDef(i++).notSortable());ctrl.menuActions&&ctrl.menuActions.length>0&&ctrl.dtColumnDefs.push(DTColumnDefBuilder.newColumnDef(i++).notSortable())}function listenForDraw(){var oTable,dtInstance=ctrl.dtInstance;dtInstance&&dtInstance.dataTable&&(oTable=dtInstance.dataTable,angular.isDefined(ctrl.pageConfig)&&angular.isDefined(ctrl.pageConfig.pageNumber)&&oTable.fnPageChange(ctrl.pageConfig.pageNumber-1),ctrl.tableId=oTable[0].id,oTable.off("draw.dt"),oTable.on("draw.dt",function(){ctrl.debug&&$log.debug("--> redraw"),selectRowsByChecked()}))}function validSelectionMatchProp(){return void 0!==_.find(ctrl.columns,["itemField",ctrl.config.selectionMatchProp])}function getItemFromRow(matchPropValue){return _.find(ctrl.items,function(item){return _.toString(item[ctrl.config.selectionMatchProp])===_.toString(matchPropValue)})}function selectRowsByChecked(){ctrl.config.showCheckboxes&&$timeout(function(){var oTable,rows,checked;oTable=ctrl.dtInstance.DataTable,ctrl.debug&&$log.debug("  selectRowsByChecked"),angular.isUndefined(oTable)||(ctrl.debug&&$log.debug("  ...oTable defined"),rows=oTable.rows(),rows.deselect(),rows=oTable.rows(function(idx,data,node){return checked=node.children[0].children[0].checked}),ctrl.debug&&$log.debug("   ... #checkedRows = "+rows[0].length),rows[0].length>0&&rows.select(),setSelectAllCheckbox())})}function setSelectAllCheckbox(){var numVisibleRows,numCheckedRows;ctrl.debug&&$log.debug("  setSelectAllCheckbox"),numVisibleRows=getVisibleRows().length,numCheckedRows=document.querySelectorAll("#"+ctrl.tableId+" tbody tr.even.selected").length+document.querySelectorAll("#"+ctrl.tableId+" tbody tr.odd.selected").length,ctrl.selectAll=numVisibleRows===numCheckedRows}function getVisibleRows(){var i,rowData,visibleRows=[],anNodes=document.querySelectorAll("#"+ctrl.tableId+"  tbody tr");for(i=0;i<anNodes.length;++i)rowData=anNodes[i].cells,null!==rowData&&rowData.length>ctrl.selectionMatchPropColNum&&visibleRows.push(_.trim(rowData[ctrl.selectionMatchPropColNum].innerText));return ctrl.debug&&$log.debug("    getVisibleRows ("+visibleRows.length+")"),visibleRows}function setDropMenuLocation(parentDiv){var dropButton=parentDiv.querySelector(".dropdown-toggle"),dropMenu=parentDiv.querySelector(".dropdown-menu"),parentRect=$element[0].getBoundingClientRect(),buttonRect=dropButton.getBoundingClientRect(),menuRect=dropMenu.getBoundingClientRect(),menuTop=buttonRect.top-menuRect.height,menuBottom=buttonRect.top+buttonRect.height+menuRect.height;menuBottom<=parentRect.top+parentRect.height||menuTop<parentRect.top?ctrl.dropdownClass="dropdown":ctrl.dropdownClass="dropup"}var prevDtOptions,prevItems,prevPageConfig,prevShowCheckboxes,ctrl=this;ctrl.debug=!1,ctrl.selectAll=!1,ctrl.dtInstance={},ctrl.defaultDtOptions={autoWidth:!1,destroy:!0,order:[[0,"asc"]],dom:"t",paging:!1,select:{selector:'td:first-child input[type="checkbox"]',style:"multi"}},ctrl.defaultConfig={selectionMatchProp:"uuid",onCheckBoxChange:null,showCheckboxes:!0},ctrl.$onInit=function(){ctrl.debug&&$log.debug("$onInit"),angular.isDefined(ctrl.colummns)&&angular.isUndefined(ctrl.columns)&&(ctrl.columns=ctrl.colummns),angular.isUndefined(ctrl.config)&&(ctrl.config={}),ctrl.updateConfigOptions(),setColumnDefs()},ctrl.updateConfigOptions=function(){var props="";if(ctrl.debug&&$log.debug("  updateConfigOptions"),setPagination(),angular.isDefined(ctrl.dtOptions)&&angular.isDefined(ctrl.dtOptions.displayLength)&&(ctrl.dtOptions.displayLength=Number(ctrl.dtOptions.displayLength)),_.defaults(ctrl.dtOptions,ctrl.defaultDtOptions),_.defaults(ctrl.config,ctrl.defaultConfig),ctrl.config.showCheckboxes!==prevShowCheckboxes&&_.each(ctrl.dtOptions.order,function(col){col[0]=ctrl.config.showCheckboxes?col[0]+1:col[0]-1,col[0]=col[0]<0?0:col[0]}),prevDtOptions=angular.copy(ctrl.dtOptions),prevItems=angular.copy(ctrl.items),prevPageConfig=angular.copy(ctrl.pageConfig),prevShowCheckboxes=angular.copy(ctrl.config.showCheckboxes),!validSelectionMatchProp())throw angular.forEach(ctrl.columns,function(col){0===props.length?props=col.itemField:props+=", "+col.itemField}),new Error("pfTableView - config.selectionMatchProp '"+ctrl.config.selectionMatchProp+"' does not match any property in 'config.columns'! Please set config.selectionMatchProp to one of these properties: "+props)},ctrl.dtInstanceCallback=function(_dtInstance){ctrl.debug&&$log.debug("--> dtInstanceCallback"),ctrl.dtInstance=_dtInstance,listenForDraw(),selectRowsByChecked()},ctrl.$onChanges=function(changesObj){ctrl.debug&&$log.debug("$onChanges"),changesObj.config&&!changesObj.config.isFirstChange()&&(ctrl.debug&&$log.debug("...updateConfigOptions"),ctrl.updateConfigOptions()),changesObj.items&&changesObj.items.currentValue&&(ctrl.config.itemsAvailable=changesObj.items.currentValue.length>0)},ctrl.updatePageSize=function(event){ctrl.pageConfig.pageSize=event.pageSize,ctrl.dtOptions.displayLength=ctrl.pageConfig.pageSize,
ctrl.pageConfig.pageNumber=1},ctrl.updatePageNumber=function(event){ctrl.dtInstance&&(ctrl.pageConfig.pageNumber=event.pageNumber,ctrl.dtInstance&&ctrl.dtInstance.dataTable&&ctrl.dtInstance.dataTable.fnPageChange(ctrl.pageConfig.pageNumber-1))},ctrl.$doCheck=function(){ctrl.debug&&$log.debug("$doCheck"),angular.equals(ctrl.dtOptions,prevDtOptions)&&angular.equals(ctrl.pageConfig,prevPageConfig)||(ctrl.debug&&$log.debug("  dtOptions !== prevDtOptions"),ctrl.updateConfigOptions()),angular.equals(ctrl.items,prevItems)||(ctrl.debug&&$log.debug("  items !== prevItems"),ctrl.items&&(ctrl.config.itemsAvailable=ctrl.items.length>0),angular.isDefined(ctrl.pageConfig)&&angular.isDefined(ctrl.pageConfig.numTotalItems)&&(ctrl.pageConfig.numTotalItems=ctrl.items.length),prevItems=angular.copy(ctrl.items))},ctrl.$postLink=function(){ctrl.debug&&$log.debug(" $postLink")},ctrl.$onDestroy=function(){ctrl.debug&&$log.debug(" $onDestroy"),ctrl.dtInstance={}},ctrl.toggleAll=function(){var item,visibleRows=getVisibleRows();angular.forEach(visibleRows,function(row){item=getItemFromRow(row),item.selected!==ctrl.selectAll&&(item.selected=ctrl.selectAll,ctrl.config&&ctrl.config.onCheckBoxChange&&ctrl.config.onCheckBoxChange(item))}),selectRowsByChecked()},ctrl.toggleOne=function(item){ctrl.config&&ctrl.config.onCheckBoxChange&&ctrl.config.onCheckBoxChange(item)},ctrl.handleButtonAction=function(action,item){action&&action.actionFn&&action.actionFn(action,item)},ctrl.handleColAction=function(key,value){var tableCol=$filter("filter")(ctrl.columns,{itemField:key});tableCol&&1===tableCol.length&&tableCol[0].hasOwnProperty("colActionFn")&&tableCol[0].colActionFn(value)},ctrl.areActions=function(){return ctrl.actionButtons&&ctrl.actionButtons.length>0||ctrl.menuActions&&ctrl.menuActions.length>0},ctrl.calcActionsColspan=function(){var colspan=0;return ctrl.actionButtons&&ctrl.actionButtons.length>0&&(colspan+=ctrl.actionButtons.length),ctrl.menuActions&&ctrl.menuActions.length>0&&(colspan+=1),colspan},ctrl.handleMenuAction=function(action,item){!ctrl.checkDisabled(item)&&action&&action.actionFn&&action.isDisabled!==!0&&action.actionFn(action,item)},ctrl.setupActions=function(item,event){$timeout(function(){var nextElement,parentDiv=void 0;for(nextElement=event.target;nextElement&&!parentDiv;)-1!==nextElement.className.indexOf("dropdown-kebab-pf")&&(parentDiv=nextElement,-1!==nextElement.className.indexOf("open")&&setDropMenuLocation(parentDiv)),nextElement=nextElement.parentElement})},ctrl.checkDisabled=function(){return!1},ctrl.trustAsHtml=function(html){return $sce.trustAsHtml(html)}}]}),angular.module("patternfly.toolbars").component("pfToolbar",{bindings:{config:"="},transclude:{actions:"?"},templateUrl:"toolbars/toolbar.html",controller:function(){"use strict";function setupConfig(){prevConfig=angular.copy(ctrl.config),ctrl.config&&ctrl.config.viewsConfig&&ctrl.config.viewsConfig.views&&(ctrl.config.viewsConfig.viewsList=angular.copy(ctrl.config.viewsConfig.views),ctrl.config.viewsConfig.currentView||(ctrl.config.viewsConfig.currentView=ctrl.config.viewsConfig.viewsList[0].id))}function viewSelected(viewId){ctrl.config.viewsConfig.currentView=viewId,ctrl.config.viewsConfig.onViewSelect&&!ctrl.checkViewDisabled(viewId)&&ctrl.config.viewsConfig.onViewSelect(viewId)}function isViewSelected(viewId){return ctrl.config.viewsConfig&&ctrl.config.viewsConfig.currentView===viewId}function isTableViewSelected(){return ctrl.config.viewsConfig?"tableView"===ctrl.config.viewsConfig.currentView:ctrl.config.isTableView}function checkViewDisabled(view){return ctrl.config.viewsConfig.checkViewDisabled&&ctrl.config.viewsConfig.checkViewDisabled(view)}function filterExists(filter){var foundFilter=_.find(ctrl.config.filterConfig.appliedFilters,{title:filter.title,value:filter.value});return void 0!==foundFilter}function enforceSingleSelect(filter){_.remove(ctrl.config.filterConfig.appliedFilters,{title:filter.title})}function addFilter(field,value){var newFilter={id:field.id,title:field.title,value:value};filterExists(newFilter)||("select"===field.filterType&&enforceSingleSelect(newFilter),ctrl.config.filterConfig.appliedFilters.push(newFilter),ctrl.config.filterConfig.onFilterChange&&ctrl.config.filterConfig.onFilterChange(ctrl.config.filterConfig.appliedFilters))}function handleAction(action){action&&action.actionFn&&action.isDisabled!==!0&&action.actionFn(action)}var prevConfig,ctrl=this;ctrl.$onInit=function(){angular.isDefined(ctrl.config.sortConfig)&&angular.isUndefined(ctrl.config.sortConfig.show)&&(ctrl.config.sortConfig.show=!0),angular.extend(ctrl,{viewSelected:viewSelected,isViewSelected:isViewSelected,isTableViewSelected:isTableViewSelected,checkViewDisabled:checkViewDisabled,addFilter:addFilter,handleAction:handleAction})},ctrl.$onChanges=function(){setupConfig()},ctrl.$doCheck=function(){angular.equals(ctrl.config,prevConfig)||setupConfig()}}}),angular.module("patternfly.utils").directive("pfFixedAccordion",["$window","$timeout",function($window,$timeout){"use strict";return{restrict:"A",scope:{scrollSelector:"@",groupHeight:"@",groupClass:"@"},link:function($scope,$element,$attrs){var contentElementHeight=function(contentElement){var contentHeight=contentElement.offsetHeight;return contentHeight+=parseInt(getComputedStyle(contentElement).marginTop),contentHeight+=parseInt(getComputedStyle(contentElement).marginBottom)},setBodyScrollHeight=function(parentElement,bodyHeight){var collapsePanel,scrollElement,panelContents,innerHeight,scroller,collapsePanels=parentElement[0].querySelectorAll(".panel-collapse");angular.forEach(collapsePanels,function(collapseElement){collapsePanel=angular.element(collapseElement),scrollElement=collapsePanel,innerHeight=0,angular.isDefined($scope.scrollSelector)&&(scroller=angular.element(collapsePanel[0].querySelector($scope.scrollSelector)),scroller.length&&(scrollElement=angular.element(scroller[0]),panelContents=collapsePanel.children(),angular.forEach(panelContents,function(contentElement){contentElement!==scrollElement[0]&&(innerHeight+=contentElementHeight(contentElement))}))),angular.element(scrollElement).css("max-height",Math.max(bodyHeight-innerHeight,25)+"px"),angular.element(scrollElement).css("overflow-y","auto")})},setCollapseHeights=function(){var height,openPanel,contentHeight,bodyHeight,overflowY="hidden",parentElement=angular.element($element[0].querySelector(".panel-group")),headings=angular.element(parentElement).children();height=parentElement[0].clientHeight,openPanel=parentElement[0].querySelectorAll(".collapse.in"),openPanel&&openPanel.length>0&&angular.element(openPanel).removeClass("in"),contentHeight=0,angular.forEach(headings,function(heading){contentHeight+=contentElementHeight(heading)}),bodyHeight=height-contentHeight,25>bodyHeight&&(bodyHeight=25,overflowY="auto"),openPanel&&openPanel.length>0&&angular.element(openPanel).addClass("in"),angular.element(parentElement).css("overflow-y",overflowY),$timeout(function(){setBodyScrollHeight(parentElement,bodyHeight)})},debounceResize=_.debounce(setCollapseHeights,150,{maxWait:250});$scope.groupHeight&&angular.element($element[0].querySelector(".panel-group")).css("height",$scope.groupHeight),$scope.groupClass&&angular.element($element[0].querySelector(".panel-group")).addClass($scope.groupClass),$timeout(function(){setCollapseHeights()},100),$element.on("resize",function(){debounceResize()}),angular.element($window).on("resize",function(){debounceResize()})}}}]),angular.module("patternfly.utils").directive("pfTransclude",function(){"use strict";return{restrict:"A",link:function($scope,$element,$attrs,controller,$transclude){var iChildScope,iScopeType;if(!$transclude)throw new Error("pfTransclude - Illegal use of pfTransclude directive in the template! No parent directive that requires a transclusion found. Element: {0}");switch(iScopeType=$attrs.pfTransclude||"sibling"){case"sibling":$transclude(function(clone){$element.empty(),$element.append(clone)});break;case"parent":$transclude($scope,function(clone){$element.empty(),$element.append(clone)});break;case"child":iChildScope=$scope.$new(),$transclude(iChildScope,function(clone){$element.empty(),$element.append(clone),$element.on("$destroy",function(){iChildScope.$destroy()})})}}}}),function(){"use strict";angular.module("patternfly.utils").constant("pfUtils",{merge:function(source1,source2){var retValue;return retValue="function"==typeof angular.merge?this.angularMerge(source1,source2):"function"==typeof _.merge?this._merge(source1,source2):"function"==typeof $.extend?this.$extend(source1,source2):this.mergeDeep(source1,source2)},angularMerge:function(source1,source2){return angular.merge({},source1,source2)},_merge:function(source1,source2){return _.merge({},source1,source2)},$extend:function(source1,source2){return $.extend(!0,angular.copy(source1),source2)},mergeDeep:function(source1,source2){return mergeDeep({},angular.copy(source1),angular.copy(source2))},utilizationToColor:function(utilization){return utilizationToColor(utilization)},colorPalette:patternfly.pfPaletteColors})}(),angular.module("patternfly.validation",[]).directive("pfValidation",["$timeout",function($timeout){"use strict";return{restrict:"A",require:"ngModel",scope:{pfValidation:"&",pfValidationDisabled:"="},link:function(scope,element,attrs,ctrl){function validate(){var valid,val=scope.inputCtrl.$modelValue,valFunc=scope.pfValidation({input:val});attrs.pfValidation||(valFunc=!0),valid=!val||valFunc||""===val,toggleErrorClass(scope.valEnabled&&!valid?!0:!1)}function toggleErrorClass(add){var messageElement=element.next(),parentElement=element.parent(),hasErrorM=parentElement.hasClass("has-error"),wasHidden=messageElement.hasClass("ng-hide");scope.inputCtrl.$setValidity("pf-validation",!add),add&&(hasErrorM||parentElement.addClass("has-error"),wasHidden&&messageElement.removeClass("ng-hide")),add||(hasErrorM&&parentElement.removeClass("has-error"),wasHidden||messageElement.addClass("ng-hide"))}scope.inputCtrl=ctrl,scope.valEnabled=!attrs.pfValidationDisabled,scope.$watch("pfValidationDisabled",function(newVal){scope.valEnabled=!newVal,newVal?(scope.inputCtrl.$setValidity("pfValidation",!0),toggleErrorClass(!1)):validate()}),attrs.pfValidation?$timeout(function(){validate()},0):!scope.inputCtrl.$valid&&scope.inputCtrl.$dirty&&toggleErrorClass(!0),scope.$watch("inputCtrl.$valid",function(isValid){toggleErrorClass(isValid?!1:!0)}),scope.$watch("inputCtrl.$modelValue",function(){validate()})}}}]),angular.module("patternfly.views").component("pfCardView",{bindings:{config:"=?",pageConfig:"=?",emptyStateConfig:"=?",emptyStateActionButtons:"=?",items:"=",eventId:"@id"},transclude:!0,templateUrl:"views/cardview/card-view.html",controller:function(){"use strict";function setPagination(){angular.isUndefined(ctrl.pageConfig)?ctrl.pageConfig={pageNumber:1,pageSize:ctrl.items.length,numTotalItems:ctrl.items.length,showPaginationControls:!1}:(angular.isUndefined(ctrl.pageConfig.showPaginationControls)&&(ctrl.pageConfig.showPaginationControls=!0),angular.isNumber(ctrl.pageConfig.pageNumber)||(ctrl.pageConfig.pageNumber=1),angular.isNumber(ctrl.pageConfig.pageSize)||(ctrl.pageConfig.pageSize=10),angular.isNumber(ctrl.pageConfig.numTotalItems)||(ctrl.pageConfig.numTotalItems=ctrl.items.length),ctrl.pageConfig.showPaginationControls||(ctrl.pageConfig.pageSize=ctrl.pageConfig.numTotalItems)),prevPageConfig=angular.copy(ctrl.pageConfig)}var prevPageConfig,prevItems,ctrl=this;ctrl.defaultConfig={selectItems:!1,multiSelect:!1,dblClick:!1,selectionMatchProp:"uuid",selectedItems:[],checkDisabled:!1,showSelectBox:!0,onSelect:null,onSelectionChange:null,onCheckBoxChange:null,onClick:null,onDblClick:null,itemsAvailable:!0},ctrl.itemClick=function(e,item){var alreadySelected,selectionChanged=!1,continueEvent=!0;return ctrl.checkDisabled(item)?continueEvent:(ctrl.config&&ctrl.config.selectItems&&item&&(ctrl.config.multiSelect&&!ctrl.config.dblClick?(alreadySelected=_.find(ctrl.config.selectedItems,function(itemObj){return itemObj===item}),alreadySelected?ctrl.config.selectedItems=_.without(ctrl.config.selectedItems,item):(ctrl.config.selectedItems.push(item),selectionChanged=!0)):ctrl.config.selectedItems[0]===item?(ctrl.config.dblClick||(ctrl.config.selectedItems=[],selectionChanged=!0),continueEvent=!1):(ctrl.config.selectedItems=[item],selectionChanged=!0),selectionChanged&&ctrl.config.onSelect&&ctrl.config.onSelect(item,e),selectionChanged&&ctrl.config.onSelectionChange&&ctrl.config.onSelectionChange(ctrl.config.selectedItems,e)),ctrl.config.onClick&&ctrl.config.onClick(item,e),continueEvent)},ctrl.dblClick=function(e,item){ctrl.config.onDblClick&&ctrl.config.onDblClick(item,e)},ctrl.checkBoxChange=function(item){ctrl.config.onCheckBoxChange&&ctrl.config.onCheckBoxChange(item)},ctrl.isSelected=function(item){var matchProp=ctrl.config.selectionMatchProp,selected=!1;if(ctrl.config.showSelectBox)selected=item.selected;else if(ctrl.config.selectedItems.length)return _.find(ctrl.config.selectedItems,function(itemObj){return itemObj[matchProp]===item[matchProp]});return selected},ctrl.checkDisabled=function(item){return ctrl.config.checkDisabled&&ctrl.config.checkDisabled(item)},ctrl.$onInit=function(){if(_.defaults(ctrl.config,ctrl.defaultConfig),ctrl.config.selectItems&&ctrl.config.showSelectBox)throw new Error("pfCardView - Illegal use of pfCardView component! Cannot allow both select box and click selection in the same card view.");prevItems=angular.copy(ctrl.items),setPagination()},ctrl.$doCheck=function(){angular.equals(ctrl.pageConfig,prevPageConfig)||setPagination(),angular.equals(ctrl.items,prevItems)||(ctrl.items&&(ctrl.config.itemsAvailable=ctrl.items.length>0),angular.isDefined(ctrl.pageConfig)&&(ctrl.pageConfig.numTotalItems=ctrl.items.length),prevItems=angular.copy(ctrl.items))}}}),angular.module("patternfly.views").component("pfEmptyState",{bindings:{config:"<?",actionButtons:"<?"},templateUrl:"views/empty-state.html",controller:["$filter",function($filter){"use strict";var prevConfig,ctrl=this;ctrl.defaultConfig={title:"No Items Available"},ctrl.$onInit=function(){angular.isUndefined(ctrl.config)&&(ctrl.config={}),ctrl.updateConfig()},ctrl.updateConfig=function(){prevConfig=angular.copy(ctrl.config),_.defaults(ctrl.config,ctrl.defaultConfig)},ctrl.$onChanges=function(changesObj){changesObj.config&&!changesObj.config.isFirstChange()&&ctrl.updateConfig()},ctrl.$doCheck=function(){angular.equals(ctrl.config,prevConfig)||ctrl.updateConfig()},ctrl.hasMainActions=function(){var mainActions;return ctrl.actionButtons?(mainActions=$filter("filter")(ctrl.actionButtons,{type:"main"}),mainActions.length):!1},ctrl.hasSecondaryActions=function(){var secondaryActions;return ctrl.actionButtons?(secondaryActions=$filter("filter")(ctrl.actionButtons,{type:void 0}),secondaryActions.length):!1},ctrl.filterMainActions=function(action){return"main"===action.type},ctrl.filterSecondaryActions=function(action){return"main"!==action.type},ctrl.handleButtonAction=function(action){action&&action.actionFn&&action.actionFn(action)}}]}),angular.module("patternfly.views").component("pfListView",{bindings:{config:"=?",pageConfig:"=?",items:"=",actionButtons:"=?",enableButtonForItemFn:"=?",menuActions:"=?",hideMenuForItemFn:"=?",menuClassForItemFn:"=?",updateMenuActionForItemFn:"=?",actions:"=?",updateActionForItemFn:"=?",customScope:"=?",emptyStateConfig:"=?",emptyStateActionButtons:"=?"},transclude:{expandedContent:"?listExpandedContent"},templateUrl:"views/listview/list-view.html",controller:["$window","$element","$timeout",function($window,$element,$timeout){"use strict";function setPagination(){angular.isUndefined(ctrl.pageConfig)?ctrl.pageConfig={pageNumber:1,pageSize:ctrl.items.length,numTotalItems:ctrl.items.length,showPaginationControls:!1}:(angular.isUndefined(ctrl.pageConfig.showPaginationControls)&&(ctrl.pageConfig.showPaginationControls=!0),angular.isNumber(ctrl.pageConfig.pageNumber)||(ctrl.pageConfig.pageNumber=1),angular.isNumber(ctrl.pageConfig.pageSize)||(ctrl.pageConfig.pageSize=10),angular.isNumber(ctrl.pageConfig.numTotalItems)||(ctrl.pageConfig.numTotalItems=ctrl.items.length),ctrl.pageConfig.showPaginationControls||(ctrl.pageConfig.pageSize=ctrl.pageConfig.numTotalItems)),prevPageConfig=angular.copy(ctrl.pageConfig)}var prevPageConfig,prevItems,ctrl=this,setDropMenuLocation=function(parentDiv){var dropButton=parentDiv.querySelector(".dropdown-toggle"),dropMenu=parentDiv.querySelector(".dropdown-menu"),parentRect=$element[0].querySelector(".list-view-pf.list-view-pf-view").getBoundingClientRect(),buttonRect=dropButton.getBoundingClientRect(),menuRect=dropMenu.getBoundingClientRect(),buttonTop=buttonRect.top-parentRect.top,buttonBottom=buttonTop+buttonRect.height,menuTop=buttonTop-menuRect.height,menuBottom=buttonBottom+menuRect.height;menuBottom<=parentRect.height||0>menuTop?ctrl.dropdownClass="dropdown":ctrl.dropdownClass="dropup",ctrl.kebabMenuReady=!0};ctrl.defaultConfig={selectItems:!1,multiSelect:!1,dblClick:!1,dragEnabled:!1,dragEnd:null,dragMoved:null,dragStart:null,selectionMatchProp:"uuid",selectedItems:[],checkDisabled:!1,useExpandingRows:!1,showSelectBox:!0,onSelect:null,onSelectionChange:null,onCheckBoxChange:null,onClick:null,onDblClick:null,itemsAvailable:!0},ctrl.dropdownClass="dropdown",ctrl.handleButtonAction=function(action,item){!ctrl.checkDisabled(item)&&action&&action.actionFn&&ctrl.enableButtonForItem(action,item)&&action.actionFn(action,item)},ctrl.handleMenuAction=function(action,item){!ctrl.checkDisabled(item)&&action&&action.actionFn&&action.isDisabled!==!0&&action.actionFn(action,item)},ctrl.enableButtonForItem=function(action,item){var enable=!0;return"function"==typeof ctrl.enableButtonForItemFn?ctrl.enableButtonForItemFn(action,item):enable},ctrl.updateActions=function(item){"function"==typeof ctrl.updateMenuActionForItemFn&&ctrl.menuActions.forEach(function(action){ctrl.updateMenuActionForItemFn(action,item)})},ctrl.getMenuClassForItem=function(item){var menuClass="";return angular.isFunction(ctrl.menuClassForItemFn)&&(menuClass=ctrl.menuClassForItemFn(item)),menuClass},ctrl.hideMenuForItem=function(item){var hideMenu=!1;return angular.isFunction(ctrl.hideMenuForItemFn)&&(hideMenu=ctrl.hideMenuForItemFn(item)),hideMenu},ctrl.toggleItemExpansion=function(item){item.isExpanded=!item.isExpanded},ctrl.setupActions=function(item,event){ctrl.checkDisabled(item)||(ctrl.updateActions(item),ctrl.kebabMenuReady=!1,$timeout(function(){var nextElement,parentDiv=void 0;for(nextElement=event.target;nextElement&&!parentDiv;)-1!==nextElement.className.indexOf("dropdown-kebab-pf")&&(parentDiv=nextElement,-1!==nextElement.className.indexOf("open")&&setDropMenuLocation(parentDiv)),nextElement=nextElement.parentElement}))},ctrl.itemClick=function(e,item){var alreadySelected,selectionChanged=!1,continueEvent=!0,enableRowExpansion=ctrl.config&&ctrl.config.useExpandingRows&&!ctrl.config.compoundExpansionOnly&&item&&!item.disableRowExpansion;return ctrl.checkDisabled(item)?continueEvent:(ctrl.config&&ctrl.config.selectItems&&item&&(ctrl.config.multiSelect&&!ctrl.config.dblClick?(alreadySelected=_.find(ctrl.config.selectedItems,function(itemObj){return itemObj===item}),alreadySelected?ctrl.config.selectedItems=_.without(ctrl.config.selectedItems,item):(ctrl.config.selectedItems.push(item),selectionChanged=!0)):ctrl.config.selectedItems[0]===item?(ctrl.config.dblClick||(ctrl.config.selectedItems=[],selectionChanged=!0),continueEvent=!1):(ctrl.config.selectedItems=[item],selectionChanged=!0),selectionChanged&&ctrl.config.onSelect&&ctrl.config.onSelect(item,e),selectionChanged&&ctrl.config.onSelectionChange&&ctrl.config.onSelectionChange(ctrl.config.selectedItems,e)),ctrl.config.onClick?ctrl.config.onClick(item,e)!==!1&&enableRowExpansion&&ctrl.toggleItemExpansion(item):enableRowExpansion&&ctrl.toggleItemExpansion(item),continueEvent)},ctrl.dblClick=function(e,item){return ctrl.checkDisabled(item)?continueEvent:void(ctrl.config.onDblClick&&ctrl.config.onDblClick(item,e))},ctrl.checkBoxChange=function(item){ctrl.config.onCheckBoxChange&&ctrl.config.onCheckBoxChange(item)},ctrl.isSelected=function(item){var matchProp=ctrl.config.selectionMatchProp,selected=!1;return ctrl.config.showSelectBox?selected=item.selected:ctrl.config.selectItems&&ctrl.config.selectedItems.length&&(selected=_.find(ctrl.config.selectedItems,function(itemObj){return itemObj[matchProp]===item[matchProp]})),selected},ctrl.checkDisabled=function(item){return ctrl.config.checkDisabled&&ctrl.config.checkDisabled(item)},ctrl.$onInit=function(){if(angular.isUndefined(ctrl.config)&&(ctrl.config={}),_.defaults(ctrl.config,ctrl.defaultConfig),ctrl.config.selectItems||(ctrl.config.selectedItems=[]),!ctrl.config.multiSelect&&ctrl.config.selectedItems&&ctrl.config.selectedItems.length>0&&(ctrl.config.selectedItems=[ctrl.config.selectedItems[0]]),ctrl.config.selectItems&&ctrl.config.showSelectBox)throw new Error("pfListView - Illegal use of pListView component! Cannot allow both select box and click selection in the same list view.");prevItems=angular.copy(ctrl.items),setPagination()},ctrl.$doCheck=function(){angular.equals(ctrl.pageConfig,prevPageConfig)||setPagination(),angular.equals(ctrl.items,prevItems)||(ctrl.items&&(ctrl.config.itemsAvailable=ctrl.items.length>0),angular.isDefined(ctrl.pageConfig)&&(ctrl.pageConfig.numTotalItems=ctrl.items.length),prevItems=angular.copy(ctrl.items))},ctrl.dragEnd=function(){angular.isFunction(ctrl.config.dragEnd)&&ctrl.config.dragEnd()},ctrl.dragMoved=function(){angular.isFunction(ctrl.config.dragMoved)&&ctrl.config.dragMoved()},ctrl.isDragOriginal=function(item){return item===ctrl.dragItem},ctrl.dragStart=function(item){ctrl.dragItem=item,angular.isFunction(ctrl.config.dragStart)&&ctrl.config.dragStart(item)}}]}),function(){"use strict";angular.module("patternfly.views").constant("pfViewUtils",{getDashboardView:function(title){return{id:"dashboardView",title:title||"Dashboard View",iconClass:"fa fa-dashboard"}},getCardView:function(title){return{id:"cardView",title:title||"Card View",iconClass:"fa fa-th"}},getListView:function(title){return{id:"listView",title:title||"List View",iconClass:"fa fa-th-list"}},getTableView:function(title){return{id:"tableView",title:title||"Table View",iconClass:"fa fa-table"}},getTopologyView:function(title){return{id:"topologyView",title:title||"Topology View",iconClass:"fa fa-sitemap"}}})}(),function(){"use strict";var findWizard=function(scope){var wizard;return scope&&(wizard=angular.isDefined(scope.wizard)?scope.wizard:findWizard(scope.$parent)),wizard},setupCallback=function(scope,button,fnName,callback){button.on("click",function(e){e.preventDefault(),scope.$apply(function(){scope.wizard[fnName](callback)})})};angular.module("patternfly.wizard").component("pfWizNext",{bindings:{callback:"=?"},controller:["$element","$scope",function($element,$scope){var ctrl=this;ctrl.$onInit=function(){$scope.wizard=findWizard($scope)},ctrl.$postLink=function(){setupCallback($scope,$element,"next",ctrl.callback)}}]}),angular.module("patternfly.wizard").component("pfWizPrevious",{bindings:{callback:"=?"},controller:["$element","$scope",function($element,$scope){var ctrl=this;ctrl.$onInit=function(){$scope.wizard=findWizard($scope)},ctrl.$postLink=function(){setupCallback($scope,$element,"previous",ctrl.callback)}}]}),angular.module("patternfly.wizard").component("pfWizFinish",{bindings:{callback:"=?"},controller:["$element","$scope",function($element,$scope){var ctrl=this;ctrl.$onInit=function(){$scope.wizard=findWizard($scope)},ctrl.$postLink=function(){setupCallback($scope,$element,"finish",ctrl.callback)}}]}),angular.module("patternfly.wizard").component("pfWizCancel",{bindings:{callback:"=?"},controller:["$element","$scope",function($element,$scope){var ctrl=this;ctrl.$onInit=function(){$scope.wizard=findWizard($scope)},ctrl.$postLink=function(){setupCallback($scope,$element,"cancel",ctrl.callback)}}]}),angular.module("patternfly.wizard").component("pfWizReset",{bindings:{callback:"=?"},controller:["$element","$scope",function($element,$scope){var ctrl=this;ctrl.$onInit=function(){$scope.wizard=findWizard($scope)},ctrl.$postLink=function(){setupCallback($scope,$element,"reset",ctrl.callback)}}]})}(),angular.module("patternfly.wizard").component("pfWizardReviewPage",{bindings:{shown:"<",wizardData:"<"},templateUrl:"wizard/wizard-review-page.html",controller:["$scope",function($scope){"use strict";var ctrl=this,findWizard=function(scope){var wizard;return scope&&(wizard=angular.isDefined(scope.wizard)?scope.wizard:findWizard(scope.$parent)),wizard};ctrl.$onInit=function(){ctrl.reviewSteps=[],ctrl.wizard=findWizard($scope.$parent)},ctrl.$onChanges=function(changesObj){changesObj.shown&&changesObj.shown.currentValue&&ctrl.updateReviewSteps()},ctrl.toggleShowReviewDetails=function(step){step.showReviewDetails===!0?step.showReviewDetails=!1:step.showReviewDetails=!0},ctrl.getSubStepNumber=function(step,substep){return step.getStepDisplayNumber(substep)},ctrl.getReviewSubSteps=function(reviewStep){return reviewStep.getReviewSteps()},ctrl.updateReviewSteps=function(){ctrl.reviewSteps=ctrl.wizard.getReviewSteps()}}]}),angular.module("patternfly.wizard").component("pfWizardStep",{transclude:!0,bindings:{stepTitle:"@",stepId:"@",stepPriority:"@",substeps:"=?",nextEnabled:"<?",prevEnabled:"<?",nextTooltip:"<?",prevTooltip:"<?",disabled:"@?wzDisabled",okToNavAway:"<?",allowClickNav:"<?",description:"@",wizardData:"=",onShow:"=?",focusSelectors:"<?",showReview:"@?",showReviewDetails:"@?",reviewTemplate:"@?"},templateUrl:"wizard/wizard-step.html",controller:["$timeout","$scope",function($timeout,$scope){"use strict";var firstRun,ctrl=this,stepIdx=function(step){var idx=0,res=-1;return angular.forEach(ctrl.getEnabledSteps(),function(currStep){currStep===step&&(res=idx),idx++}),res},unselectAll=function(){angular.forEach(ctrl.getEnabledSteps(),function(step){step.selected=!1}),ctrl.selectedStep=null},findWizard=function(scope){var wizard;return scope&&(wizard=angular.isDefined(scope.wizard)?scope.wizard:findWizard(scope.$parent)),wizard};ctrl.$onInit=function(){firstRun=!0,ctrl.steps=[],ctrl.context={},ctrl.title=ctrl.stepTitle,ctrl.wizard=findWizard($scope.$parent),ctrl.contentStyle=ctrl.wizard.contentStyle,$scope.wizardStep=this,ctrl.wizard.addStep(ctrl),ctrl.pageNumber=ctrl.wizard.getStepNumber(ctrl),angular.isUndefined(ctrl.nextEnabled)&&(ctrl.nextEnabled=!0),angular.isUndefined(ctrl.prevEnabled)&&(ctrl.prevEnabled=!0),angular.isUndefined(ctrl.showReview)&&(ctrl.showReview=!1),angular.isUndefined(ctrl.showReviewDetails)&&(ctrl.showReviewDetails=!1),angular.isUndefined(ctrl.stepPriority)?ctrl.stepPriority=999:ctrl.stepPriority=parseInt(ctrl.stepPriority),angular.isUndefined(ctrl.okToNavAway)&&(ctrl.okToNavAway=!0),angular.isUndefined(ctrl.allowClickNav)&&(ctrl.allowClickNav=!0),ctrl.substeps&&!ctrl.onShow&&(ctrl.onShow=function(){$timeout(function(){ctrl.selectedStep||ctrl.goTo(ctrl.getEnabledSteps()[0])},10)})},ctrl.$onChanges=function(changesObj){changesObj.nextTooltip&&_.get(ctrl.wizard,"selectedStep")===ctrl&&(ctrl.wizard.nextTooltip=changesObj.nextTooltip.currentValue),changesObj.prevTooltip&&_.get(ctrl.wizard,"selectedStep")===ctrl&&(ctrl.wizard.prevTooltip=changesObj.prevTooltip.currentValue)},ctrl.getEnabledSteps=function(){return ctrl.steps.filter(function(step){return"true"!==step.disabled})},ctrl.getReviewSteps=function(){var reviewSteps=ctrl.getEnabledSteps().filter(function(step){return!angular.isUndefined(step.reviewTemplate)});return reviewSteps},ctrl.resetNav=function(){ctrl.goTo(ctrl.getEnabledSteps()[0])},ctrl.currentStepNumber=function(){return stepIdx(ctrl.selectedStep)+1},ctrl.getStepNumber=function(step){return stepIdx(step)+1},ctrl.isNextEnabled=function(){var enabled=angular.isUndefined(ctrl.nextEnabled)||ctrl.nextEnabled;return ctrl.substeps&&ctrl.selectedStep&&(enabled=enabled&&ctrl.selectedStep.isNextEnabled()),enabled},ctrl.isPrevEnabled=function(){var enabled=angular.isUndefined(ctrl.prevEnabled)||ctrl.prevEnabled;return ctrl.substeps&&ctrl.selectedStep&&(enabled=enabled&&ctrl.selectedStep.isPrevEnabled()),enabled},ctrl.getStepDisplayNumber=function(step){return ctrl.pageNumber+String.fromCharCode(65+stepIdx(step))+"."},ctrl.prevStepsComplete=function(nextStep){var nextIdx=stepIdx(nextStep),complete=!0;return angular.forEach(ctrl.getEnabledSteps(),function(step,stepIndex){nextIdx>stepIndex&&(complete=complete&&step.nextEnabled)}),complete},ctrl.goTo=function(step){var focusElement=null;!ctrl.wizard.isWizardDone()&&step.okToNavAway&&step!==ctrl.selectedStep&&(firstRun||ctrl.getStepNumber(step)<ctrl.currentStepNumber()&&ctrl.selectedStep.prevEnabled||ctrl.prevStepsComplete(step))&&(unselectAll(),ctrl.selectedStep=step,step&&(step.selected=!0,ctrl.wizard.setPageSelected(step),angular.isFunction(ctrl.selectedStep.onShow)&&ctrl.selectedStep.onShow(),$timeout(function(){step.focusSelectors&&_.find(step.focusSelectors,function(selector){return focusElement=document.querySelector(selector)}),!focusElement&&step.nextEnabled&&(focusElement=document.querySelector(".wizard-pf-next")),focusElement||(focusElement=document.querySelector(".wizard-pf-cancel")),focusElement&&focusElement.focus()},300),ctrl.currentStep=step.stepTitle,firstRun=!1),ctrl.wizard.updateSubStepNumber(stepIdx(ctrl.selectedStep)))},ctrl.stepClick=function(step){step.allowClickNav&&ctrl.goTo(step)},ctrl.addStep=function(step){var insertBefore=_.find(ctrl.steps,function(nextStep){return nextStep.stepPriority>step.stepPriority});insertBefore?ctrl.steps.splice(ctrl.steps.indexOf(insertBefore),0,step):ctrl.steps.push(step)},ctrl.currentStepTitle=function(){return ctrl.selectedStep.stepTitle},ctrl.currentStepDescription=function(){return ctrl.selectedStep.description},ctrl.currentStep=function(){return ctrl.selectedStep},ctrl.totalStepCount=function(){return ctrl.getEnabledSteps().length},ctrl.next=function(callback){var enabledSteps=ctrl.getEnabledSteps(),index=stepIdx(ctrl.selectedStep);return angular.isFunction(callback)?callback(ctrl.selectedStep)?index===enabledSteps.length-1?!1:(ctrl.goTo(enabledSteps[index+1]),!0):!0:(ctrl.selectedStep.completed=!0,index===enabledSteps.length-1?!1:(ctrl.goTo(enabledSteps[index+1]),!0))},ctrl.previous=function(callback){var index=stepIdx(ctrl.selectedStep),goPrev=!1;return(!angular.isFunction(callback)||callback(ctrl.selectedStep))&&0!==index&&(ctrl.goTo(ctrl.getEnabledSteps()[index-1]),goPrev=!0),goPrev}}]}),angular.module("patternfly.wizard").component("pfWizardSubstep",{transclude:!0,bindings:{stepTitle:"@",stepId:"@",stepPriority:"@",nextEnabled:"<?",prevEnabled:"<?",okToNavAway:"<?",allowClickNav:"<?",disabled:"@?wzDisabled",description:"@",wizardData:"=",onShow:"=?",focusSelectors:"<?",showReviewDetails:"@?",reviewTemplate:"@?"},templateUrl:"wizard/wizard-substep.html",controller:["$scope",function($scope){"use strict";var ctrl=this;ctrl.$onInit=function(){var findWizardStep=function(scope){var wizardStep;return scope&&(wizardStep=angular.isDefined(scope.wizardStep)?scope.wizardStep:findWizardStep(scope.$parent)),wizardStep};ctrl.step=findWizardStep($scope),angular.isUndefined(ctrl.nextEnabled)&&(ctrl.nextEnabled=!0),angular.isUndefined(ctrl.prevEnabled)&&(ctrl.prevEnabled=!0),angular.isUndefined(ctrl.showReviewDetails)&&(ctrl.showReviewDetails=!1),angular.isUndefined(ctrl.stepPriority)?ctrl.stepPriority=999:ctrl.stepPriority=parseInt(ctrl.stepPriority),angular.isUndefined(ctrl.okToNavAway)&&(ctrl.okToNavAway=!0),angular.isUndefined(ctrl.allowClickNav)&&(ctrl.allowClickNav=!0),ctrl.step.okToNavAway=ctrl.okToNavAway,ctrl.step.allowClickNav=ctrl.allowClickNav,ctrl.title=ctrl.stepTitle,ctrl.step.addStep(ctrl)},ctrl.$onChanges=function(changesObj){ctrl.step&&(changesObj.okToNavAway&&(ctrl.step.okToNavAway=changesObj.okToNavAway.currentValue),changesObj.allowClickNav&&(ctrl.step.allowClickNav=changesObj.allowClickNav.currentValue))},ctrl.isNextEnabled=function(){return angular.isUndefined(ctrl.nextEnabled)||ctrl.nextEnabled;
},ctrl.isPrevEnabled=function(){return angular.isUndefined(ctrl.prevEnabled)||ctrl.prevEnabled}}]}),angular.module("patternfly.wizard").component("pfWizard",{transclude:!0,bindings:{title:"@",wizardTitle:"@",hideIndicators:"<?",activeStepTitleOnly:"<?",hideSidebar:"@",hideHeader:"@",hideBackButton:"@",sidebarClass:"@",stepClass:"@",contentHeight:"<?",currentStep:"<?",cancelTitle:"<?",backTitle:"<?",nextTitle:"<?",backCallback:"<?",nextCallback:"<?",onFinish:"&",onCancel:"&",wizardReady:"<?",wizardDone:"<?",loadingWizardTitle:"<?",loadingSecondaryInformation:"<?",embedInPage:"<?",onStepChanged:"&?"},templateUrl:"wizard/wizard.html",controller:["$timeout","$scope",function($timeout,$scope){"use strict";var firstRun,ctrl=this,stepIdx=function(step){var idx=0,res=-1;return angular.forEach(ctrl.getEnabledSteps(),function(currStep){currStep===step&&(res=idx),idx++}),res},unselectAll=function(){angular.forEach(ctrl.getEnabledSteps(),function(step){step.selected=!1}),ctrl.selectedStep=null},stepByTitle=function(titleToFind){var foundStep=null;return angular.forEach(ctrl.getEnabledSteps(),function(step){step.title===titleToFind&&(foundStep=step)}),foundStep};ctrl.$onInit=function(){firstRun=!0,ctrl.steps=[],ctrl.context={},ctrl.hideHeader="true"===ctrl.hideHeader,ctrl.hideSidebar="true"===ctrl.hideSidebar,ctrl.hideBackButton="true"===ctrl.hideBackButton,ctrl.activeStepTitleOnly=ctrl.activeStepTitleOnly===!0,ctrl.wizardTitle=ctrl.wizardTitle||ctrl.title,angular.isDefined(ctrl.stepClass)?angular.isUndefined(ctrl.sidebarClass)&&(ctrl.sidebarClass=ctrl.stepClass):(angular.isUndefined(ctrl.contentHeight)&&(ctrl.contentHeight="300px"),ctrl.contentStyle={height:ctrl.contentHeight,"max-height":ctrl.contentHeight,"overflow-y":"auto"}),angular.isUndefined(ctrl.wizardReady)&&(ctrl.wizardReady=!0),ctrl.cancelTitle||(ctrl.cancelTitle="Cancel"),ctrl.backTitle||(ctrl.backTitle="< Back"),ctrl.nextTitle||(ctrl.nextTitle="Next >")},ctrl.$onChanges=function(changesObj){var step;if(changesObj.hideHeader&&(ctrl.hideHeader="true"===ctrl.hideHeader),changesObj.hideSidebar&&(ctrl.hideSidebar="true"===ctrl.hideSidebar),changesObj.hideBackButton&&(ctrl.hideBackButton="true"===ctrl.hideBackButton),changesObj.wizardReady&&changesObj.wizardReady.currentValue&&ctrl.goTo(ctrl.getEnabledSteps()[0]),changesObj.currentStep){if(step=changesObj.currentStep.currentValue,!step)return;ctrl.selectedStep&&ctrl.selectedStep.title!==step&&ctrl.goTo(stepByTitle(step))}},ctrl.getEnabledSteps=function(){return ctrl.steps.filter(function(step){return"true"!==step.disabled})},ctrl.getReviewSteps=function(){return ctrl.steps.filter(function(step){return!step.disabled&&(!angular.isUndefined(step.reviewTemplate)||step.getReviewSteps().length>0)})},ctrl.currentStepNumber=function(){return stepIdx(ctrl.selectedStep)+1},ctrl.getStepNumber=function(step){return stepIdx(step)+1},ctrl.goTo=function(step,resetStepNav){var focusElement=null;ctrl.wizardDone||ctrl.selectedStep&&!ctrl.selectedStep.okToNavAway||step===ctrl.selectedStep||((firstRun||ctrl.getStepNumber(step)<ctrl.currentStepNumber()&&ctrl.selectedStep.isPrevEnabled()||ctrl.selectedStep.isNextEnabled())&&(unselectAll(),!firstRun&&resetStepNav&&step.substeps&&step.resetNav(),ctrl.selectedStep=step,step.selected=!0,$timeout(function(){angular.isFunction(step.onShow)&&step.onShow(),$timeout(function(){step.focusSelectors&&_.find(step.focusSelectors,function(selector){return focusElement=document.querySelector(selector)}),!focusElement&&step.nextEnabled&&(focusElement=document.querySelector(".wizard-pf-next")),focusElement||(focusElement=document.querySelector(".wizard-pf-cancel")),focusElement&&focusElement.focus()},300)},100),ctrl.currentStep=step.title,ctrl.nextTooltip=step.nextTooltip,ctrl.prevTooltip=step.prevTooltip,step.substeps||ctrl.setPageSelected(step),firstRun=!1),ctrl.selectedStep.substeps?ctrl.firstStep=0===stepIdx(ctrl.selectedStep)&&1===ctrl.selectedStep.currentStepNumber():ctrl.firstStep=0===stepIdx(ctrl.selectedStep))},ctrl.allowStepIndicatorClick=function(step){return step.allowClickNav&&!ctrl.wizardDone&&ctrl.selectedStep&&ctrl.selectedStep.okToNavAway&&(ctrl.selectedStep.nextEnabled||step.stepPriority<ctrl.selectedStep.stepPriority)&&(ctrl.selectedStep.prevEnabled||step.stepPriority>ctrl.selectedStep.stepPriority)},ctrl.stepClick=function(step){step.allowClickNav&&ctrl.selectedStep&&!ctrl.wizardDone&&ctrl.selectedStep.okToNavAway&&(ctrl.selectedStep.nextEnabled||step.stepPriority<ctrl.selectedStep.stepPriority)&&(ctrl.selectedStep.prevEnabled||step.stepPriority>ctrl.selectedStep.stepPriority)&&ctrl.goTo(step,!0)},ctrl.setPageSelected=function(step){angular.isFunction(ctrl.onStepChanged)&&ctrl.onStepChanged({step:step,index:stepIdx(step)})},ctrl.addStep=function(step){var insertBefore=_.find(ctrl.steps,function(nextStep){return nextStep.stepPriority>step.stepPriority});insertBefore?ctrl.steps.splice(ctrl.steps.indexOf(insertBefore),0,step):ctrl.steps.push(step),ctrl.wizardReady&&ctrl.getEnabledSteps().length>0&&step===ctrl.getEnabledSteps()[0]&&ctrl.goTo(ctrl.getEnabledSteps()[0])},ctrl.isWizardDone=function(){return ctrl.wizardDone},ctrl.updateSubStepNumber=function(value){ctrl.firstStep=0===stepIdx(ctrl.selectedStep)&&0===value},ctrl.currentStepTitle=function(){return ctrl.selectedStep.title},ctrl.currentStepDescription=function(){return ctrl.selectedStep.description},ctrl.currentStep=function(){return ctrl.selectedStep},ctrl.totalStepCount=function(){return ctrl.getEnabledSteps().length},ctrl.goToStep=function(step,resetStepNav){var stepTo,enabledSteps=ctrl.getEnabledSteps();stepTo=angular.isNumber(step)?enabledSteps[step]:stepByTitle(step),ctrl.goTo(stepTo,resetStepNav)},ctrl.next=function(callback){var enabledSteps=ctrl.getEnabledSteps(),index=stepIdx(ctrl.selectedStep);if(callback=callback||ctrl.nextCallback,!ctrl.selectedStep.substeps||!ctrl.selectedStep.next(callback)){if(angular.isFunction(callback)){if(!callback(ctrl.selectedStep))return;index<enabledSteps.length-1?enabledSteps[index+1].substeps&&enabledSteps[index+1].resetNav():ctrl.finish()}ctrl.selectedStep.completed=!0,index===enabledSteps.length-1?ctrl.finish():ctrl.goTo(enabledSteps[index+1])}},ctrl.previous=function(callback){var index=stepIdx(ctrl.selectedStep);if(callback=callback||ctrl.backCallback,(!ctrl.selectedStep.substeps||!ctrl.selectedStep.previous(callback))&&(!angular.isFunction(callback)||callback(ctrl.selectedStep))){if(0===index)throw new Error("Can't go back. It's already in step 0");ctrl.goTo(ctrl.getEnabledSteps()[index-1])}},ctrl.finish=function(){ctrl.onFinish&&ctrl.onFinish()!==!1&&ctrl.reset()},ctrl.cancel=function(){ctrl.onCancel&&ctrl.onCancel()!==!1&&ctrl.reset()},ctrl.reset=function(){angular.forEach(ctrl.getEnabledSteps(),function(step){step.completed=!1}),ctrl.goToStep(0)},$scope.wizard=this}]}),angular.module("patternfly.canvas").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("canvas-view/canvas-editor/canvas-editor.html",'<div class=canvas-editor-container><div class=canvas-editor-toolbar><button id=toggleToolbox class="btn btn-primary" ng-class="{\'disabled\': $ctrl.chartViewModel.inConnectingMode || $ctrl.readOnly}" type=button ng-click=$ctrl.toggleToolbox() tooltip-placement=bottom-left uib-tooltip="{{\'Add Item To Canvas\'}}">Add Item <span class=fa ng-class="{\'fa-angle-double-up\': $ctrl.toolboxVisible, \'fa-angle-double-down\': !$ctrl.toolboxVisible}"></span></button><!-- user defined more actions --> <span ng-transclude></span> <span class=right-aligned-controls><input ng-class="{\'disabled\': $ctrl.chartViewModel.inConnectingMode}" ng-model=$ctrl.hideConnectors ng-change=$ctrl.toggleshowHideConnectors() type=checkbox ng-checked="$ctrl.hideConnectors"> <span class=show-hide-connectors-label>Hide Connectors</span> <a id=zoomOut ng-click=$ctrl.zoomOut() ng-class="{\'disabled\': $ctrl.minZoom()}"><span class="pficon fa fa-minus" tooltip-append-to-body=true tooltip-placement=bottom uib-tooltip="{{\'Zoom Out\'}}"></span></a> <a id=zoomIn ng-click=$ctrl.zoomIn() ng-class="{\'disabled\': $ctrl.maxZoom()}"><span class="pficon fa fa-plus" tooltip-append-to-body=true tooltip-placement=bottom-right uib-tooltip="{{\'Zoom In\'}}"></span></a></span></div><div class=canvas-editor-toolbox-container><div class=canvas-editor-toolbox id=toolbox ng-if=$ctrl.toolboxVisible><a ng-click="$ctrl.toolboxVisible = false" class=close-toolbox><span class="pficon pficon-close"></span></a><div class=toolbox-filter><input ng-model=$ctrl.searchText id=filterFld class=search-text placeholder="{{\'Filter by name\'}}"> <a ng-click="$ctrl.searchText = \'\'"><span class="pficon pficon-close clear-search-text"></span></a></div><uib-tabset><uib-tab ng-repeat="tab in $ctrl.toolboxTabs" heading="" active=tab.active><uib-tab-heading ng-click=$ctrl.tabClicked()><div class=tab-pre-title>{{tab.preTitle}}</div><div class=tab-title ng-class="{\'tab-single-line\':tab.preTitle == null}">{{tab.title}}</div></uib-tab-heading><uib-tabset class=subtabs ng-if=tab.subtabs><uib-tab ng-repeat="subtab in tab.subtabs" heading={{subtab.title}} active=subtab.active ng-click=$ctrl.tabClicked()><uib-tabset class=subtabs ng-if=subtab.subtabs><uib-tab ng-repeat="subsubtab in subtab.subtabs" heading={{subsubtab.title}} active=subsubtab.active ng-click=$ctrl.tabClicked()><toolbox-items items=subsubtab.items start-drag-callback=$ctrl.startCallback click-callback=$ctrl.addNodeByClick search-text="$ctrl.searchText"></uib-tab></uib-tabset><!-- SubTabs without Sub-Sub Tabs --><toolbox-items ng-if=!subtab.subtabs items=subtab.items start-drag-callback=$ctrl.startCallback click-callback=$ctrl.addNodeByClick search-text="$ctrl.searchText"></uib-tab></uib-tabset><!-- Primary Tabs without SubTabs --><toolbox-items ng-if=!tab.subtabs items=tab.items start-drag-callback=$ctrl.startCallback click-callback=$ctrl.addNodeByClick search-text="$ctrl.searchText"></uib-tab></uib-tabset></div><div class=canvas-container data-drop=true data-jqyoui-options jqyoui-droppable="{onDrop:\'$ctrl.dropCallback\'}"><pf-canvas chart-data-model=$ctrl.chartDataModel chart-view-model=$ctrl.chartViewModel read-only=$ctrl.readOnly hide-connectors=$ctrl.hideConnectors></pf-canvas></div></div></div>'),$templateCache.put("canvas-view/canvas-editor/toolbox-items.html",'<ul class=toolbox-items-list><li class=toolbox-item ng-repeat="item in $ctrl.items | filter:$ctrl.searchText" data-drag={{!item.disableInToolbox}} jqyoui-draggable="{onStart:\'$ctrl.startItemDrag(item)\'}" ng-class="{\'not-draggable\': item.disableInToolbox}" data-jqyoui-options="{revert: \'invalid\', helper: \'clone\'}" ng-click=$ctrl.itemClicked(item) uib-tooltip="{{(item.disableInToolbox ? \'Items cannot be added to the canvas more than once.\' : \'\')}}"><img ng-if=item.image src={{item.image}} alt="{{item.name}}"> <i ng-if="item.icon && !item.image" class="draggable-item-icon {{item.icon}}"></i> <span>{{ item.name }}</span></li></ul>'),$templateCache.put("canvas-view/canvas/canvas.html",'<svg class="canvas draggable-container" xmlns=http://www.w3.org/2000/svg ng-mousedown=$ctrl.mouseDown($event) ng-mousemove=mouseMove($event) ng-class="{\'read-only\': $ctrl.readOnly, \'canvas-in-connection-mode\': $ctrl.chart.inConnectingMode}" ng-style="{\'height\': $ctrl.chart.zoom.getChartHeight() + \'px\', \'width\': $ctrl.chart.zoom.getChartWidth() + \'px\', \'background-size\': $ctrl.chart.zoom.getBackgroundSize() + \'px \'+  chart.zoom.getBackgroundSize() + \'px\'}" mouse-capture><!-- Zoom --><g ng-attr-transform=scale({{$ctrl.zoomLevel()}})><!-- Connection Mode Notification --><g ng-if=$ctrl.chart.inConnectingMode><rect class=connecting-mode-rec ry=1 rx=1 x=0 y=0 width=640 height=32></rect><text class=connecting-mode-label x=12 y=22 ng-if=$ctrl.availableConnections()>Select a second item to complete the connection or click on the canvas to cancel</text><text class=connecting-mode-label-warning x=12 y=22 ng-if=!$ctrl.availableConnections()>No available connections! Click on the canvas to cancel</text></g><!-- Main Node Loop --><g ng-repeat="node in $ctrl.chart.nodes" ng-mousedown="$ctrl.nodeMouseDown($event, node)" ng-mouseover="$ctrl.nodeMouseOver($event, node)" ng-mouseleave="$ctrl.nodeMouseLeave($event, node)" ng-attr-transform="translate({{node.x()}}, {{node.y()}})"><!-- Node --><rect ng-class="{\'invalid-node-rect\': node.invalid(), \'selected-node-rect\': node.selected(), \'mouseover-node-rect\': node == $ctrl.mouseOverNode, \'node-rect\': node != $ctrl.mouseOverNode}" ry=0 rx=0 x=0 y=0 ng-attr-width={{node.width()}} ng-attr-height={{node.height()}} fill={{node.backgroundColor()}} fill-opacity=1.0></rect><!-- Node Title: no-wrap --><text ng-if=!$ctrl.foreignObjectSupported() class=node-header ng-class="{\'invalid-node-header\': node.invalid()}" ng-attr-x={{node.width()/2}} ng-attr-y="{{node.height() - 24}}" text-anchor=middle alignment-baseline=middle>{{node.name()}}</text><!-- Node Title: text wrap --><foreignobject ng-if=$ctrl.foreignObjectSupported() x=0 ng-attr-y="{{node.height() - 42}}" ng-attr-width={{node.width()}} ng-attr-height="{{node.height() - 42}}"><body><div class=node-header ng-attr-width={{node.width()}} ng-attr-height="{{node.height() - 42}}"><p ng-class="{\'invalid-node-header\': node.invalid()}" ng-style="{width: node.width()}">{{node.name()}}</p></div></body></foreignobject><!-- Node Image --><image ng-if=node.image() class=node-center-img ng-class="{\'invalid-node-img\': node.invalid()}" ng-href="{{node.image() | trustAsResourceUrl}}" xlink:href="" ng-attr-x="{{(node.width()/2) - 40}}" ng-attr-y={{20}} height=80px width=80px></image><!-- Node Icon: icon class --><foreignobject ng-if="node.icon() && !node.image() && $ctrl.foreignObjectSupported()" ng-attr-x="{{(node.width()/2) - 44}}" ng-attr-y="{{(node.height()/2) - 54}}" ng-attr-height={{node.height()}}px ng-attr-width={{node.width()}}px class=node-center-img-icon ng-class="{\'invalid-node-header\': node.invalid()}"><body><i class={{node.icon()}} ng-style="{\'font-size\': node.fontSize() ? node.fontSize() : \'76px\'}"></i></body></foreignobject><!-- Node Icon: fontContent --><text ng-if="node.fontFamily() && !node.image()" class=node-center-icon ng-class="{\'invalid-node-header\': node.invalid()}" font-family={{node.fontFamily()}} ng-attr-x="{{(node.width()/2) - 34 + ((node.bundle()) ? 4 : 0) }}" ng-attr-y={{90}}>{{node.fontContent()}}</text><!-- Sm. Top Left Bundle Icon --><text ng-if=node.bundle() class=bundle-icon x=6 y=22 font-family=PatternFlyIcons-webfont font-size=20>{{\'\\ue918\'}}</text><!-- Bottom Node Toolbar --><g id=nodeToolBar ng-if="node == $ctrl.mouseOverNode && !$ctrl.chart.inConnectingMode"><g class=svg-triangle><polyline points="4,152 14,140 24,152"></polyline></g><foreignobject ng-attr-x={{node.x}} ng-attr-y={{node.height()+1}} ng-mousedown=$event.stopPropagation() height=100% width=100%><body><node-toolbar node=node node-actions=$ctrl.chart.nodeActions node-click-handler=$ctrl.nodeClickHandler node-close-handler=$ctrl.nodeCloseHandler></node-toolbar></body></foreignobject></g><!-- Connected Input Connectors --><g ng-if=!$ctrl.hideConnectors ng-repeat="connector in node.inputConnectors | filter: $ctrl.isConnectorConnected" ng-mousedown="$ctrl.connectorMouseDown($event, node, connector, $index, true)" ng-mouseover="$ctrl.connectorMouseOver($event, node, connector, $index, true)" ng-mouseleave="$ctrl.connectorMouseLeave($event, node, connector, $index, true)" class="connector input-connector"><circle ng-if="!$ctrl.chart.inConnectingMode || $ctrl.isConnectedTo(connector, connectingModeSourceNode)" ng-class="{\'mouseover-connector-circle\': connector == $ctrl.mouseOverConnector,\n                   \'connector-circle\': connector != $ctrl.mouseOverConnector}" ng-attr-r={{$ctrl.connectorSize}} ng-attr-cx={{connector.x()}} ng-attr-cy={{connector.y()}}></circle></g><!-- Unconnected Input Connectors --><g ng-if=$ctrl.chart.inConnectingMode ng-repeat="connector in node.inputConnectors | filter: $ctrl.isConnectorUnconnectedAndValid" ng-mousedown="$ctrl.connectorMouseDown($event, node, connector, $index, true)" ng-mouseover="$ctrl.connectorMouseOver($event, node, connector, $index, true)" ng-mouseleave="$ctrl.connectorMouseLeave($event, node, connector, $index, true)" class="connector input-connector"><text ng-if=connector.fontFamily() class=connector-icons font-family={{connector.fontFamily()}} ng-attr-x="{{connector.x() - 28}}" ng-attr-y="{{connector.y() + 7}}">{{connector.fontContent()}}</text><circle ng-class="{\'unconnected-circle\': connector != $ctrl.mouseOverConnector,\n                         \'mouseover-unconnected-circle\': connector == $ctrl.mouseOverConnector}" ng-attr-r={{$ctrl.connectorSize}} ng-attr-cx={{connector.x()}} ng-attr-cy={{connector.y()}}></circle><g ng-if="connector == $ctrl.mouseOverConnector"><rect class=connector-tooltip ry=1 rx=1 ng-attr-x="{{connector.x() - 4}}" ng-attr-y="{{connector.y() + 12}}" ng-attr-width={{80}} height=20></rect><text class=connector-tooltip-text ng-attr-x="{{connector.x() + 2}}" ng-attr-y="{{connector.y() + 26}}" text-anchor=start alignment-baseline=top>{{connector.name()}}</text></g></g><!-- Output Connector --><g ng-if=!$ctrl.hideConnectors ng-repeat="connector in node.outputConnectors" ng-mousedown="$ctrl.connectorMouseDown($event, node, connector, $index, false)" ng-mouseover="$ctrl.connectorMouseOver($event, node, connector, $index, false)" ng-mouseleave="$ctrl.connectorMouseLeave($event, node, connector, $index, false)" class="connector output-connector"><circle ng-if="!$ctrl.chart.inConnectingMode || ($ctrl.connectingModeSourceNode === connector.parentNode())" ng-class="{\'connector-circle\': connector != $ctrl.mouseOverConnector,\n                   \'mouseover-connector-circle\': connector == $ctrl.mouseOverConnector}" ng-attr-r={{$ctrl.connectorSize}} ng-attr-r={{$ctrl.connectorSize}} ng-attr-cx={{connector.x()}} ng-attr-cy={{connector.y()}}></circle></g></g><!--  End Nodes Loop --><!-- Connections --><g ng-if=!$ctrl.hideConnectors ng-repeat="connection in $ctrl.chart.connections" class=connection ng-mousedown="$ctrl.connectionMouseDown($event, connection)" ng-mouseover="$ctrl.connectionMouseOver($event, connection)" ng-mouseleave="$ctrl.connectionMouseLeave($event, connection)"><g ng-if="!$ctrl.chart.inConnectingMode || connectingModeSourceNode === connection.source.parentNode()"><path ng-class="{\'selected-connection-line\': connection.selected(),\n                     \'mouseover-connection-line\': connection == $ctrl.mouseOverConnection,\n                     \'connection-line\': connection != $ctrl.mouseOverConnection}" ng-attr-d="M {{connection.sourceCoordX()}}, {{connection.sourceCoordY()}}\n                     C {{connection.sourceTangentX()}}, {{connection.sourceTangentY()}}\n                       {{connection.destTangentX()}}, {{connection.destTangentY()}}\n                       {{connection.destCoordX()}}, {{connection.destCoordY()}}"></path><text ng-if="connection == $ctrl.mouseOverConnection" ng-class="{\'selected-connection-name\': connection.selected(),\n                     \'mouseover-connection-name\': connection == $ctrl.mouseOverConnection && !connection.selected(),\n                     \'connection-name\': connection != $ctrl.mouseOverConnection && !connection.selected()}" ng-attr-x={{connection.middleX()}} ng-attr-y={{connection.middleY()}} text-anchor=middle alignment-baseline=middle>{{connection.name()}}</text><circle ng-class="{\'selected-connection-endpoint\': connection.selected(),\n                       \'mouseover-connection-endpoint\': connection == $ctrl.mouseOverConnection && !connection.selected(),\n                       \'connection-endpoint\': connection != $ctrl.mouseOverConnection && !connection.selected()}" r=5 ng-attr-cx={{connection.sourceCoordX()}} ng-attr-cy={{connection.sourceCoordY()}}></circle><circle ng-class="{\'selected-connection-endpoint\': connection.selected(),\n                       \'mouseover-connection-endpoint\': connection == $ctrl.mouseOverConnection && !connection.selected(),\n                       \'connection-endpoint\': connection != $ctrl.mouseOverConnection && !connection.selected()}" r=5 ng-attr-cx={{connection.destCoordX()}} ng-attr-cy={{connection.destCoordY()}}></circle></g></g><rect ng-if=$ctrl.dragSelecting class=drag-selection-rect ng-attr-x={{$ctrl.dragSelectionRect.x}} ng-attr-y={{$ctrl.dragSelectionRect.y}} ng-attr-width={{$ctrl.dragSelectionRect.width}} ng-attr-height={{$ctrl.dragSelectionRect.height}}></rect></g></svg>'),$templateCache.put("canvas-view/canvas/node-toolbar.html",'<div class=node-toolbar ng-style="{width: $ctrl.node.width()}"><span ng-repeat="nodeAction in $ctrl.nodeActions" class="{{nodeAction.iconClass()}} node-toolbar-icons" ng-click=$ctrl.actionIconClicked(nodeAction.action())></span></div>')}]),angular.module("patternfly.card").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("card/aggregate-status/aggregate-status-card.html",'<div ng-if=!$ctrl.isMiniLayout class="card-pf card-pf-aggregate-status" ng-class="{\'card-pf-accented\': $ctrl.shouldShowTopBorder, \'card-pf-aggregate-status-alt\': $ctrl.isAltLayout}" ng-style="$ctrl.showSpinner ? $ctrl.spinnerHeight : {}"><h2 class=card-pf-title><a href={{$ctrl.status.href}} ng-if=$ctrl.status.href><image ng-if=$ctrl.status.iconImage ng-src={{$ctrl.status.iconImage}} alt="" class=card-pf-icon-image></image><span class={{$ctrl.status.iconClass}}></span> <span class=card-pf-aggregate-status-count>{{$ctrl.status.count}}</span> <span class=card-pf-aggregate-status-title>{{$ctrl.status.title}}</span></a> <span ng-if=!$ctrl.status.href><image ng-if=$ctrl.status.iconImage ng-src={{$ctrl.status.iconImage}} alt="" class=card-pf-icon-image></image><span class={{$ctrl.status.iconClass}}></span> <span class=card-pf-aggregate-status-count>{{$ctrl.status.count}}</span> <span class=card-pf-aggregate-status-title>{{$ctrl.status.title}}</span></span></h2><div class=card-pf-body ng-class="{\'show-spinner\': $ctrl.showSpinner}"><div ng-if=$ctrl.showSpinner class=spinner-container><div class=loading-indicator><span class="spinner spinner-lg" aria-hidden=true></span> <span ng-if=$ctrl.spinnerText class=loading-text>{{$ctrl.spinnerText}}</span><label ng-if=!$ctrl.spinnerText class=sr-only>Loading</label></div></div><p class=card-pf-aggregate-status-notifications ng-class="{\'hide-for-spinner\': $ctrl.showSpinner}"><span class=card-pf-aggregate-status-notification ng-repeat="notification in $ctrl.status.notifications"><a href={{notification.href}} ng-if=notification.href><image ng-if=notification.iconImage ng-src={{notification.iconImage}} alt="" class=card-pf-icon-image></image><span class={{notification.iconClass}}></span>{{ notification.count }}</a> <span ng-if=!notification.href><image ng-if=notification.iconImage ng-src={{notification.iconImage}} alt="" class=card-pf-icon-image></image><span class={{notification.iconClass}}></span>{{ notification.count }}</span></span></p></div></div><div ng-if=$ctrl.isMiniLayout class="card-pf card-pf-aggregate-status card-pf-aggregate-status-mini" ng-class="{\'card-pf-accented\': $ctrl.shouldShowTopBorder}" ng-style="$ctrl.showSpinner ? $ctrl.spinnerHeight : {}"><h2 class=card-pf-title><a ng-if=$ctrl.status.href href={{$ctrl.status.href}}><image ng-if=$ctrl.status.iconImage ng-src={{$ctrl.status.iconImage}} alt="" class=card-pf-icon-image></image><span ng-if=$ctrl.status.iconClass class={{$ctrl.status.iconClass}}></span> <span class=card-pf-aggregate-status-count>{{$ctrl.status.count}}</span> {{$ctrl.status.title}}</a> <span ng-if=!$ctrl.status.href><span class=card-pf-aggregate-status-count>{{$ctrl.status.count}}</span> {{$ctrl.status.title}}</span></h2><div class=card-pf-body ng-class="{\'show-spinner\': $ctrl.showSpinner}"><div ng-if=$ctrl.showSpinner class=spinner-container><div class=loading-indicator><span class="spinner spinner-lg" aria-hidden=true></span> <span ng-if=$ctrl.spinnerText class=loading-text>{{$ctrl.spinnerText}}</span><label ng-if=!$ctrl.spinnerText class=sr-only>Loading</label></div></div><p ng-if="$ctrl.status.notification.iconImage || $ctrl.status.notification.iconClass || $ctrl.status.notification.count" class=card-pf-aggregate-status-notifications><span class=card-pf-aggregate-status-notification><a ng-if=$ctrl.status.notification.href href={{$ctrl.status.notification.href}}><image ng-if=$ctrl.status.notification.iconImage ng-src={{$ctrl.status.notification.iconImage}} alt="" class=card-pf-icon-image></image><span ng-if=$ctrl.status.notification.iconClass class={{$ctrl.status.notification.iconClass}}></span><span ng-if=$ctrl.status.notification.count>{{$ctrl.status.notification.count}}</span></a> <span ng-if=!$ctrl.status.notification.href><image ng-if=$ctrl.status.notification.iconImage ng-src={{$ctrl.status.notification.iconImage}} alt="" class=card-pf-icon-image></image><span ng-if=$ctrl.status.notification.iconClass class={{$ctrl.status.notification.iconClass}}></span><span ng-if=$ctrl.status.notification.count>{{$ctrl.status.notification.count}}</span></span></span></p></div></div>'),$templateCache.put("card/basic/card-filter.html",'<div uib-dropdown class=card-pf-time-frame-filter><button type=button uib-dropdown-toggle class="btn btn-default">{{$ctrl.currentFilter.label}} <span class=caret></span></button><ul uib-dropdown-menu class=dropdown-menu-right role=menu><li ng-repeat="item in $ctrl.filter.filters" ng-class="{\'selected\': item === $ctrl.currentFilter}"><a role=menuitem tabindex=-1 ng-click=$ctrl.filterCallBackFn(item)>{{item.label}}</a></li></ul></div>'),$templateCache.put("card/basic/card.html",'<div class=card-pf ng-class="{\'card-pf-accented\': $ctrl.showTopBorder === \'true\'}"><div ng-if=$ctrl.showHeader() ng-class="$ctrl.shouldShowTitlesSeparator ? \'card-pf-heading\' : \'card-pf-heading-no-bottom\'"><div ng-if=$ctrl.showFilterInHeader() class=card-pf-footer-in-header ng-class="{\'hide-for-spinner\': $ctrl.showSpinner}" ng-include="\'card/basic/card-filter.html\'"></div><h2 class=card-pf-title>{{$ctrl.headTitle}}</h2></div><span ng-if=$ctrl.subTitle class=card-pf-subtitle>{{$ctrl.subTitle}}</span><div class=card-pf-body ng-class="{\'show-spinner\': $ctrl.showSpinner}"><div ng-class="{\'hide-for-spinner\': $ctrl.showSpinner}" ng-transclude></div><div ng-if=$ctrl.showSpinner class=spinner-container><div class=loading-indicator><span class="spinner spinner-lg" aria-hidden=true></span> <span ng-if=$ctrl.spinnerText class=loading-text>{{$ctrl.spinnerText}}</span><label ng-if=!$ctrl.spinnerText class=sr-only>Loading</label></div></div></div><div ng-if=$ctrl.footer class=card-pf-footer ng-class="{\'hide-for-spinner\': $ctrl.showSpinner}"><div ng-if=$ctrl.showFilterInFooter() ng-include="\'card/basic/card-filter.html\'"></div><p><a ng-if=$ctrl.footer.href href={{$ctrl.footer.href}} ng-class="{\'card-pf-link-with-icon\':$ctrl.footer.iconClass,\'card-pf-link\':!$ctrl.footer.iconClass}"><span ng-if=$ctrl.footer.iconClass class="{{$ctrl.footer.iconClass}} card-pf-footer-text"></span> <span ng-if=$ctrl.footer.text class=card-pf-footer-text>{{$ctrl.footer.text}}</span></a> <a ng-if="$ctrl.footer.callBackFn && !$ctrl.footer.href" ng-click=$ctrl.footerCallBackFn() ng-class="{\'card-pf-link-with-icon\':$ctrl.footer.iconClass,\'card-pf-link\':!$ctrl.footer.iconClass}"><span class="{{$ctrl.footer.iconClass}} card-pf-footer-text" ng-if=$ctrl.footer.iconClass></span> <span class=card-pf-footer-text ng-if=$ctrl.footer.text>{{$ctrl.footer.text}}</span></a> <span ng-if="!$ctrl.footer.href && !$ctrl.footer.callBackFn"><span ng-if=$ctrl.footer.iconClass class="{{$ctrl.footer.iconClass}} card-pf-footer-text" ng-class="{\'card-pf-link-with-icon\':$ctrl.footer.iconClass,\'card-pf-link\':!$ctrl.footer.iconClass}"></span> <span ng-if=$ctrl.footer.text class=card-pf-footer-text>{{$ctrl.footer.text}}</span></span></p></div></div>'),$templateCache.put("card/info-status/info-status-card.html",'<div class="card-pf card-pf-info-status" ng-class="{\'card-pf-accented\': $ctrl.shouldShowTopBorder}" ng-style="$ctrl.showSpinner ? $ctrl.spinnerHeight : {}"><div class=card-pf-info-image ng-if="$ctrl.status.iconImage || $ctrl.status.iconClass"><img ng-if=$ctrl.status.iconImage ng-src={{$ctrl.status.iconImage}} alt="" class="info-img"> <span class="info-icon {{$ctrl.status.iconClass}}"></span></div><div class="card-pf-info-content card-pf-body" ng-class="{\'show-spinner\': $ctrl.showSpinner}"><h2 class=card-pf-title ng-if=$ctrl.status.title><a href={{$ctrl.status.href}} ng-if=$ctrl.status.href><span>{{$ctrl.status.title}}</span></a> <span ng-if=!$ctrl.status.href><span>{{$ctrl.status.title}}</span></span></h2><div ng-if=$ctrl.showSpinner class=spinner-container ng-class="{\'with-title\' : $ctrl.status.title}"><div class=loading-indicator><span class="spinner spinner-lg" aria-hidden=true></span> <span ng-if=$ctrl.spinnerText class=loading-text>{{$ctrl.spinnerText}}</span><label ng-if=!$ctrl.spinnerText class=sr-only>Loading</label></div></div><span ng-if=!$ctrl.showSpinner><div ng-if=$ctrl.shouldShowHtmlContent class=card-pf-info-item ng-bind-html=$ctrl.trustAsHtml(item) ng-repeat="item in $ctrl.status.info track by $index"></div><div ng-if=!$ctrl.shouldShowHtmlContent class=card-pf-info-item ng-bind=item ng-repeat="item in $ctrl.status.info track by $index"></div></span></div></div>')}]),angular.module("patternfly.charts").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("charts/donut/donut-chart.html",'<span><pf-c3-chart ng-if="$ctrl.data.dataAvailable !== false" id={{$ctrl.donutChartId}} config=$ctrl.config get-chart-callback=$ctrl.setChart></pf-c3-chart><pf-empty-chart ng-if="$ctrl.data.dataAvailable === false" chart-height=$ctrl.chartHeight></pf-empty-chart></span>'),$templateCache.put("charts/donut/donut-pct-chart.html",'<span class=pct-donut-chart-pf><span ng-class="{\'pct-donut-chart-pf-left\': $ctrl.config.labelConfig.orientation === \'left\', \'pct-donut-chart-pf-right\': $ctrl.config.labelConfig.orientation === \'right\'}"><span class=pct-donut-chart-pf-chart><pf-c3-chart ng-if="$ctrl.data.dataAvailable !== false" id={{$ctrl.donutChartId}} config=$ctrl.config get-chart-callback=$ctrl.setChart></pf-c3-chart><pf-empty-chart ng-if="$ctrl.data.dataAvailable === false" chart-height=$ctrl.chartHeight></pf-empty-chart></span> <span ng-if="$ctrl.data.dataAvailable !== false && $ctrl.config.labelConfig && !$ctrl.config.labelConfig.labelFn()" class=pct-donut-chart-pf-label>{{$ctrl.config.labelConfig.title}} <span ng-if=$ctrl.data ng-switch=$ctrl.config.labelConfig.label><span ng-switch-when=none></span> <span ng-switch-when=available>{{$ctrl.data.available}} {{$ctrl.config.labelConfig.units}} available</span> <span ng-switch-when=percent>{{$ctrl.data.percent}}&#37; used</span> <span ng-switch-default="">{{$ctrl.data.used}} {{$ctrl.config.labelConfig.units}} of {{$ctrl.data.total}} {{$ctrl.config.labelConfig.units}} used</span></span></span> <span ng-if="$ctrl.data.dataAvailable !== false && $ctrl.config.labelConfig && $ctrl.config.labelConfig.labelFn()" class=pct-donut-chart-pf-label ng-bind-html=$ctrl.config.labelConfig.labelFn()></span></span></span>'),$templateCache.put("charts/empty-chart.html",'<div class=empty-chart-content ng-style=$ctrl.sizeStyles><span class="pficon pficon-info"></span> <span>No data available</span></div>'),$templateCache.put("charts/heatmap/heatmap-legend.html",'<ul class=heatmap-pf-legend-container><li ng-repeat="item in $ctrl.legendItems" class=heatmap-pf-legend-items><span class=legend-pf-color-box ng-style="{background: item.color}"></span> <span class=legend-pf-text>{{item.text}}</span></li></ul>'),$templateCache.put("charts/heatmap/heatmap.html",'<div class=heatmap-pf-container><h3>{{$ctrl.chartTitle}}</h3><div class=heatmap-container ng-style=$ctrl.containerStyles><svg class=heatmap-pf-svg></svg></div><pf-empty-chart ng-if="$ctrl.chartDataAvailable === false" chart-height=$ctrl.height></pf-empty-chart><div ng-if=!$ctrl.loadingDone class="spinner spinner-lg loading"></div><pf-heatmap-legend ng-if=$ctrl.showLegend legend=$ctrl.legendLabels legend-colors=$ctrl.heatmapColorPattern></pf-heatmap-legend></div>'),
$templateCache.put("charts/line/line-chart.html",'<span><pf-c3-chart id={{$ctrl.lineChartId}} ng-if="$ctrl.chartData.dataAvailable !== false" config=$ctrl.chartConfig></pf-c3-chart><pf-empty-chart ng-if="$ctrl.chartData.dataAvailable === false" chart-height=$ctrl.chartConfig.size.height></pf-empty-chart></span>'),$templateCache.put("charts/sparkline/sparkline-chart.html",'<span><pf-c3-chart ng-if="$ctrl.chartData.dataAvailable !== false" id={{$ctrl.sparklineChartId}} config=$ctrl.chartConfig></pf-c3-chart><pf-empty-chart ng-if="$ctrl.chartData.dataAvailable === false" chart-height=$ctrl.chartHeight></pf-empty-chart></span>'),$templateCache.put("charts/topology-map/topology-map.html",'<div class=pf-topology-map><canvas id=topology-map class=topology-graph style="font-family: FontAwesome"></canvas></div>'),$templateCache.put("charts/trends/trends-chart.html",'<span ng-switch on=$ctrl.config.layout ng-class="{\'data-unavailable-pf\': $ctrl.chartData.dataAvailable === false}"><div ng-switch-default ng-class="{\'trend-card-large-pf\': $ctrl.showLargeCardLayout,\'trend-card-small-pf\': $ctrl.showSmallCardLayout}"><span class=trend-header-pf ng-if=$ctrl.config.title>{{$ctrl.config.title}}</span> <span ng-if=$ctrl.showActualValue><span class=trend-title-big-pf>{{$ctrl.getLatestValue()}}</span> <span class=trend-title-small-pf>{{$ctrl.config.units}}</span></span> <span ng-if=$ctrl.showPercentageValue><span class=trend-title-big-pf>{{$ctrl.getPercentageValue() + \'%\'}}</span> <span class=trend-title-small-pf>of {{$ctrl.chartData.total + \' \' + $ctrl.config.units}}</span></span><pf-sparkline-chart ng-if="$ctrl.chartData.dataAvailable !== false" config=$ctrl.config chart-data=$ctrl.chartData chart-height=$ctrl.getChartHeight() show-x-axis=$ctrl.showXAxis show-y-axis=$ctrl.showYAxis></pf-sparkline-chart><pf-empty-chart ng-if="$ctrl.chartData.dataAvailable === false" chart-height=$ctrl.getChartHeight()></pf-empty-chart><span class=trend-footer-pf ng-if=$ctrl.config.timeFrame>{{$ctrl.config.timeFrame}}</span></div><div ng-switch-when=compact class=trend-card-compact-pf><div class="row trend-row"><div class=col-sm-2 ng-class="{\'col-sm-push-10\': $ctrl.config.compactLabelPosition === \'right\'}"><div class=trend-compact-details><span ng-if=$ctrl.showActualValue><span class=trend-title-compact-big-pf>{{$ctrl.getLatestValue()}}</span> <span class=trend-title-compact-small-pf>{{$ctrl.config.units}}</span></span> <span ng-if=$ctrl.showPercentageValue><span class=trend-title-compact-big-pf>{{$ctrl.getPercentageValue() + \'%\'}}</span> <span class=trend-title-compact-small-pf>of {{$ctrl.chartData.total + \' \' + $ctrl.config.units}}</span></span> <span class=trend-header-compact-pf ng-if=$ctrl.config.title>{{$ctrl.config.title}}</span></div></div><div class=col-sm-10 ng-class="{\'col-sm-pull-2\': $ctrl.config.compactLabelPosition === \'right\'}"><pf-sparkline-chart ng-if="$ctrl.chartData.dataAvailable !== false" config=$ctrl.config chart-data=$ctrl.chartData chart-height=$ctrl.getChartHeight() show-x-axis=$ctrl.showXAxis show-y-axis=$ctrl.showYAxis></pf-sparkline-chart><pf-empty-chart ng-if="$ctrl.chartData.dataAvailable === false" chart-height=$ctrl.getChartHeight()></pf-empty-chart></div></div></div><div ng-switch-when=inline class=trend-card-inline-pf><div class="row trend-row"><div class="col-sm-8 trend-flat-col"><pf-sparkline-chart ng-if="$ctrl.chartData.dataAvailable !== false" config=$ctrl.config chart-data=$ctrl.chartData chart-height=$ctrl.getChartHeight() show-x-axis=$ctrl.showXAxis show-y-axis=$ctrl.showYAxis></pf-sparkline-chart><pf-empty-chart ng-if="$ctrl.chartData.dataAvailable === false" chart-height=$ctrl.getChartHeight()></pf-empty-chart></div><div class="col-sm-4 trend-flat-col"><div class=trend-flat-details><div class=trend-flat-details-cell><span class=trend-title-flat-big-pf>{{$ctrl.getPercentageValue() + \'%\'}}</span></div><div class=trend-flat-details-cell><span class=trend-label-flat-strong-pf>{{$ctrl.config.trendLabel}}</span> <span class=trend-label-flat-pf>{{$ctrl.getLatestValue()}} of {{$ctrl.chartData.total + \' \' + $ctrl.config.units}}</span></div></div></div></div></div></span>'),$templateCache.put("charts/utilization-bar/utilization-bar-chart.html","<div class=utilization-bar-chart-pf ng-class=\"{'data-unavailable-pf': $ctrl.chartData.dataAvailable === false}\"><span ng-if=\"!$ctrl.layout || $ctrl.layout.type === 'regular'\"><div ng-if=$ctrl.chartTitle class=progress-description>{{$ctrl.chartTitle}}</div><div class=\"progress progress-label-top-right\" ng-if=\"$ctrl.chartData.dataAvailable !== false\"><div class=progress-bar aria-valuenow={{$ctrl.chartData.percentageUsed}} aria-valuemin=0 aria-valuemax=100 ng-class=\"{'animate': animate,\n           'progress-bar-success': $ctrl.isOk, 'progress-bar-danger': $ctrl.isError, 'progress-bar-warning': $ctrl.isWarn}\" ng-style=\"{width:$ctrl.chartData.percentageUsed + '%'}\" uib-tooltip-html=\"'{{$ctrl.usedTooltipMessage()}}'\"><span ng-if=$ctrl.chartFooter ng-bind-html=$ctrl.chartFooter></span> <span ng-if=\"!$ctrl.chartFooter && (!$ctrl.footerLabelFormat || $ctrl.footerLabelFormat === 'actual')\"><strong>{{$ctrl.chartData.used}} of {{$ctrl.chartData.total}} {{$ctrl.units}}</strong> Used</span> <span ng-if=\"!$ctrl.chartFooter && $ctrl.footerLabelFormat === 'percent'\"><strong>{{$ctrl.chartData.percentageUsed}}%</strong> Used</span></div><div class=\"progress-bar progress-bar-remaining\" ng-style=\"{width:(100 - $ctrl.chartData.percentageUsed) + '%'}\" uib-tooltip-html=\"'{{$ctrl.availableTooltipMessage()}}'\"></div></div></span> <span ng-if=\"$ctrl.layout && $ctrl.layout.type === 'inline'\"><div class=\"progress-container progress-description-left progress-label-right\" ng-style=\"{'padding-left':$ctrl.layout.titleLabelWidth, 'padding-right':$ctrl.layout.footerLabelWidth}\"><div ng-if=$ctrl.chartTitle class=progress-description ng-style=\"{'max-width':$ctrl.layout.titleLabelWidth}\">{{$ctrl.chartTitle}}</div><div class=progress ng-if=\"$ctrl.chartData.dataAvailable !== false\"><div class=progress-bar aria-valuenow={{$ctrl.chartData.percentageUsed}} aria-valuemin=0 aria-valuemax=100 ng-class=\"{'animate': $ctrl.animate, 'progress-bar-success': $ctrl.isOk, 'progress-bar-danger': $ctrl.isError, 'progress-bar-warning': $ctrl.isWarn}\" ng-style=\"{width:$ctrl.chartData.percentageUsed + '%'}\" uib-tooltip-html=\"'{{$ctrl.usedTooltipMessage()}}'\"><span ng-if=$ctrl.chartFooter ng-bind-html=$ctrl.chartFooter></span> <span ng-if=\"(!$ctrl.chartFooter) && (!$ctrl.footerLabelFormat || $ctrl.footerLabelFormat === 'actual')\" ng-style=\"{'max-width':$ctrl.layout.footerLabelWidth}\"><strong>{{$ctrl.chartData.used}} {{$ctrl.units}}</strong> Used</span> <span ng-if=\"(!$ctrl.chartFooter) && $ctrl.footerLabelFormat === 'percent'\" ng-style=\"{'max-width':$ctrl.layout.footerLabelWidth}\"><strong>{{$ctrl.chartData.percentageUsed}}%</strong> Used</span></div><div class=\"progress-bar progress-bar-remaining\" ng-style=\"{width:(100 - $ctrl.chartData.percentageUsed) + '%'}\" uib-tooltip-html=\"'{{$ctrl.availableTooltipMessage()}}'\"></div></div></div></span><pf-empty-chart ng-if=\"$ctrl.chartData.dataAvailable === false\" chart-height=45></pf-empty-chart></div>"),$templateCache.put("charts/utilization-trend/utilization-trend-chart.html",'<div class=utilization-trend-chart-pf ng-class="{\'data-unavailable-pf\': $ctrl.chartData.dataAvailable === false}"><h3>{{$ctrl.config.title}}</h3><div class=current-values><h1 class="available-count pull-left">{{$ctrl.currentValue}}</h1><div class="available-text pull-left"><div><span>{{$ctrl.currentText}}</span></div><div><span>of {{$ctrl.chartData.total}} {{$ctrl.config.units}}</span></div></div></div><div class=donut-chart-pf><pf-donut-pct-chart ng-if="$ctrl.chartData.dataAvailable !== false" config=$ctrl.donutConfig data=$ctrl.chartData center-label=$ctrl.centerLabel></pf-donut-pct-chart><pf-empty-chart ng-if="$ctrl.chartData.dataAvailable === false" chart-height=231></pf-empty-chart></div><div ng-if="$ctrl.chartData.dataAvailable !== false" class=sparkline-chart><pf-sparkline-chart config=$ctrl.sparklineConfig chart-data=$ctrl.chartData chart-height=$ctrl.sparklineChartHeight show-x-axis=$ctrl.showSparklineXAxis show-y-axis=$ctrl.showSparklineYAxis></pf-sparkline-chart></div><span class="pull-left legend-text">{{$ctrl.legendLeftText}}</span> <span class="pull-right legend-text">{{$ctrl.legendRightText}}</span></div>')}]),angular.module("patternfly.datepicker").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("datepicker/datepicker.html",'<p class=input-group><input class="form-control datepicker" ng-model=$ctrl.date uib-datepicker-popup={{$ctrl.format}} datepicker-options=$ctrl.dateOptions is-open=$ctrl.isOpen ng-required=true close-text=Close show-button-bar=$ctrl.showButtonBar popup-placement="{{$ctrl.popupPlacement}}"> <span class=input-group-btn><button type=button class="btn btn-default datepicker" ng-click="$ctrl.isOpen = !$ctrl.isOpen"><i class="glyphicon glyphicon-calendar"></i></button></span></p>')}]),angular.module("patternfly.filters").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("filters/filter-panel/filter-panel-results.html",'<div class=filter-pf><div class=toolbar-pf-results><h5>{{$ctrl.config.resultsCount}} <span ng-if=$ctrl.config.appliedFilters.length>of {{$ctrl.config.totalCount}}</span> {{$ctrl.config.resultsLabel === undefined ? "Results" : $ctrl.config.resultsLabel}}</h5><p class=filter-pf-active-label ng-if=$ctrl.config.appliedFilters.length>Active filters:</p><ul class=list-inline ng-if=$ctrl.config.appliedFilters.length><li ng-repeat="filter in $ctrl.config.appliedFilters" class=filter-pf-category-item><span class="label pf-filter-category-label" ng-class="{\'label-info\': filter.values.length === 1, \'multiples\': filter.values.length > 1}">{{filter.title}}:<ul class="list-inline filter-pf-category-values"><li ng-repeat="value in filter.values"><span class="label label-info">{{value}} <a href=#><span ng-click="$ctrl.clearFilter($event, filter, value)" class="pficon pficon-close"></span></a></span></li></ul></span></li></ul><p><a href=# ng-click=$ctrl.clearAllFilters($event) ng-if="$ctrl.config.appliedFilters.length > 0">Clear All Filters</a></p></div></div>'),$templateCache.put("filters/filter-panel/filter-panel.html",'<div class="filter-pf inline-filter-pf"><span class="dropdown primary-action" uib-dropdown><button class="btn btn-default dropdown-toggle" uib-dropdown-toggle type=button>Filter <span class=caret></span></button><div ng-transclude class=dropdown-menu ng-click=$event.stopPropagation()></div></span><pf-filter-panel-results config=$ctrl.config></pf-filter-panel-results></div>'),$templateCache.put("filters/simple-filter/filter-fields.html",'<div class="filter-pf filter-fields"><div class="input-group form-group"><div uib-dropdown class=input-group-btn><button ng-if="$ctrl.config.fields.length > 1" uib-dropdown-toggle type=button class="btn btn-default filter-fields" uib-tooltip="Filter by" tooltip-placement=top tooltip-append-to-body=true>{{$ctrl.currentField.title}} <span class=caret></span></button><ul uib-dropdown-menu><li ng-repeat="item in $ctrl.config.fields" ng-class="{\'selected\': item === $ctrl.currentField}"><a class=filter-field role=menuitem tabindex=-1 ng-click=$ctrl.selectField(item)>{{item.title}}</a></li></ul></div><div ng-if="$ctrl.currentField.filterType !== \'select\' && $ctrl.currentField.filterType !== \'complex-select\'"><input class=form-control type={{$ctrl.currentField.filterType}} ng-model=$ctrl.currentValue placeholder={{$ctrl.currentField.placeholder}} ng-keypress="$ctrl.onValueKeyPress($event)"></div><div ng-if="$ctrl.currentField.filterType === \'select\'"><div class="btn-group bootstrap-select form-control filter-select" uib-dropdown><button type=button uib-dropdown-toggle class="btn btn-default dropdown-toggle"><span class="filter-option pull-left">{{$ctrl.currentValue.title || $ctrl.currentValue || $ctrl.currentField.placeholder}}</span> <span class=caret></span></button><ul uib-dropdown-menu class=dropdown-menu-right role=menu><li ng-if=$ctrl.currentField.placeholder><a role=menuitem tabindex=-1 ng-click=$ctrl.selectValue()>{{$ctrl.currentField.placeholder}}</a></li><li ng-repeat="filterValue in $ctrl.currentField.filterValues" ng-class="{\'selected\': (filterValue === $ctrl.currentValue)}"><a role=menuitem tabindex=-1 ng-click=$ctrl.selectValue(filterValue)>{{filterValue.title || filterValue}}</a></li></ul></div></div><div ng-if="$ctrl.currentField.filterType === \'complex-select\'" class=category-select><div class="btn-group bootstrap-select form-control filter-select" uib-dropdown><button type=button uib-dropdown-toggle class="btn btn-default dropdown-toggle"><span class="filter-option pull-left">{{$ctrl.filterCategory.title || $ctrl.filterCategory || $ctrl.currentField.placeholder}}</span> <span class=caret></span></button><ul uib-dropdown-menu class=dropdown-menu-right role=menu><li ng-if=$ctrl.currentField.placeholder><a role=menuitem tabindex=-1 ng-click=$ctrl.selectValue()>{{$ctrl.currentField.placeholder}}</a></li><li ng-repeat="filterCategory in $ctrl.currentField.filterValues" ng-class="{\'selected\': (filterCategory == $ctrl.filterCategory)}"><a role=menuitem tabindex=-1 ng-click="$ctrl.selectValue(filterCategory, \'filter-category\')">{{filterCategory.title ||filterCategory}}</a></li></ul></div><div class="btn-group bootstrap-select form-control filter-select" uib-dropdown><button type=button uib-dropdown-toggle class="btn btn-default dropdown-toggle category-select-value"><span class="filter-option pull-left">{{$ctrl.filterValue.title || $ctrl.filterValue || $ctrl.currentField.filterCategoriesPlaceholder}}</span> <span class=caret></span></button><ul uib-dropdown-menu class=dropdown-menu-right role=menu><li ng-if=$ctrl.currentField.placeholder><a role=menuitem tabindex=-1 ng-click=$ctrl.selectValue()>{{$ctrl.currentField.filterCategoriesPlaceholder}}</a></li><li ng-repeat="filterValue in $ctrl.currentField.filterCategories[$ctrl.filterCategory.id.toLowerCase() || $ctrl.filterCategory.toLowerCase() ].filterValues" ng-class="{\'selected\': filterValue === $ctrl.filterValue}"><a role=menuitem tabindex=-1 ng-click="$ctrl.selectValue(filterValue, \'filter-value\')">{{filterValue.title || filterValue}}</a></li></ul></div></div></div></div>'),$templateCache.put("filters/simple-filter/filter-results.html",'<div class=filter-pf><div class=toolbar-pf-results><span ng-if="$ctrl.config.showTotalCountResults !== true || $ctrl.config.totalCount === undefined || $ctrl.config.appliedFilters.length === 0"><h5 ng-if="$ctrl.config.resultsCount === 1">{{$ctrl.config.resultsCount}} {{$ctrl.config.itemsLabel}}</h5><h5 ng-if="$ctrl.config.resultsCount !== 1">{{$ctrl.config.resultsCount}} {{$ctrl.config.itemsLabelPlural}}</h5></span> <span ng-if="$ctrl.config.showTotalCountResults === true && $ctrl.config.totalCount !== undefined && $ctrl.config.appliedFilters.length > 0"><h5 ng-if="$ctrl.config.totalCount === 1">{{$ctrl.config.resultsCount}} of {{$ctrl.config.totalCount}} {{$ctrl.config.itemsLabel}}</h5><h5 ng-if="$ctrl.config.totalCount !== 1">{{$ctrl.config.resultsCount}} of {{$ctrl.config.totalCount}} {{$ctrl.config.itemsLabelPlural}}</h5></span><p class=filter-pf-active-label ng-if="$ctrl.config.appliedFilters.length > 0">Active Filters:</p><ul class=list-inline ng-if="$ctrl.config.appliedFilters.length > 0"><li ng-repeat="filter in $ctrl.config.appliedFilters"><span class="active-filter label label-info">{{filter.title}}: {{((filter.value.filterCategory.title || filter.value.filterCategory) + filter.value.filterDelimiter + (filter.value.filterValue.title || filter.value.filterValue)) || filter.value.title || filter.value}} <a href=#><span class="pficon pficon-close" ng-click="$ctrl.clearFilter($event, filter)"></span></a></span></li></ul><p><a href=# class=clear-filters ng-click=$ctrl.clearAllFilters($event) ng-if="$ctrl.config.appliedFilters.length > 0">Clear All Filters</a></p><div ng-if="$ctrl.config.selectedCount !== undefined && $ctrl.config.totalCount !== undefined" class=pf-table-view-selected-label><strong>{{$ctrl.config.selectedCount}}</strong> of <strong>{{$ctrl.config.totalCount}}</strong> selected</div></div></div>'),$templateCache.put("filters/simple-filter/filter.html","<div class=filter-pf ng-class=\"{'inline-filter-pf': $ctrl.config.inlineResults === true}\"><pf-filter-fields config=$ctrl.config add-filter-fn=$ctrl.addFilter></pf-filter-fields><pf-filter-results config=$ctrl.config></pf-filter-results></div>")}]),angular.module("patternfly.form").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("form/form-buttons/form-buttons.html",'<div class=form-group><div class={{$ctrl.pfButtonContainerClass}}><div class="control-group buttons"><button class="btn btn-default" type=button ng-click=$ctrl.pfHandleCancel() ng-disabled=$ctrl.pfWorking translate>Cancel</button> <button class="btn btn-primary" ng-click="$ctrl.pfHandleSave(); $ctrl.pfWorking = true" ng-disabled="$ctrl.isInvalid() || $ctrl.pfWorking"><i class="icon-spinner icon-spin" ng-show=$ctrl.pfWorking></i> <span ng-show=$ctrl.pfWorking translate>Saving...</span> <span ng-hide=$ctrl.pfWorking translate>Save</span></button></div></div></div>'),$templateCache.put("form/form-group/form-group.html",'<div class=form-group ng-class="{ \'has-error\' : $ctrl.hasErrors() }"><label for="{{ $ctrl.pfField }}" class="control-label {{ $ctrl.pfLabelClass }}">{{ $ctrl.pfLabel }}</label><div class="{{ $ctrl.pfInputClass }}"><span ng-transclude></span> <span class=help-block ng-show=$ctrl.error.messages><ul><li ng-repeat="message in $ctrl.error.messages">{{ message }}</li></ul></span></div></div>')}]),angular.module("patternfly.modals").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("modals/about-modal/about-modal.html",'<script type=text/ng-template id=about-modal-template.html><div class="about-modal-pf">\n    <div class="modal-header">\n      <button type="button" class="close" ng-click="$ctrl.close()" aria-hidden="true">\n        <span class="pficon pficon-close"></span>\n      </button>\n    </div>\n    <div class="modal-body">\n      <h1 ng-if="$ctrl.title">{{$ctrl.title}}</h1>\n      <div ng-if="$ctrl.productInfo && $ctrl.productInfo.length > 0" class="product-versions-pf">\n        <ul class="list-unstyled">\n          <li ng-repeat="info in $ctrl.productInfo"><strong>{{info.name}}</strong> {{info.value}}</li>\n        </ul>\n      </div>\n      <div pf-about-modal-transclude="$ctrl.template" class="product-versions-pf"></div>\n      <div ng-if="$ctrl.additionalInfo" class="product-versions-pf">{{$ctrl.additionalInfo}}</div>\n      <div ng-if="$ctrl.copyright" class="trademark-pf">{{$ctrl.copyright}}</div>\n    </div>\n    <div class="modal-footer">\n      <img ng-if="$ctrl.imgSrc" ng-src="{{$ctrl.imgSrc}}" alt="{{$ctrl.imgAlt}}"/>\n    </div>\n  </div></script>'),$templateCache.put("modals/modal-overlay/modal-overlay.html",'<script type=text/ng-template id=modal-overlay-template.html><div class="modal-overlay" ng-attr-id="{{$ctrl.modalId}}" tabindex="-1" aria-labelledby="$ctrl.titleId" aria-hidden="true">\n    <div class="modal-header">\n      <button type="button" class="close" ng-click="$ctrl.cancel()" aria-hidden="true" aria-label="Close" ng-if="!$ctrl.hideCloseIcon">\n        <span class="pficon pficon-close"></span>\n      </button>\n      <h4 class="modal-title" ng-attr-id="{{$ctrl.titleId}}">{{$ctrl.modalTitle}}</h4>\n    </div>\n    <div class="modal-body">\n      <form name="pfModalOverlayForm" ng-show="$ctrl.isForm">\n        <span ng-if="$ctrl.modalBodyTemplate" ng-include="$ctrl.modalBodyTemplate"></span>\n      </form>\n      <span ng-if="!$ctrl.isForm" ng-include="$ctrl.modalBodyTemplate"></span>\n    </div>\n    <div class="modal-footer">\n      <button ng-repeat="actionButton in $ctrl.actionButtons"\n              class="btn {{actionButton.class || \'btn-default\'}}"\n              ng-click="actionButton.isCancel ? $ctrl.cancel(actionButton.actionFn) : $ctrl.ok(actionButton.label, actionButton.actionFn)"\n              ng-disabled="(pfModalOverlayForm.$invalid && !actionButton.isCancel) || actionButton.isDisabled">{{actionButton.label}}</button>\n    </div>\n  </div></script>')}]),angular.module("patternfly.navigation").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("navigation/application-launcher.html",'<div><div class="applauncher-pf dropdown dropdown-kebab-pf" ng-class="{\'applauncher-pf-block-list\': !$ctrl.isList}" uib-dropdown uib-keyboard-nav=true><a id=domain-switcher-{{$ctrl.$id}} class="dropdown-toggle drawer-pf-trigger-icon" uib-dropdown-toggle ng-class="{\'disabled\': $ctrl.isDisabled || !$ctrl.items.length}" href><i class="fa fa-th applauncher-pf-icon" aria-hidden=true></i> <span class=applauncher-pf-title>{{$ctrl.label || \'Application Launcher\'}} <span class=caret aria-hidden=true></span></span></a><ul class="dropdown-menu dropdown-menu-right" uib-dropdown-menu role=menu aria-labelledby=domain-switcher-{{$ctrl.$id}}><li class=applauncher-pf-item role=menuitem ng-repeat="item in $ctrl.items"><a class=applauncher-pf-link ng-href={{item.href}} target="{{item.target || \'_blank\'}}" title={{item.tooltip}}><i class="applauncher-pf-link-icon pficon" ng-class=item.iconClass ng-if=!$ctrl.hiddenIcons aria-hidden=true></i> <span class=applauncher-pf-link-title>{{item.title}}</span></a></li></ul></div></div>'),$templateCache.put("navigation/vertical-navigation.html","<div><nav class=\"navbar navbar-pf-vertical\"><div class=navbar-header ng-class=\"{'ignore-mobile': $ctrl.ignoreMobile}\"><button type=button class=navbar-toggle ng-click=$ctrl.handleNavBarToggleClick()><span class=sr-only>Toggle navigation</span> <span class=icon-bar></span> <span class=icon-bar></span> <span class=icon-bar></span></button> <span class=navbar-brand><img class=navbar-brand-icon ng-if=$ctrl.brandSrc ng-src={{$ctrl.brandSrc}} alt=\"{{$ctrl.brandAlt}}\"> <span class=navbar-brand-txt ng-if=!$ctrl.brandSrc>{{$ctrl.brandAlt}}</span></span></div><nav class=\"collapse navbar-collapse\" ng-class=\"{'ignore-mobile': $ctrl.ignoreMobile}\" ng-transclude></nav><div class=nav-pf-vertical ng-class=\"{'nav-pf-persistent-secondary': $ctrl.persistentSecondary,\n                    'nav-pf-vertical-collapsible-menus': $ctrl.pinnableMenus,\n                    'hidden-icons-pf': $ctrl.hiddenIcons,\n                    'nav-pf-vertical-with-badges': $ctrl.showBadges,\n                    'secondary-visible-pf': $ctrl.activeSecondary,\n                    'show-mobile-secondary': $ctrl.showMobileSecondary,\n                    'show-mobile-tertiary': $ctrl.showMobileTertiary,\n                    'hover-secondary-nav-pf': $ctrl.hoverSecondaryNav,\n                    'hover-tertiary-nav-pf': $ctrl.hoverTertiaryNav,\n                    'collapsed-secondary-nav-pf': $ctrl.collapsedSecondaryNav,\n                    'collapsed-tertiary-nav-pf': $ctrl.collapsedTertiaryNav,\n                    'hidden': $ctrl.inMobileState,\n                    'collapsed': $ctrl.navCollapsed,\n                    'force-hide-secondary-nav-pf': $ctrl.forceHidden,\n                    'show-mobile-nav': $ctrl.showMobileNav}\"><ul class=list-group><li ng-repeat=\"item in $ctrl.items\" class=list-group-item ng-class=\"{'secondary-nav-item-pf': item.children && item.children.length > 0,\n                       'active': item.isActive,\n                       'is-hover': item.isHover,\n                       'mobile-nav-item-pf': item.isMobileItem && $ctrl.showMobileSecondary,\n                       'mobile-secondary-item-pf': item.isMobileItem && $ctrl.showMobileTertiary,\n                       'hidden': item.mobileOnly && $ctrl.ignoreMobile,\n"+'                       \'visible-xs\': item.mobileOnly && !$ctrl.ignoreMobile}" ng-mouseenter=$ctrl.handlePrimaryHover(item) ng-mouseleave=$ctrl.handlePrimaryUnHover(item)><a ng-click="$ctrl.handlePrimaryClick(item, $event)"><span class={{item.iconClass}} ng-if=item.iconClass ng-class="{hidden: $ctrl.hiddenIcons}" uib-tooltip={{item.title}} tooltip-append-to-body=true tooltip-enable={{$ctrl.navCollapsed}} tooltip-placement=bottom tooltip-class=nav-pf-vertical-tooltip></span> <span class=list-group-item-value>{{item.title}}</span><div ng-if="$ctrl.showBadges && item.badges" class=badge-container-pf><div class="badge {{badge.badgeClass}}" ng-repeat="badge in item.badges" uib-tooltip={{badge.tooltip}} tooltip-append-to-body=true tooltip-placement=right><span ng-if="badge.count && badge.iconClass" class={{badge.iconClass}}></span> <span ng-if=badge.count>{{badge.count}}</span></div></div></a><div ng-if="item.children && item.children.length > 0" class=nav-pf-secondary-nav><div class=nav-item-pf-header><a class=secondary-collapse-toggle-pf ng-click="$ctrl.collapseSecondaryNav(item, $event)" ng-class="{\'collapsed\': item.secondaryCollapsed}"></a> <span>{{item.title}}</span></div><ul class=list-group><li ng-repeat="secondaryItem in item.children" class=list-group-item ng-class="{\'tertiary-nav-item-pf\': secondaryItem.children && secondaryItem.children.length > 0,\n                             \'active\': secondaryItem.isActive,\n                             \'is-hover\': secondaryItem.isHover,\n                             \'mobile-nav-item-pf\': secondaryItem.isMobileItem}" ng-mouseenter=$ctrl.handleSecondaryHover(secondaryItem) ng-mouseleave=$ctrl.handleSecondaryUnHover(secondaryItem)><a ng-click="$ctrl.handleSecondaryClick(item, secondaryItem, $event)"><span class=list-group-item-value>{{secondaryItem.title}}</span><div ng-if="$ctrl.showBadges && secondaryItem.badges" class=badge-container-pf><div class="badge {{badge.badgeClass}}" ng-repeat="badge in secondaryItem.badges" uib-tooltip={{badge.tooltip}} tooltip-append-to-body=true tooltip-placement=right><span ng-if="badge.count && badge.iconClass" class={{badge.iconClass}}></span> <span ng-if=badge.count>{{badge.count}}</span></div></div></a><div ng-if="secondaryItem.children && secondaryItem.children.length > 0" class=nav-pf-tertiary-nav><div class=nav-item-pf-header><a class=tertiary-collapse-toggle-pf ng-click="$ctrl.collapseTertiaryNav(secondaryItem, $event)" ng-class="{\'collapsed\': secondaryItem.tertiaryCollapsed}"></a> <span>{{secondaryItem.title}}</span></div><ul class=list-group><li ng-repeat="tertiaryItem in secondaryItem.children" class=list-group-item ng-class="{\'active\': tertiaryItem.isActive}"><a ng-click="$ctrl.handleTertiaryClick(item, secondaryItem, tertiaryItem, $event)"><span class=list-group-item-value>{{tertiaryItem.title}}</span><div ng-if="$ctrl.showBadges && tertiaryItem.badges" class=badge-container-pf><div class="badge {{badge.badgeClass}}" ng-repeat="badge in tertiaryItem.badges" uib-tooltip={{badge.tooltip}} tooltip-append-to-body=true tooltip-placement=right><span ng-if="badge.count && badge.iconClass" class={{badge.iconClass}}></span> <span ng-if=badge.count>{{badge.count}}</span></div></div></a></li></ul></div></li></ul></div></li></ul></div></nav></div>')}]),angular.module("patternfly.notification").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("notification/inline-notification.html",'<div class="alert alert-{{$ctrl.pfNotificationType}}" ng-class="{\'alert-dismissable\': $ctrl.pfNotificationPersistent === true}"><button ng-show=$ctrl.pfNotificationPersistent ng-click=$ctrl.pfNotificationRemove() type=button class=close data-dismiss=alert aria-hidden=true><span class="pficon pficon-close"></span></button> <span class="pficon pficon-ok" ng-show="$ctrl.pfNotificationType === \'success\'"></span> <span class="pficon pficon-info" ng-show="$ctrl.pfNotificationType === \'info\'"></span> <span class="pficon pficon-error-circle-o" ng-show="$ctrl.pfNotificationType === \'danger\'"></span> <span class="pficon pficon-warning-triangle-o" ng-show="$ctrl.pfNotificationType === \'warning\'"></span> <strong>{{$ctrl.pfNotificationHeader}}</strong> {{$ctrl.pfNotificationMessage}}</div>'),$templateCache.put("notification/notification-drawer.html",'<div class=drawer-pf ng-class="{\'hide\': $ctrl.drawerHidden, \'drawer-pf-expanded\': $ctrl.drawerExpanded}"><div ng-if=$ctrl.drawerTitle class=drawer-pf-title><a href="" ng-if=$ctrl.allowExpand class="drawer-pf-toggle-expand fa fa-angle-double-left hidden-xs" ng-click=$ctrl.toggleExpandDrawer()></a> <a href="" ng-if=$ctrl.onClose class="drawer-pf-close pficon pficon-close" ng-click=$ctrl.onClose()></a><h3 class=text-center>{{$ctrl.drawerTitle}}</h3></div><div ng-if=$ctrl.titleInclude class=drawer-pf-title ng-include src=$ctrl.titleInclude></div><div ng-if=!$ctrl.notificationGroups class=apf-blank-notification-groups><pf-empty-state config=$ctrl.emptyStateConfig></pf-empty-state></div><div ng-if=$ctrl.notificationGroups pf-fixed-accordion scroll-selector=.panel-body><div class=panel-group><div class="panel panel-default" ng-repeat="notificationGroup in $ctrl.notificationGroups track by $index"><div class=panel-heading><h4 class=panel-title><a ng-if=!$ctrl.singleGroup ng-click=$ctrl.toggleCollapse(notificationGroup) ng-class="{collapsed: !notificationGroup.open}" ng-include src=$ctrl.headingInclude></a> <span ng-if=$ctrl.singleGroup ng-include src=$ctrl.headingInclude></span></h4><span class=panel-counter ng-include src=$ctrl.subheadingInclude></span></div><div class="panel-collapse collapse" ng-class="{in: notificationGroup.open || $ctrl.notificationGroups.length === 1}"><div ng-if=$ctrl.hasNotifications(notificationGroup) class=panel-body><div class=drawer-pf-notification ng-class="{unread: notification.unread, \'expanded-notification\': $ctrl.drawerExpanded}" ng-repeat="notification in notificationGroup.notifications track by $ctrl.notificationTrackField ? notification[$ctrl.notificationTrackField] || $index : $index" ng-include src=$ctrl.notificationBodyInclude></div><div ng-if=notificationGroup.isLoading class="drawer-pf-loading text-center"><span class="spinner spinner-xs spinner-inline"></span> Loading More</div></div><div ng-if="($ctrl.showClearAll || $ctrl.showMarkAllRead) && $ctrl.hasNotifications(notificationGroup)" class=drawer-pf-action><span class=drawer-pf-action-link ng-if="$ctrl.showMarkAllRead && $ctrl.hasUnread(notificationGroup)"><button class="btn btn-link" ng-click=$ctrl.onMarkAllRead(notificationGroup)>Mark All Read</button></span> <span class=drawer-pf-action-link><button class="btn btn-link" ng-if=$ctrl.showClearAll ng-click=$ctrl.onClearAll(notificationGroup)><span class="pficon pficon-close"></span> Clear All</button></span></div><div ng-if="$ctrl.actionButtonTitle && $ctrl.hasNotifications(notificationGroup)" class=drawer-pf-action><a class="btn btn-link btn-block" ng-click=$ctrl.actionButtonCallback(notificationGroup)>{{$ctrl.actionButtonTitle}}</a></div><div ng-if=!$ctrl.hasNotifications(notificationGroup)><div class=panel-body><pf-empty-state config=notificationGroup.emptyStateConfig></pf-empty-state></div></div><div ng-if=$ctrl.notificationFooterInclude ng-include src=$ctrl.notificationFooterInclude></div></div></div></div></div></div>'),$templateCache.put("notification/notification-list.html",'<div data-ng-show="$ctrl.notifications.data.length > 0"><div ng-repeat="notification in $ctrl.notifications.data"><pf-inline-notification pf-notification-type=notification.type pf-notification-header=notification.header pf-notification-message=notification.message pf-notification-persistent=notification.isPersistent pf-notification-index=$index></pf-inline-notification></div></div>'),$templateCache.put("notification/toast-notification-list.html",'<div class=toast-notifications-list-pf data-ng-show="$ctrl.notifications.length > 0"><div ng-repeat="notification in $ctrl.notifications"><pf-toast-notification notification-type={{notification.type}} header={{notification.header}} message={{notification.message}} show-close="{{($ctrl.showClose || notification.isPersistent === true) && !(notification.menuActions && notification.menuActions.length > 0)}}" html-content=$ctrl.htmlContent close-callback=$ctrl.handleClose action-title={{notification.actionTitle}} action-callback=notification.actionCallback menu-actions=notification.menuActions update-viewing=$ctrl.handleViewingChange data=notification></pf-toast-notification></div></div>'),
$templateCache.put("notification/toast-notification.html",'<div class="toast-pf alert alert-{{$ctrl.notificationType}}" ng-class="{\'alert-dismissable\': $ctrl.showCloseButton}" ng-mouseenter=$ctrl.handleEnter() ng-mouseleave=$ctrl.handleLeave()><div uib-dropdown class="pull-right dropdown-kebab-pf" ng-if="$ctrl.menuActions && $ctrl.menuActions.length > 0"><button uib-dropdown-toggle class="btn btn-link" type=button id=dropdownKebabRight><span class="fa fa-ellipsis-v"></span></button><ul uib-dropdown-menu class=dropdown-menu-right aria-labelledby=dropdownKebabRight><li ng-repeat="menuAction in $ctrl.menuActions" role="{{menuAction.isSeparator === true ? \'separator\' : \'menuitem\'}}" ng-class="{\'divider\': menuAction.isSeparator === true, \'disabled\': menuAction.isDisabled === true}"><a ng-if="menuAction.isSeparator !== true" class=secondary-action title={{menuAction.title}} ng-click=$ctrl.handleMenuAction(menuAction)>{{menuAction.name}}</a></li></ul></div><button ng-if=$ctrl.showCloseButton type=button class=close aria-hidden=true ng-click=$ctrl.handleClose()><span class="pficon pficon-close"></span></button><div class="pull-right toast-pf-action" ng-if=$ctrl.actionTitle><a ng-click=$ctrl.handleAction()>{{$ctrl.actionTitle}}</a></div><span class="pficon pficon-ok" ng-if="$ctrl.notificationType === \'success\'"></span> <span class="pficon pficon-info" ng-if="$ctrl.notificationType === \'info\'"></span> <span class="pficon pficon-error-circle-o" ng-if="$ctrl.notificationType === \'danger\'"></span> <span class="pficon pficon-warning-triangle-o" ng-if="$ctrl.notificationType === \'warning\'"></span> <span ng-if=!$ctrl.htmlContent><strong ng-if=$ctrl.header ng-bind=$ctrl.header></strong> <span ng-bind=$ctrl.message></span></span> <span ng-if=$ctrl.htmlContent><strong ng-if=$ctrl.header ng-bind-html=$ctrl.trustAsHtml($ctrl.header)></strong> <span ng-bind-html=$ctrl.trustAsHtml($ctrl.message)></span></span></div>')}]),angular.module("patternfly.pagination").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("pagination/pagination.html",'<form class="content-view-pf-pagination table-view-pf-pagination list-view-pf-pagination clearfix" id=form1><div class=form-group><div uib-dropdown class=btn-group><button uib-dropdown-toggle type=button class="btn btn-default">{{$ctrl.pageSize}} <span class=caret></span></button><ul uib-dropdown-menu class=dropdown-menu><li ng-repeat="increment in $ctrl.pageSizeIncrements track by $index" ng-class="{\'selected\': increment === $ctrl.pageSize}" class=display-length-increment><a role=menuitem ng-click=$ctrl.onPageSizeChange(increment)>{{increment}}</a></li></ul></div><span class=per-page-label>per page</span></div><div class=form-group><span><span class=pagination-pf-items-current>{{$ctrl.getStartIndex()}}-{{$ctrl.getEndIndex()}}</span> of <span class=pagination-pf-items-total>{{$ctrl.numTotalItems}}</span></span><ul class="pagination pagination-pf-back"><li ng-class="{\'disabled\': $ctrl.pageNumber === 1}"><a title="First Page" ng-click=$ctrl.gotoFirstPage() class=goto-first-page><span class="i fa fa-angle-double-left"></span></a></li><li ng-class="{\'disabled\': $ctrl.pageNumber === 1}"><a title="Previous Page" ng-click=$ctrl.gotoPreviousPage() class=goto-prev-page><span class="i fa fa-angle-left"></span></a></li></ul><input class=pagination-pf-page ng-model=$ctrl.pageNumber ng-model-options="{ updateOn: \'blur\' }" ng-change="$ctrl.onPageNumberChange()"> <span>of <span class=pagination-pf-pages>{{$ctrl.lastPageNumber}}</span></span><ul class="pagination pagination-pf-forward"><li ng-class="{\'disabled\': $ctrl.pageNumber === $ctrl.lastPageNumber}"><a title="Next Page" ng-click=$ctrl.gotoNextPage() class=goto-next-page><span class="i fa fa-angle-right"></span></a></li><li ng-class="{\'disabled\': $ctrl.pageNumber === $ctrl.lastPageNumber}"><a title="Last Page" ng-click=$ctrl.gotoLastPage() class=goto-last-page><span class="i fa fa-angle-double-right"></span></a></li></ul></div></form>')}]),angular.module("patternfly.select").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("select/select.html",'<div uib-dropdown class=btn-group><button uib-dropdown-toggle type=button class="btn btn-default">{{$ctrl.getDisplayValue($ctrl.selected || $ctrl.emptyValue)}} <span class=caret></span></button><ul uib-dropdown-menu><li ng-if=$ctrl.emptyValue ng-class="{\'selected\': !$ctrl.selected}"><a href=# role=menuitem tabindex=-1 ng-click=$ctrl.selectItem($event)>{{$ctrl.emptyValue}}</a></li><li ng-repeat="item in $ctrl.options" ng-class="{\'selected\': item === $ctrl.selected}"><a href=# role=menuitem tabindex=-1 ng-click="$ctrl.selectItem($event, item)">{{$ctrl.getDisplayValue(item)}}</a></li></ul></div>')}]),angular.module("patternfly.sort").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("sort/sort.html",'<div class=sort-pf><div uib-dropdown class=btn-group><button uib-dropdown-toggle type=button class="btn btn-default">{{$ctrl.config.currentField.title}} <span class=caret></span></button><ul uib-dropdown-menu><li ng-repeat="item in $ctrl.config.fields" ng-class="{\'selected\': item === $ctrl.config.currentField}"><a href=# class=sort-field role=menuitem tabindex=-1 ng-click="$ctrl.selectField($event, item)">{{item.title}}</a></li></ul></div><button class="btn btn-link" type=button ng-click=$ctrl.changeDirection()><span class=sort-direction ng-class=$ctrl.getSortIconClass()></span></button></div>')}]),angular.module("patternfly.table").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("table/tableview/table-view.html",'<div class=container-fluid><table ng-if="$ctrl.config.itemsAvailable !== false" datatable=ng dt-options=$ctrl.dtOptions dt-column-defs=$ctrl.dtColumnDefs dt-instance=$ctrl.dtInstanceCallback class="table-view-container table table-striped table-bordered table-hover dataTable"><thead><tr role=row><th class=table-view-pf-select ng-if=$ctrl.config.showCheckboxes><input type=checkbox value=$ctrl.selectAll ng-model=$ctrl.selectAll ng-change="$ctrl.toggleAll()"></th><th ng-repeat="col in $ctrl.columns">{{col.header}}</th><th ng-if=$ctrl.areActions() colspan={{$ctrl.calcActionsColspan()}}>Actions</th></tr></thead><tbody><tr role=row ng-repeat="item in $ctrl.items track by $index"><td class=table-view-pf-select ng-if=$ctrl.config.showCheckboxes><input type=checkbox value=item.selected ng-model=item.selected ng-change="$ctrl.toggleOne(item)"></td><td ng-repeat="col in $ctrl.columns" ng-init="key = col.itemField; value = item[key]"><span ng-if="!col.htmlTemplate && !col.templateFn">{{value}}</span> <span ng-if=col.htmlTemplate ng-include=col.htmlTemplate></span> <span ng-if=col.templateFn ng-bind-html="$ctrl.trustAsHtml(col.templateFn(value, item))"></span></td><td ng-if="$ctrl.actionButtons && $ctrl.actionButtons.length > 0" class=table-view-pf-actions ng-repeat="actionButton in $ctrl.actionButtons"><div class=table-view-pf-btn><button class="btn btn-default" title={{actionButton.title}} ng-click="$ctrl.handleButtonAction(actionButton, item)"><span ng-if=!actionButton.include>{{actionButton.name}}</span></button></div></td><td ng-if="$ctrl.menuActions && $ctrl.menuActions.length > 0" class="table-view-pf-actions list-group-item-header"><div uib-dropdown class="{{$ctrl.dropdownClass}} dropdown-kebab-pf" id=kebab_{{$index}} ng-if="$ctrl.menuActions && $ctrl.menuActions.length > 0"><button uib-dropdown-toggle class="btn btn-default dropdown-toggle" type=button id=dropdownKebabRight_{{$index}} ng-click="$ctrl.setupActions(item, $event)"><span class="fa fa-ellipsis-v"></span></button><ul uib-dropdown-menu class="dropdown-menu dropdown-menu-right {{$index}}" aria-labelledby=dropdownKebabRight_{{$index}}><li ng-repeat="menuAction in $ctrl.menuActions" ng-if="menuAction.isVisible !== false" role="{{menuAction.isSeparator === true ? \'separator\' : \'menuitem\'}}" ng-class="{\'divider\': (menuAction.isSeparator === true), \'disabled\': (menuAction.isDisabled === true)}"><a ng-if="menuAction.isSeparator !== true" title={{menuAction.title}} ng-click="$ctrl.handleMenuAction(menuAction, item)">{{menuAction.name}}</a></li></ul></div></td></tr></tbody></table><pf-pagination ng-if="$ctrl.dtOptions.paging && $ctrl.config.itemsAvailable === true" page-size=$ctrl.pageConfig.pageSize page-number=$ctrl.pageConfig.pageNumber num-total-items=$ctrl.pageConfig.numTotalItems page-size-increments=$ctrl.pageConfig.pageSizeIncrements update-page-size=$ctrl.updatePageSize($event) update-page-number=$ctrl.updatePageNumber($event)></pf-pagination><pf-empty-state ng-if="$ctrl.config.itemsAvailable === false" config=$ctrl.emptyStateConfig action-buttons=$ctrl.emptyStateActionButtons></pf-empty-state></div>')}]),angular.module("patternfly.toolbars").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("toolbars/toolbar.html",'<div class=container-fluid><div class="row toolbar-pf" ng-class="{\'table-view-pf-toolbar\': $ctrl.isTableViewSelected()}"><div class=col-sm-12><form class=toolbar-pf-actions ng-class="{\'no-filter\': !$ctrl.config.filterConfig}"><div class="form-group toolbar-apf-filter"><pf-filter-fields config=$ctrl.config.filterConfig ng-if=$ctrl.config.filterConfig add-filter-fn=$ctrl.addFilter></pf-filter-fields></div><div class=form-group><pf-sort config=$ctrl.config.sortConfig ng-if="$ctrl.config.sortConfig && $ctrl.config.sortConfig.show"></pf-sort></div><div class="form-group toolbar-actions" ng-if="$ctrl.config.actionsConfig &&\n                   (($ctrl.config.actionsConfig.primaryActions && $ctrl.config.actionsConfig.primaryActions.length > 0) ||\n                    ($ctrl.config.actionsConfig.moreActions && $ctrl.config.actionsConfig.moreActions.length > 0) ||\n                    $ctrl.config.actionsConfig.actionsInclude)"><button class="btn btn-default primary-action" type=button ng-repeat="action in $ctrl.config.actionsConfig.primaryActions" title={{action.title}} ng-click=$ctrl.handleAction(action) ng-disabled="action.isDisabled === true">{{action.name}}</button><div ng-if=$ctrl.config.actionsConfig.actionsInclude pf-transclude class=toolbar-pf-include-actions ng-tranclude=actions></div><div uib-dropdown class=dropdown-kebab-pf ng-if="$ctrl.config.actionsConfig.moreActions && $ctrl.config.actionsConfig.moreActions.length > 0"><button uib-dropdown-toggle class="btn btn-link" type=button><span class="fa fa-ellipsis-v"></span></button><ul uib-dropdown-menu aria-labelledby=dropdownKebab><li ng-repeat="action in $ctrl.config.actionsConfig.moreActions" role="{{action.isSeparator === true ? \'separator\' : \'menuitem\'}}" ng-class="{\'divider\': action.isSeparator === true, \'disabled\': action.isDisabled === true}"><a ng-if="action.isSeparator !== true" class=secondary-action title={{action.title}} ng-click=$ctrl.handleAction(action)>{{action.name}}</a></li></ul></div></div><div class=toolbar-pf-action-right><div class="form-group toolbar-pf-view-selector" ng-if="$ctrl.config.viewsConfig && $ctrl.config.viewsConfig.views"><button ng-repeat="view in $ctrl.config.viewsConfig.viewsList" class="btn btn-link" ng-class="{\'active\': $ctrl.isViewSelected(view.id), \'disabled\': $ctrl.checkViewDisabled(view)}" title={{view.title}} ng-click=$ctrl.viewSelected(view.id)><i class={{view.iconClass}}></i></button></div></div></form><pf-filter-results config=$ctrl.config.filterConfig ng-if=$ctrl.config.filterConfig></pf-filter-results></div></div></div>')}]),angular.module("patternfly.views").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("views/cardview/card-view.html",'<span><div ng-if="$ctrl.config.itemsAvailable !== false" class=card-view-pf><div class=card ng-repeat="item in $ctrl.items | startFrom:($ctrl.pageConfig.pageNumber - 1)*$ctrl.pageConfig.pageSize | limitTo:$ctrl.pageConfig.pageSize" ng-class="{\'pf-selectable\': $ctrl.selectItems, \'active\': $ctrl.isSelected(item), \'disabled\': $ctrl.checkDisabled(item)}"><div class=card-content ng-click="$ctrl.itemClick($event, item)" ng-dblclick="$ctrl.dblClick($event, item)"><div pf-transclude=parent></div></div><div class=card-check-box ng-if=$ctrl.config.showSelectBox><input type=checkbox value=item.selected ng-model=item.selected ng-disabled=$ctrl.checkDisabled(item) ng-change="$ctrl.checkBoxChange(item)"></div></div></div><pf-pagination ng-if="$ctrl.pageConfig.showPaginationControls && $ctrl.config.itemsAvailable === true" page-size=$ctrl.pageConfig.pageSize page-size-increments=$ctrl.pageConfig.pageSizeIncrements page-number=$ctrl.pageConfig.pageNumber num-total-items=$ctrl.pageConfig.numTotalItems></pf-pagination><pf-empty-state ng-if="$ctrl.config.itemsAvailable === false" config=$ctrl.emptyStateConfig action-buttons=$ctrl.emptyStateActionButtons></pf-empty-state></span>'),$templateCache.put("views/empty-state.html",'<div class=blank-slate-pf><div ng-if=$ctrl.config.icon class=blank-slate-pf-icon><span class={{$ctrl.config.icon}}></span></div><h4 id=blank-state-pf-title-{{$id}} class="h1 blank-state-pf-title">{{$ctrl.config.title}}</h4><p id=blank-state-pf-info-{{$id}} class=blank-state-pf-info ng-if=$ctrl.config.info>{{$ctrl.config.info}}</p><p id=blank-state-pf-helpLink-{{$id}} class=blank-state-pf-helpLink-label ng-if=$ctrl.config.helpLink>{{$ctrl.config.helpLink.label}} <a ng-if=$ctrl.config.helpLink.url class=blank-state-pf-helpLink ng-click=$ctrl.config.helpLink.urlAction() href={{$ctrl.config.helpLink.url}}>{{$ctrl.config.helpLink.urlLabel}}</a> <button ng-if=!$ctrl.config.helpLink.url class="btn blank-state-pf-helpbutton btn-link" ng-click=$ctrl.config.helpLink.urlAction()>{{$ctrl.config.helpLink.urlLabel}}</button></p><div ng-if=$ctrl.hasMainActions() class=blank-slate-pf-main-action><button class="btn btn-primary btn-lg" ng-repeat="actionButton in $ctrl.actionButtons | filter:$ctrl.filterMainActions" title={{actionButton.title}} ng-click=$ctrl.handleButtonAction(actionButton)>{{actionButton.name}}</button></div><div ng-if=$ctrl.hasSecondaryActions() class=blank-slate-pf-secondary-action><button class="btn btn-default" ng-repeat="actionButton in $ctrl.actionButtons | filter:$ctrl.filterSecondaryActions" title={{actionButton.title}} ng-click=$ctrl.handleButtonAction(actionButton)>{{actionButton.name}}</button></div></div>'),$templateCache.put("views/listview/examples/clusters-content.html","<div class=row><div class=col-md-12>Clusters for {{$ctrl.item.name}}</div><div class=col-md-3><ul><li>Cluster 1</li><li>Cluster 2</li><li>Cluster 3</li><li>Cluster 4</li><li>Cluster 5</li><li>Cluster 6</li></ul></div><div class=col-md-9><dl class=dl-horizontal><dt>Host Name</dt><dd>file1.nay.redhat.com</dd><dt>Device Path</dt><dd>/dev/disk/pci-0000.05:00-sas-0.2-part1</dd><dt>Time</dt><dd>January 15, 2016 10:45:11 AM</dd><dt>Severity</dt><dd>Warning</dd><dt>Cluster</dt><dd>Cluster 1</dd></dl><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p></div></div>"),$templateCache.put("views/listview/examples/hosts-content.html","<div class=row><div class=col-md-12>Hosts for {{$ctrl.item.name}}</div><div class=col-md-3><ul><li>Host 1</li><li>Host 2</li><li>Host 3</li><li>Host 4</li><li>Host 5</li><li>Host 6</li><li>Host 7</li><li>Host 8</li></ul></div><div class=col-md-9><dl class=dl-horizontal><dt>Host Name</dt><dd>file1.nay.redhat.com</dd><dt>Device Path</dt><dd>/dev/disk/pci-0000.05:00-sas-0.2-part1</dd><dt>Time</dt><dd>January 15, 2016 10:45:11 AM</dd><dt>Severity</dt><dd>Warning</dd><dt>Cluster</dt><dd>Cluster 1</dd></dl><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p></div></div>"),$templateCache.put("views/listview/examples/images-content.html","<div class=row><div class=col-md-12>Images for {{$ctrl.item.name}}</div><div class=col-md-3><ul><li>Image 1</li><li>Image 2</li><li>Image 3</li><li>Image 4</li><li>Image 5</li><li>Image 6</li><li>Image 7</li><li>Image 8</li></ul></div><div class=col-md-9><dl class=dl-horizontal><dt>Host Name</dt><dd>file1.nay.redhat.com</dd><dt>Device Path</dt><dd>/dev/disk/pci-0000.05:00-sas-0.2-part1</dd><dt>Time</dt><dd>January 15, 2016 10:45:11 AM</dd><dt>Severity</dt><dd>Warning</dd><dt>Cluster</dt><dd>Cluster 1</dd></dl><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p></div></div>"),$templateCache.put("views/listview/examples/nodes-content.html","<div class=row><div class=col-md-12>Nodes for {{$ctrl.item.name}}</div><div class=col-md-3><ul><li>Node 1</li><li>Node 2</li><li>Node 3</li><li>Node 4</li><li>Node 5</li><li>Node 6</li><li>Node 7</li><li>Node 8</li><li>Node 9</li><li>Node 10</li></ul></div><div class=col-md-9><dl class=dl-horizontal><dt>Host Name</dt><dd>file1.nay.redhat.com</dd><dt>Device Path</dt><dd>/dev/disk/pci-0000.05:00-sas-0.2-part1</dd><dt>Time</dt><dd>January 15, 2016 10:45:11 AM</dd><dt>Severity</dt><dd>Warning</dd><dt>Cluster</dt><dd>Cluster 1</dd></dl><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p></div></div>"),$templateCache.put("views/listview/list-view.html",'<span><div class="list-group list-view-pf list-view-pf-view" dnd-list=$ctrl.items ng-class="{\'list-view-pf-dnd\': $ctrl.config.dragEnabled === true}" ng-if="$ctrl.config.itemsAvailable !== false"><div class=dndPlaceholder></div><div class="list-group-item {{item.rowClass}}" ng-repeat="item in $ctrl.items | startFrom:($ctrl.pageConfig.pageNumber - 1)*$ctrl.pageConfig.pageSize | limitTo:$ctrl.pageConfig.pageSize track by $index" dnd-draggable=item dnd-effect-allowed=move dnd-disable-if="$ctrl.config.dragEnabled !== true" dnd-dragstart=$ctrl.dragStart(item) dnd-moved=$ctrl.dragMoved() dnd-dragend=$ctrl.dragEnd() ng-class="{\'drag-original\': $ctrl.isDragOriginal(item), \'pf-selectable\': $ctrl.selectItems, \'active\': $ctrl.isSelected(item), \'disabled\': $ctrl.checkDisabled(item), \'list-view-pf-expand-active\': item.isExpanded}"><div class=list-group-item-header ng-class="{\'list-group-item-not-selectable\' : !$ctrl.config.selectItems && (!$ctrl.config.useExpandingRows || $ctrl.config.compoundExpansionOnly)}"><div class=list-view-pf-dnd-drag-items ng-if="$ctrl.config.dragEnabled === true"><div pf-transclude=parent class=list-view-pf-main-info></div></div><div ng-class="{\'list-view-pf-dnd-original-items\': $ctrl.config.dragEnabled === true}"><div class=list-view-pf-expand ng-if="$ctrl.config.useExpandingRows && !$ctrl.config.compoundExpansionOnly"><span class="fa fa-angle-right" ng-show=!item.disableRowExpansion ng-click=$ctrl.toggleItemExpansion(item) ng-class="{\'fa-angle-down\': item.isExpanded}"></span> <span class=pf-expand-placeholder ng-show=item.disableRowExpansion></span></div><div class=list-view-pf-checkbox ng-if=$ctrl.config.showSelectBox><input type=checkbox value=item.selected ng-model=item.selected ng-disabled=$ctrl.checkDisabled(item) ng-change="$ctrl.checkBoxChange(item)"></div><div class=list-view-pf-actions ng-if="($ctrl.actionButtons && $ctrl.actionButtons.length > 0) || ($ctrl.menuActions && $ctrl.menuActions.length > 0)"><button class="btn {{actionButton.class || \'btn-default\'}}" ng-repeat="actionButton in $ctrl.actionButtons" title={{actionButton.title}} ng-class="{\'disabled\' : $ctrl.checkDisabled(item) || !$ctrl.enableButtonForItem(actionButton, item)}" ng-click="$ctrl.handleButtonAction(actionButton, item)"><div ng-if=actionButton.include class=actionButton.includeClass ng-include src=actionButton.include></div><span ng-if=!actionButton.include>{{actionButton.name}}</span></button><div uib-dropdown class="{{$ctrl.dropdownClass}} pull-right dropdown-kebab-pf {{$ctrl.getMenuClassForItem(item)}} {{$ctrl.hideMenuForItem(item) ? \'invisible\' : \'\'}}" id=kebab_{{$index}} ng-if="$ctrl.menuActions && $ctrl.menuActions.length > 0"><button uib-dropdown-toggle class="btn btn-link" type=button id=dropdownKebabRight_{{$index}} ng-class="{\'disabled\': $ctrl.checkDisabled(item)}" ng-click="$ctrl.setupActions(item, $event)"><span class="fa fa-ellipsis-v"></span></button><ul uib-dropdown-menu class="dropdown-menu dropdown-menu-right {{$index}}" ng-class="{\'invisible\': !$ctrl.kebabMenuReady}" aria-labelledby=dropdownKebabRight_{{$index}}><li ng-repeat="menuAction in $ctrl.menuActions" ng-if="menuAction.isVisible !== false" role="{{menuAction.isSeparator === true ? \'separator\' : \'menuitem\'}}" ng-class="{\'divider\': (menuAction.isSeparator === true), \'disabled\': (menuAction.isDisabled === true)}"><a ng-if="menuAction.isSeparator !== true" title={{menuAction.title}} ng-click="$ctrl.handleMenuAction(menuAction, item)">{{menuAction.name}}</a></li></ul></div></div><div pf-transclude=parent class=list-view-pf-main-info ng-click="$ctrl.itemClick($event, item)" ng-dblclick="$ctrl.dblClick($event, item)"></div></div></div><div class="list-group-item-container container-fluid" ng-transclude=expandedContent ng-if="$ctrl.config.useExpandingRows && item.isExpanded"></div></div><pf-pagination ng-if="$ctrl.pageConfig.showPaginationControls && $ctrl.config.itemsAvailable === true" page-size=$ctrl.pageConfig.pageSize page-size-increments=$ctrl.pageConfig.pageSizeIncrements page-number=$ctrl.pageConfig.pageNumber num-total-items=$ctrl.pageConfig.numTotalItems></pf-pagination></div><pf-empty-state ng-if="$ctrl.config.itemsAvailable === false" config=$ctrl.emptyStateConfig action-buttons=$ctrl.emptyStateActionButtons></pf-empty-state></span>')}]),angular.module("patternfly.wizard").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("wizard/wizard-review-page.html",'<div class=wizard-pf-review-page><div class=wizard-pf-review-steps><ul class=list-group><li class=list-group-item ng-repeat="reviewStep in $ctrl.reviewSteps track by $index"><a class=apf-form-collapse ng-class="{\'collapsed\': !reviewStep.showReviewDetails}" ng-click=$ctrl.toggleShowReviewDetails(reviewStep)>{{reviewStep.stepTitle}}</a><div class=wizard-pf-review-substeps ng-class="{\'collapse\': !reviewStep.showReviewDetails}"><ul class=list-group ng-if=reviewStep.substeps><li class=list-group-item ng-repeat="substep in reviewStep.getReviewSteps()"><a class=apf-form-collapse ng-class="{\'collapsed\': !substep.showReviewDetails}" ng-click=$ctrl.toggleShowReviewDetails(substep)><span class=wizard-pf-substep-number>{{$ctrl.getSubStepNumber(reviewStep, substep)}}</span> <span class=wizard-pf-substep-title>{{substep.stepTitle}}</span></a><div class=wizard-pf-review-content ng-class="{\'collapse\': !substep.showReviewDetails}"><div ng-include=substep.reviewTemplate></div></div></li></ul><div class=wizard-pf-review-content ng-if=reviewStep.reviewTemplate ng-class="{\'collapse\': !reviewStep.showReviewDetails}"><div ng-include=reviewStep.reviewTemplate></div></div></div></li></ul></div></div>'),$templateCache.put("wizard/wizard-step.html",'<section ng-show=$ctrl.selected class=wizard-pf-row ng-class="{current: $ctrl.selected, done: $ctrl.completed}" style="height: inherit"><div ng-if=!$ctrl.wizard.hideSidebar class=wizard-pf-sidebar ng-style=$ctrl.contentStyle ng-class=$ctrl.wizard.sidebarClass ng-if="$ctrl.substeps === true"><ul class=list-group><li class=list-group-item ng-class="{active: step.selected}" ng-repeat="step in $ctrl.getEnabledSteps()"><a ng-click=$ctrl.stepClick(step)><span class=wizard-pf-substep-number>{{$ctrl.getStepDisplayNumber(step)}}</span> <span class=wizard-pf-substep-title>{{step.title}}</span></a></li></ul></div><div class="wizard-pf-main {{$ctrl.wizard.stepClass}}" ng-class="{\'wizard-pf-singlestep\': !$ctrl.substeps || $ctrl.wizard.hideSidebar}" ng-style=$ctrl.contentStyle><div class=wizard-pf-contents ng-transclude></div></div></section>'),$templateCache.put("wizard/wizard-substep.html",'<subsection ng-show=$ctrl.selected ng-class="{current: $ctrl.selected, done: $ctrl.completed}" class=wizard-pf-step ng-transclude></subsection>'),$templateCache.put("wizard/wizard.html",'<div><div class=modal-header ng-if=!$ctrl.hideHeader><button type=button class="close wizard-pf-dismiss" aria-hidden=true aria-label=Close ng-click=$ctrl.onCancel() ng-if=!$ctrl.embedInPage><span class="pficon pficon-close"></span></button><h4 class=modal-title>{{$ctrl.wizardTitle}}</h4></div><div class="modal-body wizard-pf-body clearfix"><!-- step area --><div class=wizard-pf-steps ng-class="{\'invisible\': !$ctrl.wizardReady}"><ul class=wizard-pf-steps-indicator ng-if=!$ctrl.hideIndicators ng-class="{\'invisible\': !$ctrl.wizardReady}"><li class=wizard-pf-step ng-class="{active: step.selected}" ng-repeat="step in $ctrl.getEnabledSteps()" data-tabgroup="{{$index }}"><a ng-click=$ctrl.stepClick(step) ng-class="{\'disabled\': !$ctrl.allowStepIndicatorClick(step)}"><span class=wizard-pf-step-number>{{$index + 1}}</span> <span ng-if="!$ctrl.activeStepTitleOnly || step.selected" class=wizard-pf-step-title>{{step.title}}</span> <span class=wizard-pf-step-title-substep ng-repeat="substep in step.steps track by $index" ng-class="{\'active\': substep.selected}">{{substep.title}}</span></a></li></ul></div><!-- loading wizard placeholder --><div ng-if=!$ctrl.wizardReady class=wizard-pf-main style="margin-left: 0px"><div class="wizard-pf-loading blank-slate-pf"><div class="spinner spinner-lg blank-slate-pf-icon"></div><h3 class=blank-slate-pf-main-action>{{$ctrl.loadingWizardTitle}}</h3><p class=blank-slate-pf-secondary-action>{{$ctrl.loadingSecondaryInformation}}</p></div></div><div class=wizard-pf-position-override ng-transclude></div></div><div class="modal-footer wizard-pf-footer wizard-pf-position-override" ng-class="{\'wizard-pf-footer-inline\': $ctrl.embedInPage}"><button ng-if=!$ctrl.embedInPage class="btn btn-default btn-cancel wizard-pf-cancel" ng-class="{\'wizard-pf-cancel-no-back\': $ctrl.hideBackButton}" ng-disabled=$ctrl.wizardDone ng-click=$ctrl.onCancel()>{{$ctrl.cancelTitle}}</button> <button id=backButton class="btn btn-default" ng-if=!$ctrl.hideBackButton tooltip-append-to-body=true uib-tooltip={{$ctrl.prevTooltip}} tooltip-placement=left ng-disabled="!$ctrl.wizardReady || $ctrl.wizardDone || !$ctrl.selectedStep.isPrevEnabled() || $ctrl.firstStep" ng-click=$ctrl.previous()>{{$ctrl.backTitle}}</button> <button id=nextButton class="btn btn-primary wizard-pf-next" uib-tooltip={{$ctrl.nextTooltip}} tooltip-append-to-body=true tooltip-placement=left ng-disabled="!$ctrl.wizardReady || !$ctrl.selectedStep.isNextEnabled()" ng-click=$ctrl.next()>{{$ctrl.nextTitle}}</button> <button ng-if=$ctrl.embedInPage class="btn btn-default btn-cancel wizard-pf-cancel wizard-pf-cancel-inline" ng-disabled=$ctrl.wizardDone ng-click=$ctrl.onCancel()>{{$ctrl.cancelTitle}}</button></div></div>')}]);