/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot;

import io.hawt.springboot.HawtPlugin;
import io.hawt.util.Strings;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.actuate.endpoint.mvc.AbstractNamedMvcEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;
import org.springframework.web.util.UriComponents;

@ConfigurationProperties(prefix="endpoints.hawtio", ignoreUnknownFields=false)
public class HawtioEndpoint
extends AbstractNamedMvcEndpoint {
    private final String managementContextPrefix;
    private List<HawtPlugin> plugins;

    public HawtioEndpoint(String managementContextPrefix) {
        super("hawtio", "/hawtio", true);
        this.managementContextPrefix = Strings.webContextPath((String)managementContextPrefix, (String[])new String[0]);
    }

    public void setPlugins(List<HawtPlugin> plugins) {
        this.plugins = plugins;
    }

    @RequestMapping(value={"", "/"}, produces={"text/html"})
    public String redirectRootToIndexPage(HttpServletRequest request) {
        return this.getIndexHtmlRedirect(request);
    }

    @RequestMapping(value={"/plugin"})
    @ResponseBody
    public List<HawtPlugin> getPlugins() {
        return this.plugins;
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{this.managementContextPrefix + this.getPath() + "/plugins/**"}).addResourceLocations(new String[]{"/app/", "classpath:/hawtio-static/app/"});
        registry.addResourceHandler(new String[]{this.managementContextPrefix + this.getPath() + "/**"}).addResourceLocations(new String[]{"/", "/app/", "classpath:/hawtio-static/", "classpath:/hawtio-static/app/"});
        registry.addResourceHandler(new String[]{"/img/**"}).addResourceLocations(new String[]{"classpath:/hawtio-static/img/"});
    }

    protected String getIndexHtmlRedirect(HttpServletRequest request) {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromRequest((HttpServletRequest)request);
        builder.path("/index.html");
        UriComponents uriComponents = builder.build();
        String uri = uriComponents.toUriString();
        return "redirect:" + uri;
    }
}

