/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot;

import io.hawt.springboot.HawtioEndpoint;
import io.hawt.springboot.HawtioProperties;
import io.hawt.system.ConfigManager;
import java.util.HashMap;
import java.util.Map;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.actuate.condition.ConditionalOnEnabledEndpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnEnabledEndpoint(value="hawtio")
@PropertySource(value={"classpath:/io/hawt/springboot/application.properties"})
@EnableConfigurationProperties
public class HawtioAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public HawtioEndpoint hawtioEndpoint(ManagementServerProperties managementServerProperties) {
        return new HawtioEndpoint(managementServerProperties.getContextPath());
    }

    @Bean
    public ConfigManager hawtioConfigManager(HawtioProperties hawtioProperties) {
        return new ConfigManager(hawtioProperties.get()::get);
    }

    @Bean
    public HawtioProperties hawtioProperties() {
        return new HawtioProperties(this.hawtioConfigurationProperties().getHawtio());
    }

    @Bean
    @ConfigurationProperties
    protected HawtioConfigurationProperties hawtioConfigurationProperties() {
        return new HawtioConfigurationProperties();
    }

    protected static class HawtioConfigurationProperties {
        private final Map<String, String> hawtio = new HashMap<String, String>();

        protected HawtioConfigurationProperties() {
        }

        public Map<String, String> getHawtio() {
            return this.hawtio;
        }
    }
}

