/// Copyright 2014-2015 Red Hat, Inc. and/or its affiliates
/// and other contributors as indicated by the @author tags.
///
/// Licensed under the Apache License, Version 2.0 (the "License");
/// you may not use this file except in compliance with the License.
/// You may obtain a copy of the License at
///
///   http://www.apache.org/licenses/LICENSE-2.0
///
/// Unless required by applicable law or agreed to in writing, software
/// distributed under the License is distributed on an "AS IS" BASIS,
/// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
/// See the License for the specific language governing permissions and
/// limitations under the License.
var Login;
(function (Login) {
    Login.pluginName = 'hawtio-login';
    Login.log = Logger.get(Login.pluginName);
})(Login || (Login = {}));
/// <reference path="./login.globals.ts"/>
var Login;
(function (Login) {
    var LOGIN_URL = 'auth/login';
    var LoginController = /** @class */ (function () {
        LoginController.$inject = ["$http", "$window", "documentBase"];
        function LoginController($http, $window, documentBase) {
            'ngInject';
            this.$http = $http;
            this.$window = $window;
            this.documentBase = documentBase;
            this.branding = {};
            this.entity = {
                username: '',
                password: ''
            };
            this.wrongPassword = false;
        }
        LoginController.prototype.$onInit = function () {
            var _this = this;
            // fetch hawtconfig.json
            this.$http.get('hawtconfig.json').then(function (response) {
                Login.log.debug('hawtconfig.json:', response.data);
                _this.branding = response.data.branding;
            }, function (response) {
                Login.log.warn('Failed to fetch hawtconfig.json', response);
            });
        };
        LoginController.prototype.doLogin = function () {
            var _this = this;
            if (this.entity.username.trim() == '') {
                return;
            }
            this.$http.post(LOGIN_URL, this.entity).then(function (response) {
                Login.log.debug("Server login success:", response.data);
                _this.$window.location.href = _this.documentBase;
            }, function (response) {
                Login.log.error('Failed to log in', response);
                _this.wrongPassword = true;
            });
        };
        return LoginController;
    }());
    Login.LoginController = LoginController;
    Login.loginComponent = {
        controller: LoginController,
        templateUrl: 'app/src/login/login-template.html'
    };
})(Login || (Login = {}));
/// <reference path="login.globals.ts"/>
/// <reference path="../../node_modules/keycloak-js/dist/keycloak.d.ts"/>
var Login;
(function (Login) {
    var KEYCLOAK_ENABLED_URL = "keycloak/enabled";
    var KEYCLOAK_CLIENT_CONFIG_URL = "keycloak/client-config";
    var KEYCLOAK_VALIDATE_URL = "keycloak/validate-subject-matches";
    hawtioPluginLoader.registerPreBootstrapTask({
        name: 'KeycloakLoginBootstrap',
        task: function (next) {
            Login.log.debug('Executing keycloak login bootstrap task');
            configureKeycloakIfEnabled();
            next();
        }
    }, true);
    function configureKeycloakIfEnabled() {
        $.ajax(KEYCLOAK_ENABLED_URL, {
            type: "GET",
            success: function (data, status, xhr) {
                Login.log.debug("Keycloak enabled:", data);
                var keycloakEnabled = (data === true || data === "true");
                if (keycloakEnabled) {
                    loadKeycloakConfig();
                }
            },
            error: function (xhr, status, error) {
                Login.log.error("Failed to retrieve keycloak/enabled:", error);
            }
        });
    }
    function loadKeycloakConfig() {
        $.ajax(KEYCLOAK_CLIENT_CONFIG_URL, {
            type: "GET",
            success: function (data, status, xhr) {
                Login.log.debug("Loaded keycloak/client-config:", data);
                // This enables hawtio-oauth keycloak integration
                HawtioKeycloak.config = data;
            },
            error: function (xhr, status, error) {
                Login.log.error("Failed to retrieve keycloak/client-config:", error);
            }
        });
    }
    // TODO: validate subject against server session
    function validateSubjectMatches(keycloakUser) {
        var keycloakValidateUrl = KEYCLOAK_VALIDATE_URL + "?keycloakUser=" + encodeURIComponent(keycloakUser);
        $.ajax(keycloakValidateUrl, {
            type: "GET",
            success: function (data, status, xhr) {
                Login.log.debug("Got response for validate subject matches:", data);
            },
            error: function (xhr, status, error) {
                Login.log.debug("Failed to validate subject matches:", error);
            }
        });
    }
})(Login || (Login = {}));
/// <reference path="./login.globals.ts"/>
/// <reference path="./login.controller.ts"/>
/// <reference path="./keycloak-login.ts"/>
var Login;
(function (Login) {
    addLogoutToUserDropdown.$inject = ["HawtioExtension", "$compile", "userDetails"];
    loginUserDetails.$inject = ["userDetails", "keycloakService", "postLogoutTasks", "$window"];
    var USER_URL = 'user';
    var AUTH_LOGOUT_URL = 'auth/logout';
    angular
        .module(Login.pluginName, [])
        .component('hawtioLogin', Login.loginComponent)
        .run(addLogoutToUserDropdown)
        .run(loginUserDetails);
    function addLogoutToUserDropdown(HawtioExtension, $compile, userDetails) {
        'ngInject';
        HawtioExtension.add('hawtio-logout', function ($scope) {
            $scope.userDetails = userDetails;
            var template = '<a href="" ng-click="userDetails.logout()">Logout</a>';
            return $compile(template)($scope);
        });
    }
    Login.addLogoutToUserDropdown = addLogoutToUserDropdown;
    function loginUserDetails(userDetails, keycloakService, postLogoutTasks, $window) {
        'ngInject';
        if (keycloakService.enabled) {
            // When Keycloak is enabled, login/logout is handled at hawtio-oauth keycloak plugin
            return;
        }
        // Get logged-in user from server session
        $.ajax(USER_URL, {
            type: "GET",
            success: function (data, status, xhr) {
                Login.log.debug("Logged-in user:", data);
                userDetails.login(data, null);
                Login.log.debug("Register 'DefaultLogout' to postLogoutTasks");
                postLogoutTasks.addTask('DefaultLogout', function () {
                    Login.log.debug("Log out, redirecting to:", AUTH_LOGOUT_URL);
                    $window.location.href = AUTH_LOGOUT_URL;
                });
            },
            error: function (xhr, status, error) {
                // Silently ignore as mostly it's just not logged-in yet
                Login.log.debug("Failed to get logged-in user from server", error);
            }
        });
    }
})(Login || (Login = {}));
/// <reference path="./login/login.module.ts"/>
var ConsoleAssembly;
(function (ConsoleAssembly) {
    refreshUserSessionWhenLocationChanges.$inject = ["locationChangeStartTasks", "$http"];
    var pluginName = 'hawtio-console-assembly';
    var log = Logger.get(pluginName);
    angular
        .module(pluginName, [
        Login.pluginName
    ])
        .run(refreshUserSessionWhenLocationChanges);
    function refreshUserSessionWhenLocationChanges(locationChangeStartTasks, $http) {
        'ngInject';
        locationChangeStartTasks.addTask('RefreshUserSession', function ($event, newUrl, oldUrl) {
            $http({
                method: 'post',
                url: 'refresh'
            }).then(function (response) {
                log.debug("Updated session. Response:", response);
            }).catch(function (response) {
                log.debug("Failed to update session expiry. Response:", response);
            });
        });
    }
    hawtioPluginLoader.addModule(pluginName);
})(ConsoleAssembly || (ConsoleAssembly = {}));

angular.module('hawtio-console-assembly-templates', []).run(['$templateCache', function($templateCache) {$templateCache.put('plugins/help/doc/CHANGES.md','## Change Log\n\n#### 2.1.0 (To be released)\n\n#### 2.0.3\n\n- #2488: Allow using SSL by specifying a keyStore and keyStorePass from embedded Hawtio\n\n#### 2.0.2\n\n**Official Hawtio v2 GA version!**\n\n#### 2.0.0, 2.0.1\n\nThese are old versions that were mistakenly released years ago. Please don\'t use these versions!\n\n#### 2.0 Beta3 (To be released)\n\n* Added hawtio BOM\n\n#### 2.0 Beta2\n\n* Keycloak integration support\n* Bug fixes\n\n#### 2.0 Beta1\n\n* hawtio Maven plugin\n* Improved Spring Boot support\n* Log plugin\n* Diagnostics plugin\n* Karaf RBAC support\n* PatternFly-based login page and logo\n* Upgrade to Servlet API 3.1\n* Port fixes from hawtio v1\n* Bug fixes\n\n#### 2.0 M3\n\n* Switch from bower to yarn\n* Help plugin\n* Port fixes from hawtio v1\n\n#### 2.0 M2\n\n* Migrate to PatternFly\n* Bug fixes\n* Port fixes from hawtio v1\n\n#### 2.0 M1\n\n* Initial 2.0 milestone release\n\n-----\n\n#### 1.x\n\nSee: https://github.com/hawtio/hawtio/blob/master/CHANGES.md\n');
$templateCache.put('plugins/help/doc/FAQ.md','## General Questions\n\nGeneral questions on all things hawtio.\n\n#### What is the license?\n\nhawtio uses the [Apache 2.0 License](http://www.apache.org/licenses/LICENSE-2.0.txt).\n\n#### What does hawtio do?\n\nIt\'s a [pluggable](http://hawt.io/plugins/index.html) management console for Java stuff which supports any kind of JVM, any kind of container (Tomcat, Jetty, Karaf, JBoss, Fuse Fabric, etc), and any kind of Java technology and middleware.\n\n#### How do I install hawtio?\n\nSee the [Getting Started Guide](http://hawt.io/getstarted/index.html) and the [Configuration Guide](http://hawt.io/configuration/index.html)\n\n#### How do I configure hawtio?\n\nMostly hawtio just works. However, please check out the [Configuration Guide](http://hawt.io/configuration/index.html) to see what kinds of things you can configure via system properties, environment variables, web.xml context-params or dependency injection.\n\n#### How do I disable security?\n\nSince 1.2-M2 of hawtio we enable security by default using the underlying application container\'s security mechanism.\n\nHere\'s how to [disable security](https://github.com/hawtio/hawtio/blob/master/docs/Configuration.md#configuring-or-disabling-security-in-karaf-servicemix-fuse) if you wish to remove the need to login to hawtio.\n\n#### Which Java version is required?\n\n- Hawtio 1.5 onwards - requires Java 8.\n- Hawtio 1.4 - requires Java 7 or 8. \n- Hawtio 1.3 or older - supports Java 6 and 7.\n\n#### How do I enable hawtio inside my Java Application / Spring Boot / DropWizard / Micro Service\n\nThe easiest thing to do is add jolokia as a java agent via a java agent command line:\n\n    java -javaagent:jolokia-agent.jar=host=0.0.0.0 -jar foo.jar\n\nThen by default you can connect on http;//localhost:8778/jolokia to access the jolokia REST API.\n\nNow you can use hawtio (e.g. the Google Chrome Extension or the stand alone hawtio application) to connect to it - and it then minimises the effect of hawtio/jolokia on your app (e.g. you don\'t need to mess about with whats inside your application or even change the classpath)\n\n#### How do I connect to my remote JVM?\n\nAll that\'s required for hawtio to connect to any remote JVM is that a [jolokia agent](http://jolokia.org/agent.html) is attached to the JVM you wish to connect to. This can be done in various ways.\n\nFirstly if you are using [Fuse](http://www.jboss.org/products/fuse) or [Apache ActiveMQ 5.9.x or later](http://activemq.apache.org/) then you already have jolokia enabled by default.\n\nIf a JVM has no jolokia agent, you can use the **Local** tab of the **Connect** menu (in 1.2.x or later of **hawtio-default.war**). The Local tab lists all local Java processes on the same machine (just like JConsole does).\n\nFor JVMs not running a jolokia agent already, there\'s a start button (on the right) which will dynamically add the [jolokia JVM agent](http://jolokia.org/agent/jvm.html) into the selected JVM process. You can then click on the Agent URL link to connect into it.\n\nNote that the Local plugin only works when the JVM running hawtio has the **hawtio-local-jvm-mbean** plugin installed (which depends on the JVM finding the com.sun.tools.attach.VirtualMachine API that jconsole uses and is included in the hawtio-default.war). BTW if you don\'t see a **Local** tab inside the **Conect** menu in your hawtio application; check the log of your hawtio JVM; there might be a warning around com.sun.tools.attach.VirtualMachine not being available on the classpath. Or you could just try using the [exectuable jar](http://hawt.io/getstarted/index.html) to run hawtio which seems to work on most platforms.\n\nNote also that the **Local** tab only works when the process is on the same machine as the JVM running hawtio. So a safer option is just to make sure there\'s a jolokia agent running in each JVM you want to manage with hawtio.\n\nThere are a [few different agents you can use](http://jolokia.org/agent.html):\n\n* [WAR agent](http://jolokia.org/agent/war.html) if you are using a servlet / EE container\n* [OSGi agent](http://jolokia.org/agent/osgi.html) if you are using OSGi (note that Jolokia is enabled by default in [Fuse](http://www.jboss.org/products/fuse) so you don\'t have to worry)\n* [JVM agent](http://jolokia.org/agent/jvm.html) if you are using a stand alone Java process\n\nSo once you\'ve got a jolokia agent in your JVM you can test it by accessing `http://host:port/jolokia` in a browser to see if you can view the JSON returned for the version information of the jolokia agent.\n\nAssuming you have jolokia working in your JVM, then you can use the **Remote** tab on the **Connect** menu in hawtio to connect; just enter the host, port, jolokia path and user/password. Note by default only `localhost` is accepted to connect for security, so you need to configure `hawtio.proxyWhitelist` system property or `proxyWhitelist` init parameter on `ProxyServlet` in `hawtio.war`\'s `WEB-INF/web.xml` to explicitly allow hosts that you are connecting to.\n\nAfter trying the above if you have problems connecting to your JVM, please [let us know](http://hawt.io/community/index.html) by [raising an issue](https://github.com/hawtio/hawtio/issues?state=open) and we\'ll try to help.\n\n#### How do I install a plugin?\n\nEach hawtio distro has these [browser based plugins](http://hawt.io/plugins/index.html) inside already; plus hawtio can discover any other external plugins deployed in the same JVM too.\n\nThen the hawtio UI updates itself in real time based on what it can find in the server side JVM it connects to. So, for example, if you connect to an empty tomcat/jetty you\'ll just see things like JMX and tomcat/jetty (and maybe wiki / dashboard / maven if you\'re using hawtio-default.war which has a few more server side plugins inside).\n\nThen if you deploy a WAR which has ActiveMQ or Camel inside it, you should see an ActiveMQ or Camel tab appear as you deploy code which registers mbeans for ActiveMQ or Camel.\n\nSo usually, if you are interested in a particular plugin and its not visible in the hawtio UI (after checking your preferences in case you disabled it), usually you just need to deploy or add a server side plugin; which is usually a case of deploying some Java code (e.g. ActiveMQ, Camel, Infinispan etc).\n\n#### What has changed lately?\n\nTry have a look at the [change log](http://hawt.io/changelog.html) to see the latest changes in hawtio!\n\n#### Where can I find more information?\n\nTry have a look at the [articles and demos](http://hawt.io/articles/index.html) to see what other folks are saying about hawtio.\n\n#### Why does hawtio log a bunch of 404s to the javascript console at startup?\n\nThe hawtio help registry tries to automatically discover help data for each registered plugin even if plugins haven\'t specifically registered a help file.\n\n#### Why does hawtio have its own wiki?\n\nAt first a git-based wiki might not seem terribly relevant to hawtio. A wiki can be useful to document running systems and link to the various consoles, operational tools and views. Though in addition to being used for documentation, hawtio\'s wiki also lets you view and edit any text file; such as Camel routes, Fuse Fabric profiles, Spring XML files, Drools rulebases, etc.\n\nFrom a hawtio perspective though its wiki pages can be HTML or Markdown and then be an AngularJS HTML partial. So it can include JavaScript widgets; or it can include [AngularJS directives](http://docs.angularjs.org/guide/directive).\n\nThis lets us use HTML and Markdown files to define custom views using HTML directives (custom tags) from any [hawtio plugins](http://hawt.io/plugins/index.html). Hopefully over time we can build a large library of HTML directives that folks can use inside HTML or Markdown files to show attribute values or charts from MBeans in real time, to show a panel from a dashboard, etc. Then folks can make their own mashups and happy pages showing just the information they want.\n\nSo another way to think of hawtio wiki pages is as a kind of plugin or a custom format of a dashboard page. Right now each dashboard page assumes a grid layout of rectangular widgets which you can add to and then move around. However with a wiki page you can choose to render whatever information & widgets you like in whatever layout you like. You have full control over the content and layout of the page!\n\nHere are some [sample](https://github.com/hawtio/hawtio/issues/103) [issues](https://github.com/hawtio/hawtio/issues/62) on this if you want to help!\n\nSo whether the hawtio wiki is used for documentation, to link to various hawtio and external resources, to create custom mashups or happy pages or to provide new plugin views--all the content of the wiki is audited, versioned and stored in git so it\'s easy to see who changed what, when and to roll back changes, etc.\n\n#### How to I install hawtio as web console for Apache ActiveMQ\n\nYou can use hawtio to remote manage any ActiveMQ brokers without the need to co-install hawtio together with the ActiveMQ broker. However you can also install hawtio with the broker if you want. Dejan Bosanac [blogged how to do this](http://sensatic.net/activemq/activemq-and-hawtio.html). \n\n\n### Problems/General Questions about using hawtio\n\nQuestions relating to errors you get while using hawtio or other general questions:\n\n#### How can I hide or move tabs to different perspectives?\n\nAn easy way is to use a plugin to reconfigure the default perspective definition.  Have a look at the [custom-perspective](https://github.com/hawtio/hawtio/tree/master/hawtio-plugin-examples/custom-perspective) for a plugin-based solution.\n\nFrom **hawtio 1.2.2** onwards you can reorder and hide plugins from the preference.\n\n\n#### Provider sun.tools.attach.WindowsAttachProvider could not be instantiated: java.lang.UnsatisfiedLinkError: no attach in java.library.path\n\nIf you see an error like this:\n\n    java.util.ServiceConfigurationError: com.sun.tools.attach.spi.AttachProvider: Provider sun.tools.attach.WindowsAttachProvider could not be instantiated: java.lang.UnsatisfiedLinkError: no attach in java.library.path\n\nwhen starting up or trying the **Connect/Local** tab then its probably related to [this issue](http://stackoverflow.com/questions/14027164/fix-the-java-lang-unsatisfiedlinkerror-no-attach-in-java-library-path) as was found on [#718](https://github.com/hawtio/hawtio/issues/718#issuecomment-27677738).\n\nBasically you need to make sure that you have JAVA_HOME/bin on your path. e.g. try this first before starting hawtio:\n\n    set path=%path%;%JAVA_HOME%\\jre\\bin\n\n#### The Terminal plugin in Karaf does not work\n\nThe terminal plugin may have trouble the first time in use, not being able to connect and show the terminal. Try selecting another plugin, and go back to the terminal plugin a bit later, and it then may be able to login. Also if the screen is all black, then pressing ENTER may help show the terminal.\n\n\n#### Why does the Camel Route Diagram not show counters\n\nIf you use Apache ServixeMix / Karaf and you deploy a Camel XML file by copying a xml file to the deploy directory, then the deployer does not run this with proper security. So the Karaf RBAC will deny the Apache Camel plugin to query the Camel routes to gather performance counters. As deploying by using plain XML files is not recommended, then it works by using a deployment unit as a proper OSGi bundle such as a JAR or KAR file.\n\n\n#### The tree keeps refreshing making the UI sluggish\n\nThe reason is that there is something running in the JVM that keeps modifying the JMX tree, such as repeativily adding/removing same set of MBeans. For example Apache ActiveMQ does that when a JMS Client has been mis configured or configured without a connection pool. Because of no connection pool, then ActiveMQ JMS client creates a new connection, uses and closes the connection, and repeat that. As a net result of that, the MBean tree keeps being modified, which causes Hawtio to trigger a tree refresh. To resolve this use connection pooling with ActiveMQ - which you should always do. For an example see [issue 1903](https://github.com/hawtio/hawtio/issues/1903) for more details and how to resolve that.\n\n\n### Plugin Questions\n\nQuestions on using the available plugins:\n\n#### What plugins are available?\n\nSee the list of [hawtio plugins](http://hawt.io/plugins/index.html)\n\n#### What is a plugin?\n\nSee [How Plugins Work](http://hawt.io/plugins/howPluginsWork.html)\n\n\n#### Why does the OSGi tab not appear on GlassFish?\n\nThis is a [reported issue](https://github.com/hawtio/hawtio/issues/158). It turns out that the standard OSGi MBeans (in the osgi.core domain) are not installed by default on GlassFish.\n\nThe workaround is to install the [Gemini Management bundle](http://www.eclipse.org/gemini/management/) then you should see the MBeans in the osgi.core domain in the JMX tree; then the OSGi tab should appear!\n\n\n### Camel Questions\n\nQuestions on using [Apache Camel](http://camel.apache.org/) and hawtio.\n\n#### The Camel plugin is not visible or does not show any Camels\n\nThe Camel plugin currently requires that the Camel MBeans are stored using the default domain name which is `org.apache.camel`. So if you configure Camel to use a different name, using the `mbeanObjectDomainName` configuration, then the Camel plugin will not work. See details reported in ticket [1712](https://github.com/hawtio/hawtio/issues/1712).\n\n#### Why does the Debug or Trace tab not appear for my Camel route?\n\nThe Debug and Trace tabs depend on the JMX MBeans provided by the Camel release you use.\n\n* the Debug tab requires at least version 2.12.x or later of your Camel library to be running\n* the Trace tab requires either a 2.12.x or later distro of Camel or a Fuse distro of Camel from about 2.8 or later\n\n\n### Developer Questions\n\nQuestions on writing new plugins or hacking on existing ones:\n\n#### How do I build the project?\n\nIf you just want to run hawtio in a JVM then please see the [Getting Started](http://hawt.io/getstarted/index.html) section.\n\nIf you want to hack the source code then check out [how to build hawtio](http://hawt.io/building/index.html).\n\n#### What code conventions do you have?\n\nCheck out the [Coding Conventions](https://github.com/hawtio/hawtio/blob/master/docs/CodingConventions.md) for our recommended approach.\n\n#### What can my new plugin do?\n\nAnything you like :). So long as it runs on a web browser, you\'re good to go. Please start [contributing](http://hawt.io/contributing/index.html)!\n\n#### Do I have to use TypeScript?\n\nYou can write hawtio plugins in anything that runs in a browser and ideally compiles to JavaScript. So use pure JavaScript,  CoffeeScript, EcmaScript6-transpiler, TypeScript, GWT, Kotlin, Ceylon, ClojureScript, ScalaJS and [any language that compiles to JavaScript](https://github.com/jashkenas/coffeescript/wiki/List-of-languages-that-compile-to-JS).\n\nSo take your pick; the person who creates a plugin can use whatever language they prefer, so please contribute a [new plugin](http://hawt.io/contributing/index.html) :).\n\nThe only real APIs a plugin needs to worry about are AngularJS (if you want to work in the core layout rather than just be an iframe), JSON (for some pretty trivial extension points such as adding new tabs), HTML and CSS.\n\n#### How can I add my new plugin?\n\nCheck out [how plugins work](http://hawt.io/plugins/index.html). You can then either:\n\n* Fork this project and submit your plugin by [creating a Github pull request](https://help.github.com/articles/creating-a-pull-request) then we\'ll include your plugin by default in the hawtio distribution.\n* Make your own WAR with your plugin added (by depending on the hawtio-web.war in your pom.xml)\n* Host your plugin at some canonical website (e.g. with Github pages) then [submit an issue](https://github.com/hawtio/hawtio/issues?state=open) to tell us about it and we can add it to the plugin registry JSON file.\n\n#### How can I reuse those awesome AngularJS directives in my application?\n\nWe hope that folks can just write plugins for hawtio to be able to reuse all the various [plugins](http://hawt.io/plugins/index.html) in hawtio.\n\nHowever if you are writing your own stand alone web application using AngularJS then please check out the [Hawtio Directives](http://hawt.io/directives/) which you should be able to reuse in any AngularJS application\n');}]); hawtioPluginLoader.addModule("hawtio-console-assembly-templates");
angular.module('hawtio-console-assembly-templates', []).run(['$templateCache', function($templateCache) {$templateCache.put('app/src/login/login-template.html','<span id="badge">\n  <img ng-src="{{$ctrl.branding.companyLogoUrl}}" alt="">\n</span>\n<div class="container">\n  <div class="row">\n    <div class="col-sm-12">\n      <div id="brand">\n        <img ng-src="{{$ctrl.branding.appLogoUrl}}" alt="{{$ctrl.branding.appName}}">\n        <span>{{$ctrl.branding.appType}}</span>\n      </div><!--/#brand-->\n      <div class="alert alert-danger" ng-if="$ctrl.wrongPassword">\n        <span class="pficon pficon-error-circle-o"></span>\n        Incorrect username or password\n      </div>\n    </div><!--/.col-*-->\n    <div class="col-sm-7 col-md-6 col-lg-5 login">\n      <form class="form-horizontal" role="form" ng-submit="$ctrl.doLogin()">\n        <div class="form-group">\n          <label for="username" class="col-sm-2 col-md-2 control-label">Username</label>\n          <div class="col-sm-10 col-md-10">\n            <input type="text" class="form-control" id="username" autocomplete="section-login username"\n                    ng-model="$ctrl.entity.username" tabindex="1" autofocus>\n          </div>\n        </div>\n        <div class="form-group">\n          <label for="password" class="col-sm-2 col-md-2 control-label">Password</label>\n          <div class="col-sm-10 col-md-10">\n            <input type="password" class="form-control" id="password" autocomplete="section-login current-password"\n                    ng-model="$ctrl.entity.password" tabindex="2">\n          </div>\n        </div>\n        <div class="form-group">\n          <div class="col-xs-12 col-sm-12 col-md-12 submit">\n            <button type="submit" class="btn btn-primary btn-lg" tabindex="4">Log In</button>\n          </div>\n        </div>\n      </form>\n    </div><!--/.col-*-->\n    <div class="col-sm-5 col-md-6 col-lg-7 details">\n    </div><!--/.col-*-->\n  </div><!--/.row-->\n</div><!--/.container-->\n');}]); hawtioPluginLoader.addModule("hawtio-console-assembly-templates");