/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot;

import io.hawt.HawtioContextListener;
import io.hawt.springboot.HawtioEndpoint;
import io.hawt.springboot.HawtioProperties;
import io.hawt.springboot.PluginService;
import io.hawt.web.auth.AuthenticationFilter;
import io.hawt.web.auth.LoginServlet;
import io.hawt.web.auth.LogoutServlet;
import io.hawt.web.auth.SessionExpiryFilter;
import io.hawt.web.auth.keycloak.KeycloakServlet;
import io.hawt.web.auth.keycloak.KeycloakUserServlet;
import io.hawt.web.filters.CORSFilter;
import io.hawt.web.filters.CacheHeadersFilter;
import io.hawt.web.filters.XFrameOptionsFilter;
import io.hawt.web.filters.XXSSProtectionFilter;
import io.hawt.web.proxy.ProxyServlet;
import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.autoconfigure.ManagementContextConfiguration;
import org.springframework.boot.actuate.autoconfigure.ManagementServerProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;

@ManagementContextConfiguration
@EnableConfigurationProperties(value={HawtioProperties.class})
@PropertySource(value={"classpath:/io/hawt/springboot/application.properties"})
public class HawtioConfiguration {
    @Autowired
    private HawtioProperties hawtioProperties;
    @Autowired
    private ManagementServerProperties managementProperties;

    @Bean
    public HawtioEndpoint hawtioEndpoint() {
        return new HawtioEndpoint();
    }

    @Bean
    public PluginService pluginService() {
        return new PluginService();
    }

    @Bean
    public FilterRegistrationBean sessionExpiryFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new SessionExpiryFilter());
        filter.addUrlPatterns(new String[]{"/hawtio/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean cacheFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new CacheHeadersFilter());
        filter.addUrlPatterns(new String[]{"/hawtio/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean CORSFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new CORSFilter());
        filter.addUrlPatterns(new String[]{"/hawtio/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean xframeOptionsFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new XFrameOptionsFilter());
        filter.addUrlPatterns(new String[]{"/hawtio/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean xxssProtectionFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new XXSSProtectionFilter());
        filter.addUrlPatterns(new String[]{"/hawtio/*"});
        return filter;
    }

    @Bean
    public FilterRegistrationBean authenticationFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new AuthenticationFilter());
        filter.addUrlPatterns(new String[]{"/hawtio/auth/*", "/jolokia/*"});
        return filter;
    }

    @Bean
    public ServletRegistrationBean jolokiaProxyServlet() {
        return new ServletRegistrationBean((Servlet)new ProxyServlet(), new String[]{"/hawtio/proxy/*"});
    }

    @Bean
    public ServletRegistrationBean userServlet() {
        return new ServletRegistrationBean((Servlet)new KeycloakUserServlet(), new String[]{"/user/*", "/hawtio/user/*"});
    }

    @Bean
    public ServletRegistrationBean loginServlet() {
        return new ServletRegistrationBean((Servlet)new LoginServlet(), new String[]{"/hawtio/auth/login/*"});
    }

    @Bean
    public ServletRegistrationBean logoutServlet() {
        return new ServletRegistrationBean((Servlet)new LogoutServlet(), new String[]{"/hawtio/auth/logout/*"});
    }

    @Bean
    public ServletRegistrationBean keycloakServlet() {
        return new ServletRegistrationBean((Servlet)new KeycloakServlet(), new String[]{"/hawtio/keycloak/*"});
    }

    @Bean
    public ServletListenerRegistrationBean hawtioContextListener() {
        return new ServletListenerRegistrationBean((EventListener)new HawtioContextListener());
    }
}

