/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot;

import io.hawt.HawtioContextListener;
import io.hawt.web.AuthenticationFilter;
import io.hawt.web.CORSFilter;
import io.hawt.web.CacheHeadersFilter;
import io.hawt.web.ContextFormatterServlet;
import io.hawt.web.ExportContextServlet;
import io.hawt.web.GitServlet;
import io.hawt.web.JavaDocServlet;
import io.hawt.web.LoginServlet;
import io.hawt.web.LogoutServlet;
import io.hawt.web.ProxyServlet;
import io.hawt.web.RedirectFilter;
import io.hawt.web.SessionExpiryFilter;
import io.hawt.web.UploadServlet;
import io.hawt.web.UserServlet;
import io.hawt.web.XFrameOptionsFilter;
import io.hawt.web.keycloak.KeycloakServlet;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.commons.fileupload.servlet.FileCleanerCleanup;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
public class HawtioConfiguration
extends WebMvcConfigurerAdapter {
    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/hawtio/plugins/**"}).addResourceLocations(new String[]{"/app/", "classpath:/static/hawtio/app/"});
        registry.addResourceHandler(new String[]{"/hawtio/**"}).addResourceLocations(new String[]{"/", "/app/", "classpath:/static/hawtio/", "classpath:/static/hawtio/app/"});
        registry.addResourceHandler(new String[]{"/img/**"}).addResourceLocations(new String[]{"classpath:/static/hawtio/img/"});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addViewController("/hawtio/plugin").setViewName("forward:/plugin");
        registry.addViewController("/hawtio/").setViewName("redirect:/hawtio/index.html");
    }

    @Bean
    public ServletRegistrationBean userServlet() {
        return new ServletRegistrationBean((Servlet)new UserServlet(), new String[]{"/user/*", "/hawtio/user/*"});
    }

    @Bean
    public ServletRegistrationBean jolokiaproxy() {
        return new ServletRegistrationBean((Servlet)new ProxyServlet(), new String[]{"/hawtio/proxy/*"});
    }

    @Bean
    public ServletRegistrationBean fileupload() {
        return new ServletRegistrationBean((Servlet)new UploadServlet(), new String[]{"/hawtio/file-upload/*"});
    }

    @Bean
    public ServletRegistrationBean loginservlet() {
        return new ServletRegistrationBean((Servlet)new LoginServlet(), new String[]{"/hawtio/auth/login/*"});
    }

    @Bean
    public ServletRegistrationBean logoutservlet() {
        return new ServletRegistrationBean((Servlet)new LogoutServlet(), new String[]{"/hawtio/auth/logout/*"});
    }

    @Bean
    public ServletRegistrationBean keycloakservlet() {
        return new ServletRegistrationBean((Servlet)new KeycloakServlet(), new String[]{"/hawtio/keycloak/*"});
    }

    @Bean
    public ServletRegistrationBean exportcontextservlet() {
        return new ServletRegistrationBean((Servlet)new ExportContextServlet(), new String[]{"/hawtio/exportContext/*"});
    }

    @Bean
    public ServletRegistrationBean mavenSource() {
        return new ServletRegistrationBean((Servlet)new JavaDocServlet(), new String[]{"/hawtio/javadoc/*"});
    }

    @Bean
    public ServletRegistrationBean contextFormatter() {
        return new ServletRegistrationBean((Servlet)new ContextFormatterServlet(), new String[]{"/hawtio/contextFormatter/*"});
    }

    @Bean
    public ServletRegistrationBean gitServlet() {
        return new ServletRegistrationBean((Servlet)new GitServlet(), new String[]{"/hawtio/git/*"});
    }

    @Bean
    public ServletListenerRegistrationBean hawtioContextListener() {
        return new ServletListenerRegistrationBean((EventListener)new HawtioContextListener());
    }

    @Bean
    public ServletListenerRegistrationBean fileCleanerCleanup() {
        return new ServletListenerRegistrationBean((EventListener)new FileCleanerCleanup());
    }

    @Bean
    public FilterRegistrationBean redirectFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new RedirectFilter());
        filter.setUrlPatterns(Collections.singletonList("/hawtio/*"));
        return filter;
    }

    @Bean
    public FilterRegistrationBean sessionExpiryFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new SessionExpiryFilter());
        filter.setUrlPatterns(Collections.singletonList("/hawtio/*"));
        return filter;
    }

    @Bean
    public FilterRegistrationBean cacheFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new CacheHeadersFilter());
        filter.setUrlPatterns(Collections.singletonList("/hawtio/*"));
        return filter;
    }

    @Bean
    public FilterRegistrationBean CORSFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new CORSFilter());
        filter.setUrlPatterns(Collections.singletonList("/hawtio/*"));
        return filter;
    }

    @Bean
    public FilterRegistrationBean XFrameOptionsFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new XFrameOptionsFilter());
        filter.setUrlPatterns(Collections.singletonList("/hawtio/*"));
        return filter;
    }

    @Bean
    public FilterRegistrationBean AuthenticationFilter() {
        FilterRegistrationBean filter = new FilterRegistrationBean();
        filter.setFilter((Filter)new AuthenticationFilter());
        filter.setUrlPatterns(Arrays.asList("/hawtio/auth/*", "/jolokia/*", "/hawtio/upload/*", "/hawtio/javadoc/*"));
        return filter;
    }
}

