# Demos (2.x)

<table class="table table-striped">
<tr>
<th>Demo</th><th>Source</th><th>Description</th>
</tr>
<tr>
<td><a href="http://dashboard.hawt.io/">dashboard.hawt.io</a></td>
<td><a href="https://github.com/hawtio/hawtio-dashboard">hawtio-dashboard</a></td>
<td>Provides a dashboard capability; letting any angular pages be composed into a dashboard</td>
</tr>
<tr>
<td><a href="http://forms.hawt.io/">forms.hawt.io</a></td>
<td><a href="https://github.com/hawtio/hawtio-forms">hawtio-forms</a></td>
<td>The forms plugin from hawtio 1.x, used to create forms from a simple schema</td>
</tr>
<tr>
<td><a href="http://ui.hawt.io/">ui.hawt.io</a></td>
<td><a href="https://github.com/hawtio/hawtio-ui">hawtio-ui</a></td>
<td>The UI widgets from hawtio 1.x, including hawtio-simple-table and the editor plugin</td>
</tr>
</table>

# Videos (2.x)

The following videos are in the [hawtio video album](https://vimeo.com/album/3324251):

* [create a hawtio pluing in 3 minutes](https://vimeo.com/123423650)
* [add hawtio forms to your plugin](https://vimeo.com/123441243) using [hawtio-forms](https://github.com/hawtio/hawtio-forms)

# Demos (1.x)

* <a href="https://vimeo.com/album/2635012" title="a library of demo videos using hawtio with JBoss Fuse">various demos of using hawtio, ActiveMQ and Camel inside JBoss Fuse</a> by [James Strachan](http://macstrac.blogspot.co.uk/). JBoss Fuse 6.1 or later uses hawtio for its management console; so all these demos are really hawtio demos (in terms of the console).
* <a href="http://vimeo.com/80625940" title="Demo of Fuse 6.1 with Apache Camel and hawtio on OpenShift">Demo of Fuse 6.1 with Apache Camel and hawtio on OpenShift</a> by [James Strachan](http://macstrac.blogspot.co.uk/) showing how to get started using <a href="http://www.jboss.org/products/fuse">JBoss Fuse</a> 6.1 Early Access release on OpenShift for creating integration solutions based on Apache Camel in the hybrid cloud (via <a href="https://www.openshift.com/products/online">OpenShift Online</a> for the public cloud or <a href="https://www.openshift.com/products/enterprise">OpenShift Enterprise</a> for on premise, or a combination of both).
* <a href="https://vimeo.com/68442425" title="see a demo of provisioning Fuse containers, viewing, editing, debugging and provisioning Camel routes using Fuse Fabric with the hawtio console">CamelOne keynote 2013</a> by [James Strachan](http://macstrac.blogspot.co.uk/) showing the create, view, edit debug and provision of Camel routes using Fuse Fabric with the hawtio
* <a href="https://www.youtube.com/watch?v=sL6tlEv-mxQ">demo of FMC and hawtio with Fuse Fabric</a>

## Videos on hawtio

The following videos has been found on the web about hawtio.  If you find any others please [let us know](http://hawt.io/community/index.html) or [raise an issue](https://github.com/hawtio/hawtio/issues?state=open) and we'll add it to the list.

* [hawtio - the Extensive console](https://www.youtube.com/watch?v=Bxgk9--_WzE) by Stan Lewis, at [DevNation 2014](http://www.devnation.org/) presenting how you can extend and build your own plugins to hawtio. Highly recommended if you want to build custom plugins.
* Hawtio on Talend ESB part [1](https://www.youtube.com/watch?v=lzdgxcHwfcY), [2](https://www.youtube.com/watch?v=_vjp8rg1DNQ), [3](https://www.youtube.com/watch?v=uJqG2JbXfkM) by [Robin Huiser](http://nl.linkedin.com/in/robinhuiser)

## Articles on using hawtio

The following articles have been found on the web about hawtio. If you find any others please [let us know](http://hawt.io/community/index.html) or [raise an issue](https://github.com/hawtio/hawtio/issues?state=open) and we'll add it to the list.

* [Hawtio + ActiveMQ](http://www.christianposta.com/blog/?p=315) by [Christian Posta](http://www.christianposta.com/)
* [Hawtio & Apache Jclouds](http://iocanel.blogspot.co.uk/2013/07/hawtio-apache-jclouds.html) by [Ioannis Canellos](http://iocanel.blogspot.co.uk/)
* [Apache Camel web dashboard with hawtio](http://www.davsclaus.com/2013/04/apache-camel-web-dashboard-with-hawtio.html) by [Claus Ibsen](http://www.davsclaus.com)
* [introducing the Apache Camel based open source iPaaS](http://macstrac.blogspot.co.uk/2013/06/introducing-apache-camel-based-open.html) by [James Strachan](http://macstrac.blogspot.co.uk/)
* [Monitoring Camel Application](http://bushorn.com/monitoring-camel-application/) by [Gnanaguru](http://bushorn.com/author/gnanagurus/)
* [Hawtio, la console web polyvalente](http://blog.zenika.com/index.php?post/2014/01/07/HawtIO-la-console-web-polyvalente) by Gérald Quintana (in French) with a great overview of hawtio (note: Google can translate the page into readable english)
* [Hawtio, écrire un plugin](http://blog.zenika.com/index.php?post/2014/01/14/HawtIO-ecrire-un-plugin) by Gérald Quintana (in French) the second part on writing a plugin (note: Google can translate the page into readable english)
* [Hawtio authentication with LDAP](http://jcordes73.blogspot.de/2014/03/hawtio-authentication-with-ldap-on.html) by Jochen Cordes with a blog series how to use LDAP authentication with hawtio running on Tomcat 7, JBoss Fuse, and JBoss EAP.
* [Installing hawtio as web console for ActiveMQ](http://sensatic.net/activemq/activemq-and-hawtio.html) by Dejan Bosanac shows how to install hawtio as the web console in Apache ActiveMQ. Dejan also demonstrates how you can remote connect from hawtio to any ActiveMQ broker.
* [HawtIO on JBoss Wildfly 8.1 -- step by step](http://www.christianposta.com/blog/?p=403) by [Christian Posta](http://www.christianposta.com/) How to get HawtIO running and secured on JBoss Wildfly Application Server 8.1
* [HawtIO on OpenShift](http://jimmidyson.github.io/hawtio-on-OpenShift/) by Jimmi Dyson, how to run Apache Tomcat on OpenShift Online and install hawtio into the Tomcat.
* [Hawtio on JBoss EAP 6](http://jcordes73.blogspot.de/2014/12/deploying-hawtio-on-jboss-eap-6.html) by Jochen Cordes how to deploy Hawtio on JBoss EAP 6

## Developer articles

* [Creating a directive in hawtio](http://www.wayofquality.de/open%20source/hawtio/creating-a-hwatio-directive/) by [Andreas Gies](http://www.wayofquality.de/index.php/blog)
* [Using a data factory to encapsulate backend data in hawtio](http://www.wayofquality.de/open%20source/hawtio/using-a-datafactory-in-hawtio/) by [Andreas Gies](http://www.wayofquality.de/index.php/blog)
