/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.springboot.security;

import io.hawt.web.auth.AuthenticationConfiguration;
import io.hawt.web.auth.RolePrincipal;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Principal;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.spi.LoginModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class HawtioSpringSecurityLoginModule
implements LoginModule {
    public static final Logger LOG = LoggerFactory.getLogger(HawtioSpringSecurityLoginModule.class);
    private Subject subject;
    private Class<? extends Principal> roleClass;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        AuthenticationConfiguration authConfig = (AuthenticationConfiguration)options.get(AuthenticationConfiguration.class.getName());
        if (authConfig != null) {
            this.roleClass = authConfig.getDefaultRolePrincipalClass();
        }
        if (this.roleClass == null) {
            this.roleClass = RolePrincipal.class;
        }
    }

    @Override
    public boolean login() {
        return true;
    }

    @Override
    public boolean commit() {
        for (Principal principal : this.subject.getPrincipals()) {
            if (!(principal instanceof Authentication)) continue;
            Authentication auth = (Authentication)principal;
            for (GrantedAuthority ga : auth.getAuthorities()) {
                String role = ga.getAuthority();
                if (role.startsWith("ROLE_")) {
                    role = role.substring(5);
                }
                try {
                    Constructor<? extends Principal> ctor = this.roleClass.getConstructor(String.class);
                    this.subject.getPrincipals().add(ctor.newInstance(role));
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    LOG.warn("Problem creating principal instance of class {} for role {}", new Object[]{this.roleClass, role, e});
                }
            }
        }
        return true;
    }

    @Override
    public boolean abort() {
        return false;
    }

    @Override
    public boolean logout() {
        return this.subject.getPrincipals().removeIf(principal -> principal.getClass() == this.roleClass);
    }
}

