/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.embedded;

import io.hawt.embedded.HawtioDefaultLocator;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Arrays;
import java.util.concurrent.Callable;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(versionProvider=ManifestVersionProvider.class, name="hawtio", description={"Run Hawtio"})
public class Main
implements Callable<Integer> {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    private static CommandLine commandLine;
    @CommandLine.Option(names={"--war-location", "-l"}, description={"Directory to search for .war files."})
    String warLocation;
    @CommandLine.Option(names={"--war", "-w"}, description={"War file or directory of the hawtio web application."})
    String war;
    @CommandLine.Option(names={"--context-path", "-c"}, description={"Context path."}, defaultValue="/hawtio")
    String contextPath = "/hawtio";
    @CommandLine.Option(names={"--plugins-dir", "-d"}, description={"Directory to search for .war files to install as 3rd party plugins."}, defaultValue="plugins")
    String plugins = "plugins";
    @CommandLine.Option(names={"--host", "-H"}, description={"Hostname to listen to."}, defaultValue="0.0.0.0")
    String host = "0.0.0.0";
    @CommandLine.Option(names={"--port", "-p"}, description={"Port number."}, defaultValue="8080")
    Integer port = 8080;
    @CommandLine.Option(names={"--extra-class-path", "-e"}, description={"Extra class path."})
    String extraClassPath;
    @CommandLine.Option(names={"--join", "-j"}, description={"Join server thread."}, defaultValue="true")
    boolean jointServerThread;
    @CommandLine.Option(names={"--open-url", "-o"}, description={"Open the web console automatic in the web browser."}, defaultValue="true")
    boolean openUrl;
    @CommandLine.Option(names={"--key-store", "-k"}, description={"JKS keyStore with the keys for https."})
    String keyStore;
    @CommandLine.Option(names={"--key-store-pass", "-s"}, description={"Password for the JKS keyStore with the keys for https."})
    String keyStorePass;
    @CommandLine.Option(names={"--version", "-V"}, versionHelp=true, description={"Print Hawtio version"})
    boolean versionRequested;
    @CommandLine.Option(names={"--help", "-h"}, usageHelp=true, description={"Print usage help and exit."})
    boolean usageHelpRequested;
    private boolean welcome = true;

    public static void run(String ... args) {
        Main main = new Main();
        commandLine = new CommandLine((Object)main);
        int exitCode = commandLine.execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() throws Exception {
        String val = System.getProperty("hawtio.authenticationEnabled");
        if (val == null) {
            System.setProperty("hawtio.authenticationEnabled", "false");
        }
        if (this.war == null && this.warLocation == null) {
            HawtioDefaultLocator.setWar(this);
        }
        this.run();
        return 0;
    }

    public static void main(String[] args) {
        Main main = new Main();
        Main.doRun(main);
    }

    public static void doRun(Main main) {
        try {
            main.run();
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
            e.printStackTrace();
        }
    }

    public String run() throws Exception {
        return this.run(this.jointServerThread);
    }

    public String run(boolean join) throws Exception {
        Server server = new Server(new InetSocketAddress(InetAddress.getByName(this.host), (int)this.port));
        HandlerCollection handlers = new HandlerCollection();
        handlers.setServer(server);
        server.setHandler((Handler)handlers);
        String scheme = this.resolveScheme(server);
        WebAppContext webapp = this.createHawtioWebapp(server, scheme);
        String homeDir = System.getProperty("user.home", ".") + "/.hawtio";
        String tempDirPath = homeDir + "/tmp";
        File tempDir = new File(tempDirPath);
        tempDir.mkdirs();
        log.info("Using temp directory for jetty: {}", (Object)tempDir.getPath());
        webapp.setTempDirectory(tempDir);
        this.findThirdPartyPlugins(log, handlers, tempDir);
        handlers.addHandler((Handler)webapp);
        if (this.welcome) {
            System.out.println("Embedded Hawtio: You can use --help to show usage");
        }
        System.out.println("About to start Hawtio " + webapp.getWar());
        server.start();
        String url = String.format("%s://%s:%s%s", scheme, this.host, this.port, this.contextPath);
        if (this.welcome) {
            System.out.println();
            System.out.println("Welcome to Hawtio");
            System.out.println("=====================================================");
            System.out.println();
            System.out.println(url);
            System.out.println();
        }
        if (this.openUrl && Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().browse(new URI(url));
            }
            catch (Exception e) {
                System.err.printf("Failed to open browser session, to access hawtio visit \"%s\"%n", url);
            }
        }
        if (join) {
            if (this.welcome) {
                System.out.println("Joining the Jetty server thread");
            }
            server.join();
        }
        return url;
    }

    private WebAppContext createHawtioWebapp(Server server, String scheme) throws IOException {
        WebAppContext webapp = new WebAppContext();
        webapp.setServer(server);
        webapp.setContextPath(this.contextPath);
        String foundWar = this.findWar(this.warLocation);
        if (foundWar == null) {
            foundWar = this.war;
        }
        if (foundWar == null) {
            throw new IllegalArgumentException("No war or warLocation options set!");
        }
        webapp.setWar(foundWar);
        webapp.setParentLoaderPriority(true);
        webapp.setLogUrlOnStart(true);
        webapp.setInitParameter("scheme", scheme);
        webapp.setExtraClasspath(this.extraClassPath);
        return webapp;
    }

    private String resolveScheme(Server server) {
        String sysScheme;
        String scheme = "http";
        if (null != this.keyStore) {
            System.out.println("Configuring SSL");
            SslContextFactory.Server sslcontf = new SslContextFactory.Server();
            HttpConfiguration httpconf = new HttpConfiguration();
            sslcontf.setKeyStorePath(this.keyStore);
            if (null != this.keyStorePass) {
                sslcontf.setKeyStorePassword(this.keyStorePass);
            } else {
                System.out.println("Attempting to open keystore with no password...");
            }
            try (ServerConnector sslconn = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslcontf, "http/1.1"), new HttpConnectionFactory(httpconf)});){
                sslconn.setPort(this.port.intValue());
                server.setConnectors(new Connector[]{sslconn});
            }
            scheme = "https";
        }
        if (null == (sysScheme = System.getProperty("hawtio.redirect.scheme"))) {
            System.out.println("Implicitly setting Scheme = " + scheme);
            System.setProperty("hawtio.redirect.scheme", scheme);
        } else {
            System.out.println("Scheme Was Set Explicitly To = " + scheme);
            scheme = sysScheme;
        }
        return scheme;
    }

    protected void findThirdPartyPlugins(Logger log, HandlerCollection handlers, File tempDir) {
        File dir = new File(this.plugins);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        log.info("Scanning for 3rd party plugins in directory: {}", (Object)dir.getPath());
        File[] wars = dir.listFiles((d, name) -> this.isWarFileName(name));
        if (wars == null) {
            return;
        }
        Arrays.stream(wars).forEach(war -> this.deployPlugin((File)war, log, handlers, tempDir));
    }

    private void deployPlugin(File war, Logger log, HandlerCollection handlers, File tempDir) {
        String contextPath = this.resolveContextPath(war);
        WebAppContext plugin = new WebAppContext();
        plugin.setServer(handlers.getServer());
        plugin.setContextPath(contextPath);
        plugin.setWar(war.getAbsolutePath());
        plugin.setLogUrlOnStart(true);
        File pluginTempDir = new File(tempDir, war.getName());
        pluginTempDir.mkdirs();
        plugin.setTempDirectory(pluginTempDir);
        plugin.setThrowUnavailableOnStartupException(true);
        handlers.addHandler((Handler)plugin);
        log.info("Added 3rd party plugin with context-path: {}", (Object)contextPath);
        System.out.println("Added 3rd party plugin with context-path: " + contextPath);
    }

    private String resolveContextPath(File war) {
        Object contextPath = "/" + war.getName();
        if (((String)contextPath).endsWith(".war")) {
            contextPath = ((String)contextPath).substring(0, ((String)contextPath).length() - 4);
        }
        if (((String)contextPath).equals(this.contextPath)) {
            throw new IllegalArgumentException("3rd party plugin " + war.getName() + " cannot have same name as Hawtio context path. Rename the plugin file to avoid the clash.");
        }
        return contextPath;
    }

    protected String findWar(String ... paths) {
        if (paths != null) {
            for (String path : paths) {
                File[] wars;
                String name2;
                File file;
                if (path == null || !(file = new File(path)).exists()) continue;
                if (file.isFile() && this.isWarFileName(name2 = file.getName())) {
                    return file.getPath();
                }
                if (!file.isDirectory() || (wars = file.listFiles((dir, name) -> this.isWarFileName(name))) == null || wars.length <= 0) continue;
                return wars[0].getPath();
            }
        }
        return null;
    }

    protected boolean isWarFileName(String name) {
        return name.toLowerCase().endsWith(".war");
    }

    public void showWelcome(boolean welcome) {
        this.welcome = welcome;
    }

    public void setWarLocation(String warLocation) {
        this.warLocation = warLocation;
    }

    public void setWar(String war) {
        this.war = war;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setPlugins(String plugins) {
        this.plugins = plugins;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setExtraClassPath(String extraClassPath) {
        this.extraClassPath = extraClassPath;
    }

    public void setJointServerThread(boolean jointServerThread) {
        this.jointServerThread = jointServerThread;
    }

    public void setOpenUrl(boolean openUrl) {
        this.openUrl = openUrl;
    }

    public void setKeyStore(String keyStore) {
        this.keyStore = keyStore;
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    static class ManifestVersionProvider
    implements CommandLine.IVersionProvider {
        ManifestVersionProvider() {
        }

        public String[] getVersion() throws Exception {
            String[] result = new String[]{Main.class.getPackage().getImplementationVersion()};
            return result;
        }
    }
}

