/*
 * Decompiled with CFR 0.152.
 */
package io.hawt.embedded;

import io.hawt.embedded.Options;
import java.io.File;
import java.io.FilenameFilter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.log.Slf4jLog;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.webapp.WebAppContext;

public class Main {
    private Options options = new Options();
    private boolean welcome = true;

    public Main() {
        this.options.init();
    }

    public static void main(String[] args) {
        Main main = new Main();
        if (!main.parseArguments(args) || main.isHelp()) {
            main.showOptions();
            return;
        }
        Main.doRun(main);
    }

    public boolean parseArguments(String[] args) {
        return this.options.parseArguments(args);
    }

    public void showOptions() {
        this.options.showOptions();
    }

    public static void doRun(Main main) {
        try {
            main.run();
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
            e.printStackTrace();
        }
    }

    public void run() throws Exception {
        this.run(this.options.isJointServerThread());
    }

    public void run(boolean join) throws Exception {
        String sysScheme;
        System.setProperty("org.eclipse.jetty.util.log.class", Slf4jLog.class.getName());
        Slf4jLog log = new Slf4jLog("jetty");
        Log.setLog((Logger)log);
        Server server = new Server(new InetSocketAddress(InetAddress.getByName(this.options.getHost()), (int)this.options.getPort()));
        HandlerCollection handlers = new HandlerCollection();
        handlers.setServer(server);
        server.setHandler((Handler)handlers);
        String scheme = "http";
        if (null != this.options.getKeyStore()) {
            System.out.println("Configuring SSL");
            SslContextFactory sslcontf = new SslContextFactory();
            HttpConfiguration httpconf = new HttpConfiguration();
            sslcontf.setKeyStorePath(this.options.getKeyStore());
            if (null != this.options.getKeyStorePass()) {
                sslcontf.setKeyStorePassword(this.options.getKeyStorePass());
            } else {
                System.out.println("Attempting to open keystore with no password...");
            }
            try (ServerConnector sslconn = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslcontf, "http/1.1"), new HttpConnectionFactory(httpconf)});){
                sslconn.setPort(this.options.getPort().intValue());
                server.setConnectors(new Connector[]{sslconn});
            }
            scheme = "https";
        }
        if (null == (sysScheme = System.getProperty("hawtio.redirect.scheme"))) {
            System.out.println("Implicitly setting Scheme = " + scheme);
            System.setProperty("hawtio.redirect.scheme", scheme);
        } else {
            System.out.println("Scheme Was Set Explicitly To = " + scheme);
            scheme = sysScheme;
        }
        WebAppContext webapp = new WebAppContext();
        webapp.setServer(server);
        webapp.setContextPath(this.options.getContextPath());
        String war = this.findWar(this.options.getWarLocation());
        if (war == null) {
            war = this.options.getWar();
        }
        if (war == null) {
            throw new IllegalArgumentException("No war or warLocation options set!");
        }
        webapp.setWar(war);
        webapp.setParentLoaderPriority(true);
        webapp.setLogUrlOnStart(true);
        webapp.setInitParameter("scheme", scheme);
        webapp.setExtraClasspath(this.options.getExtraClassPath());
        String homeDir = System.getProperty("user.home", ".") + "/.hawtio";
        String tempDirPath = homeDir + "/tmp";
        File tempDir = new File(tempDirPath);
        tempDir.mkdirs();
        log.info("using temp directory for jetty: " + tempDir.getPath(), new Object[0]);
        webapp.setTempDirectory(tempDir);
        this.findThirdPartyPlugins(log, handlers, tempDir);
        handlers.addHandler((Handler)webapp);
        if (this.welcome) {
            System.out.println("Embedded Hawtio: You can use --help to show usage");
            System.out.println(this.options.usedOptionsSummary());
        }
        System.out.println("About to start Hawtio " + war);
        server.start();
        if (this.welcome) {
            System.out.println();
            System.out.println("Welcome to Hawtio");
            System.out.println("=====================================================");
            System.out.println();
            System.out.println(scheme + "://localhost:" + this.options.getPort() + this.options.getContextPath());
            System.out.println();
        }
        if (join) {
            if (this.welcome) {
                System.out.println("Joining the Jetty server thread");
            }
            server.join();
        }
    }

    protected void findThirdPartyPlugins(Slf4jLog log, HandlerCollection handlers, File tempDir) {
        File dir = new File(this.options.getPlugins());
        if (dir.exists() && dir.isDirectory()) {
            log.info("Scanning for 3rd party plugins in directory: " + dir.getName(), new Object[0]);
            File[] wars = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return Main.this.isWarFileName(name);
                }
            });
            if (wars != null) {
                for (File war : wars) {
                    String contextPath = "/" + war.getName();
                    if (contextPath.endsWith(".war")) {
                        contextPath = contextPath.substring(0, contextPath.length() - 4);
                    }
                    if (contextPath.equals(this.options.getContextPath())) {
                        throw new IllegalArgumentException("3rd party plugin " + war.getName() + " cannot have same name as Hawtio context path. Rename the plugin file to avoid the clash.");
                    }
                    WebAppContext plugin = new WebAppContext();
                    plugin.setServer(handlers.getServer());
                    plugin.setContextPath(contextPath);
                    plugin.setWar(war.getAbsolutePath());
                    plugin.setLogUrlOnStart(true);
                    File pluginTempDir = new File(tempDir, war.getName());
                    pluginTempDir.mkdirs();
                    plugin.setTempDirectory(pluginTempDir);
                    plugin.setThrowUnavailableOnStartupException(true);
                    try {
                        plugin.start();
                        handlers.addHandler((Handler)plugin);
                        log.info("Added 3rd party plugin with context-path: " + contextPath, new Object[0]);
                        System.out.println("Added 3rd party plugin with context-path: " + contextPath);
                    }
                    catch (Exception e) {
                        log.warn("Failed to add and start 3rd party plugin with context-path: " + contextPath + " due " + e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    protected String findWar(String ... paths) {
        if (paths != null) {
            for (String path : paths) {
                File[] wars;
                String name2;
                File file;
                if (path == null || !(file = new File(path)).exists()) continue;
                if (file.isFile() && this.isWarFileName(name2 = file.getName())) {
                    return file.getPath();
                }
                if (!file.isDirectory() || (wars = file.listFiles((dir, name) -> this.isWarFileName(name))) == null || wars.length <= 0) continue;
                return wars[0].getPath();
            }
        }
        return null;
    }

    protected boolean isWarFileName(String name) {
        return name.toLowerCase().endsWith(".war");
    }

    public String getWarLocation() {
        return this.options.getWarLocation();
    }

    public void setWarLocation(String warLocation) {
        this.options.setWarLocation(warLocation);
    }

    public String getWar() {
        return this.options.getWar();
    }

    public void setWar(String war) {
        this.options.setWar(war);
    }

    public String getContextPath() {
        return this.options.getContextPath();
    }

    public void setContextPath(String contextPath) {
        this.options.setContextPath(contextPath);
    }

    public Integer getPort() {
        return this.options.getPort();
    }

    public void setPort(Integer port) {
        this.options.setPort(port);
    }

    public String getExtraClassPath() {
        return this.options.getExtraClassPath();
    }

    public void setExtraClassPath(String extraClassPath) {
        this.options.setExtraClassPath(extraClassPath);
    }

    public boolean isJoinServerThread() {
        return this.options.isJointServerThread();
    }

    public void setJoinServerThread(boolean joinServerThread) {
        this.options.setJointServerThread(joinServerThread);
    }

    public boolean isOpenUrl() {
        return this.options.isOpenUrl();
    }

    public void setOpenUrl(boolean openUrl) {
        this.options.setOpenUrl(openUrl);
    }

    public boolean isHelp() {
        return this.options.isHelp();
    }

    public void showWelcome(boolean welcome) {
        this.welcome = welcome;
    }
}

